<?php

header("Content-Type:text/html; charset=utf-8");

$json = file_get_contents('php://input');
$post = json_decode($json, true);
define("CTL", 'ctl');
define("ACT", 'act');
if (!defined('APP_ROOT_PATH'))
    define('APP_ROOT_PATH', str_replace('bogo_imcallback.php', '', str_replace('\\', '/', __FILE__)));
require APP_ROOT_PATH . 'public/directory_init.php';
require APP_ROOT_PATH . 'license.php';
require APP_ROOT_PATH . 'system/define.php';
require APP_ROOT_PATH . "system/cache/Rediscache/Rediscache.php";
require_once APP_ROOT_PATH . 'vendor/autoload.php';
require_once APP_ROOT_PATH . 'system/common.php';

add_file_log("\n ================post：" . json_encode($post) . "================\n", "imcallback");

if ($post['CallbackCommand'] == 'Group.CallbackAfterNewMemberJoin') {

    define("BOGO_REQUIRE", true);
    //require './system/system_init.php';
    require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
    $video_viewer_obj = new VideoViewerRedisService();

    $video_viewer_obj->member_join($post);//会员进直播间

} else if ($post['CallbackCommand'] == 'Group.CallbackAfterMemberExit') {

    define("BOGO_REQUIRE", true);
    //require './system/system_init.php';
    require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
    $video_viewer_obj = new VideoViewerRedisService();

    $video_viewer_obj->member_exit($post, 1);   //会员离开

} else if ($post['CallbackCommand'] == 'Group.CallbackBeforeSendMsg') { //聊天之前的回调
    $From_Account = $post['From_Account'];
    if (!$From_Account) {
        $data['ErrorCode'] = 1;
    } else {
        $data['ErrorCode'] = 0;
    }

} else if ($post['CallbackCommand'] == 'C2C.CallbackBeforeSendMsg') { //聊天之前的回调
    $From_Account = $post['From_Account'];
    if (!$From_Account) {
        $data['ErrorCode'] = 1;
    } else {
        $data['ErrorCode'] = 0;
    }

    $To_Account = $post['To_Account'];

    add_file_log("\n ================to_user1================\n", "imcallback");
    define("BOGO_REQUIRE", true);
    require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
    $video_viewer_obj = new VideoViewerRedisService();


    $key = "Prohibited_account_" . $To_Account;
    $is_Prohibited_account = $video_viewer_obj->get_redis_one($key);

    add_file_log("\n  to_user：" . $is_Prohibited_account . "\n", "imcallback");

    if ($is_Prohibited_account) {
        // 您的账号已被拉黑。其他用户给他发消息
        $data['ActionStatus'] = 'FAIL';
        $data['ErrorInfo'] = 'Your account has been hacked. Other users send him messages';
        echo json_encode($data);
        exit;
    }
    $msg_body = $post['MsgBody'];
    if ($post['From_Account']) {
        if ($msg_body) {
            if (isset($msg_body[0]['MsgType'])) {

                if ($msg_body[0]['MsgType'] == 'TIMTextElem' || $msg_body[0]['MsgType'] == 'TIMImageElem' || $msg_body[0]['MsgType'] == 'TIMCustomElem' || $msg_body[0]['MsgType'] == 'TIMSoundElem') {
                    $is_add = true;
                    $content = "";
                    if ($msg_body[0]['MsgType'] == 'TIMTextElem') {
                        $type = 1;
                        $content = $msg_body[0]['MsgContent']['Text'];
                    } elseif ($msg_body[0]['MsgType'] == 'TIMImageElem') {
                        $type = 2;
                        $content = $msg_body[0]['MsgContent']['ImageInfoArray'][0]['URL'];
                    } elseif ($msg_body[0]['MsgType'] == 'TIMSoundElem') {
                        $type = 3;
                        $content = $msg_body[0]['MsgContent']['Url'];
                    } else {
                        $type = 1;
                        $data = $msg_body[0]['MsgContent']['Data'];
                        $data = json_decode($data, true);

                        if (isset($data['text'])) {
                            $content = $data['text'];
                        } else {
                            $is_add = false;
                        }
                    }
                    if ($is_add) {
                        $chat_log_array = [
                            'user_id'     => $post['From_Account'],
                            'to_user_id'  => $post['To_Account'],
                            'type'        => $type,
                            'content'     => $content,
                            'create_time' => NOW_TIME,
                            'format_time' => date('Y-m-d H:i:s', NOW_TIME),
                            'msg_key'     => $post['MsgKey']
                        ];
                        require(APP_ROOT_PATH . 'mapi/lib/core/common.php');
                        $re = redis_lPush("chat_log_redis_lPush", json_encode($chat_log_array));
                    }
                }
            }
        }

    }
//    add_chat_log($post['From_Account'], $post['To_Account'], $post['MsgKey'], $post['MsgBody']);
} else if ($post['CallbackCommand'] == 'State.StateChange') {  // 用户在线状态回调
    $user_id = $post['Info']['To_Account'];
    $action = $post['Info']['Action'];
    define("BOGO_REQUIRE", true);
    require_once APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php';
    require_once APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php';
    $video_viewer_obj = new VideoViewerRedisService();

    $video_viewer_obj->add_user_online($user_id, $action);   //掉线操作修改用户在线状态和用户下麦处理存入缓存--后台定时操作
} else {
    $data['ErrorCode'] = 0;
}

$data['ActionStatus'] = 'OK';
$data['ErrorInfo'] = '';

echo json_encode($data);
exit;
