<?php
//定时任务
header("Content-Type:text/html; charset=utf-8");
define("BOGO_REQUIRE", true);
require '../system/mapi_init.php';

bogo_require(APP_ROOT_PATH . 'mapi/lib/core/common.php');
bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
bogo_require(APP_ROOT_PATH . 'system/utils/Credis.php');

$redis_config = [
    'host' => $GLOBALS['distribution_cfg']['RDB_CLIENT'],
    'password' => $GLOBALS['distribution_cfg']['RDB_PASSWORD'],
    'port' => $GLOBALS['distribution_cfg']['RDB_PORT'],
    'database' => $GLOBALS['distribution_cfg']['REDIS_PREFIX_DB'],
];

$redis = \utils\Credis\CRedis::getInstance($redis_config, ['db_id' => $distribution_cfg['REDIS_PREFIX_DB'], 'timeout' => 30]);

$count = $redis->lLen($distribution_cfg['IM_QUEUE_KEY']);
echo $count;

require_once APP_ROOT_PATH . 'system/tim/TimApi.php';
$api = createTimAPI();

if ($count) {
    for ($i = 0; $i < $count; $i++) {
        $pid = pcntl_fork();
        if ($pid == -1) {
            exit("fork error");
        } elseif ($pid > 0) {
            //echo "child process {$pid}\n";
            pcntl_wait($status);
            //暂时不关心子进程是否成为僵尸进程
            continue;
        } else {
            $data = $redis->lPop($distribution_cfg['IM_QUEUE_KEY']);
            $data = json_decode($data, true);
            $ret = $api->group_send_group_msg2($data['user_id'], $data['group_id'], $data['msg_count']);
            echo json_encode($ret);
            if (isset($ret['ActionStatus']) && $ret['ActionStatus'] != 'OK') {
                $db->autoExecute($data['table'], $ret, 'UPDATE', 'id=' . $data['prop_id']);
            }
        }
    }
}

