<?php
header('Access-Control-Allow-Origin: *');

class hostCModule extends baseCModule
{
    // 开启密码房间
    public function encryption_live()
    {
        $root = array('status' => 1, 'error' => '');

        $user_id = intval($_REQUEST['user_id']);
        $room_id = intval($_REQUEST['room_id']);
        $password = strim($_REQUEST['password']);
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            ajax_return($root);
        }
        if (strlen($password) != 6) {
            $root['error'] = "请输入6位数密码";
            $root['status'] = 0;
            ajax_return($root);
        }
        $psd =  strtoupper(md5($password));
        $sql = "update " . DB_PREFIX . "video set password='{$psd}' where id=" . $room_id;
        $result = $GLOBALS['db']->query($sql);
        if (!$result) {
            $root['error'] = "密码设置失败";
            $root['status'] = 0;
        }
        ajax_return($root);
    }

    //vue直播间页面
    public function index()
    {
        $root = array('status' => 1, 'error' => '');

        $user_id = intval($_REQUEST['user_id']);
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            ajax_return($root);
        }
        //用户信息
        $sql = "select nick_name,id,user_level,province,city,sex,head_image,diamonds,ticket from " . DB_PREFIX . "user  where id=" . $user_id;
        $user = $GLOBALS['db']->getRow($sql, true, true);
        $user['head_image'] = get_spec_image($user['head_image']);
        //创建直播间
        $start_room = $this->get_start_room($user_id);
        $video = $start_room['live'];
        $video['status'] = $start_room['status'];   //直播状态
        $video['error'] = $start_room['error'];

        //在看数量
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        $video_viewer_redis = new VideoViewerRedisService();
        $viewer = $video_viewer_redis->get_viewer_list2($video['id'], 1, 10);

        $user['viewer_num'] = $viewer['watch_number'];

        $m_config = load_auto_cache("m_config");//初始化手机端配置
        // 心跳时间 转换毫秒
        $root['monitor_overtime'] = $m_config['monitor_overtime'] * 1000;
        $root['log_img'] = get_spec_image($m_config['app_logo']);//logo
        $user['ticket_name'] = $m_config['ticket_name'];//ticket_name 主播收益单位
        $user['virtual_watch_number'] = $video ? $video['virtual_watch_number'] : '0'; //直播间观看人数

        $root['barrage_coin'] = $m_config['barrage_coin']; //弹幕发送价格
        $root['diamonds_name'] = $m_config['diamonds_name'];//diamonds_name 虚拟币钻石单位

        $root['user'] = $user;

        $root['video'] = $video;
        //热门
        $root['hot_list'] = $this->live_list("v.sort_num", 6, 0);
        $tim_user_id = $user_id > 0 ? $user_id : 0;
        $usersig = load_auto_cache("usersig", array("id" => $tim_user_id));
        //聊天信息
        $root['loginInfo'] = array(
            'sdkAppID' => $m_config['tim_sdkappid'],
            'accountType' => $m_config['tim_account_type'],
            'identifier' => $tim_user_id,
            'userSig' => $usersig['usersig'],
            "user_id" => $user_id,
            "nick_name" => $user['nick_name'],
            "user_level" => $user['user_level'],
            "head_image" => get_spec_image($user['head_image']),
            "identifierNick" => $user['nick_name'],
        );

        //直播公告消息
        $listmsg_one = load_auto_cache("article_notice");
        $root['list_msg'] = array(
            'text' => $listmsg_one[0]['desc'],
            'is_system' => 1,
            'user_level' => 0,
            'nick_name' => 'admin',
        );

        ajax_return($root);
        exit;

    }

    //开播初始值
    public function get_start_room($user_id)
    {
        $return = array();

        $m_config = load_auto_cache("m_config");

        $tim_user_id = $user_id > 0 ? $user_id : 0;
        $usersig = load_auto_cache("usersig", array("id" => $tim_user_id));
        $return['tim'] = array(
            'sdkappid' => $m_config['tim_sdkappid'],
            'account_type' => $m_config['tim_account_type'],
            'account_id' => $tim_user_id,
            'usersig' => $usersig['usersig'],
        );
        $return['monitor_overtime'] = $m_config['monitor_overtime'] * 1000;//心跳时间
        $return['m_config'] = $m_config;
        $rticle = load_auto_cache("article_notice");

        $return['rticle'] = count($rticle) > 0 ? $rticle[0]['desc'] : '';

        //是否正在开直播
        $sql = "select * from " . DB_PREFIX . "video where  user_id = " . $user_id . " and live_in=1";
        $video_end = $GLOBALS['db']->getRow($sql, true, true);

        if ($video_end) {

            //   header("location:./"); exit;
        }

        //用户是否禁播，$is_ban=1 永久禁播；$is_ban=0非永久禁播，$ban_time禁播结束时间
        $sql = "select is_authentication,is_ban,ban_time,mobile,login_ip,ban_type,apns_code,sex,ticket,refund_ticket,user_level,fans_count,head_image,thumb_head_image,nick_name from " . DB_PREFIX . "user where id = " . $user_id;
        $user = $GLOBALS['db']->getRow($sql, true, true);

        $video_classified = intval($_REQUEST['video_classified']);
        $is_authentication = intval($user['is_authentication']);
        $m_config = load_auto_cache("m_config");

        $return['nick_name'] = $user['nick_name'];
        $return['user_id'] = $user_id;
        $return['user_level'] = $user['user_level'];
        $return['head_image'] = get_spec_image($user['head_image']);

        $dev_type = strim($_REQUEST['sdk_type']);
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);

        //提过限制开播
        $allow = 0;
        if (($user['mobile'] == '13888888888' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) or ($user['mobile'] == '13999999999' && $m_config['ios_check_version'] != '')) {
            $allow = 1;
        }


        if ($allow) {
            $is_authentication = 2;
            $m_config['is_limit_time'] = 0;
        }

        if ($m_config['must_authentication'] == 1 && $is_authentication != 2) {
            $return = array("error" => api_lang("Live_broadcast_after_certification"), "status" => 0);
            return $return;
            exit;
        }


        if (intval($m_config['is_limit_time']) == 1) {
            $now = to_date(get_gmtime(), "H");
            if (intval($m_config['is_limit_time_end']) == intval($m_config['is_limit_time_start'])) {
                $return = array("error" => api_lang("Live_broadcast_has_been_turned_off"), "status" => 0);
                return $return;
                exit;
            }

            $to_day = intval($m_config['is_limit_time_start']) > intval($m_config['is_limit_time_end']) ? 0 : 1;

            if ($to_day == 0 && intval($m_config['is_limit_time_start']) > $now && intval($m_config['is_limit_time_end']) <= $now) {
                $return = array("error" => api_lang("Please_do_it_every_day") . intval($m_config['is_limit_time_start']) . api_lang("hour").api_lang("By_the_next_day") . intval($m_config['is_limit_time_end']) . api_lang("hour").api_lang("During_the_live_broadcast"), "status" => 0);
                return $return;
                exit;
            }

            if ($to_day == 1 && (intval($m_config['is_limit_time_start']) > $now || intval($m_config['is_limit_time_end']) <= $now)) {
                $return = array("error" => api_lang("Please_do_it_every_day") . intval($m_config['is_limit_time_start']) . api_lang("hour")."到" . intval($m_config['is_limit_time_end']) . api_lang("hour").api_lang("During_the_live_broadcast"), "status" => 0);
                return $return;
                exit;
            }
        }

        if ($GLOBALS['db']->getRow("select ban_ip from " . DB_PREFIX . "ban_list where ban_type=1 and ban_ip='" . $user['login_ip'] . "'")) {
            $return = array("error" => api_lang("Failed_to_request_room_ID"), "status" => 0);
            return $return;
            exit;
        }
        if ($GLOBALS['db']->getRow("select apns_code from " . DB_PREFIX . "ban_list where ban_type=2 and apns_code='" . $user['apns_code'] . "'")) {
            $return = array("error" => api_lang("current_device_is_disabled"), "status" => 0);
            return $return;
            exit;
        }

        if (intval($user['is_ban']) == 0 && intval($user['ban_time']) < get_gmtime()) {

            $title = $user['nick_name'] . "的直播间";

            $cate_id = $user['nick_name'] . "的直播间";

            $province = strim($_REQUEST['province']);//省
            $city = strim($_REQUEST['city']);//市

            $is_private = intval($_REQUEST['is_private']);//1：私密聊天; 0:公共聊天
            $share_type = strtolower(strim($_REQUEST['share_type']));//WEIXIN,WEIXIN_CIRCLE,QQ,QZONE,EMAIL,SMS,SINA
            if ($share_type == 'null') {
                $share_type = '';
            }


            $sql = "select * from " . DB_PREFIX . "video where live_in =2 and user_id = " . $user_id;
            $video = $GLOBALS['db']->getRow($sql, true, true);

            if ($video) {
                //更新心跳时间，免得被删除了
                $sql = "update " . DB_PREFIX . "video set monitor_time = '" . to_date(NOW_TIME, 'Y-m-d H:i:s') . "' where id =" . $video['id'];
                $GLOBALS['db']->query($sql);

                if ($GLOBALS['db']->affected_rows()) {
                    //如果数据库中发现，有一个正准备执行中的，则直接返回当前这条记录;
                    $return['status'] = 1;
                    $return['error'] = '';
                    $return['room_id'] = intval($video['id']);
                    $return['live'] = $video;
                    $return['video_type'] = intval($video['video_type']);
                    return $return;
                    exit;
                }
            }


            //关闭 之前的房间,非正常结束的直播,还在通知所有人：退出房间
            $sql = "select id,user_id,watch_number,vote_number,group_id,room_type,begin_time,end_time,channelid,video_vid,cate_id,is_voice from " . DB_PREFIX . "video where live_in =1 and user_id = " . $user_id;
            $list = $GLOBALS['db']->getAll($sql, true, true);
            foreach ($list as $k => $v) {
                //结束直播
                do_end_video($v, $v['video_vid'], 1, $v['cate_id']);
            }

            //添加位置

            if ($province == 'null') {
                $province = '';
            }

            if ($city == 'null') {
                $city = '';
            }

            $province = str_replace("省", "", $province);

            $city = str_replace("市", "", $city);

            if ($province == '' || $city == '') {

                $ipinfo = get_ip_info();

                $province = $ipinfo['province'];
                $city = $ipinfo['city'];
            }

            $province = $province == '' ? api_lang('Mars') : $province;
            $city = $city == '' ? api_lang('Mars') : $city;


            $video_id = get_max_room_id(0);
            $data = array();
            $data['id'] = $video_id;
            //room_type 房间类型 : 1私有群（Private）,0公开群（Public）,2聊天室（ChatRoom）,3互动直播聊天室（AVChatRoom）
            if ($is_private == 1) {
                $data['room_type'] = 1;
                $data['private_key'] = md5($video_id . rand(1, 9999999));//私密直播key
            } else {
                $data['room_type'] = 3;
            }

            $data['virtual_number'] = intval($m_config['virtual_number']);
            $data['max_robot_num'] = intval($m_config['robot_num']);//允许添加的最大机器人数;


            $data['live_image'] = get_spec_image($user['head_image']);

            $data['head_image'] = get_spec_image($user['head_image']);
            $data['thumb_head_image'] = get_spec_image($user['thumb_head_image']);

            $data['sex'] = intval($user['sex']);//性别 0:未知, 1-男，2-女


            $data['video_type'] = intval($m_config['video_type']);//0:腾讯云互动直播;1:腾讯云直播

            if ($data['video_type'] > 0) {

                //创建groupid
                require_once(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();
                $ret = $api->group_create_group('AVChatRoom', (string)$user_id, (string)$user_id, (string)$video_id);
                if ($ret['ActionStatus'] != 'OK') {
                    ajax_return(array(
                        'status' => 0,
                        'error' => $ret['ErrorCode'] . $ret['ErrorInfo']
                    ));
                }

                $data['group_id'] = $ret['GroupId'];

                bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
                $video_factory = new VideoFactory();
                $channel_info = $video_factory->Create($video_id, 'mp4', $user_id);

                $data['video_type'] = !empty($channel_info['video_type']) ? $channel_info['video_type'] : $data['video_type'];


                $data['channelid'] = $channel_info['channel_id'];
                $data['push_rtmp'] = $channel_info['upstream_address'];
                $data['play_flv'] = $channel_info['downstream_address']['flv'];
                $data['play_rtmp'] = $channel_info['downstream_address']['rtmp'];
                $data['play_hls'] = $channel_info['downstream_address']['hls'];

                $return['play_hls'] = $data['play_hls'];
                $return['play_rtmp'] = $data['play_rtmp'];
                $return['play_flv'] = $data['play_flv'];
            }

            $data['monitor_time'] = to_date(NOW_TIME, 'Y-m-d H:i:s');//主播心跳监听

            $data['push_url'] = '';//video_type=1;1:腾讯云直播推流地址
            $data['play_url'] = '';//video_type=1;1:腾讯云直播播放地址(rmtp,flv)

            $data['share_type'] = $share_type;
            $data['title'] = $title;
            $data['video_classified'] = $video_classified;
            $data['user_id'] = $user_id;
            $data['live_in'] = 2;//live_in:是否直播中 1-直播中 0-已停止;2:正在创建直播;
            $data['watch_number'] = '';//'当前观看人数';
            $data['vote_number'] = '';//'获得票数';
            $data['province'] = $province;//'省';
            $data['city'] = $city;//'城市';

            $data['create_time'] = NOW_TIME;//'创建时间';
            $data['begin_time'] = NOW_TIME;//'开始时间';
            $data['end_time'] = '';//'结束时间';
            $data['is_hot'] = 1;//'1热门; 0:非热门';
            $data['is_new'] = 1; //'1新的; 0:非新的,直播结束时把它标识为：0？'

            $data['online_status'] = 1;//主播在线状态;1:在线(默认); 0:离开

            //sort_init(初始排序权重) = (用户可提现印票：bogo_user.ticket - bogo_user.refund_ticket) * 保留印票权重+ 直播/回看[回看是：0; 直播：9000000000 直播,需要排在最上面 ]+ bogo_user.user_level * 等级权重+ bogo_user.fans_count * 当前有的关注数权重
            $sort_init = (intval($user['ticket']) - intval($user['refund_ticket'])) * floatval($m_config['ticke_weight']);

            $sort_init += intval($user['user_level']) * floatval($m_config['level_weight']);
            $sort_init += intval($user['fans_count']) * floatval($m_config['focus_weight']);

            $data['sort_init'] = 200000000 + $sort_init;
            $data['sort_num'] = $data['sort_init'];


            // 1、创建视频时检查表是否存在，如不存在创建礼物表，表命名格式 bogo_ video_ prop_201611、格式同bogo_ video_ prop相同
            // 2、将礼物表名称写入bogovideo 中，需新建字段
            // 3、记录礼物发送时候读取bogo_video 的礼物表名，写入对应的礼物表
            // 4、修改所有读取礼物表的地方，匹配数据
            $data['prop_table'] = createPropTable();
            //直播分类
            $data['classified_id'] = $video_classified;
            if ((defined('PUBLIC_PAY') && PUBLIC_PAY == 1) && intval($m_config['switch_public_pay']) == 1 && intval($m_config['public_pay']) > 0) {
                $data['is_live_pay'] = 1;
                $data['live_pay_type'] = 1;
                $data['public_screen'] = 1;
                $data['live_fee'] = intval($m_config['public_pay']);
                $data['live_pay_time'] = intval(NOW_TIME);
            }
            $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $data, 'INSERT');

            if ($GLOBALS['db']->affected_rows()) {
                $return['status'] = 1;
                $return['error'] = '';
                $return['room_id'] = $video_id;
                $return['live'] = $data;
                $return['video_type'] = intval($data['video_type']);
                sync_video_to_redis($video_id, '*', false);

            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("Failed_to_create_room");
            }
        } else {
            if (intval($user['is_ban'] && intval($user['ban_type'] == 0))) {
                $return['status'] = 0;
                $return['error'] = api_lang("You_are_banned");
            } elseif (intval($user['is_ban'] && intval($user['ban_type'] == 1))) {
                $return['status'] = 0;
                $return['error'] =api_lang("Failed_to_request_room_ID");
            } elseif (intval($user['is_ban'] && intval($user['ban_type'] == 2))) {
                $return['status'] = 0;
                $return['error'] =api_lang("current_device_is_disabled");
            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("title_can_be_broadcast_for_time_being").'：' . to_date(intval($user['ban_time']), 'Y-m-d H:i:s') . '。';
            }

        }

        if ($m_config['must_authentication'] == 1 && $is_authentication != 2) {
            $return['room_id'] = 0;
        }
        //-------------------------------------
        //sdk_type 0:使用腾讯SDK、1：使用金山SDK
        //映射关系类型  腾讯云直播, 金山云，星域，  云 ，阿里云cont
        //video_type     1          2        3      4       5
        //sdk_type       0          1        -      -       -
        $return['sdk_type'] = get_sdk_info($m_config['video_type']);
        return $return;
        exit;
    }

    //开播
    public function upd_live_status()
    {

        $root = array('status' => 0, 'error' => '开播失败', 'list' => []);

        $user_id = intval($_REQUEST['user_id']);
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            ajax_return($root);
        }
        $room_id = intval($_REQUEST['room_id']);//直播ID 也是room_id

        $sql = "select * from " . DB_PREFIX . "video where live_in =1 and user_id = " . $user_id . " and id=" . $room_id;
        $list = $GLOBALS['db']->getRow($sql, true, true);

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        if ($list) {
            $root['list'] = $list;
            $root['status'] = 1;
            $root['error'] = '';
            $video_redis->video_online($room_id, $list['group_id']);
            //将mysql数据,同步一份到redis中
            sync_video_to_redis($room_id, '*', false);
            ajax_return($root);
        }
        $sql = "update " . DB_PREFIX . "video set live_in = 1,create_type=1 where live_in =2 and id = " . $room_id . " and user_id = " . $user_id;

        $GLOBALS['db']->query($sql);
        if ($GLOBALS['db']->affected_rows()) {
            $sql = "select * from " . DB_PREFIX . "video where live_in =1 and user_id = " . $user_id . " and id=" . $room_id;
            $list = $GLOBALS['db']->getRow($sql, true, true);
            $root['list'] = $list;
            $root['status'] = 1;
            $root['error'] = '';

            $video_redis->video_online($room_id, $list['group_id']);
            //将mysql数据,同步一份到redis中
            sync_video_to_redis($room_id, '*', false);
        }

        ajax_return($root);

    }

    /**
     * 直播结束
     */
    public function end_live()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        $room_id = intval($_REQUEST['room_id']);//房间号id

        $user_token = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            ajax_return($root);
        }
        //只要主播请求关闭直播，就请求同步redis数据到mysql，防止结束时候mysql数据未同步导致的当前处理的数据错误；
        $sql = "SELECT id FROM " . DB_PREFIX . "video";
        $list = $GLOBALS['db']->getAll($sql, true, true);
        if (count($list) > 0) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            foreach ($list as $k => $v) {
                $video_id = $v['id'];
                //计算权重
                $video_redis->syn_sort_num($video_id);
                $fields = array('share_count', 'like_count', 'fans_count', 'sort_num', 'vote_number', 'robot_num', 'watch_number', 'virtual_watch_number', 'max_watch_number');
                $video = $video_redis->getRow_db($video_id, $fields);

                $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $video, "UPDATE", "id=" . $video_id);
            }
        }
        $sql = "";
        if (OPEN_PAI_MODULE == 1) {
            $sql = "select id,user_id,max_watch_number,virtual_watch_number,robot_num,vote_number,group_id,room_type,begin_time,end_time,channelid,cate_id,pai_id,is_live_pay,live_pay_type,is_voice from " . DB_PREFIX . "video where id = " . $room_id . " and user_id = " . $user_id;
        } else {
            $sql = "select id,user_id,max_watch_number,virtual_watch_number,robot_num,vote_number,group_id,room_type,begin_time,end_time,channelid,cate_id,is_live_pay,live_pay_type,is_voice from " . DB_PREFIX . "video where id = " . $room_id . " and user_id = " . $user_id;
        }
        $video = $GLOBALS['db']->getRow($sql, true, true);
        //只有主播自己能结束
        if ($user_id == $video['user_id']) {
            //同时关闭子房间
            if (defined('CHILD_ROOM') && CHILD_ROOM == 1) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/ChildRoom.class.php');
                $child_room = new child_room();
                $child_room->end_child_video($room_id);
            }
            do_end_video($video, '', 0, $video['cate_id']);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();

            $root['watch_number'] = intval($video['max_watch_number']);
            $root['vote_number'] = intval($video['vote_number']) + intval($video_redis->getOne_db($video['id'], 'game_vote_number'));//获得印票
            $time_len = NOW_TIME - $video['begin_time'];//私有聊天或小于5分钟的视频，不保存
            $m_config = load_auto_cache("m_config");
            $short_video_time = $m_config['short_video_time'] ? $m_config['short_video_time'] : 300;

            if ($video['room_type'] == 1 || $time_len < $short_video_time && $m_config['has_save_video'] == 0) {
                $root['has_delvideo'] = 0;//1：显示删除视频按钮; 0:不显示；
            } else {
                $root['has_delvideo'] = 1;//1：显示删除视频按钮; 0:不显示；
            }
        }
        rm_auto_cache("select_video");
        $root['status'] = 1;
        ajax_return($root);
    }

    //监控定时请求直播间
    public function timing()
    {
        $root = array('status' => 1);
        $user_id = $_REQUEST['user_id'];
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        } else {

            $room_id = intval($_REQUEST['room_id']);//直播ID 也是room_id

            $sql = "select * from " . DB_PREFIX . "video where (live_in =1 or live_in =2) and user_id = " . $user_id . " and id=" . $room_id;
            $video_number = $GLOBALS['db']->getRow($sql, true, true);


            $vote_number = intval($video_number['vote_number']);//获得印票数
            $watch_number = intval($video_number['watch_number']);//当前观看人数
            $group_id = strim($video_number['group_id']);//聊天组ID
            $live_pay_time = $video_number['live_pay_time'];//开始收费时间
            $live_pay_type = intval($video_number['live_pay_type']);//收费模式
            $live_fee = intval($video_number['live_fee']);//付费直播 收费多少
            $live_is_mention = intval($video_number['live_is_mention']);//收费模式 是否已经提档过

            if (intval($_REQUEST['watch_number']) > 0) {
                //客户端有返回：当前观看人数 则取客户端返回的
                $watch_number = intval($_REQUEST['watch_number']);//当前观看人数
            }
            $lianmai_num = intval($_REQUEST['lianmai_num']);//当前连麦数量

            $live_quality = json_decode($_REQUEST['live_quality'], true);
            $appCPURate = intval($live_quality['appCPURate']);//appcpu占用率
            $sysCPURate = intval($live_quality['sysCPURate']);//系统cpu占用率
            $sendKBps = intval($live_quality['sendKBps']);//上行速率
            $recvKBps = intval($live_quality['recvKBps']);//下行速率
            $sendLossRate = intval($live_quality['sendLossRate']);//上行丢包率
            $fps = intval($live_quality['fps']);//视频帧率fps
            $device = strim($live_quality['device']);//设备系统

            $monitor_time = to_date(NOW_TIME, 'Y-m-d H:i:s');

            //00:00; 05:00; 10:00; 15:00; ....; 55:00;
            $i_time = to_date(NOW_TIME, 'i');
            $s_time = to_date(NOW_TIME, 's');

            if ($i_time >= 55 && $s_time > 0) {
                //放在下一小时的：00:00 时段
                $statistic_time = to_date(NOW_TIME + 330, 'Y-m-d H:00:00');
            } else {

                if ($i_time >= 50) {
                    $i_time2 = '55';
                } else if ($i_time >= 45) {
                    $i_time2 = '50';
                } else if ($i_time >= 40) {
                    $i_time2 = '45';
                } else if ($i_time >= 35) {
                    $i_time2 = '40';
                } else if ($i_time >= 30) {
                    $i_time2 = '35';
                } else if ($i_time >= 25) {
                    $i_time2 = '30';
                } else if ($i_time >= 20) {
                    $i_time2 = '25';
                } else if ($i_time >= 15) {
                    $i_time2 = '20';
                } else if ($i_time >= 10) {
                    $i_time2 = '15';
                } else if ($i_time >= 5) {
                    $i_time2 = '10';
                } else {
                    $i_time2 = '05';
                }

                $statistic_time = to_date(NOW_TIME, 'Y-m-d H:') . $i_time2 . ':00';
            }

            //更新最后心跳时间点
            $sql = "update " . DB_PREFIX . "video set monitor_time = '" . $monitor_time . "' where (live_in =1 or live_in=2) and id = " . $room_id . " and user_id = " . $user_id;
            $GLOBALS['db']->query($sql);
            if ($GLOBALS['db']->affected_rows()) {

                $video_monitor = array();
                $video_monitor['user_id'] = $user_id;
                $video_monitor['video_id'] = $room_id;
                $video_monitor['vote_number'] = $vote_number;
                $video_monitor['watch_number'] = $watch_number;
                $video_monitor['lianmai_num'] = $lianmai_num;
                $video_monitor['monitor_time'] = $monitor_time;
                $video_monitor['statistic_time'] = $statistic_time;
                $video_monitor['appCPURate'] = $appCPURate;
                $video_monitor['sysCPURate'] = $sysCPURate;
                $video_monitor['sendKBps'] = $sendKBps;
                $video_monitor['recvKBps'] = $recvKBps;
                $video_monitor['sendLossRate'] = $sendLossRate;
                $video_monitor['fps'] = $fps;
                $video_monitor['device'] = $device;
                $GLOBALS['db']->autoExecute(DB_PREFIX . "video_monitor", $video_monitor, "INSERT");

                //在主播心跳接口monitor,做一次：连麦用户的IM通知更新，确保不漏单
                /*   $root['push_lianmai'] = $this->push_lianmai($room_id);

                   if ($lianmai_num > 0) {
                       $this->mix_stream2($room_id, 0);
                   }*/
            }
        }
        $live_pay = $GLOBALS['db']->getRow("SELECT id,class FROM " . DB_PREFIX . "plugin WHERE is_effect=1 and type = 1 ");
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        if ((defined('OPEN_LIVE_PAY') && OPEN_LIVE_PAY == 1) && $live_pay) {
            $root['live']['allow_live_pay'] = 0;
            $root['live']['allow_mention'] = 0;
            $root['live']['live_fee'] = $live_fee;
            $root['live']['live_is_mention'] = $live_is_mention;

            $live_pay_type = intval($video_number['live_pay_type']);
            //最低人数
            if (intval($m_config['live_pay_num']) <= intval($video_number['watch_number'] + $video_number['robot_num'] + $video_number['virtual_watch_number'])) {
                if ($live_pay_time != '' && $live_fee > 0) {
                    $root['live']['allow_live_pay'] = 2;//已经付费过
                } else {
                    $root['live']['allow_live_pay'] = 1;//可以付费
                }
            }
            log_result($root);
            if ((defined('PUBLIC_PAY') && PUBLIC_PAY == 1) && $m_config['switch_public_pay'] == 1 && $m_config['public_pay'] > 0) {
                $public_screen = $GLOBALS['db']->getOne("SELECT public_screen FROM  " . DB_PREFIX . "video WHERE user_id=" . $user_id . " and live_in=1");
                if ($public_screen == 1) {
                    $root['live']['allow_live_pay'] = 1;//可以付费
                }
            }

            if ((intval($m_config['live_pay_rule'] * 60) <= intval(NOW_TIME - $live_pay_time)) && $live_pay_time > 0 && $live_pay_type == 0) {
                if ($live_is_mention) {
                    $root['live']['allow_mention'] = 2;//已经提档
                } else {
                    $root['live']['allow_mention'] = 1;//可以提档
                }
            }
            //直播间主播获得的印票
            $sql = "select ticket from " . DB_PREFIX . "user  where id = " . $user_id;
            $users = $GLOBALS['db']->getRow($sql, true, true);
            $root['live']['ticket'] = intval($users['ticket']);

            //默认价格
            $root['live']['live_fee'] = intval($root['live']['live_fee']) > 0 ? intval($root['live']['live_fee']) : 1;
            $live_time = $live_pay_time - NOW_TIME;
            $live_time = $live_time > 0 ? intval($live_time) : 0;
            //实际付费人数
            if ($live_pay_type == 0) {
                if ($live_time == 0) {
                    $times = get_gmtime() - 120;
                    $sql = "select id from " . DB_PREFIX . "live_pay_log where total_diamonds>0 and video_id =" . $room_id . " and pay_time_end>=" . $times . " group by from_user_id ";
                    $live_list = $GLOBALS['db']->getAll($sql, true, true);
                } else {
                    $live_list = array();
                }
            } else {
                $live_list = $GLOBALS['db']->getAll("select id from " . DB_PREFIX . "live_pay_log where total_diamonds>0 and video_id =" . $room_id . " group by from_user_id ", true, true);
            }
            $live_viewer = count($live_list);
            $root['live']['live_viewer'] = intval($live_viewer);
            //收费类型 0是按时付费、1按场付费、2 普通付费
            if ($live_pay_type == 0 && intval($video_number['is_live_pay'])) {
                $root['live']['live_pay_type'] = 0;
            } else if ($live_pay_type == 1 && intval($video_number['is_live_pay'])) {
                $root['live']['live_pay_type'] = 1;
            } else {
                $root['live']['live_pay_type'] = 2;
            }
        }
        //设置直播间观众列表返回数量
        $page_size = intval($m_config['view_page_size']) > 0 ? intval($m_config['view_page_size']) : 50;

        $root['ret'] = push_viewer($room_id, $group_id, $page_size);
        ajax_return($root);
    }

}

?>