<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class loginCModule extends baseModule
{
    /**
     * 注册
     */
    public function register()
    {

        $root = array('status' => 1, 'error' => '');

        if (!$_REQUEST) {
            app_redirect(get_domain() . "/");
        }

        $mobile = strim($_REQUEST['mobile']);

        if ($mobile == '') {
            $root['error'] = api_lang("Mobile_phone_is_not_empty");
            $root['status'] = 0;
            ajax_return($root);
        }

        if (!check_mobile($mobile)) {
            $result['info'] = api_lang("Mobile_phone_format_error");
            $root['status'] = 0;
            ajax_return($root);
        }

        $m_config = load_auto_cache("m_config");


        $root['url'] = $m_config['promote_url'];

        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where mobile =" . $mobile);
        if ($user) {
            $this->check_verify_code();
            $user['token'] = encryptDecrypt('password', 'bogo|' . $user['id'] . '_' . NOW_TIME, 0);
            //设置session
            es_session::set("user_info", $user);
            $GLOBALS['user_info'] = $user;
            //      $names=es_session::get("user_info");
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $user, "UPDATE", "id=" . $user['id']);
            $root['error'] = api_lang("Login_successful");
            $root['status'] = 1;
            $root['user'] = $user;

        } else {
            bogo_require(APP_ROOT_PATH . "system/libs/user.php");
            $result = do_login_user($_REQUEST['mobile'], $_REQUEST['yzm'], 0, $_REQUEST);
            if ($result['status']) {
                $root['user_id'] = $result['user']['id'];
                $root['status'] = 1;
                //头像
                $m_config = load_auto_cache("m_config");//初始化手机端配置
                $system_head_image = $m_config['app_logo'];

                if ($system_head_image == '') {
                    $system_head_image = './public/attachment/test/noavatar_10.JPG';
                    syn_to_remote_image_server($system_head_image, false);
                }
                $data = array(
                    'head_image' => $system_head_image,
                    'thumb_head_image' => get_spec_image($system_head_image, 40, 40),
                    'token' => encryptDecrypt('password', $result['user']['id'] . '_' . time(), 0)
                );
                $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, "UPDATE", "id=" . $result['user']['id']);

                $result['user']['token'] = $data['token'];

                $root['error'] = api_lang("login_was_successful");
                //设置session
                es_session::set("user_info", $result);
                $GLOBALS['user_info'] = $result;
                $root['user'] = $result;

            } else {
                $root['status'] = 0;
                if ($root['error'] == '') $root['error'] = $result['info'];
            }

        }


        ajax_return($root);
    }


    /**
     * 退出功能
     */
    public function loginout()
    {
        $ajax = intval($_REQUEST['ajax']);
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        $result = loginout_user();

        es_session::delete("user_info");
        $root['status'] = 1;
        $root['error'] = api_lang("Exit_succeeded");

        ajax_return($root);
    }

    /**
     * 检查手机验证码
     */
    public function check_verify_code()
    {
        $settings_mobile_code = strim($_REQUEST['yzm']);
        $mobile = strim($_REQUEST['mobile']);


        if ($GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND verify_code='" . $settings_mobile_code . "'") == 0) {
            $data['status'] = 0;
            $data['info'] = api_lang("Verification_code_error");
            ajax_return($data);
        }


    }


    /**
     * 发送手机验证码
     */
    function send_mobile_verify()
    {
        $mobile = addslashes(htmlspecialchars(trim($_REQUEST['mobile'])));
        $type = intval($_REQUEST['type']);
        if (app_conf("SMS_ON") == 0) {
            $root['status'] = 0;
            $root['error'] = api_lang("SMS_not_opened");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }
        if ($mobile == '') {
            $root['status'] = 0;
            $root['error'] = api_lang("Input_mobile_phone_number");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }


        if (OPEN_YPSMS == 1) {

        } else if (!check_mobile($mobile)) {
            $root['status'] = 0;
            $root['error'] = api_lang("Fill_in_the_correct_number");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        //添加：手机发送 防护
        $root = check_sms_send($mobile);
        if ($root['status'] == 0) {
            $root['time'] = 0;
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        //微信绑定判断手机是否被使用
        //获取登录方式
        if ($GLOBALS['user_info'] && intval($_REQUEST['wx_binding'])) {
            if ($GLOBALS['user_info']['login_type'] == '') {
                $login_type_sql = "select login_type from " . DB_PREFIX . "user where id = '" . $GLOBALS['user_info']['id'] . "'";
                $login_type = $GLOBALS['db']->getOne($login_type_sql);
            } else {
                $login_type = $GLOBALS['user_info']['login_type'];
            }

            if ($GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "user where mobile = '" . $mobile . "' and login_type = " . $login_type) > 0) {
                $root['status'] = 0;
                $root['error'] = api_lang("Mobile_phone_number_used");
                if ($type) {
                    api_ajax_return($root);
                } else {
                    ajax_return($root);
                }
            }
        }

        if ($GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where mobile = '" . $mobile . "' and is_effect =0")) {
            $root['status'] = 0;
            $root['error'] = api_lang("Account_disabled");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        $result = array("status" => 1, "info" => '');

        //图片验证码
        if (app_conf("USER_VERIFY_STATUS") == 1 && !$GLOBALS['user_info']) {
            $image_code = strim($_REQUEST['image_code']);
            if ($image_code) {
                $sql = "select id from " . DB_PREFIX . "image_verify_code where verify_code = '" . md5($image_code) . "'";
                $verify_id = $GLOBALS['db']->getOne($sql);
                if (intval($verify_id) == 0) {
                    ajax_return(array("status" => 0, "error" => api_lang("Picture_captcha_error")));
                } else {
                    $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "image_verify_code WHERE verify_code = '" . md5($image_code) . "'");
                }
            } else {

                if ($type) {
                    api_ajax_return(array("status" => 0, "error" => api_lang("Image_verification_code_empty")));
                } else {
                    ajax_return(array("status" => 0, "error" => api_lang("Image_verification_code_empty")));
                }
            }
        }

        //发送时间
        if ($GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "mobile_verify_code where mobile = '" . $mobile . "' and client_ip='" . get_client_ip() . "' and create_time>=" . (get_gmtime() - 60) . " ORDER BY id DESC") > 0) {
            $root['status'] = 0;
            $root['error'] = api_lang("too_fast_to_send");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }
        $n_time = get_gmtime() - 300;
        //删除超过5分钟的验证码
        $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "mobile_verify_code WHERE create_time <=" . $n_time);
        //开始生成手机验证
        if ($mobile == '13888888888' || $mobile == '13999999999') {
            $root['status'] = 1;
            $root['time'] = 60;
            $root['error'] = api_lang("Sent_successfully");
        } else {
            $code = rand(1000, 9999);
            //     $code =123456;
            $GLOBALS['db']->autoExecute(DB_PREFIX . "mobile_verify_code", array("verify_code" => $code, "mobile" => $mobile, "create_time" => get_gmtime(), "client_ip" => get_client_ip()), "INSERT");
            $_REQUEST['code'] = $code;
            send_verify_sms($mobile, $code);
            $status = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "deal_msg_list where dest = '" . $mobile . "' and code='" . $code . "'");

            if ($status['is_success']) {
                $root['status'] = 1;
                $root['time'] = 60;
                $root['error'] = $status['title'] . $status['result'];
            } else {
                $root['status'] = 0;
                $root['time'] = 0;
                $root['error'] = api_lang("Verification_code_sending_failed");
            }
        }
        if ($type) {
            api_ajax_return($root);
        } else {
            ajax_return($root);
        }
    }
}


?>