<?php
// 也可以添加所有的请求为 允许，当然不推荐这样做了、
header('Access-Control-Allow-Origin: *');

class userinfoCModule extends baseCModule
{
    //获取编辑用户信息
    public function index()
    {
        $root = array();
        $root['status'] = 1;
        $user_id = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            echo json_encode($root);
            exit;
        }
        $sql = "select * from " . DB_PREFIX . "user where  id =" . $user_id;
        $users = $GLOBALS['db']->getRow($sql, true, true);
        if ($users) {
            $users['head_image'] = get_spec_image($users['head_image']);
            $users['token'] = encryptDecrypt('password', 'bogo|' . $users['id'] . '_' . time(), 0);
        }
        $root['users'] = $users;

        echo json_encode($root);
        exit;
    }

    // 保存用户信息
    public function upd_user()
    {
        $root = array('error' => api_lang("Save_failed"), 'status' => 0);
        $user_id = intval($_REQUEST['user_id']);
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        $signature = strim($_REQUEST['signature']);
        $nick_name = strim($_REQUEST['nick_name']);

        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            echo json_encode($root);
            exit;
        }
        $data = array(
            'nick_name' => $nick_name,
            'signature' => $signature
        );
        $sql = "select * from " . DB_PREFIX . "user where  id =" . $user_id;
        $users = $GLOBALS['db']->getRow($sql, true, true);
        if ($signature == $users['signature'] && $nick_name == $users['nick_name']) {
            $root['error'] = "请修改要保存的信息";
            echo json_encode($root);
            exit;
        }
        $where = "id=" . $user_id;
        $result = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, "UPDATE", $where);
        if ($result) {
            $users['signature'] = $signature;
            $users['nick_name'] = $nick_name;
            $users['head_image'] = get_spec_image($users['head_image']);
            $users['token'] = encryptDecrypt('password', 'bogo|' . $users['id'] . '_' . time(), 0);
            $root['status'] = "1";
            $root['user'] = $users;
            $root['error'] = api_lang("Saved_successfully");
        }
        echo json_encode($root);
        exit;
    }

    //获取关注用户列表
    public function get_focus()
    {
        $root = array();
        $to_user_id = intval($_REQUEST['to_user_id']);
        $user_id = intval($_REQUEST['user_id']);
        if (!$to_user_id) {
            $to_user_id = $user_id;
        }
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
        $user_redis = new UserFollwRedisService($to_user_id);
        $list_user = $user_redis->following();
        $name = '';
        foreach ($list_user as $k => $v) {
            $name .= $v . ",";
        }
        $name = rtrim($name, ',');
        if ($name) {
            $list = $GLOBALS['db']->getALL("select signature,nick_name,id as user_id,sex,head_image,user_level from " . DB_PREFIX . "user  where id in(" . $name . ")");
            foreach ($list as &$v) {
                $user_redis = new UserFollwRedisService($user_id);
                $v['is_focus'] = $user_redis->is_following($v['user_id']) || intval($_REQUEST['to_user_id']) == $user_id ? 1 : 0;
            }

        } else {
            $list = [];
        }

        /* $list[$k]['signature'] = htmlspecialchars_decode($list[$k]['signature']);
            $list[$k]['nick_name'] = htmlspecialchars_decode($list[$k]['nick_name']);
            $list[$k]['signature'] = emoji_decode($list[$k]['signature']);
            $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);*/

        $root['list'] = $list;
        echo json_encode($root);
        exit;
    }

    //取消关注
    public function del_focus()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        $to_user_id = intval($_REQUEST['to_user_id']); //取消和关注用户id

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
        $user_follw_redis = new UserFollwRedisService($user_id);

        if ($user_follw_redis->is_following($to_user_id)) {
            //取消关注;
            $root['type'] = 0;
            $user_follw_redis->unfollow($to_user_id);
        } else {
            $root['type'] = 1;
            //关注操作
            $user_follw_redis->follow($to_user_id);
            //若在黑名单，解除拉黑
            set_black($user_id, $to_user_id, true);
        }
        echo json_encode($root);
        exit;
    }

    //获取粉丝用户列表
    public function get_fans()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        $to_user_id = intval($_REQUEST['to_user_id']);

        $page_size = 200;
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
        $user_redis = new UserFollwRedisService($user_id);
        $list = $user_redis->get_follonging_by_user($to_user_id, 1, $page_size);
        $keys = $user_redis->following();

        foreach ($list as $k => $v) {
            if ($user_id > 0) {
                if (in_array($v['user_id'], $keys)) {
                    $list[$k]['follow_id'] = 1;
                } else {
                    $list[$k]['follow_id'] = 0;
                }
            } else {
                $list[$k]['follow_id'] = 0;
            }
            $list[$k]['head_image'] = get_spec_image($v['head_image']);
            $list[$k]['nick_name'] = htmlspecialchars_decode($list[$k]['nick_name']);
            $list[$k]['signature'] = htmlspecialchars_decode($list[$k]['signature']);
            $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
            $list[$k]['signature'] = emoji_decode($list[$k]['signature']);
        }
        $root['list'] = $list;
        echo json_encode($root);
        exit;
    }

    //我的等级
    public function my_level()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_data = $user_redis->getRow_db($user_id, array('id', 'score', 'online_time', 'user_level'));
        user_leverl_syn($user_data);
        $level = $GLOBALS['db']->getRow("select ul.name as leve_name,ul.score as l_score from " . DB_PREFIX . "user_level as ul  where ul.level=" . intval($user_data['user_level']));
        $m_config = load_auto_cache("m_config");
        $level['u_score'] = $user_data['score'] + floor($user_data['online_time'] * floatval($m_config['onlinetime_to_experience']));
        $level['up_score'] = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level=" . intval($user_data['user_level'] + 1));

        if (intval($level['up_score']) <= 0) {
            $l_up_score = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level>" . intval($user_data['user_level'] + 1));
            if ($l_up_score['score'] > 0) {
                $level['up_score'] = $l_up_score['score'];
            }
        }

        $level['percentage'] = round($level['u_score'] / $level['up_score'] * 100, 2);
        $root = $level;
        ajax_return($root);
    }

    //我的收益
    public function my_income()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $profit = $user_redis->getRow_db($user_id, array('ticket', 'money', 'subscribe', 'wx_openid', 'mobile', 'refund_ticket', 'binding_alipay'));

            $root['status'] = 1;
            $root['error'] = '';

            //提现比例 如果主播提现比例为空，则使用后台通用比例
            $root['ticket_catty_ratio'] = $GLOBALS['db']->getOne("select alone_ticket_ratio from " . DB_PREFIX . "user where id=" . $user_id);
            if ($root['ticket_catty_ratio'] == '') {
                $root['ticket_catty_ratio'] = floatval($m_config['ticket_catty_ratio']);
            }
            //公会长提现比例特殊ljz
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE == 1 && $m_config['society_pattern'] == 2) {
                $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_id);
                if (intval($society_info['society_chieftain']) == 1) {
                    $refund_rate = $GLOBALS['db']->getOne("select refund_rate from " . DB_PREFIX . "society where id=" . $society_info['society_id']);
                    $root['ticket_catty_ratio'] = floatval($refund_rate);
                    if ($root['ticket_catty_ratio'] > 1 || $root['ticket_catty_ratio'] <= 0) {
                        $root['ticket_catty_ratio'] = $m_config['society_public_rate'];
                    }
                } elseif ($society_info['society_id']) {
                    $root['ticket_catty_ratio'] = $m_config['society_user_rate'];
                }
            }

            $root['ticket'] = intval($profit['ticket']);
            $root['money'] = number_format(intval($profit['ticket'] - $profit['refund_ticket']) * floatval($root['ticket_catty_ratio']), 2);
            $root['useable_ticket'] = intval($profit['ticket'] - $profit['refund_ticket']);
            $root['subscribe'] = intval($profit['subscribe']);

            //最小提现印票
            $root['ticket_catty_min'] = intval(intval($m_config['ticket_catty_min']) / floatval($root['ticket_catty_ratio']));
            //添加微信公众号名称
            $root['gupnp_context_get_subscription_timeout(context)'] = mb_strlen($m_config['subscription']) ? $m_config['subscription'] : '';

            //每日可提现印票
            if (floatval($root['ticket_catty_ratio']) > 0) {
                $root['day_ticket_max'] = intval(intval($m_config['day_cash_max']) / floatval($root['ticket_catty_ratio']));
            }

            //是否有未处理的提现
            if ($GLOBALS['db']->getOne("select count(*) FROM " . DB_PREFIX . "user_refund WHERE user_id = " . $user_id . " and (is_pay =0 or is_pay=1)") > 0) {
                $root['refund_exist'] = 1;
            } else {
                $root['refund_exist'] = 0;
            }

            if ($profit['wx_openid'] != '')
                $root['binding_wx'] = 1;
            else
                $root['binding_wx'] = 0;

            if ($profit['mobile'] != '')
                $root['mobile_exist'] = 1;
            else
                $root['mobile_exist'] = 0;

            if (OPEN_PAI_MODULE == 1) {
                $rs = BogoServiceCall("user_center", "profit", array("user_id" => $user_id));
            }

            $root['show_pai_ticket'] = 0;
            $root['pai_ticket'] = intval($rs['pai_income_done']);
            $root['pai_wait_ticket'] = intval($rs['pai_income_undone']);

            $root['show_goods_ticket'] = 0;
            $root['goods_ticket'] = intval($rs['goods_income_done']);
            $root['goods_wait_ticket'] = intval($rs['goods_income_undone']);

            //是否绑定支付宝 0指未绑定， 1指已绑定
            $root['binding_alipay'] = intval($profit['binding_alipay']);

            //提现开启或关闭 1：开启 0：关闭
            $root['is_refund'] = $m_config['is_refund'];

            if (intval($m_config['is_refund']) == 1) {//提现是开启的
                //开启微信还是支付宝提现
                $withdrawals_type = intval($m_config['withdrawals_type']);
                if ($withdrawals_type == 0) {
                    $root['withdrawals_wx'] = 1;
                    $root['withdrawals_alipay'] = 0;
                    $root['withdrawals_name'] = api_lang("WeChat");
                } else {
                    $root['withdrawals_wx'] = 0;
                    $root['withdrawals_alipay'] = 1;
                    $root['withdrawals_name'] = api_lang("Alipay");
                }
            } else {//提现是关闭的，微信支付宝均设为0
                $root['withdrawals_wx'] = 0;
                $root['withdrawals_alipay'] = 0;
                $root['withdrawals_name'] = '';
            }
            //提现说明
            $root['refund_explain'] = array();
            $refund_arr = explode("<br />", nl2br($m_config['refund_explain']));
            foreach ($refund_arr as $k => $v) {
                $v = ltrim(rtrim(trim($v)));
                if ($v != '') {
                    $root['refund_explain'][] = $v;
                }
            }
        }
        $root['ticket_name'] = $m_config['ticket_name'];
        ajax_return($root);
    }

    //提现领取记录
    public function extract_record()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
        } else {
            $sql = "select money,pay_time,create_time,is_pay from " . DB_PREFIX . "user_refund  where is_pay in (1,3) and user_id =" . $user_id;
            $list = $GLOBALS['db']->getAll($sql, true, true);
            if ($list) {
                foreach ($list as $k => $v) {
                    if ($v['is_pay'] == 3) {
                        $totle_money += $v['money'] * 100;
                    }
                    $record[$k]['money'] = number_format($v['money'], 2);
                    if ($v['pay_time'] != 0) {
                        $record[$k]['pay_time'] = date("Y年m月d日", $v['pay_time']);
                    }
                    $record[$k]['is_pay'] = intval($v['is_pay']);
                    $record[$k]['create_time'] = date("Y年m月d日", $v['create_time']);

                }
            } else {
                $record = array();
            }

            $root['total_money'] = number_format(intval($totle_money) / 100, 2);
            $root['status'] = 1;
            $root['error'] = '';//提现记录
            $root['list'] = $record;
        }

        ajax_return($root);
    }

    //支付宝提现绑定接口
    public function binding_alipay()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $alipay_name = trim($_REQUEST['alipay_name']);
            $alipay_account = trim($_REQUEST['alipay_account']);

            if ($alipay_name != '' && $alipay_account != '') {
                $alipay = array();
                $alipay['alipay_name'] = strim($alipay_name);
                $alipay['alipay_account'] = strim($alipay_account);
                $alipay['binding_alipay'] = 1;
                $where = "id=" . $user_id;
                $result = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $alipay, "UPDATE", $where);

                if (!$result) {
                    $root['error'] = api_lang("Binding_failed");
                    $root['status'] = 0;
                } else {
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    $user_ticket_info = $user_redis->update_db($user_id, $alipay);

                    $root['error'] = api_lang("Binding_succeeded");
                    $root['status'] = 1;
                }
            } else {
                $root['error'] = api_lang("Alipay_account_can_not_be_empty");
                $root['status'] = 0;
            }
        }
        ajax_return($root);
    }

    //支付宝提现接口
    public function submit_refund_alipay()
    {
        $root = array('status' => 1, 'error' => api_lang("success"));
        $user_id = intval($_REQUEST['user_id']);
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
        } else {
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $ticket = intval($_REQUEST['ticket']);//提现印票

            //判断是否在直播中，如是则不让进入提现界面
            $is_live = $GLOBALS['db']->getRow("select user_id,live_in from " . DB_PREFIX . "video where  user_id=" . $user_id . " order by id desc");
            //异常退出后，等待公会长抽成完成后才能提现ljz
            if (!empty($is_live) && $is_live['live_in'] == 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("Unable_to_withdraw_cash_temporarily");
                ajax_return($root);
            }

            $rate = $GLOBALS['db']->getOne("select alone_ticket_ratio from " . DB_PREFIX . "user where id=" . intval($user_id));
            if ($rate == '') {
                $rate = $m_config['ticket_catty_ratio'];
            }

            $memo = api_lang("Alipay_cash");
            $money = floatval($ticket * $rate);
            //未处理提现
            $ready_refund_id = intval($GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_refund where user_id = " . intval($user_id) . " and (is_pay =0 or is_pay=1)"));
            if ($ready_refund_id) {
                $root['error'] = api_lang("There_are_outstanding_withdrawals");
                $root['status'] = 0;
                ajax_return($root);
            }
            //会员当前印票
            $user_ticket_info = $GLOBALS['db']->getRow("select ticket,refund_ticket from " . DB_PREFIX . "user where id = '" . intval($user_id) . "'");
            $user_ticket = $user_ticket_info['ticket'] - $user_ticket_info['refund_ticket'];//可使用的印票
            //超额判断
            if ($ticket > $user_ticket) {
                $root['error'] = api_lang("No_more_than_available_withdrawal");
                $root['status'] = 0;
                ajax_return($root);
            }
            // 进入每月提现一次流程
            $month_carry_one = intval($m_config['month_carry_one']) ? 1 : 0;//提现配置，1：每月提现1次，0：无限制
            if ($month_carry_one) {
                $ready_refund_info = $GLOBALS['db']->getRow("select pay_time from " . DB_PREFIX . "user_refund where user_id = " . intval($user_id) . " and is_pay = 3");
                $pay_time = $ready_refund_info['pay_time'];
                //本月是否有提现
                if ($pay_time != '' && (to_date($pay_time, "Ym") == to_date(get_gmtime(), 'Ym'))) {
                    $root['error'] = api_lang("Cash_has_been_withdrawn_this_month");
                    $root['status'] = 0;
                    ajax_return($root);
                } else {
                    //查看本月允许提现时间，精确计算到天
                    if ((to_date(get_gmtime(), 'd') > intval($m_config['month_carry_max']) || to_date(get_gmtime(), 'd') < intval($m_config['month_carry_min'])) && intval($m_config['month_carry_max']) != 0 && intval($m_config['month_carry_min']) != 0) {
                        $root['error'] = api_lang("monthly") . intval($m_config['month_carry_min']) . api_lang("day").api_lang("reach") . intval($m_config['month_carry_max']) . api_lang("day").api_lang("To_withdraw_cash");
                        $root['status'] = 0;
                        ajax_return($root);
                    }
                }
            }
            //百媚模式下代理会员提现
            if (defined('OPEN_BM') && OPEN_BM) {
                $bm_config = load_auto_cache("bm_config");
                $bm_pid = intval($bm_config['bm_pid']);
                $bm_user = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id=" . intval($user_id) . " and( bm_pid=" . $bm_pid . " or bm_pid=0)");
                $bm_promoter = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "bm_promoter where user_id=" . intval($user_id));
                if ($bm_user == '' || $bm_promoter) {
                    $root['error'] = $m_config['bm_point'];
                    $root['status'] = 0;
                    ajax_return($root);
                }

            }


            //如果开启公会并且开启无抽成模式，支付宝 将无法提现ljz
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE == 1 && $m_config['society_pattern'] == 2) {
                $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_id);
                if (intval($society_info['society_chieftain']) == 1) {
                    $root['error'] = api_lang("Withdrawal_by_Chairman");
                    $root['status'] = 0;
                    ajax_return($root);
                } elseif (intval($society_info['society_id'])) {
                    $root['error'] = api_lang("association_does_not_withdraw_cash");
                    $root['status'] = 0;
                    ajax_return($root);
                }
            }

            //提现最小值
            $ticket_catty_min = $m_config['ticket_catty_min'] > 1 ? $m_config['ticket_catty_min'] : 1;
            //最小判断
            if ($money < $ticket_catty_min) {
                $root['error'] = api_lang("Withdrawal_cannot_be_less_than") . $ticket_catty_min . api_lang("Yuan");
                $root['status'] = 0;
                ajax_return($root);
            }

            //取用户当日提现金额之和
            //create_time储存的是格林威治时间。使用时需转换为北京时间
            $refunded_money_sql = "select sum(money) from " . DB_PREFIX . "user_refund where user_id=$user_id and (is_pay=0 or is_pay=1 or is_pay=3) 
			                        and DATE_FORMAT(FROM_UNIXTIME(create_time+28800),'%Y-%m-%d')=DATE_FORMAT(NOW(),'%Y-%m-%d')";
            $refunded_money = $GLOBALS['db']->getOne($refunded_money_sql);
            $total_money = floatval($refunded_money) + $money;
            //提现最大值
            $day_cash_max = intval($m_config['day_cash_max']);
            //总和判断
            if ($total_money > $day_cash_max) {
                $root['error'] = api_lang("No_more_than_daily_withdrawal") . $day_cash_max . api_lang("Yuan");
                $root['status'] = 0;
                ajax_return($root);
            }

            $refund_data['money'] = $money;
            $refund_data['user_bank_id'] = -1;
            $refund_data['ticket'] = $ticket;
            $refund_data['user_id'] = $user_id;
            $refund_data['create_time'] = NOW_TIME;
            $refund_data['memo'] = $memo;
            $refund_data['partner_trade_no'] = to_date(NOW_TIME, "Ymdhi") . rand(10000, 99999);
            $refund_data['withdrawals_type'] = 1;
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user_refund", $refund_data);
        }
        ajax_return($root);
    }

    /**
     * 用户充值界面
     */
    public function recharge()
    {
        $root = array('status' => 1, 'error' => '');
        $user_id = intval($_REQUEST['user_id']);
        $user_token = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id && $user_token != $user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
        } else {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $root['diamonds'] = $user_redis->getOne_db($user_id, 'diamonds');
            //充值规则
            $sql = "select id,name,money,diamonds from " . DB_PREFIX . "recharge_rule where  is_effect =1 and is_delete=0 order by sort desc";
            $root['rule'] = $GLOBALS['db']->getAll($sql, true, true);
            //充值规则
            $sql = "select id,name,class_name from " . DB_PREFIX . "payment where  is_effect =1 order by sort desc";
            $root['payment'] = $GLOBALS['db']->getAll($sql, true, true);

        }
        $m_config = load_auto_cache("m_config");
        $root['diamonds_name'] = $m_config['diamonds_name'];
        ajax_return($root);
    }


    //联系客服
    public function customer_service()
    {
        $root = array('status' => 1, 'error' => '');
        //联系客服
        $sql = "select c.id from " . DB_PREFIX . "article as a left join " . DB_PREFIX . "article_cate as c on c.id = a.cate_id where c.title ='联系客服' and c.is_effect =1 and a.is_effect=1";
        $cate_id = $GLOBALS['db']->getOne($sql);
        $data = 'http://' . $_SERVER['HTTP_HOST'] . '/wap/index.php?ctl=settings&act=article_show&cate_id=' . $cate_id;

        $root['data'] = $data;
        ajax_return($root);
    }
}

?>