<?php

/**
 * Created by PhpStorm.
 * User: weipeng
 * Date: 2017/9/16
 * Time: 1:48
 */
use think\Db;
class agent_adminModule
{
    protected $user_agency;
    /**
    * status 0错误  1 成功 2跳转登录页面
     */
    public function __construct()
    {
        header("Access-Control-Allow-Origin: *");
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization, x-token");
            header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS,PATCH');
            exit;
        }
        $token = strim($_REQUEST['token']);
        $is_login = intval($_REQUEST['is_login']);
        if ($token) {
           $user_agency = Db::name('agency')->where("token =  '".$token."'")->find();
           if (!$user_agency) {
               // 跳转登录页面
               $root = array('status' => 2, 'error' => api_lang('parameter_error'));
               api_ajax_return($root);
           }
            //用户登录信息
            $this->user_agency = $user_agency;
        }else{
            if($is_login == 0) {
                // 不是登录的判断token
                $root = array('status' => 2, 'error' => api_lang('parameter_error'));
                api_ajax_return($root);
            }
        }
    }
    /**
    * 创建充值代理账号
     */
    public function register_agency(){
        $root = array('status' => 0, 'error' => api_lang('Login_failed'));
        $username = strim($_REQUEST['username']);
        $account = strim($_REQUEST['account']);
        $password = strim($_REQUEST['password']);
        $confirm_password = strim($_REQUEST['confirm_password']);
    //    $status = intval($_REQUEST['status']);
        $id = intval($_REQUEST['id']);

        if(!$username){
            // 昵称不存在
            $root['error'] = api_lang("Please_enter_your_nickname");
            api_ajax_return($root);
        }
        if(!$account){
            // 账户不存在
            $root['error'] = api_lang("Please_enter_account_number");
            api_ajax_return($root);
        }
        if(!$password){
            // 密码错误
            $root['error'] = api_lang("Enter_at_least_6_digits_of_password");
            api_ajax_return($root);
        }
        if ($password != $confirm_password) {
            // 密码错误
            $root['error'] = api_lang("Password_inconsistency");
            api_ajax_return($root);
        }
        $where = "login ='".$account."'";
        $where .= $id ? " and id !=".$id : "";
        $login = Db::name('agency')->where($where)->find();
        if ($login) {
            // 账号重复
            $root['error'] = api_lang("Account_already_exists");
            api_ajax_return($root);
        }
        $add = array(
            'login' => $account,
            'psd' => md5($password),
            'name' => $username,
       //     'status' => $status,
        );
        if($this->user_agency['platform_level'] == 3) {
            $root['error'] = api_lang("Insufficient_authority");
            api_ajax_return($root);
        }
        $agency_status = false;
        if ($id) {
            $agency = Db::name('agency')->where('id = '.$id)->find();
            if ($agency['first_superior_id'] == $this->user_agency['id'] || $agency['two_superior_id'] == $this->user_agency['id']) {
                // 修改
                $agency_status = Db::name('agency')->where('id = '.$id)->update($add);
            }else{
                $root['error'] = api_lang("Insufficient_authority");
                api_ajax_return($root);
            }
        }else{
            // 添加
            if($this->user_agency['platform_level'] == 1) {
                $add['first_superior_id'] = $this->user_agency['id'];
                $add['two_superior_id'] = 0;
                $add['platform_level'] = 2;
            }else {
                $add['first_superior_id'] = $this->user_agency['first_superior_id'];
                $add['two_superior_id'] = $this->user_agency['id'];
                $add['platform_level'] = 3;
            }
            $add['create_time'] = NOW_TIME;
            $agency_status = Db::name('agency')->insert($add);
        }
        if ($agency_status !== false) {
            $root['status'] = 1;
            $root['error'] = api_lang("operation_was_successful");
        }else{
            $root['error'] = api_lang("operation_failed");
        }

        api_ajax_return($root);
    }
    /***
    *  获取移动端充值后台余额数据
     */
    public function get_index(){
        $root = array('status' => 1, 'error' => api_lang('parameter_error'));
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        $root['data'] = array(
            'coin' => $this->user_agency['coin'],
            'diamond' => $m_config['diamonds_name'],
            'text' => $m_config['recharge_background_instructions']
        );
        api_ajax_return($root);
    }
    /**
    *  通过用户id检测用户是否存在
     * touid 要充值的用户或代理id
     * type 2用户1代理
     */
    public function detection_user(){
        $root = array('status' => 0, 'error' => api_lang('user_does_not_exist'));
        $touid = intval($_REQUEST['touid']);
        $type = intval($_REQUEST['type']);
        if($type == 1){
            // 充值代理id
            $agency = Db::name('agency')->where("id =".$touid)->find();
            if(!$agency) {
                api_ajax_return($root);
            }
            $nick_name = $agency['name'];
            $id = $touid;
            $luck_num= '';
            $head_image = '';
        }else{
            // 充值用户id
            $user = Db::name('user')->where("id =".$touid." or luck_num=".$touid)->find();
            if(!$user) {
                api_ajax_return($root);
            }
            $nick_name = emoji_decode($user['nick_name']);
            $id = $user['id'];
            $luck_num= $user['luck_num'];
            $head_image = get_spec_image($user['head_image']);
        }
        $root['status'] = 1;
        $root['data'] = array(
            'nick_name' => $nick_name,
            'id' => $id,
            'luck_num' => $luck_num,
            'avatar'=> $head_image
        );
        api_ajax_return($root);
    }
    /**
    * 充值代理给用户(或代理)充值
     */
    public function user_recharge(){
        $root = array('status' => 0, 'error' => api_lang('user_does_not_exist'));
        $touid = intval($_REQUEST['touid']);
        $type = intval($_REQUEST['type']);
        $coin = intval($_REQUEST['coin']);
      //  $confirmed_coin = intval($_REQUEST['confirmed_coin']);
        if ($coin <= 0) {
            $root['error'] = api_lang('amount_entered_is_incorrect');
            api_ajax_return($root);
        }
        if($coin > $this->user_agency['coin']) {
            $root['error'] = api_lang('insufficient_balance');
            api_ajax_return($root);
        }

        $agency_superior_id = 0;
        if ($type == 1) {
            // 给代理后台充值 - 充值代理id
            $user = Db::name('agency')->where("id =".$touid)->find();
            $agency_superior_id =  $user['two_superior_id'] ? $user['two_superior_id'] : $user['first_superior_id'];
            $old_coin = $user['coin'];
        }else{
            // 给用户充值 - 充值用户id
            $user = Db::name('user')->where("id =".$touid)->find();
            $old_coin = $user['diamonds'];
        }
        if(!$user) {
            api_ajax_return($root);
        }

// 需要处理缓存
        Db::startTrans();
        try {
            // 扣除代理后台余额数量
            Db::name('agency')->where("id =".$this->user_agency['id'])->dec('coin',$coin)->inc('consumption_coin',$coin)->update();
            $agency_log = array(
                'coin' =>$coin,
                'old_coin' => $old_coin,
                'create_time' =>  NOW_TIME,
                'type'=> $type == 1 ? 1 : 2,
                'operator_id' => $this->user_agency['id'],
                'operator_old_coin' =>$this->user_agency['coin'],
                'platform_level' => $this->user_agency['platform_level'],
                'first_superior_id' => $this->user_agency['first_superior_id'],
                'two_superior_id' => $this->user_agency['two_superior_id'],
                'agency_superior_id' => $agency_superior_id,
            );
            if ($type == 1) {
                $agency_log['agency_id'] = $touid;
                // 增加收益
                Db::name('agency')->where("id =".$touid)->inc('coin_total',$coin)->inc('coin',$coin)->update();
            }else{
                $agency_log['uid'] = $touid;
                // 增加收益
                Db::name('user')->where("id =".$touid)->inc('diamonds',$coin)->update();
                // 用户增加收益记录
                add_user_consumption_log(0, $touid, 0, api_lang('agent_recharge').$this->user_agency['id']."-".$coin, 0, $coin, 11);
                //发送系统消息
                $add = array(
                    'title'=> api_lang("agent_recharge"),
                    'content' => api_lang("agent_recharge").":" . $coin,
                    'users' => $touid,
                    'type' => 1,
                    'addtime' => NOW_TIME
                );
                Db::name('pub_msgs')->insert($add);
            }
            Db::name('agency_log')->insert($agency_log);
            $root['status'] = 1;
            $root['error'] = api_lang('Successful_recharge');
            //提交事务
            Db::commit();
        }catch (Exception $e) {
            $root['error'] = $e->getMessage();
            // 回滚事务
            Db::rollback();
        }
        $root['data'] = array(

        );
        api_ajax_return($root);
    }
    /**
    * 查询充值记录
     */
    public function user_recharge_log(){
        $root = array('status' => 1, 'error' => api_lang('user_does_not_exist'));
        $page = intval($_REQUEST['page']);
        $type = intval($_REQUEST['type']);
        $limit = intval($_REQUEST['limit']) > 0 ? intval($_REQUEST['limit']) : 20;
        $StartTime = strim($_REQUEST['StartTime']);
        $EndTime = strim($_REQUEST['EndTime']);
        $SearchUid = intval($_REQUEST['SearchUid']);

        $p = $page > 0 ? $page * $limit : 0;
        $where = "l.operator_id=".$this->user_agency['id'];
        $where .= $StartTime ? " and l.create_time >=".strtotime($StartTime) : '';
        $where .= $EndTime ? " and l.create_time <".strtotime($EndTime) : '';


        if ($type == 1) {
            $where .= $SearchUid ? " and l.agency_id =".$SearchUid : '';
            $where .=" and type = 1";
            $field="l.agency_id as uid,u.name as name,l.coin,l.create_time";
            $list = Db::name('agency_log')->alias("l")
                ->join("agency u","u.id=l.agency_id")
                ->where($where)
                ->field($field)
                ->order("l.create_time desc")
                ->limit($p, $limit)
                ->select();
            $count = Db::name('agency_log')->alias("l")
                ->join("agency u","u.id=l.agency_id")
                ->where($where)
                ->count();
            $sum = Db::name('agency_log')->alias("l")
                ->join("agency u","u.id=l.agency_id")
                ->where($where)
                ->sum("l.coin");
        } else {
            $where .= $SearchUid ? " and l.uid =".$SearchUid : '';
            $where .=" and type = 2";
            $field="l.uid,u.nick_name as name,l.coin,l.create_time";
            $list = Db::name('agency_log')->alias("l")
                ->join("user u","u.id=l.uid")
                ->where($where)
                ->field($field)
                ->order("l.create_time desc")
                ->limit($p, $limit)
                ->select();
            $count = Db::name('agency_log')->alias("l")
                ->join("user u","u.id=l.uid")
                ->where($where)
                ->count();
            $sum = Db::name('agency_log')->alias("l")
                ->join("user u","u.id=l.uid")
                ->where($where)
                ->sum("l.coin");
        }
        foreach ($list as &$v){
            $v['name'] = emoji_decode($v['name']);
            $v['create_time'] = date('Y-m-d H:i',$v['create_time']);
        }
        $root['data'] = array(
            'currentPage' => $page + 1,
            'total' => $count,
            'totalAmount' => $sum,
            'list' => $list
        );
        api_ajax_return($root);
    }
    /**
     * 查询收益记录
     */
    public function user_income_log(){
        $root = array('status' => 1, 'error' => api_lang('user_does_not_exist'));
        $page = intval($_REQUEST['page']);
        $limit = intval($_REQUEST['limit']) > 0 ? intval($_REQUEST['limit']) : 20;
        $StartTime = strim($_REQUEST['StartTime']);
        $EndTime = strim($_REQUEST['EndTime']);
        $SearchUid = intval($_REQUEST['SearchUid']);

        $p = $page > 0 ? $page * $limit : 0;
        $where = "l.agency_id=".$this->user_agency['id'];
        $where .= $StartTime ? " and l.create_time >=".strtotime($StartTime) : '';
        $where .= $EndTime ? " and l.create_time <".strtotime($EndTime) : '';
        $where .= $SearchUid ? " and l.operator_id =".$SearchUid : '';

        $field="u.name as name,l.coin,l.create_time";
        $list = Db::name('agency_log')->alias("l")
            ->join("agency u","u.id=l.operator_id","left")
            ->where($where)
            ->field($field)
            ->order("l.create_time desc")
            ->limit($p, $limit)
            ->select();
        $count = Db::name('agency_log')->alias("l")
            ->where($where)
            ->count();
        $sum = Db::name('agency_log')->alias("l")
            ->where($where)
            ->sum("l.coin");
        foreach ($list as &$v){
            $v['create_time'] = date('Y-m-d H:i',$v['create_time']);
        }
        $root['data'] = array(
            'currentPage' => $page + 1,
            'total' => $count,
            'totalAmount' => $sum,
            'list' => $list
        );
        api_ajax_return($root);
    }
    /**
    * 获取本代理下的充值代理列表
     */
    public function agency_list(){
        $root = array('status' => 1, 'error' => api_lang('user_does_not_exist'));
        $page = intval($_REQUEST['page']);
        $limit = intval($_REQUEST['limit']) > 0 ? intval($_REQUEST['limit']) : 20;
        $p = $page > 0 ? $page * $limit : 0;
        $field="id,name,login,coin,status";
        if ($this->user_agency['platform_level'] == 1) {
            $where = "first_superior_id=".$this->user_agency['id']." and two_superior_id=0";
        } else {
            $where = "two_superior_id=".$this->user_agency['id'];
        }
        $list = Db::name('agency')
            ->where($where)
            ->field($field)
            ->order("create_time desc")
            ->limit($p, $limit)
            ->select();
        $count = Db::name('agency_log')
            ->where($where)
            ->count();
        $root['data'] = array(
            'currentPage' => $page + 1,
            'total' => $count,
            'list' => $list
        );
        api_ajax_return($root);
    }
    /**
    * 登录验证
     */
    public function login(){
        $root = array('status' => 0, 'error' => api_lang('Login_failed'));
        $username = strim($_REQUEST['username']);
        $password = strim($_REQUEST['password']);

        if(!$username){
            // 登录失败,账户不存在
            $root['error'] = api_lang("user_does_not_exist");
            api_ajax_return($root);
        }
        if(!$password){
            // 密码错误
            $root['error'] = api_lang("Re_enter_the_password");
            api_ajax_return($root);
        }
        $login = Db::name('agency')->where("login ='".$username."'")->find();
        if (!$login || $login['status'] != 1) {
            api_ajax_return($root);
        } else {
            if ($login['psd'] != md5($password)){
                // 密码错误
                $root['error'] = api_lang("Re_enter_the_password");
                api_ajax_return($root);
            }
            //登录成功 -- 生成用户token
            $token = md5($login['login'] . $login['id'] . time() . 'bogo');
            // 更新登录信息
            $update =array(
                'login_ip' => get_client_ip(),
                'login_time' => NOW_TIME,
                'token' => $token
            );
            //重新保存记录
            Db::name('agency')->where('id = '.$login['id'])->update($update);

            // recharge_background_level

            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $is_agent_authority = 0;
            if ($login['platform_level'] < $m_config['recharge_background_level']) {
                // 是否有权限开启下级代理
                $is_agent_authority = 1;
            }
            $root['status'] = 1;
            $root['data']['token'] = $token;
            $root['data']['name'] = $login['name'];
            $root['data']['platform_level'] = $login['platform_level'];
            $root['data']['is_agent_authority'] = $is_agent_authority;
            $root['data']['id'] = $login['id'];

        }
        api_ajax_return($root);
    }

    /**
    * 退出
     */
    public function logout(){
        $root = array('status' => 1, 'error' => api_lang('Operation_completed'));
        $token = strim($_REQUEST['token']);
        if (!empty($token)) {
            Db::name('agency')->where("token =  '".$token."'")->update(['token'=>0]);
        }
        api_ajax_return($root);
    }
}