<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------
use QCloud\COSSTS\Sts;
use Qiniu\Auth;
use Qiniu\Storage\UploadManager;
use think\Db;

class appModule extends baseModule
{
    /**
    * 测试接口
     * */
    public function ceshi(){
        $user_id= 168159;
        $room_id = $GLOBALS['db']->getOne("SELECT id FROM  " . DB_PREFIX . "video WHERE user_id=" . $user_id . " and live_in=1 and is_voice=0");
        if ($room_id) {
            $date = date('Y-m-d');
            $live_duration_key = "mission_calculate_time_" . $date . "_" . $room_id; // 任务计算开始时间
            $begin_time = time() - 60*60*2;
            redis_set($live_duration_key, $begin_time, 60 * 60 * 24);
        }
       var_dump($room_id);
    }
    /**
     * 初始化接口
     */
    public function init()
    {
        //$this->checkCountryAreaAvailable();

        //客服端手机类型dev_type=android;dev_type=ios
        $dev_type = strim($_REQUEST['sdk_type']);

        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        $sdk_version = strim($_REQUEST['sdk_version']);
        $root = array();

        $root['status'] = 1;

        $m_config = load_auto_cache("m_config");//初始化手机端配置
        //直播公告消息
        $root['listmsg'] = load_auto_cache("article_notice");
        //API接口地址
        $root['api_link'] = load_auto_cache("api_list");

        //sdk_type 0:使用腾讯SDK、1：使用金山SDK
        $root['sdk_type'] = get_sdk_info($m_config['video_type']);
        //是否开启pk
        $root['is_pk'] = $m_config['is_pk'];

        $root['sina_app_api'] = intval($m_config['sina_app_api']);
        $root['wx_app_api'] = intval($m_config['wx_app_api']);
        $root['qq_app_api'] = intval($m_config['qq_app_api']);
        $root['facebook_app_api'] = intval($m_config['is_share_facebook']);
        //创建直播时 默认选中分享按钮，0:不选中;1:微信;2:微信朋友圈;3:QQ;4:微博; 5facebook
        $root['selected_app_api'] = 0;
        //使用sdk登陆,如果使用sdk登陆时,在访问webveiw时,需要传输session_id参数;
        $root['has_sdk_login'] = 1;
        //支持新浪登陆
        $root['has_sina_login'] = intval($m_config['has_sina_login']);
        //支持微信登陆
        $root['has_wx_login'] = intval($m_config['has_wx_login']);
        //支持qq登陆
        $root['has_qq_login'] = intval($m_config['has_qq_login']);
        //支持facebook登录
        $root['has_facebook_login'] = intval($m_config['facebook_login']);
        //支持手机登陆(注册)
        $root['has_mobile_login'] = intval($m_config['has_mobile_login']);
        //支持手机登陆(注册)
        $root['danmu_level'] = intval($m_config['danmu_level']);
        //支持google登录
        $root['has_google_login'] = intval($m_config['google_login']);
        // 支持line登录
        $root['has_line_login'] = intval($m_config['line_login']);

        //腾讯直播配置
        $root['tencent_video_sdk_key'] = $m_config['tencent_video_sdk_key'];
        $root['tencent_video_sdk_licence'] = $m_config['tencent_video_sdk_licence'];
        $root['tencent_live_sdk_key'] = $m_config['tencent_live_sdk_key'];
        $root['tencent_live_sdk_licence'] = $m_config['tencent_live_sdk_licence'];

        //视频上传类型0阿里云OSS、1腾讯云点播
        $root['short_video_store'] = $m_config['short_video_store'];

        //兼容分销屏蔽登录功能
        if (intval('OPEN_DISTRIBUTION') == 1 && intval($m_config['distribution']) == 1) {
            //支持微信登陆
            $root['has_wx_login'] = intval($m_config['distribution_wx']);
            //支持新浪登陆
            $root['has_sina_login'] = intval($m_config['distribution_sina']);
            //支持qq登陆
            $root['has_qq_login'] = intval($m_config['distribution_qq']);
        }

        //0:显示状态栏;1隐藏状态栏
        $root['statusbar_hide'] = 0;

        $theme = intval($m_config['app_theme']);
        if ($theme == 1) {//1: green #1cd39b
            $color_code = '#1cd39b';
            if (defined('QK_TREE') && QK_TREE) {
                $color_code = '#ffffff';
            }
        } else {//0或其他: default #ff7551
            $color_code = '#ff7551';
        }
        $root['statusbar_color'] = $color_code;// '#55ACEF';//状态栏,颜色
        $root['topnav_color'] = $color_code;//'#55ACEF';//顶部导航栏,颜色
        //启动时的广告图
        $root['ad_img'] = '';
        //启动时的广告连接内容
        $root['ad_http'] = '';
        //点击广告内容，打开方式：0:在第一个webveiw中打开;1:新建一个webview打开连接
        $root['ad_open'] = 0;

        $root['site_url'] = SITE_DOMAIN;//.'/theme/index.php';//h5首页地址
        //$root['api'] = SITE_DOMAIN.APP_ROOT.'/service/index.php';//api地址
        //秒；程序暂停，超过 60 秒，再进去时，需要重新清空程序加载
        $root['reload_time'] = 60;


        $root['monitor_second'] = 10;//主播心跳监听，每10秒监听一次;监听数据：时间点，印票数，房间人数
        $root['jr_user_level'] = intval($m_config['jr_user_level']);//加入房间时,如果用户等级超过或等于jr_user_level时，有用户进入房间提醒操作
        $root['bullet_screen_diamond'] = $m_config['barrage_coin'];//弹幕一次消费的金币

        //SPEAR引擎配置
        $root['spear_live'] = 'LiveHost';//主播
        $root['spear_normal'] = 'NormalGuest';//观众
        $root['spear_interact'] = 'InteractUser';//连麦

        $root['privacy_title'] = "《" . api_lang('User_privacy_policy') . "》";
        $root['privacy_link'] = SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=app&act=privacy';

        //$root['agreement_title'] = "主播协议";
        $root['agreement_link'] = SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=app&act=agreement';

        $root['short_name'] = strim($m_config['short_name']);
        $root['ticket_name'] = strim($m_config['ticket_name']);
        $root['diamonds_name'] = strim($m_config['diamonds_name']);

        $root['beauty_ios'] = intval($m_config['beauty_ios']);//IOS美颜度，默认值
        $root['beauty_android'] = intval($m_config['beauty_android']);//ANDROID美颜度，默认值

        $root['beauty_close'] = intval($m_config['beauty_close']);//4、客户端不许自义美颜度; 0:开;1:关; 当beauty_close=1时,美颜功能只有 开/关；美颜值直接取：服务端返回的值
        $root['beauty_close'] = 0;
        //$root['service_push'] =intval($m_config['service_push']);//是否开启全服推送 0： 不开启 推送给粉丝 1：开启
        $root['app_name'] = strim($m_config['app_name']);//app名称    直播
        $root['share_title'] = strim($m_config['share_title']);//分享标题  你丑你先睡，我美我直播
        $root['has_save_video'] = intval($m_config['has_save_video']);//保存视频（可用于回播）
        $root['account_name'] = strim($m_config['account_name']);//app账号名称  账号

        //美颜KEY
        $root['bogo_beauty_key'] = strim($m_config['bogo_beauty_key']);

        $root['ip_info'] = get_ip_info();

        $root['city'] = $root['ip_info']['city'];

        //地区列表版本号
        $root['region_versions'] = intval($m_config['region_versions']);
        //$root['request'] = print_r($_SERVER['HTTP_USER_AGENT'],1);
        //$root['ios_check_version'] = $m_config['ios_check_version'];
        //正在审核的版本,只显示：苹果支付
        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
            $root['auto_login'] = 0;//自动创建帐户登陆;苹果审核跟云测试时使用

            $root['sina_app_api'] = 0;
            $root['wx_app_api'] = 0;
            $root['qq_app_api'] = 0;
            $root['facebook_app_api'] = 0;
            $root['selected_app_api'] = 0;//创建直播时 默认选中分享按钮，0:不选中;1:微信;2:微信朋友圈;3:QQ;4:微博;

            $root['has_sdk_login'] = 1;//使用sdk登陆,如果使用sdk登陆时,在访问webveiw时,需要传输session_id参数;

            $root['has_sina_login'] = 0;//支持新浪登陆
            $root['has_wx_login'] = 0;//支持微信登陆
            $root['has_qq_login'] = 0;//支持qq登陆
            $root['has_mobile_login'] = 1;//intval($m_config['has_mobile_login']);//支持手机登陆(注册)

            //1:可升级;0:不可升级
            $root['version'] = $this->version2($dev_type, $sdk_version, $sdk_version_name);//版本升级检查

            //购物竞拍配置开关
            $root['pai_real_btn'] = 0;
            $root['pai_virtual_btn'] = 0;
            $root['shopping_goods'] = 0;
            $root['open_pai_module'] = 0;
            $root['shop_shopping_cart'] = 0;
            $root['open_podcast_goods'] = 0;

            //是否开启游戏字段
            $root['open_game_module'] = 0;
            //是否开启上庄模块
            $root['open_banker_module'] = 0;
            //是否开启赠送游戏币模块
            $root['open_send_coins_module'] = 0;
            // 游戏分销
            $root['game_distribution'] = 0;
            $root['open_send_diamonds_module'] = 0;

            //是否开启钻石游戏
            /**
             * 未开启游戏默认为1
             */
            $root['open_diamond_game_module'] = 1;

            // 是否加载首页假数据
            $root['fake_index'] = 1;
            /*
             * 版本审核中
             */
            $ios_check_version = 1;
        } else {
            $root['auto_login'] = 0;

            $root['version'] = $this->version2($dev_type, $sdk_version, '');//版本升级检查

            //JP配置开关
            $root['pai_real_btn'] = 0;
            $root['pai_virtual_btn'] = 0;
            $root['shopping_goods'] = 0;
            $root['open_pai_module'] = 0;
            $root['shop_shopping_cart'] = 0;
            $root['open_podcast_goods'] = 0;

            //是否开启游戏字段
            $root['open_game_module'] = intval(OPEN_GAME_MODULE);
            //是否开启上庄模块
            $root['open_banker_module'] = intval(OPEN_BANKER_MODULE) ? 1 : 0;
            //是否开启赠送游戏币模块
            $root['open_send_coins_module'] = intval(OPEN_SEND_COINS_MODULE);
            $root['open_send_diamonds_module'] = intval(OPEN_SEND_DIAMONDS_MODULE);

            //是否开启钻石游戏
            /**
             * 未开启游戏默认为1
             */
            $root['open_diamond_game_module'] = intval(intval(OPEN_DIAMOND_GAME_MODULE) || !intval(OPEN_GAME_MODULE));
            //游戏分销
            $root['game_distribution'] = intval(GAME_DISTRIBUTION);

            // 是否加载首页假数据
            $root['fake_index'] = 0;
        }
        //$root['auto_login'] = 1;

        //苹果审核版本号
        $root['ios_check_version'] = $m_config['ios_check_version'];


        //家族开关
        $root['open_family_module'] = intval(OPEN_FAMILY_MODULE);
        //贵族开关
        $root['open_noble'] = intval(OPEN_NOBLE);

        //公会开关ljz
        //$root['open_society_module']= intval(OPEN_SOCIETY_MODULE);
        if (defined("OPEN_SOCIETY_MODULE") && OPEN_SOCIETY_MODULE == 1) {
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            if ($m_config['society_pattern'] == 0) {
                $root['open_society_module'] = 0;
            } else {
                $root['open_society_module'] = 1;
                if ($m_config['society_list_name'] == '') {
                    $root['society_list_name'] = api_lang('guild');
                } else {
                    $root['society_list_name'] = $m_config['society_list_name'];
                }
            }
        } else {
            $root['open_society_module'] = 0;
        }

        //APP端公会开关
        $root['open_society_app'] = intval(OPEN_SOCIETY_APP) ? intval(OPEN_SOCIETY_APP) : 0;

        //每日首次登录赠送积分开关
        $root['open_login_send_score'] = intval(OPEN_LOGIN_SEND_SCORE);

        $root['o2o_open_goods'] = 0;
        //登录赠送积分值
        $root['login_send_score'] = intval($m_config['login_send_score']);

        //是否首次登录
        $root['first_login'] = es_session::get("first_login") ? es_session::get("first_login") : 0;
        es_session::set("first_login", 0);
        //每次登录时升级提示
        $root['open_upgrade_prompt'] = intval(OPEN_UPGRADE_PROMPT);
        $root['new_level'] = es_session::get("new_level") ? es_session::get("new_level") : 0;
        es_session::set("new_level", 0);

        //排行榜开关,审核期间不开
        $root['open_ranking_list'] = 0;
        if (trim($m_config['ios_check_version'] == '')) {
            $root['open_ranking_list'] = intval(OPEN_RANKING_LIST);
        }
        //启动广告
        if (!$root['open_ranking_list']) {
            //未开启排行榜，去除指向排行榜
            $root['start_diagram'] = $GLOBALS['db']->getAll("select * from " . DB_PREFIX . "index_image where show_position = 4 and `type`<>2 order by sort asc ", true, true);
        } else {
            $root['start_diagram'] = $GLOBALS['db']->getAll("select * from " . DB_PREFIX . "index_image where show_position = 4 order by sort asc ", true, true);
        }
        if (!$root['start_diagram']) {
            $root['start_diagram'] = array();
        }
        foreach ($root['start_diagram'] as $k => $v) {
            if ($v['image'] != '') {
                $root['start_diagram'][$k]['image'] = get_spec_image($v['image']);
            }
        }

        //开启邀请好友三级分销
        $root['open_invite_reward_agent'] = intval(OPEN_INVITE_REWARD_AGENT);
        $version = "20241127"; // vue版本号
        //H5链接
        $h5_url = array(
            //我的等级
            'url_my_grades' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=user_center&act=level',
            //   'url_my_grades' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=user_center&act=grade',
            'url_about_we' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=settings&act=article_show&cate_id=10',
            'url_help_feedback' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=settings&act=help',
            //商品收益h5
            'url_goods_income' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=user_center&act=income&details=1',
            //购买靓号
            'luck_num_url' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=luck&act=index",
            //守护规则　
            'guartian_details' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=guardians_old&act=details",
            //守护特效id=?
            'guartian_special_effects' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=guardians_old&act=get_guardian_details",
            //每日任务 ---传值user_id
            'task_url' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=task&act=index",
            //会员新版
            'members_url' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=vip&act=index",
            //购买座驾新版
            'pay_car' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=vehicle&act=index",
            //收礼记录
            'earnings_log_url' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=user_center&act=earnings_log",
            //购买贵族列表 user_id 
            'pay_noble' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/noble?version=" . $version,
            // 道具商城 uid token
            'shop_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/shop?version=" . $version,
            'shop_url_v_120' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/item_shop?version=" . $version,
            //我的邀请团队 token
            'invite_rewards' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/UpSharemoney?version=" . $version,
            //主播中心 token
            'emcee_center_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/emcee_center?version=" . $version,
            //我的小店 token
            'shop_product_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/my_shop?version=" . $version,
            //我的小店管理 token
            'shop_manage_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/shop_manage?version=" . $version,
            // 绑定提现账号 --- token
            'withdrawal_account_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/banding_bank?version=" . $version,
            // 主播收益记录 旧 emcee_income_log
            'emcee_income_log_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/revenue_records?version=" . $version,
            'url_recharge_agreement' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=settings&act=article_show&cate_id=28', //充值协议
            // 绑定和选择账户类型
            'bank_url' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=bank&act=index",
            // 分享下载地址【新】 invite_code
            'download_url' => SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=invite_rewards&act=download",
            // 直播间排行榜 房间富豪榜---room_id token to_uid
            'video_ranking_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/video_rich_ranking?version=" . $version,
            // 游戏列表--- uid token
            'game_list_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/game_picture_list?version=" . $version,
            // 三方游戏列表h5带背景图--- uid token
            'game_list' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/game_picture_list?version=" . $version,
            // 主播工资政策--月统计
            'month_statistics_log' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/month_statistics?version=" . $version,
            // 播放svga
            'play_svga' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/play_svga?version=" . $version,
            // 房间流水 ---uid token room_id
            'room_flow' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/room_flow?version=" . $version,
            // 排行榜 ---uid token
            'ranking_user_url' => SITE_DOMAIN . APP_ROOT . VUE_URL . "/ranking_user?version=" . $version,
        );
        // 查询绑定账号的时候是否开启了自动代付功能
        $payment = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "payment where is_modern_payment=1 and is_effect= 1 and class_name='TopPay'");
        if($payment){
            $h5_url['withdrawal_account_url'] = SITE_DOMAIN . APP_ROOT . VUE_URL . "/banding_top_bank?version=" . $version;
        }
        $root['is_open_shop'] = 0;
        //商城小店
        if (OPEN_MY_SHOP == 1) {
            $root['is_open_shop'] = 1;
        }

        if ((defined('PAI_REAL_BTN') && PAI_REAL_BTN == 1) && (defined('PAI_VIRTUAL_BTN') && PAI_VIRTUAL_BTN == 0)) {
            $h5_url['url_user_pai'] = SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_user&act=goods&is_true=1';
            $h5_url['url_podcast_pai'] = SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_podcast&act=goods&is_true=1';
        }

        $root['h5_url'] = $h5_url;

        // 是否开启脏字库
        $root['has_dirty_words'] = intval($m_config['has_dirty_words']);//当为1时,启用脏子过滤;默认0时不过滤, 即：0时不发送组合消息即可; 接收还是要处理组合消息; 主要是为了跟旧版本兼容过度一下,过度完后,这个参数将去掉;
        // 脏字库
        $root['dynamic_dirty_word'] = $m_config['dirty_words_list'];

        //将图片直接上传到OSS上,不中转;https://help.aliyun.com/document_detail/31920.html?spm=5176.doc31931.6.206.OEtePt
        $root['open_sts'] = intval($m_config['open_sts']);
        $root['sts_video_limit'] = intval($m_config['sts_video_limit']) ?: 60;
        //是否开启 强制输入话题 功能 1是 0否
        $root['must_cate'] = intval($m_config['must_cate']);

        //付费总开关
        $root['live_pay'] = 0;
        //按时付费
        $root['live_pay_time'] = 0;
        //按场付费
        $root['live_pay_scene'] = 0;
        if ((defined('OPEN_LIVE_PAY') && OPEN_LIVE_PAY == 1) && intval($ios_check_version) == 0) {
            $live_pay_info = $GLOBALS['db']->getAll("SELECT id,class FROM " . DB_PREFIX . "plugin WHERE is_effect=1 and type =1 order by sort desc");

            if ($live_pay_info) {
                foreach ($live_pay_info as $item) {
                    $live_pay[$item['id']] = $item['class'];
                }
                $root['live_pay'] = intval(OPEN_LIVE_PAY);
            }
            //按时付费
            if (intval(LIVE_PAY_TIME) == 1) {
                if (in_array('live_pay', $live_pay)) {
                    $root['live_pay_time'] = 1;
                    $root['live_pay_count_down'] = intval($m_config['live_count_down']);//进入付费模式倒计时时间
                }
            }
            //按场付费
            if (intval(LIVE_PAY_SCENE) == 1) {
                if (in_array('live_pay_scene', $live_pay)) {
                    $root['live_pay_scene'] = 1;
                }
            }
        }


        $pay_interval = intval($m_config['pay_interval']) * 60;//（分钟）扣费间隔
        $root['pay_interval'] = $pay_interval > 0 ? $pay_interval : 60;
        //最大连麦数量
        $root['mic_max_num'] = intval($m_config['mic_max_num']) > 3 ? 3 : intval($m_config['mic_max_num']);
        //分销功能
        //邀请奖励功能 依赖分销功能 分享收益开关
        if ((defined('OPEN_DISTRIBUTION') && OPEN_DISTRIBUTION == 1)) {
            $root['distribution'] = intval($m_config['distribution']) ? 1 : 0;
        } else if (intval(OPEN_REWARD_POINT) == 1) {
            $root['distribution'] = intval(OPEN_REWARD_POINT) ? 1 : 0;
        }

        //审核版本关闭分享功能
        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
            $root['distribution'] = 0;
        }

        //分销类型
        if (defined('distribution_module')) {
            $root['distribution_module'] = intval(DISTRIBUTION_MODULE);
        } else {
            $root['distribution_module'] = 0;
        }

        $root['is_invite_code'] = strim($m_config['is_invite_code']);//用户注册是否需要验证码0否1需要

        //手机验证码登录开关
        $root['open_mobile_code_login'] = intval($m_config['open_mobile_code_login']);

        $root['full_group_id'] = '';//全员广播大群群组id
        $root['on_line_group_id'] = '';//在线用户大群id
        $group_id = strim($m_config['full_group_id']);
        $online_group_id = strim($m_config['on_line_group_id']);
        //var_dump($group_id);exit;
        if ($group_id || $online_group_id) {
            require_once(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();
            $api_arr = (array)$api;

            if (intval($api_arr['status']) == 0 && $api_arr['error'] != '') {
                log_err_file(array(__FILE__, __LINE__, __METHOD__, $api_arr['error']));
                echo api_lang("im_error");
                exit;
            }
            if ($group_id) {
                $aes_key_info = get_privatekey();
                if (is_array($aes_key_info[0]['aes_key'])) {
                    $aes_key = $aes_key_info[0]['aes_key'][0];
                } else {
                    $aes_key = $aes_key_info[0]['aes_key'];
                }
                $ret = $api->group_get_group_info2(array('0' => $group_id), [], [], []);
                $root['full_group_id'] = $ret['GroupInfo'][0]['GroupId'];
                if ($ret['GroupInfo'][0]['ErrorCode']) {
                    $ret = $api->full_group_create($group_id, $aes_key);
                    if ($ret['ActionStatus'] != 'OK') {
                        log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
                        $ret = $api->full_group_create($group_id, $aes_key);
                    }
                    $root['full_group_id'] = $ret['GroupId'];
                }
            }
            if ($online_group_id) {
                $ret = $api->group_get_group_info2(array('0' => $online_group_id), [], [], []);
                $root['on_line_group_id'] = $ret['GroupInfo'][0]['GroupId'];
                if ($ret['GroupInfo'][0]['ErrorCode']) {
                    $ret = $api->full_group_create($online_group_id);
                    if ($ret['ActionStatus'] != 'OK') {
                        log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
                        $ret = $api->full_group_create($online_group_id);
                    }
                    $root['on_line_group_id'] = $ret['GroupId'];
                }
            }
        }
        $root['open_xr'] = 0;

        //按场付费直播最高最低限制
        $root['live_pay_max'] = intval($m_config['live_pay_max']);//付费直播收费最高
        $root['live_pay_min'] = intval($m_config['live_pay_min']);//付费直播收费最低
        //按场付费直播最高最低限制
        $root['live_pay_scene_max'] = intval($m_config['live_pay_scene_max']);//付费直播收费最高
        $root['live_pay_scene_min'] = intval($m_config['live_pay_scene_min']);//付费直播收费最低

        //开启vip会员
        $root['open_vip'] = 0;
        if (defined('OPEN_VIP') && intval($m_config['open_vip']) == 1) {
            $root['open_vip'] = intval(OPEN_VIP);
        }

        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号
        //是否开启私信
        $root['has_private_chat'] = intval($m_config['has_private_chat']);//开启私信 1开启 0关闭

        //视频清晰度:0标清(360*640),1高清(540*960),2超清(720*1280)
        $root['video_resolution_type'] = intval($m_config['video_resolution_type']);
        //备用域名 列表
        $domain_list = array();
        $domain_arr = explode("<br />", nl2br($m_config['domain_list']));
        foreach ($domain_arr as $k => $v) {
            $v = ltrim(rtrim(trim($v)));
            if ($v != '') {
                $domain_list[] = $v;
            }
        }
        $root['domain_list'] = $domain_list;


        //首页其他分类
        $root['video_classified'] = array();
        $video_classified = load_auto_cache("video_classified");
        if ($video_classified) {
            $root['video_classified'] = $video_classified;
        }

        //发言等级
        $root['speak_level'] = intval($m_config['speak_level']);
        //用户开启发言功能的最低等级
        $root['send_msg_lv'] = intval($m_config['send_msg_lv']);
        //用户开启私信功能的最低等级
        $root['private_letter_lv'] = intval($m_config['private_letter_lv']);
        //声网AppID
        $root['agora_app_id'] = trim($m_config['agora_app_id']);

        //手机端配置,腾讯云 账号信息
        $root['sdkappid'] = trim($m_config['tim_sdkappid']);
        $root['accountType'] = trim($m_config['tim_account_type']);
        //游客登录
        $root['has_visitors_login'] = intval($m_config['open_visitors_login']);

        $root['family_join'] = 1;//开启加入家族的按钮

        //家族加入按钮 是否显示
        if ((defined('OPEN_FAMILY_JOIN') && OPEN_FAMILY_JOIN == 1)) {
            $root['family_join'] = 0;//关闭加入家族的按钮
        }

        //直播页面取消点赞功能 1.取消点赞 0.不取消
        $root['is_no_light'] = intval($m_config['is_no_light']);

        if (defined('OPEN_PAI_MODULE') && OPEN_PAI_MODULE) {
            $root['itype'] = 'shop';
        } elseif (defined('SHOPPING_GOODS') && SHOPPING_GOODS) {
            $root['itype'] = 'shop';
        } elseif (defined('OPEN_PODCAST_GOODS') && OPEN_PODCAST_GOODS) {
            $root['itype'] = 'shop';
        }

        /*$root['diamond_name'] = '钻石';*/
        $root['diamond_name'] = strim($m_config['diamonds_name']);

        //创建直播时是否需要强制选择分类 1.需要 0.不需要
        $root['is_classify'] = intval($m_config['is_classify']);

        $root['app_logo'] = get_spec_image($m_config['app_logo']);

        //是否七牛上传 1.是 0.阿里云
        $root['is_qiniu'] = intval($m_config['files_upload_btn']);
        //七牛accessKey
        $root['qiniu_accessKey'] = $m_config['qiniu_accessKey'];
        //七牛secretKey
        $root['qiniu_secretKey'] = $m_config['qiniu_secretKey'];
        //七牛空间名
        $root['qiniu_bucket_name'] = $m_config['qiniu_bucket_name'];
        //七牛空间域名
        $root['qiniu_bucket_domain_name'] = $m_config['qiniu_bucket_domain_name'];

        //是否认证才是直播
        $root['must_authentication'] = $m_config['must_authentication'];

        //广场短视频播放形式
        $root['short_video'] = $m_config['short_video'];
        //注册成功统一默认头像
        $root['default_avatar'] = $m_config['default_avatar'];
        //SUD 游戏状态：1正式环境、2测试环境
        $root['sud_status'] = $m_config['sud_status_type'];
        //短视频分类
        $weibo_cate_list = redis_get("weibo_cate_list");
        if ($weibo_cate_list) {
            $weibo_cate_list = json_decode($weibo_cate_list, true);
            if (!is_array($weibo_cate_list)) {
                $weibo_cate_list = false;
            }
        }
        if (!$weibo_cate_list) {
            $tab = DB_PREFIX . 'weibo_cate';
            $sql = "select id, name from {$tab} where status = 0 and is_del = 0 order by sort ASC";
            $weibo_cate_list = $GLOBALS['db']->getAll($sql);
            redis_set("weibo_cate_list", json_encode($weibo_cate_list), 60 * 60 * 24 * 30);
        }

        $root['video_cate'] = $weibo_cate_list;

        // 获取热门国家
        $root['hot_country_list'] = get_hot_country_list();
        // 获取不是热门国家
        $root['country_list'] = get_country_list();
        // 获取语言类型
        $root['user_lang_list'] =get_languages_list();
        //平台用户协议
        $root['user_agreement_link'] = SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=app&act=user_agreement';
        //注销协议
        $root['user_unsubscribe'] = SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=app&act=unsubscribe';
        //提现协议
        $root['Withdrawal_agree'] = SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=app&act=Withdrawal_agree';

        /*温馨提示【合规政策】*/
        $article = redis_hget("article_list", "compliance_policy");
        if (!$article) {
            /*温馨提示【合规政策】*/
            $sql = "select a.content from " . DB_PREFIX . "article a  left join " . DB_PREFIX . "article_cate b on b.id = a.cate_id  where a.is_delete = 0 and a.is_effect = 1 and b.identification = 'Compliance_policy'";
            $article = $GLOBALS['db']->getOne($sql);
            redis_hset("article_list", "compliance_policy", $article);
        }
        $root['compliance_policy'] = $article;

        ajax_return($root);

    }

    /**
     * 获取表情包列表
     * */
    public function room_memes_type_list()
    {
        $root = array('status' => 1, 'error' => '');
        $list = Db::name('face_classify')->field("id,classify_name as name,classify_img as img")->where("status=1")->order("sort desc,id desc")->select();
        $root['list'] = $list;
        ajax_return($root);
    }

    //语音表情包列表
    public function room_memes_list()
    {
        $root = array('status' => 1, 'error' => '');
        $memes_type_id = intval($_REQUEST['memes_type_id']); // 表情分类id
        $where = "status=1";
        $where .= $memes_type_id ? " and face_classify_id =" . $memes_type_id : '';
        $list = Db::name('face_list')->field("id,img_url as img,name")->where($where)->order("sort desc,id desc")->select();
        $root['list'] = $list;
        ajax_return($root);
    }

    /**
     * 获取音乐列表
     * */
    public function get_music_list()
    {
        $root = array('status' => 1, 'error' => '');
        $page = intval($_REQUEST['page']);
        $limit = intval($_REQUEST['limit']) > 0 ? intval($_REQUEST['limit']) : 20;
        $title = strim($_REQUEST['title']);

        $p = $page > 1 ? $page * $limit : 0;
        $where = 'status=1';
        $where .= $title ? ' and title like "%' . $title . '%"' : '';
        $field = "id,title,url,music_time,music_size,format,user_name";
        $list = Db::name('music')
            ->where($where)
            ->field($field)
            ->order("sort desc,id asc")
            ->limit($p, $limit)
            ->select();
        foreach ($list as &$v) {
            $v['music_time'] = get_live_time_lenght($v['music_time']);
        }
        $root['list'] = $list;
        ajax_return($root);
    }

    /**
     * 用户隐私政策
     */
    function privacy()
    {
        header("Content-Type:text/html; charset=utf-8");
        $content = load_auto_cache("article_privacy");
        echo $content;
        exit;
    }

    /**
     * 提现协议
     */
    function Withdrawal_agree()
    {
        $article = $GLOBALS['db']->getOne('select content from ' . DB_PREFIX . "article where is_effect = 1 and title = '提现协议'");
        $root['compliance_policy'] = $article;
        echo $root['compliance_policy'];
        exit;
    }

    /**
     * 平台用户协议
     */
    function user_agreement()
    {
        header("Content-Type:text/html; charset=utf-8");

        $content = load_auto_cache("article_user");
        echo $content;
        exit;
    }

    /**
     * 注销政策
     */
    function unsubscribe()
    {
        header("Content-Type:text/html; charset=utf-8");

        $content = load_auto_cache("article_unsubscribe");
        echo $content;
        exit;
    }

    /*合规政策*/
    public function compliance_policy()
    {
        header("Content-Type:text/html; charset=utf-8");

        $content = load_auto_cache("article_policy");
        echo $content;
        exit;
    }

    /**
     * 获取下载信息
     */
    public function get_download()
    {
        $root = array('status' => 1, 'error' => '', 'data' => array());

        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $data['img'] = $m_config['download_log'];
        $data['title'] = $m_config['download_app_title'];
        $data['center'] = $m_config['download_app_introduce'];
        $data['bg_img'] = $m_config['download_bg'];
        $data['app_bg_img'] = $m_config['download_app_bg'];

        $Android_version_log = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "version_log where is_release = 1 and type = 2 order by create_time desc");
        $ios_version_log = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "version_log where is_release = 1 and type = 1 order by create_time desc");

        $data['Android'] = $Android_version_log ? $Android_version_log['url'] : $m_config['android_download_url'];
        $data['ios'] = $ios_version_log ? $ios_version_log['url'] : $m_config['ios_download_url'];
        $data['u_link_id'] = '';
        $data['um_from_appkey'] = '';
        if (INVITE_U_LINK == 1) {
            if (strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone') || strpos($_SERVER['HTTP_USER_AGENT'], 'iPad')) {
                //ios下载地址
                $data['um_from_appkey'] = $m_config['ios_ushare_umeng_appkey'];
            } else {
                // 安卓下载地址
                $data['um_from_appkey'] = $m_config['android_ushare_umeng_appkey'];
            }
            $data['u_link_id'] = $m_config['u_link_id'];
        }

        $root['data'] = $data;
        ajax_return($root);
    }

    /**
     * 主播协议
     */
    function agreement()
    {
        header("Content-Type:text/html; charset=utf-8");
        $content = load_auto_cache("article_agreement");
        echo $content;
        exit;
    }

    /**
     * 版本管理
     * @param $dev_type
     * @param $version
     * @param $sdk_version_name
     * @return array
     */
    function version2($dev_type, $version, $sdk_version_name)
    {

        $m_config = load_auto_cache("m_config");//初始化手机端配置

        $site_url = SITE_DOMAIN . APP_ROOT . "/";//站点域名;

        $root = array();
        if ($dev_type == 'android') {
            $Android_version_log = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "version_log where is_release = 1 and type = 2 order by create_time desc");

            $root['serverVersion'] = $Android_version_log ? $Android_version_log['version_number'] : $m_config['android_version'];//android版本号
            if ($version < $root['serverVersion'] && $Android_version_log && $Android_version_log['url'] != '') {
                $root['filename'] = $Android_version_log['url'];//android下载包名
                $root['android_upgrade'] = $Android_version_log['content'];//android版本升级内容
                $root['forced_upgrade'] = intval($Android_version_log['is_update']);//强制升级
                $root['hasfile'] = 1;
                $root['has_upgrade'] = 1;//1:可升级;0:不可升级
            } else {
                $root['hasfile'] = 0;
                $root['has_upgrade'] = 0;//1:可升级;0:不可升级
            }
        } else if ($dev_type == 'ios') {
            $Ios_version_log = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "version_log where is_release = 1 and type = 1 order by create_time desc");

            $root['serverVersion'] = $Ios_version_log ? $Ios_version_log['version_number'] : $m_config['ios_version'];//IOS版本号
            if ($version < $root['serverVersion'] && $Ios_version_log && $Ios_version_log['url'] != '') {
                $root['ios_down_url'] = $Ios_version_log['url'];//ios下载地址
                $root['ios_upgrade'] = $Ios_version_log['content'];//ios版本升级内容
                $root['has_upgrade'] = 1;//1:可升级;0:不可升级
                $root['forced_upgrade'] = intval($Ios_version_log['is_update']);//0:非强制升级;1:强制升级
            } else {
                $root['has_upgrade'] = 0;//1:可升级;0:不可升级
            }

        } else {
            $root['hasfile'] = 0;
            $root['has_upgrade'] = 0;//1:可升级;0:不可升级
        }
        return $root;
    }

    /**
     * 将图片直接上传到OSS上,不中转;
     * 参考网址：https://help.aliyun.com/document_detail/31920.html?spm=5176.doc31931.6.206.OEtePt
     * status: 1,
     * //上传文件时,必要的3个参数
     * AccessKeyId: "",
     * AccessKeySecret: "",
     * SecurityToken: "",
     *
     * //过期时间,客户端不关心
     * Expiration: "2016-09-28T10:30:02Z",
     *
     * //出错时,返回下面3个参数
     * RequestId: "",
     * Code: "",
     * Message: "",
     *
     * //回调地址
     * callbackUrl: "",
     * callbackBody: "",
     *
     * //文件存放目录
     * dir: ""
     */
    function aliyun_sts()
    {
        $root = array();
        $root['status'] = 1;
        //$GLOBALS['user_info']['id'] = 1;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $root = load_auto_cache("aliyun_sts");

            if ($root['status'] == 200) {
                $root['status'] = 1;

                //回调说明https://help.aliyun.com/document_detail/31922.html?spm=5176.doc31921.6.208.xZgpik
                $root['callbackUrl'] = '';
                $root['callbackBody'] = '';
                //上传的目录是由服务端（即PHP）指定的，这样的好处就是安全。 这样就能控制每个客户端只能上传指定到指定的目录，做到安全隔离, 想要修改上传目录地址成abc/(必须以'/'结尾)
                $dir_name = to_date(get_gmtime(), "Ym");
                $root['dir'] = 'public/attachment/' . $dir_name . '/' . intval($GLOBALS['user_info']['id']) . "/";
            } else {
                //$sts['status'] = 0;
            }
        }
        ajax_return($root);
    }

    /**
     * 调试接口
     */
    public function test()
    {
        header("Content-Type:text/html; charset=utf-8");
    }

    /**
     * 获得举报类型列表
     */
    public function tipoff_type()
    {

        $root = array();
        $root['status'] = 1;

        $list = load_auto_cache("tipoff_type_list");

        $root['list'] = $list;
        ajax_return($root);
    }

    /**
     * 获得礼物列表
     */
    public function prop()
    {

        $root = array();
        $root['status'] = 1;

        $root['list'] = load_auto_cache("prop_list");

        foreach ($root['list'] as $k => $v) {
            $root['list'][$k]['ticket'] = intval($v['ticket']);
        }

        //游戏币送礼物
        if (PROP_COINS == 1) {
            $coins_list = array();
            foreach ($root['list'] as $k => $v) {
                if (intval($v['coins']) > 0) {
                    $v['ticket'] = intval($v['ticket']);
                    $v['coins'] = intval($v['coins']);
                    $coins_list[] = $v;
                }
            }
            $root['coins_list'] = $coins_list;
        }
        $root['user_diamonds'] = 0;
        if ($GLOBALS['user_info']) {
            $user_info = $GLOBALS['db']->getRow("select diamonds from " . DB_PREFIX . "user  where id=" . intval($GLOBALS['user_info']['id']));
            $root['user_diamonds'] = $user_info ? $user_info['diamonds'] : 0;
        }
        ajax_return($root);
    }


    /**
     *插件列表接口
     *
     */
    public function plugin_init()
    {
        $user_id = intval($GLOBALS['user_info']['id']);
        if ($user_id == 0) {
            api_ajax_return(array(
                'status' => 10007,
                'error' => api_lang("Please_log_in_first"),
            ));
        }
        $m_config = load_auto_cache("m_config"); //初始化手机端配置

        //审核版本
        $ios_check = 0;
        $dev_type = strim($_REQUEST['sdk_type']);
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name && $GLOBALS['user_info']['mobile'] == '13888888888') {
            $ios_check = 1;
        }

        if ($ios_check) {
            ajax_return(array(
                'status' => 1,
                'list' => array(),
                'rs_count' => 0,
            ));
        }

        $plugin = $GLOBALS['db']->getALL("SELECT id,child_id,name,image,type,class as class_name FROM " . DB_PREFIX . "plugin WHERE is_effect=1 order by sort desc", true, true);

        $table = DB_PREFIX . 'video';
        $video = $GLOBALS['db']->getRow("SELECT `id` FROM  $table WHERE user_id=$user_id and live_in=1");
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        $fields = array('live_pay_time', 'live_fee', 'live_pay_type', 'is_live_pay', 'game_log_id');
        $video_info = $video_redis->getRow_db($video['id'], $fields);
        foreach ($plugin as $key => $value) {
            $plugin[$key]['is_active'] = 0;
            $plugin[$key]['is_tripartite'] = 0;
            $plugin[$key]['tripartite_type'] = '';
            switch ($value['class_name']) {
                case 'game':
                    if (defined('GAME_PLUGIN_MANAGE') && GAME_PLUGIN_MANAGE == 1) {
                        $allow_game_plugin = $GLOBALS['db']->getOne("select allow_game_plugin from " . DB_PREFIX . "user where id = " . $user_id);
                        if (!$allow_game_plugin) {
                            unset($plugin[$key]);
                            continue 2;
                        }
                    }
                    if (defined('OPEN_GAME_MODULE') && OPEN_GAME_MODULE == 1) {
                        if ($value['type'] == 2) {
                            $game_id = 0;
                            $is_enable = 1;
                            if ($video['id']) {
                                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/GamesRedisService.php');
                                $redis = new GamesRedisService();
                                $last_game = $video_info['game_log_id'];
                                if ($last_game) {
                                    $last_game = $redis->get($last_game, 'game_id,create_time,long_time');
                                    if (NOW_TIME < $last_game['create_time'] + $last_game['long_time']) {
                                        $game_id = $last_game['game_id'];
                                        $is_enable = 0;
                                    }
                                }
                            }
                            $plugin[$key]['is_active'] = intval($value['id'] == $game_id);
                            $plugin[$key]['is_enable'] = $is_enable;
                        }
                    } else {
                        unset($plugin[$key]);
                        continue 2;
                    }
                    break;
                case 'live_pay':
                case 'live_pay_scene':
                default:
                    if (defined('OPEN_LIVE_PAY') && OPEN_LIVE_PAY == 1) {
                        $is_nospeaking = $GLOBALS['db']->getOne("SELECT is_nospeaking FROM " . DB_PREFIX . "user WHERE id=" . $user_id, true, true);
                        if ($is_nospeaking) {
                            unset($plugin[$key]);
                            continue 2;
                        }
                        $live_pay_time = $video_info['live_pay_time']; //开始收费时间
                        $live_fee = intval($video_info['live_fee']); //付费直播 收费多少
                        $is_live_pay = intval($video_info['is_live_pay']);
                        $live_pay_type = intval($video_info['live_pay_type']);
                        $is_active = 0;
                        if ($live_pay_time != '' && $live_fee > 0) {
                            if (($is_live_pay == 1 && $live_pay_type == 0 && $value['class_name'] == 'live_pay') || ($is_live_pay == 1 && $live_pay_type == 1 && $value['class_name'] == 'live_pay_scene')) {
                                $is_active = 1;
                                $is_enable = 0;
                            } else {
                                $is_enable = 0;
                            }
                        }
                        $plugin[$key]['is_active'] = $is_active;
                        $plugin[$key]['is_enable'] = $is_enable;
                    } else {
                        unset($plugin[$key]);
                        continue 2;
                    }
                    break;
            }
            $plugin[$key]['image'] = get_spec_image($value['image']);
        }

        api_ajax_return(array(
            'status' => 1,
            'list' => array_values($plugin),
            'rs_count' => sizeof($plugin),
            'test' => __FILE__ . __LINE__,
        ));
    }

    /**
     * 插件接口状态
     */
    public function plugin_status()
    {
        $root = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);
        if ($user_id == 0) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            ajax_return($root);
        } else {
            $plugin_id = intval($_REQUEST['plugin_id']);//插件id，bogo_plugin.id
            $table = DB_PREFIX . 'video';
            $video = $GLOBALS['db']->getRow("SELECT `id`,pai_id FROM  $table WHERE user_id=" . $user_id . " and live_in=1");
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $fields = array('live_pay_time', 'live_fee', 'live_pay_type', 'is_live_pay', 'game_log_id');
            $video_info = $video_redis->getRow_db($video['id'], $fields);
            $is_enable = 1;
            $is_active = 0;
            $plugin = $GLOBALS['db']->getRow("SELECT id,child_id,name,image,type,class as class_name FROM " . DB_PREFIX . "plugin WHERE is_effect=1 and id=" . $plugin_id, true, true);
            $plugin['is_active'] = $is_active;
            $plugin['is_enable'] = $is_enable;


            if (defined('OPEN_PLUGIN') && OPEN_PLUGIN) {
                $open_plugin = $GLOBALS['db']->getRow("select open_game,open_pay,open_auction from " . DB_PREFIX . "user where id = $user_id");
                if ($plugin['class_name'] == 'game') {
                    if ($open_plugin['open_game'] == 1) {
                        $root['error'] = api_lang("unable_to_open_the_game");
                        $root['status'] = 0;
                        ajax_return($root);
                    }
                }
                if ($plugin['class_name'] == 'pai') {
                    if ($open_plugin['open_auction'] == 1) {
                        $root['error'] = api_lang("unable_to_open_auction");
                        $root['status'] = 0;
                        ajax_return($root);
                    }
                }
                if ($plugin['class_name'] == 'live_pay' || $plugin['class_name'] == 'live_pay_scene') {
                    if ($open_plugin['open_pay'] == 1) {
                        $root['error'] = api_lang("unable_to_open_payment");
                        $root['status'] = 0;
                        ajax_return($root);
                    }
                }

            }
            if (defined('OPEN_LIVE_PAY') && OPEN_LIVE_PAY == 1) {
                $live_pay_time = $video_info['live_pay_time'];//开始收费时间
                $live_fee = intval($video_info['live_fee']);//付费直播 收费多少
                $is_live_pay = intval($video_info['is_live_pay']);
                $live_pay_type = intval($video_info['live_pay_type']);
                if ($live_pay_time != '' && $live_fee > 0) {
                    //$is_enable = 0;
                    if (($is_live_pay == 1 && $live_pay_type == 1 && $plugin['class_name'] == 'live_pay_scene') || ($is_live_pay == 1 && $live_pay_type == 0 && $plugin['class_name'] == 'live_pay')) {
                        $is_active = 1;
                    }
                    if ($video['public_screen'] == 0) {
                        if ($plugin['class_name'] == 'live_pay') {
                            $is_enable = 0;
                            if ($is_active) {
                                $error = api_lang("live_pay_on_time");
                            } else {
                                $error = api_lang("live_pay_as_you_go");
                            }
                        } else if ($plugin['class_name'] == 'live_pay_scene') {
                            $is_enable = 0;
                            if ($is_active) {
                                $error = api_lang("live_pay_as_you_go");
                            } else {
                                $error = api_lang("live_pay_on_time");
                            }
                        }
                    }
                }

                $plugin['is_active'] = $is_active;
                $plugin['is_enable'] = $is_enable;
            }

            if (defined('OPEN_GAME_MODULE') && OPEN_GAME_MODULE == 1) {
                if ($plugin['type'] == 2) {
                    $game_id = 0;
                    if ($video['id']) {
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/GamesRedisService.php');
                        $redis = new GamesRedisService();
                        $last_game = $video_info['game_log_id'];
                        if ($last_game) {
                            $last_game = $redis->get($last_game, 'game_id,create_time,long_time');
                            $game_id = $last_game['game_id'];
                            $is_enable = $game_id ? intval($plugin_id == $game_id) : 1;
                            if ($game_id) {
                                $error = $plugin_id == $game_id ? api_lang("game_in_use") : api_lang("close_current_game");
                            }
                        }
                    }

                    $plugin['is_enable'] = $is_enable;
                }
            }
            $root['class_name'] = $plugin['class_name'];
            $root['is_enable'] = $plugin['is_enable'];
            if ($error != '') $root['error'] = $error;

            ajax_return($root);
        }
    }

    /**
     * 获取游戏列表
     */
    public function room_game_list()
    {
        $root = array('status' => 1, 'error' => '', 'list' => array());
        $type = strim($_REQUEST['type']);
        $user_id = intval($GLOBALS['user_info']['id']);

        if ($type && $type == 'h5') {
            $where = "status = 1 and (position=0 or position=1)";
        } else {
            $where = "status = 1 and (position=0 or position=2)";
        }

        // 转盘 : voice_id uid token
     //   $list = Db::name('other_game')->field("id,title as name,img,type,url,img as bg_img")->where($where)->order("sort desc")->select();
        $tripartite_game_where = "status = 1";

        $tripartite_game = Db::name('tripartite_game')->field("*")->where($tripartite_game_where)->order("sort desc")->select();
        $return = [];
        foreach ($tripartite_game as &$v) {
            if ($type && $type == 'h5') {
                $isLandscape = 'true';
                $url = $v['domain_name'];
                if ($v['directorys']) {
                    $url .= $v['directorys'] . "/";
                }
                $url .= "?isLandscape=" . $isLandscape;
            } else {
                $isLandscape = $v['is_landscape'] == 1 ? 'true' : 'false';
                $url = $v['domain_name'] . "?isLandscape=" . $isLandscape;
            }

            if ($v['merchant']) {
                $url .= "&merchant=" . $v['merchant'];
            }
            if ($v['game_id']) {
                $url .= "&gameId=" . $v['game_id'];
            }
            $url .= "&roomId=111";
            $return[] = array(
                'id' => $v['id'],
                'name' => $v['title'],
                'img' => $v['icon'],
                'type' => $v['type'],
                'bg_img' => $v['bg_img'],
                'url' => $url
            );
        }
        $root['list'] = $return;
        ajax_return($root);
    }
    /**
     * 获取游戏列表 增加了sud游戏
     */
    public function get_game_list()
    {
        $root = array('status' => 1, 'error' => '', 'list' => array());
        $type = strim($_REQUEST['type']);
        $user_id = intval($GLOBALS['user_info']['id']);

        $where = "status = 1";
        // sud游戏
        $list = Db::name('other_game')->field("id,title as name,img,type,url,img as bg_img,game_mark")->where($where)->order("sort desc")->select();
        $tripartite_game_where = "status = 1";

        $tripartite_game = Db::name('tripartite_game')->field("*")->where($tripartite_game_where)->order("sort desc")->select();
        $return = [];
        foreach ($tripartite_game as &$v) {
            if ($type && $type == 'h5') {
                $isLandscape = 'true';
                $url = $v['domain_name'];
                if ($v['directorys']) {
                    $url .= $v['directorys'] . "/";
                }
                $url .= "?isLandscape=" . $isLandscape;
            } else {
                $isLandscape = $v['is_landscape'] == 1 ? 'true' : 'false';
                $url = $v['domain_name'] . "?isLandscape=" . $isLandscape;
            }

            if ($v['merchant']) {
                $url .= "&merchant=" . $v['merchant'];
            }
            if ($v['game_id']) {
                $url .= "&gameId=" . $v['game_id'];
            }
            $url .= "&roomId=111";
            $return[] = array(
                'id' => $v['id'],
                'name' => $v['title'],
                'img' => $v['icon'],
                'type' => $v['type'],
                'bg_img' => $v['bg_img'],
                'url' => $url,
                'mgid' => 0,
                'game_type' => 'bogokj'
            );
        }
        foreach ($list as $ov) {
            $return[] = array(
                'id' => $ov['id'],
                'name' => $ov['name'],
                'img' => $ov['img'],
                'type' => $ov['type'],
                'bg_img' => $ov['bg_img'],
                'url' => $ov['url'],
                'mgid' => $ov['game_mark'],
                'game_type' => 'sud'
            );
        }
        $root['list'] = $return;
        ajax_return($root);
    }
    /**
     * 接收APP端错误日志
     */
    public function log_err()
    {
        $agent = strtolower($_SERVER['HTTP_USER_AGENT']);
        $dev_type = strim($_REQUEST['sdk_type']);
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        $sdk_version = strim($_REQUEST['sdk_version']);//升级版本号yyyymmddnn： 2016021601
        $err = trim($_REQUEST['desc']);
        if ($err != '') {
            log_err_file(array($dev_type, $sdk_version_name, $sdk_version, $agent, $err));
        }
    }

    /**
     * 获取腾讯云上传视频的sign
     * */
    public function app_request_get_upload_sign()
    {
        $this->checkUserLogin();

        $config = load_auto_cache('m_config');

        //确定 App 的云 API 密钥
        $secret_id = $config['qcloud_secret_id'];
        $secret_key = $config['qcloud_secret_key'];

        //确定签名的当前时间和失效时间
        $current = NOW_TIME;
        $expired = $current + 86400;  // 签名有效期：1天

        //向参数列表填入参数
        $arg_list = array(
            "secretId" => $secret_id,
            "currentTimeStamp" => $current,
            "expireTime" => $expired,
            "random" => rand());

        // 计算签名
        $original = http_build_query($arg_list);
        $signature = base64_encode(hash_hmac('SHA1', $original, $secret_key, true) . $original);

        ajax_return(array(
            'signature' => $signature,
            'status' => 1,
            'error' => ''
        ));

    }

    public function getCosSTS()
    {
        $this->checkUserLogin();

        $cosConfig = $GLOBALS['distribution_cfg']['COS_CONFIG'];

        //上传的目录是由服务端（即PHP）指定的，这样的好处就是安全。 这样就能控制每个客户端只能上传指定到指定的目录，做到安全隔离, 想要修改上传目录地址成abc/(必须以'/'结尾)
        $dir_name = to_date(get_gmtime(), "Ym");
        $dir = 'public/attachment/' . $dir_name . '/' . intval($GLOBALS['user_info']['id']) . "/";

        $secretId = $cosConfig['secretId'];
        $secretKey = $cosConfig['secretKey'];
        $region = $cosConfig['region'];
        $bucket_url = $cosConfig['url'];
        $bucket = $cosConfig['bucket'];

        // 检查有没有为空的参数配置
        if (empty($secretId) || empty($secretKey) || empty($region) || empty($bucket_url) || empty($bucket)) {
            ajax_return(array(
                'status' => 0,
                'error' => 'COS config is error!'
            ));
        }

        $allowPrefix = [$dir . '*'];

        $sts = new Sts();
        $config = array(
            'url' => 'https://sts.tencentcloudapi.com/', // url和domain保持一致
            'domain' => 'sts.tencentcloudapi.com', // 域名，非必须，默认为 sts.tencentcloudapi.com
            'proxy' => '',
            'secretId' => $secretId, // 固定密钥,若为明文密钥，请直接以'xxx'形式填入，不要填写到getenv()函数中
            'secretKey' => $secretKey, // 固定密钥,若为明文密钥，请直接以'xxx'形式填入，不要填写到getenv()函数中
            'bucket' => $bucket, // 换成你的 bucket
            'region' => $region, // 换成 bucket 所在园区
            'durationSeconds' => 1800, // 密钥有效期
            'allowPrefix' => $allowPrefix, // 这里改成允许的路径前缀，可以根据自己网站的用户登录态判断允许上传的具体路径，例子： a.jpg 或者 a/* 或者 * (使用通配符*存在重大安全风险, 请谨慎评估使用)
            // 密钥的权限列表。简单上传和分片需要以下的权限，其他权限列表请看 https://cloud.tencent.com/document/product/436/31923
            'allowActions' => array(
                // 简单上传
                'name/cos:PutObject',
                'name/cos:PostObject',
                // 分片上传
                'name/cos:InitiateMultipartUpload',
                'name/cos:ListMultipartUploads',
                'name/cos:ListParts',
                'name/cos:UploadPart',
                'name/cos:CompleteMultipartUpload'
            ),
            // 临时密钥生效条件，关于condition的详细设置规则和COS支持的condition类型可以参考 https://cloud.tencent.com/document/product/436/71306
//            "condition" => array(
//                "ip_equal" => array(
//                    "qcs:ip" => array(
//                        "10.217.182.3/24",
//                        "111.21.33.72/24",
//                    )
//                )
//            )
        );

        // 获取临时密钥，计算签名
        $tempKeys = $sts->getTempKeys($config);

        if (isset($tempKeys['credentials'])) {
            $result['sessionToken'] = $tempKeys['credentials']['sessionToken'];
            $result['tmpSecretId'] = $tempKeys['credentials']['tmpSecretId'];
            $result['tmpSecretKey'] = $tempKeys['credentials']['tmpSecretKey'];
            $result['bucket'] = $bucket;
            $result['domain'] = $bucket_url;
            $result['region'] = $region;
            $result['expiredTime'] = $tempKeys['expiredTime'];
            $result['startTime'] = $tempKeys['startTime'];
            $result['requestId'] = $tempKeys['requestId'];
            $result['allowPrefix'] = $allowPrefix;
            //echo date('Y-m-d H:i:s',$tempKeys['expiredTime']);die();

            $result['dir'] = $dir;

            ajax_return(array(
                'data' => ['sts' => $result, 'cosConfig' => $cosConfig],
                'status' => 1,
                'error' => ''
            ));
        } else {

            ajax_return(array(
                'status' => 0,
                'error' => $tempKeys['message'],
                'data' => null
            ));
        }
    }
}