<?php
use think\Db;
class avatar_frameModule extends baseModule
{

    //头像框列表
    public function index()
    {
        $root = array('status' => 1, 'error'=> '');
        $token = strim($_REQUEST['token']);// token
        $user_info = Db::name('user')->field("head_image")->where("token='".$token."'")->find();
        if (!$user_info) {
            $root['status'] = 0;
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $avatar_frame = Db::name('avatar_frame')->field("id,name,img,coin,day")->where("status=1")->order("sort desc")->select();

        $root['data'] = array(
            'list'=> $avatar_frame,
            'head_image' => $m_config['default_avatar'],
            'diamonds_name' => $m_config['diamonds_name']
        );
        api_ajax_return($root);
    }
    // 我的头像框
    public function my_avatar_frame(){
        $root = array('status' => 1, 'error'=> '');
        $user_id = intval($_REQUEST['uid']);// 用户ID
        $token = strim($_REQUEST['token']);// token
        $user_info = Db::name('user')->field("head_image,avatar_frame_id,id")->where("token='".$token."'")->find();
        if (!$user_info) {
            $root['status'] = 0;
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $user_id=$user_info['id'];
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $my_avatar = Db::name('avatar_frame_log')
            ->field("id,name,img,avatar_id,end_time")
            ->where("uid = ".$user_id." and status=1 and end_time >".time())
            ->group("avatar_id")
            ->order("create_time desc")
            ->select();
        foreach ($my_avatar as &$v) {
            $v['end_time'] = date('Y-m-d',$v['end_time']);
        }
        $root['data'] = array(
            'my_avatar' => $my_avatar,
            'head_image' => $m_config['default_avatar'],
            'select_id' => $user_info['avatar_frame_id']
        );
        api_ajax_return($root);
    }
    //购买
    public function pay()
    {
        $root = array('status'=>0,'error'=>'');
        $user_id = intval($_REQUEST['uid']);// 用户ID
        $token = strim($_REQUEST['token']);// token
        $user_info = Db::name('user')->field("diamonds,id")->where("token='".$token."'")->find();
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $before_user_diamonds = $user_info['diamonds'];
        $user_id = $user_info['id'];
        $id = intval($_REQUEST['id']);
        $recharge = Db::name('avatar_frame')->where("id=". $id." and status = 1")->find();
        if (!$recharge) {
            $root['error'] = api_lang("data_error");
            api_ajax_return($root);
        }
        if ($recharge['coin'] > $user_info['diamonds']) {
            $root['error'] = api_lang('insufficient_balance');
            api_ajax_return($root);
        }
        $pInTrans = Db::name()->StartTrans();
        try {
            $avatar_frame_log = Db::name('avatar_frame_log')->where("uid=". $user_id." and status = 1 and avatar_id=".$id)->find();
            $time = NOW_TIME;
            $endtime = $time;
            if ($avatar_frame_log && $avatar_frame_log['end_time'] > $time) {
                // 说明有头像框
                $endtime = $avatar_frame_log['end_time'];
                Db::name('avatar_frame_log')->where("id=". $avatar_frame_log['id'])->update(['status'=>2]);
            }
            $endtime =  $endtime + 60 * 60 * 24 * $recharge['day'];
            // 扣除钻石
            Db::name('user')->where("id=". $user_id)->setDec('diamonds', $recharge['coin']);
            // 添加购买记录
            $insert = array(
                'uid' => $user_id,
                'avatar_id' => $id,
                'name' => $recharge['name'],
                'img' => $recharge['img'],
                'coin' => $recharge['coin'],
                'day' => $recharge['day'],
                'type' => 1,
                'status' => 1,
                'create_time' => $time,
                'end_time' => $endtime
            );
            $prop_id = Db::name('avatar_frame_log')->insertGetId($insert);
            $insert = array(
                'log_info' => api_lang('Purchas_profile_picture_frame').$recharge['coin']. api_lang('Diamonds'),
                'log_time' => $time,
                'type' => 14,
                'user_id' => $user_id,
                'diamonds' => $recharge['coin'],
                'prop_id' => $prop_id
            );
            Db::name('user_log')->insert($insert);
            Db::name('user')->where("id=". $user_id)->update(['avatar_frame_id'=>$id]);
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            // 消费和收益记录表
            add_user_consumption_log($user_id,0,$recharge['coin'],api_lang('Purchas_profile_picture_frame')."：".$recharge['name'],0,0,9);
            //更新session
            $user_info = Db::name('user')->where("id=". $user_id)->find();
            $user_redis->update_db($user_id, $user_info);
            es_session::set("user_info", $user_info);
            $root['status'] = 1;
            $root['error'] = api_lang("purchase_successful");

            $content = $recharge['name']."(".$recharge['id'].")";
            add_user_records( $user_id,0,$recharge['coin'],0,$before_user_diamonds,0,0,0,$content,7);


            //提交事务
            Db::name()->Commit($pInTrans);
        } catch (Exception $e) {
            //异常回滚
            $root['error'] = $e->getMessage();
            Db::name()->Rollback($pInTrans);
        }
        api_ajax_return($root);
    }
    /**
     * 开启和关闭
     * */
    public function open_close()
    {
        $root = array('status'=>0,'error'=>'');
        $user_id = intval($_REQUEST['uid']);// 用户ID
        $token = strim($_REQUEST['token']);// token
        $id = intval($_REQUEST['id']);
        $user_info = Db::name('user')->field("avatar_frame_id,id")->where("token='".$token."'")->find();
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];
        $avatar_frame_log = Db::name('avatar_frame_log')->where("uid=". $user_id." and status = 1 and id=".$id)->find();
        if (!$avatar_frame_log) {
            $root['error'] = api_lang("data_error");
            api_ajax_return($root);
        }
        $avatar_frame_id = $avatar_frame_log['avatar_id'] == $user_info['avatar_frame_id'] ? 0 : $avatar_frame_log['avatar_id'];

        $res = Db::name('user')->where("id=". $user_id)->update(['avatar_frame_id'=>$avatar_frame_id]);
        if (!$res) {
            $root['error'] = api_lang("failed_to_open");
            api_ajax_return($root);
        }
        $root['status'] = 1;
        $root['error'] = api_lang("operation_was_successful");
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_redis->inc_field($user_id, 'avatar_frame_id', $avatar_frame_id);
        api_ajax_return($root);
    }

}