<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

bogo_require(APP_ROOT_PATH . 'vendor/autoload.php');
bogo_require(APP_ROOT_PATH . 'mapi/lib/core/db_common.php');

class baseModule
{
    public $page;
    public $pageSize;
    public $limit;

    protected $loginUserId;
    protected $globalUserInfo;

    /**
     * 测试使用的IP地址，不受地区限制
     * */
    protected $testIPAddress = [
        '222.132.157.163',
        '222.132.157.161'
    ];
    protected $testMobile = [
        '8615753857573',
        '8615753857574',
        '8615753857575',
        '8615698137973',
        '8615715385900',
        '8613583884080',
        '8615854868807',
        '8615615546244',
    ];

    public function __construct()
    {
        header("Access-Control-Allow-Origin: *");
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization, x-token");
            header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS,PATCH');
            exit;
        }
        //取第几页数据
        $page = intval($_REQUEST['p']);
        $page = $page == 0 ? 1 : $page;
        $this->page = $page;
        $this->page_size = 50;
        $this->limit = (($this->page - 1) * $this->page_size) . "," . $this->page_size;

        //用户登录信息
        $this->loginUserId = $GLOBALS['user_info'] ? $GLOBALS['user_info']['id'] : 0;
        $this->globalUserInfo = $GLOBALS['user_info'];
    }

    /**
     * 检测用户是否登录
     * */
    protected function checkUserLogin()
    {
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            $root['user_login_status'] = 0;
            ajax_return($root);
        }
    }

    public function __destruct()
    {
        register_shutdown_function(function () {
            if (isset($GLOBALS['redisdb'])) {
                $redis = $GLOBALS['redisdb'];
                $redis->close();
            }
        });
    }

    /**
     * @return void
     */
    public function checkCountryAreaAvailable()
    {
        $ipInfo = getIPInfoIO();
        $country = $ipInfo['country'];
        $region = $ipInfo['region'];

        add_file_log($ipInfo, 'ip_info');

        if (($country == 'CN' && !in_array(get_client_ip(), $this->testIPAddress)) || $region == 'Henan') {
            ajax_return(array("status" => 0, "error" => 'Not available in your country or region!'));
        }
    }

    /**
     * @return void
     */
    public function checkBanAreaAvailable()
    {
        $ipInfo = getIPInfoIO();
        $country = $ipInfo['country'];
        $region = $ipInfo['region'];

        add_file_log($ipInfo, 'ip_info');

        if ($country == 'CN' && $region == 'Henan') {
            ajax_return(array("status" => 0, "error" => 'Not available in your country or region!' . $region));
        }
    }
}