<?php

use think\Db;

/**
 *
 * @param unknown_type $user_id    查看人
 * @param unknown_type $podcast_id 主播
 * @param unknown_type $to_user_id 被查看的人
 * @param array        $request_data
 * @return array <mixed, multitype:number unknown mixed >
 */
function getuserinfo($user_id, $podcast_id, $to_user_id, $request_data = array())
{
    $root = array();

    $root['show_tipoff'] = 0;//举报按钮 1:显示;0:不显示
    $root['show_admin'] = 0;//管理按钮 1,2:显示;0:不显示 （1 管理员：举报，禁言，取消; 2 主播：设置为管理员/取消管理员,管理员列表，禁言，取消）
    $root['has_focus'] = 0;//0:未关注;1:已关注
    $root['has_admin'] = 0;//0:非管理员;1:是管理员
    $root['is_forbid'] = 0;//0:未被禁言;1:被禁言
    if ($to_user_id == 0) {
        $to_user_id = $user_id;
    }
    $user_lang=isset($_REQUEST['language']) ? $_REQUEST['language']:'';
    $room_id = intval($request_data['room_id']);
    if ($room_id) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        $video_info = $video_redis->getRow_db($room_id, array('id', 'group_id', 'password'));
        $forbid_info = $video_redis->has_forbid_msg($video_info['group_id'], $to_user_id);//判断某个用户是否被禁言(被禁言返回：true; 未被禁言返回：false)
        if ($forbid_info && intval($forbid_info) > NOW_TIME) {
            $root['is_forbid'] = 1;
        } else {
            $video_redis->unset_forbid_msg($video_info['group_id'], $to_user_id);
        }
    }


    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();

    $m_config = load_auto_cache("m_config");//初始化手机端配置

    $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time');

    $fields = array_merge($fields, array('is_vip', 'vip_expire_time', 'luck_num', 'avatar_frame_id', 'create_time','country_code','user_lang'));
    $userinfo = $user_redis->getRow_db($to_user_id, $fields);

    //查看自己
    if ($to_user_id == $user_id) {
        if($user_lang && $userinfo['user_lang'] != $user_lang){
            $sql = "update " . DB_PREFIX . "user set user_lang = '".$user_lang."' where id = " . $user_id;
            $GLOBALS['db']->query($sql);
        }
        if (defined('OPEN_VIP')) {
            $open_vip = intval(OPEN_VIP);
        }
        //     $fields = implode(',', $fields);
        //     $userinfo = $GLOBALS['db']->getRow('select ' . $fields . ' from ' . DB_PREFIX . 'user where id =' . $to_user_id);

        // 头像框
        $userinfo['avatar_frame_url'] = get_avatar_frame_url($to_user_id, $userinfo['avatar_frame_id']);

        $userinfo['signature'] = htmlspecialchars_decode($userinfo['signature']);
        $userinfo['nick_name'] = htmlspecialchars_decode($userinfo['nick_name']);
        $userinfo['signature'] = emoji_decode($userinfo['signature']);
        $userinfo['nick_name'] = emoji_decode($userinfo['nick_name']);

        $userinfo['ticket_total'] = intval(floor($userinfo['ticket'] + $userinfo['no_ticket'])); //用户总的：印票数

        $userinfo['user_id'] = $to_user_id;
        $userinfo['refund_ticket'] = intval(floor($userinfo['refund_ticket']));
        if (defined("robot_gifts") && robot_gifts == 1) {
            $userinfo['ticket'] = intval(floor($userinfo['ticket'] + $userinfo['no_ticket']));
        } else {
            $userinfo['ticket'] = intval(floor($userinfo['ticket'] - $userinfo['refund_ticket']));
        }
        $userinfo['use_diamonds'] = intval(floor($userinfo['use_diamonds']));
        $userinfo['diamonds'] = intval(floor($userinfo['diamonds']));
        if ($userinfo['is_authentication'] == 2) {
            if ($userinfo['v_explain'] == '') {
                $userinfo['v_explain'] = trim($userinfo['authentication_type']);
            }
        }

        if ($userinfo['signature'] == '' || $userinfo['signature'] == false) {
            $userinfo['signature'] = api_lang("forget_to_sign");
        }

        if ($userinfo['is_nospeaking'] === false) {
            $userinfo['is_nospeaking'] = 0;
        }
        if ($userinfo['coin'] === false) {
            $userinfo['coin'] = 0;
        }
        if ($userinfo['birthday'] == false)
            $userinfo['birthday'] = '';

        if ($userinfo['room_title'] === false) {
            $userinfo['room_title'] = '';
        }

        if ($userinfo['luck_num'] == false) {
            $userinfo['luck_num'] = '';
        }

        if ($userinfo['family_id'] == false)
            $userinfo['family_id'] = 0;

        if ($userinfo['family_chieftain'] == false)
            $userinfo['family_chieftain'] = 0;

        if ($userinfo['society_id'] == false)
            $userinfo['society_id'] = 0;

        if ($userinfo['society_chieftain'] == false)
            $userinfo['society_chieftain'] = 0;

        if ($userinfo['society_settlement_type'] == false)
            $userinfo['society_settlement_type'] = 0;

        if ($userinfo['emotional_state'] === false) {
            $userinfo['emotional_state'] = '';
        }
        if ($userinfo['noble_car_id'] === false) {

            $userinfo['noble_car_id'] = '0';

        }

        if ($userinfo['is_robot'] === false) {
            $userinfo['is_robot'] = 0;
        }
        if ($userinfo['job'] === false) {
            $userinfo['job'] = '';
        }

        if ($userinfo['alipay_user_id'] === false) {
            $userinfo['alipay_user_id'] = '';
        }

        if ($userinfo['alipay_name'] === false) {
            $userinfo['alipay_name'] = '';
        }

        if ($userinfo['alipay_authent_token'] === false) {
            $userinfo['alipay_authent_token'] = '';
        }

        if ($userinfo['id'] === false) {
            $userinfo['id'] = $user_id;
        }

        if ($userinfo['fans_count'] === false) {
            $userinfo['fans_count'] = 0;
        }

        if ($userinfo['focus_count'] === false) {
            $userinfo['focus_count'] = 0;
        }
        if ($userinfo['is_agree'] === false) {
            $userinfo['is_agree'] = 0;
        }
        if ($userinfo['is_remind'] === false) {
            $userinfo['is_remind'] = 0;
        }
        if ($userinfo['video_count'] === false) {
            $userinfo['video_count'] = 0;
        }
        if ($userinfo['is_authentication'] === false) {
            $userinfo['is_authentication'] = 0;
        }
        if ($userinfo['authentication_type'] === false) {
            $userinfo['authentication_type'] = 0;
        }
        if ($userinfo['sex'] === false) {
            $userinfo['sex'] = 0;
        }
        if ($userinfo['province'] === false) {
            $userinfo['province'] = '';
        }
        if ($userinfo['city'] === false) {
            $userinfo['city'] = '';
        }
        if ($userinfo['head_image'] === false) {
            $userinfo['head_image'] = '';
        }
        if ($userinfo['use_diamonds'] === false) {
            $userinfo['use_diamonds'] = 0;
        }
        if ($userinfo['user_level'] === false) {
            $userinfo['user_level'] = 1;
        }
        if ($userinfo['v_type'] === false) {
            $userinfo['v_type'] = 0;
        }
        if ($userinfo['v_explain'] === false) {
            $userinfo['v_explain'] = '';
        }
        if ($userinfo['v_icon'] === false) {
            $userinfo['v_icon'] = '';
        }
        $userinfo['open_vip'] = 0;
        if ($open_vip) {
            $userinfo['open_vip'] = $open_vip;
        }
        if ($userinfo['is_vip'] === false) {
            $userinfo['is_vip'] = 0;
        }
        if (!$userinfo['weibo_count']) {
            $userinfo['weibo_count'] = 0;
        }
        $userinfo['moments'] = $userinfo['weibo_count'];
        if (defined('OPEN_DIAMOND_GAME_MODULE') && OPEN_DIAMOND_GAME_MODULE == 1) {
            $userinfo['coin'] = $userinfo['use_diamonds'];
        }
        $vip_expire_time = intval($userinfo['vip_expire_time']);
        if ($vip_expire_time > 0) {
            $userinfo['vip_expire_time'] = to_date($vip_expire_time, 'Y-m-d H:i');
            if ($vip_expire_time < NOW_TIME) {
                $userinfo['is_vip'] = 0;
                $userinfo['vip_expire_time'] = api_lang("Expired");
                $sql = "update " . DB_PREFIX . "user set is_vip = 0 where id = " . $user_id;
                $GLOBALS['db']->query($sql);
                user_deal_to_reids(array($user_id));
            } else {
                if (intval($userinfo['is_vip']) == 0) {
                    $userinfo['vip_expire_time'] = api_lang("Not_open");
                }
            }
        } else {
            $userinfo['vip_expire_time'] = api_lang("Not_open");
            if (intval($userinfo['is_vip']) == 1) {
                $userinfo['vip_expire_time'] = api_lang("permanent");
            }
        }

        //未开启家族不显示
        if (!defined('OPEN_FAMILY_MODULE') || OPEN_FAMILY_MODULE != 1) {
            unset($userinfo['family_id']);
            unset($userinfo['family_chieftain']);
        }

        //未开启公会不显示
        if (!defined('OPEN_SOCIETY_MODULE') || OPEN_SOCIETY_MODULE != 1) {
            unset($userinfo['society_id']);
            unset($userinfo['society_chieftain']);
            unset($userinfo['society_settlement_type']);
        }
        //贵族特权
        $userinfo['noble_vip_type'] = 0;
        //贵族座驾
        $userinfo['noble_car'] = 0;
        //贵族坐席
        $userinfo['noble_maybe'] = 0;
        //贵族专属礼物
        $userinfo['noble_gift'] = 0;

        //是否是贵族头像
        $userinfo['noble_is_avatar'] = 0;

        //贵族特效
        $userinfo['noble_special_effects'] = 0;
        //贵族勋章
        $userinfo['noble_medal'] = 0;
        //经验加成
        $userinfo['noble_experience'] = 0;
        //弹幕
        $userinfo['noble_barrage'] = 0;
        //防禁言
        $userinfo['noble_silence'] = 0;
        //隐身
        $userinfo['noble_stealth'] = 0;
        //贵族发言图标
        $userinfo['noble_icon'] = '';
        //贵族图标
        $userinfo['noble_shop'] = '';
        //贵族头像图片
        $userinfo['noble_avatar'] = '';
        //贵族名称
        $userinfo['noble_name'] = '';
        //座驾路径
        $userinfo['noble_car_url'] = '';
        //座驾名称
        $userinfo['noble_car_name'] = '';
        //贵族明星框
        $userinfo['star_box'] = '';
        //聊天背景颜色
        $userinfo['bg_color'] = '';
        //神秘昵称
        $userinfo['mysterious_name'] = '';
        //神秘人头像
        $userinfo['mysterious_picture'] = '';
        //是否有权限开启神秘人
        $is_noble_mysterious = 0;    // 是否有权限开启神秘人
        $userinfo['aristocratic'] = [];
        //我的座驾

        // 贵族20210429版

        // 获取贵族权限
        // { ["id"]=> string(1) "1" ["name"]=> string(6) "骑士" ["icon"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202005/15/14/5ebe328210002.png" ["sort"]=> string(3) "200" ["addtime"]=> string(10) "1619600674" ["status"]=> string(1) "1" ["shop_icon"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202004/30/11/5eaa45bdb924c.png" ["card_img"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202104/28/17/60892515bc3b5.png" ["avatar_img"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202104/28/17/6089251ec0991.png" ["is_opening"]=> int(1) ["is_nameplate"]=> int(1) ["is_hesder"]=> int(1) ["is_card"]=> int(1) ["is_entry_effects"]=> int(1) ["is_seats"]=> int(1) ["is_car"]=> int(0) ["car_id"]=> int(0) ["is_skin"]=> int(1) ["is_ranking"]=> int(0) ["is_experience"]=> int(0) ["experience_val"]=> int(0) ["is_gift"]=> int(0) ["is_stealth_approach"]=> int(0) ["is_kickproof"]=> int(0) ["is_list_invisible"]=> int(0) ["is_beautiful"]=> int(0) }
        $jurisdiction = load_auto_cache("noble_id", ['id' => $userinfo['nobleid']]);
        // 贵族到期时间
        if ($userinfo['noble_time'] >= NOW_TIME) {
            // 1开通2铭牌3头像框4卡片5进场特性6坐席7座驾8公聊皮肤9排名靠前10经验加速11礼物12隐身进场13防踢防禁言14榜单隐身15贵族靓号
            //贵族特权
            $userinfo['noble_vip_type'] = 1;
            //贵族座驾
            $userinfo['noble_car'] = $jurisdiction['is_car'];
            //贵族坐席
            $userinfo['noble_maybe'] = $jurisdiction['is_seats'];
            //贵族专属礼物
            $userinfo['noble_gift'] = $jurisdiction['is_gift'];

            //是否是贵族头像
            $userinfo['noble_is_avatar'] = $jurisdiction['is_hesder'];

            //贵族特效
            $userinfo['noble_special_effects'] = $jurisdiction['is_entry_effects'];
            //贵族勋章
            $userinfo['noble_medal'] = $jurisdiction['is_nameplate'];
            //经验加成
            $userinfo['noble_experience'] = $jurisdiction['is_experience'];
            //弹幕
            $userinfo['noble_barrage'] = 1;
            //防禁言
            $userinfo['noble_silence'] = $jurisdiction['is_kickproof'];
            //隐身
            $userinfo['noble_stealth'] = $jurisdiction['is_stealth_approach'];
            //贵族发言图标
            $userinfo['noble_icon'] = $jurisdiction['icon'];
            //贵族图标
            $userinfo['noble_shop'] = $jurisdiction['shop_icon'];
            //贵族头像图片
            $userinfo['noble_avatar'] = $jurisdiction['avatar_img'];
            //贵族名称
            $userinfo['noble_name'] = $jurisdiction['name'];
            //贵族明星框
            $userinfo['star_box'] = $jurisdiction['card_img'];
            //聊天背景颜色
            $userinfo['bg_color'] = $jurisdiction['bg_color'];
            $userinfo['aristocratic'] = $jurisdiction;
            // 是否开启隐身
            $userinfo['is_noble_stealth'] = $jurisdiction['is_stealth_approach'] == 1 ? $userinfo['is_noble_stealth'] : 0;

            $is_noble_mysterious = $userinfo['is_noble_stealth'];
        } else {
            $sql = "update " . DB_PREFIX . "user set nobleid = 0 where id = " . $to_user_id;
            $GLOBALS['db']->query($sql);
        }
        if ($userinfo['noble_car_id'] > 0) {
            $car = redis_get("noble_car_" . $userinfo['noble_car_id'] . "_" . $to_user_id);
            if ($car) {
                $car = json_decode($car, true);
            }
            if ($car) {
                $car_noble = get_noble_one($car['carid']);
                if ($car_noble) {
                    $userinfo['noble_car_url'] = $car_noble['img'];
                    $userinfo['noble_car_name'] = $car_noble['name'];
                }
            } else {
                $sql = "update " . DB_PREFIX . "user set noble_car_id = 0 where id = " . $to_user_id;
                $GLOBALS['db']->query($sql);
            }
        }

        if ($is_noble_mysterious == 1 && $userinfo['is_noble_mysterious'] == 1) {
            //开启了神秘人
            //神秘人昵称
            $userinfo['mysterious_name'] = noble_mysterious_name($to_user_id, $userinfo['create_time']);
            //神秘人头像
            $userinfo['mysterious_picture'] = $m_config['mysterious_picture'];
        } else {
            $userinfo['is_noble_mysterious'] = 0;
        }
        $country_flag = get_country_flag($userinfo['country_code']);
        $userinfo['country_img'] = $country_flag['country_img']; // 国旗
        $root['user'] = $userinfo;
        $root['user']['useable_ticket'] = intval($userinfo['ticket']);
        //$root['user']['ticket'] = $root['user']['useable_ticket'];
        $root['user']['head_image'] = get_spec_image($userinfo['head_image']);
        $root['user']['is_robot'] = intval($userinfo['is_robot']);
        //$root['user']['focus_count'] = $focus_count;
        //$root['user']['fans_count'] = $fans_count;

        $root['user']['show_user_order'] = 0;
        $root['user']['user_order'] = 0;
        $root['user']['show_user_pai'] = 0;
        $root['user']['user_pai'] = 0;
        $root['user']['show_podcast_order'] = 0;
        $root['user']['show_podcast_pai'] = 0;
        $root['user']['show_podcast_goods'] = 0;
        $root['user']['podcast_goods'] = 0;
        $root['user']['show_shopping_cart'] = 0;
        $root['user']['shopping_cart'] = 0;
        $root['user']['open_podcast_goods'] = 0;

        $root['user']['show_svideo'] = defined("OPEN_SVIDEO_MODULE") && OPEN_SVIDEO_MODULE == 1 ? 1 : 0;
        $root['user']['show_svideo_favor'] = defined("OPEN_SVIDEO_MODULE") && OPEN_SVIDEO_MODULE == 1 ? 1 : 0;
        if ($root['user']['show_svideo']) {
            $sql = "select count(*) from " . DB_PREFIX . "weibo where user_id = " . $user_id . " and status=1";
            $root['user']['svideo_count'] = intval($GLOBALS['db']->getOne($sql, true, true));
        } else {
            $root['user']['svideo_count'] = 0;
        }

        if ($podcast_id == $user_id) {
            $root['show_admin'] = 0;//主播查看 主播：设置为管理员/取消管理员,管理员列表，禁言，取消
        }


        //H5链接
        $h5_url = array(
            'url_my_grades'         => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=user_center&act=grade',
            'url_about_we'          => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=settings&act=article_cate',
            'url_help_feedback'     => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=settings&act=help',
            'url_auction_record'    => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_user&act=pailogs',
            'url_user_order'        => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=shop&act=shop_order&page=1', //商城h5订单链接（观众）
            'url_user_pai'          => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_user&act=goods',
            'url_podcast_order'     => '',  // 星级订单（暂无）
            'url_podcast_pai'       => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_podcast&act=goods',
            'url_podcast_goods'     => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=shop&act=podcasr_goods_management&state=1&page=1', //商城h5链接（主播）
            'url_auction_agreement' => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=settings&act=article_show&cate_id=18', //竞拍协议
            'url_pai_income'        => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=user_center&act=income', //竞拍收益h5
            'url_goods_income'      => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=user_center&act=goods_income_details', //商品收益h5
            'url_user_goods'        => '', //进入第三方商城h5链接(观众)
            'url_shopping_cart'     => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=shop&act=shop_shopping_cart&page=1' //购物车

        );

        if (defined('OPEN_EDU_MODULE') && OPEN_EDU_MODULE == 1 && $userinfo['authentication_type'] == '机构') {
            $store_url = $GLOBALS['db']->getOne("select store_url from " . DB_PREFIX . "edu_org where user_id = " . $user_id);
            $h5_url['url_user_store'] = $store_url;
        }

        if ((defined('PAI_REAL_BTN') && PAI_REAL_BTN == 1) && (defined('PAI_VIRTUAL_BTN') && PAI_VIRTUAL_BTN == 0)) {
            $h5_url['url_user_pai'] = SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_user&act=goods&is_true=1';
            $h5_url['url_podcast_pai'] = SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=pai_podcast&act=goods&is_true=1';
        }

        $root['h5_url'] = $h5_url;
    } else {

        $userinfo['user_id'] = $to_user_id;
        $userinfo['signature'] = htmlspecialchars_decode($userinfo['signature']);
        // 头像框
        $userinfo['avatar_frame_url'] = get_avatar_frame_url($to_user_id, $userinfo['avatar_frame_id']);
        $userinfo['signature'] = emoji_decode($userinfo['signature']);

        $userinfo['ticket_total'] = intval(floor($userinfo['ticket'] + $userinfo['no_ticket'])); //用户总的：印票数
        if (defined("robot_gifts") && robot_gifts == 1) {
            $userinfo['ticket'] = intval(floor($userinfo['ticket'] + $userinfo['no_ticket']));
        } else {
            $userinfo['ticket'] = intval(floor($userinfo['ticket'] - $userinfo['refund_ticket']));
        }

        /****************** 添加浏览记录 *******************************/
        $re = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user_record where uid = ' . $user_id . ' and to_user_id = ' . $to_user_id);
        if (empty($re)) {
            $sql = "insert into " . DB_PREFIX . "user_record (uid,to_user_id,addtime) values (" . $user_id . "," . $to_user_id . "," . time() . ")";
            $GLOBALS['db']->query($sql);
        }


        //===================slf add by 20160927 ============
        if ($userinfo['signature'] == '' || $userinfo['signature'] == false) {
            $userinfo['signature'] = api_lang("forget_to_sign");
        }
        //===================================================

        if ($userinfo['birthday'] == false)
            $userinfo['birthday'] = '';

        if ($userinfo['room_title'] === false) {
            $userinfo['room_title'] = '';
        }
        if ($userinfo['luck_num'] === false) {
            $userinfo['luck_num'] = '';
        }
        if ($userinfo['emotional_state'] === false) {
            $userinfo['emotional_state'] = '';
        }
        if ($userinfo['family_id'] == false)
            $userinfo['family_id'] = 0;

        if ($userinfo['family_chieftain'] == false)
            $userinfo['family_chieftain'] = 0;

        if ($userinfo['is_robot'] === false) {
            $userinfo['is_robot'] = 0;
        }
        if ($userinfo['job'] === false) {
            $userinfo['job'] = '';
        }

        if ($userinfo['id'] === false) {
            $userinfo['id'] = $user_id;
        }

        if ($userinfo['fans_count'] === false) {
            $userinfo['fans_count'] = 0;
        }

        if ($userinfo['focus_count'] === false) {
            $userinfo['focus_count'] = 0;
        }
        if ($userinfo['is_agree'] === false) {
            $userinfo['is_agree'] = 0;
        }
        if ($userinfo['is_remind'] === false) {
            $userinfo['is_remind'] = 0;
        }
        if ($userinfo['video_count'] === false) {
            $userinfo['video_count'] = 0;
        }
        if ($userinfo['is_authentication'] === false) {
            $userinfo['is_authentication'] = 0;
        }
        if ($userinfo['sex'] === false) {
            $userinfo['sex'] = 0;
        }
        if ($userinfo['province'] === false) {
            $userinfo['province'] = '';
        }
        if ($userinfo['city'] === false) {
            $userinfo['city'] = '';
        }
        if ($userinfo['head_image'] === false) {
            $userinfo['head_image'] = '';
        }
        if ($userinfo['use_diamonds'] === false) {
            $userinfo['use_diamonds'] = 0;
        }
        if ($userinfo['user_level'] === false) {
            $userinfo['user_level'] = 1;
        }
        if ($userinfo['v_type'] === false) {
            $userinfo['v_type'] = 0;
        }
        if ($userinfo['is_authentication'] == 2) {
            if ($userinfo['v_explain'] == '') {
                $userinfo['v_explain'] = trim($userinfo['authentication_type']);
            }
        }
        if ($userinfo['v_icon'] === false) {
            $userinfo['v_icon'] = '';
        }

        if ($userinfo['is_vip'] === false) {
            $userinfo['is_vip'] = 0;
        }

        if ($userinfo['weibo_count'] === false) {
            $userinfo['weibo_count'] = 0;
        }
        $userinfo['moments'] = $userinfo['weibo_count'];
        $vip_expire_time = intval($userinfo['vip_expire_time']);
        if ($vip_expire_time > 0) {
            $userinfo['vip_expire_time'] = to_date($vip_expire_time, 'Y-m-d H:i');
            if ($vip_expire_time < NOW_TIME) {
                $userinfo['is_vip'] = 0;
                $userinfo['vip_expire_time'] = api_lang("Expired");
                $sql = "update " . DB_PREFIX . "user set is_vip = 0 where id = " . $to_user_id;
                $GLOBALS['db']->query($sql);
                user_deal_to_reids(array($to_user_id));
            } else {
                if (intval($userinfo['is_vip']) == 0) {
                    $userinfo['vip_expire_time'] = api_lang("Not_open");
                }
            }
        } else {
            $userinfo['vip_expire_time'] = api_lang("Not_open");
            if (intval($userinfo['is_vip']) == 1) {
                $userinfo['vip_expire_time'] = api_lang("permanent");
            }
        }
        //贵族特权
        $userinfo['noble_vip_type'] = 0;                //不是贵族
        $userinfo['noble_car'] = 0;                    //贵族座驾
        $userinfo['noble_maybe'] = 0;                    //贵族坐席
        $userinfo['noble_gift'] = 0;                    //贵族专属礼物
        $userinfo['noble_is_avatar'] = 0;               //是否是贵族头像
        $userinfo['noble_special_effects'] = 0;       //贵族特效
        $userinfo['noble_medal'] = 0;                //贵族勋章
        $userinfo['noble_experience'] = 0;           //经验加成
        $userinfo['noble_barrage'] = 0;             //   弹幕
        $userinfo['noble_silence'] = 0;             //  防禁言
        $userinfo['noble_stealth'] = 0;             //   隐身

        $userinfo['noble_icon'] = '';           //贵族发言图标
        $userinfo['noble_shop'] = '';          //贵族图标
        $userinfo['noble_avatar'] = '';         //贵族头像图片
        $userinfo['noble_name'] = '';         //贵族名称
        $userinfo['noble_car_url'] = '';         //座驾路径
        $userinfo['star_box'] = '';             //贵族明星框
        //聊天背景颜色
        $userinfo['bg_color'] = '';
        $userinfo['mysterious_name'] = '';     //神秘昵称
        $userinfo['mysterious_picture'] = ''; // 神秘人头像
        // 是否有权限开启神秘人

        $is_noble_mysterious = 0;    // 是否有权限开启神秘人

        // 贵族20210429版

        $userinfo['aristocratic'] = [];
        if ($userinfo) {
            // 获取贵族权限
            // { ["id"]=> string(1) "1" ["name"]=> string(6) "骑士" ["icon"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202005/15/14/5ebe328210002.png" ["sort"]=> string(3) "200" ["addtime"]=> string(10) "1619600674" ["status"]=> string(1) "1" ["shop_icon"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202004/30/11/5eaa45bdb924c.png" ["card_img"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202104/28/17/60892515bc3b5.png" ["avatar_img"]=> string(92) "http://fw25live.oss-cn-beijing.aliyuncs.com/public/attachment/202104/28/17/6089251ec0991.png" ["is_opening"]=> int(1) ["is_nameplate"]=> int(1) ["is_hesder"]=> int(1) ["is_card"]=> int(1) ["is_entry_effects"]=> int(1) ["is_seats"]=> int(1) ["is_car"]=> int(0) ["car_id"]=> int(0) ["is_skin"]=> int(1) ["is_ranking"]=> int(0) ["is_experience"]=> int(0) ["experience_val"]=> int(0) ["is_gift"]=> int(0) ["is_stealth_approach"]=> int(0) ["is_kickproof"]=> int(0) ["is_list_invisible"]=> int(0) ["is_beautiful"]=> int(0) }
            $jurisdiction = load_auto_cache("noble_id", ['id' => $userinfo['nobleid']]);
            // 贵族到期时间
            if ($userinfo['noble_time'] >= NOW_TIME) {
                // 1开通2铭牌3头像框4卡片5进场特性6坐席7座驾8公聊皮肤9排名靠前10经验加速11礼物12隐身进场13防踢防禁言14榜单隐身15贵族靓号
                //贵族特权
                $userinfo['noble_vip_type'] = 1;
                //贵族座驾
                $userinfo['noble_car'] = $jurisdiction['is_car'];
                //贵族坐席
                $userinfo['noble_maybe'] = $jurisdiction['is_seats'];
                //贵族专属礼物
                $userinfo['noble_gift'] = $jurisdiction['is_gift'];

                //是否是贵族头像
                $userinfo['noble_is_avatar'] = $jurisdiction['is_hesder'];

                //贵族特效
                $userinfo['noble_special_effects'] = $jurisdiction['is_entry_effects'];
                //贵族勋章
                $userinfo['noble_medal'] = $jurisdiction['is_nameplate'];
                //经验加成
                $userinfo['noble_experience'] = $jurisdiction['is_experience'];
                //弹幕
                $userinfo['noble_barrage'] = 1;
                //防禁言
                $userinfo['noble_silence'] = $jurisdiction['is_kickproof'];
                //隐身
                $userinfo['noble_stealth'] = $jurisdiction['is_stealth_approach'];
                //贵族发言图标
                $userinfo['noble_icon'] = $jurisdiction['icon'];
                //贵族图标
                $userinfo['noble_shop'] = $jurisdiction['shop_icon'];
                //贵族头像图片
                $userinfo['noble_avatar'] = $jurisdiction['avatar_img'];
                //贵族名称
                $userinfo['noble_name'] = $jurisdiction['name'];
                //贵族明星框
                $userinfo['star_box'] = $jurisdiction['card_img'];
                //聊天背景颜色
                $userinfo['bg_color'] = $jurisdiction['bg_color'];
                $userinfo['aristocratic'] = $jurisdiction;
                // 是否开启隐身
                $userinfo['is_noble_stealth'] = $jurisdiction['is_stealth_approach'] == 1 ? $userinfo['is_noble_stealth'] : 0;
                $is_noble_mysterious = $userinfo['is_noble_stealth'];
            } else {
                $sql = "update " . DB_PREFIX . "user set nobleid = 0 where id = " . $to_user_id;
                $GLOBALS['db']->query($sql);
            }
        }
        //我的座驾
        if ($userinfo['noble_car_id'] > 0) {
            $car = redis_get("noble_car_" . $userinfo['noble_car_id'] . "_" . $to_user_id);
            if ($car) {
                $car = json_decode($car, true);
            }
            if ($car) {
                $car_noble = get_noble_one($car['carid']);
                if ($car_noble) {
                    $userinfo['noble_car_url'] = $car_noble['img'];
                }
            } else {
                $sql = "update " . DB_PREFIX . "user set noble_car_id = 0 where id = " . $to_user_id;
                $GLOBALS['db']->query($sql);
            }
        }

        if ($is_noble_mysterious == 1 && $userinfo['is_noble_mysterious'] == 1) {
            // 开启了神秘人
            // 神秘人昵称
            $userinfo['nick_name'] = noble_mysterious_name($to_user_id, $userinfo['create_time']);
            // 神秘人头像
            $userinfo['head_image'] = $m_config['mysterious_picture'];

            $userinfo['mysterious_name'] = $userinfo['nick_name'];
            $userinfo[' '] = $userinfo['head_image'];
        } else {
            $userinfo['is_noble_mysterious'] = 0;
        }

        $userinfo['nick_name'] = htmlspecialchars_decode($userinfo['nick_name']);
        $userinfo['nick_name'] = emoji_decode($userinfo['nick_name']);
        $userinfo['head_image'] = get_spec_image($userinfo['head_image']);
        $country_flag = get_country_flag($userinfo['country_code']);
        $userinfo['country_img'] = $country_flag['country_img']; // 国旗


        $root['user'] = $userinfo;
        //被查看的用户：个人主页地址
        //$root['user']['home_url'] = SITE_DOMAIN.APP_ROOT.'/index.php?isapp=1&c=home&podcast_id='.$to_user_id;
        //$root['user']['focus_count'] = $focus_count;
        //$root['user']['fans_count'] = $fans_count;
        if ($podcast_id > 0) {
            //主播查看
            if ($podcast_id == $user_id) {
                $root['show_admin'] = 2;//主播查看 主播：设置为管理员/取消管理员,管理员列表，禁言，取消

                $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = " . $user_id . " and user_id = " . $to_user_id;
                //$root['sql'] = $sql;
                if ($GLOBALS['db']->getOne($sql, true, true) > 1) {
                    $root['has_admin'] = 1;//0:非管理员;1:是管理员
                } else {
                    $root['has_admin'] = 0;
                }

            } else {
                $sql = "select count(id) as num from " . DB_PREFIX . "user_admin where podcast_id = '" . $podcast_id . "' and user_id = " . $user_id;
                if ($GLOBALS['db']->getOne($sql, true, true) > 0) {
                    $root['show_admin'] = 1;
                    $root['has_admin'] = 1;//0:非管理员;1:是管理员
                    //$root['sql'] = $sql;
                }
            }

            //管理员查看：主播; 不能：禁言 主播
            if ($root['show_admin'] == 1 && $podcast_id == $to_user_id) {
                $root['show_admin'] = 0;
            }


            if ($root['show_admin'] > 0)
                $root['show_tipoff'] = 0;
            else
                $root['show_tipoff'] = 1;

        }

        //关注
        //bogo_require(APP_ROOT_PATH.'mapi/lib/redis/UserFollwRedisService.php');
        $userfollw_redis = new UserFollwRedisService($user_id);
        if ($userfollw_redis->is_following($to_user_id)) {
            $root['has_focus'] = 1;//0:未关注;1:已关注
        }
        /*
        //关注
        $sql = "select count(id) as num from ".DB_PREFIX."focus where podcast_id = ".$to_user_id." and user_id = ".$user_id;
        if ($GLOBALS['db']->getOne($sql,true,true) > 0){
            $root['has_focus'] = 1;//0:未关注;1:已关注
        }*/
    }

    if ($podcast_id == 0) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoContributionRedisService.php');
        $video_con = new VideoContributionRedisService();
        $con_list = $video_con->get_podcast_contribute($to_user_id, 0, 3, 1);

        //印票贡献前3名
        $root['cuser_list'] = $con_list;
        foreach ($root['cuser_list'] as $k => $v) {
            $root['cuser_list'][$k]['nick_name'] = emoji_decode($v['nick_name']);
        }

        //拖黑
        $sql = "select count(id) as num from " . DB_PREFIX . "black where black_user_id = " . $to_user_id . " and user_id = " . $user_id;
        if ($GLOBALS['db']->getOne($sql, true, true) > 0) {
            $root['has_black'] = 1;//0:未拖黑;1:已拖黑
        } else {
            $root['has_black'] = 0;//0:未拖黑;1:已拖黑 $podcast_id == 0 时有效
        }

        $item = array();
        if ($root['user']['birthday'] == 0)
            $item[api_lang("age")] = api_lang("have_guess"); //年龄
        else {
            $item[api_lang("age")] = ceil((NOW_TIME - $root['user']['birthday']) / 31536000) . api_lang("year_one");//年龄
        }

        $item[api_lang("emotional_state")] = $root['user']['emotional_state']; //情感状况

        $item[api_lang("occupation")] = $root['user']['job'];//职业


        //如果有靓号，显示的用户ID为靓号luck_num
        /*if (intval($root['user']['luck_num']) > 0) {
            $item[$m_config['short_name'] . api_lang("Number")] = $userinfo['luck_num'];//布谷鸟直播系统号
        } else {
            $item[$m_config['short_name'] . api_lang("Number")] = $root['user']['user_id']; //布谷鸟直播系统号
        }*/
        $item[api_lang("hometown")] = $root['user']['province'] . " " . $root['user']['city'];//家乡
//        $item[$m_config['short_name'].'号'] = $root['user']['user_id'];
        $item[api_lang("Personal_signature")] = $root['user']['signature'];//个性签名

        $len_time = get_live_time_len2($root['user']['len_time']);
        if ($len_time) {
            $item[api_lang("Duration_live_broadcast")] = $len_time;// 直播时长
        }
        $times = NOW_TIME - $root['user']['create_time'];
        $user_time = get_live_time_len2($times);
        if ($user_time) {
            $item[api_lang("duration_registration")] = $user_time;// 注册时长
        }

        //清空空值
        foreach ($item as $k => $v) {
            if (trim($v) == '') {
                unset($item[$k]);
            } else {
                $item[$k] = htmlspecialchars_decode($v);
            }
        }

        $root['user']['item'] = $item;
    } else {
        //印票贡献第一名
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoContributionRedisService.php');
        $video_con = new VideoContributionRedisService();
        $con_root = $video_con->get_podcast_contribute($to_user_id, 0, 1, 1);
        if ($con_root[0]) {
            $root['cuser'] = $con_root[0];
        }
    }

    // --------------- 直播中 -------------
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
    $video_viewer = new VideoViewerRedisService();
    $videos = $video_viewer->redis->get("room_user_status:" . $to_user_id);
    $is_videos = true;
    if ($videos) {
        $videos = json_decode($videos, true);
        $video = $GLOBALS['db']->getRow("select id as room_id,group_id,live_in,user_id,video_type,head_image,create_type,live_image,password,is_voice from " . DB_PREFIX . "video where id=" . $videos['id'] . " and live_in in (1,3) and room_type = 3 order by sort_num desc,sort desc", true, true);
        if ($video) {
            $video['head_image'] = get_spec_image($video['head_image']);
            $video['live_image'] = get_spec_image($video['live_image']);
            // 是否直播中 1-直播中 0-已停止;2:正在创建直播;3:历史数据
            $video['in_room_status'] = 0; // 0观看中 1 直播中 2语音房间
            if ($video['user_id'] == $to_user_id) {
                $video['in_room_status'] = $video['is_voice'] == 1 ? 2 : 1;
            }
            $root['video'] = $video;
            $is_videos = false;
        } else {
            $video_viewer->redis->delete("room_user_status:" . $to_user_id);
        }
    }

    if ($is_videos) {
        $video = $GLOBALS['db']->getRow("select id as room_id,group_id,live_in,user_id,video_type,head_image,create_type,live_image,password,is_voice from " . DB_PREFIX . "video where user_id=" . $to_user_id . " and live_in in (1,3) and room_type = 3 order by sort_num desc,sort desc", true, true);
        if (intval($video['room_id'])) {
            $video['head_image'] = get_spec_image($video['head_image']);
            $video['live_image'] = get_spec_image($video['live_image']);

            if (defined('OPEN_EDU_MODULE') && OPEN_EDU_MODULE == 1) {
                $video['is_verify'] = intval($GLOBALS['db']->getOne("select is_verify from " . DB_PREFIX . "edu_video_info where video_id = " . $video['room_id']));
            }

            if (empty($video['group_id']) && defined('CHILD_ROOM') && CHILD_ROOM) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/ChildRoom.class.php');
                $child_room = new child_room();
                $parent_id = $child_room->parent_id($video['room_id']);
                $video['group_id'] = $GLOBALS['db']->getOne("SELECT group_id FROM " . DB_PREFIX . "video WHERE id =" . $parent_id);
            }

            // 是否直播中 1-直播中 0-已停止;2:正在创建直播;3:历史数据
            $video['in_room_status'] = 2; // 0观看中 1 直播中 2语音房间
            if ($video['user_id'] == $to_user_id) {
                $video['in_room_status'] = $video['is_voice'] == 1 ? 2 : 1;
            }
            $root['video'] = $video;

        }
    }
    if (isset($root['user']['noble_time']) && $root['user']['noble_time'] > NOW_TIME) {
        $root['user']['noble_time'] = date('Y-m-d', $root['user']['noble_time']);
    }
    return $root;
}

/**
 * 获取用户头像框
 * uid 用户id
 * avatar_frame_id 头像框id
 */
function get_avatar_frame_url($uid, $avatar_frame_id)
{
    $avatar_frame_url = '';
    if ($uid && $avatar_frame_id) {
        $avatar_frame_log_key = "avatar_frame_log_" . $uid . "_" . intval($avatar_frame_id);
        $avatar_frame_log = $GLOBALS['cache']->get($avatar_frame_log_key);
        if (!$avatar_frame_log || $avatar_frame_log['end_time'] < time()) {
            $avatar_frame_log = $GLOBALS['db']->getRow('select img,end_time from ' . DB_PREFIX . 'avatar_frame_log where uid =' . $uid . " and end_time > " . time() . " and status = 1 and avatar_id=" . intval($avatar_frame_id));
            $GLOBALS['cache']->set($avatar_frame_log_key, $avatar_frame_log, 24 * 60 * 60);//缓存时间
        }
        if ($avatar_frame_log && $avatar_frame_log['end_time'] > time()) {
            $avatar_frame_url = $avatar_frame_log['img'];
        }
    }

    return $avatar_frame_url;
}

/**
 * 消费和收益记录表
 * @param int    $uid         消费者
 * @param int    $to_uid      收益人
 * @param int    $consumption 总消费数
 * @param string $content     说明
 * @param int    $profit      收益 -- 收益积分
 * @param int    $coin        钻石--收益钻石
 * @param int    $type        类型：1礼物 2守护 3 任务 4 付费房间 5私信 6弹幕 7vip 8座驾 9头像框 10靓号 11充值金币12兑换13签到 14修改昵称消费15注册赠送16幸运礼物中奖 17购买贵族 18三方游戏 19家族 20平台充值 21 提现 22 红包
 * @param int    $mission_id  主播任务id
 * @param int    $duration    主播任务时长--分钟
 */
function add_user_consumption_log($uid, $to_uid, $consumption, $content, $profit, $coin = '0', $type = '1', $mission_id = 0, $duration = 0)
{
    $add = array(
        'from_uid'     => $uid,
        'received_uid' => $to_uid,
        'content'      => "'" . $content . "'",
        'consumption'  => $consumption,
        'coin'         => $coin,
        'profit'       => $profit,
        'type'         => $type,
        'mission_id'   => $mission_id,
        'duration'     => $duration,
        'create_time'  => NOW_TIME
    );
    //将礼物写入mysql表中
    $field_arr = array('from_uid', 'received_uid', 'content', 'consumption', 'coin', 'profit', 'type', 'mission_id', 'duration', 'create_time');

    $fields = implode(",", $field_arr);
    $valus = implode(",", $add);

    $sql = "insert into " . DB_PREFIX . "user_consumption_log(" . $fields . ") VALUES (" . $valus . ")";
    $GLOBALS['db']->query($sql);
    if ($to_uid && $type == 1 && $profit) {
        // 获取时间 数组格式
        $date = get_date_time(NOW_TIME);
        // 是房主本人，增加时长
        insert_duration($date, $to_uid, 3, $profit);

    }
}

/**
 * 设置关注/取消关注
 * @param unknown_type $user_id    关注用户ID
 * @param unknown_type $to_user_id 被关注的用户ID
 *                                 $force_remove: 强制取消关注操作
 * @return multitype:number string
 */
function redis_set_follow($user_id, $to_user_id, $force_remove = false, $room_id = 0)
{
    $root = array();
    $root['status'] = 1;

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
    $user_follw_redis = new UserFollwRedisService($user_id);

    if ($user_follw_redis->is_following($to_user_id) || $force_remove) {
        //已关注,取消关注操作
        //if ($user_redis->is_following($to_user_id)){
        //取消关注;
        $user_follw_redis->unfollow($to_user_id, $room_id);
    } else {
        //未关注,添加关注操作
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $follow_max = $m_config['follow_max'];

        if ($user_follw_redis->follow_count() >= $follow_max) {
            $root['error'] = '关注用户不能超过' . $follow_max . 'api_lang("individual")';
            $root['status'] = 0;
            return $root;
        } else {
            //关注操作
            $user_follw_redis->follow($to_user_id, $room_id);
            //若在黑名单，解除拉黑
            set_black($user_id, $to_user_id, true);
        }
    }


    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();

    $user_data = array();
    $user_data['fans_count'] = $user_follw_redis->follower_count();//粉丝数
    $user_data['focus_count'] = $user_follw_redis->follow_count();//关注数
    $user_redis->update_db($user_id, $user_data);

    $sql = "update " . DB_PREFIX . "user set fans_count = " . $user_data['fans_count'] . ",focus_count = " . $user_data['focus_count'] . " where id = " . $user_id;
    $GLOBALS['db']->query($sql);

    $user2_follw_redis = new UserFollwRedisService($to_user_id);
    $user_data = array();
    $user_data['fans_count'] = $user2_follw_redis->follower_count();//粉丝数
    $user_data['focus_count'] = $user2_follw_redis->follow_count();//关注数
    $user_redis->update_db($to_user_id, $user_data);

    $sql = "update " . DB_PREFIX . "user set fans_count = " . $user_data['fans_count'] . ",focus_count = " . $user_data['focus_count'] . " where id = " . $to_user_id;
    $GLOBALS['db']->query($sql);


    if ($user_follw_redis->is_following($to_user_id)) {
        $root['has_focus'] = 1;//0:未关注;1:已关注
    } else {
        $root['has_focus'] = 0;
    }
    $root['fans_count'] = $user2_follw_redis->follower_count();
    $root['focus_count'] = $user_follw_redis->follow_count();//关注数
    return $root;
}


/**
 * 结束直播
 * @param unknown_type $video      (id,user_id,group_id,watch_number,begin_time,end_time,room_type)
 * @param string       $video_vid
 * @param string       $is_aborted 1:被服务器异常终止结束(主要是心跳超时)
 */
function do_end_video($video, $video_vid, $is_aborted = 0, $cate_id = 0)
{

    $user_id = $video['user_id'];
    $room_id = $video['id'];
    $group_id = $video['group_id'];
    //$watch_number = $video['watch_number'];

    $video_vid = strim($video_vid);
    if ($video_vid == 'null') $video_vid = '';

    // 关闭上次主播时长任务未领取记录
    $current_at = date('Y-m-d H:i:s'); // 当前时间
    $date = date('Y-m-d');
    $sql = "select * from " . DB_PREFIX . "reward_record where status=0 and created_at >= " . $date . " and anchor_id=" . $user_id . " order by created_at asc";
    $list = $GLOBALS['db']->getAll($sql);
    foreach ($list as $vr) {
        $GLOBALS['db']->autoExecute(DB_PREFIX . "reward_record", ['status' => 2, 'claimed_at' => $current_at], "UPDATE", "id =" . $vr['id']);
        $key = "mission_reward_record_" . $date . "_" . $vr['anchor_id'] . "_" . intval($vr['reward_config_id']);
        $is_insert = json_decode(redis_get($key), true);
        if ($is_insert) {
            $is_insert['status'] = 2;
            redis_set($key, json_encode($is_insert), 60 * 60 * 24);
        }
    }

    /*if ($video_vid == '')
        $is_del_vod = 1;
    else
        $is_del_vod = 0;*/
    $is_del_vod = 1;
    $m_config = load_auto_cache("m_config");
    $short_video_time = $m_config['short_video_time'] ? $m_config['short_video_time'] : 300;

    //私有聊天或小于5分钟的视频，不保存 is_delete = IF(room_type =1 or ((".NOW_TIME." - begin_time) <300),1,is_delete)
    $sql = "update " . DB_PREFIX . "video set live_in = 0,online_status=1,is_aborted = '" . $is_aborted . "',end_time = " . NOW_TIME . ",end_date = '" . to_date(NOW_TIME, 'Y-m-d') . "',video_vid = '" . $video_vid . "',is_del_vod = " . $is_del_vod . ",is_delete = IF(room_type =1 or ((" . NOW_TIME . " - begin_time) <" . $short_video_time . "),1,is_delete) where (live_in =1 or live_in = 2 or live_in = 0) and id = " . $room_id;
    $GLOBALS['db']->query($sql);
    if ($GLOBALS['db']->affected_rows()) {
        if ($cate_id > 0) {
            $sql = "update " . DB_PREFIX . "video_cate a set a.num = (select count(*) from " . DB_PREFIX . "video b where b.cate_id = a.id and b.live_in in (1,3)";
            if ((defined('OPEN_ROOM_HIDE') && OPEN_ROOM_HIDE == 1) && intval($m_config['open_room_hide']) == 1) {
                $sql .= " and b.province <> '" . api_lang('Mars') . "' and b.province <>''";
            }
            $sql .= ") where a.id = " . $cate_id;
            $GLOBALS['db']->query($sql);
        }

        //直播结束,连麦也打上结束标识
        $sql = 'update ' . DB_PREFIX . "video_lianmai set stop_time ='" . NOW_TIME . "' where stop_time = 0 and video_id =" . $room_id;
        $GLOBALS['db']->query($sql);

        //开启公会功能ljz
        if (defined('OPEN_SOCIETY_MODULE') && intval(OPEN_SOCIETY_MODULE) == 1) {
            $video_id = intval($video['id']);
            $m_config = load_auto_cache("m_config");//初始化手机端配置


            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');
            $user_info = $user_redis->getRow_db($user_id, $fields);

            //获取公会审核状态
            $society_status = $GLOBALS['db']->getOne("select status from " . DB_PREFIX . "society where id=" . $user_info['society_id']);
            //判断是否有公会
            if ($user_info['society_id'] > 0 && $society_status == 1) {
                //判断模式
                if ($m_config['society_pattern'] == 0) {//关闭公会模式
                    platform_receipts($user_id, $m_config, $video, $video_id);
                } elseif ($m_config['society_pattern'] == 1) {//有抽成模式
                    society_lv_jf($m_config, $user_id, $video_id, $video, $user_info);
                } elseif ($m_config['society_pattern'] == 2) {//无抽成模式
                    society_receipts($video);
                }
            } else {
                platform_receipts($user_id, $m_config, $video, $video_id);
            }
        }


        //开启公会功能，直播结束后将受益写入公会收益表
        /*if(OPEN_SOCIETY_MODULE == 1){
            society_receipts($video);
        }*/

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        //直播结束时,将redis中计算的数据,同步一份到mysql;
        $fields = array('room_type', 'video_type', 'share_count', 'like_count', 'fans_count', 'sort_num', 'vote_number', 'robot_num', 'watch_number', 'virtual_watch_number', 'max_watch_number', 'channelid', 'prop_table');
        $video_data = $video_redis->getRow_db($room_id, $fields);
        $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $video_data, "UPDATE", "id=" . $room_id);

        $video['vote_number'] = $video_data['vote_number'];
        //开启家族功能
        if (defined('OPEN_FAMILY_MODULE') && intval(OPEN_FAMILY_MODULE) == 1 && intval(OPEN_SOCIETY_MODULE) == 0) {
            family_receipts1($room_id, $user_id, $video);
        }


        if ($video_data['room_type'] == 1) {
            $drop_video = true;
            if (defined('OPEN_EDU_MODULE') && OPEN_EDU_MODULE == 1) {
                // 教育众筹和约课不删除视频
                $sql = "select deal_id,booking_class_id from " . DB_PREFIX . "edu_video_info where video_id = " . $room_id;
                $edu_video_info = $GLOBALS['db']->getRow($sql);
                if ($edu_video_info && ($edu_video_info['deal_id'] > 0 || $edu_video_info['booking_class_id'] > 0)) {
                    $sql = "update " . DB_PREFIX . "video set is_delete = IF(((" . NOW_TIME . " - begin_time) <" . $short_video_time . "),1,0) where id = " . $room_id;
                    $GLOBALS['db']->query($sql);
                    $drop_video = false;
                }
            }
            //私密直播,
            if ($drop_video) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
                $video_private_redis = new VideoPrivateRedisService();
                $video_private_redis->drop_video($room_id);
            }
        }

        $parent_id = 0;
        if (defined('CHILD_ROOM') && CHILD_ROOM == 1) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/ChildRoom.class.php');
            $child_room = new child_room();
            $parent_id = $child_room->parent_id($room_id);
            if ($parent_id != $room_id) {
                $p_video_data = $video_redis->getRow_db($parent_id, $fields);
                $video_data['max_watch_number'] = $p_video_data['max_watch_number'];
            }
        }

        if ($video_data['video_type'] == 1 && $parent_id == $room_id) {
            //0:腾讯云互动直播;1:腾讯云直播
            bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
            $video_factory = new VideoFactory();
            $video_factory->StopLVBChannel($video_data['channelid']);
        }


        //获取直播间，红包 发放记录,主要用于,直播结束后,处理还未被领取的红包
        $red_list = $video_redis->get_reds($room_id);

        if (count($red_list) > 0) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
            $videoRed_redis = new VideoRedRedisService();
            foreach ($red_list as $red_id) {
                if ($videoRed_redis->red_exists($red_id)) {
                    $prop_table = $video_data['prop_table'];
                    if ($prop_table != '') {
                        $sql = "SELECT from_user_id FROM " . $prop_table . " WHERE id=" . $red_id;
                        $from_user_id = $GLOBALS['db']->getOne($sql, true, true);
                    }
                    do {
                        $money = $videoRed_redis->pop_red($red_id);
                        if ($money > 0) {
                            //随机获得一机器人
                            $robot_keys = $videoRed_redis->redis->srandmember($videoRed_redis->user_robot_db, 1);

                            $robot_id = intval($robot_keys[0]);

                            //如果是私密直播间，红包退回发送者
                            if ($video_data['room_type'] == 1) {
                                if (intval($from_user_id)) {
                                    $robot_id = $from_user_id;
                                }

                            }
                            allot_red_to_user($red_id, $robot_id, $money);
                        }

                    } while ($money > 0);
                }
            }
        }

        if ((defined('LIVE_END_TO_SCENE') && LIVE_END_TO_SCENE == 1) && intval($video['is_live_pay']) == 1) {
            //按时付费直播结束后转按场付费
            change_pay_type($video);
        }
        // 增加每日时长统计
        live_duration($video);
        //将mysql数据,同步一份到redis中
        sync_video_to_redis($room_id, '*', false);

        if ($group_id != '') {
            //广播：直播结束
            $ext = array();
            $ext['type'] = 7; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束
            $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
            $ext['show_num'] = $video_data['max_watch_number'];//观看人数
            $ext['fonts_color'] = '';//字体颜色
            $ext['desc'] = '直播结束';//弹幕消息;
            $ext['desc2'] = '直播结束';//弹幕消息;

            //消息发送者
            //$sender = array();
            //$ext['sender'] = $sender;


            #构造高级接口所需参数
            $msg_content = array();
            //创建array 所需元素
            $msg_content_elem = array(
                'MsgType'    => 'TIMCustomElem',       //自定义类型
                'MsgContent' => array(
                    'Data' => json_encode($ext),
                    'Desc' => '',
                    //  'Ext' => $ext,
                    //  'Sound' => '',
                )
            );
            //将创建的元素$msg_content_elem, 加入array $msg_content
            array_push($msg_content, $msg_content_elem);

            //发送广播：直播结束
            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();
            $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);

            if (defined('CHILD_ROOM') && CHILD_ROOM == 1) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/ChildRoom.class.php');
                $child_room = new child_room();
                $child_ids = $child_room->child_id($room_id);
                foreach ($child_ids as $child_id) {
                    $ext['room_id'] = $child_id;
                    $ret = $api->group_send_group_msg2($user_id, $group_id, array(
                        array(
                            'MsgType'    => 'TIMCustomElem',       //自定义类型
                            'MsgContent' => array(
                                'Data' => json_encode($ext),
                                'Desc' => '',
                            )
                        )
                    ));
                }
            }

            //=========================================================
            //广播：直播结束
            $ext = array();
            $ext['type'] = 18; //18：直播结束（全体推送的，用于更新用户列表状态）
            $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应

            //18：直播结束（全体推送的，用于更新用户列表状态）
            $api->group_send_group_system_notification($m_config['on_line_group_id'], json_encode($ext), null);
            //=========================================================
            //直播结束解散群组
            $destroy_ret = $api->group_destroy_group($video['group_id']);

            return $ret;
        } else {
            return true;
        }
    } else {
        return false;
    }

}

/**
 * 直播结束 后相关数据处理（在后台定时执行）
 *
 *$video id,user_id,group_id,room_type,begin_time,end_time,video_vid,is_delete,is_del_vod
 *
 * 1、处理 bogo_video_viewer 异常数据;没有begin_time时间的,用bogo_video.begin_time代替; 没有end_time 用bogo_video.end_time代替
 * 2、统计用户在线时长，bogo_video_viewer
 * 3、移除bogo_video_viewer,bogo_video_contribution,bogo_video_monitor,bogo_video_share,bogo_video,bogo_video_lianmai数据到历史表中
 * @param unknown_type $video (id,user_id,watch_number,vote_number,group_id,room_type,begin_time,end_time)
 */
function do_end_video_2(&$video_redis, &$api, $video_id)
{

    $pInTrans = $GLOBALS['db']->StartTrans();
    //  var_dump(1);exit;
    try {
        $sql = "update " . DB_PREFIX . "video set live_in = -1 where live_in = 0 and id = " . $video_id;
        //echo $sql."<br>";
        $GLOBALS['db']->query($sql);
        if ($GLOBALS['db']->affected_rows()) {

            $sql = "select * from " . DB_PREFIX . "video where id = " . $video_id;
            //$video = $video_redis->getRow_db($video_id);
            $video = $GLOBALS['db']->getRow($sql);

            $group_id = $video['group_id'];
            $begin_time = $video['begin_time'];
            $end_time = $video['end_time'];
            $user_id = $video['user_id'];
            $is_del_vod = $video['is_del_vod'];
            $is_delete = $video['is_delete'];
            $room_type = $video['room_type'];//房间类型 : 1私有群（Private）,0公开群（Public）,2聊天室（ChatRoom）,3互动直播聊天室（AVChatRoom）
            /*
            //处理bogo_video_viewer 异常数据
            $sql = "update ".DB_PREFIX."video_viewer set is_exception = 1, begin_time = '".$begin_time."' where begin_time = 0 and group_id = '".$group_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql = "update ".DB_PREFIX."video_viewer set is_exception = 1,end_time = '".$end_time."' where end_time = 0 and group_id = '".$group_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            //bogo_video_viewer
            //统计用户在线时长
            $sql = "update ".DB_PREFIX."user u,
                    (select user_id, sum(end_time - begin_time) as time_len from ".DB_PREFIX."video_viewer where group_id = '".$group_id."' group by user_id) t
                     set u.online_time = u.online_time + t.time_len
                    where t.user_id = u.id";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            //将本次直播观众移到历史表中
            $sql = "insert into ".DB_PREFIX."video_viewer_history(video_id,group_id,user_id,begin_time,end_time,is_robot,is_exception) select ".$video_id." as video_id,group_id,user_id,begin_time,end_time,is_robot,is_exception from ".DB_PREFIX."video_viewer where group_id='".$group_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql= "delete from ".DB_PREFIX."video_viewer where group_id='".$group_id."'";
            $GLOBALS['db']->query($sql);
            ///echo $sql."<br>";

            //将本次直播贡献排行移到历史表中
            $sql = "insert into ".DB_PREFIX."video_contribution_history(video_id,user_id,num) select video_id,user_id,num from ".DB_PREFIX."video_contribution where video_id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql= "delete from ".DB_PREFIX."video_contribution where video_id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";
            */

            //将本次直播 心跳监听 移到历史表中
            $sql = "insert into " . DB_PREFIX . "video_monitor_history(video_id,user_id,vote_number,watch_number,lianmai_num,monitor_time,statistic_time,appCPURate,sysCPURate,sendKBps,recvKBps,sendLossRate,fps,device) select video_id,user_id,vote_number,watch_number,lianmai_num,monitor_time,statistic_time,appCPURate,sysCPURate,sendKBps,recvKBps,sendLossRate,fps,device from " . DB_PREFIX . "video_monitor where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql = "delete from " . DB_PREFIX . "video_monitor where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            //将本次直播 用户分享记录 移到历史表中
            $sql = "insert into " . DB_PREFIX . "video_share_history(video_id,user_id,type,create_time) select video_id,user_id,type,create_time from " . DB_PREFIX . "video_share where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql = "delete from " . DB_PREFIX . "video_share where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            //修正异常连麦结束数据
            $sql = 'update ' . DB_PREFIX . "video_lianmai set stop_time ='" . $end_time . "' where stop_time = 0 and video_id ='" . $video_id . "'";
            $GLOBALS['db']->query($sql);

            //将本次直播 用户连麦记录 移到历史表中
            $sql = "insert into " . DB_PREFIX . "video_lianmai_history(video_id,user_id,start_time,stop_time) select video_id,user_id,start_time,stop_time from " . DB_PREFIX . "video_lianmai where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql = "delete from " . DB_PREFIX . "video_lianmai where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            /*
            //将本次直播 礼物记录 移到历史表中
            $sql = "insert into ".DB_PREFIX."video_prop_history(id,prop_id,prop_name,total_score,total_diamonds,use_diamonds,total_ticket,from_user_id,to_user_id,create_time,num,video_id,group_id,is_red_envelope,create_date,ActionStatus,ErrorInfo,ErrorCode) select id,prop_id,prop_name,total_score,total_diamonds,use_diamonds,total_ticket,from_user_id,to_user_id,create_time,num,video_id,group_id,is_red_envelope,create_date,ActionStatus,ErrorInfo,ErrorCode from ".DB_PREFIX."video_prop where video_id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql= "delete from ".DB_PREFIX."video_prop where video_id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            //将本次直播 红包记录 移到历史表中
            $sql = "insert into ".DB_PREFIX."video_red_envelope_history(id,video_id,video_prop_id,user_id,nick_name,diamonds,sex,head_image,create_time) select id,video_id,video_prop_id,user_id,nick_name,diamonds,sex,head_image,create_time from ".DB_PREFIX."video_red_envelope where video_id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql= "delete from ".DB_PREFIX."video_red_envelope where video_id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            */
            /* bogo_video_private 放在redis中处理
            if ($room_type == 1){
                //将本次私聊直播 被护肩 的用户 移到历史表中
                $sql = "insert into ".DB_PREFIX."video_private_history(video_id,user_id) select video_id,user_id from ".DB_PREFIX."video_private where video_id='".$video_id."'";
                $GLOBALS['db']->query($sql);
                //echo $sql."<br>";

                $sql= "delete from ".DB_PREFIX."video_private where video_id='".$video_id."'";
                $GLOBALS['db']->query($sql);
            }
            */
            //echo $sql."<br>";

            /*
            //把bogo_video 也移历史表中 end_date = ".to_date(NOW_TIME,'Y-m-d')
            $fields = "id,title,user_id,live_in,end_date,watch_number,virtual_watch_number,vote_number,cate_id,province,city,create_time,begin_time,end_time,group_id,destroy_group_status,long_polling_key,is_hot,is_new,max_watch_number,room_type,is_del_vod,video_vid,monitor_time,is_delete,robot_num,robot_time,channelid,is_aborted,tipoff_count";
            $sql = "insert into ".DB_PREFIX."video_history(".$fields.") select ".$fields." from ".DB_PREFIX."video where id='".$video_id."'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";
            */

            //将本次直播 麦位记录 移到历史表中
            $sql = "insert into " . DB_PREFIX . "voice_even_wheat_log_history(video_id,user_id,status,location,gift_earnings,the_gift_earnings,nick_name,head_image,addtime,endtime,monitor_time) select video_id,user_id,status,location,gift_earnings,the_gift_earnings,nick_name,head_image,addtime,endtime,monitor_tim from " . DB_PREFIX . "voice_even_wheat_log_history where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);
            //echo $sql."<br>";

            $sql = "delete from " . DB_PREFIX . "voice_even_wheat_log_history where video_id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);

            $video['live_in'] = 0;//改成：直播结束 live_in 0:结束;1:正在直播;2:创建中;3:回看

            $end_time = intval($video['end_time']);
            if ($end_time == 0) $end_time = to_timespan($video['monitor_time']);
            $video['len_time'] = $video['len_time'] + ($end_time - $video['begin_time']);
            $video['video_t_id'] = $video['id'];
            unset($video['id']);
            $GLOBALS['db']->autoExecute(DB_PREFIX . "video_history", $video, "INSERT");

            $sql = "delete from " . DB_PREFIX . "video where id='" . $video_id . "'";
            $GLOBALS['db']->query($sql);

            //将付费直播记录移到历史表
            if (intval($video['is_live_pay']) == 1) {
                syn_live_pay_to_history($video_id, $video['user_id']);
            }


            //echo $sql."<br>";
            /*
            //删除禁言数据
            $sql = "delete from ".DB_PREFIX."video_forbid_send_msg where group_id='".$group_id."'";
            $GLOBALS['db']->query($sql);
            */
            //video_count
            //$sql = "select id,title,begin_time,max_watch_number from ".DB_PREFIX."video_history where is_delete = 0 and is_del_vod = 0 and user_id = '".$to_user_id."' order by ".$sort_field." limit ".$limit;

            $sql = "select count(*) as num from " . DB_PREFIX . "video_history where is_delete = 0 and is_del_vod = 0 and user_id = '" . $user_id . "'";
            $video_count = $GLOBALS['db']->getOne($sql);

            $sql = "update " . DB_PREFIX . "user set video_count = " . $video_count . " where id = " . $user_id;
            $GLOBALS['db']->query($sql);


            //将直播间,用户领取的红包记录,同步一份到mysql
            syn_red_to_mysql($video_id);

            $GLOBALS['db']->Commit($pInTrans);
            $pInTrans = false;

            /*改成在 删除视频时 解散群组
            //如果是删除状态,则解散群组
            if ($is_delete == 1 && $video['destroy_group_status'] == 1){
                if ($video['group_id'] != ''){
                    $ret = $api->group_destroy_group($video['group_id']);
                    $data['destroy_group_status'] = $ret['ErrorCode'];

                    $video_redis->del_video_group_db($video['group_id']);//只有在：解散 聊天组时，才删除
                }else{
                    $data['destroy_group_status'] = 0;
                }
            }
            $video_redis->update_db($video_id, $data);
            */

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_data = array();
            $user_data['video_count'] = $video_count;
            $user_redis->update_db($user_id, $user_data);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $data = [
                'game_log_id'   => 0,
                'banker_id'     => 0,
                'banker_status' => 0,
                "banker_log_id" => 0,
                "banker_name"   => '',
                "banker_img"    => '',
                'coin'          => 0,
            ];
            $video_redis->update_db($video_id, $data);

            if ($is_del_vod == 0 && $is_delete == 1) {
                $m_config = load_auto_cache("m_config");
                $del_short_video = $m_config['del_short_video'] ? $m_config['del_short_video'] : 1;
                if ($del_short_video) {
                    return del_vodset($video, true);//直播删除短视频
                } else {
                    return $video_id;
                }
            } else {
                return $video_id;
            }
        } else {
            $GLOBALS['db']->Rollback($pInTrans);
            return 0;
        }

    } catch (Exception $e) {
        //异常回滚
        $GLOBALS['db']->Rollback($pInTrans);
        return 0;
    }
}

/**
 * 设置 黑名单/取消 黑名单
 * @param unknown_type $user_id    关注用户ID
 * @param unknown_type $to_user_id 被关注的用户ID
 *                                 $force_remove: 强制取消黑名单
 * @return multitype:number string
 */
function set_black($user_id, $to_user_id, $force_remove = false)
{
    $root = array();
    $root['status'] = 1;
    //
    $pInTrans = $GLOBALS['db']->StartTrans();
    try {
        $sql = "select id from " . DB_PREFIX . "black where black_user_id = " . $to_user_id . " and user_id = " . $user_id;
        $black_id = $GLOBALS['db']->getOne($sql);

        if ($black_id > 0 || $force_remove) {

            if ($black_id > 0) {

                //echo "black_a_id:".$black_id;


                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();

                $ret = $api->sns_black_delete((string)$user_id, (string)$to_user_id);

                if ($ret['ActionStatus'] == 'OK') {
                    //取消黑名单操作;
                    $sql = "delete from " . DB_PREFIX . "black where id = " . $black_id;
                    $GLOBALS['db']->query($sql);
                } else {
                    $root['status'] = 0;
                    $root['error'] = $ret['ErrorCode'] . $ret['ErrorInfo'];
                }
            }
        } else {
            //echo "black_b_id:".$black_id;
            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();
            $ret = $api->sns_black_import((string)$user_id, (string)$to_user_id);
            //print_r($ret);
            if ($ret['ActionStatus'] == 'OK') {
                //未关注,需要关注操作;
                $black = array();
                $black['black_user_id'] = $to_user_id;
                $black['user_id'] = $user_id;
                $black['create_time'] = NOW_TIME;
                $GLOBALS['db']->autoExecute(DB_PREFIX . "black", $black, "INSERT");

                //取消关注
                //set_follow($user_id,$to_user_id,true);
                redis_set_follow($user_id, $to_user_id, true);
            } else {
                $root['status'] = 0;
                $root['error'] = $ret['ErrorCode'] . $ret['ErrorInfo'];
            }
        }

        $sql = "select count(id) as num from " . DB_PREFIX . "black where black_user_id = " . $to_user_id . " and user_id = " . $user_id;
        //$root['sql'] = $sql;
        if ($GLOBALS['db']->getOne($sql) > 0) {
            $root['has_black'] = 1;//0:未黑名单;1:黑名单
        } else {
            $root['has_black'] = 0;
        }

        if ($root['status'] == 1) {
            $GLOBALS['db']->Commit($pInTrans);
        } else {
            $GLOBALS['db']->Rollback($pInTrans);
        }

    } catch (Exception $e) {
        //异常回滚
        $root['error'] = $e->getMessage();
        $root['status'] = 0;

        $GLOBALS['db']->Rollback($pInTrans);
    }
    return $root;
}


/**
 * 获得点播资料
 * @param unknown_type $video_vid
 * @return multitype:multitype: number string
 * https://www.qcloud.com/doc/api/257/2331
 */
function get_vodset($video_vid)
{
    $root = array();
    $root['status'] = 1;
    //$root['vodset'] = array();

    //var_dump($video_vid);

    $video_vid = htmlspecialchars_decode($video_vid);
    //var_dump($video_vid);

    $video_vid = str_replace("&quot;", "", $video_vid);
    $video_vid = str_replace("[", "", $video_vid);
    $video_vid = str_replace("]", "", $video_vid);
    $video_vid = str_replace('"', '', $video_vid);
    $video_vid = explode(",", $video_vid);

    //var_dump($video_vid2);

    //$video_vid3 = json_decode($video_vid);

    //var_dump($video_vid3);
    //print_r($video_vid);
    //exit;

    if (count($video_vid) > 0) {
        bogo_require(APP_ROOT_PATH . 'system/QcloudApi/QcloudApi.php');

        $m_config = load_auto_cache("m_config");

        $config = array('SecretId'      => $m_config['qcloud_secret_id'],
                        'SecretKey'     => $m_config['qcloud_secret_key'],
                        'RequestMethod' => 'GET',
                        'DefaultRegion' => 'gz');

        //print_r($config);exit;

        $service = QcloudApi::load(QcloudApi::MODULE_VOD, $config);

        foreach ($video_vid as $k => $v) {
            $package = array('vid' => $v);
            $ret = $service->DescribeRecordPlayInfo($package);
            //var_dump($package);
            //var_dump($ret);
            //exit;

            if ($ret === false) {
                $error = $service->getError();
                $root['status'] = 0;
                $root['error'] = $v . ";" . $error->getCode() . ";" . $error->getMessage();
            } else {
                $root['vodset'][] = $ret;
            }


        }
    } else {
        $root['status'] = 0;
        $root['error'] = '无效的直播录制文件';
    }

    return $root;
}

/**
 * 删除录制视频
 * @param unknown_type $room_id
 */
function del_vodset($video, $is_del_group = false)
{

    if (!is_array($video)) {
        $video = array('id' => $video);
    }

    $room_id = $video['id'];
    $root = array();

    $root['status'] = 1;
    $root['room_id'] = $room_id;

    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
    $video_factory = new VideoFactory();
    if ($video['video_type'] == 1 && $video['channelid'] && strpos($video['channelid'], '_')) {
        $root['delvodset'] = $video_factory->DeleteVodFiles($video['channelid'], $video['begin_time']);
    } else {
        $filename = $room_id;
        if ($video['video_type'] == 1) {
            $filename = 'live' . $room_id;
        }
        $root['delvodset'] = $video_factory->DeleteVodFilesByFileName($filename);
    }

    //$sql = "select id as room_id,video_vid,is_del_vod,group2_id,group2_status from ".DB_PREFIX."video_history where id = ".$room_id;
    //$video = $GLOBALS['db']->getRow($sql);


    $isdelall = true;
    foreach ($root['delvodset'] as $k => $v) {
        if ($v != 1 && isset($v['code']) && $v['code'] != 0) {
            $isdelall = false;
            $root['error'] = $root['error'] . ";key:" . $k . ";code:" . $v['code'] . ";message:" . $v['message'];
        }
    }


    if ($isdelall) {
        $sql = "update " . DB_PREFIX . "video_history set is_del_vod = 1 where id = " . $room_id;
        $GLOBALS['db']->query($sql);

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        $data = array();
        $data['is_del_vod'] = 1;
        $video_redis->update_db($room_id, $data);

        //解散聊天组
        if ($is_del_group) {
            $sql = "select destroy_group_status,group_id from " . DB_PREFIX . "video_history where id = " . $room_id;
            $video_data = $GLOBALS['db']->getRow($sql);

            //如果是删除状态,则解散群组
            if ($video_data['destroy_group_status'] == 1) {
                if ($video_data['group_id'] != '') {
                    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                    $api = createTimAPI();
                    $ret = $api->group_destroy_group($video_data['group_id']);
                    $destroy_group_status = $ret['ErrorCode'];

                } else {
                    $destroy_group_status = 0;
                }

                $sql = "update " . DB_PREFIX . "video_history set destroy_group_status = " . $destroy_group_status . " where id = " . $room_id;
                $GLOBALS['db']->query($sql);

                $data = array();
                $data['destroy_group_status'] = $destroy_group_status;
                $video_redis->update_db($room_id, $data);
            }
        }

        //将直播间,用户领取的红包记录,同步一份到mysql
        syn_red_to_mysql($room_id);

        $sql = "select destroy_group_status,is_del_vod from " . DB_PREFIX . "video_history where id = " . $room_id;
        $video_data = $GLOBALS['db']->getRow($sql);
        if ($video_data['destroy_group_status'] == 0 && $video_data['is_del_vod'] == 1) {
            $video_redis->del_db($room_id);//清空redis上视频相关数量【bogo_video,禁言,点赞,观众列表,group_id与 video_id对应数据】
        }
    }

    //print_r($root);

    return $root;
}

//防盗连接sign = md5(【腾讯号 + 用户ID + 房间号】)
function check_sign($sign, $sign_version, $tim_sdkappid, $user_id, $room_id)
{
    //防盗连接问题 sign = md5(【腾讯号 + 用户ID + 房间号】)
    if ($sign_version == '1.0') {
        $sign2 = md5($tim_sdkappid . $user_id . $room_id);
    } else {
        $sign2 = md5($tim_sdkappid . $user_id . $room_id);
    }

    return (($sign == $sign2) && $sign != '');
}

//获取直播信息2
function get_video_info2($room_id, $user_id, $type, $param, $require_type = 0)
{
    //1: 自动会多返回一个podcast2(room_id,head_image)参数,用于上下滚动切换时，预加载使用; 当预加载直播失效时，自动返回下一个有效的直播房间
    $has_scroll = strim($param['has_scroll']);
    //私密直播key
    $private_key = strim($param['private_key']);
    //0:观看直播;1:点播
    $is_vod = intval($param['is_vod']);
    //性别 0:全部, 1-男，2-女，默认为：0
    $sex = intval($param['sex']);
    //话题id，默认为：0
    $cate_id = intval($param['cate_id']);
    //城市(空为:热门)，默认为：空
    $city = strim($param['city']);
    $type = intval($param['type']);
    if ($city == '热门' || $city == 'null') {
        $city = '';
    }
    //1：PC端；0：app端
    $require_type = intval($require_type);
    $root = array();
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    //获得当前用户和主播的手机资料
    $user_info = $user_redis->getRow_db($user_id, array('id', 'user_level', 'is_robot', 'is_authentication', 'luck_num', 'mobile', 'is_effect', 'vip_expire_time', 'is_vip', 'noble_car_id'));

    if ($room_id > 0) {

        if ($user_info['is_effect'] == 0) {
            $root = array();
            $root['error'] = api_lang("invalid_account");
            $root['status'] = 0;
            if (!$require_type) {
                ajax_return($root);
            }
        }

        $fields = array('id', 'channelid', 'create_type', 'head_image', 'cate_id', 'title', 'thumb_head_image', 'xpoint', 'ypoint', 'sort_num', 'push_rtmp', 'play_url', 'play_mp4', 'play_flv', 'play_rtmp', 'play_hls', 'room_type', 'user_id', 'live_in', 'monitor_time', 'max_watch_number', 'online_status', 'video_vid', 'is_del_vod', 'is_delete', 'video_type', 'group_id', 'room_type', 'private_key', 'share_type', 'province', 'city', 'pai_id', 'begin_time', 'create_time', 'live_pay_time', 'is_live_pay', 'live_pay_type', 'live_fee', 'live_is_mention', 'room_title', 'pay_room_id', 'is_shop', 'push_type');
        if (OPEN_GAME_MODULE == 1) {
            $fields[] = 'game_log_id';
        }

        $m_config = load_auto_cache("m_config");//手机端配置

        $root = $video_redis->getRow_db($room_id, $fields);
        if (!$root || !$root['id']) {
            $fields = 'id, channelid, create_type, head_image, cate_id, title, thumb_head_image, xpoint, ypoint, sort_num, push_rtmp, play_url, play_mp4, play_flv, play_rtmp, play_hls, room_type, user_id, live_in, monitor_time, max_watch_number, online_status, video_vid, is_del_vod, is_delete, video_type, group_id, room_type, private_key, share_type, province, city, pai_id, begin_time, create_time, live_pay_time, is_live_pay, live_pay_type, live_fee, live_is_mention, room_title, pay_room_id, is_shop, push_type';
            $root = Db::name("video")->field($fields)->where("id=" . $room_id)->find();
            //将mysql数据,同步一份到redis中
            sync_video_to_redis($room_id, '*', false);
        }
        if ($root['user_id'] != $user_id) {
            // 房主不是自己需要处理当前的用户是否开直播间 是否正在开直播
            $sql = "select * from " . DB_PREFIX . "video where  user_id = " . $user_id . " and live_in=1";
            $video_end = $GLOBALS['db']->getRow($sql, true, true);
            if ($video_end) {
                $root = array();
                $root['error'] = api_lang("unable_enter_other_rooms");
                $root['status'] = 0;
                ajax_return($root);
            }
        }
        if ($root['pay_room_id'] === false) {
            $root['pay_room_id'] = 0;
        }

        //累计观看次数;累计观看次数明显大于其它用户观看次数时，及有可能是盗连接用户，需要禁用它
        $sql = "update  " . DB_PREFIX . "user set view_count = view_count + 1 where id = " . $user_id;
        $GLOBALS['db']->query($sql);

        $monitor_overtime = $m_config['monitor_overtime'];
        if ($monitor_overtime <= 0) $monitor_overtime = 40;

        if ($root['live_in'] == 1 && $root['monitor_time'] && strtotime($root['monitor_time']) < NOW_TIME - $monitor_overtime) {
            //心跳超时
            crontab_do_end_video();

            $root = $video_redis->getRow_db($room_id, $fields);
        }
        //兼容IM推送失败列表不刷新，存在已关闭的直播显示问题
        if (intval($root['live_in']) == 0 && $is_vod == 0) {
            $root = array();
            $root['error'] = api_lang("Live_broadcast_is_closed");
            $root['status'] = 0;
            if ($require_type == 1) {
                return $root;
            } else {
                ajax_return($root);
            }
        }
        $root['head_image'] = get_spec_image($root['head_image']);
        $root['thumb_head_image'] = get_spec_image($root['thumb_head_image']);

        //每日任务
        $root['open_daily_task'] = 0;
        if (defined('OPEN_MISSION') && OPEN_MISSION == 1 && $m_config['mission_switch']) {
            require_once APP_ROOT_PATH . 'mapi/lib/core/Model.class.php';
            Model::$lib = APP_ROOT_PATH . 'mapi/lib/';
            if (sizeof(Model::build('mission')->getMissionList($user_id)) > 0) {
                $root['open_daily_task'] = 1;
            }
        }
        //-------------------------------------
        //sdk_type 0:使用腾讯SDK、1：使用金山SDK
        //映射关系类型  腾讯云直播, 金山云，星域，  云 ，阿里云
        //video_type     1          2        3      4       5
        //sdk_type       0          1        -      -       -
        $root['sdk_type'] = get_sdk_info(intval($m_config['video_type']));

        $filter_false = array(
            'create_type'      => 0,
            'video_vid'        => '',
            'is_del_vod'       => 0,
            'is_delete'        => 0,
            'private_key'      => '',
            'group_id'         => '',
            'video_type'       => 0,
            'pai_id'           => 0,
            'max_watch_number' => 0,
            'head_image'       => '',
            'thumb_head_image' => '',
            'xpoint'           => 0,
            'ypoint'           => 0,
            'sort_num'         => 0,
            'play_flv'         => '',
            'play_rtmp'        => '',
            'play_hls'         => '',
            'play_mp4'         => '',
            'play_url'         => '',
            'push_rtmp'        => '',
            'cate_id'          => 0,
            'title'            => '',
            'is_live_pay'      => 0,
            'live_pay_type'    => 0,
            'live_pay_time'    => '',
            'live_fee'         => 0,
            'live_is_mention'  => 0,
            'pay_room_id'      => 0
        );

        if (OPEN_GAME_MODULE == 1) {
            $filter_false['game_log_id'] = 0;
        }

        filter_false($root, $filter_false);
        //限制主播PC端发起直播，APP端重复登录
        $dev_type = strim($_REQUEST['sdk_type']);
        if ($root['user_id'] == $user_id && $root['create_type'] == 1 && $is_vod != 1 && ($dev_type == 'ios' || $dev_type == 'android')) {
            $root['error'] = "PC端发起的直播，APP不能重复登录";
            $root['status'] = 0;
            ajax_return($root);
        }
        //vip
        if ($user_id != $root['user_id'] && (defined('OPEN_VIP') && OPEN_VIP == 1) && intval($m_config['open_vip']) == 1) {

            $vip_expire_time = intval($user_info['vip_expire_time']);
            $is_vip = intval($user_info['is_vip']);
            if ($is_vip != 1 || ($is_vip == 1 && $vip_expire_time > 0 && $vip_expire_time < NOW_TIME)) {
                $root['error'] = "非VIP会员或VIP会员已过期，请先购买。";
                $root['status'] = 0;
                $root['is_vip'] = 0;
                $root['play_url'] = '';
                $root['is_live_pay'] = 0;
                if ($require_type == 1) {
                    return $root;
                } else {
                    ajax_return($root);
                }

            }
        } else {
            $vip_expire_time = intval($user_info['vip_expire_time']);
            $is_vip = intval($user_info['is_vip']);
        }

        $group_id = $root['group_id'];
        $p_user_id = $root['user_id'];

        $is_order = 0;

        //付费直播
        if (OPEN_LIVE_PAY == 1 && !$is_order) {
            $result = get_pay_video_info($root);
            if ($result['status'] == 0 && $root['user_id'] != $user_id) { //去掉这个参数; 0腾讯云互动直播,1腾讯云直播  &&intval($m_config['video_type'])==1

                $root_result = $result;
                $root_result['status'] = 1;

                if (intval($m_config['is_only_play_video'])) {
                    $root_result['is_only_play_voice'] = 0;
                } else {
                    $root_result['is_only_play_voice'] = 1;
                }

                //防盗连接问题 sign = md5(【腾讯号 + 用户ID + 房间号】)
                $sign = strim($param['sign']);
                $sign_version = strim($param['sign_version']);//1.0

                //只有签名对，才返回：视频预览地址 防盗连接
                if (check_sign($sign, $sign_version, $m_config['tim_sdkappid'], $user_id, $room_id)) {
                    $key = "preview:video:{$room_id}:{$user_id}";

                    $preview_num = intval($GLOBALS['cache']->get($key, true));
                    $preview_num = $preview_num + 1;
                    $GLOBALS['cache']->set($key, $preview_num, 600, true);

                    $preview_play_url = '';
                    if ($preview_num > 2) {
                        $root_result['is_only_play_voice'] = 1;//超过2次预览后，只显示声音
                    }

                    //视频预览地址,后面添加较验
                    $preview_play_url = $root['play_url'];
                    //直播状态,默认播放flv格式;
                    if (($root['live_in'] == 1 || $root['live_in'] == 2) && $preview_play_url == '') {
                        $preview_play_url = $root['play_flv'];
                    }

                    if ($root['live_in'] == 3 && $preview_play_url == '') {
                        $file_info = load_auto_cache('video_file', array(
                            'id'          => $root['room_id'],
                            'video_type'  => $root['video_type'],
                            'channelid'   => $root['channelid'],
                            'begin_time'  => $root['begin_time'],
                            'create_time' => $root['create_time'],
                        ));
                        if ($file_info['play_url']) {
                            $preview_play_url = $file_info['play_url'];
                        }
                    }
                }
                if (intval($m_config['countdown']) == 0) {
                    $preview_play_url = '';
                }

                $root_result['id'] = $room_id;
                $root_result['room_id'] = $room_id;
                $root_result['group_id'] = $group_id;
                $root_result['user_id'] = $p_user_id;
                $root_result['countdown'] = intval($m_config['countdown']);//(秒) 付费直播间预览倒计时，默认为10，0为关闭倒计时预览
                $root_result['preview_play_url'] = $preview_play_url ? $preview_play_url : '';
                $root_result['online_status'] = $root['online_status'];
                if (($root['live_in'] == 3 || $root['live_in'] == 0) && $is_vod == 1) {
                    $root_result['has_video_control'] = 1;//点播时，视频控制操作
                }
                if ($require_type == 1) {
                    $root_result['status'] = 0;
                    return $root_result;
                } else {
                    ajax_return($root_result);
                }

            } else {
                $is_live_pay = intval($result['is_live_pay']);
                $live_pay_type = intval($result['live_pay_type']);
                $live_fee = intval($result['live_fee']);
                $is_pay_over = intval($result['is_pay_over']);
                if ((defined('PUBLIC_PAY') && PUBLIC_PAY == 1) && $m_config['switch_public_pay'] == 1 && $m_config['public_pay'] > 0) {
                    $is_live_pay = 1;
                }
            }
        }

        //非主播,不下发推流地址
        if ($root['user_id'] != $user_id) {
            $root['push_rtmp'] = '';
        }

        //直播状态,默认播放flv格式;
        if (($root['live_in'] == 1 || $root['live_in'] == 2) && $root['play_url'] == '') {
            $root['play_url'] = $root['play_flv'];
        }

        if ($root['room_type'] == 1 && $root['user_id'] != $user_id) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
            $video_private_redis = new VideoPrivateRedisService();
            if ($private_key != '' && $private_key != 'null') {
                if ($private_key == $root['private_key']) {
                    //检查用户是否被踢除,被踢除后，不能再加入;除非再次邀请
                    if ($video_private_redis->check_user_drop($room_id, $user_id)) {
                        $root['error'] = api_lang("You_have_been_kicked_out");
                        $root['status'] = 0;
                        if ($require_type == 1) {
                            return $root;
                        } else {
                            ajax_return($root);
                        }

                    } else {
                        //将用户加入私密直播,可重复操作
                        $video_private_redis->push_user($room_id, $user_id);
                    }
                } else {
                    $root['error'] = "无效的私密钥匙:" . $private_key;
                    $root['status'] = 0;
                    if ($require_type = 1) {
                        return $root;
                    } else {
                        ajax_return($root);
                    }

                }
            } else {
                //私聊,判断用户是否在被邀请的名单中,被踢除后，也不能重新加入
                $is_bm = false;

                if ($video_private_redis->check_user_push($room_id, $user_id) == false && !$is_bm) {
                    $root['error'] = "私聊群,用户不在邀请名单中";
                    $root['status'] = 0;
                    if ($require_type == 1) {
                        return $root;
                    } else {
                        ajax_return($root);
                    }

                }
            }
        }


        if ($root) {
            $param = array(
                'sex'        => $sex,
                'city'       => $city,
                'cate_id'    => $cate_id,
                'is_vod'     => $is_vod,
                'video_type' => $root['video_type'],
                'sort_num'   => $root['sort_num']
            );
            $root['room_id'] = $room_id;
            //$video_list = get_rand_video($type,2,$user_id);
            $video_list = get_rand_video($room_id, $user_id, $type, $param);
            $video_previous = $video_list[0];
            if (!$video_previous) {
                $video_previous = $root;
            }
            $video_next = $video_list[1];
            if (!$video_next) {
                $video_next = $root;
            }
        }
    }

    if ($root['id']) {
        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

        //获得当前用户资料。这里注释是因为有的地方没有把用户信息变更存入缓存，上面直接使用sql查了数据库
//        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
//        $user_redis = new UserRedisService();
//        $user_info = $user_redis->getRow_db($user_id, array('id', 'user_level', 'is_robot', 'is_authentication', 'luck_num', 'mobile'));

        //live_in 0:结束;1:正在直播;2:创建中;3:回看
        if (($root['live_in'] == 1 && $is_vod == 0) || ($user_id == $root['user_id'] && $is_vod == 0) || (($root['live_in'] == 3 || $root['live_in'] == 0) && $is_vod == 1)) {

            //'video_vid','is_del_vod','is_delete','video_type','play_url','group_id','room_type','private_key'
            $root['room_id'] = $room_id;
            $root['podcast'] = getuserinfo($user_id, $root['user_id'], $root['user_id'], []);

            $root['podcast']['user']['nick_name'] = emoji_decode($root['podcast']['user']['nick_name']);

            $root['luck_num'] = $root['podcast']['user']['luck_num'];
            if (empty($root['room_title'])) {
                $root['room_title'] = $root['podcast']['user']['room_title'];
            }
            if ($video_previous) {
                $podcast_previous = array();
                $podcast_previous['room_id'] = $video_previous['room_id'];
                $video_previous['thumb_head_image'] = $video_previous['thumb_head_image'] != '' ? $video_previous['thumb_head_image'] : $video_previous['head_image'];
                $podcast_previous['head_image'] = get_spec_image($video_previous['thumb_head_image']);

                $root['podcast_previous'] = $podcast_previous;
            }

            if ($video_next) {
                $podcast_next = array();
                $podcast_next['room_id'] = $video_next['room_id'];
                $video_next['thumb_head_image'] = $video_next['thumb_head_image'] != '' ? $video_next['thumb_head_image'] : $video_next['head_image'];
                $podcast_next['head_image'] = get_spec_image($video_next['thumb_head_image']);

                $root['podcast_next'] = $podcast_next;
            }

            $user_level = intval($user_info['user_level']);
            if ($user_level == 0) $user_level = 1;

            $sort_num = $user_level * $user_redis->gz_level_weight;
            if ($user_info['is_robot'] == 0) {
                $sort_num += $user_redis->gz_real_weight;
            }
            if ($user_info['is_authentication'] == 2) {
                $sort_num += $user_redis->gz_rz_weight;
            }
            //观众列表的排序权重
            $root['sort_num'] = $sort_num;

            //live_in 0:结束;1:正在直播;2:创建中;3:回看
            if (($root['live_in'] == 3 || $root['live_in'] == 0) && $is_vod == 1) {
                //录制地址不能为空,且录制文件没有被删除
                if ($root['is_del_vod'] == 0) {
                    //如果是线上有回放的情况需要去请求回放信息，不需要的话直接使用下面的注释代码赋值省的请求比较耗时影响播放速度
                    if (empty($root['play_url'])) {
                        $file_info = load_auto_cache('video_file', array(
                            'id'          => $root['room_id'],
                            'video_type'  => $root['video_type'],
                            'channelid'   => $root['channelid'],
                            'begin_time'  => $root['begin_time'],
                            'create_time' => $root['create_time'],
                        ));
                        if ($file_info['play_url']) {
                            $root['play_url'] = $file_info['play_url'];
                        } else {
                            $root['play_url'] = get_spec_image($root['play_url']);
                        }
                        $root['urls'] = $file_info['urls'];
                    } else {
                        $root['play_url'] = get_spec_image($root['play_url']);
                    }
                }

                if ($root['user_id'] == $user_id) {
                    $root['is_live_pay'] = 0;
                }

                $root['has_video_control'] = 1;//点播时，视频控制操作
                $root['has_lianmai'] = 0;//1:显示连麦按钮;0:不显示连麦按钮
            } else {
                if (($root['video_type'] == 1 && $m_config['qcloud_security_key'] == '') || $root['video_type'] == 2 || $root['video_type'] == 5) {
                    //非直播码方式，不让连麦
                    $root['has_lianmai'] = 0;//1:显示连麦按钮;0:不显示连麦按钮
                } else {
                    //会员允许等级
                    if ($m_config['has_lianmai_lv'] <= $user_level) {

                        $root['has_lianmai'] = 1;//1:显示连麦按钮;0:不显示连麦按钮
                    } else {
                        $root['has_lianmai'] = 0;//1:显示连麦按钮;0:不显示连麦按钮
                    }

                }
            }

            if ($user_id != $root['user_id']) {
                //非主播，不返回：推流地址
                $root['push_url'] = '';//video_type=1;1:腾讯云直播推流地址
            }

            $share = array();
            $share['share_title'] = strim($m_config['share_title']);//'你丑你先睡,我美我直播!';
            $share['share_imageUrl'] = $root['podcast']['user']['head_image'];
            $share['share_key'] = $root['room_id'];

            $API_LANG = $_REQUEST['language'] ? $_REQUEST['language'] : API_LANG;
            $http = strim($m_config['share_address']) ? strim($m_config['share_address']) : SITE_DOMAIN . APP_ROOT;
            $share['share_url'] = $http . "/wap/index.php?ctl=invite_rewards&act=download&invite_code=" . $user_id . "&language=" . $API_LANG;

            //  $share['share_url'] = SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=share&act=live&user_id=' . $root['user_id'] . '&video_id=' . $root['room_id'] . '&share_id=' . $user_id;


            //TODO 分享短连接域名 是否使用t.cn短域名 source正式环境需要自行申请

            $share['share_content'] = $share['share_title'] . $root['podcast']['user']['nick_name'] . api_lang('Come_watch_live_broadcast');

            $root['share'] = $share;
            $root['status'] = 1;


            //$sql = "select count(*) from ".DB_PREFIX."video_viewer where group_id = '".$root['group_id']."'";
            //$sql = "select count(*) from ".DB_PREFIX."user";
            //当前房间人数 = 当前实时观看人数（实际,不含虚拟人数,不包含机器人) + 当前虚拟观看人数 + 机器人
            //$root['viewer_num'] = $root['watch_number'] + $root['virtual_watch_number'] + $root['robot_num'];


            //观众列表
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
            $video_viewer_redis = new VideoViewerRedisService();
            $viewer = $video_viewer_redis->get_viewer_list2($room_id);
            $lists = $viewer['list'];


            if (count($lists) > 0) {
                $table = createPropTable();
                foreach ($lists as &$v) {
                    // 获取用户缓存中的信息
                    $noble = $user_redis->getRow_db($v['user_id'], ['nobleid', 'noble_time', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'avatar_frame_id']);
                    if ($noble['noble_time'] > NOW_TIME) {
                        $v['nobleid'] = $noble['nobleid'];
                        $v['is_noble_ranking_stealth'] = $noble['is_noble_ranking_stealth'];
                        $v['is_noble_mysterious'] = $noble['is_noble_mysterious'];
                    } else {
                        $v['nobleid'] = '';
                        $v['is_noble_ranking_stealth'] = 0;
                        $v['is_noble_mysterious'] = 0;
                    }
                    // 头像框
                    $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $noble['avatar_frame_id']);

                    //查询今日给此主播的贡献值
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoGiftRedisService.php');
                    $video_gift_redis = new VideoGiftRedisService();
                    $day = to_date(NOW_TIME, 'Y-m-d');
                    $total_num = $video_gift_redis->getOne_gift_db($table . "_" . $day . "_" . $root['room_id'] . "_" . $root['user_id'], $v['user_id']);

                    $v['total_num'] = $total_num > 0 ? format_for_ten_thousand($total_num) : 0;

                }
                //二维数组排序
                foreach ($lists as $key => $row) {
                    $volume[$key] = $row['total_num']; //要排序的字段
                    $edition[$key] = $row['nobleid']; //要排序的字段
                }

                array_multisort($volume, SORT_DESC, $edition, SORT_DESC, $lists);

            }

            $new_viewer = [
                'page'         => $viewer['page'],
                'list'         => $lists,
                'has_next'     => $viewer['has_next'],
                "status"       => $viewer['status'],
                "watch_number" => $viewer['watch_number']
            ];
            $root['viewer'] = $new_viewer;
            $root['viewer_num'] = $viewer['watch_number'];


            //添加观看人数
            $GLOBALS['db']->query("update " . DB_PREFIX . "video set virtual_watch_number = " . $viewer['watch_number'] . " , max_watch_number =  " . $viewer['watch_number'] . " where id = " . $room_id);
            //直播间贵族列表
            $root['noble_sum'] = $video_viewer_redis->get_noble_list_sum($room_id);

            if ($root['room_type'] == 1) {
                $root['is_private'] = 1;
                if ($root['is_bm'] == 1) {
                    $root['is_private'] = 0;
                }

                $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = " . $root['user_id'] . " and user_id=" . $user_id;
                $user_admin_id = intval($GLOBALS['db']->getOne($sql, true, true));
                //主播自己或管理员  // || $root['podcast']['show_admin'] == 2
                if ($user_admin_id > 0 || ($user_id == $root['user_id'])) {
                    $private_share = "复制整段信息，打开［" . strim($m_config['app_name']) . "］可直接看直播," . $root['podcast']['user']['nick_name'] . api_lang("In_progress") . $root['city'] . api_lang("live_broadcast");
                    $private_share = $private_share . base64_decode("8J+UkQ==") . $root['private_key'] . base64_decode("8J+UkQ==") . "还没安装" . strim($m_config['app_name']) . "？点此安装，" . SITE_DOMAIN_DOWNLOAD . "/appdown.php";

                    $root['private_share'] = $private_share;//print_r($root['podcast'],1);
                }

                $root['private_key'] = '';
            } else {
                $root['is_private'] = 0;
            }
            //进入房间提示 1、提示进入房间  0、 不提示
            $join_room_remind_limit = intval($m_config['join_room_remind_limit']);
            $root['join_room_prompt'] = 1;
            if ($join_room_remind_limit > 0 && $root['viewer_num'] > $join_room_remind_limit) {
                $root['join_room_prompt'] = 0;
            }

            $root['is_live_pay'] = $is_live_pay;
            $root['live_pay_type'] = $live_pay_type;
            $root['live_fee'] = $live_fee;
            $root['is_pay_over'] = $is_pay_over;

            $root['is_vip'] = $is_vip;//是否VIP会员


            //进入房间人数上限  join_room_limit
            $join_room_limit = intval($m_config['join_room_limit']);
            if ($join_room_limit > 0 && $root['viewer_num'] >= $join_room_limit && $root['user_id'] != $user_id) {
                $root = array();
                $root['error'] = api_lang("live_reach_upper_limit");
                $root['status'] = 0;
            }
            $root['video_title'] = api_lang("live_broadcast");

            if ($root['live_in'] == 3 && intval($root['is_gather']) != 1) {
                $root['video_title'] = api_lang("back");
            } else if ($root['live_in'] == 3 && intval($root['is_gather']) == 1) {
                $root['video_title'] = api_lang("live_broadcast");
            }

            //获取是否是守护者
//            $sql = "select v.id from " . DB_PREFIX . "guardian_user v  where v.host_id=" . $root['user_id'] . " and v.uid=" . $user_id . " and v.endtime >= " . NOW_TIME . " and status=1";
//            $guardian = $GLOBALS['db']->getOne($sql);
            $guardian = redis_get("guardian_host_" . $root['user_id'] . "_user_" . $user_id);

            $root['is_guardian'] = $guardian ? 1 : 0;

            //获取房间守护人数
            $sql = "select count(*) from " . DB_PREFIX . "guardian_user where host_id=" . $root['user_id'] . " and endtime >= " . NOW_TIME . " and status=1";
            $root['guardian_num'] = intval($GLOBALS['db']->getOne($sql, true, true));

        } else {
            if ($is_vod == 0) {
                $show_num = $root['max_watch_number'];//观看人数
                $podcast_id = $root['user_id'];
                $live_in = $root['live_in'];
                $root = array();

                //关注
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
                $userfollw_redis = new UserFollwRedisService($user_id);

                if ($userfollw_redis->is_following($podcast_id)) {
                    $root['has_focus'] = 1;//0:未关注;1:已关注
                } else {
                    $root['has_focus'] = 0;
                }

                $root['live_in'] = $live_in;
                $root['show_num'] = $show_num;
                $root['status'] = 2;//提示直播结束;

                //=========================================================
                //广播：直播结束
                //发送广播：直播结束
                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();

                $ext = array();
                $ext['type'] = 18; //18：直播结束（全体推送的，用于更新用户列表状态）
                $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应

                //18：直播结束（全体推送的，用于更新用户列表状态）
                $api->group_send_group_system_notification($m_config['on_line_group_id'], json_encode($ext), null);
                //=========================================================

                //$video_redis->update_db($room_id,array('live_in'=>1));
                //较验数据
                crontab_do_end_video();
                crontab_do_end_video_2();
                //
            } else {
                $root = array();
                $root['error'] = api_lang("live_broadcast_is_over") . $room_id;
                $root['status'] = 0;
            }
        }

        //我的座驾
        $root['noble_car_url'] = '';
        $root['noble_car_name'] = '';         //座驾名称
        if ($user_info['noble_car_id'] > 0) {
            $car = redis_get("noble_car_" . $user_info['noble_car_id'] . "_" . $user_id);
            if ($car) {
                $car = json_decode($car, true);
            }
            if ($car) {
                $car_noble = get_noble_one($car['carid']);
                if ($car_noble) {
                    //$root['noble_car_url']="http://".$_SERVER['SERVER_NAME'].strstr($car_noble['img'], '/public/attachment');
                    $root['noble_car_url'] = $car_noble['img'];
                    $root['noble_car_name'] = $car_noble['name'];
                }
            } else {
                $sql = "update " . DB_PREFIX . "user set noble_car_id = 0 where id = " . $user_id;
                $GLOBALS['db']->query($sql);
            }
        }
        $host_id = $root['user_id'];

        $guardian = redis_get("guardian_host_" . $host_id . "_user_" . $user_id);
        if ($guardian) {
            $guardian = json_decode($guardian, true);
        }

        $binding = $guardian ? explode(',', $guardian['privilege']) : [];
        $guardian_type = load_auto_cache("guardian_type");

        $guardian_val['guardian_img'] = $guardian ? $guardian['img'] : '';
        $guardian_val['guardian_remind'] = '0';
        $guardian_val['guardian_icon'] = '0';
        $guardian_val['guardian_gift'] = '0';
        $guardian_val['guardian_skin'] = '0';
        $guardian_val['guardian_broadcast'] = '0';
        $guardian_val['guardian_kick'] = '0';
        foreach ($guardian_type as $vs) {
            if (in_array($vs['id'], $binding)) {
                //1开通提醒，2身份标识，3专属礼物，4专属弹幕皮肤，5全站广播，6防踢防禁言
                switch ($vs['type']) {
                    case 1:
                        $guardian_val['guardian_remind'] = '1';
                        break;
                    case 2:
                        $guardian_val['guardian_icon'] = '1';
                        break;
                    case 3:
                        $guardian_val['guardian_gift'] = '1';
                        break;
                    case 4:
                        $guardian_val['guardian_skin'] = '1';
                        break;
                    case 5:
                        $guardian_val['guardian_broadcast'] = '1';
                        break;
                    case 6:
                        $guardian_val['guardian_kick'] = '1';
                        break;
                    default:
                }
            }
        }
        $root['guardians_privilege'] = $guardian_val;
        $root['len_time'] = $root['begin_time'] ? NOW_TIME - $root['begin_time'] : 0; // 主播直播时长(秒)
        $root['pk_id'] = 0;
        //房间是否在PK
        if ($group_id) {
            $video_pk = redis_get("pk_list_" . $host_id);
            if ($video_pk) {
                $video_pk = json_decode($video_pk, true);
                $root['pk_id'] = $video_pk['id'];
            }
        }
    } else {
        $root = array();
        $root['error'] = api_lang("no_live_room_found") . $room_id;
        $root['status'] = 0;
    }
    return $root;
}


//检查主播是否直播中
function is_live($data, $live_list)
{
    foreach ($data as $k => $v) {
        foreach ($live_list as $kk => $vv) {
            if ($vv['user_id'] == $v['user_id']) {
                $data[$k]['live_in'] = $vv['live_in'];
                $data[$k]['video_url'] = get_video_url($vv['room_id'], $vv['live_in']);
                break;
            }
        }
        if (empty($data[$k]['video_url'])) {
            $data[$k]['video_url'] = url('live#show', array('podcast_id' => $v['user_id']));
        }
        $data[$k]['user_level_ico'] = get_spec_image("./public/images/rank/rank_" . $v['user_level'] . ".png");
    }
    return $data;
}

//获取直播列表
function get_live()
{
    $sql = "SELECT v.id AS room_id, v.sort_num, v.group_id, v.user_id, v.city, v.title, v.cate_id, v.live_in, v.video_type, v.room_type,
                        (v.robot_num + v.virtual_watch_number + v.watch_number) as watch_number, v.head_image,v.thumb_head_image, v.xpoint,v.ypoint,v.live_image,
                        u.v_type, u.v_icon, u.nick_name,u.user_level FROM " . DB_PREFIX . "video v
                    LEFT JOIN " . DB_PREFIX . "user u ON u.id = v.user_id where v.live_in in (1,3) order by v.live_in, v.sort_num desc,v.sort desc";
    $live_list = $GLOBALS['db']->getAll($sql, true, true);

    return $live_list;
}

/**
 * //随机从type类型的直播列表中，取$num个直播ID; type: 0:热门;1:最新;2:关注
 * 不会列出私聊房间
 * @param int    $type
 * @param int    $num
 * @param string $user_id 当$type=2时生效;
 */
function get_rand_video($room_id, $user_id, $type, $param, $num = 2)
{

    $ret_list = array();

    $is_vod = intval($param['is_vod']);

    if ($is_vod == 0) {
        if ($type == 2) {
            //关注
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $userfollw_redis = new UserFollwRedisService($user_id);
            $user_list = $userfollw_redis->following();

            //私密直播  video_private,私密直播结束后， 本表会清空
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
            $video_private_redis = new VideoPrivateRedisService();
            $private_list = $video_private_redis->get_video_list($user_id);

            if (sizeof($private_list) || sizeof($user_list)) {
                $list_all = load_auto_cache("select_video", array('has_private' => 1));

                foreach ($list_all as $k => $v) {
                    if (($v['live_in'] == 1) && ($v['room_id'] != $room_id) && (($v['room_type'] == 1 && in_array($v['room_id'], $private_list)) || ($v['room_type'] == 3 && in_array($v['user_id'], $user_list)))) {
                        $list[] = $v;
                    }
                }
            }
        } else {
            $list_all = load_auto_cache("select_video", array('sex_type' => intval($param['sex']), 'area_type' => $param['city'], 'cate_id' => intval($param['cate_id']), 'has_private' => 0));

            foreach ($list_all as $k => $v) {
                if (($v['live_in'] == 1) && ($v['room_id'] != $room_id) && $v['user_id'] != $user_id) {
                    $list[] = $v;
                }
            }
        }

        if (count($list) <= $num) {
            $ret_list = $list;
        } else {
            foreach (array_rand($list, $num) as $key) {
                $ret_list[] = $list[$key];
            }
        }

    }

    return $ret_list;
}

//格式化时间单位（多少时间前）
function format_show_date($time)
{
    $t = NOW_TIME - $time;
    $f = array(
        '31536000' => '年',
        '2592000'  => '个月',
        '604800'   => '星期',
        '86400'    => api_lang("day"),
        '3600'     => '小时',
        '60'       => api_lang("minute"),
        '1'        => '秒'
    );

    foreach ($f as $k => $v) {
        if (0 != $c = floor($t / (int)$k)) {
            return $c . $v . '前';
        }
    }
}

//格式化时间单位（多少时间前）
function dynamic_format_show_date($time)
{
    $t = NOW_TIME - $time;
    $f = array(
        '86400' => api_lang("day"),
        '3600'  => '小时',
        '60'    => api_lang("minute"),
        '1'     => '秒'
    );
    if ($t < 86400 * 30) {
        foreach ($f as $k => $v) {
            if (0 != $c = floor($t / (int)$k)) {
                return $c . $v . '前';
            }
        }
    } else {
        return date('m月d日', $time);
    }
}

//获得回放视频的时长（多少小时/多少分钟）
function get_time_len($begin_time, $end_time)
{
    $time = $end_time - $begin_time;
    $palyback = '';
    if ($time / 3600 > 1) {
        $palyback .= intval($time / 3600) . '小时';
        $time = $time % 3600;
    }
    if ($time / 60 > 1) {
        $palyback .= intval($time / 60) . api_lang("minute");
    }
    return $palyback;
}

// 主播播的时长
function get_live_time_lenght($time)
{
    $palyback = '';
    if ($time / 3600 > 1) {
        $palyback .= intval($time / 3600);
        $time = $time % 3600;
    } else {
        $palyback .= '00';
    }
    if ($time / 60 > 1) {
        $palyback .= intval($time / 60) > 9 ? ':' . intval($time / 60) : ':0' . intval($time / 60);
        $time = $time % 60;
    } else {
        $palyback .= ':00';
    }
    if ($time) {
        $palyback .= $time > 9 ? ':' . $time : ':0' . $time;
    } else {
        $palyback .= ':00';
    }
    return $palyback;
}

//格式化时间长度单位 （小时/分钟）
function get_live_time_len($time)
{
    $total_time_format = '';
    if ($time / 3600 >= 1) {
        $total_time_format .= intval($time / 3600) . '小时';
        $time = $time % 3600;
    }
    if ($time / 60 >= 1) {
        $total_time_format .= intval($time / 60) . api_lang("minute");
    }
    return $total_time_format;
}

//格式化时间长度单位（天/小时/分钟）2017-8-9 10:40:18新增
function get_live_time_len2($time)
{
    $total_time_format = '';
    if ($time / 86400 >= 1) {
        $total_time_format .= intval($time / 86400) . 'd ';
        $time = $time % 86400;
    }
    if ($time / 3600 >= 1) {
        $total_time_format .= intval($time / 3600) . 'h ';
        $time = $time % 3600;
    }
    if ($time / 60 >= 1) {
        $total_time_format .= intval($time / 60) . 'm';
    }
    return $total_time_format;
}

//如果数据大于10000，则保留两位小数并以万为单位【四舍五入】，否则数据不变;并将结果转字符串格式
function format_for_ten_thousand($number, $precision = 1, $type = 1)
{
    if ($number < 1000) {
        return $number; // 小于 1000 直接返回
    }
    $units = [
        12 => 'T', // 万亿
        9  => 'B',  // 十亿
        6  => 'M',  // 百万
        4  => 'w',  // 万
        3  => 'k',  // 千
    ];
    foreach ($units as $exp => $unit) {
        if ($number >= pow(10, $exp)) {
            if ($type == 1) {
                return round($number / pow(10, $exp), $precision) . $unit;
            } else {
                $sum = floor($number / pow(10, $exp) * pow(10, $precision));
                return $sum / pow(10, $precision) . $unit;
            }
        }
    }
    return $number; // 如果未匹配到单位，直接返回
}

//如果数据大于10000，则保留两位小数并以万为单位【四舍五入】，否则数据不变;并将结果转字符串格式
function format_for_ten_thousand_k($number, $precision = 1, $type = 1)
{
    if ($number < 1000) {
        return $number; // 小于 1000 直接返回
    }
    $units = [
        3 => 'k',  // 千
    ];
    foreach ($units as $exp => $unit) {
        if ($number >= pow(10, $exp)) {
            if ($type == 1) {
                return round($number / pow(10, $exp), $precision) . $unit;
            } else {
                $sum = floor($number / pow(10, $exp) * pow(10, $precision));
                return $sum / pow(10, $precision) . $unit;
            }
        }
    }
    return $number; // 如果未匹配到单位，直接返回
}

//如果数据大于10000，则保留两位小数并以万为单位 【不四舍五入】，否则数据不变;并将结果转字符串格式
function format_for_ten_thousand_new($num)
{
    $API_LANG = $_REQUEST['language'] ? $_REQUEST['language'] : API_LANG;
    if ($API_LANG == 'zh-en') {
        // 英文的处理到千
        if (!isset($num)) {
            $num = '0';
        } else if ($num >= 1000) {
            $num = floatval($num) / 1000;
            $num = number_format($num, 2, '.', '');
            $num .= 'k';
        }
    } else {
        // 其他处理到万
        if (!isset($num)) {
            $num = '0';
        } else if ($num >= 10000) {
            $num = floatval($num) / 10000;
            $num = number_format($num, 2, '.', '');
            $num .= api_lang("ten_thousand");
        }
    }
    $num = strval($num);
    return $num;
}

function crontab_do_check_pc_video()
{
    $ret_array = array();
    $m_config = load_auto_cache("m_config");
    $monitor_overtime = $m_config['monitor_overtime'];
    if ($monitor_overtime <= 0) $monitor_overtime = 40;

    $ret_array = array();
    //监听主播掉线（30秒一次监听，如果超过180秒未收到心跳消息，则说明：主播掉线 了
    $t = to_date(NOW_TIME - $monitor_overtime, 'Y-m-d H:i:s');

    $sql = "select id,user_id,watch_number,vote_number,group_id,room_type,video_type,begin_time,end_time,channelid,video_vid,live_in,cate_id,pai_id  from " . DB_PREFIX . "video where live_in = 2 and is_voice=0 and create_type = 1 and monitor_time > '" . $t . "'";
    $list = $GLOBALS['db']->getAll($sql, true, true);
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    foreach ($list as $v) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
        $video_factory = new VideoFactory();
        if ($v['channelid']) {
            $channel_info = $video_factory->Query($v['channelid']);
            $ret_array[] = $channel_info;
            // 正在直播，继续监听
            if ($channel_info['status'] == 1) {
                $data = array('live_in' => 1, 'begin_time' => NOW_TIME);
                $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $data, 'UPDATE', " id=" . $v['id']);

                if ($GLOBALS['db']->affected_rows()) {
                    $room_id = $v['id'];
                    $sql = "select user_id,room_type,title,city,cate_id from " . DB_PREFIX . "video where id = " . $room_id;
                    $video = $GLOBALS['db']->getRow($sql);

                    $video_redis->video_online($room_id, $v['group_id']);
                    //将mysql数据,同步一份到redis中
                    sync_video_to_redis($room_id, '*', false);

                    if ($video['cate_id'] > 0) {
                        $sql = "update " . DB_PREFIX . "video_cate a set a.num = (select count(*) from " . DB_PREFIX . "video b where b.cate_id = a.id and b.live_in in (1,3)) where a.id = " . $video['cate_id'];
                        $GLOBALS['db']->query($sql);
                    }

                    if ($video['room_type'] == 3) {
                        crontab_robot($room_id);
                    }

                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    $user_data = $user_redis->getRow_db($v['user_id'], array('id', 'nick_name', 'head_image'));

                    $pushdata = array(
                        'user_id'     => $v['user_id'], //'主播ID',
                        'nick_name'   => $user_data['nick_name'],//'主播昵称',
                        'create_time' => NOW_TIME, //'创建时间',
                        'cate_title'  => $video['title'],// '直播主题',
                        'room_id'     => $room_id,// '房间ID',
                        'city'        => $video['city'],// '直播城市地址',
                        'head_image'  => get_spec_image($user_data['head_image']),
                        'status'      => 0,//'推送状态(0:未推送，1：推送中；2：已推送）'
                    );
                    $m_config = load_auto_cache("m_config");
                    if (intval($m_config['service_push'])) {
                        $pushdata['pust_type'] = 1; //'推送状态(0:粉丝推送，1：全服推送）';
                    } else {
                        $pushdata['pust_type'] = 0; //'推送状态(0:粉丝推送，1：全服推送）';
                    }

                    $GLOBALS['db']->autoExecute(DB_PREFIX . "push_anchor", $pushdata, 'INSERT');
                }
            }
        }
    }
    return $ret_array;
}

function crontab_do_check_upload_video($create_type = 1)
{
    $create_type = intval($create_type) ? intval($create_type) : 0;

    $ret_array = array();

    $sql = "select id,video_vid,live_in,group_id from " . DB_PREFIX . "video_history where live_in = 2 and create_type = " . $create_type;
    $list = $GLOBALS['db']->getAll($sql, true, true);

    if ($list) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
        $video_redis = new VideoRedisService();
        $video_factory = new VideoFactory();
        foreach ($list as $v) {
            // 用户上传的视频轮询取得播放地址
            $ret = $video_factory->DescribeVodPlayUrls($v['video_vid']);
            if (empty($ret['urls'])) {
                continue;
            }

            $play_url = array_shift($ret['urls']);
            $data = array('live_in' => 0, 'is_del_vod' => 0, 'play_url' => $play_url, 'end_time' => NOW_TIME);
            $GLOBALS['db']->autoExecute(DB_PREFIX . "video_history", $data, 'UPDATE', " id=" . $v['id']);

            $video_redis->update_db($v['id'], $data);
            $video_redis->video_online($v['id'], $v['group_id']);

            $ret_array[] = $data;
        }
    }

    return $ret_array;
}

function crontab_do_end_voice()
{
    $redis_key = "member_exit_list";
    $member_exit_list = redis_zRevRange($redis_key, 0, -1, true);
    $ret_array = [];
    if ($member_exit_list) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        $video_viewer_redis = new VideoViewerRedisService();

        foreach ($member_exit_list as $k => $v) {
            $video_id = $k;
            if ($v + 60 * 5 <= NOW_TIME) {
                $watch_number = $video_viewer_redis->get_voice_count($video_id);
                if ($watch_number <= 0) {
                    // 关闭房间
                    $sql = "select * from " . DB_PREFIX . "video where id = " . $video_id . " and is_voice=1 and live_in=1";
                    $video = $GLOBALS['db']->getRow($sql);
                    if ($video) {
                        $ret['status'] = do_close_voice($video);
                        $ret['func'] = 'do_end_video';
                        $ret_array[] = $ret;
                    }
                }
                rm_auto_cache("select_video");
                redis_zrem($redis_key, $video_id);
            }
        }
    }
    return array(
        'member_exit_list' => $member_exit_list,
        'ret_array'        => $ret_array
    );
}

function crontab_do_end_video()
{
    try {

        $m_config = load_auto_cache("m_config");
        $monitor_overtime = $m_config['monitor_overtime'];
        if ($monitor_overtime <= 0) $monitor_overtime = 40;

        $ret_array = array();
        //监听主播掉线（30秒一次监听，如果超过180秒未收到心跳消息，则说明：主播掉线 了
        $t = to_date(NOW_TIME - $monitor_overtime, 'Y-m-d H:i:s');
        //    $sql = "select id,user_id,watch_number,vote_number,group_id,room_type,video_type,begin_time,end_time,channelid,video_vid,live_in,cate_id,pai_id,is_voice from " . DB_PREFIX . "video where (live_in = 1 or live_in = 2) and (monitor_time < '" . $t . "' or monitor_time is null)"; //  and is_voice=0
        $sql = "select id,user_id,watch_number,vote_number,group_id,room_type,video_type,begin_time,end_time,channelid,video_vid,live_in,cate_id,pai_id,is_voice from " . DB_PREFIX . "video where (live_in = 1 or live_in = 2) and is_voice=0 and (monitor_time < '" . $t . "' or monitor_time is null)"; //

        $list = $GLOBALS['db']->getAll($sql, true, true);
        foreach ($list as $k => $v) {

//            if ($v['video_type'] > 0) {
//                //0:腾讯云互动直播;1:腾讯云直播;2:  云直播
//                bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
//                $video_factory = new VideoFactory();
//                $channel_info = $video_factory->Query($v['channelid']);
//                // 正在直播，继续监听
//                if ($channel_info['status'] == 1) {
//                    continue;
//                }
//            }

            //结束直播
            if ($v['live_in'] == 1) {
                $cate_id = $v['cate_id'];
            } else {
                $cate_id = 0;
            }

            $system_user_id = $m_config['tim_identifier'];//系统消息
            $ext = array();
            $ext['type'] = 17;
            $ext['desc'] = '网络不佳，已结束直播';
            $ext['room_id'] = $v['id'];
            #构造高级接口所需参数
            $msg_content = array();
            //创建array 所需元素
            $msg_content_elem = array(
                'MsgType'    => 'TIMCustomElem',       //自定义类型
                'MsgContent' => array(
                    'Data' => json_encode($ext),
                    'Desc' => '',
                    //  'Ext' => $ext,
                    //  'Sound' => '',
                )
            );
            //将创建的元素$msg_content_elem, 加入array $msg_content
            array_push($msg_content, $msg_content_elem);
            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();
            $group_info = $api->group_get_group_member_info($v['group_id'], 0, 0);
            if ($group_info['MemberList']) {
                $to = array_column($group_info['MemberList'], "Member_Account");
            }
            $exceed = 500; //一次最多发送500条
            if (sizeof($to) > $exceed) {
                $num = ceil(sizeof($to) / $exceed);
                for ($i = 0; $i < $num; $i++) {
                    $to_account = array_slice($to, $i * $exceed, $exceed);
                    $api->openim_batchsendmsg($system_user_id, $msg_content, $to_account);
                }
            } else {
                $api->openim_batchsendmsg($system_user_id, $msg_content, $to);
            }

            $ret = do_end_video($v, $v['video_vid'], 1, $cate_id);
            $ret['func'] = 'do_end_video';

            $ret_array[] = $ret;
        }

        return $ret_array;
    } catch (Exception $e) {

        return $e->getMessage();
    }


}

function crontab_do_end_video_2()
{

    try {
        $ret_array = array();

        // 结束直播5分钟后，
        $sql = "select id,is_del_vod,video_type,channelid,begin_time,create_time,end_time,user_id,vote_number,destroy_group_status,group_id from " . DB_PREFIX . "video where end_time < " . (NOW_TIME - 300) . " and live_in = 0 limit 10";
        $list = $GLOBALS['db']->getAll($sql);

        if ($list) {

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();

            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();


            foreach ($list as $k => $v) {
                //1:表示已经清空了,录制视频;0:未做清空操作
                if ($v['is_del_vod'] == 1) {
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
                    $video_factory = new VideoFactory();
                    /*if($v['video_type'] > 0 && $v['channelid']&& strpos($v['channelid'],'_')){
                        $ret = $video_factory->GetVodRecordFiles($v['channelid'], $v['create_time']);
                    } else {
                        $fileName = $v['id'];
                        if($v['video_type'] == 1){
                            $fileName = 'live'.$v['id'] ;
                        }
                        $ret = $video_factory->DescribeVodPlayInfo($fileName);
                    }*/
                    $ret = get_vodset_by_video_id($v['id']);
                    /*if ($ret['totalCount'] > 0){*/
                    if ($ret['total_count'] > 0) {
                        //视频存在
                        $sql = "update " . DB_PREFIX . "video set is_del_vod = 0 where id = " . $v['id'];
                        $GLOBALS['db']->query($sql);

                        $v['is_del_vod'] = 0;
                        $data = array();
                        $data['is_del_vod'] = 0;
                        $video_redis->update_db($v['id'], $data);
                    }
                }

                //直播结束 后相关数据处理（在后台定时执行）

                //1、解散群组
                if ($v['destroy_group_status'] == 1 && $v['is_del_vod'] == 1) {
                    if ($v['group_id'] != '') {
                        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                        $api = createTimAPI();
                        $ret = $api->group_destroy_group($v['group_id']);

                        //删除：观众列表
                        $video_redis->del_viewer($v['id']);

                        $sql = "update " . DB_PREFIX . "video set destroy_group_status = '" . $ret['ErrorCode'] . "' where id = " . $v['id'];
                        $GLOBALS['db']->query($sql);

                    } else {
                        $sql = "update " . DB_PREFIX . "video set destroy_group_status = 0 where id = " . $v['id'];
                        $GLOBALS['db']->query($sql);
                    }
                }

                $ret['status'] = do_end_video_2($video_redis, $api, $v['id']);

                $ret['func'] = 'do_end_video_2';

                $ret_array[] = $ret;
            }
        }
        return $ret_array;
    } catch (Exception $e) {
        return $e->getMessage();
    }

}

/**
 * pk时 定时推送送礼物最高的3个用户
 * */
function pk_user_gift()
{
    // 获取所有的正在pk的房间

    $sql = 'select k.emcee_user_id1,k.emcee_user_id2,k.group_id1,k.group_id2,k.create_time,v.prop_table as vprop_table,i.prop_table as iprop_table,k.time from ' . DB_PREFIX . 'video_pk k inner join ' . DB_PREFIX . 'video v on v.user_id=k.emcee_user_id1 inner join ' . DB_PREFIX . 'video i on i.user_id=k.emcee_user_id2 where k.status !=0';
    $list = $GLOBALS['db']->getAll($sql);


    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');

    $video_redis = new VideoViewerRedisService();
    $pk_user_gift = $video_redis->get_redis_one('pk_user_gift');

    if ($pk_user_gift && NOW_TIME - $pk_user_gift < 3) {
        return false;
        exit;

    }

    $video_redis->set_redis_one('pk_user_gift', NOW_TIME);
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    foreach ($list as &$v) {

        //获取pk用户消费前3名

        //pk开始时间
        $video_pk_startime = $v['create_time'];
        //PK的结束时间
        $video_pk_endtime = $v['create_time'] + $v['time'] * 60;
        // pk1
//        $sql = "select sum(t.total_diamonds) as total_diamonds_sum,u.nick_name,u.id as user_id,u.head_image from " . $v['vprop_table'] . " t left join " . DB_PREFIX . "user u on u.id=t.from_user_id  where t.to_user_id=" . $v['emcee_user_id1'] . " and t.create_time >=$video_pk_startime and t.create_time  <= $video_pk_endtime  group by t.from_user_id order by total_diamonds_sum desc limit 0,3";
//        $pk_user = $GLOBALS['db']->getAll($sql);
//
//        foreach ($pk_user as &$vs) {
//            $vs['head_image'] = get_spec_image($vs['head_image']);//发送人头像
//        }
        $pk_user_list = redis_zRevRange("video_pk_consumption_" . $v['emcee_user_id1'], 0, 3, true);
        $pk_user = [];
        foreach ($pk_user_list as &$v1) {
            $user_info = $user_redis->getRow_db($v1, array('id', 'nick_name', 'head_image'));
            $user_info['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
            $pk_user[] = $user_info;
        }


        // pk2
//        $sql = "select sum(t.total_diamonds) as total_diamonds_sum,u.nick_name,u.id as user_id,u.head_image from " . $v['iprop_table'] . " t left join " . DB_PREFIX . "user u on u.id=t.from_user_id  where t.to_user_id=" . $v['emcee_user_id2'] . " and t.create_time >=$video_pk_startime and t.create_time  <= $video_pk_endtime  group by t.from_user_id order by total_diamonds_sum desc limit 0,3";
//        $pk_user2 = $GLOBALS['db']->getAll($sql);
//
//        foreach ($pk_user2 as &$vs) {
//            $vs['head_image'] = get_spec_image($vs['head_image']);//发送人头像
//        }

        $pk_user_list2 = redis_zRevRange("video_pk_consumption_" . $v['emcee_user_id2'], 0, 3, true);
        $pk_user2 = [];
        foreach ($pk_user_list2 as &$v2) {
            $user_info = $user_redis->getRow_db($v2, array('id', 'nick_name', 'head_image'));
            $user_info['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
            $pk_user2[] = $user_info;
        }


        $user_null = array(
            'total_diamonds_sum' => 0,
            'nick_name'          => '',
            'user_id'            => 0,
            'head_image'         => '',
        );
        if (count($pk_user) <= 0) {
            $pk_user[0] = $user_null;
            $pk_user[1] = $user_null;
            $pk_user[2] = $user_null;
        } elseif (count($pk_user) == 1) {
            $pk_user[1] = $user_null;
            $pk_user[2] = $user_null;
        } elseif (count($pk_user) == 2) {
            $pk_user[2] = $user_null;
        }
        if (count($pk_user2) <= 0) {
            $pk_user2[0] = $user_null;
            $pk_user2[1] = $user_null;
            $pk_user2[2] = $user_null;
        } elseif (count($pk_user2) == 1) {
            $pk_user2[1] = $user_null;
            $pk_user2[2] = $user_null;
        } elseif (count($pk_user2) == 2) {
            $pk_user2[2] = $user_null;
        }

        //发送pk用户消费前3名信息
        $ext['pk_user1'] = $pk_user;
        //发送pk用户消费前3名信息
        $ext['pk_user2'] = $pk_user2;

        $ext['pk_host1'] = $v['emcee_user_id1'];
        $ext['pk_host2'] = $v['emcee_user_id2'];

        $ext['type'] = 77;   //pk主播用户前三名

        #构造高级接口所需参数
        $msg_content = array();
        //创建array 所需元素
        $msg_content_elem = array(
            'MsgType'    => 'TIMCustomElem',       //自定义类型
            'MsgContent' => array(
                'Data' => json_encode($ext),
                'Desc' => '',
                //  'Ext' => $ext,
                //  'Sound' => '',
            )
        );

        //将创建的元素$msg_content_elem, 加入array $msg_content
        array_push($msg_content, $msg_content_elem);

        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();

        //发送消息到正在PK的两个群组
        $ret = $api->group_send_group_msg2($v['emcee_user_id1'], $v['group_id1'], $msg_content);
        $api->group_send_group_msg2($v['emcee_user_id2'], $v['group_id2'], $msg_content);
    }
}

/**
 * 添加机器人,每隔几秒随机添加几个人
 */
function crontab_robot($video_id = 0)
{

    if ($video_id == 0) {
        $sql = "SELECT id,group_id,robot_num,max_robot_num FROM " . DB_PREFIX . "video where robot_num < max_robot_num and live_in in (1,3) and room_type = 3 and robot_time < " . (NOW_TIME - rand(20, 30));
    } else {
        $sql = "SELECT id,group_id,robot_num,max_robot_num FROM " . DB_PREFIX . "video where robot_num < max_robot_num and live_in in (1,3) and room_type = 3 and id = " . $video_id;
    }
    $list = $GLOBALS['db']->getAll($sql, true, true);

    if (count($list) > 0) {
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $max_num = $m_config['robot_num'];

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');

        $video_redis = new VideoRedisService();
        $video_viewer = new VideoViewerRedisService();
    }

    foreach ($list as $k => $v) {
        //添加机器人
        $robot_num = $v['robot_num'];
        $max_robot_num = $v['max_robot_num'] ? $v['max_robot_num'] : $max_num;
        $video_id = $v['id'];

        if ($robot_num < $max_robot_num) {
            $rand_num = rand(6, 10);
            $robot_keys = $video_viewer->redis->srandmember($video_viewer->user_robot_db, $rand_num);
            $user_array = array();

            foreach ($robot_keys as $user_id) {
                $user_array[$user_id]['user_level'] = $video_viewer->redis->hGet($video_viewer->user_db . $user_id, 'user_level');
            }

            //新入群成员列表
            foreach ($robot_keys as $k => $user_id) {

                $begin_time = get_gmtime();
                if ($video_viewer->redis->zScore($video_viewer->video_viewer_level_db . $video_id, $user_id) === false) {

                    //实际观众数统计：累计观众列表和; [score 为负数是：机器人; 正数是：真实观众] $user_array[$user_id]['user_level']
                    $video_viewer->redis->zAdd($video_viewer->video_viewer_level_db . $video_id, -1, $user_id);

                    $video_viewer->redis->hIncrBy($video_viewer->video_db . $video_id, 'robot_num', 1);
                    $video_viewer->redis->hIncrBy($video_viewer->video_db . $video_id, 'max_watch_number', 1);

                    //记录直播间的机器人头像 去除：直播间机器人独立列表 score 为负数是：机器人
                    //$video_redis->add_robot($video_id, $user_id);
                }

            }


            $video = $video_redis->getRow_db($video_id, array('robot_num'));
            $robot_num = intval($video['robot_num']);

            if ($robot_num > 0) {
                $sql = "update " . DB_PREFIX . "video set robot_num =  " . $robot_num . ",robot_time=" . NOW_TIME . " where id = " . $video_id;
                $GLOBALS['db']->query($sql);
            }
        }
    }
}


//获取一个新的房间号,同时记录分配给那个系统使用;
function get_max_room_id($sysid = 0)
{
    $sql = "insert into " . DB_PREFIX . "room_id (id,sysid) values(0,$sysid)";
    $GLOBALS['db']->query($sql);
    $room_id = $GLOBALS['db']->insert_id();
    return $room_id;
}

/**
 * IP地址查询接口(API)
 */
function get_ip_info()
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/transport.php');
    $trans = new transport();

    //$url = 'http://int.dpool.sina.com.cn/iplookup/iplookup.php?format=json&ip='.CLIENT_IP;
    $url = 'http://ip.ws.126.net/ipquery?ip=' . CLIENT_IP;
    $req = $trans->request($url, array(), 'GET');
    //$req = json_decode($req['body'],true);
    $req['body'] = mb_convert_encoding($req['body'], 'utf-8', 'gbk');
    $b = substr($req['body'], strpos($req['body'], "{"), strpos($req['body'], "}"));
    $req['city'] = substr($b, strpos($b, "{city:") + 7, strpos($b, "\",") - 7);
    $req['city'] = str_replace("市", "", $req['city']);
    $req['province'] = substr($b, strpos($b, "province:") + 10, -4);
    $req['province'] = str_replace("省", "", $req['province']);


    /*
    {
        ret: 1,
        start: -1,
        end: -1,
        country: "美国",
        province: "加利福尼亚",
        city: "Zenia",
        district: "",
        isp: "",
        type: "",
        desc: ""
    }*/

    $info = array();
    $info['ip'] = CLIENT_IP;
    $info['country'] = '';
    $info['province'] = $req['province'];
    $info['city'] = empty($req['city']) ? $req['province'] : $req['city']; //没有市就写省
    $info['district'] = '';
    return $info;
}

function get_ip_infos()
{

    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/transport.php');

    $trans = new transport();

    $url = "https://dm-81.data.aliyun.com/rest/160601/ip/getIpInfo.json?ip=" . CLIENT_IP;
    $date = array();
    $date['AppKey'] = '23489658';
    $date['AppKeyAppSecret'] = '71d175d90329b580f989268f957f152a';
    $req = $trans->request($url, $date, 'GET');
    return $req;
    /*$req = json_decode($req['body'],true);

    $info = array();
    $info['ip'] = CLIENT_IP;
    $info['country'] = $req['country'];
    $info['province'] = $req['province'];
    $info['city'] = $req['city'];
    $info['district'] = $req['district'];
    return $info;*/
}

/**
 * 距离计算(API)
 */
function get_distance_order($from, $to)
{
    // http://lbs.qq.com/webservice_v1/guide-distance.html

    $m_config = load_auto_cache("m_config");

    //  test
    if (!isset($m_config["qcloud_app_key"])) {
        $m_config["qcloud_app_key"] = "UNDBZ-KYNLX-LDS4K-ZBARP-VT37E-I2FCL";
    }

    $url = 'http://apis.map.qq.com/ws/distance/v1/?' . http_build_query(array(
            "mode"   => "walking",
            "from"   => $from,
            "to"     => implode(';', $to),
            "output" => "json",
            "key"    => $m_config["qcloud_app_key"],
        ));

    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/transport.php');
    $trans = new transport();
    $response = $trans->request($url, array(), 'GET');

    $data = json_decode($response['body'], true);
    if ($data['status'] != 0) {
        return array();
    }

    return $data['result']['elements'];
}


/**
 * 格式化时间
 */
function date_time_format(&$date_time)
{
    $time = strtotime($date_time);
    $ri = date('Y年m月d日 ', $time);
    $zhou = date('N', $time);
    if ($zhou == 1) {
        $zhou = " 周一 ";
    } elseif ($zhou == 2) {
        $zhou = " 周二 ";
    }
    if ($zhou == 3) {
        $zhou = " 周三 ";
    }
    if ($zhou == 4) {
        $zhou = " 周四 ";
    }
    if ($zhou == 5) {
        $zhou = " 周五 ";
    }
    if ($zhou == 6) {
        $zhou = " 周六 ";
    }
    if ($zhou == 7) {
        $zhou = " 周日 ";
    }
    $fen = date(' H时i分', $time);
    $date_time = $ri . $zhou . $fen;
}


/*
 * 在线人数进行整理
 */
function deal_online_cate_num()
{

}

/**
 * 通过  房间号 获取视频播放信息列表；注:在手机端开启录制时,要以房间号作为文件名;
 * https://www.qcloud.com/doc/api/257/1373
 * @param unknown_type $video_id
 * @return Ambigous <multitype:number NULL unknown , number, string, unknown>
 */
function get_vodset_by_video_id($video_id)
{
    $root = array();
    $root['status'] = 1;
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    $video = $video_redis->getRow_db($video_id, array('id', 'channelid', 'begin_time', 'video_type'));
    $fileName = $video_id . '_' . to_date($video['begin_time'], 'Y-m-d-H');//互动直播 例如：2018376_2017-01-12-18-03-19
    if ($video['video_type'] == 1 && $video['channelid']) {
        $fileName = 'live' . $video_id . '_' . to_date($video['begin_time'], 'Y-m-d-H');//云直播&频道托管    例如：live2018376_2017-01-12-18-03-19
        if (strpos($video['channelid'], '_')) {
            $fileName = $video['channelid'];//云直播&直播码 例如：2811_311359b479_dd55c664b4acf27c5138
        }
    }
    $ret = get_vodset_by_filename($fileName);
    //兼容 云直播&直播码接入&点播前缀有live
    if ($ret['status'] != 1) {
        if ($video['video_type'] == 1 && $video['channelid'] && strpos($video['channelid'], '_')) {
            $fileName = 'live' . $video['channelid'];//例如：live6311_311359b479_dd55c664b4acf27c5138
        }

        $ret = get_vodset_by_filename($fileName);
    }

    $root['total_count'] = 0;
    if ($ret['status'] == 1) {
        $root['vodset'][] = $ret['ret'];
        $root['total_count'] = $ret['ret']['totalCount'];
    } else {
        $root['status'] = 0;
        $root['error'] = $ret['error'];
    }

    return $root;
}

/**
 * 通过  房间号 获取视频播fileIds列表
 * https://www.qcloud.com/doc/api/257/1373
 * @param unknown_type $video_id
 */
function get_vod_fileIds($video_id)
{
    $fileName = $video_id . '_';
    $ret = get_vodset_by_filename($fileName);

    $fileIds = array();

    foreach ($ret['fileSet'] as $k2 => $v2) {
        $fileIds[] = $v2['fileId'];
    }

    return $fileIds;
}

/**
 * 通过  视频名称（前缀匹配） 获取视频播放信息列表
 * https://www.qcloud.com/doc/api/257/1373
 * @param unknown_type $fileName
 * @param unknown_type $page
 * @return multitype:number string unknown
 */
function get_vodset_by_filename($fileName, $page = 1, $page_size = 20)
{
    $root = array();
    $root['status'] = 1;


    bogo_require(APP_ROOT_PATH . 'system/QcloudApi/QcloudApi.php');

    $m_config = load_auto_cache("m_config");

    $config = array('SecretId'      => $m_config['qcloud_secret_id'],
                    'SecretKey'     => $m_config['qcloud_secret_key'],
                    'RequestMethod' => 'GET',
                    'DefaultRegion' => 'gz');

    $service = QcloudApi::load(QcloudApi::MODULE_VOD, $config);

    if ($page == 0) {
        $page = 1;
    }


    $package = array('fileName' => $fileName, 'pageNo' => $page, 'pageSize' => $page_size);
    $ret = $service->DescribeVodPlayInfo($package);

    if ($ret === false) {
        $error = $service->getError();
        $root['status'] = 0;
        $root['code'] = $error->getCode();
        $root['error'] = "fileName:" . $fileName . ";code:" . $error->getCode() . ";msg:" . $error->getMessage();
    } else {
        $root['ret'] = $ret;
    }

    $root['package'] = $ret;
    return $root;
}

/**
 * 每隔N秒，将在线直播redis计算的数据同步到mysql中
 */
function crontab_deal_num($s = 5)
{
    add_chat_log(166725, 166593, '1212121212', 'text 000');

    $is_ok = $GLOBALS['cache']->set_lock('crontab_deal_num', $s);
    if ($is_ok) {
        $sql = "SELECT id FROM " . DB_PREFIX . "video";
        $list = $GLOBALS['db']->getAll($sql, true, true);
        if (count($list) > 0) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            foreach ($list as $k => $v) {
                $video_id = $v['id'];
                //计算权重
                $video_redis->syn_sort_num($video_id);
                $fields = array('share_count', 'like_count', 'fans_count', 'sort_num', 'vote_number', 'robot_num', 'watch_number', 'virtual_watch_number', 'max_watch_number');
                $video = $video_redis->getRow_db($video_id, $fields);

                $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $video, "UPDATE", "id=" . $video_id);
            }
        }
    }
}


//同步所有数据库中的直播信息到redis
function sync_all_video_to_redis()
{

    $sql = "select * from " . DB_PREFIX . "video";
    $video = $GLOBALS['db']->getAll($sql);

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();

    foreach ($video as $v) {

        echo $v['id'] . '更新成功<br/>';

        $video_redis->update_db($v['id'], $v);

    }
}

/**
 * 把数据库中的bogo_video同步到redis上去
 * @param int    $video_id
 * @param string $fields              需要同步的字段 * 表示所有
 * @param bool   $exinclude_calc；true 不含redis中的计算字段array('share_count','like_count','fans_count', 'sort_num', 'vote_number', 'robot_num','watch_number', 'virtual_watch_number', 'max_watch_number')
 */
function sync_video_to_redis($video_id, $fields = '*', $exinclude_calc = true)
{

    if ($fields == '') $fields = '*';

    $sql = "select " . $fields . " from " . DB_PREFIX . "video where id = " . $video_id;
    $video = $GLOBALS['db']->getRow($sql);
    if ($video == false) {
        $sql = "select " . $fields . " from " . DB_PREFIX . "video_history where id = " . $video_id;
        $video = $GLOBALS['db']->getRow($sql);
    }

    if ($exinclude_calc) {
        $calc_fields = array('share_count', 'like_count', 'fans_count', 'sort_num', 'vote_number', 'robot_num', 'watch_number', 'virtual_watch_number', 'max_watch_number');
        foreach ($video as $k => $v) {
            if (in_array($k, $calc_fields)) {
                unset($video[$k]);
            }
        }
    }

    if ($fields == '*' && isset($video['vote_number'])) {
        unset($video['vote_number']);
    }

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();

    $video_redis->update_db($video_id, $video);

}

/**
 * 将发送礼物记录移到mysql数据库中
 * $num：一次插入多少条数据; -1取出所有记录;
 *
 * 本函数实际上已经失效;发送礼物记录，发送时直接记录在bogo_video_prop_ym表中了; 此时用来处理旧的redis中数据,同步到mysql中
 */
function sync_video_prop_to_mysql($num = -1)
{

    $is_ok = $GLOBALS['cache']->set_lock('sync_video_prop_to_mysql', 500);
    if ($is_ok) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoGiftRedisService.php');
        $videoGift_redis = new VideoGiftRedisService();

        //$list = $videoGift_redis->getAll($num);

        if ($num == -1) $num = 10000;
        $list = $videoGift_redis->getAll($num);
        if (count($list) == 0)
            $list = $videoGift_redis->getAll(-1);

        foreach ($list as $k => $v) {
            $video_prop = json_decode($v, true);


            $video_prop['create_y'] = to_date($video_prop['create_time'], 'Y');
            $video_prop['create_m'] = to_date($video_prop['create_time'], 'm');
            $video_prop['create_ym'] = to_date($video_prop['create_time'], 'Ym');
            $video_prop['create_d'] = to_date($video_prop['create_time'], 'd');
            $video_prop['create_w'] = to_date($video_prop['create_time'], 'W');

            //没做批量插入,主要是考虑支持重复执行
            $GLOBALS['db']->autoExecute(DB_PREFIX . "video_prop", $video_prop, "INSERT", '', 'SILENT');

            if ($GLOBALS['db']->affected_rows()) {
                $videoGift_redis->del_db($k);
            } else {
                $sql = "select id from " . DB_PREFIX . "video_prop where id = " . $k;
                if ($GLOBALS['db']->getOne($sql) > 0) {
                    $videoGift_redis->del_db($k);
                }
            }
        }

        $GLOBALS['cache']->del_lock('sync_video_prop_to_mysql');
    }
}

/**
 * 删除指定文件[前缀搜索]
 * @param unknown_type $fileName
 * @return multitype:unknown
 */
function del_all_vod($fileName)
{
    //$fileName = '_';
    $ret = get_vodset_by_filename($fileName, 1, 80);
    //print_r($ret);

    //$fileIds = array();

    bogo_require(APP_ROOT_PATH . 'system/QcloudApi/QcloudApi.php');

    $m_config = load_auto_cache("m_config");

    $config = array('SecretId'      => $m_config['qcloud_secret_id'],
                    'SecretKey'     => $m_config['qcloud_secret_key'],
                    'RequestMethod' => 'GET',
                    'DefaultRegion' => 'gz');

    $service = QcloudApi::load(QcloudApi::MODULE_VOD, $config);
    foreach ($ret['ret']['fileSet'] as $k2 => $v2) {
        $package = array('fileId' => $v2['fileId'], 'priority' => 0);
        $ret2 = $service->DeleteVodFile($package);
        $ret[$v2['fileId']] = $ret2;
    }
    //print_r($fileIds);
    return $ret;
}

/**
 * 历史直播：上架/下架
 * 上架: 将bogo_video_history 表数据,移到bogo_video 后，删除bogo_video_history记录
 * 下架: 将bogo_video 表数据,移到bogo_video_history 后，删除bogo_video记录
 * @param unknown_type $video_id
 * @param unknown_type $status ; 0:上架;1:下架;
 */
function video_status($video_id, $status)
{

    $pInTrans = $GLOBALS['db']->StartTrans();
    try {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');

        if ($status == 0) {
            //历史直播：上架
            $sql = "update " . DB_PREFIX . "video_history set live_in = 3 where live_in = 0 and id = " . $video_id;
            $GLOBALS['db']->query($sql);
            if ($GLOBALS['db']->affected_rows()) {
                $sql = "select * from " . DB_PREFIX . "video_history  where id = " . $video_id;
                $video = $GLOBALS['db']->getRow($sql);
                $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $video, "INSERT");

                //修改话题
                if ($video['cate_id'] > 0) {
                    $sql = "update " . DB_PREFIX . "video_cate a set a.num = (select count(*) from " . DB_PREFIX . "video b where b.cate_id = a.id and b.live_in in (1,3)";
                    $m_config = load_auto_cache("m_config");//初始化手机端配置
                    if ((defined('OPEN_ROOM_HIDE') && OPEN_ROOM_HIDE == 1) && intval($m_config['open_room_hide']) == 1) {
                        $sql .= " and b.province <> '" . api_lang('Mars') . "' and b.province <>''";
                    }
                    $sql .= ") where a.id = " . $video['cate_id'];
                    $GLOBALS['db']->query($sql);
                }

                $user_id = intval($video['user_id']);

                $user = $user_redis->getRow_db($user_id, $fields);
                $m_config = load_auto_cache("m_config");

                //sort_init(初始排序权重) = (用户可提现印票：bogo_user.ticket - bogo_user.refund_ticket)  * 保留印票权重+ 直播/回看[回看是：0; 直播：9000000000 直播,需要排在最上面 ]+ bogo_user.user_level * 等级权重+ bogo_user.fans_count * 当前有的关注数权重
                $sort_init = (intval($user['ticket']) - intval($user['refund_ticket'])) * floatval($m_config['ticke_weight']);

                $sort_init += intval($user['user_level']) * floatval($m_config['level_weight']);
                $sort_init += intval($user['fans_count']) * floatval($m_config['focus_weight']);

                $sql = "update " . DB_PREFIX . "video set sort_init = " . $sort_init . ",watch_number=0,robot_num=0 where id = " . $video_id;
                $GLOBALS['db']->query($sql);

                $sql = "delete from " . DB_PREFIX . "video_history WHERE id=" . $video_id;
                $GLOBALS['db']->query($sql);

                //将mysql数据,同步一份到redis中
                sync_video_to_redis($video_id, '*', false);
                //付费记录从历史表移到原记录表中
                if (intval($video['is_live_pay']) == 1) {
                    syn_history_to_live_pay($video_id);
                }
                $video_redis->video_online($video_id, $video['group_id']);
            }
        } else {
            //回看直播：下架
            $sql = "update " . DB_PREFIX . "video set live_in = 0 where live_in = 3 and id = " . $video_id;
            $GLOBALS['db']->query($sql);
            if ($GLOBALS['db']->affected_rows()) {
                //下架后，将redis数据,同步一份到mysql
                $fields = array('share_count', 'like_count', 'fans_count', 'sort_num', 'vote_number', 'robot_num', 'watch_number', 'virtual_watch_number', 'max_watch_number', 'user_id');
                $video = $video_redis->getRow_db($video_id, $fields);
                $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $video, "UPDATE", "id=" . $video_id);

                //将数据历史表中
                $sql = "select * from " . DB_PREFIX . "video where id = " . $video_id;
                $video = $GLOBALS['db']->getRow($sql);

                $GLOBALS['db']->autoExecute(DB_PREFIX . "video_history", $video, "INSERT");

                //修改话题
                if ($video['cate_id'] > 0) {
                    $sql = "update " . DB_PREFIX . "video_cate a set a.num = (select count(*) from " . DB_PREFIX . "video b where b.cate_id = a.id and b.live_in in (1,3)";
                    $m_config = load_auto_cache("m_config");//初始化手机端配置
                    if ((defined('OPEN_ROOM_HIDE') && OPEN_ROOM_HIDE == 1) && intval($m_config['open_room_hide']) == 1) {
                        $sql .= " and b.province <> '" . api_lang('Mars') . "' and b.province <>''";
                    }
                    $sql .= ") where a.id = " . $video['cate_id'];
                    $GLOBALS['db']->query($sql);
                }

                //将mysql数据,同步一份到redis中
                sync_video_to_redis($video_id, '*', false);
                //付费直播记录移到历史表
                if (intval($video['is_live_pay']) == 1) {
                    syn_live_pay_to_history($video_id, $video['user_id']);
                }
                $sql = "delete from " . DB_PREFIX . "video WHERE id=" . $video_id;
                $GLOBALS['db']->query($sql);

            }
        }

        $sql = "select count(*) as num from " . DB_PREFIX . "video_history where is_delete = 0 and is_del_vod = 0 and user_id = '" . $user_id . "'";
        $video_count = $GLOBALS['db']->getOne($sql);
        $sql = "update " . DB_PREFIX . "user set video_count = " . $video_count . " where id = " . $user_id;
        $GLOBALS['db']->query($sql);


        //提交事务,不等 消息推送,防止锁太久
        $GLOBALS['db']->Commit($pInTrans);
        $pInTrans = false;//防止，下面异常时，还调用：Rollback


        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_data = array();
        $user_data['video_count'] = $video_count;
        $user_redis->update_db($user_id, $user_data);

        return true;
    } catch (Exception $e) {
        //异常回滚
        $GLOBALS['db']->Rollback($pInTrans);

        return true;
    }
}

/**
 * 查询直播频道详情
 * https://www.qcloud.com/doc/api/258/4717
 * @param unknown_type $channelId
 * @return
 */
function describe_lvb_channel($channelId)
{

    bogo_require(APP_ROOT_PATH . 'system/QcloudApi/QcloudApi.php');

    $m_config = load_auto_cache("m_config");

    $config = array('SecretId'      => $m_config['qcloud_secret_id'],
                    'SecretKey'     => $m_config['qcloud_secret_key'],
                    'RequestMethod' => 'GET',
                    'DefaultRegion' => 'gz');

    $service = QcloudApi::load(QcloudApi::MODULE_LIVE, $config);

    $package = array('channelId' => $channelId);
    $ret = $service->DescribeLVBChannel($package);

    return $ret;
}

/**
 * 给用户分配红包
 * @param unknown_type $user_prop_id
 * @param unknown_type $user_id
 * @param unknown_type $money
 */
function allot_red_to_user($user_prop_id, $user_id, $money)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
    $videoRed_redis = new VideoRedRedisService();
    $videoRed_redis->add_user_winning($user_prop_id, $user_id, $money);

    //增加：用户钻石
    $sql = "update " . DB_PREFIX . "user set diamonds = diamonds + " . $money . " where id = " . $user_id;
    $GLOBALS['db']->query($sql);

    user_deal_to_reids(array($user_id));

    // 消费和收益记录表
    add_user_consumption_log(0, $user_id, 0, '抢红包', 0, $money, 22);

}

/**
 * 将直播房间中的，红包领取记录,同步一份到mysql中
 * 正常在：直播结束时调用一次，删除直播(视频)时调用一次
 * @param unknown_type $video_id
 */
function syn_red_to_mysql($video_id)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    //直播结束后,将redis中,领取红包记录保存一份到mysql中
    $red_list = $video_redis->get_reds($video_id);
    if (count($red_list) > 0) {
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
        $videoRed_redis = new VideoRedRedisService();
        $pInTrans = $GLOBALS['db']->StartTrans();
        try {
            foreach ($red_list as $red_id) {
                $user_list = $videoRed_redis->get_winnings($red_id);
                foreach ($user_list as $k => $v) {
                    $user_id = intval($v['user_id']);
                    $sql = "select id from " . DB_PREFIX . "video_red where video_id =" . $video_id . " and video_prop_id = " . $red_id . " and user_id =" . $user_id;
                    $id = $GLOBALS['db']->getOne($sql);

                    $video_red = array();
                    $video_red['video_id'] = $video_id;
                    $video_red['video_prop_id'] = $red_id;
                    $video_red['user_id'] = $user_id;
                    $video_red['diamonds'] = $v['diamonds'];

                    if ($id > 0) {
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "video_red", $video_red, "UPDATE", "id=" . $id);
                    } else {
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "video_red", $video_red, "INSERT");
                    }
                }
            }

            $GLOBALS['db']->Commit($pInTrans);
        } catch (Exception $e) {
            //异常回滚
            $GLOBALS['db']->Rollback($pInTrans);
        }
    }
}

function filter_false(&$data, $default = array())
{
    foreach ($default as $key => $value) {
        if ($data[$key] == false) {
            $data[$key] = $value;
        }
    }
}

function get_video_url($room_id, $live_in)
{
    if ($live_in == 3 || $live_in == 0) {
        return url('live#show', array('room_id' => $room_id, 'is_vod' => 1));
    } else {
        return url('live#show', array('room_id' => $room_id));
    }
}

function get_live_image($v)
{
    return get_spec_image(empty($v['live_image']) ? $v['head_image'] : $v['live_image'], 285, 160, 1);
}

function getPropTablename($video_id)
{
    $video_id = intval($video_id);
    // $table = DB_PREFIX . 'video';
    // $res = $GLOBALS['db']->getRow("SELECT `prop_table` FROM $table WHERE `id`=$video_id;");
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    $video = $video_redis->getRow_db($video_id, array('prop_table'));
    return $video ? $video['prop_table'] : $video;
}

function createPropTable($time = NOW_TIME)
{
    //获取上个月自增ID
    $prev_m = date("Ym", strtotime("-1 month"));
    $prev_table = DB_PREFIX . 'video_prop_' . $prev_m;
    $result = $GLOBALS['db']->getRow("SHOW TABLES LIKE'$prev_table'");
    if (empty($result)) {
        $prev_table = DB_PREFIX . 'video_prop';
    }

    $increment_id = $GLOBALS['db']->getOne("SELECT MAX(id) from " . $prev_table);

    $increment_id = intval($increment_id) ? intval($increment_id) : 1;

    $table = DB_PREFIX . 'video_prop_' . to_date($time, 'Ym');
    $res = $GLOBALS['db']->getRow("SHOW TABLES LIKE'$table'");
    if (!$res) {
        // 创建新表
        // 表结构
        // -- Table structure for `%DB_PREFIX%video_prop`
        $sql = "CREATE TABLE `$table` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `prop_id` int(10) NOT NULL DEFAULT '0' COMMENT '礼物id',
          `prop_name` varchar(255) NOT NULL COMMENT '道具名',
          `total_score` int(11) NOT NULL COMMENT '积分（from_user_id可获得的积分）合计',
          `total_diamonds` int(11) NOT NULL COMMENT '钻石（from_user_id减少的钻石）合计',
          `total_ticket` int(11) NOT NULL DEFAULT '0' COMMENT '印票(to_user_id增加的印票）合计;is_red_envelope=1时,为主播获得的：钻石 数量',
          `from_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '送',
          `to_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '收',
          `create_time` int(10) NOT NULL COMMENT '时间',
          `create_date` date NOT NULL COMMENT '日期字段,按日期归档；要不然数据量太大了；不好维护',
          `create_d` tinyint(2) NOT NULL COMMENT '日',
          `create_w` tinyint(2) NOT NULL COMMENT '周',
          `num` int(10) NOT NULL COMMENT '送的数量',
          `video_id` int(10) NOT NULL DEFAULT '0' COMMENT '直播ID',
          `group_id` varchar(20) NOT NULL COMMENT '群组ID',
          `is_red_envelope` tinyint(1) NOT NULL DEFAULT '0' COMMENT '1:红包',
          `msg` varchar(255) NOT NULL COMMENT '弹幕内容',
          `ActionStatus` varchar(10) NOT NULL COMMENT '消息发送，请求处理的结果，OK表示处理成功，FAIL表示失败。',
          `ErrorInfo` varchar(255) NOT NULL COMMENT '消息发送，错误信息',
          `ErrorCode` int(10) NOT NULL COMMENT '错误码',
          `create_ym` varchar(12) NOT NULL COMMENT '年月 如:201610',
          `from_ip` varchar(255) NOT NULL COMMENT '送礼物人IP',
          `is_private` int(4) default 0 COMMENT '判断是否为私信送礼 1表示私信 2表示不是私信',
          `is_award` tinyint(1) NOT NULL COMMENT '是否为可中奖礼物 1为 是、0为否',
          `is_coin` tinyint(1) NOT NULL COMMENT '双币礼物，0是钻石，1是游戏币',
          `family_id` int(11) NOT NULL COMMENT '家族id',
          `family_income` int(10) NOT NULL COMMENT '家族收益',
          PRIMARY KEY (`id`),
          KEY `idx_ecs_video_prop_cc_1` (`create_ym`,`create_d`,`from_user_id`,`total_diamonds`),
          KEY `from_user_id` (`from_user_id`,`total_diamonds`) USING BTREE,
          KEY `idx_ecs_video_prop_cc_2` (`create_ym`,`from_user_id`,`total_diamonds`),
          KEY `to_user_id` (`is_red_envelope`,`to_user_id`,`total_ticket`) USING BTREE,
          KEY `idx_ecs_video_prop_cc_3` (`create_ym`,`create_d`,`is_red_envelope`,`to_user_id`,`total_ticket`) USING BTREE,
          KEY `idx_ecs_video_prop_cc_4` (`create_ym`,`is_red_envelope`,`to_user_id`,`total_ticket`) USING BTREE
        ) ENGINE=InnoDB AUTO_INCREMENT={$increment_id} DEFAULT CHARSET=utf8 COMMENT='送礼物表'";
        $res = $GLOBALS['db']->query($sql);
    }
    /*$res = 1;
    $table = DB_PREFIX . 'video_prop';*/
    return $res ? $table : false;
}

// 私信记录按月分表
function createChatRecordTable($time = NOW_TIME)
{
    $table = DB_PREFIX . 'chat_record_log_' . to_date($time, 'Ym');
    $res = $GLOBALS['db']->getRow("SHOW TABLES LIKE'$table'");
    if (!$res) {
        // 创建新表 = 表结构   ''    => $to_user_name,
        //                            '' => $user_name,
        $sql = "CREATE TABLE `$table` (
          `id` int(11) NOT NULL AUTO_INCREMENT,
          `user_id` int(10) NOT NULL DEFAULT '0' COMMENT '发送人id',
          `to_user_id` int(10) NOT NULL DEFAULT '0' COMMENT '接收人id',
          `user_nickname` varchar(255) NOT NULL COMMENT '发送人昵称',
           `to_user_nickname` varchar(255) NOT NULL COMMENT '接收人昵称',
          `type` TINYINT(1) NOT NULL DEFAULT 1 COMMENT '1文字、2图片、3视频 4语音',
          `content` TEXT COMMENT '消息内容',
          `create_time` int(10) NOT NULL COMMENT '时间',
          `format_time` DATETIME DEFAULT NULL COMMENT '格式化时间',
          `is_revoke` TINYINT(1) NOT NULL DEFAULT 0 COMMENT '是否撤回0否1已撤回',
          `revoke_time` int(10) DEFAULT NULL COMMENT '撤回时间',
          `msg_key` TEXT COMMENT 'im唯一标识',
          PRIMARY KEY (`id`)
        ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='私信表'";
        $res = $GLOBALS['db']->query($sql);
    }
    return $res ? $table : false;
}

/**
 * 取前50条观众列表，IM推送到客户端
 * @param unknown_type $video_id
 * @param unknown_type $group_id
 * @return mixed
 */
function push_viewer($video_id, $group_id, $page_size = 50)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
    $video_viewer_redis = new VideoViewerRedisService();
    $viewer = $video_viewer_redis->get_viewer_list2($video_id, 1, $page_size);

    for ($i = count($viewer['list']) - 1; $i >= 0; $i--) {
        if ($viewer['list'][$i]['user_id'] == 0) {
            array_splice($viewer['list'], $i, 1);
        }
    }

    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/shorturl.php');

    $user_list = array();
    $viewer['list_fields'] = array('user_id', 'user_level', 'head_image', 'v_icon', 'is_robot', 'is_authentication', 'noble_avatar', 'noble_id', 'total_num');
    $short = shorturl::SHORTURL;
    //查询今日给此主播的贡献值
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoGiftRedisService.php');
    $video_gift_redis = new VideoGiftRedisService();
    $day = to_date(NOW_TIME, 'Y-m-d');
    $table = createPropTable();
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    $video = $video_redis->getRow_db($video_id, array('user_id'));
    foreach ($viewer['list'] as $k => $v) {

        $head_image = get_spec_image($v['head_image']);
        $v_icon = get_spec_image($v['v_icon']);
        $is_robot = intval($v['is_robot']);
        $noble_avatar = get_spec_image($v['noble_avatar']); //贵族头像图片
        $is_authentication = intval($v['is_authentication']);
        $noble_id = intval($v['noble_id']);
        //主播当日人气值
        $total_num = $video_gift_redis->getOne_gift_db($table . "_" . $day . "_" . $video_id, $v['user_id']);
        $total_num_val = $total_num > 0 ? format_for_ten_thousand($total_num) : 0;
        $user2 = array((string)$v['user_id'], (string)$v['user_level'], $head_image, $v_icon, $is_robot, $is_authentication, $noble_avatar, $noble_id, $total_num_val);

        $user_list[] = $user2;
    }

    unset($viewer['list']);
//主播当日人气值
    $total_num = $video_gift_redis->getOne_gift_db($table . "_" . $day . "_" . $video_id, $video['user_id']);

    $viewer['short_url'] = $short;//如果head_image,v_icon不是http://开头则需要加上short_url
    $viewer['list_data'] = $user_list;
    $viewer['charm_total_num'] = intval($total_num);
    $viewer['time'] = NOW_TIME;

    $ext = array();
    $ext['type'] = 42; //42 通用数据格式
    $ext['data_type'] = 0;//直播间观众列表
    $ext['data'] = $viewer;

    $msg_content = json_encode($ext);

    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
    $api = createTimAPI();
    $ret = $api->group_send_group_system_notification($group_id, $msg_content);

    return $ret;
}

/**
 * 回播定时推送观众列表
 * @param unknown_type $video_id
 * @param unknown_type $page_size
 * @param unknown_type $s
 * @return multitype:mixed
 */
function crontab_viewer($video_id, $page_size = 50, $s = 50)
{
    $ret = array();
    $is_ok = $GLOBALS['cache']->set_lock('crontab_viewer_num', $s);
    if ($is_ok) {
        if ($video_id == 0) {
            $sql = "SELECT id,group_id,watch_number FROM " . DB_PREFIX . "video where live_in = 3 and watch_number > 0";
        } else {
            $sql = "SELECT id,group_id,watch_number FROM " . DB_PREFIX . "video where id = " . $video_id;
        }
        //设置直播间观众列表返回数量
        $m_config = load_auto_cache("m_config");
        $page_size = intval($m_config['view_page_size']) > 0 ? intval($m_config['view_page_size']) : 50;
        $list = $GLOBALS['db']->getAll($sql, true, true);
        if (count($list) > 0) {
            foreach ($list as $k => $v) {
                $ret[] = push_viewer($v['id'], $v['group_id'], $page_size);
            }
        }

        $GLOBALS['cache']->del_lock('crontab_viewer_num');
    }
    return $ret;
}

function filter_all_false($default = array())
{
    if (is_array($default)) {
        foreach ($default as $key => $value) {
            if (is_array($value)) {
                $value = filter_all_false($value);
            } else {
                if ($value === false) {
                    $value = get_type($value);
                }
            }
            $default[$key] = $value;
        }
    } else {
        if ($default === false) {
            $default = get_type($default);
        }
    }
    return $default;
}

/*
    判断变量的类型
 */
function get_type($date = '')
{
    switch (gettype($date)) {
        case 'integer':
            return 0;
            break;
            break;
        case 'string':
            return '';
            break;
        case 'array':
            return array();
            break;
        case 'boolean':
            return '0';
            break;
        /* case 'double':
            return 0.00;
            break;
        case 'object':
            return object();
            break;
        case 'resource':
            return 'resource';
            break;
        case 'NULL':
            return 'NULL';
            break;
        case 'object':
            return  'object';
            break;*/
        default:
            return '0';
    }
}

/*
 * 视频合并
 * @param string $channel_id 直播码
 * @param string $new_file_name 新的文件名
 */
function Com_ConcatVideo($channel_id, $new_file_name)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
    $video_factory = new VideoFactory();
    $ret = $video_factory->ConcatVideo($channel_id, $new_file_name);
    return $ret;
}

//使用的sdk版本 0默认腾讯云、1金山
//映射关系类型  腾讯云直播, 金山云，星域，  云 ，阿里云
//video_type     1          2        3      4       5
//sdk_type       0          1        1      1       1
function get_sdk_info($video_type)
{
//    switch($video_type){
//        case 1:
//            return  $sdk_type = 0;
//            break;
//        default;
//            return $sdk_type = 1;
//            break;
//    }

    //$m_config = load_auto_cache('m_config');
    if (LIVE_SDK_TYPE == 1) {
        return 1;
    } else {
        return 0;
    }
}

//------付费相关------

/**
 * 按时付费直播结束后转按场付费
 * @param $video
 */
function change_pay_type($video)
{
    if (intval($video['live_pay_type']) != 1) {
        $sql = "update " . DB_PREFIX . "video set live_pay_type = 1 where id = " . $video['id'];
        $GLOBALS['db']->query($sql);
    }
}

/**
 * 是否付费过
 */
function get_pay_video_info($video_info)
{
    $root = array('status' => 1, 'error' => '');

    //初始化参数
    $live_pay_time = strim($video_info['live_pay_time']);
    $live_pay_type = intval($video_info['live_pay_type']);
    $live_fee = intval($video_info['live_fee']);
    $live_is_mention = intval($video_info['live_is_mention']);
    $is_live_pay = intval($video_info['is_live_pay']);
    $user_id = intval($GLOBALS['user_info']['id']);//用户ID
    $video_user_id = intval($video_info['user_id']);//主播ID
    $live_in = intval($video_info['live_in']);//直播间ID
    $room_id = intval($video_info['id']);//直播间ID
    $is_pay_over = 0; //是否付费   1 已付费；0未付费
    $new_room_id = 0;
    if (intval($video_info['pay_room_id']) > 0) {
        $room_id = $video_info['pay_room_id'];
        $new_room_id = $video_info['id'];
    }

    //非付费直播间 或者 直播不正常 或者 直播不存在 跳过
    if ($is_live_pay == 1 && $live_fee > 0 && $live_in != 0 && $room_id > 0) {
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //默认提醒
            if ($room_id > 0) {
                //获取付费记录信息
                $sql = "select id,pay_time_next,total_time,total_diamonds,live_pay_type from " . DB_PREFIX . "live_pay_log  where from_user_id = " . $user_id . " and to_user_id = " . $video_user_id . " and video_id=" . $room_id;
                $live_pay_log_info = $GLOBALS['db']->getRow($sql);
                //不可提醒
                $now_time = NOW_TIME;
                $root['status'] = 0;

                if (intval($live_pay_log_info['id']) > 0 && ($live_pay_log_info['live_pay_type'] == 1 || ($live_pay_log_info['pay_time_next'] > $now_time && $live_pay_log_info['live_pay_type'] == 0))) {
                    $is_pay_over = 1;
                    $root['status'] = 1;
                }
            }
        }
    }
    $root['is_live_pay'] = $is_live_pay;
    $root['live_pay_type'] = $live_pay_type;
    $root['live_fee'] = $live_fee;
    $root['is_pay_over'] = $is_pay_over;
    return $root;
}

/**
 * 将付费直播记录移到历史表
 * 正常在：直播结束时调用一次，删除直播(视频)时调用一次
 * @param unknown_type $video_id
 */
function syn_live_pay_to_history($video_id, $user_id)
{
    if ($video_id > 0) {
        $sql = "select MAX(id) from " . DB_PREFIX . "live_pay_log_history";
        $live_pay_log_history_mid = $GLOBALS['db']->getOne($sql);
        $sql = "select MAX(id) from " . DB_PREFIX . "live_pay_log";
        $live_pay_mid = $GLOBALS['db']->getOne($sql);
        if ($live_pay_log_history_mid > $live_pay_mid) {
            $video_max = $live_pay_log_history_mid + 1;
            $sql = "alter table " . DB_PREFIX . "live_pay_log AUTO_INCREMENT=" . $video_max;
            $GLOBALS['db']->query($sql);
        }

        //将本次直播付费记录 移到历史表中
        $fields = 'id,total_time,total_ticket,total_diamonds,from_user_id,to_user_id,create_time,create_date,create_ym,create_d,create_w,live_fee,live_pay_time,live_pay_date,video_id,group_id,pay_time_end,pay_time_next,live_is_mention_time,live_is_mention_pay,live_pay_type,new_room_id,total_score,uesddiamonds_to_score,ticket_to_rate';
        $sql = "insert into " . DB_PREFIX . "live_pay_log_history(" . $fields . ") select " . $fields . " from " . DB_PREFIX . "live_pay_log where video_id='" . $video_id . "' and to_user_id=" . $user_id;
        $GLOBALS['db']->query($sql);

        $sql = "delete from " . DB_PREFIX . "live_pay_log where video_id='" . $video_id . "' and to_user_id=" . $user_id;
        $GLOBALS['db']->query($sql);
    }
}

/**
 * 将付费直播从历史表移到原记录表中
 * 正常在：直播结束时调用一次，删除直播(视频)时调用一次
 * @param unknown_type $video_id
 */
function syn_history_to_live_pay($video_id)
{
    if ($video_id > 0) {
        //将本次直播付费记录 从历史表移到原记录表中
        $fields = 'total_time,total_ticket,total_diamonds,from_user_id,to_user_id,create_time,create_date,create_ym,create_d,create_w,live_fee,live_pay_time,live_pay_date,video_id,group_id,pay_time_end,pay_time_next,live_is_mention_time,live_is_mention_pay,live_pay_type,new_room_id,total_score,uesddiamonds_to_score,ticket_to_rate';
        $sql = "insert into " . DB_PREFIX . "live_pay_log(" . $fields . ") select " . $fields . " from " . DB_PREFIX . "live_pay_log_history where video_id='" . $video_id . "'";
        $GLOBALS['db']->query($sql);

        $sql = "delete from " . DB_PREFIX . "live_pay_log_history where video_id='" . $video_id . "'";
        $GLOBALS['db']->query($sql);
    }
}

//-------------家族收益处理-------------

/**
 * @ param int $user_id 主播ID
 * @ param int $family_id 家族ID
 * @ param float $vote_number 直播间总收益
 * @ param int $video_id 直播ID
 * @ param int $video_time 直播时长
 */
function family_receipts($user_id, $family_id, $vote_number, $video_id = 0, $video_time = 0, $is_voice = 0, $coin = 0)
{
    $m_config = load_auto_cache("m_config");//初始化手机端配置
    $family_income = intval(intval($vote_number) * 0.01 * $m_config['profit_ratio']);
    $sql = "select f.id as family_id,fj.id as join_id,f.status as family_status,f.user_id from " . DB_PREFIX . "user as fj left join " . DB_PREFIX . "family as f on f.id = fj.family_id where  fj.id = " . $user_id . " and fj.family_id =" . $family_id;
    $family_info = $GLOBALS['db']->getRow($sql);
    $return_family_income = 0;
    if ($family_info['join_id'] > 0 && $family_info['family_status'] == 1 && $family_info['family_id'] > 0) {
        if ($family_income) {
            $return_family_income = $family_income;
            $family_score = 0;
            //合并贡献收益 判断，用户当前等级积分
            if (floatval($m_config['contribution_to_experience']) > 0) {
                $family_score = $family_income * floatval($m_config['contribution_to_experience']) + $family_income;
                //修改个人家族积分贡献
                $sql = "update " . DB_PREFIX . "user set family_score = family_score + " . $family_score . " where family_id = " . $family_id . " and id = " . $user_id;
                $GLOBALS['db']->query($sql);
                //修改家族积分，直播时长数据
                $sql = "update " . DB_PREFIX . "family set score = score + " . $family_score . " where status=1 and id = " . $family_id;
                $GLOBALS['db']->query($sql);
            }
            //添加贡献记录
            $sqls = "insert into " . DB_PREFIX . "family_score_log";
            $ins_arr = [
                'uid'        => $user_id,
                'family_id'  => $family_id,
                'score'      => $family_score,
                'video_id'   => $video_id,
                'video_time' => $video_time,
                'addtime'    => NOW_TIME,
                'coin'       => intval($coin),
            ];
            $sqls .= insertstr($ins_arr);
            $GLOBALS['db']->query($sqls);

            bogo_require(APP_ROOT_PATH . "system/libs/auto_cache.php");
            bogo_require(APP_ROOT_PATH . "system/auto_cache/family_contribution.auto_cache.php");
            $class = "family_contribution_auto_cache";
            $obj = new $class;
            $param = array(
                'family_id' => $family_id,
            );
            $obj->rm($param);
            $family_info = $GLOBALS['db']->getRow("SELECT id as family_id,family_level,video_time,score,user_id FROM " . DB_PREFIX . "family WHERE id=" . $family_id . " and status=1", true, true);
            family_level_syn($family_info);


            //增加：家族收益
            $sql = "update " . DB_PREFIX . "family set contribution = contribution + " . $family_income . " where id = " . $family_id;
            $GLOBALS['db']->query($sql);
            //将家族收益汇入家族长
            $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $family_income . " where id = " . $family_info['user_id'];
            $status = $GLOBALS['db']->query($sql);
            user_deal_to_reids(array($family_info['user_id']));
            //添加收益记录
            $sqls = "insert into " . DB_PREFIX . "family_earnings";
            $ins_arr = [
                'uid'             => $user_id,
                'family_id'       => $family_id,
                'family_earnings' => $family_income,
                'video_id'        => $video_id,
                'is_voice'        => $is_voice,
                'time_sum'        => $video_time,
                'vote_number'     => $vote_number,
                'profit_ratio'    => $m_config['profit_ratio'],
                'create_time'     => NOW_TIME,
            ];
            $sqls .= insertstr($ins_arr);
            $GLOBALS['db']->query($sqls);
            if ($status) {
                $data['ticket'] = intval($family_income);
                $param['type'] = 4;//类型 0表示充值 1表示提现 2赠送道具 3 兑换印票 4 家族收益
                $log_msg = api_lang('收取家族收益') . $data['ticket'] . api_lang("Printing_tickets");
                add_user_consumption_log(0, $family_info['user_id'], 0, $log_msg, $data['ticket'], 0, 19);
                account_log_com($data, $family_info['user_id'], $log_msg, $param);
            }
        } else if (intval($vote_number) > 0) {
            //添加贡献记录
            $sqls = "insert into " . DB_PREFIX . "family_score_log";
            $ins_arr = [
                'uid'        => $user_id,
                'family_id'  => $family_id,
                'score'      => 0,
                'video_id'   => $video_id,
                'video_time' => $video_time,
                'addtime'    => NOW_TIME,
                'coin'       => intval($vote_number),
            ];
            $sqls .= insertstr($ins_arr);
            $GLOBALS['db']->query($sqls);
        }

    }
    return $return_family_income;
}

function family_receipts1($video_id, $user_id, $video)
{
    $video_id = intval($video_id);
    $user_id = intval($user_id);
    if ($video_id == 0 || $user_id == 0) {
        return;
    }
    // 获取房间流水
//    $diamonds_water = $GLOBALS['db']->getOne("select diamonds_water from " . DB_PREFIX . "video where id = " . $video_id, true, true);

    $video_time = (NOW_TIME - $video["begin_time"]);
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');
    $userinfo = $user_redis->getRow_db($user_id, $fields);

    $family_id = intval($userinfo['family_id']);
    $family = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "family where status = 1 and  id = " . $family_id, true, true); //家族是否审核通过
    if ($family_id > 0 && !empty($family)) {
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $family_score = 0;

        //合并直播时长 判断，用户当前等级积分
        $vte = floatval($m_config['videotime_to_experience']);
        if ($vte > 0) {
            $family_score += $video_time * $vte;
        }

        //修改个人家族积分贡献
        $sql = "update " . DB_PREFIX . "user set family_score = family_score + " . $family_score . " where family_id = " . $family_id . " and id = " . $user_id;
        $GLOBALS['db']->query($sql);

        //修改家族积分，直播时长数据
        $sql = "update " . DB_PREFIX . "family set video_time = video_time + " . $video_time . ",score = score + " . $family_score . " where status=1 and id = " . $family_id;
        $GLOBALS['db']->query($sql);

        //添加贡献记录
        $sqls = "insert into " . DB_PREFIX . "family_score_log";
        $ins_arr = [
            'uid'        => $user_id,
            'family_id'  => $family_id,
            'score'      => $family_score,
            'video_id'   => $video['id'],
            'video_time' => $video_time,
            'addtime'    => NOW_TIME,
        ];
        $sqls .= insertstr($ins_arr);
        $GLOBALS['db']->query($sqls);

        bogo_require(APP_ROOT_PATH . "system/libs/auto_cache.php");

        $file = APP_ROOT_PATH . "system/auto_cache/family_contribution.auto_cache.php";
        bogo_require($file);
        $class = "family_contribution_auto_cache";
        $obj = new $class;
        $param = array(
            'family_id' => $family_id,
        );
        $obj->rm($param);

        $family_info = $GLOBALS['db']->getRow("SELECT id as family_id,family_level,video_time,score FROM " . DB_PREFIX . "family WHERE id=" . $family_id . " and status=1", true, true);
        family_level_syn($family_info);
    }
}

//-------------公会无抽成模式---------------

/**
 * @param $video 直播结束相关信息
 * @return bool
 */
function society_receipts($video)
{
    if (intval($video['vote_number']) <= 0) {
        return false;
    }
    //公会的收益
    $society_income = intval($video['vote_number']);

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');
    $user_info = $user_redis->getRow_db($video['user_id'], $fields);

    $society_info = $GLOBALS['db']->getRow("select user_id,status from " . DB_PREFIX . "society where id=" . $user_info['society_id']);
    //判断是否扣除过
    $user_log_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_log where type=10 and user_id = " . $video['user_id'] . " and video_id=" . intval($video['id']));

    if ($user_info['society_id'] > 0 && $society_info['status'] == 1 && intval($user_log_id) == 0) {
        //主播的收益加到公会中
        $pInTrans = $GLOBALS['db']->StartTrans();
        try {
            //收益添加到公会收益中
            $GLOBALS['db']->query("update " . DB_PREFIX . "society set chairman_earnings=chairman_earnings+" . $society_income . " where id=" . $user_info['society_id']);

            if ($user_info['society_chieftain'] == 0) {//排除会长
                //将用户上交的公会的印票计入已提现
                $sql = "update " . DB_PREFIX . "user set refund_ticket = refund_ticket + " . $society_income . ",society_ticket=society_ticket+" . $society_income . " where id = " . $video['user_id'] . " and ticket >=" . $society_income;
                $status = $GLOBALS['db']->query($sql);
                user_deal_to_reids(array($video['user_id']));
            } else {
                $status = true;
            }


            if ($status) {
                if ($user_info['society_chieftain'] == 0) {//排除会长
                    //将收益汇入公会长
                    $sql_chieftain = "update " . DB_PREFIX . "user set ticket = ticket + " . $society_income . " where id = " . $society_info['user_id'];
                    $GLOBALS['db']->query($sql_chieftain);
                    user_deal_to_reids(array($society_info['user_id']));

                    //写入会长日志
                    earnings_log($society_income, $user_info['society_id'], $video['user_id'], 10, '获取收益：公会成员' . $video['user_id'] . '贡献' . $society_income . api_lang("Printing_tickets"), $society_info['user_id'], $video['id']);
                }

                if ($user_info['society_chieftain']) {
                    $contribution_id = $society_info['user_id'];
                } else {
                    $contribution_id = 0;
                }

                //写入用户日志
                earnings_log($society_income, $user_info['society_id'], $contribution_id, 10, '直播获取收益' . $society_income . api_lang("Printing_tickets"), $video['user_id'], $video['id']);


                //公会等级积分的写入
                society_level_syn($society_income, $video["begin_time"], $user_info['society_id']);
                $m_config = load_auto_cache("m_config");//初始化手机端配置
                //记录到公会主播收益表
                $society_data = array();
                $society_earning_id = $GLOBALS['db']->getOne('select id from ' . DB_PREFIX . "society_earning where video_id=" . $video['id']);//是否已经记录过
                if (!$society_earning_id && $user_info['society_id'] > 0) {//收益还未记录且主播是公会成员
                    $society_data['video_id'] = $video['id'];
                    $society_data['user_id'] = $video['user_id'];
                    $society_data['vote_number'] = $video['vote_number'];
                    $society_data['begin_time'] = $video['begin_time'];
                    $society_data['end_time'] = $video['end_time'] ? $video['end_time'] : NOW_TIME;
                    $society_data['timelen'] = $society_data['end_time'] - $society_data['begin_time'];
                    $society_data['society_id'] = $user_info['society_id'];
                    $society_data['end_date'] = to_date($society_data['end_time'], 'Y-m-d');
                    $society_data['end_Y'] = to_date($society_data['end_time'], 'Y');
                    $society_data['end_m'] = to_date($society_data['end_time'], 'm');
                    $society_data['end_d'] = to_date($society_data['end_time'], 'd');
                    $society_data['end_w'] = to_date($society_data['end_time'], 'W');
                    $society_data['society_settlement_type'] = $m_config['society_pattern'];
                    $society_data['society_number'] = $society_income;

                    $GLOBALS['db']->autoExecute(DB_PREFIX . "society_earning", $society_data);
                }
            }
            //提交事务
            $GLOBALS['db']->Commit($pInTrans);
        } catch (Exception $e) {
            //异常回滚
            $GLOBALS['db']->Rollback($pInTrans);
            //写入用户日志
            earnings_log($society_income, $user_info['society_id'], $contribution_id, 10, '直播获取收益' . $society_income . '印票，失败', $video['user_id'], $video['id']);

            //写入会长日志
            earnings_log($society_income, $user_info['society_id'], $video['user_id'], 10, '获取收益：公会成员' . $video['user_id'] . '贡献' . $society_income . '印票，失败', $society_info['user_id'], $video['id']);
        }
        //-----事务结束-----
    }
    return;
}

//-------------平台收益,针对无公会人员-------------

/**
 * @ param int $user_id 主播ID
 * @ param float $m_config 配置信息
 * @ param int $video 直播信息
 * @ param int $video_id 直播ID
 */
function platform_receipts($user_id, $m_config, $video, $video_id = 0)
{
    $society_income = 0;
    $user_log_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_log where type<>7 and user_id = " . $user_id . " and video_id=" . intval($video_id));
    if ($m_config['society_platform_earnings'] >= 0 && intval($user_log_id) == 0 && $m_config['society_platform_earnings'] < 100 && $video['vote_number'] > 0) {

        //写入用户日志
        earnings_log($video['vote_number'], 0, 0, 11, '直播获取收益' . intval($video['vote_number']) . api_lang("Printing_tickets"), $user_id, $video_id);

        if ($m_config['society_platform_earnings'] == 0) {//平台不抽成
            return true;
        }
        $society_income = intval(intval($video['vote_number']) * 0.01 * $m_config['society_platform_earnings']);
        //增加收益更新到用户上
        //$sql = "update " . DB_PREFIX . "user set ticket = ticket + ".$video['vote_number'].",refund_ticket = refund_ticket + " . $society_income . " where id = " .$user_id. " and ticket > refund_ticket + " . $society_income;
        $sql = "update " . DB_PREFIX . "user set refund_ticket = refund_ticket + " . $society_income . " where id = " . $user_id . " and ticket > refund_ticket + " . $society_income;
        $status = $GLOBALS['db']->query($sql);
        user_deal_to_reids(array($user_id));
        if ($status) {
            //写入用户日志
            earnings_log($society_income, 0, 0, 11, '扣除平台收益' . $society_income . api_lang("Printing_tickets"), $user_id);
            return true;
        } else {
            return false;
        }
    }
}

//-------------公会有抽成模式，会长收益-------------
/**
 * @ param int $user_id 主播ID
 * @ param int $society_id 公会ID
 * @ param float $society_income 直播结束所得收益
 * @ param int $video_id 直播ID
 */
function society_receipts1($user_id, $society_id, $society_income, $vote_number, $video_id = 0)
{
    $sql = "select s.id as society_id,sa.id as apply_id,s.status as society_status,s.user_id from " . DB_PREFIX . "society_apply as sa left join " . DB_PREFIX . "society as s on s.id = sa.society_id where sa.status in(1,3) and sa.user_id = " . $user_id . " and sa.society_id =" . $society_id;
    $society_info = $GLOBALS['db']->getRow($sql);

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');
    $user_info = $user_redis->getRow_db($user_id, $fields);
    $society_chieftain = $user_info['society_chieftain'];

    if ($society_info['apply_id'] > 0 && $society_info['society_status'] == 1 && $society_info['society_id'] > 0) {
        if ($society_income) {

            if ($society_chieftain == 0) {//排除会长自己
                //增加：公会收益
                $sql = "update " . DB_PREFIX . "society set contribution = contribution + " . $society_income . " where id = " . $society_id;
                $GLOBALS['db']->query($sql);
                //将公会收益汇给会长
                $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $society_income . " where id = " . $society_info['user_id'];
                $status = $GLOBALS['db']->query($sql);
                user_deal_to_reids(array($society_info['user_id']));
            } else {
                //增加：公会收益
                $sql = "update " . DB_PREFIX . "society set contribution = contribution + " . $vote_number . " where id = " . $society_id;
                $GLOBALS['db']->query($sql);
            }

            if ($society_chieftain) {
                $contribution_id = $user_id;
            } else {
                $contribution_id = 0;
            }
            //收益情况写入用户日志
            earnings_log($vote_number, $society_id, $contribution_id, 8, '直播获取收益' . $vote_number . api_lang("Printing_tickets"), $user_id, $video_id);

            $m_config = load_auto_cache("m_config");//初始化手机端配置
            if (intval($m_config['society_profit_platform']) == 0 && $society_chieftain == 0) {//判断会长抽成是否由平台支付，0否1是
                $sql = "update " . DB_PREFIX . "user set refund_ticket = refund_ticket + " . $society_income . " where id = " . $user_id . " and ticket > refund_ticket + " . $society_income;
                $GLOBALS['db']->query($sql);
                user_deal_to_reids(array($user_id));

                //写入用户日志
                earnings_log($society_income, $society_id, 0, 8, '扣除公会长抽成' . $society_income . api_lang("Printing_tickets"), $user_id, $video_id);
            }

            if ($society_chieftain == 0) {

                //写入公会长日志
                earnings_log($society_income, $society_id, $user_id, 8, '获取公会成员' . $user_id . '：' . $society_income . api_lang("Printing_tickets"), $society_info['user_id'], $video_id);

            }

            return true;
        }
        return false;
    } else {
        return false;
    }
}

//-------------公会等级积分-------------
/**
 * @ param int $m_config 配置信息
 * @ param int $user_id 用户ID
 * @ param int $video_id 直播ID
 * @ param array $video 直播信息
 * @ param array $user_info 包含成员的 公会ID和会长标识
 */
function society_lv_jf($m_config, $user_id, $video_id, $video, $user_info)
{
    $society_income = 0;
    //判断是否扣除过
    $user_log_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_log where type=8 and user_id = " . $user_id . " and video_id=" . intval($video_id));
    if ($m_config['society_profit_ratio'] >= 0 && intval($user_log_id) == 0 && $m_config['society_profit_ratio'] < 100) {
        if ($m_config['society_profit_ratio'] == 0) {

            //写入用户日志
            earnings_log($video['vote_number'], $user_info['society_id'], 0, 8, '直播获取收益' . intval($video['vote_number']) . api_lang("Printing_tickets"), $user_id, $video_id);
            return true;
        }
        $society_income = intval(intval($video['vote_number']) * 0.01 * $m_config['society_profit_ratio']);
        $result = society_receipts1($user_id, $user_info['society_id'], $society_income, $video['vote_number'], $video_id);
        if ($result) {
            //公会等级积分的写入
            $society_score = intval($video['vote_number']);
            society_level_syn($video['vote_number'], $video['begin_time'], $user_info['society_id']);

            //记录到公会主播收益表
            $society_data = array();
            $society_earning_id = $GLOBALS['db']->getOne('select id from ' . DB_PREFIX . "society_earning where video_id=" . $video['id']);//是否已经记录过
            if (!$society_earning_id && $user_info['society_id'] > 0) {//收益还未记录且主播是公会成员
                $society_data['video_id'] = $video['id'];
                $society_data['user_id'] = $video['user_id'];
                $society_data['vote_number'] = $video['vote_number'];
                $society_data['begin_time'] = $video['begin_time'];
                $society_data['end_time'] = $video['end_time'] ? $video['end_time'] : NOW_TIME;
                $society_data['timelen'] = $society_data['end_time'] - $society_data['begin_time'];
                $society_data['society_id'] = $user_info['society_id'];
                $society_data['end_date'] = to_date($society_data['end_time'], 'Y-m-d');
                $society_data['end_Y'] = to_date($society_data['end_time'], 'Y');
                $society_data['end_m'] = to_date($society_data['end_time'], 'm');
                $society_data['end_d'] = to_date($society_data['end_time'], 'd');
                $society_data['end_w'] = to_date($society_data['end_time'], 'W');
                $society_data['society_settlement_type'] = $m_config['society_pattern'];

                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();
                $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');
                $user_info = $user_redis->getRow_db($user_id, $fields);

                if ($user_info['society_chieftain']) {
                    $society_data['society_number'] = $society_score;
                } else {
                    $society_data['society_number'] = $society_income;
                }

                $GLOBALS['db']->autoExecute(DB_PREFIX . "society_earning", $society_data);
            }
        }
    }
}

//-------------公会等级积分写入-------------
/**
 * @ param int    $society_income 直播结束所得收益
 * @ param number $begin_time 直播时长
 * @ param int    $society_id 公会ID
 */
function society_level_syn($society_income, $begin_time, $society_id)
{

    $m_config = load_auto_cache("m_config");//初始化手机端配置
    $society_score = 0;
    //合并贡献收益 判断，用户当前等级积分
    $cte = intval($m_config['society_lv_contribution']);
    if ($cte > 0 && $cte < 100) {
        $society_score += $society_income * $cte * 0.01;
    }
    if ($begin_time > 0) {//区分私信送礼物
        $video_time = (NOW_TIME - $begin_time);
        //合并直播时长 判断，用户当前等级积分
        $vte = intval($m_config['society_lv_videotime']);
        if ($vte > 0 && $vte < 100) {
            $society_score += $video_time * $vte * 0.01;
        }
    }
    if ($cte > 0 || ($begin_time > 0 && $vte > 0)) {
        //积分写入
        $GLOBALS['db']->query("update " . DB_PREFIX . "society set score=score+" . intval($society_score) . " where id=" . $society_id);
        $society_info = $GLOBALS['db']->getRow("SELECT id as society_id,society_level,score FROM " . DB_PREFIX . "society WHERE id=" . $society_id . " and status=1", true, true);
        //society_level_syn($society_info);
        $society_score = $society_info['score'];
        $society_level_info = load_auto_cache("society_level");
        $society_level = null;
        foreach ($society_level_info as $v) {
            // 两层关系即可
            unset($society_level['next_level']);
            $v['next_level'] = $society_level;
            $society_level = $v;
            if ($v['score'] <= intval($society_score)) {
                break;
            }
        }
        if ($society_level) {
            $GLOBALS['db']->query("update " . DB_PREFIX . "society set society_level = " . $society_level['level'] . " where id = " . $society_info['society_id']);
        }
        return $society_level;
    }
}

//判断用户是否参与众筹
function is_ordered($room_id, $user_id)
{
    $is_order = 0;
    $deal_id = $GLOBALS['db']->getOne("select deal_id from " . DB_PREFIX . "edu_video_info where video_id= " . $room_id);
    if ($deal_id) {
        $deal_order_count = $GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "edu_deal_order where deal_id= " . $deal_id . " and order_status=1 and is_refund=0 and user_id =" . $user_id);
        if ($deal_order_count > 0) {
            $is_order = 1;
        }
    }
    return $is_order;
}

/**
 * 返回用户等级信息,当前经验和下一级所需经验
 * @param $user_id
 * @return mixed
 */
function get_level_up_grade($user_id)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    $user_data = $user_redis->getRow_db($user_id, array('id', 'score', 'online_time', 'user_level'));
    user_leverl_syn($user_data);
    $level = $GLOBALS['db']->getRow("select ul.level as user_level, ul.score as l_score from " . DB_PREFIX . "user_level as ul  where ul.level=" . intval($user_data['user_level']));
    $m_config = load_auto_cache("m_config");
    $level['u_score'] = $user_data['score'] + floor($user_data['online_time'] * floatval($m_config['onlinetime_to_experience']));
    $level['up_score'] = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level=" . intval($user_data['user_level'] + 1));
    if (intval($level['up_score']) <= 0) {
        $l_up_score = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level>" . intval($user_data['user_level'] + 1));
        if ($l_up_score['score'] > 0) {
            $level['up_score'] = $l_up_score['score'];
        } else {
            $level['up_score'] = api_lang("Full_class");
        }
    }
    $level['u_score'] = intval($level['u_score']);
    $level['up_score'] = intval($level['up_score']);
    return $level;
}

/**
 * //暮橙定制: IM推送用户等级和经验信息
 * @param $user_id
 * @return bool
 */
function push_level_info($user_id)
{

    $m_config = load_auto_cache("m_config");
    $system_user_id = $m_config['tim_identifier'];//系统消息
    $level = get_level_up_grade($user_id);
    $level_info = array();
    $level_info['user_level'] = $level['user_level'];
    if ($level['up_score'] == api_lang("Full_class")) {
        $level_info['score_msg'] = "升级还需0" . $m_config['ticket_name'];
    } else {
        $score = $level['up_score'] - $level['u_score'];
        $level_info['score_msg'] = "升级还需" . $score . $m_config['ticket_name'];
    }
    $ext2 = array();
    $ext2['type'] = 61; //上海暮橙定制: 用户送礼给主播,系统返回推送用户等级和升级经验信息
    $ext2['level_info'] = $level_info;
    $msg_content2 = array();
    //创建array 所需元素
    $msg_content_elem2 = array(
        'MsgType'    => 'TIMCustomElem',       //自定义类型
        'MsgContent' => array(
            'Data' => json_encode($ext2),
            'Desc' => ''
        )
    );
    //将创建的元素$msg_content_elem, 加入array $msg_content
    array_push($msg_content2, $msg_content_elem2);
    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
    $api = createTimAPI();
    $ret2 = $api->openim_send_msg2($system_user_id, (string)$user_id, $msg_content2);
    if ($ret2['ActionStatus'] != 'OK') {
        //二次处理
        $ret2 = $api->openim_send_msg2($system_user_id, (string)$user_id, $msg_content2);
    }
    if ($ret2['ActionStatus'] == 'OK') {
        return true;
    } else {
        return false;
    }
}

/**
 * //公会收益日志
 * @param int    $ticket          印票数
 * @param int    $type            类型
 * @param string $log             日志内容
 * @param int    $user_id         用户id
 * @param int    $society_id      公会id
 * @param int    $contribution_id 会长抽取收益的成员id
 * @param int    $video_id        直播间id
 * */
function earnings_log($ticket, $society_id, $contribution_id, $type, $log, $user_id, $video_id = 0)
{
    $data = array();
    $data['ticket'] = $ticket;
    $data['society_id'] = $society_id;
    $data['contribution_id'] = $contribution_id;//会长记录
    $data['video_id'] = $video_id;
    $param['type'] = $type;//类型 0表示充值 1表示提现 2赠送道具 3 兑换印票  4 分享获得印票 5 登录赠送积分 6 观看付费直播 7游戏收益8扣除公会收益9分销收益10公会长收益11平台收益 12公会操作13私信收入
    $log_msg = $log;
    account_log_com($data, $user_id, $log_msg, $param);
}


/**
 * 获取程序执行时间
 * @param int $type 0：初次执行时间 1：最终执行时间
 */
function get_runtime($pram, $type = 0)
{
    //get_runtime(array(__FILE__,__LINE__,__METHOD__),1);
    if ($type == 0) {
        global $get_runtime_t1;
        $get_runtime_t1 = microtime(true);
        log_file('文件名：' . $pram[0] . ',行数：' . $pram[1] . ',方法：' . $pram[2] . '，首次执行时间' . $get_runtime_t1 . '秒', 'run_time');
    } else {
        $get_runtime_t1 = $GLOBALS['get_runtime_t1'];
        $get_runtime_t2 = microtime(true);
        log_file('文件名：' . $pram[0] . ',行数：' . $pram[1] . ',方法：' . $pram[2] . '，最后执行时间' . $get_runtime_t2 . '秒', 'run_time');
        log_file('文件名：' . $pram[0] . ',行数：' . $pram[1] . ',方法：' . $pram[2] . '，耗时' . floatval($get_runtime_t2 - $get_runtime_t1) . '秒', 'run_time');
    }
}

/**
 * 得到X时间之前
 * @param $timing
 * @return string
 */
function get_timing($timing)
{
    $timing_time = '';
    $timings = NOW_TIME - $timing;

    if ($timings <= 60 * 60 * 24 * 30) {
        $total_time_format = '';
        $time = $timings;
        if ($time / 86400 >= 1) {
            $total_time_format .= intval($time / 86400) . api_lang("Days_ago");
            $time = $time % 86400;
        } elseif ($time / 3600 >= 1) {
            $total_time_format .= intval($time / 3600) . api_lang("Hours_ago");
            $time = $time % 3600;
        } elseif ($time / 60 >= 1) {
            $total_time_format .= intval($time / 60) . api_lang("Minutes_ago");
            $time = $time % 60;
        } else {
            $total_time_format .= intval($timings) . api_lang("Seconds_ago");
        }
        $timing_time = $total_time_format;

    } else {
        $timing_time = date('m-d', $timing);
    }

    return $timing_time;
}

/**
 * 用户资金变动记录
 * @param $ins_arr
 * @return mixed
 */
function user_log($ins_arr)
{
    $sql = "insert into " . DB_PREFIX . "user_log";
//    $ins_arr = [
//        'log_info' => '每日签到赠送'.$reward.'钻石',
//        'log_time' => $time,
//        'log_admin_id' => 0,
//        'money' => 0,
//        'user_id' => $user_id,
//        'type' => 20,
//        'diamonds' => $reward
//    ];
    $sql .= insertstr($ins_arr);
    $bool = $GLOBALS['db']->query($sql);
//    if ( !$bool ) {
//        $root['error'] = '记录失败';
//        ajax_return($root);
//    }
    return $bool;
}

/**
 * 封装ajax_return
 * @param $code
 * @param $msg
 */
function y_ajax($msg = '', $data = [])
{
    $root = [];
    $root['status'] = 1;
    $root['error'] = $msg;

    ajax_return(array_merge($root, $data));
}

/**
 * 封装ajax_return
 * @param $code
 * @param $msg
 */
function n_ajax($msg = '')
{
    $root = [];
    $root['status'] = 0;
    $root['error'] = $msg;
    ajax_return($root);
}

/**
 * 根据传入key做数组key
 * @param $arr
 * @param $key
 * @param $new_arr
 * @return mixed
 */
function formatArray($arr, $key, $new_arr)
{
    foreach ($arr as $v) {
        $new_arr[$v[$key]] = $v;
    }
    return $new_arr;
}

/*
   *  购买坐骑vip靓号和贵族记录
   *  uid:用户id
   *  type:1座驾2vip 3靓号4贵族
   *  table_id : 类型表id
   *  money:消费的金额
    */
function add_buy_record($uid, $type, $table_id, $money)
{
    $sql = "insert into " . DB_PREFIX . "buy_record(uid,type,table_id,addtime,money) values(" . $uid . "," . $type . "," . $table_id . "," . time() . "," . $money . ")";
    $status = $GLOBALS['db']->query($sql);
    //  var_dump($sql);exit;
    return $status;
}

/**
 * 贡献排行榜定时请求存入缓存
 */
function upd_contribution_ranking()
{
    $day_key = "rank_consumption_day";
    $month_key = "rank_consumption_month";
    $all_key = "rank_consumption_all";
    $table = createPropTable();
    // 当日
    $day_start_time = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
    $sql = "select u.id as user_id ,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_diamonds) as ticket ,u.is_authentication,u.sex,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
												from " . $table . " as v LEFT JOIN  " . DB_PREFIX . "user as u on u.id = v.from_user_id
												where u.is_effect=1 and v.create_time >=" . $day_start_time . " GROUP BY v.from_user_id
												order BY sum(v.total_diamonds) desc limit 0,100";

    $day_list = $GLOBALS['db']->getAll($sql, true, true);
    // 本月
    $month_start_time = mktime(0, 0, 0, date('m'), 1, date('Y'));

    $sql = "select u.id as user_id ,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_diamonds) as ticket ,u.is_authentication,u.sex,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from  " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = v.from_user_id
											where u.is_effect=1 and v.create_time >=" . $month_start_time . " GROUP BY v.from_user_id
											order BY sum(v.total_diamonds) desc limit 0,100";

    $month_list = $GLOBALS['db']->getAll($sql, true, true);
    // 全部
    $sql = "select u.id as user_id ,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,u.use_diamonds as ticket ,u.is_authentication,u.sex,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from " . DB_PREFIX . "user as u where u.is_effect=1 and u.use_diamonds>0
											order BY u.use_diamonds desc limit 0,100";
    $list = $GLOBALS['db']->getAll($sql, true, true);

    $GLOBALS['cache']->set($day_key, $day_list);//缓存时间 1800秒
    $GLOBALS['cache']->set($month_key, $month_list);//缓存时间 1800秒
    $GLOBALS['cache']->set($all_key, $list);//缓存时间 1800秒
}

/**
 *  主播排行榜定时请求存入缓存
 */
function upd_revenue_ranking()
{
    $day_key = "rank_profit_day";
    $month_key = "rank_profit_month";
    $all_key = "rank_profit_all";
    $table = createPropTable();
    // 当日
    $day_start_time = mktime(0, 0, 0, date('m'), date('d'), date('Y'));

    $sql = "select u.id as user_id,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_ticket) as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from  " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u  on u.id = v.to_user_id
											where u.is_effect=1 and v.create_time>=" . $day_start_time . " and v.is_red_envelope = 0 GROUP BY v.to_user_id
											order BY sum(v.total_ticket) desc limit 0,100";
    $day_list = $GLOBALS['db']->getAll($sql, true, true);
    // 本月
    $month_start_time = mktime(0, 0, 0, date('m'), 1, date('Y'));

    $sql = "select u.id as user_id,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_ticket) as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = v.to_user_id
											where u.is_effect=1 and v.create_time>=" . $month_start_time . " and v.is_red_envelope = 0 GROUP BY v.to_user_id
											order BY sum(v.total_ticket) desc limit 0,100";
    $month_list = $GLOBALS['db']->getAll($sql, true, true);
    // 全部
    $sql = "select u.id as user_id,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,u.ticket as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from " . DB_PREFIX . "user as u
											where u.is_effect=1 and u.ticket>0
											order BY u.ticket desc limit 0,100";
    $list = $GLOBALS['db']->getAll($sql, true, true);

    $GLOBALS['cache']->set($day_key, $day_list);//缓存时间 1800秒
    $GLOBALS['cache']->set($month_key, $month_list);//缓存时间 1800秒
    $GLOBALS['cache']->set($all_key, $list);//缓存时间 1800秒
}

/**
 * 定时修改用户上下线状态
 * @throws \think\Exception
 * @throws \think\db\exception\PDOException
 */
function save_user_online()
{
    require_once APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php';
    require_once APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php';
    require_once APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php';
    require_once APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php';
    $video_viewer_obj = new VideoViewerRedisService();
    $user_redis = new UserRedisService();
    $video_redis = new VideoRedisService();
    $list = $video_viewer_obj->get_user_online();
    foreach ($list as $v) {
        $v = json_decode($v, true);
        // 此处也可以延时操作 - 暂无
        if ($v['is_handle']) {
            $data = array('is_online' => $v['is_online'], 'login_time' => to_date($v['login_time']));
            Db::name("user")->where(" id = " . $v['uid'])->update($data);
            $user_redis->update_db($v['uid'], $data);
        }
        if ($v['video_id']) {
            $video_group = $video_redis->getRow_db($v['video_id'], array('group_id'));
            if ($video_group) {
                $m_config = load_auto_cache("m_config");
                //设置直播间观众列表返回数量
                $page_size = intval($m_config['view_page_size']) > 0 ? intval($m_config['view_page_size']) : 50;
                push_viewer($v['video_id'], $video_group['group_id'], $page_size);
            }
        }
        $video_viewer_obj->del_user_online($v['uid']);
    }
    //  rm_auto_cache("select_video");
}

/**
 * 获得声网token
 * @param $uid         integer 用户ID
 * @param $channelName string 频道名
 * */
function getAgoraToken($uid, $channelName)
{
    bogo_require(APP_ROOT_PATH . 'system/agora/src/RtcTokenBuilder.php');

    $config = load_auto_cache('m_config');

    $appID = $config['agora_app_id'];
    $appCertificate = $config['agora_app_certificate'];

    if (empty($appID) || empty($appCertificate)) {
        return '';
    }

    $role = RtcTokenBuilder::RoleAttendee;
    $expireTimeInSeconds = 3600 * 24 * 30;
    $currentTimestamp = (new DateTime("now", new DateTimeZone('UTC')))->getTimestamp();
    $privilegeExpiredTs = $currentTimestamp + $expireTimeInSeconds;

    $token = RtcTokenBuilder::buildTokenWithUid($appID, $appCertificate, $channelName, $uid, $role, $privilegeExpiredTs);

    return $token;
}

function sendLinkVoiceMicMsg($video_id, $groupId, $linkData = [], $time_out = 0)
{

    //获得连麦观众的列表，最多取最新3个
    $sql = "select user_id,push_rtmp,play_rtmp,channelid,mute_voice from " . DB_PREFIX . "video_lianmai where stop_time = 0 and video_id =" . $video_id . " order by start_time desc limit 3";
    $list = $GLOBALS['db']->getAll($sql, true, true);


    if (count($linkData) == 0) {

        $linkData = [];

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        foreach ($list as $k => $v) {

            $user_data = $user_redis->getRow_db($v['user_id'], array('id', 'nick_name', 'head_image'));
            // 获取麦克风的状态
            $is_open_wheat = $video_redis->has_close_microphone($video_id, $v['user_id']);
            $pushdata = array(
                'user_id'     => $v['user_id'], //'主播ID',
                'nick_name'   => emoji_decode($user_data['nick_name']),//'主播昵称',
                'head_image'  => get_spec_image($user_data['head_image']),
                //'is_open_wheat' => $is_open_wheat ? 0 : 1 // 是否开启了麦克风状态1已开启麦克风0已关闭麦克风
                'mute_status' => $v['mute_voice'],
            );

            $linkData[] = $pushdata;
        }

    }

//    $logger = new Logger('api');
//    $logger->pushHandler(new StreamHandler('./logs/app.log', Logger::DEBUG));
//
//    $logger->info('发送连麦747消息前=======');
//    $logger->info(json_encode($linkData));

    $m_config = load_auto_cache("m_config");//初始化手机端配置

    $ext = array();
    $ext['type'] = 747; //747 im发送当前房间正在连麦人信息
    $ext['data_type'] = 1;//直播间,连麦观众列表
    $ext['data'] = $linkData;

    #构造高级接口所需参数
    $msg_content = array();
    //创建array 所需元素
    $msg_content_elem = array(
        'MsgType'    => 'TIMCustomElem',       //自定义类型
        'MsgContent' => array(
            'Data' => json_encode($ext),
            'Desc' => '',
        )
    );

    //将创建的元素$msg_content_elem, 加入array $msg_content
    array_push($msg_content, $msg_content_elem);;

    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
    $api = createTimAPI();

    //   $logger->info('发送747消息');
    $r = $api->group_send_group_msg2($m_config['tim_identifier'], $groupId, $msg_content, $time_out);

//    $logger->info(json_encode($r));
//
//    $logger->info('发送连麦747消息后=======');
}

/**
 * 退出语音直播
 * @param $video
 * @param $user_id
 */
function do_end_voice($video, $user_id)
{
    $room_id = $video['id'];
    $group_id = $video['group_id'];

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();

    $wheat_logs = db::name('voice_even_wheat_log')->where("user_id=$user_id and video_id=" . $room_id . " and (status=1 or status=0)")->find();
    if ($wheat_logs) {
        //正在连麦的下麦
        $name = array('status' => 3, 'endtime' => NOW_TIME);
        db::name('voice_even_wheat_log')->where("id=" . $wheat_logs['id'])->update($name);
        if ($wheat_logs['status'] == 1) {
            //解除禁言房间缓存
            $video_redis->unset_forbid_speak($group_id, $user_id);
        }
        im_wheat_position_upd($room_id);
    }
    //累计观看次数;累计观看次数明显大于其它用户观看次数时，及有可能是盗连接用户，需要禁用它 -- 并且存入当前进入房间的id
    $sql = "update  " . DB_PREFIX . "user set in_room_id=" . $room_id . " where id = " . $user_id;
    $GLOBALS['db']->query($sql);

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
    $video_viewer_redis = new VideoViewerRedisService();
    $video_viewer_redis->del_voice_one($video['id'], $user_id);
    $watch_number = $video_viewer_redis->get_voice_count($video['id']);

    if (isset($video['is_voice']) && $video['is_voice'] == 1 && $watch_number <= 0) {
        // 房间没有用户执行--定时器执行操作
        redis_zadd("member_exit_list", NOW_TIME, $room_id);
    }

}

// 获取麦位列表
function get_voice_even_wheat_log_list($video_id, $status = '1', $field = "*")
{
    $where = "video_id=" . $video_id;
    $where .= $status == '-1' ? ' and (status=1 or status =0)' : " and status=" . $status;
    return $GLOBALS['db']->getAll("select " . $field . " from " . DB_PREFIX . "voice_even_wheat_log where " . $where . " order by location asc");
}

// 获取语音房间信息
function get_voice_info($room_id, $user_id, $require_type = 0, $is_refresh = 0)
{
    //1：PC端；0：app端
    $require_type = intval($require_type);
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    //获得当前用户和主播的手机资料
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    // 获得当前用户资料
    $user_info = $user_redis->getRow_db($user_id, array('id', 'user_level', 'is_robot', 'is_authentication', 'luck_num', 'mobile', 'is_effect', 'noble_car_id'));
    if ($user_info['is_effect'] == 0) {
        $root = array();
        $root['error'] = api_lang("invalid_account");
        $root['status'] = 0;
        if (!$require_type) {
            ajax_return($root);
        }
    }

    $fields = array('id', 'channelid', 'voice_bg', 'wheat_type', 'create_type', 'head_image', 'cate_id', 'title', 'thumb_head_image', 'sort_num', 'room_type', 'user_id', 'live_in', 'monitor_time', 'max_watch_number', 'online_status', 'video_vid', 'is_del_vod', 'is_delete', 'video_type', 'group_id', 'room_type', 'private_key', 'share_type', 'pai_id', 'begin_time', 'create_time', 'live_pay_time', 'is_live_pay', 'live_pay_type', 'live_fee', 'live_is_mention', 'room_title', 'pay_room_id', 'announcement');

    $m_config = load_auto_cache("m_config");//手机端配置

    $root = $video_redis->getRow_db($room_id, $fields);
    if (!$root || !$root['id'] || $root['live_in'] != 1) {
        $fields = 'id, channelid,voice_bg, create_type, head_image, cate_id, title, thumb_head_image, sort_num, room_type, user_id, live_in, monitor_time, max_watch_number, online_status, video_vid, is_del_vod, is_delete, video_type, group_id, room_type, private_key, share_type, pai_id, begin_time, create_time, live_pay_time, is_live_pay, live_pay_type, live_fee, live_is_mention, room_title, pay_room_id,announcement';
        $root = Db::name("video")->field($fields)->where("id=" . $room_id . " and live_in=1")->find();
        //将mysql数据,同步一份到redis中
        sync_video_to_redis($room_id, '*', false);
        if (!$root) {
            $root = array();
            $root['error'] = api_lang("Room_closed");
            $root['status'] = 0;
            ajax_return($root);
        }
    }

    if ($is_refresh == 0) {
        //累计观看次数;累计观看次数明显大于其它用户观看次数时，及有可能是盗连接用户，需要禁用它 -- 并且存入当前进入房间的id
        $sql = "update  " . DB_PREFIX . "user set view_count = view_count + 1 where id = " . $user_id;
        $GLOBALS['db']->query($sql);
    }

    if ($root['pay_room_id'] === false) {
        $root['pay_room_id'] = 0;
    }

    // 是否是管理员 user_role，1房主，2是管理员，3是普通用户
    $user_role = 1;
    if ($root['user_id'] != $user_id) {
        //判断是否管理员
        $user_admin = Db::name("user_admin")->where(" podcast_id = " . $root['user_id'] . " and user_id =" . $user_id)->find();
        $user_role = $user_admin ? 2 : 3;
        if ($user_role == 2) {
            // 管理员存入缓存
            $video_redis->set_room_administrator($room_id, $user_id, 1);
        }
    } else {
        // 管理员(房主)存入缓存
        $video_redis->set_room_administrator($room_id, $user_id, 2);
    }

    $root['user_role'] = $user_role;
    // 上麦转换
    $wheat_type = json_decode($root['wheat_type'], true);
    $group_id = $root['group_id'];
    //获取上麦人列表
    $even_wheat = get_voice_even_wheat_log_list($room_id);
    // 处理麦位上信息
    foreach ($even_wheat as &$v) {
        // 查询用户已禁言
        $kick_out = $video_redis->has_forbid_msg($group_id, $v['user_id']);
        // 是否禁言1禁言0否
        $v['is_kick_out'] = $kick_out ? 1 : 0;
        // 是否是管理员
        $v['is_admin'] = 0;
        if ($root['user_id'] != $v['user_id']) {
            //判断是否管理员
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $root['user_id'] . " and user_id =" . $v['user_id'])->find();
            $v['is_admin'] = $user_admin ? 1 : 0;
        }

        // 查询用户是否禁止发音
        $ban_voice = $video_redis->has_forbid_speak($group_id, $v['user_id']);
        // 是否禁止发音 1禁0否
        $v['is_ban_voice'] = $ban_voice ? 1 : 0;

        $v['avatar_frame_url'] = '';
        // 头像框
        $avatar_frame = $user_redis->getRow_db($v['user_id'], array('avatar_frame_id'));
        if ($avatar_frame && $avatar_frame['avatar_frame_id']) {
            // 头像框
            $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $avatar_frame['avatar_frame_id']);
        }
        $v['nick_name'] = emoji_decode($v['nick_name']);
    }

    foreach ($wheat_type as &$v) {

        $v['is_wheat'] = 0;
        $v['even_wheat'] = (object)array();
        foreach ($even_wheat as $vw) {
            if ($v['wheat_id'] == $vw['location']) {
                $v['is_wheat'] = 1;
                $v['even_wheat'] = $vw;
            }
        }
    }


    $root['wheat_type_list'] = $wheat_type;

    unset($root['wheat_type']);
    $root['head_image'] = get_spec_image($root['head_image']);
    $root['thumb_head_image'] = get_spec_image($root['thumb_head_image']);

    $filter_false = array(
        'create_type'      => 0,
        'private_key'      => '',
        'group_id'         => '',
        'video_type'       => 0,
        'pai_id'           => 0,
        'max_watch_number' => 0,
        'head_image'       => '',
        'thumb_head_image' => '',
        'sort_num'         => 0,
        'cate_id'          => 0,
        'title'            => '',
        'live_is_mention'  => 0
    );

    filter_false($root, $filter_false);
    $root['room_id'] = $room_id;

    // 房间背景图片
    $root['voice_bg_image'] = '';
    if ($root['voice_bg']) {
        $voice_bg = Db::name('voice_bg')->where("status=1 and id=" . $root['voice_bg'])->find();
        $root['voice_bg_image'] = $voice_bg ? $voice_bg['image'] : '';
    }

    if ($root['id']) {
        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

        $root['room_id'] = $room_id;
        $root['podcast'] = getuserinfo($user_id, $root['user_id'], $root['user_id'], []);

        $root['podcast']['user']['nick_name'] = emoji_decode($root['podcast']['user']['nick_name']);

        $root['luck_num'] = $root['podcast']['user']['luck_num'];
        if (empty($root['room_title'])) {
            $root['room_title'] = $root['podcast']['user']['room_title'];
        }

        $user_level = intval($user_info['user_level']);
        if ($user_level == 0) $user_level = 1;

        $sort_num = $user_level * $user_redis->gz_level_weight;
        if ($user_info['is_robot'] == 0) {
            $sort_num += $user_redis->gz_real_weight;
        }
        if ($user_info['is_authentication'] == 2) {
            $sort_num += $user_redis->gz_rz_weight;
        }
        $root['sort_num'] = $sort_num;
        $root['status'] = 1;

        $redis_key = "member_exit_list";
        redis_zrem($redis_key, $room_id);
        //观众列表
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        $video_viewer_redis = new VideoViewerRedisService();
        $viewer = $video_viewer_redis->get_viewer_list2($room_id);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $fields = array('id', 'fans_count', 'focus_count', 'is_agree', 'video_count', 'is_authentication', 'authentication_type', 'authentication_name', 'nick_name', 'signature', 'sex', 'province', 'city', 'head_image', 'ticket', 'no_ticket', 'refund_ticket', 'use_diamonds', 'diamonds', 'user_level', 'v_type', 'v_explain', 'v_icon', 'is_remind', 'birthday', 'emotional_state', 'job', 'family_id', 'family_chieftain', 'society_id', 'society_chieftain', 'society_settlement_type', 'noble_car_id', 'is_robot', 'room_title', 'luck_num', 'coin', 'is_nospeaking', 'weibo_count', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'is_open_young', 'is_tips', 'tel_code', 'len_time', 'is_vip', 'vip_expire_time', 'avatar_frame_id');

        $lists = $viewer['list'];
        if (count($lists) > 0) {
            $table = createPropTable();
            foreach ($lists as &$v) {
                $noble = $user_redis->getRow_db($v['user_id'], $fields);
                if ($noble['noble_time'] > NOW_TIME) {
                    $v['nobleid'] = $noble['nobleid'];
                    $v['is_noble_ranking_stealth'] = $noble['is_noble_ranking_stealth'];
                    $v['is_noble_mysterious'] = $noble['is_noble_mysterious'];
                } else {
                    $v['nobleid'] = '';
                    $v['is_noble_ranking_stealth'] = 0;
                    $v['is_noble_mysterious'] = 0;
                }

                // 头像框
                $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $noble['avatar_frame_id']);

                //查询今日给此主播的贡献值
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoGiftRedisService.php');
                $video_gift_redis = new VideoGiftRedisService();
                $total_num = $video_gift_redis->getOne_gift_db($table . "_" . $root['room_id'] . "_" . $root['user_id'], $v['user_id']);
                $v['total_num'] = $total_num > 0 ? format_for_ten_thousand($total_num) : 0;

            }
            //二维数组排序
            foreach ($lists as $key => $row) {
                $volume[$key] = $row['total_num']; //要排序的字段
                $edition[$key] = $row['nobleid']; //要排序的字段
            }

            array_multisort($volume, SORT_DESC, $edition, SORT_DESC, $lists);
        }
        $new_viewer = [
            'page'         => $viewer['page'],
            'list'         => $lists,
            'has_next'     => $viewer['has_next'],
            "status"       => $viewer['status'],
            "watch_number" => $viewer['watch_number']
        ];
        $root['viewer'] = $new_viewer;
        $root['viewer_num'] = $viewer['watch_number'];

        if ($is_refresh == 0) {
            //添加观看人数
            $GLOBALS['db']->query("update " . DB_PREFIX . "video set virtual_watch_number = " . $viewer['watch_number'] . " , max_watch_number =  " . $viewer['watch_number'] . " where id = " . $room_id);
        }

        //直播间贵族列表
        $root['noble_sum'] = $video_viewer_redis->get_noble_list_sum($room_id);

        $root['is_private'] = 0;

        //进入房间提示 1、提示进入房间  0、 不提示
        $join_room_remind_limit = intval($m_config['join_room_remind_limit']);
        $root['join_room_prompt'] = 1;
        if ($join_room_remind_limit > 0 && $root['viewer_num'] > $join_room_remind_limit) {
            $root['join_room_prompt'] = 0;
        }
        //进入房间人数上限  join_room_limit
        $join_room_limit = intval($m_config['join_room_limit']);
        if ($join_room_limit > 0 && $root['viewer_num'] >= $join_room_limit && $root['user_id'] != $user_id) {
            $root = array();
            $root['error'] = api_lang("live_reach_upper_limit");
            $root['status'] = 0;
        }
        $root['video_title'] = api_lang("live_broadcast");

        if ($root['live_in'] == 3 && intval($root['is_gather']) != 1) {
            $root['video_title'] = api_lang("back");
        } else if ($root['live_in'] == 3 && intval($root['is_gather']) == 1) {
            $root['video_title'] = api_lang("live_broadcast");
        }

        $share = array();
        $share['share_title'] = strim($m_config['share_title']);//'你丑你先睡,我美我直播!';
        $share['share_imageUrl'] = $root['podcast']['user']['head_image'];
        $share['share_key'] = $root['room_id'];
        $share['share_url'] = strim($m_config['share_address']);//'你丑你先睡,我美我直播!';
        //     $share['share_url'] = HTTP_VUE . APP_ROOT.VUE_URL ."/download?time=" . NOW_TIME;
        //    SITE_DOMAIN . APP_ROOT ."/wap/index.php?ctl=invite_rewards&act=download&user_id=".$root['user_id']."&video_id=".$root['room_id']."&share_id=".$user_id;

        //TODO 分享短连接域名 是否使用t.cn短域名 source正式环境需要自行申请

        $share['share_content'] = $share['share_title'] . $root['podcast']['user']['nick_name'] . api_lang("voice_room_open_Come_watch_together");

        $root['share'] = $share;

        //获取是否是守护者

        $guardian = redis_get("guardian_host_" . $root['user_id'] . "_user_" . $user_id);
        $root['is_guardian'] = $guardian ? 1 : 0;
        $root['is_voice'] = 1;
        //获取房间守护人数
//        $sql = "select count(*) from " . DB_PREFIX . "guardian_user where host_id=" . $root['user_id'] . " and endtime >= " . NOW_TIME . " and status=1";
//        $root['guardian_num'] = intval($GLOBALS['db']->getOne($sql, true, true));
        $root['guardian_num'] = 0;


        //我的座驾
        $root['noble_car_url'] = '';
        $root['noble_car_name'] = '';         //座驾名称
        if ($user_info['noble_car_id'] > 0) {
            $car = redis_get("noble_car_" . $user_info['noble_car_id'] . "_" . $user_id);
            if ($car) {
                $car = json_decode($car, true);
            }
            if ($car) {
                $car_noble = get_noble_one($car['carid']);
                if ($car_noble) {
                    $root['noble_car_url'] = $car_noble['img'];
                    $root['noble_car_name'] = $car_noble['name'];
                }
            } else {
                $sql = "update " . DB_PREFIX . "user set noble_car_id = 0 where id = " . $user_id;
                $GLOBALS['db']->query($sql);
            }
        }
        $root['pk_id'] = 0;
        // 生成声网加入频道的token
        $root['agora_token'] = getAgoraToken($user_id, (string)$room_id);
    } else {
        $root = array();
        $root['error'] = api_lang("no_live_room_found") . $room_id;
        $root['status'] = 0;
    }
    return $root;
}

function get_noble_one($id)
{
    $car_noble = redis_hget("noble_list", $id);
    if ($car_noble) {
        $car_noble = json_decode($car_noble, true);
    } else {
        $sql = "select * from " . DB_PREFIX . "noble where id=" . $id . " and status=1";
        $car_noble = $GLOBALS['db']->getRow($sql, true, true);
        if ($car_noble) {
            redis_hset("noble_list", $id, json_encode($car_noble));
        }
    }
    return $car_noble;
}

/**
 * 用户上下麦变动需要发送im到前端更房间麦位信息
 */
function im_wheat_position_upd($video_id)
{
    // 查询语音房间
    $voice = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "video where id = " . $video_id);

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
    $user_redis = new UserRedisService();
    // 上麦转换
    $wheat_type = json_decode($voice['wheat_type'], true);
    // 获取上麦人列表
    $even_wheat = get_voice_even_wheat_log_list($video_id);
    // 处理麦位上信息
    foreach ($even_wheat as &$v) {
        // 查询用户已禁言
        $kick_out = $video_redis->has_forbid_msg($voice['group_id'], $v['user_id']);
        // 是否禁言1禁言0否
        $v['is_kick_out'] = $kick_out ? 1 : 0;
        // 是否是管理员
        $v['is_admin'] = 0;
        if ($voice['user_id'] != $v['user_id']) {
            //判断是否管理员
            $user_admin = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user_admin where podcast_id = " . $voice['user_id'] . " and user_id =" . $v['user_id']);
            $v['is_admin'] = $user_admin ? 1 : 0;
        }
        $v['avatar_frame_url'] = '';
        // 头像框
        $avatar_frame = $user_redis->getRow_db($v['user_id'], array('avatar_frame_id'));
        if ($avatar_frame && $avatar_frame['avatar_frame_id']) {
            // 头像框
            $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $avatar_frame['avatar_frame_id']);
        }

        // 查询用户是否禁止发音
        $ban_voice = $video_redis->has_forbid_speak($voice['group_id'], $v['user_id']);
        // 是否禁止发音 1禁0否
        $v['is_ban_voice'] = $ban_voice ? 1 : 0;

        $v['nick_name'] = emoji_decode($v['nick_name']);
    }

    foreach ($wheat_type as &$v) {
        $v['is_wheat'] = 0;
        $v['even_wheat'] = (object)array();
        foreach ($even_wheat as $vw) {
            if ($v['wheat_id'] == $vw['location']) {
                $v['is_wheat'] = 1;
                $v['even_wheat'] = $vw;
            }
        }
    }
    $broadMsg['type'] = 745;
    $broadMsg['room_id'] = $voice['id']; // 房间id
    $broadMsg['wheat_type_list'] = $wheat_type;
    #构造rest API请求包
    $msg_content = array();
    //创建$msg_content 所需元素
    $msg_content_elem = array(
        'MsgType'    => 'TIMCustomElem',       //定义类型为普通文本型
        'MsgContent' => array(
            'Data' => json_encode($broadMsg)    //转为JSON字符串
        )
    );

    //将创建的元素$msg_content_elem, 加入array $msg_content
    array_push($msg_content, $msg_content_elem);
    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
    $api = createTimAPI();
    $m_config = load_auto_cache("m_config");
    $ret = $api->group_send_group_msg2($m_config['tim_identifier'], $voice['group_id'], $msg_content);

    return $ret;
}

/**
 * 结束语音直播
 * @param $video
 * @return array|bool|mix|mixed|stdClass|string
 */
function do_close_voice($video)
{
    $user_id = $video['user_id'];
    $room_id = $video['id'];
    $group_id = $video['group_id'];

    $m_config = load_auto_cache("m_config");

    $sql = "update " . DB_PREFIX . "video set live_in = 0,online_status=1,end_time = " . NOW_TIME . ",end_date = '" . to_date(NOW_TIME, 'Y-m-d') . "',is_del_vod = 1,is_delete = 1 where live_in =1 and id = " . $room_id;
    $GLOBALS['db']->query($sql);
    if ($GLOBALS['db']->affected_rows()) {

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();


        $sql = "select * from " . DB_PREFIX . "voice_even_wheat_log where video_id = " . $room_id . " and (status=1 or status=0)";
        $wheat_logs = $GLOBALS['db']->getAll($sql);
        if ($wheat_logs) {
            //正在连麦的下麦
            foreach ($wheat_logs as $v) {
                $sql = "update " . DB_PREFIX . "voice_even_wheat_log set status = 3,end_time = " . NOW_TIME . " where id = " . $v['id'];
                $GLOBALS['db']->query($sql);
                if ($v['status'] == 1) {
                    //解除禁言房间缓存
                    $video_redis->unset_forbid_speak($group_id, $v['user_id']);
                }
            }
        }

        //直播结束时,将redis中计算的数据,同步一份到mysql;
        $fields = array('room_type', 'video_type', 'share_count', 'like_count', 'fans_count', 'sort_num', 'vote_number', 'robot_num', 'watch_number', 'virtual_watch_number', 'max_watch_number', 'channelid', 'prop_table');
        $video_data = $video_redis->getRow_db($room_id, $fields);
        $GLOBALS['db']->autoExecute(DB_PREFIX . "video", $video_data, "UPDATE", "id=" . $room_id);

        $video['vote_number'] = $video_data['vote_number'];
        //开启家族功能
        if (defined('OPEN_FAMILY_MODULE') && intval(OPEN_FAMILY_MODULE) == 1 && intval(OPEN_SOCIETY_MODULE) == 0) {

            family_receipts1($room_id, $user_id, $video);
        }
        $parent_id = 0;

        if ($video_data['video_type'] == 1 && $parent_id == $room_id) {
            //0:腾讯云互动直播;1:腾讯云直播
            bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
            $video_factory = new VideoFactory();
            $video_factory->StopLVBChannel($video_data['channelid']);
        }
        if ((defined('LIVE_END_TO_SCENE') && LIVE_END_TO_SCENE == 1) && intval($video['is_live_pay']) == 1) {
            //按时付费直播结束后转按场付费
            change_pay_type($video);
        }
        //将mysql数据,同步一份到redis中
        sync_video_to_redis($room_id, '*', false);
        if ($group_id != '') {
            //广播：直播结束
            $ext = array();
            $ext['type'] = 7; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束
            $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
            $ext['show_num'] = $video_data['max_watch_number'];//观看人数
            $ext['fonts_color'] = '';//字体颜色
            $ext['desc'] = api_lang("End_live_broadcast");//弹幕消息;
            $ext['desc2'] = api_lang("End_live_broadcast");//弹幕消息;

            //消息发送者
            #构造高级接口所需参数
            $msg_content = array();
            //创建array 所需元素
            $msg_content_elem = array(
                'MsgType'    => 'TIMCustomElem',       //自定义类型
                'MsgContent' => array(
                    'Data' => json_encode($ext),
                    'Desc' => '',
                    //  'Ext' => $ext,
                    //  'Sound' => '',
                )
            );
            //将创建的元素$msg_content_elem, 加入array $msg_content
            array_push($msg_content, $msg_content_elem);

            //发送广播：直播结束
            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();
            $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);

            //=========================================================
            //广播：直播结束
            $ext = array();
            $ext['type'] = 18; //18：直播结束（全体推送的，用于更新用户列表状态）
            $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应

            //18：直播结束（全体推送的，用于更新用户列表状态）
            $api->group_send_group_system_notification($m_config['on_line_group_id'], json_encode($ext), null);
            //=========================================================
            //直播结束解散群组
            $destroy_ret = $api->group_destroy_group($video['group_id']);

            return $ret;
        } else {
            return true;
        }

    } else {
        return false;
    }
}

/**
 * 礼物用户日志 before
 * $type 1礼物2座驾3守护4vip5靓号6贵族7头像框8家族收益9主播提现10兑换
 * 主播提现和兑换都是扣除收益
 */
function add_user_records($uid, $touid, $total_diamonds, $total_ticket, $before_user_diamonds, $before_to_ticket, $voice_id, $prop_id, $content = '', $type = "1")
{

    $to_ticket = 0;
    $user_diamonds = 0;
    if ($touid) {
        $to_ticket = intval($GLOBALS['db']->getOne("select ticket from " . DB_PREFIX . "user where id=" . $touid));
    }
    if ($uid) {
        $user_diamonds = intval($GLOBALS['db']->getOne("select diamonds from " . DB_PREFIX . "user where id=" . $uid));
    }
    $add = array(
        'uid'                  => $uid,
        'to_uid'               => $touid,
        'total_diamonds'       => $total_diamonds,
        'total_ticket'         => $total_ticket,
        'voice_id'             => $voice_id,
        'prop_id'              => $prop_id,
        'content'              => $content,
        'before_user_diamonds' => $before_user_diamonds,
        'before_to_ticket'     => $before_to_ticket,
        'user_diamonds'        => $user_diamonds,
        'to_ticket'            => $to_ticket,
        'create_time'          => NOW_TIME,
        'type'                 => $type,
        'status'               => $type == 9 ? 0 : 1
    );
    $GLOBALS['db']->autoExecute(DB_PREFIX . "user_records", $add, "INSERT");
}

/**
 * 增加每日时长
 * type 1直播时长 2语音时长 3 收益
 *
 */
function insert_duration($date, $uid, $type, $sum)
{

    $where = "uid=" . $uid . " and date_y='" . $date['date_y'] . "' and date_m='" . $date['date_m'] . "' and date_d='" . $date['date_d'] . "'";
    $user_duration = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user_duration WHERE " . $where);
    switch ($type) {
        case 1:
            $name = "live_duration"; // 直播时长
            break;
        case 2:
            $name = "voice_duration"; // 语音时长
            break;
        default:
            $name = "earnings"; // 收益
    }

    $m_config = load_auto_cache("m_config");
    if ($user_duration) {
        if ($type != 3) {
            if ($m_config['effective_duration_voice_computing'] == 1) {
                // 语音房间 + 直播房间时长
                $user_duration_time = intval($user_duration['live_duration']) + intval($user_duration['voice_duration']) + $sum;
            } else {
                // 直播房间时长
                $user_duration_time = intval($user_duration['live_duration']);
                if ($type == 1) {
                    $user_duration_time = $user_duration_time + $sum;
                }
            }
            if ($user_duration_time >= 60 * 60 * intval($m_config['effective_days'])) {
                $sql = "update " . DB_PREFIX . "user_duration set day_effective = 1 where " . $where;
                $GLOBALS['db']->query($sql);
            }
        }
        // 累计
        $sql = "update  " . DB_PREFIX . "user_duration set $name = $name + $sum where " . $where;
        $GLOBALS['db']->query($sql);
    } else {
        $day_effective = 0;
        if (($type == 2 && $m_config['effective_duration_voice_computing'] == 1) || $type == 1) {
            // 语音房间 + 直播房间时长
            $day_effective = $sum >= 60 * 60 * intval($m_config['effective_days']) ? 1 : 0;
        }
        // 新增
        $add = array(
            'uid'           => $uid,
            'date_y'        => $date['date_y'],
            'date_m'        => $date['date_m'],
            'date_d'        => $date['date_d'],
            'date_type'     => $date['date_type'],
            'create_time'   => NOW_TIME,
            'day_effective' => $day_effective,
            $name           => $sum
        );
        $GLOBALS['db']->autoExecute(DB_PREFIX . "user_duration", $add, "INSERT");
    }

}

/**
 * 主播心跳-每分钟执行一次
 *  增加主播任务奖励--等待主播领取
 * uid 主播id
 * begin_time 时长统计开始时间
 * 如果今天不是第一次奖励的；需要更新开始时间(查询上次奖励的时间)
 * */
function add_host_mission($uid, $begin_time, $room_id = 0)
{
    $date = date('Y-m-d');
    $insert = [];
    $live_duration_key = "mission_calculate_time_" . $date . "_" . $room_id; // 任务计算开始时间
    $live_duration_time = intval(redis_get($live_duration_key)); // 获取计算的开始时间--时间戳
    if ($live_duration_time) {
        $begin_time = $live_duration_time;
    }
    $time = NOW_TIME;
    $live_duration_sum = floor(($time - $begin_time) / 60); // 当前直播时长
    $current_at = date('Y-m-d H:i:s'); // 当前时间
    // 关闭未领取的记录
    $sql = "select * from " . DB_PREFIX . "reward_record where status=0 and expire_at < " . $current_at . " order by expire_at asc";
    $list = $GLOBALS['db']->getAll($sql);
    foreach ($list as $vr) {
        $GLOBALS['db']->autoExecute(DB_PREFIX . "reward_record", ['status' => 2, 'claimed_at' => $current_at], "UPDATE", "id =" . $vr['id']);
        $key = "mission_reward_record_" . $date . "_" . $vr['anchor_id'] . "_" . intval($vr['reward_config_id']);
        $is_insert = json_decode(redis_get($key), true);
        if ($is_insert) {
            $is_insert['status'] = 2;
            redis_set($key, json_encode($is_insert), 60 * 60 * 24);
        }
    }

    $key = "mission_reward_record_" . $date . "_" . $uid . "_";

    $host_mission_list = host_mission_list(); // 任务列表

    $expire_duration = $time + 60 * 10; // 过期时间
    $unclaimed_mission = [];
    foreach ($host_mission_list as $v) {
        $duration_key = $key . $v['id'];
        $is_insert = json_decode(redis_get($duration_key), true);
        if ($is_insert) {
            $unclaimed_mission = $is_insert;
        }
        if ($v['duration'] > 0 && $v['duration'] <= $live_duration_sum && intval($v['money']) > 0 && !$is_insert) {
            // 存入待领取记录
            $insert = array(
                'anchor_id'        => $uid,
                'reward_config_id' => $v['id'],
                'reward_duration'  => $live_duration_sum,
                'reward_amount'    => intval($v['money']),
                'live_record_id'   => $room_id,
                'status'           => 0,
                'created_at'       => $current_at,
                'expire_at'        => date('Y-m-d H:i:s', $expire_duration)
            );
            //将礼物写入mysql表中
            $GLOBALS['db']->autoExecute(DB_PREFIX . "reward_record", $insert, "INSERT");//插入数据
            $insert['id'] = $GLOBALS['db']->insert_id(); // 获取自增 ID
            // 把领取的记录存入缓存
            redis_set($duration_key, json_encode($insert), 60 * 60 * 24);
            $begin_time = $time;
            break;
        }
    }

    // 更新过期状态。
    redis_set($live_duration_key, $begin_time, 60 * 60 * 24);
    if (count($insert) <= 0) {
        if ($unclaimed_mission && $unclaimed_mission['status'] == 0 && $unclaimed_mission['expire_at'] > date('Y-m-d H:i:s')) {
            // 获取未领取的奖励
            $insert = $unclaimed_mission;
        }
    }
    return $insert;
}

/**
 * 主播任务奖励列表
 * */
function host_mission_list()
{
    $key = 'host_mission_list';
    $list = json_decode(redis_get($key), true);
    if (!$list) {
        $sql = "select * from " . DB_PREFIX . "host_mission where status = 1 order by duration asc,id asc";
        $list = $GLOBALS['db']->getAll($sql);
        if ($list) {
            redis_set($key, json_encode($list), 0);
        }
    }
    return $list;
}

/**
 * 直播间每日时长累计处理
 * 视频直播关闭房间不是马上计算，是定时器执行结束直播的；大约5-6分钟
 */
function live_duration($video)
{
    //  add_file_log("\n ================直播间时长信息：" . json_encode($video) . "================\n", 'live_duration');
    // 获取开始时间 数组格式
    $start_date = get_date_time($video['begin_time']);
    // 获取结束时间 数组格式
    $video['end_time'] = $video['end_time'] ? $video['end_time'] : NOW_TIME;
    $end_date = get_date_time($video['end_time']);
    $len_time = $video['end_time'] - $video['begin_time'];
    if ($start_date['date_y'] != $end_date['date_y'] || $start_date['date_m'] != $end_date['date_m'] || $start_date['date_d'] != $end_date['date_d']) {

        // 不是同一天---处理前一天时长
        // 获取当天开始时间戳（北京时间的8:00）
//        $startTimestamp = strtotime(date('Y-m-d 08:00:00', $video['end_time']));
        $startTimestamp = strtotime(date('Y-m-d', $video['end_time']));
        $begin_len_time = $startTimestamp - $video['begin_time'];
        // 增加前一天时长
        insert_duration($start_date, $video['user_id'], 1, $begin_len_time);
        $len_time = $video['begin_time'] - $startTimestamp;

    }
//    add_file_log("\n ================直播间时长：" . json_encode($end_date) . "======" . $len_time . "=========\n", 'live_duration');
    // 增加时长
    insert_duration($end_date, $video['user_id'], 1, $len_time);
}

/**
 * 判断用户是否登录封禁 type = 1封禁IP 2设备 3邮箱登陆 4facebookID 5手机号 6谷歌登录 7苹果登录
 * */
function disableSel($disable_value, $type)
{
    // 获取当前用户的ip
    $ip = get_client_ip();
    // 获取当前用户的设备号
    $device_id = trim($_REQUEST['device_id']);
    $where = "status=1 and end_time >=" . NOW_TIME;
    $disable_login_one = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "disable_login WHERE " . $where . " and type=" . $type . " and disable_value='" . $disable_value . "'");
    if (!$disable_login_one) {
        $disable_login_one = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "disable_login WHERE " . $where . " and (disable_value='" . $ip . "' or disable_value='" . $device_id . "')");
    }
    if ($disable_login_one) {
        $root['status'] = 0;
        switch ($disable_login_one['type']) {
            case 1:
                $root['error'] = 'IP ' . api_lang("Account_disabled");
                break;
            case 2:
                $root['error'] = api_lang("device") . api_lang("Account_disabled");
                break;
            case 3:
                $root['error'] = api_lang("mailbox") . api_lang("Account_disabled");
                break;
            case 4:
                $root['error'] = 'facebook ' . api_lang("Account_disabled");
                break;
            case 6:
                $root['error'] = 'google ' . api_lang("Account_disabled");
                break;
            case 7:
                $root['error'] = 'apple ' . api_lang("Account_disabled");
                break;
            default:
                $root['error'] = api_lang("Account_disabled");
        }
        ajax_return($root);
    }
    return false;
}

function get_guardian_classification_one($id)
{
    $key = "guardian_classification_list";
    $guardian_classification = redis_hget($key, $id);
    if (!$guardian_classification) {
        $sql = "select * from " . DB_PREFIX . "guardian_classification order by sort desc";
        $guardian = $GLOBALS['db']->getAll($sql);
        foreach ($guardian as &$v) {
            redis_hset($key, $v['id'], json_encode($v));
            if ($v['id'] == $id) {
                $guardian_classification = $v;
            }
        }
    } else {
        $guardian_classification = json_decode($guardian_classification, true);
    }
    if (!$guardian_classification) {
        $guardian_classification = array(
            'id'                 => '',
            'name'               => '',
            'img_bg'             => '',
            'img_identification' => '',
            'img'                => '',
            'privilege'          => '',
        );
    }
    return $guardian_classification;
}

function get_guardian_type_one($id)
{
    $key = "guardian_type_one";
    $guardian_type = redis_hget($key, $id);
    if (!$guardian_type) {
        $sql = "select * from " . DB_PREFIX . "guardian_type order by sort desc";
        $type_list = $GLOBALS['db']->getAll($sql);
        foreach ($type_list as &$v) {
            redis_hset($key, $v['id'], json_encode($v));
            if ($v['id'] == $id) {
                $guardian_type = $v;
            }
        }
    } else {
        $guardian_type = json_decode($guardian_type, true);
    }
    return $guardian_type;
}

function redis_set($key, $value, $expire = 0)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    $RedisService->set($key, $value, $expire);
}

function redis_get($key)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->get($key);
}

function redis_rm($key)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    $RedisService->delete($key);
}

function redis_hset($key, $name, $value)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->hSet($key, $name, $value);
}

function redis_hget($key, $name)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->hGet($key, $name);
}

function redis_hdel($key, $name)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->hDelOne($key, $name);
}

/**
 * 插入队列
 * */
function redis_lPush($key, $value)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->lPush($key, $value);
}

/**
 * 读取队列
 * */
function redis_lPop($key)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->lPop($key);
}

/**
 * $score1排名分数
 * */
function redis_zadd($key, $score1, $name)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->zAdd($key, $score1, $name);
}

/**
 * $score1移出
 * */
function redis_zrem($key, $name)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->zRem($key, $name);
}

/**
 * $score1排名分数 --列表
 * */
function redis_zRevRange($key, $start, $end, $withscores = null)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->zRevRange($key, $start, $end, $withscores);
}

/**
 * $score1排名分数 --列表
 * */
function redis_zIncrBy($key, $member, $name)
{
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/RedisService.php');
    $RedisService = new RedisService();
    return $RedisService->zIncrBy($key, $member, $name);
}

/**
 * json_decode处理
 * */
function get_redis_array($key)
{
    $video_pk = redis_get($key);
    if ($video_pk) {
        $video_pk = json_decode($video_pk, true);
    } else {
        $video_pk = "";
    }
    return $video_pk;
}

/**
 * 通过ip获取国家  https://ipinfo.io/
 * */
function getIPInfoIO()
{
    $m_config = load_auto_cache("m_config");
  //  $m_config['ipinfo_token'] = 'bcd9f16802e99b';

    $ip = get_client_ip();
    $url = "https://ipinfo.io/" . $ip . "?token=" . $m_config['ipinfo_token'];
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    $return_str = curl_exec($curl);
    //   $re = curl_error($curl);
    curl_close($curl);

    // 解码JSON响应
    $details = json_decode($return_str, true);
    return $details;
}

/**
 * 定时器：增加私信记录 添加聊天记录
 * */
function add_chat_log()
{
    $data = [];
    for ($i = 1; $i <= 10; $i++) {
        $chat_log_array = json_decode(redis_lPop("chat_log_redis_lPush"), true);
        if ($chat_log_array) {
            $to_user_name = $GLOBALS['db']->getOne("select nick_name from " . DB_PREFIX . "user where id = " . intval($chat_log_array['to_user_id']), true, true);
            $user_name = $GLOBALS['db']->getOne("select nick_name from " . DB_PREFIX . "user where id = " . intval($chat_log_array['user_id']), true, true);
            $table = createChatRecordTable();// 获取当月的实现记录表
            $sql = "insert into " . $table . "(user_id,to_user_id,user_nickname,to_user_nickname,type,content,create_time,format_time,msg_key) values('" . intval($chat_log_array['user_id']) . "','" . intval($chat_log_array['to_user_id']) . "','" . $to_user_name . "','" . $user_name . "','" . intval($chat_log_array['type']) . "','" . $chat_log_array['content'] . "','" . $chat_log_array['create_time'] . "','" . $chat_log_array['format_time'] . "','" . $chat_log_array['msg_key'] . "')";
            //  add_file_log("\n ================MsgType:sql================\n".$sql, "imcallback");
            $GLOBALS['db']->query($sql);
        }
        $data[] = $chat_log_array;
    }
    return $data;
}
/**
* 通过ip获取国家  https://ipinfo.io/
 * **/
function getCountryCode($uid){
    $ipInfo = getIPInfoIO();
    if ($ipInfo && isset($ipInfo['country'])) {
        $sys_config = require APP_ROOT_PATH . 'public/countries.json';
    }
}
/**
 * 通过ip获取国家  https://ipinfo.io/
 * https://ipinfo.io/103.153.130.166?token=187f909d0af15b
 *返回国家code
 * */
function get_country_ipinfo()
{
    $m_config = load_auto_cache("m_config");
    $ip = get_client_ip();
    $ipinfo_token = $m_config['ipinfo_token'];
    $url = "https://ipinfo.io/" . $ip . "?token=" . $ipinfo_token;
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HEADER, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    $return_str = curl_exec($curl);
    curl_close($curl);
    $country_code = 0;
    try {
        // 解码JSON响应
        $details = json_decode($return_str, true);
        // 加载国家代码映射
        $countriesFile = APP_ROOT_PATH . "public/countries.json";
        $file = file_get_contents($countriesFile);
        $countries = json_decode($file, true);
        foreach ($countries as $v) {
            if ($details['country'] == $v['alpha_2_code']) {
                $country_code = $v['num_code'];
                break;
            }
        }
    } catch (\Exception $e) {
        return 0;
    }

    return $country_code;
}
/**
* 获取国旗
 * */
function get_country_flag($country_code){
    $country_flag = false;
    if ($country_code) {
        $key="country_flag_list";
        $country_flag = redis_hget($key,$country_code);
        $country_flag = false;
        if (!$country_flag){
            // 加载国家代码映射
            $countriesFile = APP_ROOT_PATH . "public/countries.json";
            $file = file_get_contents($countriesFile);
            $countries = json_decode($file, true);
            foreach ($countries as $v) {
                redis_hset($key, $v['num_code'], $v);
                if($v['num_code']==$country_code){
                    $country_flag = $v;
                }
            }
        }
    }
    return array(
        'num_code' => $country_flag ? $country_flag['num_code']: '',
        'alpha_2_code' => $country_flag ? $country_flag['alpha_2_code']: '',
        'alpha_3_code' => $country_flag ? $country_flag['alpha_3_code']: '',
        'en_short_name' => $country_flag ? $country_flag['en_short_name']: '',
        'nationality' => $country_flag ? $country_flag['nationality']: '',
        'country_img' => $country_flag ? get_domain().'/public/images/flag/'.$country_flag['alpha_2_code'].'.png': '',
    );
}

/**
 * 获取国家列表
 * $hot 1热门0不是热门
 * */
function get_country_list(){
    $keys="country_seach_list";
    $hot_country = redis_get($keys);
    if(!$hot_country){
        $hot_country = Db::name('country')->field("id,name,img,num_code")->where("status=1 and is_seach=1")->order("sort desc")->select();
        redis_set($keys,json_encode($hot_country));
    }else{
        $hot_country = json_decode($hot_country,true);
    }
    return $hot_country;
}
/**
 * 获取热门国家列表
 * */
function get_hot_country_list(){
    $keys="country_hot_list";
    $keys_id="country_hot_id";
    $hot_country = redis_get($keys);
    $hot_country = false;
    if(!$hot_country){
        $hot_country = Db::name('hot_country_groups')->field("id,group_name,country_codes as num_code")->order("sort desc")->select();

        foreach ($hot_country as &$v){
            $country_codes_list = explode(',', $v['num_code']);
            $country_img=[];
            if(count($country_codes_list)){
                foreach ($country_codes_list as $vs){
                    $country_codes_imgs = Db::name('country')->where("num_code",$vs)->find();
                    if($country_codes_imgs){
                        $country_img[]=$country_codes_imgs['img'];
                    }
                }
            }
            $v['country_imgs']=$country_img;
            redis_hset($keys_id,$v['id'],json_encode($v));
        }
        redis_set($keys,json_encode($hot_country));
    }else{
        $hot_country = json_decode($hot_country,true);
    }
    foreach ($hot_country as &$v){
        $v['num_code_text'] = $v['num_code'];
        $v['num_code'] = intval($v['id']) * 10000;
    }
    return $hot_country;
}
/**
* 获取后台配置的国家信息
 * type 1国家列表 2 国家的提现概率
 *country_code 国家code(type=2时传参)
 * */
function get_country_config($type=1,$country_code=0){
    $key = "country_list";
    $key_ratio="country_code_ratio";
    $country = json_decode(redis_get($key), true);
    if (!$country) {
        $sql = "SELECT * FROM " . DB_PREFIX . "country where status = 1 order by sort desc";
        $country = $GLOBALS['db']->getAll($sql, true, true);
        if ($country) {
            foreach ($country as $k => $v) {
                redis_hset($key_ratio, $v['num_code'], $v['ticket_catty_ratio']);
            }
            redis_set($key, json_encode($country));
        }
    }
    if($type == 1){
        return $country;
    }else{
        $country_code_ratio = 0;
        if ($country_code){
            $key_ratio="country_code_ratio";
            $ratio_one = redis_hget($key_ratio, $country_code);
            if($ratio_one){
                $country_code_ratio =floatval($ratio_one);
            }
        }
        return $country_code_ratio > 0 ? $country_code_ratio : 0;
    }
}
/**
 * 获取说话技能：语言列表
 * type 1:语言分类 2:语言
 * */
function get_languages_list(){
    $lang= [];
    $lang[]=array(
        'id'=> 1,
        'code'=>'en',
        'name'=> api_lang('english')
    );
    $lang[]=array(
        'id'=> 2,
        'code'=>'hi',
        'name'=>api_lang('hindi')
    );
    $lang[]=array(
        'id'=> 3,
        'code'=>'tr',
        'name'=>api_lang('turkish')
    );
    $lang[]=array(
        'id'=> 4,
        'code'=>'es',
        'name'=>api_lang('spanish')
    );
    $lang[]=array(
        'id'=> 5,
        'code'=>'pt',
        'name'=>api_lang('portuguese')
    );
    $lang[]=array(
        'id'=> 6,
        'code'=>'nl',
        'name'=>api_lang('dutch')
    );
    return $lang;
}

