<?php

/**
 * monitor check voice room user status, if don't exist in room then delete it
 * */
function do_check_voice_room_user_status()
{
    $db = $GLOBALS['db'];

    // 获取当前时间
    $current_time = time();
    // 计算5分钟前的日期时间格式
    $timeout_date = date('Y-m-d H:i:s', $current_time - 5 * 60);

    // 限制每次处理的记录数量，避免一次处理过多数据
    $limit = 20;

    // 查询超过5分钟没有心跳的记录，并限制数量
    $sql = "SELECT * FROM " . DB_PREFIX . "voice_even_wheat_log WHERE status = 1 AND monitor_time < '{$timeout_date}' LIMIT {$limit}";
    $timeout_records = $db->getAll($sql);

    if (empty($timeout_records)) {
        return true;
    }

    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
    $video_redis = new VideoRedisService();

    foreach ($timeout_records as $record) {
        $room_id = $record['video_id'];
        $user_id = $record['user_id'];
        $wheat_position = $record['location'];

        $video = $video_redis->getRow_db($room_id, array('channelid', 'group_id', 'user_id', 'video_type', 'play_rtmp', 'push_rtmp'));
        if ($video && $video['user_id'] == $user_id) {
            // 如果是房主不需要处理，房主有自己的心跳逻辑
            continue;
        }

        // 用户下麦处理
        $update_wheat_data = array('status' => 3, 'endtime' => NOW_TIME);
        // 操作修改
        $db->autoExecute(DB_PREFIX . "voice_even_wheat_log", $update_wheat_data, "UPDATE", "id=" . $record['id']);

        // 记录日志
        $log_message = "User {$user_id} automatically removed from wheat position {$wheat_position} in room {$room_id} due to timeout";
        add_file_log($log_message, 'voice_room_timeout');

        // 发送IM消息通知房间内其他用户
        im_wheat_position_upd($room_id);
    }

    return true;
}

/**
 * 从麦位上移除用户
 * @param int $room_id        房间ID
 * @param int $user_id        用户ID
 * @param int $wheat_position 麦位
 * @return bool 操作结果
 */
function remove_user_from_wheat_position($room_id, $user_id, $wheat_position)
{
    // 实现移除麦位的逻辑
    // 这里需要根据您的业务逻辑来实现具体的移除操作

    return true;
}

/**
 * 发送麦位超时通知
 * @param int $room_id        房间ID
 * @param int $user_id        用户ID
 * @param int $wheat_position 麦位
 * @return bool 操作结果
 */
function send_wheat_timeout_notification($room_id, $user_id, $wheat_position)
{
    // 实现发送通知的逻辑
    // 这里需要根据您的业务逻辑来实现具体的通知操作

    return true;
}