<?php

/**
 * 获取单个字段值
 * @param $dbTableName string 表名
 * @param $fieldName   string 字段名
 * @param $where       array 查询条件，键对值组合
 * @param $order       array 排序条件，键对值组合
 * @param $orderType   string 升序降序 desc asc
 * */
function dbGetOneFiled($dbTableName, $fieldName, $where, $order = [], $orderType = '')
{

    $whereSql = getDbWhereSql($where);

    $sql = "select $fieldName from " . DB_PREFIX . "$dbTableName where $whereSql";

    // 有排序需求拼接排序sql
    $sql = getDbOrderSql($sql, $order, $orderType);
    //echo $sql;exit;
    return $GLOBALS['db']->getOne($sql);
}

/**
 * 获取一行数据
 * */
function dbGetRow($dbTableName, $aliasName, $join, $field = [], $where = [], $order = [], $orderType = '')
{
    $joinSql = getDbJoinSql($join);

    $fieldSql = getDbFieldSql($field);

    $whereSql = getDbWhereSql($where);

    $sql = "select $fieldSql from " . DB_PREFIX . $dbTableName;

    if (!empty($aliasName)) {
        $sql .= ' as ' . $aliasName;
    }

    $sql .= " $joinSql where " . $whereSql;
    // 有排序需求拼接排序sql
    $sql = getDbOrderSql($sql, $order, $orderType);
    return $GLOBALS['db']->getRow($sql);
}

/**
 * 查询数据列表
 * @param $dbTableName string 表名
 * @param $aliasName   string 别名
 * @param $join        array 链接表sql 格式：[['type' => 'left', 'table_name' => 'abc', 'alias' => 'a', 'on' => 'a.id=b.id']];
 * @param $isRow       boolean 是否是单行数据
 * @param $where       array 查询条件，键对值组合
 * @param $order       array 排序条件，键对值组合
 * @param $orderType   string 升序降序 desc asc
 * */
function dbGetAll($dbTableName, $aliasName, $join, $isRow, $field = [], $where = [], $order = [], $orderType = '', $limit = '')
{
    $joinSql = getDbJoinSql($join);

    $fieldSql = getDbFieldSql($field);

    $whereSql = getDbWhereSql($where);

    $sql = "select $fieldSql from " . DB_PREFIX . $dbTableName;

    if (!empty($aliasName)) {
        $sql .= ' as ' . $aliasName;
    }

    $sql .= " $joinSql where " . $whereSql;

    // 有排序需求拼接排序sql
    $sql = getDbOrderSql($sql, $order, $orderType);

    if ($isRow) {
        return $GLOBALS['db']->getRow($sql);
    } else {

        if (!empty($limit)) {
            $sql .= ' limit ' . $limit;
        }
        //echo $sql;exit;
        return $GLOBALS['db']->getALL($sql);
    }
}

/**
 * 更新数据
 * @param $dbTableName string 表名
 * @param $where       array 查询条件
 * @param $updateData  array|string 更新数据
 * */
function dbUpdate($dbTableName, $where, $updateData)
{
    $whereSql = getDbWhereSql($where);

    if (is_array($updateData)) {
        $setSql = getDbSetSql($updateData);
    } else {
        $setSql = $updateData;
    }

    $sql = "update " . DB_PREFIX . $dbTableName . " set " . $setSql . " where " . $whereSql;

    return $GLOBALS['db']->query($sql);
}

/**
 * 删除数据
 * */
function dbDelete($dbTableName, $where)
{
    $whereSql = '';

    $i = 0;
    foreach ($where as $k => $v) {
        $whereSql .= $k . '=' . $v;

        //  如果不是最后一个后面加and
        if ($i != count($where) - 1) {
            $whereSql .= ' and';
        }

        $i++;
    }

    $sql = "delete from " . DB_PREFIX . $dbTableName . " where " . $whereSql;
    return $GLOBALS['db']->query($sql);
}

/**
 * 插入数据
 * @param $dbTableName string 数据表
 * @param $data        array 要插入的数据
 * @param $getInsertId boolean 是否需要ID
 * */
function dbInsert($dbTableName, $data, $getInsertId = false)
{
    $result = $GLOBALS['db']->autoExecute(DB_PREFIX . $dbTableName, $data, "INSERT");
    if ($getInsertId) {
        return $GLOBALS['db']->insert_id();
    } else {
        return $result;
    }
}

function getDbJoinSql($join)
{
    $joinSql = '';

    //[['type' => 'left', 'table_name' => 'abc', 'alias' => 'a', 'on' => 'a.id=b.id']];

    if (is_array($join) && count($join) != 0) {
        foreach ($join as $v) {
            $joinSql .= $v['type'] . ' join ' . DB_PREFIX . $v['table_name'] . ' as ' . $v['alias'] . ' on ' . $v['on'];
        }
    }

    return $joinSql;

}


/**
 * 拼接db where参数，返回字符串
 * @return string 拼接好的where段sql语句，注意不是完整的sql
 * */
function getDbWhereSql($where)
{
    $whereSql = '';

    // 查询条件组合
    $i = 0;
    foreach ($where as $k => $v) {

        if (is_array($v)) {
            $whereSql .= $k . $v[0] . $v[1];
        } else {
            $whereSql .= $k . '=' . $v;
        }

        //  如果不是最后一个后面加and
        if ($i != count($where) - 1) {
            $whereSql .= ' and ';
        }

        $i++;
    }

    return $whereSql;

}

/**
 * 拼接db set参数，返回字符串
 * @return string 拼接好的set段sql语句，注意不是完整的sql
 * */
function getDbSetSql($data)
{
    $setSql = '';

    $j = 0;
    foreach ($data as $k => $v) {
        $setSql .= $k . ' = ' . $v;

        //  如果不是最后一个后面加,
        if ($j != count($data) - 1) {
            $setSql .= ',';
        }

        $j++;
    }

    return $setSql;
}


/**
 * 拼接db order参数，返回字符串
 * @return string 拼接好的sql语句
 * */
function getDbOrderSql($sql, $order, $orderType)
{
    if (is_array($order) && count($order) != 0) {

        $orderSql = '';

        // 排序参数组合sql
        $j = 0;
        foreach ($order as $k => $v) {
            $orderSql .= $v;
            //  如果不是最后一个后面加,
            if ($j != count($order) - 1) {
                $orderSql .= ',';
            }

            $j++;
        }

        // 排序方式
        if (!empty($orderSql) && !empty($orderType)) {
            $orderSql .= ' ' . $orderType;
        }

        $sql .= ' order by ' . $orderSql;
    }

    return $sql;

}


/**
 * 拼接sql 字段
 * @param mixed $field
 * @param array $order
 */
function getDbFieldSql($field = [])
{
    $fieldSql = '*';

    if (is_array($field) && count($field) != 0) {
        $fieldSql = '';

        $i = 0;
        foreach ($field as $v) {
            //  如果不是最后一个后面加,
            $fieldSql .= $v;
            if ($i != count($field) - 1) {
                $fieldSql .= ',';
            }
            $i++;
        }
    }

    return $fieldSql;
}