<?php
/*ajax返回*/
function api_ajax_return($data, $is_debug = false)
{
    //$user_info = app_login();
    //$data['user_info'] = $user_info;
    if (!$is_debug) {
        header("Content-Type:text/html; charset=utf-8");
        header('Cache-Control: no-cache, no-store, max-age=0, must-revalidate');
        //echo(json_encode($data));
        $encrypt = $GLOBALS['encrypt'];
        if ($encrypt['i_type']) {
            ajax_return_aes($data, 4);
        } else {
            echo(json_encode($data, JSON_UNESCAPED_SLASHES));
        }
        exit;
    } else {
        var_export($data);
        echo "<br />";
        exit;
    }
}

function filter_ma_request_mapi(&$str)
{
    $search = array("../", "\n", "\r", "\t", "\r\n", "'", "<", ">", "\"", "%", "\\", ".", "/");
    return str_replace($search, "", $str);
}

function strim_mapi($str)
{
    return quotes_mapi(htmlspecialchars(trim($str)));
}

function quotes_mapi($content)
{
    //if $content is an array
    if (is_array($content)) {
        foreach ($content as $key => $value) {
            //$content[$key] = mysql_real_escape_string($value);
            $content[$key] = addslashes($value);
        }
    } else {
        //if $content is not an array
        //$content=mysql_real_escape_string($content);
        $content = addslashes($content);
    }
    return $content;
}

/**
 * 获取和设置配置参数 支持批量定义
 * @param string|array $name    配置变量
 * @param mixed        $value   配置值
 * @param mixed        $default 默认值
 * @return mixed
 */
function C($name = null, $value = null, $default = null)
{
    static $_config = array();
    // 无参数时获取所有
    if (empty($name)) {
        return $_config;
    }
    // 优先执行设置获取或赋值
    if (is_string($name)) {
        if (!strpos($name, '.')) {
            $name = strtoupper($name);
            if (is_null($value)) {
                return isset($_config[$name]) ? $_config[$name] : $default;
            }
            $_config[$name] = $value;
            return null;
        }
        // 二维数组设置和获取支持
        $name = explode('.', $name);
        $name[0] = strtoupper($name[0]);
        if (is_null($value)) {
            return isset($_config[$name[0]][$name[1]]) ? $_config[$name[0]][$name[1]] : $default;
        }
        $_config[$name[0]][$name[1]] = $value;
        return null;
    }
    // 批量设置
    if (is_array($name)) {
        $_config = array_merge($_config, array_change_key_case($name, CASE_UPPER));
        return null;
    }
    return null; // 避免非法参数
}


/**
 * 获取输入参数 支持过滤和默认值
 * 使用方法:
 * <code>
 * I('id',0); 获取id参数 自动判断get或者post
 * I('post.name','','htmlspecialchars'); 获取$_POST['name']
 * I('get.'); 获取$_GET
 * </code>
 * @param string $name    变量的名称 支持指定类型
 * @param mixed  $default 不存在的时候默认值
 * @param mixed  $filter  参数过滤方法
 * @param mixed  $datas   要获取的额外数据源
 * @return mixed
 */
function I($name, $default = '', $filter = null, $datas = null)
{
    static $_PUT = null;
    if (strpos($name, '/')) {
        // 指定修饰符
        list($name, $type) = explode('/', $name, 2);
    } elseif (C('VAR_AUTO_STRING')) {
        // 默认强制转换为字符串
        $type = 's';
    }
    if (strpos($name, '.')) {
        // 指定参数来源
        list($method, $name) = explode('.', $name, 2);
    } else {
        // 默认为自动判断
        $method = 'param';
    }
    switch (strtolower($method)) {
        case 'get':
            $input = &$_GET;
            break;
        case 'post':
            $input = &$_POST;
            break;
        case 'put':
            if (is_null($_PUT)) {
                parse_str(file_get_contents('php://input'), $_PUT);
            }
            $input = $_PUT;
            break;
        case 'param':
            switch ($_SERVER['REQUEST_METHOD']) {
                case 'POST':
                    $input = $_POST;
                    break;
                case 'PUT':
                    if (is_null($_PUT)) {
                        parse_str(file_get_contents('php://input'), $_PUT);
                    }
                    $input = $_PUT;
                    break;
                default:
                    $input = $_GET;
            }
            break;
        case 'path':
            $input = array();
            if (!empty($_SERVER['PATH_INFO'])) {
                $depr = C('URL_PATHINFO_DEPR');
                $input = explode($depr, trim($_SERVER['PATH_INFO'], $depr));
            }
            break;
        case 'request':
            $input = &$_REQUEST;
            break;
        case 'session':
            $input = &$_SESSION;
            break;
        case 'cookie':
            $input = &$_COOKIE;
            break;
        case 'server':
            $input = &$_SERVER;
            break;
        case 'globals':
            $input = &$GLOBALS;
            break;
        case 'data':
            $input = &$datas;
            break;
        default:
            return null;
    }
    if ('' == $name) {
        // 获取全部变量
        $data = $input;
        $filters = isset($filter) ? $filter : C('DEFAULT_FILTER');
        if ($filters) {
            if (is_string($filters)) {
                $filters = explode(',', $filters);
            }
            foreach ($filters as $filter) {
                $data = array_map_recursive($filter, $data); // 参数过滤
            }
        }
    } elseif (isset($input[$name])) {
        // 取值操作
        $data = $input[$name];
        $filters = isset($filter) ? $filter : C('DEFAULT_FILTER');
        if ($filters) {
            if (is_string($filters)) {
                if (0 === strpos($filters, '/')) {
                    if (1 !== preg_match($filters, (string)$data)) {
                        // 支持正则验证
                        return isset($default) ? $default : null;
                    }
                } else {
                    $filters = explode(',', $filters);
                }
            } elseif (is_int($filters)) {
                $filters = array($filters);
            }
            if (is_array($filters)) {
                foreach ($filters as $filter) {
                    $filter = trim($filter);
                    if (function_exists($filter)) {
                        $data = is_array($data) ? array_map_recursive($filter, $data) : $filter($data); // 参数过滤
                    } else {
                        $data = filter_var($data, is_int($filter) ? $filter : filter_id($filter));
                        if (false === $data) {
                            return isset($default) ? $default : null;
                        }
                    }
                }
            }
        }
        if (!empty($type)) {
            switch (strtolower($type)) {
                case 'a': // 数组
                    $data = (array)$data;
                    break;
                case 'd': // 数字
                    $data = (int)$data;
                    break;
                case 'f': // 浮点
                    $data = (float)$data;
                    break;
                case 'b': // 布尔
                    $data = (boolean)$data;
                    break;
                case 's': // 字符串
                default:
                    $data = (string)$data;
            }
        }
    } else {
        // 变量默认值
        $data = isset($default) ? $default : null;
    }
    is_array($data) && array_walk_recursive($data, 'think_filter');
    return $data;
}


function str_check($str)
{

    if (empty($str)) return false;
    $str = htmlspecialchars($str);
    //$str = str_replace('/', "", $str);
    $str = str_replace('"', "", $str);
    $str = str_replace('(', "", $str);
    $str = str_replace(')', "", $str);
    $str = str_replace('CR', "", $str);
    $str = str_replace('ASCII', "", $str);
    $str = str_replace('ASCII 0x0d', "", $str);
    $str = str_replace('LF', "", $str);
    $str = str_replace('ASCII 0x0a', "", $str);
    //$str = str_replace(',', "", $str);
    $str = str_replace('%', "", $str);
    $str = str_replace(';', "", $str);
    $str = str_replace('eval', "", $str);
    $str = str_replace('open', "", $str);
    $str = str_replace('sysopen', "", $str);
    $str = str_replace('system', "", $str);
    $str = str_replace('$', "", $str);
    //$str = str_replace("'", "", $str);
    //$str = str_replace("'", "", $str);
    $str = str_replace('ASCII 0x08', "", $str);
    $str = str_replace('"', "", $str);
    $str = str_replace('"', "", $str);
    $str = str_replace("", "", $str);
    $str = str_replace("&gt", "", $str);
    $str = str_replace("&lt", "", $str);
    $str = str_replace("<SCRIPT>", "", $str);
    $str = str_replace("</SCRIPT>", "", $str);
    $str = str_replace("<script>", "", $str);
    $str = str_replace("</script>", "", $str);
    $str = str_replace("select", "", $str);
    $str = str_replace("join", "", $str);
    $str = str_replace("union", "", $str);
    $str = str_replace("where", "", $str);
    $str = str_replace("insert", "", $str);
    $str = str_replace("delete", "", $str);
    $str = str_replace("update", "", $str);
    $str = str_replace("like", "", $str);
    $str = str_replace("drop", "", $str);
    $str = str_replace("DROP", "", $str);
    $str = str_replace("create", "", $str);
    $str = str_replace("modify", "", $str);
    $str = str_replace("rename", "", $str);
    $str = str_replace("alter", "", $str);
    $str = str_replace("cas", "", $str);
    //  $str = str_replace("&", "", $str);
    $str = str_replace(">", "", $str);
    $str = str_replace("<", "", $str);
    // $str = str_replace(" ", chr(32), $str);
    // $str = str_replace(" ", chr(9), $str);
    // $str = str_replace("    ", chr(9), $str);
    //   $str = str_replace("&", chr(34), $str);
    $str = str_replace("'", chr(39), $str);
    $str = str_replace("<br />", chr(13), $str);
    $str = str_replace("''", "'", $str);
    $str = str_replace("css", "'", $str);
    $str = str_replace("CSS", "'", $str);
    $str = str_replace("<!--", "", $str);
    $str = str_replace("convert", "", $str);
    $str = str_replace("md5", "", $str);
    $str = str_replace("passwd", "", $str);
    $str = str_replace("password", "", $str);
    $str = str_replace("../", "", $str);
    //$str = str_replace("./", "", $str);
    $str = str_replace("Array", "", $str);
    $str = str_replace("or 1='1'", "", $str);
    $str = str_replace(";set|set&set;", "", $str);
    $str = str_replace("`set|set&set`", "", $str);
    $str = str_replace("--", "", $str);
    $str = str_replace("OR", "", $str);
    $str = str_replace('"', "", $str);
    $str = str_replace("*", "", $str);
    //$str = str_replace("-", "", $str);
    //$str = str_replace("+", "", $str);
    //$str = str_replace("/", "", $str);
    //   $str = str_replace("=", "", $str);
    //$str = str_replace("'/", "", $str);
    $str = str_replace("-- ", "", $str);
    $str = str_replace(" -- ", "", $str);
    $str = str_replace(" --", "", $str);
    $str = str_replace("(", "", $str);
    $str = str_replace(")", "", $str);
    $str = str_replace("{", "", $str);
    $str = str_replace("}", "", $str);
    //$str = str_replace("-1", "", $str);
    //$str = str_replace("1", "", $str);
    //$str = str_replace(".", "", $str);
    $str = str_replace("response", "", $str);
    $str = str_replace("write", "", $str);
    $str = str_replace("|", "", $str);
    $str = str_replace("`", "", $str);
    $str = str_replace(";", "", $str);
    $str = str_replace("etc", "", $str);
    $str = str_replace("root", "", $str);
    //$str = str_replace("//", "", $str);
    $str = str_replace("!=", "", $str);
    $str = str_replace("$", "", $str);
    //   $str = str_replace("&", "", $str);
    $str = str_replace("&amp", "&", $str);
    $str = str_replace("&&", "", $str);
    $str = str_replace("==", "", $str);
    //$str = str_replace("#", "", $str);
    //$str = str_replace("@", "", $str);
    $str = str_replace("mailto:", "", $str);
    $str = str_replace("CHAR", "", $str);
    $str = str_replace("char", "", $str);
    return $str;

}
