<?php

/**
 * 发布动态消息推送
 * */
function push_dynamic_msg($self_id, $user_id_list, $msg)
{

    bogo_require(APP_ROOT_PATH . 'system/schedule/android_list_schedule.php');
    bogo_require(APP_ROOT_PATH . 'system/schedule/ios_list_schedule.php');
    bogo_require(APP_ROOT_PATH . 'system/schedule/android_file_schedule.php');
    bogo_require(APP_ROOT_PATH . 'system/schedule/ios_file_schedule.php');
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');

    //查询主播设备号
    $apns_code_sql = "select u.apns_code from " . DB_PREFIX . "user as u  where u.id =" . $self_id;
    $my_apns_code = $GLOBALS['db']->getOne($apns_code_sql, true, true);

    //查找粉丝推送
    $code_list = array();

    $user_list = substr($user_id_list, 0, strlen($user_id_list) - 1);

    $code_sql = "select u.apns_code,u.device_type from " . DB_PREFIX . "user as u where  u.is_effect =1 and u.device_type in (1,2) and u.id in (" . $user_list . ") and u.is_remind=1";
    $apns_list = $GLOBALS['db']->getAll($code_sql, true, true);
    $code_list = array_merge($code_list, $apns_list);

    //推送消息文本
    $content = $msg;

    //过滤重复的推送数据数据
    $array = array_map('json_encode', $code_list);
    $array = array_unique($array);
    $code_list = array_map('json_decode', $array);

    $num = count($code_list);
    //大于10000条的推送，使用文件方式，小于1000条直接推送
    if (intval($num) > 10000) {
        $code_arr = array();
        $code_android_arr = array();
        $code_ios_arr = array();
        foreach ($code_list as $ck => $cv) {
            $apns_code = $cv->apns_code;
            $device_type = $cv->device_type;
            //排除主播设备号
            if ($my_apns_code == $apns_code || in_array($apns_code, $code_android_arr) || in_array($apns_code, $code_ios_arr)) {
                continue;
            }
            if ($device_type == 1) {
                $code_android_arr[] = $apns_code;
            }
            if ($device_type == 2) {
                $code_ios_arr[] = $apns_code;
            }

        }
        if ($code_android_arr) {
            $code_android_file = implode("\n", $code_android_arr);
        }

        if ($code_ios_arr) {
            $code_ios_file = implode("\n", $code_ios_arr);
        }

        //device_type 1：安卓机型。2：ios
        //安卓推送信息
        if ($code_android_arr) {
            $AndroidFile = new android_file_schedule();
            $data = array(
                'file_code' => $code_android_file,
                'content' => $content,
                'type' => 0,
                'room_id' => 0,
            );
            $return = $AndroidFile->exec($data);
        }
        //ios 推送信息
        if ($code_ios_arr) {
            $IosFile = new ios_file_schedule();
            $Ios_data = array(
                'file_code' => $code_ios_file,
                'content' => $content,
                'type' => 0,
                'room_id' => 0,
            );
            $return = $IosFile->exec($Ios_data);
        }
    } else {
        //得到机器码列表
        $apns_app_code_list = array();
        $apns_ios_code_list = array();

        $j = $i = 0;
        foreach ($code_list as $kk => $vv) {
            $apns_code = $vv->apns_code;
            $device_type = $vv->device_type;

            //排除主播设备号
            if ($my_apns_code == $apns_code || in_array($apns_code, $apns_app_code_list)) {
                continue;
            }
            //获取android机器码
            if ($device_type == 1) {
                $apns_app_code_list[$i] = $apns_code;
                $i++;
            }

            //获取IOS机器码
            if ($device_type == 2) {
                $apns_ios_code_list[$j] = $apns_code;
                $j++;
            }

            //安卓推送信息
            if ($i % 500 == 0 && $i != 0) {
                $AndroidList = new android_list_schedule();
                $android_dest = implode(",", $apns_app_code_list);
                $data = array(
                    'dest' => $android_dest,
                    'content' => $content,
                    'type' => 0,
                    'room_id' => 0,
                );
                $return = $AndroidList->exec($data);

                //重置机器列表
                $i = 0;
                unset($apns_app_code_list);

            }

            //ios 推送信息
            if ($j % 500 == 0 && $j != 0) {
                $IosList = new ios_list_schedule();
                $ios_dest = implode(",", $apns_ios_code_list);
                $ios_data1 = array(
                    'dest' => $ios_dest,
                    'content' => $content,
                    'type' => 0,
                    'room_id' => 0,
                );
                $return = $IosList->exec($ios_data1);
                // ios_dest = '".$ios_dest."',

                //重置机器列表
                $j = 0;
                unset($apns_ios_code_list);
            }
        }
        //安卓推送信息
        if (count($apns_app_code_list) > 0) {
            $AndroidList = new android_list_schedule();
            $android_dest = implode(",", $apns_app_code_list);
            $data = array(
                'dest' => $android_dest,
                'content' => $content,
                'type' => 0,
                'room_id' => 0,
            );
            $return = $AndroidList->exec($data);

            //打印推送列表
            //$this->chack_push_notice($android_dest);
            //$this->chack_push_notice($return);
        }


        //ios 推送信息
        if (count($apns_ios_code_list) > 0) {
            $IosList = new ios_list_schedule();
            $ios_dest = implode(",", $apns_ios_code_list);
            $ios_data = array(
                'dest' => $ios_dest,
                'content' => $content,
                'type' => 0,
                'room_id' => 0,
            );
            $return = $IosList->exec($ios_data);
        }

        //打印推送列表
        //$this->chack_push_notice($android_dest);
        //$this->chack_push_notice($return);
    }
    //推送结束

}

//礼物发送者信息，群组内消息数据，礼物信息
function propNotify($sender,$to_user_info, $ext, $prop)
{
    $all_success_flag = 1; //所有群组IM发送都成功的标志位,默认置1
    $user_id = $sender['user_id'];
    //定义广播消息相关内容
    $broadMsg = array();
    $broadMsg['type'] = 50;  //IM的type

    $broadMsg['num'] = $ext['num']; //礼物数量
    $broadMsg['is_plus'] = $ext['is_plus']; //可以叠加显示多个
    $broadMsg['is_much'] = $ext['is_much']; //可以连续发送多个
    $broadMsg['room_id'] = $ext['room_id']; //房间号
    // $broadMsg['app_plus_num'] = $ext['app_plus_num'];
    $broadMsg['app_plus_num'] = $ext['is_animated'];     //动画类型

    $broadMsg['sender'] = $sender;    //礼物发送者
    $broadMsg['prop_id'] = $ext['prop_id']; //礼物ID
    $broadMsg['icon'] = $ext['icon'];    //礼物图标
    $broadMsg['to_user_id'] = $ext['to_user_id'];    //接收礼物的主播ID
    $broadMsg['fonts_color'] = "";    //消息字体颜色
    $broadMsg['anim_type'] = $ext['anim_type'];    //大型道具类型;
    $sender['nick_name'] = emoji_decode($sender['nick_name']);
    $broadMsg['desc'] =$sender['nick_name'] .' '. api_lang("give_to").' '.emoji_decode($to_user_info['nick_name']).' '. $prop['name'] .' x '.$ext['num'];//消息;

    #构造rest API请求包
    $msg_content = array();
    //创建$msg_content 所需元素
    $msg_content_elem = array(
        'MsgType' => 'TIMCustomElem',       //定义类型为普通文本型
        'MsgContent' => array(
            'Data' => json_encode($broadMsg)    //转为JSON字符串
        )
    );

    //将创建的元素$msg_content_elem, 加入array $msg_content
    array_push($msg_content, $msg_content_elem);

    //引入IM API文件
    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
    $tim_api = createTimAPI();
    $m_config = load_auto_cache("m_config");//初始化手机端配置
    $ret=$tim_api->group_send_group_msg2($user_id, $m_config['full_group_id'], $msg_content);
    $root['status_notify_all'] = 1;
    $root['ret'] = $ret;
    return $root;
}


function propNotify2() //礼物发送者信息，群组内消息数据，礼物信息
{
    $all_success_flag = 1; //所有群组IM发送都成功的标志位,默认置1
    $user_id = 'admin';


    $m_config = load_auto_cache("m_config");//初始化手机端配置

    $sender = array();
    $sender['user_id'] = $user_id;//发送人昵称
    $sender['nick_name'] = '系统消息';//发送人昵称
    $sender['head_image'] = '';//发送人头像
    $sender['user_level'] = 1;//用户等级
    $sender['v_icon'] = '';//认证图标

    //定义广播消息相关内容
    $broadMsg = array();
    $broadMsg['type'] = 50;  //IM的type

    $broadMsg['num'] = 1; //礼物数量
    $broadMsg['is_plus'] = 1; //可以叠加显示多个
    $broadMsg['is_much'] = 1; //可以连续发送多个
    $broadMsg['room_id'] = 1; //房间号
    $broadMsg['app_plus_num'] = 1;
    $broadMsg['app_plus_num'] = 1;     //动画类型

    $broadMsg['sender'] = $sender; //礼物发送者
    $broadMsg['prop_id'] = 1; //礼物ID
    $broadMsg['icon'] = '';  //礼物图标
    $broadMsg['to_user_id'] = 1;  //接收礼物的主播ID
    $broadMsg['fonts_color'] = "";   //消息字体颜色
    $broadMsg['anim_type'] = 1;  //大型道具类型;
    $sender['nick_name'] = emoji_decode($sender['nick_name']);
    $broadMsg['desc'] = $m_config['system_message_fly'];//消息;
    $broadMsg['url'] = $m_config['system_message_url_fly'];//消息;

    #构造rest API请求包
    $msg_content = array();
    //创建$msg_content 所需元素
    $msg_content_elem = array(
        'MsgType' => 'TIMCustomElem',       //定义类型为普通文本型
        'MsgContent' => array(
            'Data' => json_encode($broadMsg)  //转为JSON字符串
        )
    );

    //将创建的元素$msg_content_elem, 加入array $msg_content
    array_push($msg_content, $msg_content_elem);

    //引入IM API文件
    bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
    $tim_api = createTimAPI();

    //获取所有的群组ID
    $group_id_all = $GLOBALS['db']->getAll("SELECT id,group_id,live_in FROM " . DB_PREFIX . "video", true, true);
    //向所有群组发送消息
    $ret = array(); //存放发送返回信息
    for ($i = 0; $i < count($group_id_all); $i++) {
        $ret[] = $tim_api->group_send_group_msg2($user_id, $group_id_all[$i]['group_id'], $msg_content);
        $idx = 'group' . $i;
        $root[$idx] = $group_id_all[$i]['group_id'];
    }


    //查看是否全部发送成功,对于没发送成功的情况进行回馈
    for ($i = 0; $i < count($ret); $i++) {
        //定义对应信息的存放键值
        $err_info = 'error_notify' . $i;
        $status_info = 'status_notify' . $i;
        //出错的写入对应位置
        if ($ret[$i]['ActionStatus'] == 'FAIL') {
            $root[$err_info] = $ret[$i]['ErrorInfo'] . ":" . $ret[$i]['ErrorCode'];
            $root[$status_info] = 0;
            $all_success_flag = 0;
        }
    }
    if ($all_success_flag) {
        $root['status_notify_all'] = 1;
    } else {
        $root['status_notify_all'] = 0;
    }

    return $root;
}



