<?php

use GuzzleHttp\Client;
use GuzzleHttp\Psr7\Request;

/**
 * 文档地址 https://help.aliyun.com/document_detail/48207.html?spm=5176.doc35411.6.570.AeuNzq
 */
class videoAgora
{
    private $m_config;

    function __construct($m_config)
    {
        $this->m_config = $m_config;
    }

    public function Create($video_id, $user_id)
    {

        //生成推拉流地址 $pull_key ='87ebfaf7ddededf680ec4466fd79262d'; '89ef33f73c49c2a2da98be404a34551b';
        $pull_key = $this->m_config['qcloud_pull_security_key'];
        $stream_id = $user_id . "_" . substr(md5($video_id . microtime_float()), 12);
        //生成推流地址
        $time = date('Y-m-d H:i:s', time() + 86400);
        $txTime = strtoupper(base_convert(strtotime($time), 10, 16));
        $txSecret = md5($pull_key . $stream_id . $txTime);
        $ext_str = "?" . http_build_query(array(
                "txSecret" => $txSecret,
                "txTime"   => $txTime
            ));
        $live_pull_url = $this->m_config['tpull_domain']; // $live_pull_url = 'livepull.bogokj.com';// $this->m_config['tpull_domain'];
        $qcloud_app_name = 'live';
        if (strpos($live_pull_url, 'http') == false) {
            $live_pull_url = "https://" . $live_pull_url;
        }
        $downstream_address = array(
            'rtmp' => "rtmp://" . $this->m_config['tpull_domain'] . "/" . $qcloud_app_name . "/" . $stream_id . (isset($ext_str) ? $ext_str : ""),
            'flv'  => $live_pull_url . "/" . $qcloud_app_name . "/" . $stream_id . ".flv" . (isset($ext_str) ? $ext_str : ""),
            'hls'  => $live_pull_url . "/" . $qcloud_app_name . "/" . $stream_id . ".m3u8" . (isset($ext_str) ? $ext_str : "")
        );
        $live_push_url = $this->m_config['tpush_domain'];
        $upstream_address = "rtmp://" . $live_push_url . "/" . $qcloud_app_name . "/" . $stream_id . (isset($ext_str) ? $ext_str : "");
        $agora_app_id = $this->m_config['agora_app_id'];
        $agora_customer_id = $this->m_config['agora_customer_id'];
        $agora_app_certificate = $this->m_config['agora_customer_key'];
        $apiResult = $this->agoraRequestCreatePushStream($agora_app_id, $agora_customer_id, $agora_app_certificate, $video_id, $upstream_address, $user_id);

        if (!$apiResult && $apiResult['status'] == 0) {
            return $apiResult;
        }
        return array(
            'status'    => 1,
            'stream_id' => $stream_id,
            'push_rtmp' => $upstream_address,
            'play_rtmp' => $downstream_address['rtmp'],
            'play_flv'  => $downstream_address['flv'],
            'play_hls'  => $downstream_address['hls'],
        );
    }

    /**
     * 创建推流
     * */
    function agoraRequestCreatePushStream($app_id, $customerKey, $customerSecret, $channelName, $pushUrl, $uid1)
    {
        $region = 'cn';
        $url = "https://api.sd-rtn.com/$region/v1/projects/$app_id/rtmp-converters";

        // 拼接客户 ID 和客户密钥
        $credentials = $customerKey . ":" . $customerSecret;

        // 使用 base64 进行编码
        $base64Credentials = base64_encode($credentials);
        $headers = ['Content-Type' => 'application/json', 'X-Request-ID' => $uid1, 'Authorization' => "Basic " . $base64Credentials];

        $bodyArray = [
            'converter' => [
                'rawOptions' => [
                    'rtcChannel'   => (string)$channelName,
                    'rtcStreamUid' => $uid1
                ],
                'rtmpUrl'    => $pushUrl,
            ]
        ];

        $client = new Client();
        $body = json_encode($bodyArray);
        $request = new Request('POST', $url, $headers, $body);

        try {
            $response = $client->send($request);

            add_file_log($response->getBody(), 'agora_api');

            if ($response->getStatusCode() != 200) {
                $data = json_decode($response->getBody(), true);
                return ['status' => 0, 'error' => $data['message']];
            }
        } catch (\GuzzleHttp\Exception\GuzzleException $e) {

            add_file_log($e->getMessage(), 'agora_api');
            return ['status' => 0, 'error' => $e->getMessage()];
        }

        return ['status' => 1, 'error' => '', 'data' => json_decode((string)$response->getBody(), true)];
    }

}