<?php

bogo_require(APP_ROOT_PATH . 'vendor/autoload.php');


/**
 * 文档地址 https://v.ksyun.com/doc.html#/doc/livesdk.md
 */
class VideoDaimeng
{
    private $m_config;

    function __construct($m_config)
    {
        $this->m_config = $m_config;
    }

    function getExpireTime()
    {
        $tz = 'Asia/Shanghai';
        $dt = new DateTime("now", new DateTimeZone($tz));
        // 流时长6小时之内，且主动正常断流会触发拼接
        $dt->add(new DateInterval('PT6H'));
        return $dt->getTimestamp();
    }

    public function Create($video_id)
    {
        // 流时长6小时之内，且主动正常断流会触发拼接

        $stream_id = $video_id . "_" . substr(md5($video_id . microtime_float()), 12);

        $upstream_address = "rtmp://{$this->m_config['ucloud_push']}/{$this->m_config['ucloud_name']}/{$stream_id}";

        return array(
            'stream_id' => $stream_id,
            'push_rtmp' => $upstream_address,
            'play_rtmp' => "rtmp://{$this->m_config['ucloud_pull']}/{$this->m_config['ucloud_name']}/" . $stream_id,
            'play_flv' => "http://{$this->m_config['ucloud_pull']}/{$this->m_config['ucloud_name']}/" . $stream_id . ".flv",
            'play_hls' => "http://{$this->m_config['ucloud_pull']}/{$this->m_config['ucloud_name']}/" . $stream_id . "/index.m3u8",
        );
    }

    public function Query($stream_id)
    {

        return array(
            'channel_id' => $stream_id,
            'status' => 1,
        );
    }

    public function Stop($stream_id)
    {

        return true;
    }

    public function GetRecord($stream_id, $video_id)
    {
        return array();
    }
}
