<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------
// 也可以添加所有的请求为 允许，当然不推荐这样做了、
header('Access-Control-Allow-Origin: *');

use think\Db;

class dealModule
{
    /**
     * 获取礼物数量赠送
     */
    public function get_gift_quantity()
    {
        $root = array('status' => 1, 'error' => '', 'data' => array());
        $prop_quantity = Db::name('prop_quantity')->field("id,title,num")->order("sort desc")->select();
        if ($prop_quantity) {
            $root['data'] = $prop_quantity;
        }
        ajax_return($root);
    }

    /**
     * 送礼物
     */
    public function pop_prop()
    {

        $root = array();

        $token = strim($_REQUEST['token']);
        if (!empty($token)) {
            //根据加密的token获取id pc使用
            $user = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . "user where token = '" . $token . "'");
            $user_id = $user['id'];
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
        }

        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id=" . $user_id);
            //VIP状态
            if ($user_info['vip_expire_time'] > NOW_TIME || $user_info['is_vip'] == 1) {
                $user_info['is_vip'] = 1;
            } else {
                $user_info['is_vip'] = 0;
            }
            //礼物id
            $prop_id = intval($_REQUEST['prop_id']);
            //礼物数量
            $num = intval($_REQUEST['num']) <= 0 ? 1 : intval($_REQUEST['num']);
            //1显示连续;
            $is_plus = intval($_REQUEST['is_plus']);
            //直播ID 也是room_id
            $video_id = strim($_REQUEST['room_id']);
            //判断发送来源 pc或者app
            $from = strim($_REQUEST['from']);
            //0是钻石，1是游戏币
            $is_coins = intval($_REQUEST['is_coins']);
            //子房间
            $child_id = isset($_REQUEST['child_id']) ? intval($_REQUEST['child_id']) : $video_id;

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            //查询直播记录
//            $sql = "select id,user_id,group_id,prop_table,room_type,is_voice from " . DB_PREFIX . "video where id = " . $video_id;
//            $video = $GLOBALS['db']->getRow($sql);

             $video = $video_redis->getRow_db($video_id, array('id', 'user_id', 'group_id', 'prop_table', 'room_type','is_voice'));

            $group_id = strim($video['group_id']);//群组ID
            $to_user_id = get_input('to_user_id', 's');
            //送给谁，有群组ID(group_id)，除了红包外其它的都是送给：群主
            if ($video && $video['is_voice'] != 1) {
                $to_user_id = $video['user_id'];
            }
            $to_user_id_list = explode(',', $to_user_id);
            //直播间类型 房间类型 : 1私有群（Private）,0公开群（Public）,2聊天室（ChatRoom）,3互动直播聊天室（AVChatRoom）
            $room_type = intval($video['room_type']);
            //查询用户是否被禁言
            //优化
            $forbid_info = $video_redis->has_forbid_msg($group_id, $user_id);//判断某个用户是否被禁言(被禁言返回：true; 未被禁言返回：false)
            if ($forbid_info) {
                $root['status'] = 0;
                $root['error'] = api_lang("no_gift_can_be_given");
                ajax_return($root);
            }
            $m_config = load_auto_cache("m_config");//初始化手机端配置

            if ($m_config['give_yourself_gift_switch'] == 0) {
                if (in_array($user_id, $to_user_id_list)) {
                    $root['error'] = api_lang("no_give_yourself_gift");
                    $root['status'] = 0;
                    ajax_return($root);
                }
            }
            //检查测试账号不能发礼物给真实主播
//            $sql = "select mobile from " . DB_PREFIX . "user where id in (" . $to_user_id . ")";
//            $podcast_mobile_list = $GLOBALS['db']->getAll($sql, true, true);
//            foreach ($podcast_mobile_list as $v) {
//                if (($GLOBALS['user_info']['mobile'] == '13888888888' && $v != '13999999999') || $GLOBALS['user_info']['mobile'] == '13999999999' && $v != '13888888888') {
//                    $root['error'] = "测试账号不能发礼物给真实主播";
//                    $root['status'] = 0;
//                    ajax_return($root);
//                }
//            }

            //以后需要从缓存中读取
            $prop = load_auto_cache("prop_id", array('id' => $prop_id));
            //守护礼物
            if ($prop['type'] == 2) {
                foreach ($to_user_id_list as $v) {
                    //获取是否是守护者
                    $guardian_user = redis_get("guardian_host_".$v."_user_".$user_id);
                    if (!$guardian_user) {
                        $root['status'] = 0;
                        $root['error'] = api_lang("Guard_not_opened");
                        ajax_return($root);
                    }
                }
            }
            //判断VIP礼物
            if ($prop['type'] == 3 && $user_info['is_vip'] != 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("Unable_to_send_VIP_gift");
                ajax_return($root);
            }
            //贵族礼物
            if ($prop['type'] == 4) {
                //获取贵族权限
                if ($user_info['nobleid'] <= 0 || $user_info['noble_time'] < NOW_TIME) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("No_noble_gifts_sent");
                    ajax_return($root);
                }
                //此等级贵族是否有送礼物权限
                $jurisdiction = load_auto_cache("noble_id", ['id' => $user_info['nobleid']]);
                if ($jurisdiction && $jurisdiction['is_gift'] != 1) {
                    $root['status'] = 0;

                    $root['error'] = api_lang("noble_Insufficient_authority");
                    ajax_return($root);
                }
            }

            if ($is_coins == 0) {
                $all_diamonds = $num * $prop['diamonds'] * count($to_user_id_list);
                $total_diamonds = $num * $prop['diamonds'];
            } else {
                $all_diamonds = $num * $prop['coins'] * count($to_user_id_list);
                $total_diamonds = $num * $prop['coins'];
            }
            if ($is_coins == 0) {
                if ($user_info['diamonds'] < $all_diamonds) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("insufficient_balance");
                    ajax_return($root);
                }
            } else {
                if ($user_info['coin'] < $all_diamonds) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("insufficient_balance");
                    ajax_return($root);
                }
            }
            // 判断会员礼物积分
            $score = $prop['type'] == 3 ? $prop['score'] + $prop['vip_score'] : $prop['score'];
            $total_score = $num * $score;
            $total_ticket = intval($num * $prop['ticket']);
            $robot_diamonds = intval($prop['robot_diamonds']);
            foreach ($to_user_id_list as $v) {
                // 获取用户余额
                $before_user_diamonds = intval($GLOBALS['db']->getOne("select diamonds from " . DB_PREFIX . "user where id=" . $user_id));
                $before_to_ticket = intval($GLOBALS['db']->getOne("select ticket from " . DB_PREFIX . "user where id=" . $v));
                $root = $this->pack_prop($video_redis, $total_diamonds, $total_score, $total_ticket, $num, $prop, $is_plus, $video_id, $user_id, $prop_id, $v, $group_id, $room_type, $from, $robot_diamonds, $is_coins, $child_id, $user['is_vip']);
                // 扣除中奖金额
                $lucky_jackpot_pot_amount = $lucky_jackpot_pot_amount - $root['lucky_jackpot_pot_amount'];
                $content = $prop['name'] . "(" . $prop['diamonds'] . ") x " . $num;
                add_user_records($user_id, $v, $total_diamonds, $total_ticket, $before_user_diamonds, $before_to_ticket, $video_id, $prop_id, $content);
            }
            $user_info = $GLOBALS['db']->getRow("select diamonds from " . DB_PREFIX . "user  where id=" . intval($user_id));
            // 更新余额
            $root['user_diamonds'] = $user_info['diamonds'];
        }
        ajax_return($root);
    }

    /**
     * 送礼物每日任务
     */
    public function get_task($prop, $user_id)
    {

        $task = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "daily_mission where task=" . $prop . " and status=1");//查询是否是每日任务礼物

        if ($task) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            $user_redis = new BaseRedisService();
            $time = date("Y-m-d");
            $is_prop = $user_redis->getOne($user_id . $time . "task" . $prop, 'sum');

            if (!$is_prop) {
                $data = array('sum' => 1);
                //$time是当天的时间 prop礼物id
                $user_redis->insert($user_id . $time . "task" . $prop, $data);
            } elseif ($is_prop['sum'] < $task['number']) {
                $sum = $is_prop['sum'] + 1;
                $data = array('sum' => $sum);
                $user_redis->update($user_id . $time . "task" . $prop, $data);
            }

        }
    }
    /**
     *测试幸运礼物
     * 幸运礼物中奖通知字段 status 1是幸运礼物  is_winning 1是中奖  is_broadcast1全服飘屏
     *
     * /*public function get_gifts(){
     *
     * $user_id=170741;
     * $prop_id=79;
     * $lucky_sum=1;
     * $podcast_id=170802;
     *
     * $lucky=$this->get_lucky($user_id,$prop_id,$podcast_id,$lucky_sum);
     * var_dump($lucky);exit;
     * }*/


    /**
     * 幸运礼物   user_id 送礼人id  $prop_id  礼物id  $podcast_id收礼人id  $num连送礼物数量
     * bogo_prop_bonus_pools奖金池
     * prop_bonus_pools_log   中奖记录
     * status 1幸运礼物 0不是  is_winning 0 未中奖 1中奖
     * user_money 中奖金额  user_multiple中奖倍率    num 送礼物数量
     *  $user_id=164731;$prop_id=31; $podcast_id=164732; $num=3;
     * */
    public function get_lucky($user_id, $prop_id, $podcast_id, $num)
    {
        $lucky = load_auto_cache("prop_lucky", array('user_id' => $user_id, 'prop_id' => $prop_id, 'podcast_id' => $podcast_id, 'num' => $num));
        $lucky['num'] = $num;
        return $lucky;
    }


    /**
     * 送礼物封装
     */
    public function pack_prop($video_redis, $total_diamonds, $total_score, $total_ticket, $num, $prop, $is_plus, $video_id, $user_id, $prop_id, $podcast_id, $group_id, $room_type, $from, $robot_diamonds, $is_coins, $child_id = '', $is_vip = 0)
    {
        $table = createPropTable();
        $pInTrans = $GLOBALS['db']->StartTrans();
        //获取是否是守护者
        $guardian_user = redis_get("guardian_host_".$podcast_id."_user_".$user_id);
        $guardian = ['barrage' => 0, 'icon' => 0];
        $video = $video_redis->getRow_db($video_id, array('user_id','is_voice'));

        $guardian_info = [];
        if ($guardian_user) {
            $guardian_user = json_decode($guardian_user,true);
            if($guardian_user){
                //守护类型
                $guardian_info = $this->get_guardians_barrage(intval($guardian_user['classification_id']));  //获取守护权限
            }
        }
        try {
            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();

            $m_config = load_auto_cache("m_config");//初始化手机端配置
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $fields= array('diamonds','ticket','no_ticket','is_noble_stealth','is_noble_mysterious','nick_name', 'head_image', 'user_level', 'v_icon', 'is_gift_giving', 'nobleid', 'noble_time');
            $user_info = $user_redis->getRow_db($user_id, $fields);
            //$lucky = $this->get_lucky($user_id, $prop_id, $podcast_id, $num);


            //免费礼物 和中奖的幸运礼物
            if (($total_diamonds == 0 && $total_score == 0 && $total_ticket == 0)) {

                $type = 1;
                //普通会员收到的提示内容;
                $desc = api_lang("I_did") . $num . api_lang("individual") . $prop['name'];
                //礼物接收人（主播）收到的提示内容
                $desc2 = $desc;

                $ext = array();
                $ext['type'] = $type; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束; 8:红包
                $ext['num'] = $num;
                $ext['is_plus'] = $is_plus;//1：数量连续叠加显示;0:不叠加;这个值是从客户端上传过来的
                $ext['is_much'] = $prop['is_much'];//1:可以连续发送多个;用于小金额礼物
                $ext['room_id'] = $video_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                $ext['is_animated'] = $prop['is_animated'];//1:动画；0：未动画
                $ext['animated_url'] = $prop['animated_url'];//svga动画礼物

                //消息发送者
                $sender = array();

                $sender['user_id'] = $user_id;//发送人昵称
                $sender['nick_name'] = emoji_decode($user_info['nick_name']);//发送人昵称
                $sender['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
                $sender['user_level'] = $user_info['user_level'];//用户等级
                $sender['v_icon'] = $user_info['v_icon'];//认证图标

                /*守护*/
                $sender['is_guardian'] = $guardian_user ? 1 : 0; //是否是守护
                $sender['guardian_img'] = $guardian_info ? $guardian_info['img'] : ''; //守护图标
                $sender['guardian_skin'] = $guardian['barrage']; //是否有守护专属弹幕
                $sender['guardian_icon'] = $guardian['icon']; //是否有守护身份标识

                $sender['is_vip'] = $is_vip; //是否是vip
                $ext['sender'] = $sender;
                if ($type == 1) {

                    $ext['prop_id'] = $prop_id; //礼物id
                    $ext['icon'] = get_spec_image($prop['icon']);//图片，是否要: 大中小格式？
                    $ext['total_ticket'] = intval($user_redis->getOne_db($podcast_id, 'ticket'));//用户总的：印票数
                    $ext['to_user_id'] = $podcast_id;//礼物接收人（主播）
                    $ext['fonts_color'] = '';//字体颜色
                    $ext['desc'] = $desc;//普通群员收到的提示内容;
                    $ext['desc2'] = $desc2;//礼物接收人（主播）收到的提示内容;
                    $ext['anim_type'] = $prop['anim_type'] ? $prop['anim_type'] : 1;//大型道具类型;
                //    $ext['top_title'] = $sender['nick_name'] . api_lang("give") . $prop['name'];//大型道具类型，标题;
                    // A 用户 赠送 礼物名称 给 B 用户


                    $str = api_lang("gift_msg");
                    $str = str_replace("{uname}", emoji_decode($sender['nick_name']), $str);
                    $str = str_replace("{gift_name}", $prop['name'], $str);
                    $newStr = str_replace("{tname}", emoji_decode($user_redis->getOne_db($podcast_id, 'nick_name')), $str);

                    $ext['top_title'] = $newStr;//大型道具类型，标题;

                    $ext['anim_cfg'] = $prop['anim_cfg'];

                }
                #构造高级接口所需参数
                $msg_content = array();
                //创建array 所需元素
                $msg_content_elem = array(
                    'MsgType'    => 'TIMCustomElem',       //自定义类型
                    'MsgContent' => array(
                        'Data' => json_encode($ext),
                        'Desc' => '',
                        //  'Ext' => $ext,
                        //  'Sound' => '',
                    )
                );
                //将创建的元素$msg_content_elem, 加入array $msg_content
                array_push($msg_content, $msg_content_elem);

                $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);
                if ($ret['ActionStatus'] == 'FAIL' && $ret['ErrorCode'] == 10002) {
                    //10002 系统错误，请再次尝试或联系技术客服。
                    log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
                    $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);
                }

                //$videoGift_redis->update_db($user_prop_id, $ret);

                if ($ret['ActionStatus'] == 'FAIL') {
                    $root['error'] = $ret['ErrorInfo'] . ":" . $ret['ErrorCode'];
                    $root['status'] = 0;
                } else {
                    $root['error'] = '';
                    $root['status'] = 1;
                }

            } else {
                //私密直播间送红包不加经验   
                $video_pk = '';
                if ($prop['is_red_envelope'] == 1 && $room_type == 1) {
                    $total_score = 0;
                }

                //是否是贵族和到期时间 是否经验加倍
                if ($user_info['noble_time'] >= NOW_TIME && $user_info['nobleid'] > 0) {
                    $jurisdiction = load_auto_cache("noble_id", ['id' => $user_info['nobleid']]);
                    if ($jurisdiction && $jurisdiction['is_experience'] == 1 && $jurisdiction['experience_val'] > 1) {
                        $total_score = $total_score * $jurisdiction['experience_val'] + $total_score;
                    }
                }
                if ($is_coins == 0) {
                    //减少用户钻石
                    $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $total_diamonds . ", use_diamonds = use_diamonds + " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and diamonds >= " . $total_diamonds;
                } else {
                    //减少用户游戏币
                    $sql = "update " . DB_PREFIX . "user set coin = coin - " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and coin >= " . $total_diamonds;
                }

                $GLOBALS['db']->query($sql);
                if ($GLOBALS['db']->affected_rows()) {

                    //增加礼物消费账户日志记录
                    if ($is_coins) {
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/core/Model.class.php');
                        Model::$lib = dirname(__FILE__);
                        $user_model = Model::build('user');
                        $account_diamonds = $user_model->coin($user_id);
                        Model::build('coin_log')->addLog($user_id, -1, -$total_diamonds, $account_diamonds, '送礼物消费游戏币');

                    }
                    //插入:送礼物表 修改礼物直接写入 mysql @by slf
                    $video_prop = array(
                        'family_id'     => 0,
                        'family_income' => 0,
                    );
                    $is_consumption_log = 0; // 是否增加了消费记录0否1是
                    //记录：钻石 减少日志
                    if ($total_ticket > 0) {
                        // 家族收益--按照消费数计算
                        $family_one = $this->add_family_income($video_id, $podcast_id, $total_diamonds,$total_ticket);
                        if ($family_one['family_id'] > 0) {
                            $video_prop['family_id'] = $family_one['family_id'];
                            $video_prop['family_income'] = $family_one['family_income'];
                        }

                        if ($prop['is_red_envelope'] == 1) {
                            //主播增加：钻石 数量
                            //$user_redis->lock_diamonds($podcast_id,$total_ticket);
                            $sql = "update " . DB_PREFIX . "user set diamonds = diamonds + " . $total_ticket . " where id = " . $podcast_id;
                            $GLOBALS['db']->query($sql);
                            $is_consumption_log = 1;
                            // 消费和收益记录表
                            add_user_consumption_log($user_id, $podcast_id, $total_diamonds, $num . api_lang("individual") . $prop['name'], 0, $total_ticket);
                        } else {
                            //机器人送礼物
                            if (defined("robot_gifts") && robot_gifts == 1) {
                                $roboter = $GLOBALS['db']->getOne("select roboter from " . DB_PREFIX . "user where roboter=1 and id=" . $user_id);//查询是否特殊权限用户
                                if ($roboter) {
                                    //增加：不可提现印票
                                    $sql = "update " . DB_PREFIX . "user set no_ticket = no_ticket + " . $total_ticket . " where id = " . $podcast_id;
                                    $GLOBALS['db']->query($sql);

                                } else {
                                    //增加：用户印票
                                    if ($user_info['is_gift_giving'] != '1') {
                                        $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $podcast_id;
                                        $GLOBALS['db']->query($sql);
                                        $is_consumption_log = 1;
                                        // 消费和收益记录表
                                        add_user_consumption_log($user_id, $podcast_id, $total_diamonds, $num . api_lang("individual") . $prop['name'], $total_ticket);
                                    }
                                }
                            } else {
                                //增加：用户印票
                                if ($user_info['is_gift_giving'] != '1') {
                                    $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $podcast_id;
                                    $GLOBALS['db']->query($sql);
                                    $is_consumption_log = 1;
                                    // 消费和收益记录表
                                    add_user_consumption_log($user_id, $podcast_id, $total_diamonds, $num . api_lang("individual") . $prop['name'], $total_ticket);
                                }

                            }
                        }
                        if($video['is_voice'] == 1){
                            $this->add_wheat_earnings($video_id, $podcast_id, $total_diamonds);
                        }

                        //每日礼物任务赠送记录
                        $this->get_task($prop_id, $user_id);

                        //判断用户是否禁止主播收益（一般是管理员给用户增加的金币，用户消费后主播才没有收益）
                        if ($user_info['is_gift_giving'] != 1) {
                            //邀请码分销
                            $this->check_invite($user_id, $total_ticket, $prop_id);
                        }

                        // 邀请码代理收入
                        $this->agent_check_invite($user_id, $total_ticket, $prop_id, $podcast_id);

                        //记录在redis中
                        //当前直播获得印票数
                        // 是否在PK
                        $video_pk = get_redis_array("pk_list_".$video['user_id']);
                        if ($video_pk && $video_pk['time'] * 60 + $video_pk['create_time'] >= NOW_TIME) {
                            $pk_ticket = $total_diamonds;
                            //增加PK收益
                            if ($video_pk['emcee_user_id1'] == $podcast_id) {
                                $sql = "update " . DB_PREFIX . "video_pk set pk_ticket1 = pk_ticket1 + " . $pk_ticket . " where id=" . $video_pk['id'];
                                $video_pk['pk_ticket1'] += $pk_ticket;
                                $rank_key = $video_pk['emcee_user_id1'];
                            } else {
                                $sql = "update " . DB_PREFIX . "video_pk set pk_ticket2 = pk_ticket2 + " . $pk_ticket . " where id=" . $video_pk['id'];
                                $video_pk['pk_ticket2'] += $pk_ticket;
                                $rank_key = $video_pk['emcee_user_id2'];
                            }
                            $expire =$video_pk['time'] * 60 + 120 + $video_pk['create_time'] - NOW_TIME;
                            redis_set("pk_list_".$video_pk['emcee_user_id1'],json_encode($video_pk),$expire);
                            redis_set("pk_list_".$video_pk['emcee_user_id2'],json_encode($video_pk),$expire);
                            // 存入pk消费缓存
                            redis_zIncrBy("video_pk_consumption_".$rank_key,$pk_ticket,$user_id);

                            // PK消费存入缓存
                           // $video_redis->pk_add_rank($rank_key, $user_id, $total_diamonds);
                            $GLOBALS['db']->query($sql);

                            $list1_array = redis_zRevRange("video_pk_consumption_".$video_pk['emcee_user_id1'],0,3,true);
                            $list1 = array();
                            if (count($list1_array) > 0) {
                                foreach ($list1_array as $k => $v) {
                                    if (intval($k) && intval($v) > 0) {
                                        $to_user = $user_redis->getRow_db(intval($k), array('id', 'nick_name', 'head_image', 'nobleid', 'noble_time', 'is_noble_mysterious'));
                                        $to_user['num'] = $v;
                                        $to_user['head_image'] = get_spec_image($to_user['head_image']);
                                        $to_user['is_noble_mysterious'] = $to_user['noble_time'] > NOW_TIME ? $to_user['is_noble_mysterious'] : 0;
                                        $list1[] = $to_user;
                                    }
                                }
                            }
                            $list2_array = redis_zRevRange("video_pk_consumption_".$video_pk['emcee_user_id2'],0,3,true);
                            $list2 = array();
                            if (count($list2_array) > 0) {
                                foreach ($list2_array as $ks => $s) {
                                    if (intval($ks) && intval($s) > 0) {
                                        $to_user1 = $user_redis->getRow_db(intval($ks), array('id', 'nick_name', 'head_image', 'nobleid', 'noble_time', 'is_noble_mysterious'));
                                        $to_user1['num'] = $s;
                                        $to_user1['head_image'] = get_spec_image($to_user1['head_image']);
                                        $to_user1['is_noble_mysterious'] = $to_user1['noble_time'] > NOW_TIME ? $to_user1['is_noble_mysterious'] : 0;
                                        $list2[] = $to_user1;
                                    }
                                }
                            }

                            $ext['to_user_id'] = $podcast_id;
                            $ext['total_diamonds'] = $total_diamonds;
                            //发送pk收益更新消息
                            $ext['pk_ticket1'] = $video_pk['pk_ticket1'];
                            $ext['pk_ticket2'] = $video_pk['pk_ticket2'];
                            $ext['emcee_user_id1'] = $video_pk['emcee_user_id1'];
                            $ext['emcee_user_id2'] = $video_pk['emcee_user_id2'];
                            $ext['rank_list1'] = $list1;
                            $ext['rank_list2'] = $list2;

                            $ext['type'] = 70;

                            #构造高级接口所需参数
                            $msg_content = array();
                            //创建array 所需元素
                            $msg_content_elem = array(
                                'MsgType'    => 'TIMCustomElem',       //自定义类型
                                'MsgContent' => array(
                                    'Data' => json_encode($ext),
                                    'Desc' => '',
                                )
                            );
                            //将创建的元素$msg_content_elem, 加入array $msg_content
                            array_push($msg_content, $msg_content_elem);
                            //发送消息到正在PK的两个群组
                            $api->group_send_group_msg2($user_id, $video_pk['group_id2'], $msg_content);
                            $api->group_send_group_msg2($user_id, $video_pk['group_id1'], $msg_content);
                        }
                    }
                    if( $is_consumption_log != 1){
                        // 消费和收益记录表
                        add_user_consumption_log($user_id, $podcast_id, $total_diamonds, $num . api_lang("individual") . $prop['name'], 0);
                    }

                    //=========数据库更新成功后,处理redis数据==========


                    $video_prop['prop_id'] = $prop_id;
                    $video_prop['prop_name'] = "'" . $prop['name'] . "'";
                    $video_prop['is_red_envelope'] = $prop['is_red_envelope'];
                    $video_prop['total_score'] = $total_score;
                    $video_prop['total_diamonds'] = $total_diamonds;
                    if ($user_info['is_gift_giving'] != '1') {
                        $video_prop['total_ticket'] = intval($total_ticket);//is_red_envelope=1时,为主播获得的：钻石 数量
                    } else {
                        $video_prop['total_ticket'] = 0;//is_gift_giving=1时,后台限制用户送礼物主播的收益
                    }
                    $video_prop['from_user_id'] = $user_id;
                    $video_prop['to_user_id'] = $podcast_id;
                    $video_prop['create_time'] = NOW_TIME;
                    $video_prop['create_date'] = "'" . to_date(NOW_TIME, 'Y-m-d') . "'";
                    $video_prop['num'] = $num;
                    $video_prop['video_id'] = $video_id;
                    $video_prop['group_id'] = "'" . $group_id . "'";

                    $video_prop['create_ym'] = to_date($video_prop['create_time'], 'Ym');
                    $video_prop['create_d'] = to_date($video_prop['create_time'], 'd');
                    $video_prop['create_w'] = to_date($video_prop['create_time'], 'W');
                    $video_prop['from_ip'] = "'" . get_client_ip() . "'";

                    $video_prop['is_coin'] = 0;
                    if ($is_coins == 1) {
                        $video_prop['is_coin'] = 1;
                    }

                    $table_info = $GLOBALS['db']->getRow("Describe " . $table . " from_ip", true, true);
                    if (!$table_info) {
                        $GLOBALS['db']->query("ALTER TABLE " . $table . " ADD COLUMN `from_ip` varchar(255) NOT NULL  COMMENT '送礼物人IP'");
                    }

                    $table_version = $GLOBALS['db']->getRow("Describe " . $table . " is_coin", true, true);
                    if (!$table_version) {
                        $GLOBALS['db']->query("ALTER TABLE " . $table . " ADD COLUMN `is_coin` varchar(255) NOT NULL  COMMENT '双币礼物，0是钻石，1是游戏币'");
                    }

                    //将礼物写入mysql表中
                    $field_arr = array('family_id', 'family_income', 'prop_id', 'prop_name', 'is_red_envelope', 'total_score', 'total_diamonds', 'total_ticket', 'from_user_id', 'to_user_id', 'create_time', 'create_date', 'num', 'video_id', 'group_id', 'create_ym', 'create_d', 'create_w', 'from_ip', 'is_coin');

                    $fields = implode(",", $field_arr);
                    $valus = implode(",", $video_prop);
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/common.php');
                    //$table = createPropTable();
                    $sql = "insert into " . $table . " (" . $fields . ") VALUES (" . $valus . ")";
                    $GLOBALS['db']->query($sql);
                    $user_prop_id = $GLOBALS['db']->insert_id();

                    //提交事务,不等 消息推送,防止锁太久
                    $GLOBALS['db']->Commit($pInTrans);
                    $pInTrans = false;//防止，下面异常时，还调用：Rollback

                    if ($prop['is_red_envelope'] == 0 && $total_diamonds > 0) {
                        //贡献榜
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoContributionRedisService.php');
                        $videoCont_redis = new VideoContributionRedisService();
                        $videoCont_redis->insert_db($user_id, $podcast_id, $video_id, $total_diamonds);
                    }

                    //分销功能 计算抽成
                    if (defined('OPEN_DISTRIBUTION') && OPEN_DISTRIBUTION == 1 && $prop['is_red_envelope'] == 0 && $total_ticket > 0) {
                        $this->distribution_calculate($user_id, $total_ticket);
                    }

                    if ($prop['is_red_envelope'] == 0 && $total_ticket > 0) {
                        $this->distribution($podcast_id, $video_id, $total_ticket);
                    }

                    user_deal_to_reids(array($user_id, $podcast_id));

                    //更新用户等级
                    $user_info = $user_redis->getRow_db($user_id, array('id', 'nick_name', 'head_image', 'v_icon', 'score', 'online_time', 'user_level', 'diamonds'));
                    user_leverl_syn($user_info);

                    //=================发送:礼物=================================

                    $type = 1;
                    //普通会员收到的提示内容;
                    if ($prop['is_red_envelope'] == 1) {
                        $desc = api_lang("Gave_a_red_envelope");
                        $type = 8;
                    } else {
                        $API_LANG = $_REQUEST['language'] ? $_REQUEST['language'] : API_LANG;

                        $to_nick_name=$user_redis->getOne_db($podcast_id, 'nick_name');
                        if ($API_LANG == 'zh-cn') {
                            $desc = api_lang("I_did") . $num . api_lang("individual") . $prop['name'];
                        } else {
                            $desc = api_lang("I_did").' ' . $num . ' X ' . $prop['name'];

                        }

                    }


                    //礼物接收人（主播）收到的提示内容
                    $desc2 = $desc;

                    $ext = array();
                    $ext['type'] = $type; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束; 8:红包
                    $ext['num'] = $num;
                    $ext['is_plus'] = $is_plus;//1：数量连续叠加显示;0:不叠加;这个值是从客户端上传过来的
                    $ext['is_much'] = $prop['is_much'];//1:可以连续发送多个;用于小金额礼物
                    $ext['room_id'] = $video_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                    //$ext['award'] = $award_res;//

                    $lucky_sum = 1;
                    if ($prop['is_much']) {
                        // 计算连发次数，兼容 PC 端
                        $key = "user:prop:{$user_id}:{$video_id}:{$prop_id}";
                        $user_prop = $GLOBALS['cache']->get($key, true);
                        if ($user_prop && $user_prop['time'] > NOW_TIME) {
                            $plus_num = $user_prop['num'] + 1;
                            if ($from == 'pc' && $plus_num > 1) {
                                $is_plus = 1;
                            }
                        } else {
                            $plus_num = 1;
                        }
                        $ext['plus_num'] = $plus_num;
                        // app 上传 is_plus 视为连发
                        $GLOBALS['cache']->set($key, array('time' => NOW_TIME + 5, 'num' => $plus_num), 5, true);
                        //APP
                        $key = "user:prop:{'app'}{$user_id}:{$video_id}:{$prop_id}";
                        $app_user_prop = $GLOBALS['cache']->get($key, true);
                        if ($app_user_prop && $is_plus == 1) {
                            $app_plus_num = $app_user_prop['num'] + 1;
                        } else {
                            $app_plus_num = 1;
                        }
                        $ext['app_plus_num'] = $app_plus_num;
                        // app 上传 is_plus 视为连发
                        $GLOBALS['cache']->set($key, array('num' => $app_plus_num), 86400, true);
                        //    $lucky_sum = $app_plus_num;
                    } else {
                        $ext['app_plus_num'] = 1;
                    }

                    //幸运礼物中奖通知字段 status 1是幸运礼物  is_winning 1是中奖  is_broadcast1全服飘屏
                    if ($prop['is_lucky'] == 1) {
                        $lucky = $this->get_lucky($user_id, $prop_id, $podcast_id, $lucky_sum);
                    }

                    $ext['is_animated'] = $prop['is_animated'];//1:动画；0：未动画
                    $ext['animated_url'] = $prop['animated_url'];//svga动画礼物

                    //消息发送者
                    $sender = array();
                    $sender['user_id'] = $user_id;//发送人昵称
                    $sender['nick_name'] = emoji_decode($user_info['nick_name']);//发送人昵称
                    $sender['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
                    $sender['user_level'] = $user_info['user_level'];//用户等级
                    $sender['v_icon'] = $user_info['v_icon'];//认证图标
                    $sender['is_vip'] = $is_vip; //是否是vip


                    /*守护*/
                    $sender['is_guardian'] = $guardian_user ? 1 : 0; //是否是守护
                    $sender['guardian_img'] = $guardian_info ? $guardian_info['img'] : ''; //守护图标
                    $sender['guardian_skin'] = $guardian['barrage']; //是否有守护专属弹幕
                    $sender['guardian_icon'] = $guardian['icon']; //是否有守护身份标识


                    //是否是贵族和到期时间
                    $noble_name = '';//贵族名称
                    $noble_icon = '';//贵族图标
                    $noble_avatar = '';//贵族头像图片
                    $noble_barrage = 0; //是否有贵族弹幕特权
                    $is_stealth = 0; //是否有隐身功能
                    $noble_vip_type = 0;//是否贵族 0不是；1是
                    $is_noble_stealth = 0;//是否开启隐身 1是；0否
                    $is_noble_mysterious = 0;//是否开启神秘人 1是 0否
                    if ($user_info['noble_time'] >= NOW_TIME && $user_info['nobleid'] > 0) {
                        //获取贵族权限
                        $jurisdiction = load_auto_cache("noble_id", ['id' => $user_info['nobleid']]);
                        if ($jurisdiction) {
                            $noble_name = $jurisdiction['name'];            //贵族名称
                            $noble_icon = $jurisdiction['icon'];         //贵族图标
                            $noble_avatar = $jurisdiction['avatar_img'];   //贵族头像图片
                            $is_stealth = $jurisdiction['is_stealth_approach'] == 1 ? 1 : 0;  //是否有隐身功能
                        }
                        $noble_vip_type = 1;//是否贵族 0不是；1是
                        $is_noble_stealth = $user_info['is_noble_stealth'];    //是否有开启隐身
                        $is_noble_mysterious = $user_info['is_noble_mysterious']; //是否开启神秘人
                    }

                    $sender['noble_vip_type'] = $noble_vip_type;    //是否贵族 0不是；1是
                    $sender['is_stealth'] = $is_stealth;    //是否有隐身功能
                    $sender['is_noble_stealth'] = $is_noble_stealth;    //是否有开启隐身
                    $sender['is_noble_mysterious'] = $is_noble_mysterious;    //是否有开启神秘人
                    $sender['noble_name'] = $noble_name;    //贵族名称
                    $sender['noble_icon'] = $noble_icon;    //贵族图标
                    $sender['noble_avatar'] = $noble_avatar;    //贵族头像图片
                    $sender['noble_barrage'] = $noble_barrage;    //是否有贵族弹幕特权
                    $ext['sender'] = $sender;


                    //获取主播当日人气值
                    $table = createPropTable();

                    $day = to_date(NOW_TIME, 'Y-m-d');

                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoGiftRedisService.php');
                    $video_gift_redis = new VideoGiftRedisService();
                    if ($podcast_id == $video['user_id']) {
                        //查询今日给此主播的贡献值
                        $video_gift_redis->inc_redis_field($table . "_" . $day . "_" . $video_id . "_" . $podcast_id, $user_id, $total_diamonds);
                    }
                    //查询今日给此主播的贡献值
                    $video_gift_redis->inc_redis_field($table . "_" . $day . "_" . $video_id, $podcast_id, $total_diamonds);
                    //主播当日人气值
                    $total_num = $video_gift_redis->getOne_gift_db($table . "_" . $day . "_" . $video_id, $podcast_id);

//                    $sql = "select sum(v.total_ticket) as num from " . $table . " as v LEFT JOIN  " . DB_PREFIX . "user as u on u.id = v.from_user_id where v.prop_id<>12 and v.create_ym=" . to_date(NOW_TIME, 'Ym') . " and v.create_d=" . to_date(NOW_TIME, 'd') . " and v.to_user_id = " . $podcast_id . ' and v.video_id = ' . $video_id;
//                    $total_num = $GLOBALS['db']->getOne($sql, true, true);
                    $ext['total_num'] = $total_num > 0 ? format_for_ten_thousand($total_num) : 0; //主播当日人气值
                    $ext['charm_total_num'] = intval($total_num);
                    // 赠送的总钻石数
                    $ext['total_diamonds'] = $total_diamonds;

                    if ($type == 1) {
                        $ext['prop_id'] = $prop_id; //礼物id
                        //$ext['animated_url'] = $prop['animated_url'];//动画播放url
                        $ext['icon'] = get_spec_image($prop['icon']);//图片，是否要: 大中小格式？
                        //$ext['is_red_envelope'] = $prop['is_red_envelope'];//是否是：红包；1:红包
                        $ext['user_prop_id'] = $user_prop_id; //红包时用到，抢红包的id
                        //$ext['show_num'] = $show_num;//显示连续送的礼物数量;

                        $fields = array('ticket', 'no_ticket','nick_name', 'refund_ticket');
                        $user_info1 = $user_redis->getRow_db($podcast_id, $fields);//用户总的：印票数

                        $ext['total_ticket'] = $user_info1['ticket'] + $user_info1['no_ticket'];//用户总的：印票数
                        //直播间显示主播实际可提现印票（客户定制，标准版保留此功能）
//                        if(1){
//                            $ext['total_ticket'] = $ext['total_ticket'] - intval($user_info['refund_ticket']);
//                        }

                        $ext['prop_coin'] = $prop['diamonds']*$num;
                        $ext['to_user_id'] = $podcast_id;//礼物接收人（主播）
                        $ext['fonts_color'] = '';//字体颜色
                        $ext['desc'] = $desc;//普通群员收到的提示内容;
                        $ext['desc2'] = $desc2;//礼物接收人（主播）收到的提示内容;
                        $ext['anim_type'] = $prop['anim_type'] ? $prop['anim_type'] : 1;//大型道具类型;
                        // A 用户 赠送 礼物名称 给 B 用户

                        $str = api_lang("gift_msg");
                        $str = str_replace("{uname}", emoji_decode($sender['nick_name']), $str);
                        $str = str_replace("{gift_name}", $prop['name'], $str);
                        $newStr = str_replace("{tname}", emoji_decode($user_info1['nick_name']), $str);

                        $ext['top_title'] = $newStr;//大型道具类型，标题;

                        $ext['anim_cfg'] = $prop['anim_cfg'];
                    } else {
                        $ext['prop_id'] = $prop_id; //礼物id
                        //$ext['animated_url'] = $prop['animated_url'];//动画播放url
                        $ext['icon'] = get_spec_image($prop['icon']);//图片，是否要: 大中小格式？
                        //$ext['is_red_envelope'] = $prop['is_red_envelope'];//是否是：红包；1:红包
                        $ext['user_prop_id'] = $user_prop_id; //红包时用到，抢红包的id
                        //$ext['show_num'] = $show_num;//显示连续送的礼物数量;
                        $ext['total_ticket'] = intval($user_redis->getOne_db($podcast_id, 'ticket'));//用户总的：印票数
                        $ext['to_user_id'] = $podcast_id;//礼物接收人（主播）
                        $ext['to_diamonds'] = $total_ticket;//礼物接收人（主播）,获得的：钻石 数量
                        $ext['fonts_color'] = '';//字体颜色
                        $ext['desc'] = $desc;//普通群员收到的提示内容;
                        $ext['desc2'] = $desc2;//礼物接收人（主播）收到的提示内容;

                        $allot_diamonds = 0;
                        if ($prop['is_red_envelope'] == 1 && $room_type == 1) {

                        } else {
                            if ($robot_diamonds > 0) {
                                //优先分配给：观众列表中的机器人
                                $robot_list = $video_redis->get_robot($video_id);

                                $robot_num = count($robot_list);
                                if ($robot_num > 0) {
                                    //给一半以上的机器 人分配
                                    $robot_num = mt_rand(ceil($robot_num / 2), $robot_num);
                                    //可分配的钻石小于机器人数1.3倍时,减少分配人数
                                    if ($robot_num * 1.3 > $robot_diamonds) $robot_num = ceil($robot_diamonds / 2);

                                    $diamonds_list = $this->red_rand_list2($robot_diamonds, $robot_num);

                                    while (count($diamonds_list) > 0) {
                                        $money = $diamonds_list[0];
                                        array_splice($diamonds_list, 0, 1);

                                        $robot_num = count($robot_list) - 1;
                                        $r = mt_rand(0, $robot_num);
                                        $robot_userid = $robot_list[$r];

                                        array_splice($robot_list, $r, 1);

                                        //实际分配的
                                        $allot_diamonds = $allot_diamonds + $money;

                                        allot_red_to_user($user_prop_id, $robot_userid, $money);
                                    }
                                }
                            }
                        }

                        //生成一个随机红包队列（观众可抢钻石=diamonds-ticket-robot_diamods)
                        $money_list = $this->red_rand_list($total_diamonds - $total_ticket - $allot_diamonds);
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
                        $videoRed_redis = new VideoRedRedisService();
                        $videoRed_redis->push_red($user_prop_id, $money_list);

                        //记录直播间发的：红包 记录; 主要用于,直播结束后,处理还未被领取的红包
                        $video_redis->add_red($video_id, $user_prop_id);
                    }

                    #构造高级接口所需参数
                    $msg_content = array();
                    //创建array 所需元素
                    $msg_content_elem = array(
                        'MsgType'    => 'TIMCustomElem',       //自定义类型
                        'MsgContent' => array(
                            'Data' => json_encode($ext),
                            'Desc' => '',
                            //  'Ext' => $ext,
                            //  'Sound' => '',
                        )
                    );
                    //将创建的元素$msg_content_elem, 加入array $msg_content
                    array_push($msg_content, $msg_content_elem);

                    $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);
                    if ($ret['ActionStatus'] == 'FAIL' && $ret['ErrorCode'] == 10002) {
                        //10002 系统错误，请再次尝试或联系技术客服。
                        log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
                        $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);
                    }

                    $GLOBALS['db']->autoExecute($table, $ret, 'UPDATE', 'id=' . $user_prop_id);

                    //$videoGift_redis->update_db($user_prop_id, $ret);
                    if (defined('PROP_NOTIFY') && PROP_NOTIFY == 1) {
                        //$prop['anim_type'] != '' ||
                        if ($type == 1 && $prop['is_all_notify'] == 1) //判断开关是否开启,是否为大型礼物
                        {
                            $m_config = load_auto_cache('m_config');
                            $root['is_notify'] = intval($m_config['is_prop_notify']);   //判断后台是否开启这个功能
                            if ($root['is_notify']) {
                                //获取房间类型
                                $sql1 = "SELECT room_type FROM " . DB_PREFIX . "video WHERE id=" . $video_id;
                                $room_type = $GLOBALS['db']->getOne($sql1, true, true);
                                $sql2 = "SELECT live_in FROM " . DB_PREFIX . "video WHERE id=" . $video_id;
                                $live_type = $GLOBALS['db']->getOne($sql2, true, true);
                                if ($room_type != 1 && $live_type != 3)    //判定房间是否为私有房间或回播的房间
                                {
                                    bogo_require(APP_ROOT_PATH . 'mapi/lib/core/prop_notify.php');
                                    $to_user_info = $user_redis->getRow_db($podcast_id, array('id', 'nick_name', 'head_image'));
                                    $root[] = propNotify($sender,$to_user_info, $ext, $prop);  //执行全服通告
                                }
                            }
                            $root['is_notify'] = intval($m_config['is_prop_notify']);
                        }
                    }
                    $fields = array('user_level');
                    $user_info = $user_redis->getRow_db($user_id, $fields);//用户总的：印票数
                    $root['error'] = '';
                    $root['status'] = 1;
                    $root['user_level'] = $user_info['user_level'];

                    //幸运礼物推送消息，推送到当前房间，暂时不要推送全频道除非有好的方案不造成接口卡顿
                    if ($lucky && $lucky['is_winning'] == 1 && $lucky['status'] == 1 && $lucky['is_broadcast'] == 1) {

                        //$video = $GLOBALS['db']->getAll("SELECT id,group_id,prop_table,room_type FROM " . DB_PREFIX . "video where (live_in=1 or live_in=3)");

                        $lucky_ext = array();
                        $lucky_ext['type'] = 88; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束  83:中奖通知
                        //消息发送者
                        $lucky_sender = array();
                        $lucky_sender['user_id'] = $user_id;//发送人昵称
                        $lucky_sender['nick_name'] = emoji_decode($user_info['nick_name']);//发送人昵称
                        $lucky_sender['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
                        $lucky_sender['user_level'] = $user_info['user_level'];//用户等级

                        $lucky_ext['text'] = api_lang("give") . $lucky['name'] . " X" . $lucky['num'] . api_lang("Win_a_prize") . $lucky['user_multiple'] . api_lang("times");//中奖内容
                        $lucky_ext['user_money'] = $lucky['user_money'];          //中奖金额
                        $lucky_ext['user_multiple'] = $lucky['user_multiple'];   //中奖倍数
                        $lucky_ext['num'] = $lucky['num'];                   //赠送礼物数量

                        $lucky_ext['room_id'] = $video_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                        $lucky_ext['sender'] = $lucky_sender;
                        #构造高级接口所需参数
                        $lucky_msg_content = array();
                        //创建array 所需元素
                        $lucky_msg_content_elem = array(
                            'MsgType'    => 'TIMCustomElem',       //自定义类型
                            'MsgContent' => array(
                                'Data' => json_encode($lucky_ext),
                                'Desc' => '',
                            )
                        );
                        //将创建的元素$msg_content_elem, 加入array $msg_content
                        array_push($lucky_msg_content, $lucky_msg_content_elem);
                        $api->group_send_group_msg2($user_info['id'], $group_id, $lucky_msg_content);

                        //幸运礼物中奖钻石数量
                        //print_r($lucky);exit;
                        $root['user_diamonds'] = $user_info['diamonds'];
                    }


                } else {
                    $GLOBALS['db']->Rollback($pInTrans);
                    $root['error'] = $is_coins ? api_lang("Insufficient_game_currency") : $m_config['diamonds_name'] . api_lang("Insufficient");
                    $root['status'] = 0;
                }
            }


        } catch (Exception $e) {
            //异常回滚
            $root['error'] = $e->getMessage();
            $root['status'] = 0;
            $GLOBALS['db']->Rollback($pInTrans);
        }
        if (defined('OPEN_MISSION') && OPEN_MISSION) {
            require_once APP_ROOT_PATH . 'mapi/lib/core/Model.class.php';
            Model::$lib = dirname(__FILE__);
            Model::build('mission')->incProgress($user_id, 2);
        }
        return $root;
    }

    /**
     * 增加家族收益
     * uid 消费者
     * to_uid 主播
     * coin 消费价格
     * */
    public function add_family_income($video_id, $to_uid, $coin,$total_ticket)
    {
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $to_user_info = $user_redis->getRow_db($to_uid, array('family_id'));
        //是否有家族
        $data = array(
            'family_income' => 0,
            'family_id'     => 0,
        );
        if ($to_user_info['family_id']) {
            // 增加家族收益
            $return_family_income = family_receipts($to_uid, $to_user_info['family_id'], intval($total_ticket), $video_id,0,0,intval($coin));
            $data = array(
                'family_income' => $return_family_income,
                'family_id'     => $to_user_info['family_id'],
            );
        }
        return $data;
    }

    /**
     * 处理麦位上收益
     * @param $video_id
     * @param $user_id
     * @param $coin
     * @return mixed
     */
    public function add_wheat_earnings($video_id, $user_id, $coin)
    {
        $where = "video_id=" . $video_id . " and user_id=" . $user_id . " and status=1";
        //减少用户游戏币
        $sql = "update " . DB_PREFIX . "voice_even_wheat_log set gift_earnings = gift_earnings + " . $coin . " where " . $where;
        $GLOBALS['db']->query($sql);
    }

    /**
     * 邀请码分销
     * @param $user_id
     * @param $total_ticket
     * @param $prop_id
     */

    private function check_invite($user_id, $total_ticket, $prop_id)
    {

        $m_config = load_auto_cache('m_config');
        if ($m_config['invite_host_ratio'] <= 0 || $m_config['invite_host_ratio'] > 1) {
            return;
        }

        $ratio = round($total_ticket * $m_config['invite_host_ratio'], 2);
        if ($ratio <= 0) {
            return;
        }

        $invite_by_user_id = $GLOBALS['db']->getOne("select p_user_id from bogo_user where id = {$user_id}");
        if ($invite_by_user_id <= 0) {
            return;
        }

        $invite_user = $GLOBALS['db']->getRow("select is_effect,is_authentication from " . DB_PREFIX . "user where id = {$invite_by_user_id}");
        if (!$invite_user['is_effect'] && $invite_user['is_authentication'] == 2) {
            return;
        }

        $GLOBALS['db']->query("update " . DB_PREFIX . "user set ticket = ticket + " . $ratio . " where id = " . $invite_by_user_id);

        $video_prop = array(
            'from_user_id' => $user_id,
            'to_user_id'   => $invite_by_user_id,
            'create_date'  => "'" . to_date(NOW_TIME, 'Y-m-d') . "'",
            'diamonds'     => $ratio,
            'create_time'  => NOW_TIME,
            'create_ym'    => to_date(NOW_TIME, 'Ym'),
            'create_d'     => to_date(NOW_TIME, 'd'),
            'create_w'     => to_date(NOW_TIME, 'W'),
            'type'         => 2
        );

        $field_arr = array(
            'from_user_id',
            'to_user_id',
            'create_date',
            'diamonds',
            'create_time',
            'create_ym',
            'create_d',
            'create_w',
            'type'
        );
        $fields = implode(",", $field_arr);
        $valus = implode(",", $video_prop);
        $sql = "insert into " . DB_PREFIX . "distribution_log(" . $fields . ") VALUES (" . $valus . ")";
        $GLOBALS['db']->query($sql);
        $GLOBALS['db']->insert_id();
        user_deal_to_reids(array($invite_by_user_id));
    }


    /**
     * 弹幕消息接口
     */
    public function pop_msg()
    {
        $root = array();
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //$user_id = intval($GLOBALS['user_info']['id']);
            $room_id = strim($_REQUEST['room_id']);//直播ID 也是room_id
            $msg = strim($_REQUEST['msg']);//消息内容8J+UkQ==
            //$to_user_id = intval($_REQUEST['to_user_id']);//群主ID

            $user_info= $GLOBALS['db']->getRow("SELECT is_nospeaking,is_vip,vip_expire_time,noble_time,nobleid,ticket,no_ticket,nick_name,head_image,user_level,is_noble_stealth,is_noble_mysterious,v_icon FROM " . DB_PREFIX . "user WHERE id=" . $user_id);
            if ($user_info['is_nospeaking']) {
                $root['status'] = 0;
                $root['error'] = api_lang("Be_forbidden_to_send_message");
                ajax_return($root);
            }

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $video = $video_redis->getRow_db($room_id, array('id', 'user_id', 'group_id', 'prop_table'));

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            $group_id = strim($video['group_id']);//群组ID

            $podcast_id = intval($video['user_id']);//送给谁，有群组ID(group_id)，除了红包外其它的都是送给：群主

            $m_config = load_auto_cache("m_config");//初始化手机端配置

            //获取是否是守护者
            $guardian_user = redis_get("guardian_host_".$podcast_id."_user_".$user_id);
            //会员
            $is_vip = $user_info['vip_expire_time'] > NOW_TIME && $user_info['is_vip'] ? 1 : 0;

            $guardian = ['barrage' => 0, 'icon' => 0];
            if ($guardian_user) {
                $guardian_user = json_decode($guardian_user,true);
                if($guardian_user){
                    //守护特权
                    $guardian = $this->get_guardians_barrage(intval($guardian_user['classification_id']));  //是否有开通守护弹幕
                }
            }

            //主播,自己发送 弹幕 消息,不扣钻石  守护者开通守护弹幕权限不扣钻石
            if ($podcast_id == $user_id || $guardian_user || $is_vip || intval($m_config['barrage_coin']) <= 0) {
                $ext = array();
                $ext['type'] = 2; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束
                $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                $ext['num'] = 1;
                $ext['prop_id'] = 0; //礼物id
                //s$ext['animated_url'] = '';//动画播放url
                $ext['icon'] = '';//图片，是否要: 大中小格式？
                //$ext['is_red_envelope'] = 0;//是否是：红包；1:红包
                $ext['user_prop_id'] = 0; //红包时用到，抢红包的id
                //$ext['show_num'] = 1;//显示连续送的礼物数量;
                $fields = array('ticket', 'no_ticket', 'refund_ticket');
                $user_info2 = $user_redis->getRow_db($podcast_id, $fields);//用户总的：印票数
                $ext['total_ticket'] = intval($user_info2['ticket']) + intval($user_info2['no_ticket']);//用户总的：印票数
                //直播间显示主播实际可提现印票（客户定制，标准版保留此功能）
                $ext['to_user_id'] = 0;//礼物接收人（主播）
                $ext['fonts_color'] = '';//字体颜色
                $ext['desc'] = $msg;//弹幕消息;
                $ext['desc2'] = $msg;//弹幕消息;
                //消息发送者
                $sender = array();

                /*是否是贵族和到期时间*/
                $noble_name = '';            //贵族名称
                $noble_icon = '';         //贵族图标
                $noble_avatar = '';   //贵族头像图片
                $noble_barrage = 0; //是否有贵族弹幕特权
                $is_stealth = 0; //是否有隐身功能
                $is_noble_mysterious = 0; //是否开启了神秘人0否1是
                $noble_vip_type = 0; //是否贵族 0不是，1是

                if ($user_info['noble_time'] >= NOW_TIME && $user_info['nobleid'] > 0) {
                    //获取贵族权限
                    $jurisdiction = load_auto_cache("noble_id", ['id' => $user_info['nobleid']]);
                    if ($jurisdiction) {
                        $noble_name = $jurisdiction['name'];            //贵族名称
                        $noble_icon = $jurisdiction['icon'];         //贵族图标
                        $noble_avatar = $jurisdiction['avatar_img'];   //贵族头像图片
                        $is_stealth = $jurisdiction['is_stealth_approach'] == 1 ? 1 : 0;  //是否有隐身功能
                    }

                    $noble_vip_type = 1;//是否贵族 0不是；1是
                    $is_noble_stealth = $user_info['is_noble_stealth'];    //是否有开启隐身
                    $is_noble_mysterious = $user_info['is_noble_mysterious']; //是否开启神秘人
                }

                $sender['user_id'] = $user_id;//发送人昵称
                $sender['nick_name'] = emoji_decode($user_info['nick_name']);//发送人昵称
                $sender['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
                $sender['user_level'] = $user_info['user_level'];//用户等级
                $sender['v_icon'] = $user_info['v_icon'];//认证图标

                $sender['is_vip'] = $is_vip; //是否是vip

                $sender['noble_vip_type'] = $noble_vip_type; //是否贵族 0不是，1是
                $sender['noble_name'] = $noble_name;         //贵族名称
                $sender['noble_icon'] = $noble_icon;         //贵族图标
                $sender['noble_avatar'] = $noble_avatar;     //贵族头像图片
                $sender['noble_barrage'] = $noble_barrage;    //是否有贵族弹幕特权
                $sender['is_stealth'] = $is_stealth;    //是否有隐身功能
                $sender['is_noble_stealth'] = $user_info['is_noble_stealth'];    //是否有开启隐身
                $sender['is_noble_mysterious'] = $is_noble_mysterious;    //是否有开启隐身


                /*守护*/
                $sender['is_guardian'] = $guardian_user ? 1 : 0; //是否是守护
                $sender['guardian_img'] = $guardian_user ? $guardian_user['img'] : ''; //守护图标
                $sender['guardian_skin'] = $guardian['barrage']; //是否有守护专属弹幕
                $sender['guardian_icon'] = $guardian['icon']; //是否有守护身份标识


                $ext['sender'] = $sender;


                #构造高级接口所需参数
                $msg_content = array();
                //创建array 所需元素
                $msg_content_elem = array(
                    'MsgType'    => 'TIMCustomElem',       //自定义类型
                    'MsgContent' => array(
                        'Data' => json_encode($ext),
                        'Desc' => '',
                        //  'Ext' => $ext,
                        //  'Sound' => '',
                    )
                );

                if (intval($m_config['has_dirty_words']) == 1) {
                    //文档内容,用来过滤脏字
                    $msg_text_elem = array(
                        'MsgType'    => 'TIMTextElem', //
                        'MsgContent' => array(
                            'Text' => $msg,
                        )
                    );
                    array_push($msg_content, $msg_text_elem, $msg_content_elem);
                } else {
                    //将创建的元素$msg_content_elem, 加入array $msg_content
                    array_push($msg_content, $msg_content_elem);
                }

                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();
                $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);

                if ($ret['ActionStatus'] == 'FAIL') {
                    log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
                    if ($ret['ErrorCode'] == 80001) {
                        $root['error'] = api_lang("The_word_is_disabled");
                    } else {
                        $root['error'] = $ret['ErrorInfo'] . ":" . $ret['ErrorCode'];
                    }
                    $root['status'] = 0;
                } else {
                    $root['error'] = '';
                    $root['status'] = 0;//app端通过这个判断是否扣除钻石，1为扣除
                }
            } else {

                //$sql = "select id from ".DB_PREFIX."video_forbid_send_msg where group_id='".$group_id."' and user_id = ".$user_id;
                //$has_forbid = $GLOBALS['db']->getOne($sql,true,true) > 0;

                $has_forbid = $video_redis->has_forbid_msg2($group_id, $user_id);
                if ($has_forbid) {
                    $root['error'] = api_lang("Be_forbidden_to_send_message");
                    $root['status'] = 0;
                } else {

                    $p_id = $podcast_id;

                    $total_diamonds = $m_config['barrage_coin'];
                    $total_score = $m_config['barrage_coin'];
                    $total_ticket = $m_config['barrage_coin'];
                    $pInTrans = $GLOBALS['db']->StartTrans();
                    try {
                        $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $total_diamonds . ",use_diamonds = use_diamonds + " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and diamonds >= " . $total_diamonds;
                        $GLOBALS['db']->query($sql);
                        if ($GLOBALS['db']->affected_rows()) {
                            if ($total_ticket > 0) {
                                if (defined("robot_gifts") && robot_gifts == 1) {
                                    $roboter = $GLOBALS['db']->getOne("select roboter from " . DB_PREFIX . "user where roboter=1 and id=" . $user_id);//查询是否特殊权限用户
                                    if ($roboter) {
                                        //增加：不可提现印票
                                        $sql = "update " . DB_PREFIX . "user set no_ticket = no_ticket + " . $total_ticket . " where id = " . $p_id;
                                        $GLOBALS['db']->query($sql);

                                    } else {
                                        //增加：用户印票
                                        $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $p_id;
                                        $GLOBALS['db']->query($sql);
                                    }
                                } else {
                                    //增加：用户印票
                                    $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $p_id;
                                    $GLOBALS['db']->query($sql);
                                }
                            }
                            // 消费和收益记录表
                            add_user_consumption_log($user_id, $p_id, $total_diamonds, api_lang('bullet_chat'), $total_ticket, 0, 6);
                            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoGiftRedisService.php');
                            $video_gift_redis = new VideoGiftRedisService();
                            //获取主播当日人气值
                            $table1 = createPropTable();
                            $day = to_date(NOW_TIME, 'Y-m-d');
                            //查询今日给此主播的贡献值 $room_id, $podcast_id
                            $video_gift_redis->inc_redis_field($table1 . "_" . $day . "_" . $room_id, $p_id, $total_diamonds);

                            $video_prop = array();
                            $video_prop['prop_id'] = 0;
                            $video_prop['prop_name'] = "'" . api_lang("bullet_chat") . "'";
                            $video_prop['is_red_envelope'] = 0;
                            $video_prop['total_score'] = $total_score;
                            $video_prop['total_diamonds'] = $total_diamonds;
                            $video_prop['total_ticket'] = intval($total_ticket);
                            $video_prop['from_user_id'] = $user_id;
                            $video_prop['to_user_id'] = $podcast_id;
                            $video_prop['create_time'] = NOW_TIME;
                            $video_prop['create_date'] = "'" . to_date(NOW_TIME, 'Y-m-d') . "'";
                            $video_prop['num'] = 1;
                            $video_prop['video_id'] = $room_id;
                            $video_prop['group_id'] = "'" . $group_id . "'";
                            $video_prop['msg'] = "'" . $msg . "'";

                            $video_prop['create_ym'] = to_date($video_prop['create_time'], 'Ym');
                            $video_prop['create_d'] = to_date($video_prop['create_time'], 'd');
                            $video_prop['create_w'] = to_date($video_prop['create_time'], 'W');
                            $video_prop['from_ip'] = "'" . get_client_ip() . "'";
                            //将礼物写入mysql表中
                            $field_arr = array(
                                'prop_id',
                                'prop_name',
                                'is_red_envelope',
                                'total_score',
                                'total_diamonds',
                                'total_ticket',
                                'from_user_id',
                                'to_user_id',
                                'create_time',
                                'create_date',
                                'num',
                                'video_id',
                                'group_id',
                                'msg',
                                'create_ym',
                                'create_d',
                                'create_w',
                                'from_ip'
                            );
                            $fields = implode(",", $field_arr);
                            $valus = implode(",", $video_prop);

                            $table = $video['prop_table'];
                            $table_info = $GLOBALS['db']->getRow("Describe " . $table . " from_ip", true, true);
                            if (!$table_info) {
                                $GLOBALS['db']->query("ALTER TABLE " . $table . " ADD COLUMN `from_ip` varchar(255) NOT NULL  COMMENT '送礼物人IP'");
                            }
                            $sql = "insert into " . $table . "(" . $fields . ") VALUES (" . $valus . ")";
                            $GLOBALS['db']->query($sql);
                            $user_prop_id = $GLOBALS['db']->insert_id();

                            //写入总表
                            if (file_exists(APP_ROOT_PATH . 'mapi/lib/core/award_function.php')) {
                                bogo_require(APP_ROOT_PATH . 'mapi/lib/core/award_function.php');
                                $table_all = createPropAllTable();
                                $sql = "insert into " . $table_all . " (" . $fields . ") VALUES (" . $valus . ")";
                                $GLOBALS['db']->query($sql);
                            }

                            //提交事务,不等 消息推送,防止锁太久
                            $GLOBALS['db']->Commit($pInTrans);
                            $pInTrans = false;//防止，下面异常时，还调用：Rollback

                            if ($total_diamonds > 0) {
                                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoContributionRedisService.php');
                                $videoCont_redis = new VideoContributionRedisService();
                                $videoCont_redis->insert_db($user_id, $podcast_id, $room_id, $total_diamonds);
                            }

                            user_deal_to_reids(array($user_id, $podcast_id));

                            //更新用户等级
                            $user_info2 = $user_redis->getRow_db($user_id,
                                array('id', 'score', 'online_time', 'user_level'));
                            user_leverl_syn($user_info2);

                            //分销功能 计算抽成
                            if (defined('OPEN_DISTRIBUTION') && OPEN_DISTRIBUTION == 1 && $total_ticket > 0) {
                                $this->distribution_calculate($user_id, $total_ticket);
                            }
                            $this->distribution($podcast_id, $room_id, $total_ticket);
                            //发送:礼物


                            $ext = array();
                            $ext['type'] = 2; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束
                            $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                            $ext['num'] = 1;
                            $ext['prop_id'] = 0; //礼物id
                            //s$ext['animated_url'] = '';//动画播放url
                            $ext['icon'] = '';//图片，是否要: 大中小格式？
                            //$ext['is_red_envelope'] = 0;//是否是：红包；1:红包
                            $ext['user_prop_id'] = $user_prop_id; //红包时用到，抢红包的id
                            //$ext['show_num'] = 1;//显示连续送的礼物数量;
                            $fields = array('ticket', 'no_ticket');
                            $user_info1 = $user_redis->getRow_db($podcast_id, $fields);//用户总的：印票数
                            $ext['total_ticket'] = $user_info1['ticket'] + $user_info1['no_ticket'];//用户总的：印票数
//                            $ext['total_ticket'] = intval($user_redis->getOne_db($podcast_id, 'ticket'));//用户总的：印票数
                            $ext['to_user_id'] = 0;//礼物接收人（主播）
                            $ext['fonts_color'] = '';//字体颜色
                            $ext['desc'] = $msg;//弹幕消息;
                            $ext['desc2'] = $msg;//弹幕消息;

                            //消息发送者
                            $sender = array();
                            /*是否是贵族和到期时间*/
                            $noble_name = '';            //贵族名称
                            $noble_icon = '';         //贵族图标
                            $noble_avatar = '';   //贵族头像图片
                            $noble_barrage = 0; //是否有贵族弹幕特权
                            $is_stealth = 0; //是否有隐身功能
                            $is_noble_mysterious = 0; //是否开启了神秘人0否1是
                            $noble_vip_type = 0; //是否贵族 0 否；1是

                            if ($user_info['noble_time'] >= NOW_TIME && $user_info['nobleid'] > 0) {
                                //获取贵族权限
                                $jurisdiction = load_auto_cache("noble_id", ['id' => $user_info['nobleid']]);
                                if ($jurisdiction) {
                                    $noble_name = $jurisdiction['name'];            //贵族名称
                                    $noble_icon = $jurisdiction['icon'];         //贵族图标
                                    $noble_avatar = $jurisdiction['avatar_img'];   //贵族头像图片
                                    $is_stealth = $jurisdiction['is_stealth_approach'] == 1 ? 1 : 0;  //是否有隐身功能
                                }
                                $noble_vip_type = 1;//是否贵族 0不是；1是
                                $is_noble_mysterious = $user_info['is_noble_mysterious']; //是否开启神秘人
                            }

                            $sender['user_id'] = $user_id;//发送人昵称
                            $sender['nick_name'] = emoji_decode($user_info['nick_name']);//发送人昵称
                            $sender['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
                            $sender['user_level'] = $user_info['user_level'];//用户等级
                            $sender['is_vip'] = $is_vip; //是否是vip


                            $sender['noble_vip_type'] = $noble_vip_type;    //是否贵族 0 否；1是
                            $sender['noble_name'] = $noble_name;         //贵族名称
                            $sender['noble_icon'] = $noble_icon;         //贵族图标
                            $sender['noble_avatar'] = $noble_avatar;     //贵族头像图片
                            $sender['noble_barrage'] = $noble_barrage;    //是否有贵族弹幕特权
                            $sender['is_stealth'] = $is_stealth;    //是否有隐身功能
                            $sender['is_noble_stealth'] = $user_info['is_noble_stealth'];    //是否有开启隐身
                            $sender['is_noble_mysterious'] = $is_noble_mysterious;    //是否开启了神秘人0否1是


                            /*守护*/
                            $sender['is_guardian'] = $guardian_user ? 1 : 0; //是否是守护
                            $sender['guardian_img'] = $guardian_user ? $guardian_user['img'] : ''; //守护图标
                            $sender['guardian_skin'] = $guardian['barrage']; //是否有守护专属弹幕
                            $sender['guardian_icon'] = $guardian['icon']; //是否有守护身份标识


                            $ext['sender'] = $sender;
                            //主播当日人气值
                            $total_num = $video_gift_redis->getOne_gift_db($table1 . "_" . $day . "_" . $room_id, $podcast_id);
                            $ext['charm_total_num'] = intval($total_num);

                            #构造高级接口所需参数
                            $msg_content = array();
                            //创建array 所需元素
                            $msg_content_elem = array(
                                'MsgType'    => 'TIMCustomElem',       //自定义类型
                                'MsgContent' => array(
                                    'Data' => json_encode($ext),
                                    'Desc' => '',
                                )
                            );


                            if (intval($m_config['has_dirty_words']) == 1) {
                                //文档内容,用来过滤脏字
                                $msg_text_elem = array(
                                    'MsgType'    => 'TIMTextElem', //
                                    'MsgContent' => array(
                                        'Text' => $msg,
                                    )
                                );
                                array_push($msg_content, $msg_text_elem, $msg_content_elem);
                            } else {
                                //将创建的元素$msg_content_elem, 加入array $msg_content
                                array_push($msg_content, $msg_content_elem);
                            }


                            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                            $api = createTimAPI();

                            $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);
                            if ($ret['ActionStatus'] == 'FAIL' && $ret['ErrorCode'] == 10002) {
                                //10002 系统错误，请再次尝试或联系技术客服。
                                log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
                                $ret = $api->group_send_group_msg2($user_id, $group_id, $msg_content);
                            }

                            $GLOBALS['db']->autoExecute($table, $ret, 'UPDATE', 'id=' . $user_prop_id);


                            //$videoGift_redis->update_db($user_prop_id, $ret);


                            if ($ret['ActionStatus'] == 'FAIL') {
                                if ($ret['ErrorCode'] == 80001) {
                                    $root['error'] = api_lang("The_word_is_disabled");
                                } else {
                                    $root['error'] = $ret['ErrorInfo'] . ":" . $ret['ErrorCode'];
                                }
                                $root['status'] = 0;
                            } else {
                                $root['error'] = '';
                                $root['status'] = 1;
                            }
                        } else {
                            $GLOBALS['db']->Rollback($pInTrans);
                            $root['error'] = $m_config['diamonds_name'] . api_lang("Insufficient");
                            $root['status'] = 0;
                        }


                    } catch (Exception $e) {
                        //异常回滚
                        $root['error'] = $e->getMessage();
                        $root['status'] = 0;

                        $GLOBALS['db']->Rollback($pInTrans);
                    }
                }
            }
        }

        ajax_return($root);
    }

    /**
     * 预生成好，红包随机队列
     * @param unknown_type $total_diamonds
     *
     * 0    1
     * 1    20
     * 2    3
     *
     */
    function red_rand_list($total_diamonds)
    {

        $list = array();
        while ($total_diamonds > 0) {
            $diamonds = mt_rand(1, 20);//随机取：1至20中的一个数字

            if ($total_diamonds >= $diamonds) {
                $total_diamonds = $total_diamonds - $diamonds;
                $list[] = $diamonds;
            } else {
                if ($total_diamonds >= 1) {
                    $diamonds = 1;
                    $total_diamonds = $total_diamonds - $diamonds;
                    $list[] = $diamonds;
                }
            }
        }

        return $list;
    }

    /**
     * 把$total_diamonds 生成指定数量$num的，随机列表数
     * @param unknown_type $total_diamonds
     * @param unknown_type $num
     * @return multitype:number
     */
    function red_rand_list2($total_diamonds, $num)
    {
        $list = array();
        if ($num > $total_diamonds) {
            $num = $total_diamonds;
        }

        //先生成一批为：1 的
        for ($x = 0; $x < $num; $x++) {
            $list[] = 1;
            $total_diamonds = $total_diamonds - 1;
        }

        while ($total_diamonds > 0) {
            foreach ($list as $k => $v) {
                $diamonds = mt_rand(1, 19);//随机取：1至20中的一个数字

                if ($total_diamonds >= $diamonds) {
                    $total_diamonds = $total_diamonds - $diamonds;
                } else {
                    if ($total_diamonds >= 1) {
                        $diamonds = 1;
                        $total_diamonds = $total_diamonds - $diamonds;
                    }
                }

                $list[$k] = $v + $diamonds;

                if ($total_diamonds == 0) {
                    break;
                }
            }
        };

        return $list;
    }


    /**
     * 抢红包
     */
    public function red_envelope()
    {

        $root = array();
        $root['status'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);

            $user_prop_id = intval($_REQUEST['user_prop_id']);//红包id

            $m_config = load_auto_cache("m_config");//初始化手机端配置

            //============================redis================================================
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
            $videoRed_redis = new VideoRedRedisService();

            //判断该用户没有抢过;
            $ret = $videoRed_redis->get_user_winning($user_prop_id, $user_id);
            if ($ret == false) {
                //判断是否还有可以抢的红包
                if ($videoRed_redis->red_exists($user_prop_id)) {
                    $money = $videoRed_redis->pop_red($user_prop_id);
                    if ($money > 0) {
                        allot_red_to_user($user_prop_id, $user_id, $money);
                        $root['diamonds'] = $money;

                        $root['error'] = api_lang("Congratulations") . $money . api_lang("individual") . $m_config['diamonds_name'];
                    } else {
                        $root['status'] = 0;
                        $root['error'] = api_lang("Hand_slow_not_found");
                    }
                } else {
                    $root['status'] = 0;
                    $root['error'] = api_lang("Hand_slow_not_found");
                }
            } else {
                $root['diamonds'] = $ret;
                $root['error'] = api_lang("Congratulations") . $ret . api_lang("individual") . $m_config['diamonds_name'];
            }
        }

        ajax_return($root);
    }

    /**
     * 抢红包---》看看大家的手气
     */
    public function user_red_envelope()
    {

        $root = array();
        $root['status'] = 1;
        //$GLOBALS['user_info']['id'] = 278;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_prop_id = intval($_REQUEST['user_prop_id']);//红包id

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
            $videoRed_redis = new VideoRedRedisService();

            $list = $videoRed_redis->get_winnings($user_prop_id);
            foreach ($list as $k => $v) {
                $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
            }


            $root['status'] = 1;

            $root['list'] = $list;

        }
        ajax_return($root);
    }

    /**
     * 送礼物给某人
     */
    public function send_prop()
    {
        $root = array();

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in") . print_r($_COOKIE, 1);
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);

            $prop_id = intval($_REQUEST['prop_id']);//礼物id
            $num = intval($_REQUEST['num']);//礼物数量
            $to_user_id = strim($_REQUEST['to_user_id']);//送给谁

            $user = $GLOBALS['db']->getRow("SELECT is_nospeaking,nobleid,noble_time FROM " . DB_PREFIX . "user WHERE id=" . $user_id,
                true, true);
            if ($user['is_nospeaking']) {
                $root['status'] = 0;
                $root['error'] = api_lang("no_gift_can_be_given");
                ajax_return($root);
            }
            $m_config = load_auto_cache("m_config");//初始化手机端配置

            if ($m_config['give_yourself_gift_switch'] == 0) {
                if ($user_id == $to_user_id) {
                    $root['error'] = api_lang("no_give_yourself_gift");
                    $root['status'] = 0;
                    ajax_return($root);
                }
            }

            //检查测试账号不能发礼物给真实主播
            $sql = "select mobile from " . DB_PREFIX . "user where id = '" . $to_user_id . "'";
            $podcast_mobile = $GLOBALS['db']->getOne($sql);
            if (($GLOBALS['user_info']['mobile'] == '13888888888' && $podcast_mobile != '13999999999') || $GLOBALS['user_info']['mobile'] == '13999999999' && $podcast_mobile != '13888888888') {
                $root['error'] = "测试账号不能发礼物给真实主播";
                $root['status'] = 0;
                ajax_return($root);
            }

            $prop = load_auto_cache("prop_id", array('id' => $prop_id));

            //守护礼物
            if ($prop['type'] == 2) {
                //获取是否是守护者
                $guardian_user = redis_get("guardian_host_".$to_user_id."_user_".$user_id);
                if (!$guardian_user) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("Guard_not_opened");
                    ajax_return($root);
                }
            }

            //判断VIP礼物
            if ($prop['type'] == 3 && $user['is_vip'] != 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("Unable_to_send_VIP_gift");
                ajax_return($root);
            }

            //   var_dump($prop);exit;
            if ($num <= 0) {
                $num = 1;
            }
            $total_diamonds = $num * $prop['diamonds'];
            $total_score = $num * $prop['score'];
            $total_ticket = intval($num * $prop['ticket']);
            //贵族礼物
            if ($prop['type'] == 4) {
                //获取贵族权限
                if ($user['nobleid'] <= 0 || $user['noble_time'] < NOW_TIME) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("No_noble_gifts_sent");
                    ajax_return($root);
                }
                $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
                if ($jurisdiction && $jurisdiction['is_gift'] != 1) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("noble_Insufficient_authority");
                    ajax_return($root);
                }
            }

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            $pInTrans = $GLOBALS['db']->StartTrans();
            try {
                //免费礼物
                if ($total_diamonds == 0 && $total_score == 0 && $total_ticket == 0) {
                    $m_config = load_auto_cache("m_config");//初始化手机端配置
                    $root['to_msg'] = api_lang("Received_one") . $prop['name'] . "," . api_lang("obtain") . $total_ticket . $m_config['ticket_name'] . "," . api_lang("You_can_view_it");
                    $to_diamonds = 0;
                    $to_ticket = intval($total_ticket);
                    $root['from_msg'] = api_lang("One_for_you") . $prop['name'];
                    $root['from_score'] = api_lang("Your_experience") . "+" . $total_score;
                    $root['to_ticket'] = intval($to_ticket);
                    $root['to_diamonds'] = $to_diamonds;//可获得的：钻石数；只有红包时，才有
                    $root['to_user_id'] = $to_user_id;
                    $root['prop_icon'] = $prop['icon'];
                    $root['status'] = 1;
                    $root['prop_id'] = $prop_id;
                    $root['total_ticket'] = intval($user_redis->getOne_db($to_user_id, 'ticket'));//用户总的：印票数
                } else {
                    //私聊送红包礼物没有经验
                    if ($prop['is_red_envelope'] == 1) {
                        $total_score = 0;
                    } else {
                        //是否是贵族和到期时间 是否经验加倍
                        if ($user['noble_time'] >= NOW_TIME && $user['nobleid'] > 0) {
                            $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
                            if ($jurisdiction && $jurisdiction['is_experience'] == 1 && $jurisdiction['experience_val'] > 1) {
                                $total_score = $total_score * $jurisdiction['experience_val'] + $total_score;
                            }
                        }
                    }
                    $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $total_diamonds . ", use_diamonds = use_diamonds + " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and diamonds >= " . $total_diamonds;
                    $GLOBALS['db']->query($sql);
                    //插入:送礼物表
                    $video_prop = array();
                    if ($GLOBALS['db']->affected_rows()) {
                        //将红包的钻石，直接加给被送用户
                        if ($prop['is_red_envelope'] == 1) {
                            //$desc = '我给大家送了一个红包';
                            //$user_redis->lock_diamonds($to_user_id,$total_diamonds);

                            $sql = "update " . DB_PREFIX . "user set diamonds = diamonds + " . $total_diamonds . " where id = " . $to_user_id;
                            $GLOBALS['db']->query($sql);

                            $root['to_msg'] = api_lang("Received_one") . $prop['name'] . "," . api_lang("obtain") . $total_diamonds . $m_config['diamonds_name'] . "," . api_lang("You_can_view_it");

                            $to_diamonds = $total_diamonds;//用户添加的：钻石 数;
                            $to_ticket = 0;
                        } else {
                            $m_config = load_auto_cache("m_config");//初始化手机端配置
                            $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id = " . $to_user_id);
                            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE) {
                                if ($m_config['society_pattern'] == 2) {
                                    //收益归公会长所有
                                    if ($society_info['society_id']) {
                                        $this->soceity_rake($to_user_id, $total_ticket, $user_id);
                                    } else {
                                        $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $to_user_id;
                                        $GLOBALS['db']->query($sql);

                                        //写入用户日志
                                        earnings_log($total_ticket, $society_info['society_id'], 0, 13, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $to_user_id);
                                    }

                                } elseif ($m_config['society_pattern'] == 1) {
                                    //有公会需要增加公会等级积分
                                    if ($society_info['society_id']) {
                                        society_level_syn($total_ticket, 0, $society_info['society_id']);
                                    }
                                    $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $to_user_id;
                                    $GLOBALS['db']->query($sql);

                                    if ($society_info['society_chieftain']) {
                                        $GLOBALS['db']->query("update " . DB_PREFIX . "society set contribution = contribution + $total_ticket where id=" . $society_info['society_id']);
                                        //写入会长日志
                                        earnings_log($total_ticket, $society_info['society_id'], $user_id, 13, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $to_user_id);
                                    } else {
                                        //写入用户日志
                                        earnings_log($total_ticket, $society_info['society_id'], 0, 13, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $to_user_id);
                                    }
                                } else {
                                    $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $to_user_id;
                                    $GLOBALS['db']->query($sql);

                                    //写入用户日志
                                    earnings_log($total_ticket, $society_info['society_id'], 0, 13, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $to_user_id);
                                }
                            } else {
                                $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $to_user_id;
                                $GLOBALS['db']->query($sql);
                                // 家族收益--按照消费数计算
                                $family_one = $this->add_family_income(0, $to_user_id, $total_diamonds,$total_ticket);
                                if ($family_one['family_id'] > 0) {
                                    $video_prop['family_id'] = $family_one['family_id'];
                                    $video_prop['family_income'] = $family_one['family_income'];
                                }
                                //写入用户日志
                                earnings_log($total_ticket, $society_info['society_id'], 0, 13, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $to_user_id);
                            }
                            // 消费和收益记录表 api_lang("individual")
                            add_user_consumption_log($user_id, $to_user_id, $total_diamonds, $num . api_lang("individual") . $prop['name'], $total_ticket);
                            $root['to_msg'] = api_lang("Received_one") . $prop['name'] . "," . api_lang("obtain") . $total_ticket . $m_config['ticket_name'] . "," . api_lang("You_can_view_it");
                            $to_diamonds = 0;
                            $to_ticket = intval($total_ticket);
                        }


                        $this->check_invite($user_id, $total_ticket, $prop_id);

                        //插入:送礼物表
                        $video_prop['prop_id'] = $prop_id;
                        $video_prop['prop_name'] = "'" . $prop['name'] . "'";
                        $video_prop['is_red_envelope'] = $prop['is_red_envelope'];
                        $video_prop['total_score'] = $total_score;
                        $video_prop['total_diamonds'] = $total_diamonds;
                        if ($prop['is_red_envelope'] == 1) {
                            $video_prop['total_ticket'] = intval($total_diamonds);
                        } else {
                            $video_prop['total_ticket'] = intval($total_ticket);
                        }
                        $video_prop['from_user_id'] = $user_id;
                        $video_prop['to_user_id'] = $to_user_id;
                        $video_prop['create_time'] = NOW_TIME;
                        $video_prop['create_date'] = "'" . to_date(NOW_TIME, 'Y-m-d') . "'";
                        $video_prop['num'] = $num;

                        $video_prop['create_ym'] = to_date($video_prop['create_time'], 'Ym');
                        $video_prop['create_d'] = to_date($video_prop['create_time'], 'd');
                        $video_prop['create_w'] = to_date($video_prop['create_time'], 'W');
                        $video_prop['from_ip'] = "'" . get_client_ip() . "'";
                        $video_prop['is_private'] = 1;

                        //将礼物写入mysql表中
                        $field_arr = array(
                            'prop_id',
                            'prop_name',
                            'is_red_envelope',
                            'total_score',
                            'total_diamonds',
                            'total_ticket',
                            'from_user_id',
                            'to_user_id',
                            'create_time',
                            'create_date',
                            'num',
                            'create_ym',
                            'create_d',
                            'create_w',
                            'from_ip',
                            'is_private'
                        );

                        $fields = implode(",", $field_arr);
                        $valus = implode(",", $video_prop);

                        $table = createPropTable();
                        $table_info = $GLOBALS['db']->getRow("Describe " . $table . " from_ip", true, true);
                        if (!$table_info) {
                            $GLOBALS['db']->query("ALTER TABLE " . $table . " ADD COLUMN `from_ip` varchar(255) NOT NULL  COMMENT '送礼物人IP'");
                        }
                        $sql = "insert into " . $table . "(" . $fields . ") VALUES (" . $valus . ")";
                        $GLOBALS['db']->query($sql);
                        $user_prop_id = $GLOBALS['db']->insert_id();
                        //写入总表
                        if (file_exists(APP_ROOT_PATH . 'mapi/lib/core/award_function.php')) {
                            bogo_require(APP_ROOT_PATH . 'mapi/lib/core/award_function.php');
                            $table_all = createPropAllTable();
                            $sql = "insert into " . $table_all . " (" . $fields . ") VALUES (" . $valus . ")";
                            $GLOBALS['db']->query($sql);
                        }
                        //提交事务
                        $GLOBALS['db']->Commit($pInTrans);
                        $pInTrans = false;

                        if ($prop['is_red_envelope'] == 0) {
                            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoContributionRedisService.php');
                            $videoCont_redis = new VideoContributionRedisService();
                            $videoCont_redis->insert_db($user_id, $to_user_id, 0, $total_diamonds);
                        }

                        //分销功能 计算抽成
                        if (defined('OPEN_DISTRIBUTION') && OPEN_DISTRIBUTION == 1 && $prop['is_red_envelope'] == 0 && $total_ticket > 0) {
                            $this->distribution_calculate($user_id, $total_ticket);
                        }
                        $this->distribution($to_user_id, 0, $total_ticket);

                        user_deal_to_reids(array($user_id, $to_user_id));

                        //更新用户等级
                        $user_info = $user_redis->getRow_db($user_id,
                            array('id', 'score', 'online_time', 'user_level'));
                        user_leverl_syn($user_info);


                        $root['from_msg'] = api_lang("One_for_you") . $prop['name'];
                        $root['from_score'] = api_lang("Your_experience") . "+" . $total_score;
                        $root['to_ticket'] = intval($to_ticket);
                        $root['to_diamonds'] = $to_diamonds;//可获得的：钻石数；只有红包时，才有
                        $root['to_user_id'] = $to_user_id;
                        $root['prop_icon'] = $prop['icon'];
                        $root['status'] = 1;
                        $root['prop_id'] = $prop_id;
                        $root['total_ticket'] = intval($user_redis->getOne_db($to_user_id, 'ticket'));//用户总的：印票数


                    } else {
                        $GLOBALS['db']->Rollback($pInTrans);
                        $root['error'] = $m_config['diamonds_name'] . api_lang("Insufficient");
                        $root['status'] = 0;
                    }
                }

                $user_info = $GLOBALS['db']->getRow("select diamonds from " . DB_PREFIX . "user  where id=" . $user_id);
                // 更新余额
                $root['user_diamonds'] = $user_info['diamonds'];

            } catch (Exception $e) {
                //异常回滚
                $root['error'] = $e->getMessage();
                $root['status'] = 0;

                $GLOBALS['db']->Rollback($pInTrans);
            }

        }
        ajax_return($root);
    }

    /**
     * 游戏分销
     * @param $podcast_id
     * @param $video_id
     * @param $total_ticket
     */
    private function distribution($podcast_id, $video_id, $total_ticket)
    {
        require_once APP_ROOT_PATH . 'mapi/lib/core/Model.class.php';
        Model::$lib = dirname(__FILE__);
        if (defined('GAME_DISTRIBUTION') && GAME_DISTRIBUTION) {
            Model::build('game_distribution')->addLog($podcast_id, $video_id, 0, $total_ticket, api_lang("Live_distribution_of_gifts"), 1);
        }
        if (defined('WEIXIN_DISTRIBUTION') && WEIXIN_DISTRIBUTION) {
            Model::build('weixin_distribution_log')->addLog($podcast_id, $total_ticket, api_lang("Live_gift_distribution_wechat"), 1);
        }
    }

    /**
     *  分销抽成
     * @param $user_id
     * @param $total_ticket
     */
    private function distribution_calculate($user_id, $total_ticket)
    {
        $root = array();
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $table = DB_PREFIX . 'distribution_log';
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $to_user_id = $user_redis->getOne_db($user_id, 'p_user_id');//用户总的：印票数
        $ticket = 0;
        $result = 0;
        if (intval($to_user_id) > 0 && intval($m_config['distribution']) == 1 && $user_id > 0 && $total_ticket > 0) {
            $ticket = round($m_config['distribution_rate'] * 0.01 * $total_ticket, 2);
            $sql = "select id from " . $table . " where to_user_id = " . $to_user_id . " and from_user_id = " . $user_id;
            $distribution_id = $GLOBALS['db']->getOne($sql);
            if (intval($distribution_id) > 0) {
                $sql = "update " . $table . " set ticket = ticket + " . $ticket . " where id = " . $distribution_id;
                $GLOBALS['db']->query($sql);
                $result = 1;
            } else {
                //插入:分销日志
                $video_prop = array();
                $video_prop['from_user_id'] = $user_id;
                $video_prop['to_user_id'] = $to_user_id;
                $video_prop['create_date'] = "'" . to_date(NOW_TIME, 'Y-m-d') . "'";
                $video_prop['ticket'] = $ticket;
                $video_prop['create_time'] = NOW_TIME;
                $video_prop['create_ym'] = to_date($video_prop['create_time'], 'Ym');
                $video_prop['create_d'] = to_date($video_prop['create_time'], 'd');
                $video_prop['create_w'] = to_date($video_prop['create_time'], 'W');

                //将日志写入mysql表中
                $field_arr = array(
                    'from_user_id',
                    'to_user_id',
                    'create_date',
                    'ticket',
                    'create_time',
                    'create_ym',
                    'create_d',
                    'create_w'
                );
                $fields = implode(",", $field_arr);
                $valus = implode(",", $video_prop);

                $sql = "insert into " . $table . "(" . $fields . ") VALUES (" . $valus . ")";
                $GLOBALS['db']->query($sql);
                $result = $GLOBALS['db']->insert_id();
            }
            if (intval($result) > 0) {
                $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $ticket . " where id = " . $to_user_id;
                $GLOBALS['db']->query($sql);
            }

        }
    }

    //-------------无抽成模式，所得私信收益归公会长所有---------------

    /**
     * @param int $to_user_id   被送礼物用户ID
     * @param int $total_ticket 获得的收益
     * @param int $user_id      用户id
     */
    public function soceity_rake($to_user_id, $total_ticket, $user_id)
    {
        //判断是否有公会
        $user_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $to_user_id);
        $society_info = $GLOBALS['db']->getRow("select user_id,status from " . DB_PREFIX . "society where id=" . $user_info['society_id']);
        if ($user_info['society_id'] > 0 && $society_info['status'] == 1) {
            //主播的收益加到公会中
            $pInTrans = $GLOBALS['db']->StartTrans();
            try {
                //加入公会收益
                $sql = "update " . DB_PREFIX . "society set chairman_earnings=chairman_earnings+" . $total_ticket . " where user_id=" . $society_info['user_id'];
                $GLOBALS['db']->query($sql);

                //排除公会长
                if (!$user_info['society_chieftain']) {
                    //将用户上交的公会的印票计入已提现
                    $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . ",refund_ticket = refund_ticket + " . $total_ticket . ",society_ticket=society_ticket+" . $total_ticket . " where id = " . $to_user_id . " and ticket >=refund_ticket";
                    $status = $GLOBALS['db']->query($sql);

                    //将收益汇入公会长
                    $sql_chieftain = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $society_info['user_id'];
                    $GLOBALS['db']->query($sql_chieftain);
                    user_deal_to_reids(array($society_info['user_id']));

                    //写入用户日志
                    earnings_log($total_ticket, $user_info['society_id'], 0, 10, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $to_user_id);
                    //写入会长日志
                    earnings_log($total_ticket, $user_info['society_id'], $to_user_id, 10, api_lang("host") . $to_user_id . api_lang("Generate_guild_income") . $total_ticket . api_lang("Printing_tickets"), $society_info['user_id']);

                } else {
                    $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . ",society_ticket=society_ticket+" . $total_ticket . " where id = " . $to_user_id . " and ticket >=refund_ticket";
                    $status = $GLOBALS['db']->query($sql);
                    //写入用户日志
                    earnings_log($total_ticket, $user_info['society_id'], $user_id, 10, api_lang("Private_message_gains") . $total_ticket . api_lang("Printing_tickets"), $society_info['user_id']);
                }

                //公会等级积分的写入
                society_level_syn($total_ticket, 0, $user_info['society_id']);
                //提交事务
                $GLOBALS['db']->Commit($pInTrans);
            } catch (Exception $e) {
                //异常回滚
                $GLOBALS['db']->Rollback($pInTrans);
                //写入会长日志
                earnings_log($total_ticket, $user_info['society_id'], 0, 10, api_lang("Guild_members") . $to_user_id . api_lang("Contribution_income") . ',' . $total_ticket . api_lang("Printing_tickets") . api_lang("fail"), $society_info['user_id']);
            }
            //-----事务结束-----
        }
        return;
    }

    /**
     * 用户是否有代理（分成） 返回的是用户金额
     * user_id   用户或主播id
     * total_ticket 消费后收益的金额
     */
    public function agent_sum($user_id, $host, $total_ticket)
    {
        $agent_id = $GLOBALS['db']->getOne("select agent_id from " . DB_PREFIX . "user where id = '$user_id'");
        $host_agent_id = $GLOBALS['db']->getOne("select agent_id from " . DB_PREFIX . "user where id = '$host'");
        $user_id_agentid = 0;
        $sum = $total_ticket;
        if ($agent_id || $host_agent_id) {
            $sum = intval($total_ticket / 2);
        }
        return $sum;
    }

    /**
     * 邀请码代理收益
     * $user_id 消费用户id
     * $total_ticket 消费的总金币
     * $prop_id    礼物id
     * $host      收益的主播
     * $type   1 彩钻 0不是
     * */
    public function agent_check_invite($user_id, $total_ticket, $prop_id, $host, $types = '0')
    {
        $agent_id = $GLOBALS['db']->getOne("select agent_id from " . DB_PREFIX . "user where id = '$user_id'");
        $host_agent_id = $GLOBALS['db']->getOne("select agent_id from " . DB_PREFIX . "user where id = '$host'");
        $user_id_agentid = 0;
        $host_id_agentid = 0;
        if ($agent_id > 0) {
            $user_id_agentid = $GLOBALS['db']->getOne("select agentid from " . DB_PREFIX . "agent_business where uid = '$agent_id'");
        }

        if ($host_agent_id > 0) {
            $host_id_agentid = $GLOBALS['db']->getOne("select agentid from " . DB_PREFIX . "agent_business where uid = '$host_agent_id'");
        }


        $account = $types > 0 ? '1' : '0';
        $sum = $total_ticket;
        //   $sum=intval($total_ticket/2);
        $table = DB_PREFIX . "agent_earnings";
        $fields = "uid,salesman,agent_id,coin,agent_coin,groupid,type,account,addtime";
        //消费用户代理的收益
        if ($user_id_agentid) {
            $type = '1';

            $valus = "'" . $user_id . "','" . $agent_id . "','" . $user_id_agentid . "','" . $total_ticket . "','" . $sum . "','" . $prop_id . "','" . $type . "','" . $account . "','" . time() . "'";
            $sql = "insert into " . $table . " (" . $fields . ") VALUES (" . $valus . ")";

            $GLOBALS['db']->query($sql);
        }

        //主播代理的收益
        if ($host_id_agentid) {
            $type = '2';

            $values = "'" . $host . "','" . $host_agent_id . "','" . $host_id_agentid . "','" . $total_ticket . "','" . $sum . "','" . $prop_id . "','" . $type . "','" . $account . "','" . time() . "'";
            $sql = "insert into " . $table . " (" . $fields . ") VALUES (" . $values . ")";

            $GLOBALS['db']->query($sql);
        }

    }

    //机器人发言
    public function get_crontab_robot_send()
    {
        $m_config = load_auto_cache("m_config");
        //是否开启机器人发言
        if ($m_config['robot_to_speak'] == 1) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/core/Model.class.php');
            Model::$lib = dirname(__FILE__);
            $gift_list = Model::build('prop')->crontab_robot_send();
        }
    }

    //机器人送礼物
    public function get_crontab_robot_send_gift()
    {
        $m_config = load_auto_cache("m_config");
        //是否开启机器人发言
        if ($m_config['robot_to_speak'] == 1) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/core/Model.class.php');
            Model::$lib = dirname(__FILE__);
            Model::build('prop')->crontabRobot();
        }
    }

    //获取守护开通特权 是否有开通守护礼物和返回特效id
//    public function get_guardians_notice($id)
//    {
//        $sql = "select * from " . DB_PREFIX . "guardian_classification where id=" . $id;
//        $guardian = $GLOBALS['db']->getRow($sql);
//
//        $type_name = explode(',', $guardian['privilege']);
//        $gift = 0;//没有权限开通礼物
//        if ($type_name) {
//
//            $sql = "select id from " . DB_PREFIX . "guardian_type where type=3";
//            $guardian_type = $GLOBALS['db']->getOne($sql);
//            foreach ($type_name as $v) {
//                if ($v == $guardian_type) {
//                    $gift = 1;
//                }
//            }
//        }
//
//        return $gift;
//    }

    //获取守护开通特权 是否有开通守护弹幕和返回特效id
    public function get_guardians_barrage($id)
    {
        $guardian =get_guardian_classification_one($id);

        $type_name = $guardian ? explode(',', $guardian['privilege']) : '';
        $barrage = 0;//没有权限开通弹幕
        $icon = 0;//没有身份标识
        if ($type_name) {
            //有无专属弹幕皮肤
            $guardian_type_4 = get_guardian_type_one(4);
            $guardian_type = $guardian_type_4 ? $guardian_type_4['id'] : '';
            //身份标识
            $guardian_type_2 = get_guardian_type_one(2);
            $icon_type = $guardian_type_2 ? $guardian_type_2['id'] : '';
            foreach ($type_name as $v) {
                if ($v == $guardian_type) {
                    $barrage = 1;
                }
                if ($v == $icon_type) {
                    $icon = 1;
                }
            }
        }

        $data = [
            'barrage' => $barrage,
            'icon'    => $icon
        ];

        return $data;
    }

}