<?php
// +----------------------------------------------------------------------
// | 
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class familyModule extends baseModule
{
    /******************【公会】****************/

    //创建公会
    public function create_guild()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $data['user_id'] = intval($GLOBALS['user_info']['id']);//创建人id
            $data['logo'] = strim($_REQUEST['family_logo']);//家族logo
            $data['name'] = strim($_REQUEST['family_name']);//家族名称
            $data['name'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['name']);//过滤表情
            $data['manifesto'] = strim($_REQUEST['family_manifesto']);//家族宣言
            $data['manifesto'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['manifesto']);//过滤表情
            $data['notice'] = strim($_REQUEST['family_notice']);//家族公告
            $data['notice'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['notice']);//过滤表情
            $data['status'] = 0;//状态 0：未审核，1：审核通过，2：拒绝通过
            $data['create_time'] = NOW_TIME;//创建时间
            $data['memo'] = "";//备注
            $data['type'] = $_REQUEST['type']; //公会加入类型
            //
            $data['create_date'] = to_date(NOW_TIME, 'Y-m-d ');
            $data['create_y'] = to_date(NOW_TIME, 'Y');
            $data['create_m'] = to_date(NOW_TIME, 'm');
            $data['create_d'] = to_date(NOW_TIME, 'd');
            $data['create_w'] = to_date(NOW_TIME, 'W');
            $user = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain,is_authentication FROM " . DB_PREFIX . "user WHERE id =" . $data['user_id']);
            if ($user['is_authentication'] != 2) {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Cannot_created_without_authentication")
                ));
            }


            /* if ($data['logo'] == '') {
                 api_ajax_return(array(
                     'status' => '0',
                     'error' => api_lang("Family_logo_is_empty")
                 ));
             } else*/
            if ($data['name'] == '') {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_name_is_empty")
                ));
            } elseif (strlen($data['name']) > 48) {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_name_restrictions")
                ));
            } elseif (strlen($data['manifesto']) > 420) {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_declaration_restrictions")
                ));
            }


            $family_status = $GLOBALS['db']->getRow("SELECT status FROM " . DB_PREFIX . "family WHERE id =" . $user['family_id'] . " and user_id=" . $data['user_id']);
            if ($user['family_id'] > 0 && $family_status['status'] != 2) {//用户已有家族且家族审核未被拒绝
                if ($user['family_chieftain'] == 1) {//用户是家族长
                    if ($family_status['status'] == 1) {
                        $root['error'] = api_lang("Existing_families_created");
                    }
                    if ($family_status['status'] == 0) {
                        $root['error'] = api_lang("family_is_under_review");
                    }
                } else {//用户是家族成员
                    $root['error'] = api_lang("You_have_joined_the_family");
                }
                $root['status'] = 0;
            } else {
                // 名称校验
                $jia_name = $GLOBALS['db']->getRow("SELECT count(id) as jia_count FROM " . DB_PREFIX . "family WHERE name = '" . $data['name'] . "' and (status=1 or status=0)");
                if ($jia_name['jia_count'] > 0) {
                    $root['error'] = api_lang("Family_name_already_exists");
                    $root['status'] = 0;
                } else {
                    $res = $GLOBALS['db']->autoExecute(DB_PREFIX . "family", $data, "INSERT");//插入数据
                    if ($res) {
                        $family_id = $GLOBALS['db']->insert_id();
                        if ($family_id) {
                            $userdata['family_id'] = $family_id;
                            $userdata['family_chieftain'] = 1;
                        }
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $userdata, $mode = 'UPDATE', "id=" . $data['user_id']);
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                        $user_redis = new UserRedisService();
                        $user_redis->update_db($data['user_id'], array('family_id' => $family_id, 'family_chieftain' => 1));
                        //更新申请表
                        $apple_count = $GLOBALS['db']->getOne("SELECT COUNT(id) FROM " . DB_PREFIX . "family_join WHERE user_id = " . $data['user_id']);
                        if ($apple_count > 0) { //如果有加入过的公会
                            $join['status'] = 2;
                            $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $join, $mode = 'UPDATE', "user_id=" . $data['user_id']);
                        }
                        $root['error'] = api_lang("Successful_creation_of_family");
                        $root['status'] = 1;
                        $root['data']['family_id'] = $family_id;
                        $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "family WHERE user_id =" . $data['user_id'] . ' and status = 2');
                    } else {
                        $root['error'] = api_lang("Family_creation_failed");
                        $root['status'] = 0;

                    }
                }
            }

        }
        api_ajax_return($root);
    }

    //修改公会信息
    public function guild_save()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $jid = intval($_REQUEST['family_id']);
            $res = $GLOBALS['db']->getRow("SELECT logo,notice,manifesto FROM " . DB_PREFIX . "family WHERE id = " . $jid);
            if (!empty($_REQUEST['family_logo'])) {
                $data['logo'] = strim($_REQUEST['family_logo']);
            }

            if (!empty($_REQUEST['family_manifesto'])) {
                if (strlen($_REQUEST['family_manifesto']) > 420) {
                    api_ajax_return(array(
                        'status' => '0',
                        'error' => api_lang("Family_declaration_restrictions")
                    ));
                }
                if (strim($_REQUEST['family_manifesto']) != $res['manifesto']) {
                    $data['manifesto'] = strim($_REQUEST['family_manifesto']);//家族宣言
                    $data['manifesto'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                        return '';
                    }, $data['manifesto']);
                } else {
                    $data['manifesto'] = $res['manifesto'];
                }
            }

            $data['name'] = strim($_REQUEST['family_name']);
            if (strlen($data['name']) > 48) {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_name_restrictions")
                ));
            }

            $data['name'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['name']);

            $data['type'] = $_REQUEST['type']; //加入方式

            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $user = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain FROM " . DB_PREFIX . "user WHERE id=" . $user_id);
//			$jia_status=$user['jia_status'];//家族状态
            $family_chieftain = $user['family_chieftain'];//族长标志：0不是族长。1是组长
            if ($family_chieftain != 1) {//判断是否为族长
                $root['error'] = api_lang("No_authority");
                $root['status'] = 0;
                $root['family_id'] = $jid;
            } else {
                $is_refuse = $GLOBALS['db']->getOne("SELECT id FROM " . DB_PREFIX . "family WHERE user_id = " . $user_id . " and status=2 ");
                if ($is_refuse > 0) { //有公会申请被拒的
                    $jia_name = $GLOBALS['db']->getRow("SELECT count(id) as jia_count FROM " . DB_PREFIX . "family WHERE name = '" . $data['name'] . "' and status=1 ");
                    if ($jia_name['jia_count'] > 0) {
                        $root['error'] = api_lang("Family_name_already_exists");
                        $root['status'] = 0;
                    } else {
                        $data['status'] = 0;
                        $update = $GLOBALS['db']->autoExecute(DB_PREFIX . "family", $data, $mode = 'UPDATE', 'id=' . $is_refuse); //如果是被拒绝状态重新编辑更新
                        if ($update) {
                            $root['error'] = api_lang("Modification_succeeded");
                            $root['status'] = 1;
                            $root['family_id'] = $is_refuse;
                        } else {
                            $root['error'] = api_lang("Modification_failed");
                            $root['status'] = 0;
                        }
                    }

                } else {
                    $res = $GLOBALS['db']->autoExecute(DB_PREFIX . "family", $data, "UPDATE", 'id=' . $jid);//更新信息
                    if ($res) {
                        $root['error'] = api_lang("Modification_succeeded");
                        $root['status'] = 1;
                        $root['data']['family_id'] = $jid;
                    } else {
                        $root['error'] = api_lang("Modification_failed");
                        $root['status'] = 0;
                        $root['family_id'] = $jid;
                    }
                }
            }
            api_ajax_return($root);
        }
    }

    //公会首页
    public function guild_index()
    {
        $root = ['status' => 1, 'error' => ''];
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];//创建人id
        $family_id = intval($_REQUEST['family_id']);//家族ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $sql = "SELECT f.id as family_id,f.logo as family_logo,f.name as family_name,f.create_time,f.memo,f.status,f.manifesto as family_manifesto,f.type as family_type,f.user_id from " . DB_PREFIX . "family AS f WHERE f.id =" . $family_id;
            $jiainfo = $GLOBALS['db']->getRow($sql);
            if(!$jiainfo){
                $root['error'] = api_lang("Family_ID_error");
                $root['status'] = 0;
                api_ajax_return($root);
            }
            $family_user = $GLOBALS['db']->getRow('select nick_name,head_image from ' . DB_PREFIX . 'user where id = ' . $jiainfo['user_id']);

            if ($jiainfo['status'] == 0) {
                $root['error'] = api_lang("family_is_under_review");
                //$root['status'] = 0;
            } elseif ($jiainfo['status'] == 2) {
                $root['error'] = api_lang("Your_family_failed");
                //$root['status'] = 2;
            } elseif ($jiainfo['status'] == 1) {
                //$root['status'] = 1;
                $root['error'] = "";
            }
            $sqls="select count(*) from " . DB_PREFIX . "user where family_id = " . $family_id;
            $user_count = $GLOBALS['db']->getOne($sqls);
            $jiainfo['user_count'] = $user_count;
            $jiainfo['family_manifesto'] = htmlspecialchars_decode($jiainfo['family_manifesto']);
            $jiainfo['family_name'] = htmlspecialchars_decode($jiainfo['family_name']);
            $jiainfo['family_logo'] = get_spec_image($jiainfo['family_logo']);
            $jiainfo['head_image'] = get_spec_image($family_user['head_image']);
            $jiainfo['nick_name'] = emoji_decode($family_user['nick_name']);
            $root['data']['family_info'] = $jiainfo; //工会信息
            //申请人数
            $apply = $GLOBALS['db']->getOne('select count(*) from ' . DB_PREFIX . 'family_join where status = 0 and family_id = ' . $family_id);
            if ($user_id == $jiainfo['user_id']) {
                $root['data']['apply'] = $apply;
            }
            //贡献榜
            $sql = "select fl.uid,u.nick_name,u.head_image,u.user_level,u.sex,sum(fl.score) as sums from " . DB_PREFIX . 'family_score_log fl inner join ' . DB_PREFIX . 'user u on fl.uid = u.id and fl.family_id = u.family_id  where  fl.family_id = ' . $family_id . ' group by fl.uid order by sums desc limit 0,3';
            $lists = $GLOBALS['db']->getAll($sql, true, true);

            if (count($lists) > 0) {
                foreach ($lists as &$v) {
                    $v['head_image'] = get_spec_image($v['head_image']);
                }
            }
            $root['data']['lists'] = $lists; //贡献榜

            $user_info = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where id = ' . $user_id);
            $root['data']['user_family_id'] = $user_info['family_id']; //当前用户的公会id

            $join = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'family_join where status < 2 and user_id = ' . $user_id . ' and family_id = ' . $family_id . ' order by create_time desc');
            $root['data']['join_status'] = empty($join) ? -1 : $join['status']; //我是否加入这个公会  -1未加入；0待审核；1已加入


//            if ($family_id) {
//                $sql = "SELECT f.id as family_id,f.logo as family_logo,f.name as family_name,f.create_time,f.memo,f.status,f.manifesto as family_manifesto,f.type as family_type,b.user_count,f.user_id,(select nick_name from " . DB_PREFIX . "user where id=f.user_id) as nick_name,(select head_image from " . DB_PREFIX . "user where id=f.user_id) as head_image from (select family_id, count(*) as user_count from " . DB_PREFIX . "user where family_id = " . $family_id . " group by family_id) b LEFT JOIN " . DB_PREFIX . "family AS f on  f.id=b.family_id  WHERE f.id =" . $family_id;
//            } else {
//                $root['error'] = api_lang("Family_ID_error");
//                $root['status'] = 0;
//                api_ajax_return($root);
//            }
//            $jiainfo = $GLOBALS['db']->getRow($sql);
//            foreach ($jiainfo as $k => $v) {
//                if ($k == 'family_manifesto' || $k == 'family_name') {
//                    $jiainfo[$k] = htmlspecialchars_decode($v);
//                }
//            }
//            if ($jiainfo) {
//                if ($jiainfo['status'] == 0) {
//                    $root['error'] = api_lang("family_is_under_review");
//                    //$root['status'] = 0;
//                } elseif ($jiainfo['status'] == 2) {
//                    $root['error'] = api_lang("Your_family_failed");
//                    //$root['status'] = 2;
//                } elseif ($jiainfo['status'] == 1) {
//                    //$root['status'] = 1;
//                    $root['error'] = "";
//                }
//                $jiainfo['family_logo'] = get_spec_image($jiainfo['family_logo']);
//                $jiainfo['head_image'] = get_spec_image($jiainfo['head_image']);
//                $jiainfo['nick_name'] = emoji_decode($jiainfo['nick_name']);
//                $root['data']['family_info'] = $jiainfo; //工会信息
//
//                //申请人数
//                $apply = $GLOBALS['db']->getOne('select count(*) from ' . DB_PREFIX . 'family_join where status = 0 and family_id = ' . $family_id);
//
//                if ($user_id == $jiainfo['user_id']) {
//                    $root['data']['apply'] = $apply;
//                }
//                //贡献榜
//                $sql = "select fl.uid,u.nick_name,u.head_image,u.user_level,u.sex,sum(fl.score) as sums from " . DB_PREFIX . 'family_score_log fl inner join ' . DB_PREFIX . 'user u on fl.uid = u.id and fl.family_id = u.family_id inner join ' . DB_PREFIX . 'family_join j on fl.family_id = j.family_id  where  fl.family_id = ' . $family_id . ' and j.status=1 group by uid order by sums desc limit 0,3';
//                $lists = $GLOBALS['db']->getAll($sql, true, true);
//
//                if (count($lists) > 0) {
//                    foreach ($lists as &$v) {
//                        $v['head_image'] = get_spec_image($v['head_image']);
//                    }
//                }
//                $root['data']['lists'] = $lists; //贡献榜
//
//                $user_info = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where id = ' . $user_id);
//                $root['data']['user_family_id'] = $user_info['family_id']; //当前用户的公会id
//                $join = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'family_join where status < 2 and user_id = ' . $user_id . ' and family_id = ' . $family_id . ' order by create_time desc');
//                $root['data']['join_status'] = empty($join) ? -1 : $join['status']; //我是否加入这个公会  -1未加入；0待审核；1已加入
//            } else {
//                $root['status'] = 0;
//                $root['error'] = api_lang("Your_family_is_not_here");
//            }
        }
        api_ajax_return($root);
    }

    //公会成员列表
    public function guild_member_list()
    {
        $root = ['status' => 1, 'error' => ''];
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];//创建人id
        $family_id = intval($_REQUEST['family_id']);//家族ID
        $type = intval($_REQUEST['type']);//类型【1已加入的；0申请的】
        $page = intval($_REQUEST['page']) > 0 ? intval($_REQUEST['page']) : 1;//分页
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //每次20条
            $page_size = 20;
            $limit = (($page - 1) * $page_size) . "," . $page_size;

            if (empty($family_id)) {
                $root['error'] = api_lang("Family_ID_error");
                $root['status'] = 0;
                api_ajax_return($root);
            }

            $sql = "SELECT f.id as family_id,f.logo as family_logo,f.name as family_name,f.create_time,f.memo,f.status,f.manifesto as family_manifesto,b.user_count,f.user_id,(select nick_name from " . DB_PREFIX . "user where id=f.user_id) as nick_name,(select head_image from " . DB_PREFIX . "user where id=f.user_id) as head_image from (select family_id, count(*) as user_count from " . DB_PREFIX . "user where family_id = " . $family_id . " group by family_id) b LEFT JOIN " . DB_PREFIX . "family AS f on  f.id=b.family_id  WHERE f.id =" . $family_id;
            $family_info = $GLOBALS['db']->getRow($sql);

            if($type == 1){
                $sql = "select id as uid,nick_name,head_image,sex,user_level,signature,family_chieftain from ".DB_PREFIX."user where family_id = ".$family_info['family_id'].'  order by  family_chieftain desc  limit '.$limit;
                $count = $GLOBALS['db']->getOne("SELECT COUNT(id) as rs_count from ".DB_PREFIX."user where family_id = ".$family_info['family_id'], true, true);
            }else{
                $sql = "select fj.id,fj.status, fj.user_id as uid,u.nick_name,u.head_image,u.sex,u.user_level,u.signature from ".DB_PREFIX."family_join fj left join ".DB_PREFIX."user u on fj.user_id = u.id where fj.family_id = ".$family_id.' and fj.status = 0 order by fj.create_time desc  limit '.$limit;
                $count = $GLOBALS['db']->getOne("SELECT COUNT(fj.id) as rs_count from ".DB_PREFIX."family_join fj left join ".DB_PREFIX."user u on fj.user_id = u.id where fj.family_id = ".$family_id.' and fj.status = 0', true, true);
            }
            $list = $GLOBALS['db']->getAll($sql);

            if (count($list) > 0) {
                foreach ($list as &$v) {
                    $v['head_image'] = get_spec_image($v['head_image']);
                    $v['nick_name'] = emoji_decode($v['nick_name']);
                }
            }
            $has_next = ($count > $page * $page_size) ? '1' : '0';

            $root['page'] = array('page' => $page, 'has_next' => $has_next);
            $root['data'] = $list;

            ajax_return($root);
        }


    }

    //公会列表（搜索公会）
    public function guild_list()
    {
        $root = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];//创建人id
        $family_name = strim($_REQUEST['family_name']);//家族名称
        $page = intval($_REQUEST['page']) > 0 ? intval($_REQUEST['page']) : 1;//分页
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //每次20条
            $page_size = 20;
            $limit = (($page - 1) * $page_size) . "," . $page_size;

            if ($family_name) {
                $where = " and f.name like '%" . $family_name . "%'";
            } else {
                $where = '';
            }

            $sql = "SELECT f.id as family_id,f.logo as family_logo,f.name as family_name,f.create_time,f.family_level,f.memo,f.status,f.manifesto as family_manifesto,f.user_id,(select nick_name from " . DB_PREFIX . "user where id=f.user_id) as nick_name,(select head_image from " . DB_PREFIX . "user where id = f.user_id) as head_image from " . DB_PREFIX . "family f WHERE status = 1 " . $where . ' order by family_level desc limit ' . $limit;

            $lists = $GLOBALS['db']->getAll($sql);
            if (count($lists) > 0) {
                foreach ($lists as &$v) {
                    $v['family_manifesto'] = htmlspecialchars_decode($v['family_manifesto']);
                    $v['family_name'] = htmlspecialchars_decode($v['family_name']);
                    $v['head_image'] = get_spec_image($v['head_image']);
                }
            }

            $root['data'] = $lists;
            ajax_return($root);
        }
    }

    //踢出公会成员
    public function guild_del()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $r_user_id = intval($_REQUEST['to_user_id']);//删除成员ID
            $info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user WHERE id=" . $r_user_id, true, true);//查找是否有此ID
            $score = $info['family_score']; //用户贡献的家族积分

            $user_family = intval($info['family_id']);//用户家族ID
            $user = $GLOBALS['db']->getRow("SELECT family_chieftain FROM " . DB_PREFIX . "user WHERE id=" . intval($GLOBALS['user_info']['id']));
            $family_chieftain = intval($user['family_chieftain']);//jai_chieftain 为1时候，身份家族长

            if ($info && $family_chieftain == 1) {


                //清空积分贡献记录  1、减掉用户的家族积分 2 清空积分记录
                $GLOBALS['db']->query(" update " . DB_PREFIX . "family set score = `score` - " . $score . " where id = " . $user_family);
                $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "family_score_log WHERE uid =" . $r_user_id . ' and family_id = ' . $user_family);


                $user['family_id'] = 0;
                $user['family_score'] = 0;
                $delet = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $user, $mode = 'UPDATE', "id=" . $r_user_id);

                $family['status'] = 3;
                $info = $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $family, $mode = 'UPDATE', "user_id=" . $r_user_id . " and family_id=" . $user_family);

                if ($delet && $info) {
                    $root['status'] = 1;
                    $root['error'] = '操作成功';

                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    $user_redis->update_db($r_user_id, array('family_id' => 0, 'family_score' => 0));
                    bogo_require(APP_ROOT_PATH . "system/libs/auto_cache.php");

                    $file = APP_ROOT_PATH . "system/auto_cache/family_contribution.auto_cache.php";
                    bogo_require($file);
                    $class = "family_contribution_auto_cache";
                    $obj = new $class;
                    $param = array(
                        'family_id' => $user_family,
                    );
                    $obj->rm($param);
                    //发送系统消息
                    $sqls = 'insert into ' . DB_PREFIX . "pub_msgs ";
                    $content = api_lang("Kicked_out_of_guild");
                    $sqls .= insertStr(['title' => api_lang("Failed_to_join_Guild"), 'content' => $content, 'users' => $r_user_id, 'type' => 1, 'addtime' => NOW_TIME]);
                    $GLOBALS['db']->query($sqls);
                }
            }
        }
        api_ajax_return($root);
    }

    //公会申请加入的状态
    public function guild_join_status()
    {
        $root = ['status' => 1, 'error' => ''];
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $lists = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'family_join where user_id = ' . $user_id . ' order by create_time desc');

            if ($lists && $lists['status'] == 0) {
                $root['data']['is_join'] = 1;
            } else {
                $root['data']['is_join'] = 0;
            }
            ajax_return($root);
        }
    }

    //申请加入公会
    public function guild_join()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $family_id = intval($_REQUEST['family_id']);//家族ID
            $user_id = intval($GLOBALS['user_info']['id']);//申请加入ID

            $user = $GLOBALS['db']->getRow("SELECT family_id FROM " . DB_PREFIX . "user WHERE id=" . $user_id, true, true);//查找ID是否有加入家族
            if ($user['family_id'] > 0) {
                $root['status'] = 0;
                $root['error'] = api_lang("You_have_joined_family");
                api_ajax_return($root);

            }

            $user_family = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "family_join WHERE family_id=" . $family_id . " and user_id=" . $user_id . " and status<2", true, true);//查找是否申请过此家族
            if ($user_family) {
                $root['status'] = 0;
                $root['error'] = api_lang("Has_applied_this_family");
                api_ajax_return($root);
            }

            $family_info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "family_join WHERE family_id=" . $family_id . " and user_id=" . $user_id . " and status>1", true, true);//查找是否有申请家族记录
            $family = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "family WHERE id=" . $family_id, true, true);//查找是否有此家族

            //如果有待审核的就顶掉
            $family_apply = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'family_join where status = 0 and user_id = ' . $user_id . ' order by create_time desc');
            if ($family_apply) {
                $data['status'] = $family['type'] == 1 ? 0 : 1;
                $data['family_id'] = $family_id;
                $data['create_time'] = NOW_TIME;
                $info = $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $data, $mode = 'UPDATE', "user_id=" . $user_id . " and id=" . $family_apply['id']);
            } elseif ($family_info) {
                $data['status'] = $family['type'] == 1 ? 0 : 1;
                $info = $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $data, $mode = 'UPDATE', "user_id=" . $user_id . " and family_id=" . $family_id);
            } elseif ($family && $user) {
                $data['family_id'] = $family_id;
                $data['user_id'] = $user_id;
                $data['create_time'] = NOW_TIME;//获取当前时间
                $data['status'] = $family['type'] == 1 ? 0 : 1;
                $data['memo'] = $user_id . api_lang("Apply_to_join");
                $info = $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $data, "INSERT");
            } else {
                $root['status'] = 0;
                $root['error'] = api_lang("There_is_no_family");
                api_ajax_return($root);
            }
            if ($info) {
                if ($data['status'] == 1 && $family['type'] == 2) { //申请成功的 并且是 直接加入的 家族类型
                    $GLOBALS['db']->query($sql = "update " . DB_PREFIX . "user set family_id = " . $family_id . ",family_chieftain = 0 where id=" . $user_id);
                    //redis更新
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    $user_redis->update_db($user_id, array('family_id' => $family_id, 'family_chieftain' => 0));

                    //发送系统消息
                    $sqls = 'insert into ' . DB_PREFIX . "pub_msgs ";
                    $sqls .= insertStr(['title' => api_lang("Joining_Guild_successfully"), 'content' => api_lang("Successfully_join_a_Guild") . $family['name'], 'users' => $user_id, 'type' => 1, 'addtime' => NOW_TIME]);
                    $GLOBALS['db']->query($sqls);
                }

                $root['status'] = 1;
                $root['error'] = $family['type'] == 1 ? api_lang("Application_submitted") : api_lang("Joining_Guild_successfully");
                $root['data']['family_id'] = $family_id;
            }

            api_ajax_return($root);
        }

    }

    //成员申请审核
    public function guild_confirm()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $r_user_id = intval($_REQUEST['to_user_id']);//审核成员ID
            $is_agree = intval($_REQUEST['is_agree']);//审核标志，1通过，2拒绝
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $user = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain FROM " . DB_PREFIX . "user WHERE id=" . $user_id);
            $family_id = $user['family_id'];//家族编号
            $family_chieftain = $user['family_chieftain'];//族长标志：0不是族长。1是组长
            $has_family = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain FROM " . DB_PREFIX . "user WHERE id=" . $r_user_id);
            $family = $GLOBALS['db']->getRow("SELECT COUNT(id) AS is_success FROM " . DB_PREFIX . "family WHERE user_id=" . $r_user_id . " and status != 2");
            if ($family_chieftain != 1) {//判断是否为族长
                $root['error'] = api_lang("No_authority");
                $root['status'] = 0;
                $root['r_user_id'] = $r_user_id;
                api_ajax_return($root);
            } else {

                $data['family_chieftain'] = 0;
                //更新用户信息
                if ($is_agree == 1) {
                    if ($has_family['family_id'] != 0 || $family['is_success'] > 0) {
                        $root['error'] = api_lang("member_already_has_family");
                        $root['status'] = 0;
                        $root['r_user_id'] = $r_user_id;
                        api_ajax_return($root);
                    } else {
                        $r_family_id = $family_id;
                        $GLOBALS['db']->query("UPDATE " . DB_PREFIX . "family_join SET status=2 WHERE family_id != " . $family_id . " and user_id=" . $r_user_id . " and status=0");
                        $GLOBALS['db']->query("UPDATE " . DB_PREFIX . "family SET status=2 WHERE user_id=" . $r_user_id . " and status=0");
                        $sql = "update " . DB_PREFIX . "user set family_id = " . $family_id . ",family_chieftain = 0 where id=" . $r_user_id;
                    }
                } elseif ($is_agree == 2) {
                    $sql = "update " . DB_PREFIX . "user set family_id = 0,family_chieftain = 0 where id = " . $r_user_id;
                    $r_family_id = 0;
                }
                $re = $GLOBALS['db']->query($sql);
                if ($re) {

                    //redis更新
                    $user_redis->update_db($r_user_id, array('family_id' => $r_family_id, 'family_chieftain' => 0));
                    $jsql = "update " . DB_PREFIX . "family_join set status = " . $is_agree . " where user_id = " . $r_user_id . " and family_id = " . $family_id . " and status=0";
                    $GLOBALS['db']->query($jsql);


                    //发送系统消息
                    $sqls = 'insert into ' . DB_PREFIX . "pub_msgs ";
                    if ($is_agree == 1) {
                        $content = api_lang("president_approved_guild_application");
                        $title = api_lang("Joining_Guild_successfully");
                    } else {
                        $content = api_lang("president_rejected_guild_application");
                        $title = api_lang("Failed_to_join_Guild");
                    }
                    $sqls .= insertStr(['title' => $title, 'content' => $content, 'users' => $r_user_id, 'type' => 1, 'addtime' => NOW_TIME]);
                    $GLOBALS['db']->query($sqls);

                    $root['error'] = api_lang("Application_approved");
                    $root['status'] = 1;
                    $root['data']['r_user_id'] = $r_user_id;
                    api_ajax_return($root);

                } else {
                    $root['error'] = '';
                    $root['status'] = 0;
                    $root['data']['r_user_id'] = $r_user_id;
                    api_ajax_return($root);
                }
            }
        }
    }

    //退出公会
    public function guild_logout()
    {

        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return(array('error' => api_lang("user_not_logged_in"), 'status' => 0, 'user_login_status' => 0));
        }

        $user_id = intval($GLOBALS['user_info']['id']);//登陆用户ID

        $user_info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user WHERE id=" . $user_id . " and family_chieftain=0", true, true);//查询是否是家族成员
        $user_family = intval($user_info['family_id']);//用户家族ID

        if ($user_info) {

            //清空积分贡献记录  1、减掉用户的家族积分 2 清空积分记录
            $GLOBALS['db']->query(" update " . DB_PREFIX . "family set score = `score` - " . $user_info['family_score'] . " where id = " . $user_family);
            $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "family_score_log WHERE uid =" . $user_id . ' and family_id = ' . $user_family);


            $user['family_id'] = 0;
            $user['family_score'] = 0;
            $delet = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $user, $mode = 'UPDATE', "id=" . $user_id);

            $family['status'] = 3;
            $info = $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $family, $mode = 'UPDATE', "user_id=" . $user_id . " and family_id=" . $user_family);

            if ($delet && $info) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();
                $user_redis->update_db($user_id, array('family_id' => 0, 'family_score' => 0));
                es_session::set("user_info", $user_info);
            }
            ajax_return(array('error' => '操作成功', 'status' => 1));

        } else {
            ajax_return(array('error' => api_lang("Business_action_failed"), 'status' => 10002));
        }

    }

    //公会贡献榜
    public function guild_contribution()
    {

        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return(array('error' => api_lang("user_not_logged_in"), 'status' => 0, 'user_login_status' => 0));
        }
        $user_id = $GLOBALS['user_info']['id'];
        $page = intval($_REQUEST['page']) > 0 ? intval($_REQUEST['page']) : 1;//分页
        //每次20条
        $page_size = 20;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        $param = [
            'type' => $_REQUEST['type'], // day 日榜；  all 总榜
            'family_id' => $_REQUEST['family_id'], //家族id
            'limit' => $limit
        ];
        $list = load_auto_cache('family_contribution', $param);


        $user = [
            'uid' => $user_id,
            'nick_name' => emoji_decode($GLOBALS['user_info']['nick_name']),
            'head_image' => get_spec_image($GLOBALS['user_info']['head_image']),
            'user_level' => $GLOBALS['user_info']['user_level'],
            'sex' => $GLOBALS['user_info']['sex'],
            'sums' => 0,
            'order' => api_lang('Not_on_list')
        ];
        if (count($list) > 0) {
            foreach ($list as $k => $v) {
                if ($v['uid'] == $user_id) {
                    $user['order'] = $k + 1;
                    $user['sums'] = $v['sums'];
                }
            }
        }

        $root['data']['list'] = $list;
        $root['data']['user'] = $user;

        ajax_return($root);
    }

    //解散公会
    public function dissolve_guild()
    {
        $root = ['status' => 1, 'error' => ''];
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $family_info = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'family where status = 1 and user_id = ' . $user_id);
            if (empty($family_info)) {
                $root['status'] = 0;
                $root['error'] = api_lang("There_is_no_family");
                ajax_return($root);
            }
            $user = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain FROM " . DB_PREFIX . "user WHERE id=" . $user_id);
            if ($user['family_chieftain'] != 1 && $user['family_id'] != $family_info['id']) {
                $root['status'] = 0;
                $root['error'] = api_lang("Your_family_is_not_here");
                ajax_return($root);
            }

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            //已加入的成员 退出公会
            $lists = $GLOBALS['db']->getAll('select id from ' . DB_PREFIX . 'user where family_id = ' . $family_info['id']);
            if (count($lists) > 0) {
                $i = 0;
                foreach ($lists as $v) {
                    //修改用户表中的家族id
                    $up = $GLOBALS['db']->query("update " . DB_PREFIX . "user set family_id = 0,family_chieftain = 0,family_score = 0 where id = " . $v['id']);

                    //修改缓存信息
                    $user_redis->update_db($user_id, array('family_id' => 0, 'family_score' => 0));
                    $upf = $GLOBALS['db']->query("update " . DB_PREFIX . "family_join set status = 3 where user_id = " . $v['id'] . ' and family_id = ' . $family_info['id']); //退出家族

                    //发送系统消息
                    $sqls = 'insert into ' . DB_PREFIX . "pub_msgs ";
                    $sqls .= insertStr(['title' => api_lang("Guild_exit_success"), 'content' => api_lang("Dismissed_by_president_successfully_quit"), 'users' => $v['id'], 'type' => 1, 'addtime' => NOW_TIME]);

                    $pus = $GLOBALS['db']->query($sqls);
                    if ($up && $upf && $pus) {
                        $i++;
                    }
                }
            }


            //待审核的成员 撤回申请
            $apply = $GLOBALS['db']->getAll('select * from ' . DB_PREFIX . 'family_join where status = 0 and family_id = ' . $family_info['id']);
            if (count($apply) > 0) {
                foreach ($apply as $a) {
                    //修改缓存信息
                    $upf = $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "family_join WHERE id =" . $a['id']); //删除申请

                    //发送系统消息
                    $sqls = 'insert into ' . DB_PREFIX . "pub_msgs ";
                    $sqls .= insertStr(['title' => api_lang("Withdrawal_application"), 'content' => api_lang("Application_withdrawn"), 'users' => $a['user_id'], 'type' => 1, 'addtime' => NOW_TIME]);
                    $GLOBALS['db']->query($sqls);
                }
            }


            if ($i == count($lists)) {
                $status = $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "family WHERE id =" . $family_info['id']);
            } else {
                $status = 0;
            }

            if ($status) {
                $root['status'] = 1;
                $root['error'] = api_lang("operation_was_successful");
            } else {
                $root['status'] = 0;
                $root['error'] = api_lang("operation_failed");
            }
            ajax_return($root);
        }
    }

    //公会排名
    public function guild_ranking()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return(array('error' => api_lang("user_not_logged_in"), 'status' => 0, 'user_login_status' => 0));
        }
        $user_id = $GLOBALS['user_info']['id'];
        $page = intval($_REQUEST['page']) > 0 ? intval($_REQUEST['page']) : 1;//分页
        //每次20条
        $page_size = 20;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        $param = [
            'type' => $_REQUEST['type'], // day 日榜； week 周榜；  all 总榜
        ];
        $list = load_auto_cache('family_rank_new', $param);
        $root['data'] = $list;
        ajax_return($root);
    }

    //创建公会之前清空待审核加入
    public function clean_guild()
    {
        $root = ['status' => 1, 'error' => ''];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        } else {
            $user_id = $GLOBALS['user_info']['id'];

            $family_status = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "family_join WHERE status = 0 and user_id=" . $user_id . " order by create_time desc");
            if ($family_status) {
                $join['status'] = 3;
                $status = $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $join, $mode = 'UPDATE', "id=" . $family_status['id']);
                if ($status) {
                    $root = ['status' => 1, 'error' => ''];
                } else {
                    $root = ['status' => 0, 'error' => ''];
                }
            } else {
                $root = ['status' => 0, 'error' => api_lang("There_pending_applications")];
                ajax_return($root);
            }
        }
        ajax_return($root);
    }





    /*****************【家族】********************/
    //家族首页1
    function index()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $family_id = intval($_REQUEST['family_id']);//家族ID
            $user_id = intval($GLOBALS['user_info']['id']);//创建人id
            if ($family_id != '') {
                $sql = "SELECT f.id as family_id,f.logo as family_logo,f.name as family_name,f.create_time,f.memo,f.status,f.manifesto as family_manifesto,b.user_count,f.user_id,(select nick_name from " . DB_PREFIX . "user where id=f.user_id) as nick_name from (select family_id, count(*) as user_count from " . DB_PREFIX . "user where family_id = " . $family_id . " group by family_id) b LEFT JOIN " . DB_PREFIX . "family AS f on  f.id=b.family_id  WHERE f.id =" . $family_id;
            } else {
                $root['error'] = api_lang("Family_ID_error");
                $root['status'] = 0;
                api_ajax_return($root);
            }
            $jiainfo = $GLOBALS['db']->getRow($sql);

            foreach ($jiainfo as $k => $v) {
                if ($k == 'family_manifesto' || $k == 'family_name') {
                    $jiainfo[$k] = htmlspecialchars_decode($v);
                }
            }
            if ($jiainfo) {
                if ($jiainfo['status'] == 0) {
                    $root['error'] = api_lang("family_is_under_review");
                    $root['status'] = 0;
                } elseif ($jiainfo['status'] == 2) {
                    $root['error'] = api_lang("Your_family_failed");
                    $root['status'] = 2;
                } elseif ($jiainfo['status'] == 1) {
                    $root['status'] = 1;
                    $root['error'] = "";
                }
                $jiainfo['family_logo'] = get_spec_image($jiainfo['family_logo']);
                $root['family_info'] = $jiainfo;
            } else {
                $root['status'] = 3;
                $root['error'] = api_lang("Your_family_is_not_here");
            }
        }
        api_ajax_return($root);
    }

    //家族列表
    function family_list()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //分页
            $user_id = intval($GLOBALS['user_info']['id']);
            $page = intval($_REQUEST['page']);//取第几页数据
            if ($page == 0 || $page == '') {
                $page = 1;
            }
            //每次20条
            $page_size = intval($_REQUEST['page_size']);//分页数量;
            if ($page_size == '') {
                $page_size = 20;
            }
            $limit = (($page - 1) * $page_size) . "," . $page_size;
            //搜索
            $jid = intval($_REQUEST['family_id']);
            $jia_name = strim($_REQUEST['family_name']);

            if (($jid != '' && $jid != 0) || $jia_name != '') {
                if ($jia_name == '') {
                    $jia_name = 'null';
                }
                //搜索列表
                $sql = "SELECT j.id as family_id,j.logo as family_logo,j.name as family_name,j.user_id,u.nick_name,j.create_time,(SELECT COUNT(id) FROM " . DB_PREFIX . "user c WHERE c.family_id=j.id) as user_count,IF ((select count(id) as is_apply from " . DB_PREFIX . "family_join as jo where jo.user_id=" . $user_id . " and jo.family_id=j.id and jo.status=0 )>0,1,IF ((select count(id) as is_apply from " . DB_PREFIX . "family_join as jo where jo.user_id=" . $user_id . " and jo.family_id=j.id and jo.status=1 )>0,2,0)) as is_apply FROM " . DB_PREFIX . "family as j left join " . DB_PREFIX . "user as u on j.user_id=u.id where j.status=1 and ( j.id = '" . $jid . "' or j.name like '%" . $jia_name . "%') limit " . $limit;
            } else {
                //默认列表
                $sql = "SELECT j.id as family_id,j.logo as family_logo,j.name as family_name,j.user_id,u.nick_name,j.create_time,(SELECT COUNT(id) FROM " . DB_PREFIX . "user c WHERE c.family_id=j.id) as user_count,IF ((select count(id) as is_apply from " . DB_PREFIX . "family_join as jo where jo.user_id=" . $user_id . " and jo.family_id=j.id and jo.status=0 )>0,1,IF ((select count(id) as is_apply from " . DB_PREFIX . "family_join as jo where jo.user_id=" . $user_id . " and jo.family_id=j.id and jo.status=1 )>0,2,0)) as is_apply FROM " . DB_PREFIX . "family as j left join " . DB_PREFIX . "user as u on j.user_id=u.id where j.status=1 limit " . $limit;
            }
            $jia_list = $GLOBALS['db']->getAll($sql, true, true);
            foreach ($jia_list as $k => $v) {
                $jia_list[$k]['family_logo'] = get_spec_image($v['family_logo']);
                $jia_list[$k]['name'] = htmlspecialchars_decode($jia_list[$k]['name']);
                $jia_list[$k]['nick_name'] = htmlspecialchars_decode($jia_list[$k]['nick_name']);
                $jia_list[$k]['create_time'] = htmlspecialchars_decode($jia_list[$k]['create_time']);

            }
            if ($jia_list) {
                $root['list'] = $jia_list;
                $rs_count = $GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "family where status=1", true, true);//家族数量
                if ($page == 0) {
                    $root['page'] = array('page' => $page, 'has_next' => 0);
                } else {
                    $has_next = ($rs_count > $page * $page_size) ? '1' : '0';
                    $root['page'] = array('page' => $page, 'has_next' => $has_next);
                }
//			$root['page'] = $page;
                $root['rs_count'] = $rs_count;
                $root['status'] = 1;
                $root['error'] = '';
            } else {
                $root['list'] = $jia_list;
                $root['page'] = array('page' => $page, 'has_next' => 0);
                $root['status'] = 1;
                $root['error'] = '';
            }

        }
        api_ajax_return($root);
    }

    //创建家族
    function create()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $data['user_id'] = intval($GLOBALS['user_info']['id']);//创建人id
            $data['logo'] = strim($_REQUEST['family_logo']);//家族logo
            $data['name'] = strim($_REQUEST['family_name']);//家族名称
            $data['name'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['name']);//过滤表情
            $data['manifesto'] = strim($_REQUEST['family_manifesto']);//家族宣言
            $data['manifesto'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['manifesto']);//过滤表情
            $data['notice'] = strim($_REQUEST['family_notice']);//家族公告
            $data['notice'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                return '';
            }, $data['notice']);//过滤表情
            $data['status'] = 0;//状态 0：未审核，1：审核通过，2：拒绝通过
            $data['create_time'] = NOW_TIME;//创建时间
            $data['memo'] = "";//备注
            //
            $data['create_date'] = to_date(NOW_TIME, 'Y-m-d ');
            $data['create_y'] = to_date(NOW_TIME, 'Y');
            $data['create_m'] = to_date(NOW_TIME, 'm');
            $data['create_d'] = to_date(NOW_TIME, 'd');
            $data['create_w'] = to_date(NOW_TIME, 'W');

            if ($data['logo'] == '') {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_logo_is_empty")
                ));
            } elseif ($data['name'] == '') {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_name_is_empty")
                ));
            } elseif (strlen($data['name']) > 48) {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_name_restrictions")
                ));
            } elseif (strlen($data['manifesto']) > 420) {
                api_ajax_return(array(
                    'status' => '0',
                    'error' => api_lang("Family_declaration_restrictions")
                ));
            }

            $user = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain FROM " . DB_PREFIX . "user WHERE id =" . $data['user_id']);
            $family_status = $GLOBALS['db']->getRow("SELECT status FROM " . DB_PREFIX . "family WHERE id =" . $user['family_id'] . " and user_id=" . $data['user_id']);
            if ($user['family_id'] > 0 && $family_status['status'] != 2) {//用户已有家族且家族审核未被拒绝
                if ($user['family_chieftain'] == 1) {//用户是家族长
                    if ($family_status['status'] == 1) {
                        $root['error'] = api_lang("Existing_families_created");
                    }
                    if ($family_status['status'] == 0) {
                        $root['error'] = api_lang("family_is_under_review");
                    }
                } else {//用户是家族成员
                    $root['error'] = api_lang("You_have_joined_the_family");
                }
                $root['status'] = 0;
            } else {
                // 名称校验
                $jia_name = $GLOBALS['db']->getRow("SELECT count(id) as jia_count FROM " . DB_PREFIX . "family WHERE name = '" . $data['name'] . "' and (status=1 or status=0)");
                if ($jia_name['jia_count'] > 0) {
                    $root['error'] = api_lang("Family_name_already_exists");
                    $root['status'] = 0;
                } else {
                    $res = $GLOBALS['db']->autoExecute(DB_PREFIX . "family", $data, "INSERT");//插入数据
                    if ($res) {
//						$jia_info=$GLOBALS['db']->getRow("SELECT id FROM ".DB_PREFIX."family WHERE user_id = ".$data['user_id']." AND name=".$data['name']);//查询创建成功的家族编号
                        $family_id = $GLOBALS['db']->insert_id();
                        if ($family_id) {
                            $userdata['family_id'] = $family_id;
                            $userdata['family_chieftain'] = 1;
                        }
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $userdata, $mode = 'UPDATE', "id=" . $data['user_id']);
//						$GLOBALS['db']->query("update ".DB_PREFIX."user set family_id=".$jia_info['id'].",family_chieftain=1 where id=".$data['user_id']);
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                        $user_redis = new UserRedisService();
                        $user_redis->update_db($data['user_id'], array('family_id' => $family_id, 'family_chieftain' => 1));
                        //更新申请表
                        $apple_count = $GLOBALS['db']->getOne("SELECT COUNT(id) FROM " . DB_PREFIX . "family_join WHERE user_id = " . $data['user_id']);
                        if ($apple_count > 0) {
                            $join['status'] = 2;
                            $GLOBALS['db']->autoExecute(DB_PREFIX . "family_join", $join, $mode = 'UPDATE', "user_id=" . $data['user_id']);
                        }
                        $root['error'] = api_lang("Successful_creation_of_family");
                        $root['status'] = 1;
                        $root['family_id'] = $family_id;
                    } else {
                        $root['error'] = api_lang("Family_creation_failed");
                        $root['status'] = 0;

                    }
                }
            }

        }
        api_ajax_return($root);
    }

    //修改家族信息
    function save()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $jid = intval($_REQUEST['family_id']);
            $res = $GLOBALS['db']->getRow("SELECT logo,notice,manifesto FROM " . DB_PREFIX . "family WHERE id = " . $jid);
            if (!empty($_REQUEST['family_logo'])) {

                $data['logo'] = strim($_REQUEST['family_logo']);

            }
            if (!empty($_REQUEST['family_notice'])) {
                //家族公告
                if (strim($_REQUEST['family_notice']) != $res['notice']) {
                    $data['notice'] = strim($_REQUEST['family_notice']);
                    $data['notice'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                        return '';
                    }, $data['notice']);
                } else {
                    $data['notice'] = $res['notice'];
                }
            }

            if (!empty($_REQUEST['family_manifesto'])) {
                if (strlen($_REQUEST['family_manifesto']) > 420) {
                    api_ajax_return(array(
                        'status' => '0',
                        'error' => api_lang("Family_declaration_restrictions")
                    ));
                }
                if (strim($_REQUEST['family_manifesto']) != $res['manifesto']) {
                    $data['manifesto'] = strim($_REQUEST['family_manifesto']);//家族宣言
                    $data['manifesto'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                        return '';
                    }, $data['manifesto']);
                } else {
                    $data['manifesto'] = $res['manifesto'];
                }
            }

            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $user = $GLOBALS['db']->getRow("SELECT family_id,family_chieftain FROM " . DB_PREFIX . "user WHERE id=" . $user_id);
//			$jia_status=$user['jia_status'];//家族状态
            $family_chieftain = $user['family_chieftain'];//族长标志：0不是族长。1是组长
            if ($family_chieftain != 1) {//判断是否为族长
                $root['error'] = api_lang("No_authority");
                $root['status'] = 0;
                $root['family_id'] = $jid;
            } else {
                $is_refuse = $GLOBALS['db']->getOne("SELECT id FROM " . DB_PREFIX . "family WHERE user_id = " . $user_id . " and status=2 ");
                if ($is_refuse > 0) {
                    $data['name'] = strim($_REQUEST['family_name']);
                    if (strlen($data['name']) > 48) {
                        api_ajax_return(array(
                            'status' => '0',
                            'error' => api_lang("Family_name_restrictions")
                        ));
                    }

                    $data['name'] = preg_replace_callback('/[\xf0-\xf7].{3}/', function ($r) {
                        return '';
                    }, $data['name']);
                    $jia_name = $GLOBALS['db']->getRow("SELECT count(id) as jia_count FROM " . DB_PREFIX . "family WHERE name = '" . $data['name'] . "' and status=1 ");
                    if ($jia_name['jia_count'] > 0) {
                        $root['error'] = api_lang("Family_name_already_exists");
                        $root['status'] = 0;
                    } else {
                        $data['status'] = 0;
                        $update = $GLOBALS['db']->autoExecute(DB_PREFIX . "family", $data, $mode = 'UPDATE', 'id=' . $is_refuse); //如果是被拒绝状态重新编辑更新
                        if ($update) {
                            $root['error'] = api_lang("Modification_succeeded");
                            $root['status'] = 1;
                            $root['family_id'] = $is_refuse;
                        } else {
                            $root['error'] = api_lang("Modification_failed");
                            $root['status'] = 0;
                        }
                    }

                } else {
                    $res = $GLOBALS['db']->autoExecute(DB_PREFIX . "family", $data, "UPDATE", 'id=' . $jid);//更新信息
                    if ($res) {
                        $root['error'] = api_lang("Modification_succeeded");
                        $root['status'] = 1;
                        $root['family_id'] = $jid;
                    } else {
                        $root['error'] = api_lang("Modification_failed");
                        $root['status'] = 0;
                        $root['family_id'] = $jid;
                    }
                }
            }
            api_ajax_return($root);
        }
    }

    // 创建家族（弹窗）
    function edit()
    {
        $root = array();
        api_ajax_return($root);
    }
}

?>
