<?php

/**
 * Created by PhpStorm.
 * User:zhaofangkai
 * Date: 2019/1/27
 * Time: 1:48
 */
class guardiansModule extends baseModule
{

    //守护列表
    public function index()
    {
        $root = array();
        $root['status'] = 1;
        //      $GLOBALS['user_info']['id']=164735;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $host_id = $_REQUEST['host_id'];
            //获取守护列表
            $root['list'] = $this->guardians_list($host_id);

            //获取总守护数量
            //   $root['guardian_sum'] = $this->get_guardian_sum($host_id);
            $root['guardian_sum'] = count($root['list']);
            //获取是否是守护者
            $guardian = $this->get_guardian_one($host_id, $user_id);

            $root['is_guartian'] = $guardian ? '1' : '2';
            $root['guartian_time'] = $guardian ? date("Y-m-d", $guardian['endtime']) : '';
        }
        api_ajax_return($root);
    }

    //获取守护特权信息表
    public function get_guardians_privilege()
    {
        $root = array();
        $root['status'] = 1;
        //    $GLOBALS['user_info']['id']=3;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $host_id = $_REQUEST['host_id'];

            $sql = "select c.name,c.img_bg,c.img_identification,c.img,c.privilege,v.endtime from " . DB_PREFIX . "guardian_user v left join " . DB_PREFIX . "guardian g on g.id = v.guardianid  left join " . DB_PREFIX . "guardian_classification c on c.id = g.classification_id where v.host_id=" . $host_id . " and v.uid=" . $user_id . " and v.endtime >= " . time() . " and v.status=1";

            $guardian = $GLOBALS['db']->getRow($sql);
            $binding = explode(',', $guardian['privilege']);

            $guardian_type = load_auto_cache("guardian_type");

            $data['guardian_img'] = $guardian?$guardian['img']:'';
            $data['guardian_remind'] = '0';
            $data['guardian_icon'] = '0';
            $data['guardian_gift'] = '0';
            $data['guardian_skin'] = '0';
            $data['guardian_broadcast'] = '0';
            $data['guardian_kick'] = '0';
            foreach ($guardian_type as $v) {
                if (in_array($v['id'], $binding)) {
                    //1开通提醒，2身份标识，3专属礼物，4专属弹幕皮肤，5全站广播，6防踢防禁言
                    switch ($v['type']) {
                        case 1:
                            $data['guardian_remind'] = '1';
                            break;
                        case 2:
                            $data['guardian_icon'] = '1';
                            break;
                        case 3:
                            $data['guardian_gift'] = '1';
                            break;
                        case 4:
                            $data['guardian_skin'] = '1';
                            break;
                        case 5:
                            $data['guardian_broadcast'] = '1';
                            break;
                        case 6:
                            $data['guardian_kick'] = '1';
                            break;
                        default:
                    }
                }
            }
            $root['list'] = $data;

        }
        api_ajax_return($root);
    }

    //守护类型列表
    public function duardian_index()
    {

        $root = array();
        $root['status'] = 1;
        //    $GLOBALS['user_info']['id']=3;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $host_id = $_REQUEST['host_id'];
            //   $host_id =2;
            //获取守护类型列表
            $root['list'] = $this->get_guardian_type();

            //获取守护特效列表
            $root['guardian_effects'] = $this->get_guardian_special_effects();

            //获取是否是守护者
            $guardian = $this->get_guardian_one($host_id, $user_id);
            if($guardian){
               $guardian_classification= get_guardian_classification_one($guardian['classification_id']);
                $g_icon = $guardian_classification && $guardian_classification['img'] ? $guardian_classification['img'] : '';
            }
            //获取当前余额
            $sql = "select diamonds,head_image from " . DB_PREFIX . "user where id=" . $user_id;
            $user = $GLOBALS['db']->getRow($sql);
            $root['diamonds'] = $user['diamonds'];
            $root['head_image'] = get_spec_image($user['head_image']);
            $root['is_guartian'] = $guardian ? '1' : '2';
            $root['guartian_icon'] = $guardian ? $g_icon : ''; //我的守护图标
            $root['guartian_time'] = $guardian ? date("Y-m-d H:i", $guardian['endtime']) : '';
        }
        api_ajax_return($root);
    }

    //购买守护
    public function guardian_buy()
    {
        $root = array('status' => 0, 'error' => api_lang("Guard_failure"));
        //	$GLOBALS['user_info']['id']=164735;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $host_id = $_REQUEST['host_id'];
            $id = $_REQUEST['id'];
            $m_config = load_auto_cache("m_config");//初始化手机端配置

            if($user_id == $host_id){
                $root['error'] = '不能守护自己';
                ajax_return($root);
            }
            $host_info = $GLOBALS['db'] -> getRow('select id,nick_name,head_image from '.DB_PREFIX.'user where id = '.$host_id); //主播信息
            $sql = "select * from " . DB_PREFIX . "user where id = " . $user_id;
            $user = $GLOBALS['db']->getRow($sql);
            $before_user_diamonds = intval($user['diamonds']);
            $before_to_ticket = $host_info['ticket'];
            //获取守护的信息
            $sql = "select * from " . DB_PREFIX . "guardian where id=" . $id;
            $guardian = $GLOBALS['db']->getRow($sql);
            if (!$guardian) {
                $root['error'] = api_lang("parameter_error");
                ajax_return($root);
            }

            //减少用户钻石
            $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $guardian['coin'] . ", use_diamonds = use_diamonds + " . $guardian['coin'] . ", score = score + " . $guardian['coin'] . " where id = '" . $user_id . "' and diamonds >= " . $guardian['coin'];
            $GLOBALS['db']->query($sql);
            if (!$GLOBALS['db']->affected_rows()) {
                $root['error'] = api_lang("insufficient_balance");
                ajax_return($root);
            }

            //获取是否是守护者
            $sql = "select gu.*,g.classification_id from " . DB_PREFIX . "guardian_user gu left join ".DB_PREFIX."guardian g on g.id = gu.guardianid where gu.host_id=" . $host_id . " and gu.uid=" . $user_id;
            $guardian_user = $GLOBALS['db']->getRow($sql);

            $time = time() + $guardian['day'] * 24 * 60 * 60;
            $data = array(
                'uid' => $user_id,
                'host_id' => $host_id,
                'guardianid' => $id,
                'starttime' => time(),
                'endtime' => $time,
                'status' => 1,
                'addtime' => time(),
                'coin' => $guardian['coin'],
                'day' => $guardian['day'],
            );
            $GLOBALS['db']->autoExecute(DB_PREFIX . "guardian_user_log", $data, "INSERT");
            $guardian_user_log = $GLOBALS['db']->insert_id();

            if (!$guardian_user_log) {
                $root['error'] = api_lang("Guard_failure");
                ajax_return($root);
            }
            $data['guardian_user_id'] = $guardian_user_log;
            if ($guardian_user) {
                if ($guardian_user['endtime'] >= time() && $guardian_user['status'] == 1 && $guardian['classification_id'] == $guardian_user['classification_id']) { //有守护，且守护等级更买的是一样的，即续费
                    $time = $guardian_user['endtime'] + $guardian['day'] * 24 * 60 * 60;
                    $sert = "endtime = " . $time . ",guardianid=" . $id . ",coin=" . $guardian['coin'] . ",day=" . $guardian['day'] . ",guardian_user_id=" . $guardian_user_log;
                } else {
                    $sert = "endtime = " . $time . ",guardianid=" . $id . ",coin=" . $guardian['coin'] . ",day=" . $guardian['day'] . ",guardian_user_id=" . $guardian_user_log . ",starttime=" . time() . ",status=1";
                }

                //修改守护时间
                $sql = "update " . DB_PREFIX . "guardian_user set  " . $sert . "  where id = " . $guardian_user['id'];
                $video_share_id = $GLOBALS['db']->query($sql);
                $table_id = $guardian_user['id'];
            } else {
                //添加守护时间
                $GLOBALS['db']->autoExecute(DB_PREFIX . "guardian_user", $data, "INSERT");
                $video_share_id = $GLOBALS['db']->insert_id();
                $table_id = $video_share_id;
            }

            if ($video_share_id) {
                //日志记录
                $sql = "insert into ".DB_PREFIX."user_log(log_info,log_time,type,user_id,diamonds,prop_id,podcast_id,ticket) values('".api_lang("Buy_Guardian").$guardian['name'].api_lang('consumption').$guardian['coin']."','".time()."','12','".$user_id."','".$guardian['coin']."','".$guardian_user_log."',".$host_id.",'".$guardian['coin']."')";
                $GLOBALS['db']->query($sql);

                $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $guardian['coin'] . " where id = " . $host_id;
                $GLOBALS['db']->query($sql);
                //获取守护的信息
                $classification= get_guardian_classification_one($guardian['classification_id']);

                $guardian_name = $classification['name'];

                // 守护存入缓存 KEY = guardian_host_主播id_user_用户id
                $guardian_user = array(
                    'id'=> $table_id,
                    'uid'=> $user_id,
                    'host_id' => $host_id,
                    'starttime' => NOW_TIME,
                    'endtime' =>$time,
                    'guardianid' =>$id,
                    'name' => $classification['name'],
                    'img_bg' => $classification['img_bg'],
                    'img_identification' => $classification['img_identification'],
                    'img' => $classification['img'],
                    'privilege' => $classification['privilege'],
                    'classification_id'=>$guardian['classification_id']
                );
                $expire = $time - NOW_TIME;
                redis_set("guardian_host_".$host_id."_user_".$user_id,json_encode($guardian_user),$expire);

                // 消费和收益记录表
                add_user_consumption_log($user_id,$host_id,$guardian['coin'],$guardian['name'].$guardian_name.api_lang('guardian_gift'),$guardian['coin'],0,2);

                $sql = "select * from " . DB_PREFIX . "video where user_id = " . $host_id . "  and (live_in=1 or live_in=3)";
                $video = $GLOBALS['db']->getRow($sql); //查询直播信息

                $notice = $this->get_guardians_notice($guardian['classification_id']);  //是否有开通通知
                $content = $guardian['name']."(".$guardian['id'].")";
                add_user_records( $user_id,$host_id,$guardian['coin'],$guardian['coin'],$before_user_diamonds,$before_to_ticket,0,0,$content,3);

                //飘屏
                $ext = array();
                $ext['type'] = 81;
                $ext['room_id'] = empty($video)?0:$video['id'];//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                $ext['sender']['user_id'] = $user_id;
                $ext['sender']['host_nickname'] = emoji_decode($host_info['nick_name']); //主播昵称
                $ext['sender']['nick_name'] = emoji_decode($user['nick_name']);
                $ext['sender']['user_level'] = $user['user_level'];//用户等级
                $ext['sender']['head_image'] = get_spec_image($user['head_image']);//发送人头像
                $ext['sender']['sex'] = $user['sex'];
                $ext['sender']['guardian_remind'] = $notice['notice'];  //1有开通通知权限
                $ext['sender']['guardian_broadcast'] = $notice['all'];  //1有全站关播的权限
                $ext['text'] =  api_lang("congratulations") . emoji_decode($user['nick_name']) . api_lang("Buy_Guardian").':' . $classification['name'] . api_lang("success") ;
                $ext['guardian_img'] = $classification['img'];//开通的守护图标
                $ext['guardian_name'] = $classification['name'];//开通的守护名称
                #构造高级接口所需参数
                $msg_content = array();
                //创建array 所需元素
                $msg_content_elem = array(
                    'MsgType' => 'TIMCustomElem',       //自定义类型
                    'MsgContent' => array(
                        'Data' => json_encode($ext),
                        'Desc' => '',
                    )
                );

                //将创建的元素$msg_content_elem, 加入array $msg_content
                array_push($msg_content, $msg_content_elem);

                //发送广播：守护购买成功
                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();

                if($notice['all'] == 1){ //全站广播
                    $api->group_send_group_msg2($user_id, $m_config['full_group_id'], $msg_content);
                }else{//直播间通知
                    $api->group_send_group_msg2($user_id, $video['group_id'], $msg_content);
                }
            }
            //邀请码分销
            $root['status'] = 1;
            $root['error'] = api_lang("Success_in_guarding");


        }
        ajax_return($root);

    }

    //获取守护规则详情
    public function details()
    {
        $root = array();
        $root['status'] = 1;
        $article = $GLOBALS['db']->getRow("select a.* from " . DB_PREFIX . "article as a where is_effect = 1 and is_delete = 0 and title='守护规则' order by sort desc", true, true);
        $root['content'] = $article['content'];
        $root['title'] = $article['title'];
        $root['page_title'] = $article['title'];
        api_ajax_return($root);
    }

    //显示守护特效详情
    public function get_guardian_details()
    {
        $root = array();

        $id = $_REQUEST['id'];
        $root = get_guardian_type_one($id);
        /* 
        foreach ($root as &$v) {
            $v['centent']=htmlspecialchars_decode($v['centent']);
        }*/
        $root['status'] = 1;
        $root['page_title'] = $root && $root['name'] ? $root['name'] : '';

        api_ajax_return($root);
    }

    //获取守护开通特权 是否有开通通知和返回特效id
    public function get_guardians_notice($id)
    {

        $guardian =get_guardian_classification_one($id);

        $type_name = explode(',', $guardian['privilege']);
        $notice = 0;//没有权限开通通知
        $all = 0;//没有全站广播权限
        if ($type_name) {

            $guardian_type_1 = get_guardian_type_one(1);
            $guardian_type = $guardian_type_1 ? $guardian_type_1['id'] : '';

            $guardian_type_5 = get_guardian_type_one(5);
            $all_type = $guardian_type_5 ? $guardian_type_5['id'] : '';
            foreach ($type_name as $v) {
                if ($v == $guardian_type) {
                    $notice = 1;
                }else if($v == $all_type){
                    $all = 1;
                }
            }
        }
        $data = ['notice' => $notice,'all' => $all];

        return $data;
    }

    //获取守护类型列表
    private function get_guardian_type()
    {
        $sql = "select * from " . DB_PREFIX . "guardian_classification order by sort desc";
        $guardian = $GLOBALS['db']->getAll($sql);
        foreach ($guardian as &$v) {
            $sql = "select * from " . DB_PREFIX . "guardian where classification_id=" . $v['id'] . " order by sort desc";
            $v['guardian_pay'] = $GLOBALS['db']->getAll($sql);

            $v['img_bg'] = get_spec_image($v['img_bg']);
            $v['img_identification'] = get_spec_image($v['img_identification']);
            $v['img'] = get_spec_image($v['img']);

            $type_name = explode(',', $v['privilege']);
            $v['type_name'] = $type_name;

        }
        return $guardian;
    }


    //获取守护特效列表
    private function get_guardian_special_effects()
    {
        $guardian = load_auto_cache("guardian_type");
        foreach ($guardian as &$v) {
            $v['select_icon'] = get_spec_image($v['select_icon']);
            $v['default_icon'] = get_spec_image($v['default_icon']);
            $v['centent'] = htmlspecialchars($v['centent']);
        }
        return $guardian;
    }

    /**
     * @deprecated
     */
    private function old_guardians_list($host_id)
    {
        $key = "rank:guardians:" . $host_id . ':';

        $guardian = $GLOBALS['cache']->get($key, true);
        if ($guardian == false) {
            $where = "v.host_id=" . $host_id . " and v.endtime >=" . NOW_TIME;
            $group = " GROUP BY v.uid";
            $order = " order BY total_diamonds desc";
            $field = "v.uid,u.nick_name as nick_name,u.head_image,u.sex,u.user_level,u.use_diamonds as total_diamonds";

            //$sql = "select " . $field . " from " . DB_PREFIX . "guardian_user v left join " . DB_PREFIX . "user u on u.id = v.uid join " . DB_PREFIX . "guardian g on g.id = v.guardianid  where " . $where . $group . $order;
            $sql = "select " . $field . " from " . DB_PREFIX . "guardian_user v left join " . DB_PREFIX . "user u on u.id = v.uid  where " . $where . $group . $order;

            $guardian = $GLOBALS['db']->getAll($sql);

//            foreach ($guardian as &$v) {
//                $v['head_image'] = get_spec_image($v['head_image']);
//            }

            $GLOBALS['cache']->set($key, $guardian, 60, true);//缓存时间
        }
        return $guardian;

        //获取守护数量
        //$sql = "select count(*) from " . DB_PREFIX . "guardian_user where " . "host_id=" . $host_id;

    }


    //获取本周的时间
    private function get_weeks()
    {
        //当前日期
        $sdefaultDate = date("Y-m-d");
        //$first =1 表示每周星期一为开始日期 0表示每周日为开始日期
        $first = 1;
        //获取当前周的第几天 周日是 0 周一到周六是 1 - 6
        $w = date('w', strtotime($sdefaultDate));
        //获取本周开始日期，如果$w是0，则表示周日，减去 6 天
        $start = $w ? $w - $first : 6;
        $week_start = date('Ym', strtotime("$sdefaultDate -" . $start . ' days'));
        $start_str = strtotime("$sdefaultDate -" . $start . ' days');

        //本周结束日期
        $week_end = date('Ym', strtotime($sdefaultDate));
        $data['start'] = $week_start;       //本周开始的日期
        $data['end'] = $week_end;          //当天的日期
        $data['start_str'] = $start_str;     //本周开始时间戳
        $data['end_str'] = NOW_TIME;          //当前时间戳
        return $data;
    }

    //获取本周的排名周星榜
    private function guardians_list($host_id)
    {
        //获取开始时间
        $weeks = $this->get_weeks();
        $table = createPropTable();

        $t = $weeks['end_str'];//这里和标准时间相差8小时需要补足
        $where = "v.status=1 and v.host_id=" . $host_id . "   and  v.endtime >= " . NOW_TIME . " and v.starttime <= " . NOW_TIME;
        $left_prop = " on b.to_user_id = v.host_id and b.from_user_id=v.uid and b.create_time >= v.starttime  and b.create_time <= " . $t . " and b.is_red_envelope = 0 "; //消费金额必须是开通后的
        $group = " GROUP BY v.uid";
        $order = " order BY sum(b.total_diamonds) desc,(v.endtime - ".NOW_TIME.") desc";
        $field = "v.uid,u.nick_name as nick_name,u.head_image,u.sex,u.user_level,g.type,sum(b.total_diamonds) as  total_diamonds,v.endtime,v.starttime";
        if ($weeks['start'] == $weeks['end']) {

            $sql = "select " . $field . " from " . DB_PREFIX . "guardian_user v left join " . $table . " b " . $left_prop . " join " . DB_PREFIX . "user u on u.id = v.uid join " . DB_PREFIX . "guardian g on g.id = v.guardianid  where " . $where . $group . $order;
        } else {
            $end = DB_PREFIX . "video_prop_" . $weeks['end'];
            $sql = "select " . $field . " from " . DB_PREFIX . "guardian_user v join " . DB_PREFIX . "user u on u.id = v.uid join " . DB_PREFIX . "guardian g on g.id = v.guardianid left join (SELECT * FROM " . $table . " UNION ALL SELECT * FROM " . $end . ") AS b " . $left_prop . " where " . $where . $group . $order;
        }

        $guardian = $GLOBALS['db']->getAll($sql);

        foreach ($guardian as &$v) {
            $v['nick_name'] = emoji_decode($v['nick_name']);
            $v['head_image'] = get_spec_image($v['head_image']);
            $v['total_diamonds'] = intval($v['total_diamonds']);
            $time = $v['endtime'] - NOW_TIME;
            $day = $time/(60*60*24); //转化为天
            $v['endtime'] = round($day).api_lang('day');
        }
        return $guardian;

    }

    //统计守护数量
    private function get_guardian_sum($host_id)
    {
        $sql = "select count(v.id) from " . DB_PREFIX . "guardian_user v left join " . DB_PREFIX . "user u on u.id = v.uid left join " . DB_PREFIX . "guardian g on g.id = v.guardianid where v.host_id=" . $host_id . " and v.endtime >= " . time() . " and v.status=1";
        $guardian = $GLOBALS['db']->getOne($sql);
        return $guardian;
    }

    //获取是否是守护者
    private function get_guardian_one($host_id, $id)
    {
        $sql = "select v.*,g.classification_id from " . DB_PREFIX . "guardian_user v left join " . DB_PREFIX . "guardian g on g.id = v.guardianid where v.host_id=" . $host_id . " and v.uid=" . $id . " and v.endtime >= " . time() . " and v.status=1";
        $guardian = $GLOBALS['db']->getRow($sql);
        return $guardian;
    }


}