<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class indexModule extends baseModule
{


    /**
     * 获取语音轮播图
     */
    public function get_voice_banner_list()
    {
        $root = array("status" => 1, "msg" => "", "data" => array());
        $root['data'] = load_auto_cache("banner_list", array('is_voice' => 1));
        ajax_return($root);
    }

    /**
     * 获取热门页面 --- 语音房间列表分页
     */
    public function voice_index()
    {
        $root = array();
        $sex = intval($_REQUEST['sex']);//性别 0:全部, 1-男，2-女
        $cate_id = intval($_REQUEST['cate_id']);//话题id
        $city = strim($_REQUEST['city']);//城市(空为:热门)
        $is_classify = intval($_REQUEST['is_classify']);//分类
        $is_voice = intval($_REQUEST['is_voice']);
        $country_code = strim($_REQUEST['country_code']); // 国家code 大于10000使用的是热门的id
        $user_lang_id = strim($_REQUEST['user_lang_id']); // 用户语言code (例如：en)
        if($country_code){
            if(intval($country_code) >= 10000){
                $country_code_id = intval(intval($country_code) / 10000);
                $hot_country = redis_hget("country_hot_id",$country_code_id);
                if ($hot_country) {
                    $hot_country_val = json_decode($hot_country, true);
                    $country_code = $hot_country_val['num_code'];
                }else{
                    $country_code = '';
                }
            }
          //  $country_code = urldecode($country_code); // 解码后得到 "12,156"
        }

        $root['banner'] = array();
        $page = intval($_REQUEST['p']);//取第几页数据
        if ($page == 0) {
            $page = 1;
        }
        $page_size = 50;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        $root['sex'] = $sex;
        $root['cate_id'] = $cate_id;
        $root['city'] = $city;

        $sql = "SELECT u.country_code,v.id AS room_id,v.is_voice,v.password, v.sort_num, v.group_id, v.user_id, v.city, v.title, v.cate_id, v.live_in, v.video_type, v.create_type, v.room_type,
						(/*v.robot_num + v.watch_number +*/ v.virtual_watch_number ) as watch_number, u.labels, u.head_image,u.thumb_head_image,v.live_image, v.xpoint,v.ypoint,
						u.v_type, u.v_icon, u.nick_name,u.user_level,v.is_live_pay,v.live_pay_type,v.live_fee,u.create_time as user_create_time FROM " . DB_PREFIX . "video v 
					LEFT JOIN " . DB_PREFIX . "user u ON u.id = v.user_id where v.live_in in (1,3) and u.is_hot_on =0 and  u.mobile != '13888888888' and u.mobile != '13999999999'  ";

        if ($is_classify) {
            $sql .= " and v.classified_id = " . $is_classify; //分类
        }
        $sql .= " and v.is_voice =1 and v.password = ''"; // 不是语音房间
        if ($country_code) {
            $country_list = explode(',', $country_code);
            if (count($country_list)) {
                if (count($country_list) == 1) {
                    $sql .= " and u.country_code = " . intval($country_code); // 国家code
                }else{
                    // 多个国家code
                    $sql .= " and u.country_code in (".$country_code.") "; // 国家code
                }
            }
        }

        if ($user_lang_id) {
            $sql .= " AND u.user_lang ='" .$user_lang_id."'";
        }
        if ($sex == 1 || $sex == 2) {
            $sql .= ' and v.sex = ' . $sex;
        }

        if ($city != '') {
            $sql .= " and v.province = '" . $city . "'";
        }

        if ($cate_id > 0) {
            $sql .= " and v.cate_id = '" . $cate_id . "'";
        }

        $sql .= "  order by v.is_recommend desc,v.sort_num desc,v.sort desc limit " . $limit;

        $list = $GLOBALS['db']->getAll($sql, true, true);

        foreach ($list as $k => $v) {
            //判断用户是否为今日创建的新用户，是：1，否：0
            if (date('Y-m-d') == date('Y-m-d', $list[$k]['user_create_time'] + 3600 * 8)) {
                $list[$k]['today_create'] = 1;
            } else {
                $list[$k]['today_create'] = 0;
            }

            if ($v['live_image'] == '') {
                if (strpos($v['head_image'], 'wx.qlogo.cn') !== false) {
                    $list[$k]['live_image'] = strtr($v['head_image'], array('/96' => '/0'));
                } elseif (strpos($v['head_image'], 'http://q.qlogo.cn/') !== false) {
                    $list[$k]['live_image'] = strtr($v['head_image'], array('/40' => '/100'));
                } else {
                    $list[$k]['live_image'] = get_spec_image($v['head_image']);
                }
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
            } else {
                $list[$k]['live_image'] = get_spec_image($v['live_image']);
                $list[$k]['head_image'] = get_spec_image($v['head_image'], 150, 150);
            }

            if (strpos($v['head_image'], 'wx.qlogo.cn') !== false) {
                $list[$k]['thumb_head_image'] = strtr($v['head_image'], array('/96' => '/46'));
            } else {
                if ($v['thumb_head_image'] == '') {
                    $list[$k]['thumb_head_image'] = get_spec_image($v['head_image'], 150, 150);
                } else {
                    //$list[$k]['thumb_head_image'] = get_abs_img_root($v['thumb_head_image']);
                    $list[$k]['thumb_head_image'] = get_spec_image($v['thumb_head_image'], 150, 150);
                }
            }

            if ($list[$k]['live_image'] == '') {
                $list[$k]['live_image'] = get_spec_image($v['head_image']);
            }

            $list[$k]['live_state'] =  api_lang('voice');

            $list[$k]['nick_name'] = emoji_decode($v['nick_name']);

        }


        if (defined('SHOW_IS_GAMING') && SHOW_IS_GAMING) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/GamesRedisService.php');
            $video_redis = new VideoRedisService();
            $redis = new GamesRedisService();
            foreach ($list as $key => $value) {
                $video_id = intval($value['room_id']);
                $live_in = $video_redis->getOne_db($video_id, 'live_in') == 1;
                $game_log_id = $video_redis->getOne_db($video_id, 'game_log_id');
                $list[$key]['is_gaming'] = ($game_log_id && $live_in) ? 1 : 0;
                $game_name = '';
                if ($game_log_id) {
                    $game = $redis->get($game_log_id, 'game_id');
                    $game_name = $GLOBALS['db']->getOne("select name from " . DB_PREFIX . "games where id = " . $game['game_id']);
                }
                $list[$key]['is_video_pk'] = $this->is_video_pk($value['user_id']);
                $list[$key]['game_name'] = $game_name;
                $country_flag = get_country_flag($value['country_code']);
                $list[$key]['country_img'] = $country_flag['country_img']; // 国旗

                //主播标签
                if (!empty($value['labels'])) {
                   // $lable = $GLOBALS['db']->getRow('select name,color from ' . DB_PREFIX . "user_label where url like '%" . $value['labels'] . "%'");
                    $lable = $GLOBALS['db']->getRow('select name,color,url from ' . DB_PREFIX . 'user_label where id =' . intval($value['labels']));

                    if (!empty($lable)) {
                        $list[$key]['lable_title'] = $lable['name'];
                        $list[$key]['lable_color'] = $lable['color'];
                        $list[$key]['lable_url'] = $lable['url'];
                    } else {
                        $list[$key]['lable_title'] = '';
                        $list[$key]['lable_color'] = '';
                        $list[$key]['lable_url'] =  '';
                    }
                } else {
                    $list[$key]['lable_title'] = '';
                    $list[$key]['lable_color'] = '';
                    $list[$key]['lable_url'] =  '';
                }
                //直播间实时观看人数
                $fields = array('vote_number', 'watch_number', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id');
                $video_number = $video_redis->getRow_db($video_id, $fields);
                $list[$key]['watch_number'] = intval($video_number['watch_number'] + $video_number['robot_num'] + $video_number['virtual_watch_number']);
            }
        }

        if ($is_voice) {
            //推荐前四个放到上面
            $root['recommend_list'] = [];
            //截取掉前四个人
            $root['list'] = $list;
        } else {
            //推荐前四个放到上面
            $root['recommend_list'] = array_slice($list, 0, 4);
            //截取掉前四个人
            $root['list'] = array_slice($list, count($root['recommend_list']));
        }
        $root['status'] = 1;
        $root['has_next'] = 0;
        $root['page'] = 1;

        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

        ajax_return($root);
    }

    /**
     *  热门页面接口
     */
    public function index()
    {
        $root = array();
        $sex = intval($_REQUEST['sex']);//性别 0:全部, 1-男，2-女
        $cate_id = intval($_REQUEST['cate_id']);//话题id
        $city = strim($_REQUEST['city']);//城市(空为:热门)
        $is_voice = intval($_REQUEST['is_voice']); // 是否是语音房间1是0否
        $country_code = strim($_REQUEST['country_code']); // 国家code,多个使用逗号隔开
        $user_lang_id = strim($_REQUEST['user_lang_id']); // 用户语言id
        if ($city == '热门' || $city == 'null') {
            $city = '';
        }
        if($country_code){
            if(intval($country_code) >= 10000){
                $country_code_id = intval(intval($country_code) / 10000);
                $hot_country = redis_hget("country_hot_id",$country_code_id);
                if ($hot_country) {
                    $hot_country_val = json_decode($hot_country, true);
                    $country_code = $hot_country_val['num_code'];
                }else{
                    $country_code = '';
                }
            }
            //  $country_code = urldecode($country_code); // 解码后得到 "12,156"
        }
        if ($cate_id == 0) {
            //首页 轮播
            if ($is_voice != 1) {
                //首页 轮播
                $root['banner'] = load_auto_cache("banner_list", array('is_voice' => 0));
            } else {
                $root['banner'] = array();
            }
            if ($root['banner'] == false) {
                $root['banner'] = array();
            }
        } else {
            //主题相关内容
            $cate = load_auto_cache("cate_id", array('id' => $cate_id));
            if ($cate['url'] != '' && $cate['image'] != '') {
                $root['banner'] = $cate['banner'];
                $root['cate'] = $cate;
            }
        }

        $root['sex'] = $sex;
        $root['cate_id'] = $cate_id;
        $root['city'] = $city;

        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        $dev_type = strim($_REQUEST['sdk_type']);
        $is_video_all = $m_config['popular_live_types'] == 1 ? 0 : 1;
        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
            $list = $this->check_video_list("select_video_check", array('sex_type' => $sex, 'area_type' => $city, 'cate_id' => $cate_id,'country_code'=>$country_code,'user_lang_id'=>$user_lang_id));
        } else {
            $list = load_auto_cache("select_video", array('sex_type' => $sex, 'area_type' => $city, 'cate_id' => $cate_id, 'is_voice' => $is_voice, 'is_video_all' => $is_video_all,'country_code'=>$country_code,'user_lang_id'=>$user_lang_id));
        }

        if (defined('SHOW_IS_GAMING') && SHOW_IS_GAMING) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/GamesRedisService.php');
            $video_redis = new VideoRedisService();
            $redis = new GamesRedisService();
            foreach ($list as $key => $value) {
                $video_id = intval($value['room_id']);
                $live_in = $video_redis->getOne_db($video_id, 'live_in') == 1;
                $game_log_id = $video_redis->getOne_db($video_id, 'game_log_id');
                $list[$key]['is_gaming'] = ($game_log_id && $live_in) ? 1 : 0;
                $game_name = '';
                if ($game_log_id) {
                    $game = $redis->get($game_log_id, 'game_id');
                    $game_name = $GLOBALS['db']->getOne("select name from " . DB_PREFIX . "games where id = " . $game['game_id']);
                }
                $list[$key]['is_video_pk'] = $this->is_video_pk($value['user_id']);
                $list[$key]['game_name'] = $game_name;

                $country_flag = get_country_flag($value['country_code']);
                $list[$key]['country_img'] = $country_flag['country_img']; // 国旗

                //主播标签
                if (!empty($value['labels'])) {
                    $lable = $GLOBALS['db']->getRow('select name,color,url from ' . DB_PREFIX . 'user_label where id =' . intval($value['labels']));

                    if (!empty($lable)) {
                        $list[$key]['lable_title'] = $lable['name'];
                        $list[$key]['lable_color'] = $lable['color'];
                        $list[$key]['lable_url'] = $lable['url'];
                    } else {
                        $list[$key]['lable_title'] = '';
                        $list[$key]['lable_color'] = '';
                        $list[$key]['lable_url'] = '';
                    }
                } else {
                    $list[$key]['lable_title'] = '';
                    $list[$key]['lable_color'] = '';
                    $list[$key]['lable_url'] = '';
                }
                //直播间实时观看人数
                $fields = array('vote_number', 'watch_number', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id');
                $video_number = $video_redis->getRow_db($video_id, $fields);
                $list[$key]['watch_number'] = intval($video_number['watch_number'] + $video_number['robot_num'] + $video_number['virtual_watch_number']);
                if ($value['live_in'] == 3) {
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
                    $video_redis = new VideoRedisService();
                    $video_redis->video_online($video_id, $value['group_id']);
                }

            }
        }

        if ($is_voice) {
            //推荐前四个放到上面
            $root['recommend_list'] = [];
            //截取掉前四个人
            $root['list'] = $list;
        } else {
            //推荐前四个放到上面
            $root['recommend_list'] = array_slice($list, 0, 4);
            //截取掉前四个人
            $root['list'] = array_slice($list, count($root['recommend_list']));
        }
        $root['status'] = 1;
        $root['has_next'] = 0;
        $root['page'] = 1;//

        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

        ajax_return($root);
    }

    /**
     * 是否正在pk
     **/
    public function is_video_pk($id)
    {
        $sql = "select * from " . DB_PREFIX . "video_pk where (emcee_user_id1=" . $id . " or emcee_user_id2=" . $id . ") and status > 0";
        $video = $GLOBALS['db']->getRow($sql);
        if ($video) {
            return 1;
        }
        return 0;
    }

    /**
     * 最新 &&附近的人
     */
    public function new_video()
    {

        $root = array();

        $root['cate_top'] = load_auto_cache("cate_top");

        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        $dev_type = strim($_REQUEST['sdk_type']);
        $is_voice = intval($_REQUEST['is_voice']); // 是否是语音房间1是0否

        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
            $list = $this->check_video_list("new_video_check", array('is_voice' => $is_voice));
        } else {
            $list = load_auto_cache("new_video", array('is_voice' => $is_voice));
        }


        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();


        foreach ($list as &$v) {
            $v['is_video_pk'] = $this->is_video_pk($v['user_id']);

            //主播标签
            if (!empty($v['labels'])) {
                $lable = $GLOBALS['db']->getRow('select name,color from ' . DB_PREFIX . "user_label where url like '%" . $v['labels'] . "%'");

                if (!empty($lable)) {
                    $v['lable_title'] = $lable['name'];
                    $v['lable_color'] = $lable['color'];
                } else {
                    $v['lable_title'] = '';
                    $v['lable_color'] = '';
                }
            } else {
                $v['lable_title'] = '';
                $v['lable_color'] = '';
            }

            //直播间实时观看人数
            $fields = array('vote_number', 'watch_number', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id');
            $video_number = $video_redis->getRow_db($v['room_id'], $fields);
            $v['watch_number'] = intval($video_number['watch_number'] + $video_number['robot_num'] + $video_number['virtual_watch_number']);

            $v['nick_name'] = emoji_decode($v['nick_name']);
            $v['title'] = emoji_decode($v['title']);
        }
        $root['list'] = $list;
        $root['status'] = 1;
        $root['has_next'] = 0;
        $root['page'] = 1;//
        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

        ajax_return($root);
    }

    /**
     * PC端附近的人
     */
    public function new_pc_video()
    {
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        $dev_type = strim($_REQUEST['sdk_type']);
        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
            $list = $this->check_video_list("new_video_check", array('create_type' => 1));
        } else {
            $list = load_auto_cache("new_video", array('create_type' => 1));
        }

        $root = array();
        $root['list'] = $list;
        $root['status'] = 1;
        $root['has_next'] = 0;
        $root['page'] = 1;//

        ajax_return($root);

    }

    /**
     * 获取语音房间人气最高3个房间 watch_number 当前实际人数
     */
    public function voice_popularity()
    {
        //  $list[$key]['watch_number'] = intval($video_number['watch_number'] + $video_number['robot_num'] + $video_number['virtual_watch_number']);
        $root = array('status' => 1, 'error' => '', 'data' => array());
        $sql = "SELECT v.id AS room_id,v.is_voice,v.wheat_type,v.announcement,v.password, v.sort_num, v.group_id, v.user_id, v.city, v.title, v.cate_id, v.live_in, v.video_type, v.create_type, v.room_type,
						(v.virtual_watch_number+v.watch_number+v.robot_num) as watch_number, u.labels, u.head_image,u.thumb_head_image,v.live_image, v.xpoint,v.ypoint,
						u.v_type, u.v_icon, u.nick_name,u.user_level,v.is_live_pay,v.live_pay_type,v.live_fee,u.create_time as user_create_time FROM " . DB_PREFIX . "video v 
					LEFT JOIN " . DB_PREFIX . "user u ON u.id = v.user_id where v.live_in =1";

        $sql .= " and v.is_voice =1 and v.room_type = 3 and v.password = ''"; // 语音房间
        $sql .= " order by v.watch_number desc limit 0,10";

        $list = $GLOBALS['db']->getAll($sql, true, true);
        foreach ($list as $k => $v) {

            if ($v['live_image'] == '') {
                if (strpos($v['head_image'], 'wx.qlogo.cn') !== false) {
                    $list[$k]['live_image'] = strtr($v['head_image'], array('/96' => '/0'));
                } elseif (strpos($v['head_image'], 'http://q.qlogo.cn/') !== false) {
                    $list[$k]['live_image'] = strtr($v['head_image'], array('/40' => '/100'));
                } else {
                    $list[$k]['live_image'] = get_spec_image($v['head_image']);
                }
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
            } else {
                $list[$k]['live_image'] = get_spec_image($v['live_image']);
                $list[$k]['head_image'] = get_spec_image($v['head_image'], 150, 150);
            }

            if (strpos($v['head_image'], 'wx.qlogo.cn') !== false) {
                $list[$k]['thumb_head_image'] = strtr($v['head_image'], array('/96' => '/46'));
            } else {
                if ($v['thumb_head_image'] == '') {
                    $list[$k]['thumb_head_image'] = get_spec_image($v['head_image'], 150, 150);
                } else {
                    //$list[$k]['thumb_head_image'] = get_abs_img_root($v['thumb_head_image']);
                    $list[$k]['thumb_head_image'] = get_spec_image($v['thumb_head_image'], 150, 150);
                }
            }

            if ($list[$k]['live_image'] == '') {
                $list[$k]['live_image'] = get_spec_image($v['head_image']);
            }

            $list[$k]['live_state'] = '';
            if ($v['live_in'] == 1) {
                if ($v['is_live_pay'] == 0) {
                    $list[$k]['live_state'] = $v['is_voice'] == 1 ? api_lang("live_voice") : api_lang("live_broadcast");
                } else if ($v['is_live_pay'] == 1) {
                    $list[$k]['live_state'] = api_lang("pay_live");
                }
            } else {
                if ($v['is_live_pay'] == 1) {
                    $list[$k]['live_state'] = api_lang("pay_back");
                } else if ($v['is_live_pay'] == 0 && intval($v['is_gather']) != 1) {
                    $list[$k]['live_state'] = api_lang("back");
                } else if (intval($v['is_gather']) == 1) {
                    $list[$k]['live_state'] = api_lang("live_broadcast");
                }
            }
            if ($list[$k]['live_state'] == api_lang("live_broadcast") && $v['room_type'] == 1) {
                $list[$k]['live_state'] = api_lang("private_live");
            }
            $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
        }
        $root['data'] = $list;
        ajax_return($root);
    }

    /**
     * 我关注的主播 直播
     */
    public function focus_video()
    {
        $root['page_title'] = api_lang("follow");
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : 0;
        //$user_id = $_REQUEST['uid'];
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        } else {
            //关注
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $userfollw_redis = new UserFollwRedisService($user_id);
            $user_list = $userfollw_redis->following();
            $is_voice = intval($_REQUEST['is_voice']); // 是否是语音房间1是0否

            //私密直播  video_private,私密直播结束后， 本表会清空
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
            $video_private_redis = new VideoPrivateRedisService();
            $private_list = $video_private_redis->get_video_list($user_id);
            $list = array();
            $user_video = array();
            if (sizeof($private_list) || sizeof($user_list)) {
                $m_config = load_auto_cache("m_config");//初始化手机端配置
                $sdk_version_name = strim($_REQUEST['sdk_version_name']);
                $dev_type = strim($_REQUEST['sdk_type']);
                if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
                    $list_all = load_auto_cache("select_video_check", array('has_private' => 1));
                } else {
                    $list_all = load_auto_cache("select_video", array('has_private' => 1, 'is_voice' => $is_voice));
                }

                foreach ($list_all as $k => $v) {

                    //主播标签
                    if (!empty($v['labels'])) {
                        $lable = $GLOBALS['db']->getRow('select name,color from ' . DB_PREFIX . "user_label where url like '%" . $v['labels'] . "%'");
                        if (!empty($lable)) {
                            $v['lable_title'] = $lable['name'];
                            $v['lable_color'] = $lable['color'];
                        } else {
                            $v['lable_title'] = '';
                            $v['lable_color'] = '';
                        }
                    } else {
                        $v['lable_title'] = '';
                        $v['lable_color'] = '';
                    }

                    if ((($v['room_type'] == 1 && in_array($v['room_id'], $private_list)) || ($v['room_type'] == 3 && in_array($v['user_id'], $user_list))) && ($v['user_id'] != '13888888888' || $v['user_id'] != '13999999999')) {
                        $v['is_video_pk'] = $this->is_video_pk($v['user_id']);
                        $list[] = $v;
                    } else if ($v['user_id'] == $user_id && $v['room_type'] == 1 && $v['live_in'] == 1) {
                        $v['is_video_pk'] = $this->is_video_pk($v['user_id']);
                        $user_video = $v;
                    }


                }
            }

            if ($user_video) {
                array_unshift($list, $user_video);
            }

            $root['data'] = $list;

            $playback = load_auto_cache("playback_list", array('user_id' => $user_id));
            foreach ($playback as $k => $v) {
                $playback[$k]['nick_name'] = emoji_decode($v['nick_name']);
            }
            $root['playback'] = $playback;
            $root['status'] = 1;

        }
        ajax_return($root);
    }

    /**
     * 查询话题列表
     */
    function search_video_cate()
    {

        $page = intval($_REQUEST['p']);//取第几页数据
        $title = strim($_REQUEST['title']);

        if ($page == 0) {
            $page = 1;
        }

        $page_size = 50;
        $limit = (($page - 1) * $page_size) . "," . $page_size;

        if ($title) {
            $sql = "select vc.id as cate_id,vc.title,vc.num from " . DB_PREFIX . "video_cate as vc
						where vc.is_effect = 1 and vc.title like '%" . $title . "%' order by vc.sort desc, vc.num desc limit " . $limit;

        } else {
            $sql = "select vc.id as cate_id,vc.title,vc.num from " . DB_PREFIX . "video_cate as vc
						where vc.is_effect = 1  order by vc.sort desc, vc.num desc limit " . $limit;
        }

        //查询话题列表,修改成 从只读数据库中取,但不是高效做法;主并发时,可以加入阿里云的搜索服务
        //https://www.aliyun.com/product/opensearch?spm=5176.8142029.388261.62.tgDxhe
        $list = $GLOBALS['db']->getAll($sql, true, true);
        foreach ($list as $k => $v) {
            $list[$k]['title'] = "#" . $v['title'] . "#";
        }
        if ($page == 0) {
            $root['has_next'] = 0;
        } else {
            if (count($list) == $page_size)
                $root['has_next'] = 1;
            else
                $root['has_next'] = 0;
        }

        $root['page'] = $page;//

        $root['list'] = $list;

        $root['status'] = 1;

        ajax_return($root);
    }

    //按地区（省份）
    //0:全部;1:男;2:女
    function search_area()
    {
        $sex = intval($_REQUEST['sex']);//性别 0:全部, 1-男，2-女
        $list = load_auto_cache("sex_area", array('sex' => $sex));

        $root = array();
        $root['list'] = $list;
        $root['status'] = 1;
        $root['total_num'] = count($list);

        ajax_return($root);
    }

    /**
     * IOS 审核版本读取
     * @param string $type
     * @param array  $date
     * @return mixed|string
     */
    function check_video_list($type = '', $date = array())
    {
        $list = '';
        if ($type != '') {
            if ($type == 'new_video_check') {
                $list = load_auto_cache("new_video_check");
            } else {
                $list = load_auto_cache("select_video_check", $date);
            }
        }
        return $list;
    }

    /**
     * 分类
     */
    public function classify()
    {
        $root = array();
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $sdk_version_name = strim($_REQUEST['sdk_version_name']);
        $dev_type = strim($_REQUEST['sdk_type']);
        $classified_id = intval($_REQUEST['classified_id']);
        $is_voice = intval($_REQUEST['is_voice']); // 是否是语音房间1是0否
        if (!$classified_id) {
            $classified_id = 1;
        }
        if ($dev_type == 'ios' && $m_config['ios_check_version'] != '' && $m_config['ios_check_version'] == $sdk_version_name) {
            $list = $this->check_video_list("select_video_check", array('is_classify' => $classified_id));
        } else {
            $list = load_auto_cache("select_video", array('is_classify' => $classified_id, 'is_voice' => $is_voice));
        }
        foreach ($list as &$v) {
            $v['is_video_pk'] = $this->is_video_pk($v['user_id']);
        }
        $root['list'] = $list;
        $root['status'] = 1;
        $root['has_next'] = 0;
        $root['page'] = 1;//
        $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

        ajax_return($root);
    }

    /**
     * 公会列表的显示
     */
    function society()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//登录用户id
            //获取用户的公会ID
            $sql3 = "select society_id from " . DB_PREFIX . "user where id=" . $user_id . ";";
            $res3 = $GLOBALS['db']->getOne($sql3);
            $root['error'] = "";
            $root['status'] = 1;

            //模糊查询
            $society_filtrate = $_REQUEST['society_filtrate'] ? $_REQUEST['society_filtrate'] : 0;
            $where = "s.status=1";
            if ($society_filtrate) {
                $where .= " and (s.id like '%" . $society_filtrate . "%' or s.name like '%" . $society_filtrate . "%')";
            }

            //分页
            $page = $_REQUEST['page'] ? $_REQUEST['page'] : 1;//当前页
            if ($page != null) {
                $page_size = 20;//分页数量
                //获取总条数
                $sql1 = "select count(*) from " . DB_PREFIX . "society s where " . $where;
                $res1 = intval($GLOBALS['db']->getOne($sql1));
                //总页数
                $page_total = ceil($res1 / $page_size);
                //分页
                $limit = (($page - 1) * $page_size) . "," . $page_size;

                $sql = "select s.id,s.logo,s.name,s.user_count,s.status,u.nick_name,u.id as uid from " . DB_PREFIX . "society s inner join " . DB_PREFIX . "user u on s.user_id=u.id where " . $where . " order by s.society_rank desc,s.create_time desc limit " . $limit . ";";
                $res = $GLOBALS['db']->getAll($sql);
                if (empty($res)) {
                    $root['error'] = api_lang("No_guild_display");
                } else {
                    foreach ($res as $key => $val) {
                        if ($user_id == $val['uid']) {//会长
                            $root['list'][$key]['type'] = 1;
                        } elseif ($res3 == $val['id']) {
                            $sql2 = "select id from " . DB_PREFIX . "society_apply where user_id=" . $user_id . " and society_id=" . $val['id'] . " and apply_type=1;";
                            $res2 = $GLOBALS['db']->getOne($sql2);
                            if (empty($res2)) {//会员
                                $root['list'][$key]['type'] = 0;
                            } else {//申请退出公会人员
                                $root['list'][$key]['type'] = 5;
                            }
                        } else {
                            if ($res3 != 0 && $res3 != $val['id']) {//其他公会成员
                                $root['list'][$key]['type'] = 2;
                            } else {
                                $sql4 = "select id from " . DB_PREFIX . "society_apply where user_id=" . $user_id . " and society_id=" . $val['id'] . " and apply_type=0;";
                                $res4 = $GLOBALS['db']->getOne($sql4);
                                if (empty($res4)) {//无公会人员
                                    $root['list'][$key]['type'] = 3;
                                } else {//申请入会人员
                                    $root['list'][$key]['type'] = 4;
                                }
                            }
                        }
                        $root['list'][$key]['society_id'] = intval($val['id']);
                        $root['list'][$key]['society_image'] = get_spec_image($val['logo']);
                        $root['list'][$key]['society_name'] = $val['name'];
                        $root['list'][$key]['society_user_count'] = intval($val['user_count']);
                        $root['list'][$key]['society_chairman'] = emoji_decode($val['nick_name']);
                        $root['list'][$key]['gh_status'] = intval($val['status']);
                    }
                    $has_next = ($res1 > $page * $page_size) ? '1' : '0';//是否有下一页
                    $root['page'] = array('page' => $page, 'page_total' => $page_total, 'has_next' => $has_next);
                }
            } else {
                $root['error'] = api_lang("Reception_problem");
                $root['status'] = 0;
            }

        }
        ajax_return($root);
    }

    /**
     * 推荐主播(显示未关注的)
     * 一页三个
     */
    public function recomme_user()
    {
        $root = array('status' => 1, 'error' => '', 'data' => array());
        $uid = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : 0;
        $first = intval($_REQUEST['first']) ? intval($_REQUEST['first']) : 1; //分页的页数类型 筛选出是否关注的用户0获取所有的 1是获取没有关注的
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;//取第几页数据
        $sql = "select id, sex, nick_name, head_image from " . DB_PREFIX . "user where is_recomme = 1 and id !=" . $uid;
        $count_sql = "select count(id) from " . DB_PREFIX . "user where is_recomme = 1 and id !=" . $uid;
        $page_size = $first == 1 ? 3 : 10;
        $limit = (($page - 1) * $page_size) . "," . $page_size;

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
        $userfollw_redis = new UserFollwRedisService($uid);
        $follow_list = $userfollw_redis->following();
        $follow_val = '';

        if (count($follow_list) > 0 && !empty($first)) {
            foreach ($follow_list as $v) {
                $follow_val .= $v . ',';
            }
            $not_id = rtrim($follow_val, ",");
            $sql .= " and id not in({$not_id})";
            $count_sql .= " and id not in({$not_id})";
        }

        if (is_int(time() / 2)) {
            $order = ' id desc';
        } else {
            $order = ' id asc';
        }

        $sql .= " order by " . $order . " limit {$limit}";

        $list = $GLOBALS['db']->getAll($sql);
        $count = $GLOBALS['db']->getOne($count_sql);
        $max_page = ceil($count / 3);
        foreach ($list as &$v) {
            $v['head_image'] = get_spec_image($v['head_image']);
            // 是否关注
            $v['is_follow'] = $userfollw_redis->is_following($v['id']) ? 1 : 0;
            $v['nick_name'] = emoji_decode($v['nick_name']);
        }
        $root['data'] = array(
            'max_page' => $max_page,
            'list'     => $list
        );
        ajax_return($root);
    }

    /**
     * 直播间音效列表
     */
    public function home_sound()
    {
        $tab = DB_PREFIX . 'sound';
        $sql = "select id, name, url from {$tab} where status = 0 order by `sort` ASC";
        $list = $GLOBALS['db']->getAll($sql);
        return ajax_return(['status' => 1, 'data' => $list]);
    }

    /**
     * 签到列表
     */
    public function signin_list()
    {
        $time = time();
        $root = array();
        $root['error'] = "";
        $root['status'] = 1;
        $today = date('Y-m-d', $time);   // 今日
        $today_time = strtotime($today);
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            ajax_return($root);
        }

        $uid = $GLOBALS['user_info']['id'];
        $sql = "select * from " . DB_PREFIX . "user_signin where uid = {$uid}";
        $signin = $GLOBALS['db']->getRow($sql);
        // 获取签到天数列表
        $sql = "select day,num from " . DB_PREFIX . "user_signin_reward";
        $signin_list = $GLOBALS['db']->getAll($sql);
        $signin_list = formatArray($signin_list, 'day', []);
        $signin_start = $signin['start_time'];
        $signin_count = count($signin_list);
        if ($today_time > ($signin['start_time'] + (86400 * ($signin_count - 1)))) { // 重置签到进度
            $signin_start = $today_time;
        }
        // 获取签到时间列表(一轮签到时间)
        $signin_day = $this->seventDay($signin_start, $signin_count);

        $list = [];
        $signin_count = 0;
        foreach ($signin_day as $k => &$v) {
//            $v['is_sign']= $GLOBALS['db']->getRow($sql)['num'];
            $sql = "select count(id) as num from " . DB_PREFIX . "user_signin_log where addday='{$v}' and uid = '{$uid}'";
            $is_signin = $GLOBALS['db']->getRow($sql)['num'];
            if ($is_signin != 0) $signin_count++;
            $date = date('Y-m-d', $v);
            array_push($list, [
                'day'     => $k + 1,
                'is_sign' => $is_signin,
                'num'     => $signin_list[$k + 1]['num'],
//                'days' => $date,
                'now'     => $today == $date ? 1 : 0,
            ]);
        }
        $root['list'] = $list;
        $root['signin_count'] = $signin_count;

        $s_today = strtotime($today);        // 今日开始时间
        $e_today = strtotime($today . '23:59:59');        // 今日结束时间
        $root['today_signin'] = ($signin['last_time'] >= $s_today && $signin['last_time'] <= $e_today) ? 1 : 0;
        ajax_return($root);

    }

    /**
     * 得到传入时间的前X天(包括传入时间当天)
     * @param $day
     * @return array
     */
    public function seventDay($start_day, $count_day)
    {
        $day_arr = [];
        for ($i = 0; $i < $count_day; $i++) {
            array_push($day_arr, $start_day + (86400 * $i));
        }
        return $day_arr;
    }

    /**
     * 今日是否签到
     */
    public function is_signin()
    {
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            ajax_return($root);
        }
        $root = [];
        $time = time();
        $uid = $GLOBALS['user_info']['id'];
        $sql = "select * from " . DB_PREFIX . "user_signin where uid = {$uid}";
        $signin = $GLOBALS['db']->getRow($sql);
        $today = date('Y-m-d', $time);   // 今日
        $s_today = strtotime($today);        // 今日开始时间
        $e_today = strtotime($today . '23:59:59');        // 今日结束时间
        $root['today_signin'] = ($signin['last_time'] >= $s_today && $signin['last_time'] <= $e_today) ? 1 : 0;
        $root['status'] = 1;
        ajax_return($root);
    }

    /**
     * 用户签到接口
     */
    public function user_signin()
    {
        $time = time();
        if (!$GLOBALS['user_info']) return n_ajax(api_lang("user_not_logged_in"));

        $user_id = intval($GLOBALS['user_info']['id']);//登录用户id

        $today = date('Y-m-d', $time);   // 今日
        $today_time = strtotime($today);
        // 查询当前签到记录
        $sql = "select * from " . DB_PREFIX . "user_signin where uid = '{$user_id}'";
        $row = $GLOBALS['db']->getRow($sql);
        $is_continue = 1;
        $now_day = 1;   // 获得当前是第几天签到
        // 签到记录修改或新增
        try {
            $transId = $GLOBALS['db']->StartTrans();
            if (empty($row)) { // 没签到记录,新增数据
                $start_time = $today_time;
                $sql = "insert into " . DB_PREFIX . "user_signin";
                $ins_arr = [
                    'uid'         => $user_id,
                    'start_time'  => $start_time,
                    'last_time'   => $time,
                    'count'       => 1,
                    'is_continue' => 1,
                ];
                $sql .= insertstr($ins_arr);
                $bool = $GLOBALS['db']->query($sql);
                if (!$bool) throw new \Exception(api_lang("Record_check_in_failed"));
            } else {    // 有记录, 修改记录
                $start_time = $row['start_time'];
                $s_today = $today_time;        // 今日开始时间
                $e_today = strtotime($today . '23:59:59');        // 今日结束时间
                if ($row['last_time'] >= $s_today && $row['last_time'] <= $e_today) throw new \Exception(api_lang("Signed_in_today"));

                $s_last = strtotime(date('Y-m-d', $row['last_time']));
//            $e_yesterday = strtotime(date('Y-m-d'.'23:59:59', $row['last_time']));
                $sql = "update " . DB_PREFIX . "user_signin set count=`count`+1, last_time=" . $time;
                if ($s_today - $start_time <= 86400) {
                    $is_continue = 1;
                    $sql .= ", is_continue=1";
                    $now_day = $row['count'] + 1;
                } else {
                    $is_continue = 0;
                    $sql .= ", is_continue=0";
                    //$now_day = ceil(($s_today - $s_last)/86400);
                    $now_day = ceil(($s_today - $start_time) / 86400) + 1; //算上当天时间
                }
                $sql .= " where uid={$user_id}";
                $bool = $GLOBALS['db']->query($sql);
                if (!$bool) throw new \Exception(api_lang("Record_check_in_failed"));
            }

            // 判断是否要额外送礼
            $signin_day = $GLOBALS['db']->getRow("select value from bogo_conf where name ='signin_day'")['value'];
            $sevent_day = $this->seventDay($start_time, $signin_day);
            $sevent_day_count = count($sevent_day) - 1;
            if ($today_time >= $sevent_day[$sevent_day_count]) { // 如果今日是签到最后一天或者已经过了最后一天!empty($signin_day) && $signin_day == $now_day
                if ($today_time > $sevent_day[$sevent_day_count]) {
                    $now_day = 1;
                    // 重置签到进度 => count为0 天数为1, start_time=当前,
                    $sql = "update " . DB_PREFIX . "user_signin set count = 1, start_time = '{$today_time}' where uid={$user_id}";
                    $bool = $GLOBALS['db']->query($sql);
                    if (!$bool) throw new \Exception(api_lang("Check_in_progress_reset_failed"));
                } else {
                    $now_day = count($sevent_day);
                }

                // 判断是否能获得七日奖励
                $sevent_str = implode(',', $sevent_day);
                if ($sevent_str) {
                    $sql = "select count(id) as num from " . DB_PREFIX . "user_signin_log where addday in({$sevent_str}) and uid = '{$user_id}'";
                    $sevent = $GLOBALS['db']->getRow($sql)['num'] == $signin_day ? 1 : 0;
                }
                if ($sevent) {
                    // 七日奖励
                    $sql = "select value from bogo_conf where name = 'signin_reward'";
                    $sevent_reward = $GLOBALS['db']->getRow($sql)['value'];
                    $sql = "update " . DB_PREFIX . "user set diamonds = `diamonds`+{$sevent_reward} where id = {$user_id}";
                    $bool = $GLOBALS['db']->query($sql);
                    if (!$bool) throw new \Exception(api_lang("Diamond_gift_failed"));
                    $ins_arr = [
                        'log_info'     => $signin_day . api_lang("Day_sign_in_reward") . $sevent_reward . api_lang("Diamonds"),
                        'log_time'     => $time,
                        'log_admin_id' => 0,
                        'money'        => 0,
                        'user_id'      => $user_id,
                        'type'         => 20,
                        'diamonds'     => $sevent_reward
                    ];
                    $bool = user_log($ins_arr);
                    if (!$bool) throw new \Exception($signin_day . 'api_lang("Day_sign_in_reward_gift_failed")');
                }
            }

            // 今日签到记录
            $sql = "select num from " . DB_PREFIX . "user_signin_reward where day = '{$now_day}'";
            $reward = $GLOBALS['db']->getRow($sql)['num'];
            $log_data = [
                'uid'         => $user_id,
                'reward'      => $reward,
                'addday'      => strtotime(date('Y-m-d', $time)),
                'addtime'     => $time,
                'num'         => $now_day,
                'is_continue' => $is_continue,
            ];
            $sql = "insert into " . DB_PREFIX . "user_signin_log";
            $sql .= insertstr($log_data);
            $bool = $GLOBALS['db']->query($sql);
            if (!$bool) throw new \Exception(api_lang("Check_in_record_failed"));
            // 消费和收益记录表
            add_user_consumption_log(0, $user_id, 0, api_lang('Daily_sign_in_gift'), 0, $reward, 13);
            // 今日签到奖励(钻石)
            $sql = "update " . DB_PREFIX . "user set diamonds = `diamonds`+{$reward} where id = {$user_id}";
            $bool = $GLOBALS['db']->query($sql);
            if (!$bool) throw new \Exception(api_lang("Diamond_gift_failed"));

            // 用户日志记录
            $ins_arr = [
                'log_info'     => api_lang("Daily_sign_in_gift") . $reward . api_lang("Diamonds"),
                'log_time'     => $time,
                'log_admin_id' => 0,
                'money'        => 0,
                'user_id'      => $user_id,
                'type'         => 20,
                'diamonds'     => $reward
            ];
            $bool = user_log($ins_arr);
            if (!$bool) throw new \Exception(api_lang("Check_in_record_failed"));
            $GLOBALS['db']->Commit($transId);
        } catch (\Exception $e) {
            $GLOBALS['db']->Rollback($transId);
            return n_ajax($e->getMessage());
        }
        $root = [];
        $root['error'] = api_lang("Check_in_successfully_today");
        $root['status'] = 1;
        $root['reward'] = $reward;
        ajax_return($root);
    }


    /*系统消息列表*/
    public function msg_list()
    {
        $root = [];
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
            ajax_return($root);
        }
        $page = intval(get_input('p', 'n', 1, 'intval,abs')) > 0 ? intval(get_input('p', 'n', 1, 'intval,abs')) : 1;//取第几页数据
        $uid = $GLOBALS['user_info']['id'];
        $page_size = 20;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        $sql = "select * from " . DB_PREFIX . "pub_msgs where ( find_in_set('{$uid}', `users`) or users = 'all' ) and addtime >= " . $GLOBALS['user_info']['create_time'] . "  order by addtime desc limit " . $limit;
        $list = $GLOBALS['db']->getAll($sql);
        $arr = [];
        foreach ($list as &$v) {
            $sql = "select id from " . DB_PREFIX . "pub_msgs_read where m_id = '{$v['id']}' and uid = '{$uid}'";
            if (empty($GLOBALS['db']->getRow($sql))) {
                array_push($arr, [
                    ['key' => 'm_id', 'val' => $v['id']],
                    ['key' => 'uid', 'val' => $uid],
                    ['key' => 'is_read', 'val' => 1]
                ]);
            }
            $v['url'] = get_spec_image($v['url']);
            $v['addtime'] = date('Y-m-d H:i:s', $v['addtime']);
        }
        if ($arr) {
            $sql = "insert into " . DB_PREFIX . "pub_msgs_read ";
            $sql .= insertStrAll($arr);
            $GLOBALS['db']->query($sql);
        }

        $sql = "update " . DB_PREFIX . "user set last_remove_system_message = " . NOW_TIME . " where id=" . $uid;
        $GLOBALS['db']->query($sql); //修改阅读信息时间

        $root['status'] = 1;
        $root['list'] = $list;
        ajax_return($root);
    }

    /*************** 新搜索 **********************/

    //搜索
    public function search_all()
    {
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//id
        $root = array('status' => 1, 'error' => '');
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $keyword = strim($_REQUEST['keyword']);//搜索关键字
            $type = intval($_REQUEST['type']); //0所有，1用户，2短视频，3动态
            $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1; //分页
            //每次20条
            $page_size = 20;
            $limit = (($page - 1) * $page_size) . "," . $page_size;
            if (empty($keyword)) {
                $root['has_next'] = 0;
                $root['page'] = 0;
                ajax_return($root);
            } else {
                if ($type == 0) {
                    $u = ' limit 0,3';
                    $l = ' limit 0,3';
                } else {
                    $u = ' limit ' . $limit;
                    $l = ' limit ' . $limit;
                }

                $sql = 'select id as user_id,nick_name,signature,sex,head_image,user_level,v_icon,nobleid,noble_time from ' . DB_PREFIX . "user where is_effect = 1 and is_robot = 0 and (nick_name like '%" . $keyword . "%' or luck_num like '%" . $keyword . "%' or id like '%" . $keyword . "%')" . $u;

                $user = $GLOBALS['db']->getAll($sql, true, true);
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
                $user_redis = new UserFollwRedisService($user_id);
                $keys = $user_redis->following();

                if (count($user) > 0 && ($type == 1 || $type == 0)) {
                    foreach ($user as $k => $v) {
                        if (in_array($v['user_id'], $keys)) {
                            $user[$k]['follow_id'] = $v['user_id'];
                        } else {
                            $user[$k]['follow_id'] = 0;
                        }
                        $user[$k]['noble_icon'] = '';
                        if ($v['noble_time'] > time()) {
                            $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
                            if ($jurisdiction) {
                                $user[$k]['noble_icon'] = $jurisdiction['icon'];
                            }
                        }
                        $user[$k]['head_image'] = get_spec_image($v['head_image']);
                        $user[$k]['signature'] = htmlspecialchars_decode($user[$k]['signature']);
                        $user[$k]['nick_name'] = htmlspecialchars_decode($user[$k]['nick_name']);
                        $user[$k]['signature'] = emoji_decode($user[$k]['signature']);
                        $user[$k]['nick_name'] = emoji_decode($user[$k]['nick_name']);
                    }
                    if ($page == 0) {
                        $root['has_next'] = 0;
                    } else {
                        if (count($user) == $page_size)
                            $root['has_next'] = 1;
                        else
                            $root['has_next'] = 0;
                    }

                    $root['page'] = $page;

                    $root['user'] = $user;
                }

                //2短视频
                $sql = 'select w.* ,w.id as weibo_id,u.nick_name,u.head_image,u.is_authentication from ' . DB_PREFIX . "weibo as w left join " . DB_PREFIX . "user as u on w.user_id = u.id and u.is_effect = 1 where status = 1 and w.is_audit=1 and (w.content like '%" . $keyword . "%' or u.nick_name like '%" . $keyword . "%' or u.luck_num like '%" . $keyword . "%' or u.id like '%" . $keyword . "%')";
                //是否拉黑
                $black_list = $GLOBALS['db']->getAll("select black_user_id from " . DB_PREFIX . "black where  user_id = " . $user_id);
                if (!empty($black_list)) {
                    $black_list_array = array_column($black_list, 'black_user_id');
                    $sql .= " and w.user_id not in ( " . implode(',', $black_list_array) . ")";
                }
                $sql .= " and w.is_recommend=1  order by w.create_time desc,w.is_top desc,w.video_count desc " . $l;
                $weibo = $GLOBALS['db']->getAll($sql, true, true);
                if (count($weibo) > 0 && ($type == 2 || $type == 0)) {
                    foreach ($weibo as $k => $v) {

                        if ($v['head_image']) {
                            $weibo[$k]['head_image'] = get_spec_image($v['head_image']);
                        }
                        if ($v['photo_image']) {
                            $weibo[$k]['photo_image'] = get_spec_image($v['photo_image']);
                        }

                        //是否关注
                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
                        $user_follw_redis = new UserFollwRedisService($user_id);
                        $weibo[$k]['has_focus'] = $user_follw_redis->is_following($v['user_id']) ? 1 : 0; //0:未关注;1:已关注

                        if ($v['type'] == 'video') {
                            $weibo[$k]['images'] = array();
                            $url = $v['data'];
                            $weibo[$k]['video_url'] = get_spec_image($url);
                        }
                    }

                    if ($page == 0) {
                        $root['has_next'] = 0;
                    } else {
                        if (count($weibo) == $page_size)
                            $root['has_next'] = 1;
                        else
                            $root['has_next'] = 0;
                    }

                    $root['page'] = $page;//

                    $root['weibo'] = $weibo;
                }

                //动态
                $sql = " select d.* ,u.nick_name,u.head_image,u.is_authentication,u.user_level from " . DB_PREFIX . 'user_dynamic d left join ' . DB_PREFIX . "user u on d.uid = u.id and u.is_effect = 1 where d.status = 1 and (d.content like '%" . $keyword . "%' or u.nick_name like '%" . $keyword . "%' or u.luck_num like '%" . $keyword . "%' or u.id like '%" . $keyword . "%') order by d.is_top DESC" . $l;
                $dynamic = $GLOBALS['db']->getAll($sql, true, true);
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
                $userfollw_redis = new UserFollwRedisService($user_id);
                if (count($dynamic) > 0 && ($type == 3 || $type == 0)) {
                    $new_list = [];
                    foreach ($dynamic as $k => &$v) {
                        if (!empty($v['select_user_id']) && $v['uid'] != $this->loginUserId) {
                            if (strripos($v['select_user_id'], $this->loginUserId) === false) {
                                continue;
                            }
                        }
                        $sql = "select id from " . DB_PREFIX . "user_dynamic_praise  where uid = " . $user_id . "  and dynamic_id=" . $v['id'];
                        $count = $GLOBALS['db']->getRow($sql);

                        if (!empty($count)) {
                            $v['is_like'] = 1;
                        } else {
                            $v['is_like'] = 0;
                        }
                        $rs_count = $GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "user_dynamic_comments where  dynamic_id=" . $v['id'], true, true);
                        $v['comments'] = $rs_count ? $rs_count : 0;
                        if (!empty($v['head_image'])) {
                            $v['head_image'] = get_spec_image($v['head_image']);
                        }
                        if (!empty($v['audio'])) {
                            $v['audio'] = get_spec_image($v['audio']);
                        }
                        if (!empty($v['video'])) {
                            $v['video'] = get_spec_image($v['video']);
                        }
                        if (!empty($v['cover_url'])) {
                            $v['cover_url'] = get_spec_image($v['cover_url']);
                        }
                        $sql = "select img from " . DB_PREFIX . "user_dynamic_img  where    dynamic_id=" . $v['id'] . " order by sort asc";

                        $imgs = $GLOBALS['db']->getAll($sql);
                        foreach ($imgs as $v1) {
                            $v['picUrls'][] = get_spec_image($v1['img']);
                        }
                        if ($v['type'] == 3 && !empty($imgs)) { // 视频地址
                            $v['video'] = get_spec_image($imgs[0]['img']);
                        }
                        $v['timing'] = get_timing($v['addtime']);

                        //是否关注
                        if ($userfollw_redis->is_following($v['uid'])) {
                            $v['is_focus'] = 1;//0:未关注;1:已关注
                        } else {
                            $v['is_focus'] = 0;//0:未关注;1:已关注
                        }
                        if (empty($Lng) || empty($Lat)) {
                            $v['juli'] = '';
                        } else {
                            $v['juli'] = (string)round($v['juli'], 2);
                        }

                        $v['nick_name'] = emoji_decode($v['nick_name']);
                        $v['content'] = emoji_decode($v['content']);

                        $new_list[] = $v;

                    }

                    if ($page == 0) {
                        $root['has_next'] = 0;
                    } else {
                        if (count($new_list) == $page_size)
                            $root['has_next'] = 1;
                        else
                            $root['has_next'] = 0;
                    }

                    $root['page'] = $page;//

                    $root['dynamic'] = $new_list;
                }

                //是否有此记录
                $log = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user_search where uid = ' . $user_id . " and title = '" . $keyword . "'");
                if (empty($log)) {
                    $sql = "insert into " . DB_PREFIX . "user_search (uid,title,addtime) value ('" . $user_id . "','" . $keyword . "','" . NOW_TIME . "')";
                    $GLOBALS['db']->query($sql);
                } else {
                    $sql = "update " . DB_PREFIX . "user_search set addtime = " . NOW_TIME . " where id='{$log['id']}'";
                    $GLOBALS['db']->query($sql);
                }

            }
        }
        ajax_return($root);
    }

    //搜索记录
    public function search_log()
    {
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//id
        $root = array('status' => 1, 'error' => '');
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        } else {
            $log = $GLOBALS['db']->getAll('select * from ' . DB_PREFIX . 'user_search where uid = ' . $user_id . ' order by addtime desc limit 0,20');
            if (count($log) > 0) {
                $root['list'] = $log;
            }
            ajax_return($root);
        }
    }

    //删除搜索记录
    public function del_search()
    {
        $user_id = intval($GLOBALS['user_info']['id']) ?: intval($_REQUEST['uid']);//id
        $root = array('status' => 0, 'error' => '');
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        } else {
            $log = $GLOBALS['db']->query("delete from " . DB_PREFIX . "user_search where  uid=" . $user_id);
            if ($log) {
                $root['status'] = 1;
                $root['error'] = api_lang('operation_was_successful');
            }
            ajax_return($root);
        }
    }
}