<?php

use think\Db;

class invite_vueModule extends baseModule
{

    //新邀请首页
    public function invite_index_new()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //初始化手机端配置
            $m_config = load_auto_cache("m_config");
            $data['one'] = $m_config['invite_rewards_recharge']; //一级充值奖励
            $data['two'] = $m_config['invite_rewards_recharge_shang']; //二级充值奖励

            $user_info = $GLOBALS['db']->getRow('select id,invitation_coin,alipay_name,alipay_account from ' . DB_PREFIX . 'user where id = ' . $user_id);
            $one_invite = $GLOBALS['db']->getOne('select count(id) from ' . DB_PREFIX . 'invite_rewards where inviteid = ' . $user_id); //一级邀请人数
            $two_invite = $GLOBALS['db']->getOne('select count(id) from ' . DB_PREFIX . 'invite_rewards where superior = ' . $user_id);//二级邀请人数
            $reward = [
                "total_money" => $user_info['invitation_coin'],
                "count"       => $one_invite,
                "two_count"   => $two_invite
            ];

            $lists = $GLOBALS['db']->getAll('select re.uid,u.head_image,u.nick_name,re.coin,re.addtime from ' . DB_PREFIX . 'invite_rewards_earnings_log re left join ' . DB_PREFIX . 'user u on re.uid = u.id where re.type = 2 /*and re.order_coin > 0 and re.notice_sn > 0*/ and re.invite_id = ' . $user_id . ' order by addtime desc limit 0,3'); //邀请奖励记录

            if (count($lists) > 0) {
                foreach ($lists as &$v) {
                    $v['head_image'] = get_abs_img_root($v['head_image']);
                }
            }

            //邀请规则
            $article = $GLOBALS['db']->getOne("select a.content from " . DB_PREFIX . "article as a left join " . DB_PREFIX . "article_cate as v on v.id = a.cate_id  where a.is_effect = 1 and a.is_delete = 0 and v.title='" . api_lang("Invite_Awards") . "' order by a.sort desc", true, true);

            $root['data'] = $reward; //邀请的收益+ 邀请人数
            $root['reward'] = $data; //邀请奖励
            $root['lists'] = $lists; //邀请充值奖励记录
            $root['protal'] = $article; //邀请规则
        }
        api_ajax_return($root);
    }

    //我的邀请详情
    public function invite_info_new()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        $type = intval($_REQUEST['type']) ? intval($_REQUEST['type']) : 1;//类型【1一级分类；2二级分类】
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //用户信息
            $user_info = $GLOBALS['db']->getRow('select id,invitation_coin,alipay_name,alipay_account from ' . DB_PREFIX . 'user where id = ' . $user_id);

            $page_size = 20;
            $p = $page == 1 ? 0 : $page_size * ($page - 1);
            $limit = $p . "," . $page_size;

            if ($type == 1) {
                $one_lists = $GLOBALS['db']->getAll('select re.uid,u.head_image,u.nick_name,re.coin,re.addtime from ' . DB_PREFIX . 'invite_rewards_earnings_log re left join ' . DB_PREFIX . 'user u on re.uid = u.id where re.status = 1 and re.type = 2 /*and re.order_coin > 0 and re.notice_sn > 0*/ and re.invite_id = ' . $user_id . ' order by addtime desc limit ' . $limit); //一级邀请奖励记录
                if (count($one_lists) > 0) {
                    foreach ($one_lists as &$v) {
                        $v['head_image'] = get_abs_img_root($v['head_image']);
                    }
                }

                $lists = $one_lists;
            } else {
                $two_lists = $GLOBALS['db']->getAll('select re.uid,u.head_image,u.nick_name,re.coin,re.addtime from ' . DB_PREFIX . 'invite_rewards_earnings_log re left join ' . DB_PREFIX . 'user u on re.uid = u.id where re.status = 2 and re.type = 2 /*and re.order_coin > 0 and re.notice_sn > 0*/ and re.invite_id = ' . $user_id . ' order by addtime desc limit ' . $limit); //二级邀请奖励记录
                if (count($two_lists) > 0) {
                    foreach ($two_lists as &$t) {
                        $t['head_image'] = get_abs_img_root($t['head_image']);
                    }
                }
                $lists = $two_lists;
            }

            $root['data'] = $user_info['invitation_coin']; //我的邀请收益
            $root['lists'] = $lists; //邀请奖励记录
        }
        api_ajax_return($root);
    }

    //提现页面
    public function reward_new()
    {
        $root = array('error' => '', 'status' => 1, 'data' => array());
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //用户信息
            $user_info = $GLOBALS['db']->getRow('select id,invitation_coin,alipay_name,alipay_account,is_authentication from ' . DB_PREFIX . 'user where id = ' . $user_id);
            $data = [
                'invite_coin'    => $user_info['invitation_coin'],//我的邀请收益
                'is_auth'        => $user_info['is_authentication'],//是否认证
                'alipay_name'    => $user_info['alipay_name'],//支付宝账号名称
                'alipay_account' => $user_info['alipay_account'],//支付宝账号
            ];

            $recode = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'invite_rewards_log where money = 1 and type = 2  and uid = ' . $user_id);

            //提现规则
            $lists = $GLOBALS['db']->getAll('select * from ' . DB_PREFIX . 'invitation_withdrawal_rule order by sort asc');
            if (count($lists) > 0) {
                foreach ($lists as &$v) {
                    if (!empty($recode) && ($recode['status'] == 0 || $recode['status'] == 1) && $v['money'] == 1) {
                        $v['ones'] = 1;//是否显示【0显示；1不显示】
                    } else {
                        $v['ones'] = 0; //是否显示【0显示；1不显示】
                    }

                    if ((empty($recode) || $recode['status'] == 2) && $v['money'] == 1) {
                        $v['is_only'] = 1; //显示仅一次【1显示；0不显示】
                    } else {
                        $v['is_only'] = 0;
                    }
                }
            }
            $root['data'] = $data;
            $root['list'] = $lists;
        }
        api_ajax_return($root);
    }

    //绑定支付宝账号
    public function pinless_add_new()
    {
        $root = array('status' => 0, 'error' => api_lang("Binding_failed"));
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        $pay = strim($_REQUEST['pay']);
        $pay_name = strim($_REQUEST['pay_name']);
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_info = $GLOBALS['db']->getRow("select id,alipay_name,alipay_account from " . DB_PREFIX . "user where id = " . $user_id);
            $alipay = array();
            $alipay['alipay_name'] = $pay_name;
            $alipay['alipay_account'] = $pay;
            $alipay['binding_alipay'] = 1;
            $where = "id=" . $user_info['id'];
            $result = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $alipay, "UPDATE", $where);
            if ($result) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();
                $user_redis->update_db($user_info['id'], $alipay);
                $root['status'] = 1;
                $root['error'] = api_lang("Binding_succeeded");
            }
        }
        api_ajax_return($root);
    }

    //提现记录
    public function recode_new()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $page_size = 20;
            $p = $page == 1 ? 0 : $page_size * ($page - 1);
            $limit = $p . "," . $page_size;

            $lists = $GLOBALS['db']->getAll('select id,money,addtime as `create_time`,status,alipay_name,alipay_account from ' . DB_PREFIX . 'invite_rewards_log where type = 2 and uid = ' . $user_id . ' order by create_time desc limit ' . $limit);

            if (count($lists) > 0) {
                foreach ($lists as &$v) {
                    $v['content'] = "支付宝提现";
                }
            }
            $root['data'] = $lists;
        }
        ajax_return($root);
    }

    //提现
    public function add_reward()
    {
        $root = array('error' => api_lang("operation_failed"), 'status' => 0);
        $id = intval($_REQUEST['id']);
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $type = 2; // 支付宝提现

            // 邀请规则
            $invitation_withdrawal_rule = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "invitation_withdrawal_rule where id=" . $id);

            if (!$invitation_withdrawal_rule) {
                $root['error'] = api_lang("Parameter_error");
                $root['status'] = 0;
                api_ajax_return($root);
            }
            $coin = $invitation_withdrawal_rule['invitation_coin'];
            $money = $invitation_withdrawal_rule['money'];

            //用户信息
            $user_info = $GLOBALS['db']->getRow("select id,invitation_coin,alipay_name,alipay_account from " . DB_PREFIX . "user where  id = " . $user_id);

            $sql = "select * from " . DB_PREFIX . "invite_rewards_log  where uid=" . $user_id . " and status=0";
            $invite_rewards = $GLOBALS['db']->getRow($sql);
            if ($invite_rewards) {
                $root['error'] = api_lang("There_are_not_approved_withdrawal_orders");
                api_ajax_return($root);
            }
            if (empty($user_info['alipay_account'])) {
                $root['error'] = api_lang("Please_bind_Alipay");
                api_ajax_return($root);
            }

            if ($user_info['invitation_coin'] < $coin || $coin <= 0) {
                $root['error'] = api_lang("Insufficient_withdrawal_amount");
                api_ajax_return($root);
            }

            $sql = "update " . DB_PREFIX . "user set invitation_coin =invitation_coin - '" . $coin . "' where id = " . $user_id;
            $GLOBALS['db']->query($sql);
            if ($GLOBALS['db']->affected_rows()) {
                $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards_log(uid,money,diamonds,type,status,addtime,alipay_name,alipay_account) VALUES ('" . $user_id . "','" . $money . "', '" . $coin . "','" . $type . "','0','" . time() . "','" . $user_info['alipay_name'] . "','" . $user_info['alipay_account'] . "')";
                $result = $GLOBALS['db']->query($sql);
                if ($result) {
                    $root['error'] = api_lang("successful_waiting_for_audit");
                    $root['status'] = 1;
                }
            } else {
                $root['error'] = api_lang("Insufficient_withdrawal_amount");
            }
        }
        api_ajax_return($root);
    }

    //分享背景图
    public function share_bg()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//用户ID
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $page_size = 20;
            $p = $page == 1 ? 0 : $page_size * ($page - 1);
            $limit = $p . "," . $page_size;

            //$lists = $GLOBALS['db'] -> getAll('select * from '.DB_PREFIX.'invite_bg where status = 1 order by sort desc limit '.$limit);
            $lists = $GLOBALS['db']->getAll('select * from ' . DB_PREFIX . 'invite_bg where status = 1 order by sort desc ');

            $root['data'] = $lists;
        }
        ajax_return($root);
    }


    /****************************【旧邀请】*************************************/

    // 申请邀请提现
    public function add_withdrawal()
    {
        $root = array('error' => api_lang("operation_failed"), 'status' => 0);

        $number = floatval($_REQUEST['number']);

        // 邀请规则
        if (!$number) {
            $root['error'] = api_lang("parameter_error");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $ratio = $m_config['invite_rewards_withdrawal'];
        if (!$ratio) {
            $root['error'] = api_lang('提现比例设置错误，请联系管理员！');
            api_ajax_return($root);
        }

        $money = floor(strval($ratio * $number * 100)) / 100;
        if (!$money) {
            $root['error'] = api_lang("parameter_error");
            api_ajax_return($root);
        }

        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,invitation_coin from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }

        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $user_id = $user_info['id'];

//        $sql = "select * from " . DB_PREFIX . "invite_rewards_log  where uid=" . $user_id . " and status=0";
//        $invite_rewards = $GLOBALS['db']->getRow($sql);
//        if ($invite_rewards) {
//            $root['error'] = api_lang("There_are_not_approved_withdrawal_orders");
//            api_ajax_return($root);
//        }
        $result_one = Db::name("user_cash_account")->where("uid=" . $user_info['id'] . " and choose=1")->order("choose desc")->find();
        if (!$result_one) {
            $root['error'] = api_lang("Please_bind_Alipay");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $user_info['alipay_account'] = $result_one['account_number'];
        $user_info['alipay_name'] = $result_one['name'];

        //   $type=$result_one['bank_id']; // 提现类型
        $type = 2; // 提现类型
        if ($user_info['invitation_coin'] < $number || $number <= 0) {
            $root['error'] = api_lang("Insufficient_withdrawal_amount");
            api_ajax_return($root);
        }

        //修改二级用户邀请数据
        $sql = "update " . DB_PREFIX . "user set invitation_coin =invitation_coin - '" . $number . "' where id = " . $user_id;
        $GLOBALS['db']->query($sql);
        if ($GLOBALS['db']->affected_rows()) {
            $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards_log(uid,money,diamonds,type,status,addtime,alipay_name,alipay_account,bank_name) VALUES ('" . $user_id . "','" . $money . "', '" . $number . "','" . $type . "','0','" . time() . "','" . $user_info['alipay_name'] . "','" . $user_info['alipay_account'] . "','" . $result_one['account'] . "')";
            $result = $GLOBALS['db']->query($sql);
            if ($result) {
                $root['error'] = api_lang("successful_waiting_for_audit");
                $root['status'] = 1;
            }
        } else {
            $root['error'] = api_lang("Insufficient_withdrawal_amount");
        }
        api_ajax_return($root);
    }

    // 最新邀请提现规则
    public function get_withdrawal_rules()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $list = $GLOBALS['db']->getAll("select * from " . DB_PREFIX . "invitation_withdrawal_rule order by sort desc");

        $article = $GLOBALS['db']->getRow("select a.* from " . DB_PREFIX . "article as a left join " . DB_PREFIX . "article_cate as v on v.id = a.cate_id  where a.is_effect = 1 and a.is_delete = 0 and v.id=29 order by a.sort desc", true, true);
        $data['content'] = $article ? $article['content'] : '';
        $data['list'] = $list;
        $root['data'] = $data;
        api_ajax_return($root);
    }

    //最新邀请页面
    public function index()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        //用户ID
        $user_info = array();
        $data = array(
            'url'      => '',
            'number'   => 0,
            'coin'     => 0,
            'superior' => '',
            'user_id'  => 0
        );

        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,vip_expire_time,head_image,invitation_coin_total from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //本用户余额详情
            $user_id = $user_info['id'];
            $coin = intval($user_info['invitation_coin']);
            $sql = "select count(id) from " . DB_PREFIX . "invite_rewards  where inviteid=" . $user_id;
            $invite_rewards = $GLOBALS['db']->getOne($sql);

            $sql = "select id from " . DB_PREFIX . "invite_rewards  where uid=" . $user_id;
            $superior = $GLOBALS['db']->getOne($sql);

            $url = SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=invite_rewards&act=download&invite_code=" . $user_id;
            $data['url'] = $url;
            $data['number'] = $invite_rewards ? $invite_rewards : 0;
            $data['coin'] = $coin;
            $data['superior'] = $superior ? $superior : '';
            $data['user_id'] = $user_id;
        }
        //初始化手机端配置
        $m_config = load_auto_cache("m_config");
        $data['is_invitation_two'] = $m_config['is_invitation_two'];
        $data['is_invitation_three'] = $m_config['is_invitation_three'];

        $root['data'] = $data;

        api_ajax_return($root);
    }

    //邀请奖励规则
    public function reward_rules()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $article = $GLOBALS['db']->getRow("select a.* from " . DB_PREFIX . "article as a left join " . DB_PREFIX . "article_cate as v on v.id = a.cate_id  where a.is_effect = 1 and a.is_delete = 0 and v.identification='Invitation_reward' order by a.sort desc", true, true);
        $root['data'] = $article;

        api_ajax_return($root);
    }

    //我的二级和三级团队
    public function subordinate()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,vip_expire_time,head_image from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $type = intval($_REQUEST['type']);  // 团队级别
        if ($type == 1) {
            $name = api_lang("My_first_level_team");
        } elseif ($type == 2) {
            $name = api_lang("My_secondary_team");
        } else {
            $name = api_lang("My_level_3_team");
        }

        $article = [];
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;

        $page_size = 12;
        $p = $page == 1 ? 0 : $page_size * ($page - 1);
        $limit = $p . "," . $page_size;
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = $user_info['id'];  //   用户ID
            if ($type == 1) {
                $where = "a.inviteid=" . $user_id;
            } elseif ($type == 2) {
                $where = "a.superior=" . $user_id;
            } else {
                $where = "a.on_superior=" . $user_id;
            }
            $article = $GLOBALS['db']->getALL("select v.id,v.nick_name,v.head_image from " . DB_PREFIX . "invite_rewards as a INNER join " . DB_PREFIX . "user as v on v.id = a.uid  where " . $where . " group by v.id limit " . $limit, true, true);

            if (count($article)) {
                foreach ($article as &$v) {

                    $v['nick_name'] = emoji_decode($v['nick_name']);
                    if ($v['head_image']) {
                        $v['head_image'] = get_abs_img_root($v['head_image']);
                    } else {
                        $v['head_image'] = get_abs_img_root($root['m_config']['app_logo']);
                    }
                    $article_sum = $GLOBALS['db']->getOne("select sum(coin) as coin from " . DB_PREFIX . "invite_rewards_earnings_log where uid =" . $v['id']);

                    $v['coin'] = $article_sum ? $article_sum : 0;
                }
            }
        }
        $data['list'] = $article;
        $data['name'] = $name;
        $data['type'] = $type;
        $data['page_size'] = $page_size;
        $root['data'] = $data;
        api_ajax_return($root);
    }

    //收益详情
    public function earnings()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $type = intval($_REQUEST['type']);  // 团队级别
        $consumers = intval($_REQUEST['consumers']);  // 团队级别

        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $article = array();
        $page = intval($_REQUEST['page']);//取第几页数据

        $page = $page == 0 || $page == '' ? 1 : $page;
        $page_size = 50;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = $user_info['id'];  //   用户ID
            $where = "a.status=" . $type . " and consumers=" . $consumers . " and invite_id=" . $user_id;
            $article = $GLOBALS['db']->getALL("select v.nick_name,a.coin,a.addtime,a.type from " . DB_PREFIX . "invite_rewards_earnings_log as a left join " . DB_PREFIX . "user as v on v.id = a.uid  where " . $where . " order by a.addtime desc limit " . $limit, true, true);
            foreach ($article as &$v) {
                $v['addtime'] = date("Y-m-d H:i", $v['addtime']);
                $v['name'] = $v['type'] == 1 ? $v['nick_name'] . ": " . api_lang("Registration_Award_3_team") : $v['nick_name'] . ": " . api_lang("Recharge_reward_3_team");
            }
        }
        $data['list'] = $article;
        $data['page_size'] = $page_size;
        $root['data'] = $data;
        api_ajax_return($root);
    }

    //邀请提现记录表
    public function record()
    {
        $root = array('status' => 1, 'error' => '', 'data' => []);

        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $invite_rewards = array();
        $page = intval($_REQUEST['page']);//取第几页数据

        $page = $page == 0 || $page == '' ? 1 : $page;
        $page_size = 50;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = $user_info['id'];
            $sql = "select * from " . DB_PREFIX . "invite_rewards_log  where uid=" . $user_id . " limit " . $limit;
            $invite_rewards = $GLOBALS['db']->getALL($sql);

            foreach ($invite_rewards as &$v) {
                $v['addtime'] = date("Y-m-d H:i", $v['addtime']);
            }
        }
        $data['list'] = $invite_rewards;
        $data['page_size'] = $page_size;
        $root['data'] = $data;
        api_ajax_return($root);
    }

    //邀请的用户提现
    public function withdrawal()
    {
        //   用户ID
        $root = array('status' => 1, 'error' => '', 'data' => []);
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,invitation_coin from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        }
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $user_info['ratio'] = $m_config['invite_distribution_ratio'];
        $user_info['ticket_name'] = $m_config['ticket_name'];
        $result_one = Db::name("user_cash_account")->where("uid=" . $user_info['id'] . " and choose=1")->order("choose desc")->find();
        $user_info['alipay_account'] = $result_one ? $result_one['account_number'] : '';
        $user_info['alipay_name'] = $result_one ? $result_one['name'] : '';
        $user_info['account'] = $result_one ? $result_one['account'] : '';

        $root['data'] = $user_info;
        api_ajax_return($root);
    }

    //提现金额
    public function withdrawal_add()
    {
        $root = array('error' => api_lang("operation_failed"), 'status' => 0);
        $type = intval($_REQUEST['type']) ? intval($_REQUEST['type']) : 0;
        $coin = floatval($_REQUEST['coin']);
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,invitation_coin,alipay_name,alipay_account from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];

        $sql = "select * from " . DB_PREFIX . "invite_rewards_log  where uid=" . $user_id . " and status=0";
        $invite_rewards = $GLOBALS['db']->getRow($sql);
        if ($invite_rewards) {
            $root['error'] = api_lang("There_are_not_approved_withdrawal_orders");
            api_ajax_return($root);
        }
        if (empty($user_info['alipay_account'])) {
            $root['error'] = api_lang("Please_bind_Alipay");
            api_ajax_return($root);
        }
        if ($user_info['invitation_coin'] < $coin || $coin <= 0) {
            $root['error'] = api_lang("Incorrect_amount_entered");
            api_ajax_return($root);
        }
        $m_config = load_auto_cache("m_config");
        if ($m_config['ticket_catty_min'] > $coin) {
            $root['error'] = api_lang("Amount_must_be_greater_than") . $m_config['ticket_catty_min'] . api_lang("Yuan") . api_lang("To_withdraw_cash");
            api_ajax_return($root);
        }
        if ($m_config['day_cash_max'] < $coin) {
            $root['error'] = api_lang("Maximum_withdrawal_amount") . $m_config['day_cash_max'] . api_lang("Yuan");
            api_ajax_return($root);
        }
        //修改二级用户邀请数据
        $sql = "update " . DB_PREFIX . "user set invitation_coin =invitation_coin - '" . $coin . "' where id = " . $user_id;
        $GLOBALS['db']->query($sql);
        if ($GLOBALS['db']->affected_rows()) {
            $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards_log(uid,money,diamonds,type,status,addtime,alipay_name,alipay_account) VALUES ('" . $user_id . "', '" . $coin . "','0','" . $type . "','0','" . time() . "','" . $user_info['alipay_name'] . "','" . $user_info['alipay_account'] . "')";
            $result = $GLOBALS['db']->query($sql);
            if ($result) {
                $root['error'] = api_lang("successful_waiting_for_audit");
                $root['status'] = 1;
            }
        } else {
            $root['error'] = api_lang("Insufficient_withdrawal_amount");
        }
        api_ajax_return($root);
    }

    //绑定支付宝账号
    public function pinless()
    {
        $root = array('error' => '', 'status' => 1, 'data' => array());
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,alipay_name,alipay_account from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
        }
        $root['data'] = $user_info;
        api_ajax_return($root);
    }

    //绑定支付宝账号
    public function pinless_add()
    {
        $root = array('status' => 0, 'error' => api_lang("Binding_failed"));
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,alipay_name,alipay_account from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }

        $pay = strim($_REQUEST['pay']);
        $pay_name = strim($_REQUEST['pay_name']);
        $alipay = array();
        $alipay['alipay_name'] = $pay_name;
        $alipay['alipay_account'] = $pay;
        $alipay['binding_alipay'] = 1;
        $where = "id=" . $user_info['id'];
        $result = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $alipay, "UPDATE", $where);
        if ($result) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_redis->update_db($user_info['id'], $alipay);
            $root['status'] = 1;
            $root['error'] = api_lang("Binding_succeeded");
        }
        api_ajax_return($root);
    }

    //我的上级用户
    public function superior()
    {
        $root = array('error' => '', 'status' => 1, 'data' => array());
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,alipay_name,alipay_account from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $article = array();
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        } else {
            $user_id = $user_info['id'];
            $article = $GLOBALS['db']->getRow("select v.id,v.nick_name,v.head_image from " . DB_PREFIX . "invite_rewards as a left join " . DB_PREFIX . "user as v on v.id = a.inviteid  where a.uid =" . $user_id, true, true);
            $article['nick_name'] = emoji_decode($article['nick_name']);
            $article['head_image'] = $article['head_image'] ? get_abs_img_root($article['head_image']) : get_abs_img_root($root['m_config']['app_logo']);
        }
        $root['data'] = $article;
        api_ajax_return($root);
    }

    //短链接生成
    public function short_connection($urls)
    {

        /**
         * 生成短网址
         */
        //短网址生成接口地址&传递的参数
        $url = "http://api.weibo.com/2/short_url/shorten.json?source=2849184197&url_long=" . $urls;
        $result = file_get_contents($url);
        $name = json_decode($result, true);
        if ($name['urls'][0]['result']) {
            return $name['urls'][0]['url_short'];
        } else {
            return $urls;
        }
    }


    /*  --------------------------------     vue end  --------------------------------------------------      */


    //app邀请奖励页面
    public function index1()
    {
        $root = array();
        //   用户ID
        $user_id = intval($_REQUEST['user_id']) ? intval($_REQUEST['user_id']) : $GLOBALS['user_info']['id'];//

        if ($user_id == 0) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //本用户余额详情
            $root = $this->get_diamonds($user_id);
            $sql = "select alipay_name,alipay_account from " . DB_PREFIX . "user  where id=" . $user_id;
            $user = $GLOBALS['db']->getRow($sql);

            $root['alipay_name'] = $user['alipay_name'];
            $root['alipay_account'] = $user['alipay_account'];
            $root['status'] = 1;

            $root['error'] = '';

        }

        $get_url = urlencode(SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=invite_rewards&act=download&invite_code=" . $user_id);
        $url = $this->short_connection($get_url);
        $root['url'] = $url;

        api_ajax_return($root);
    }

    //转入我的余额
    public function balance()
    {
        $root = array('error' => api_lang("user_not_logged_in"), 'status' => 0);
        $type = intval($_REQUEST['type']);
        $sum = intval($_REQUEST['sum']);
        $user_id = intval($_REQUEST['user_id']);
        $alipay_name = $_REQUEST['alipay_name'];
        $alipay_account = $_REQUEST['alipay_account'];
        //    $user_id=164738;
        if ($user_id == 0) {
            $user_id = $GLOBALS['user_info']['id'];
        }
        if ($user_id == 0) {
            ajax_return($root);
        }
        $user = $this->get_diamonds($user_id);
        if ($user['sum'] < $sum || $sum <= 0) {
            $root['error'] = api_lang("Incorrect_diamond_input");
            ajax_return($root);
        }
        if ($type == 2) {
            $money = floor($sum / $user['m_config']['invite_rewards_withdrawal']);
            if ($money <= 0) {
                $root['error'] = api_lang("amount_entered_is_incorrect");
                ajax_return($root);
            }
        } else {
            $money = 0;
        }
        if ($type == 2) {
            $money = floor($sum / $user['m_config']['invite_rewards_withdrawal']);
            if ($money <= 0) {
                $root['error'] = api_lang("amount_entered_is_incorrect");
                ajax_return($root);
            }
            if ($money < 1) {
                $root['error'] = api_lang("More_than_1_yuan_can_reflect");
                ajax_return($root);
            }
            $pay_type = $this->binding_alipay($user_id, $alipay_name, $alipay_account);

            if ($pay_type != 1) {
                $root['type'] = '1';
                $root['error'] = api_lang("Alipay_does_not_exist");
                ajax_return($root);
            }

        }

        $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards_log(uid,money,diamonds,type,status,addtime) VALUES ('" . $user_id . "', '" . $money . "','" . $sum . "','" . $type . "','0','" . time() . "')";
        $result = $GLOBALS['db']->query($sql);

        if ($result) {
            $root['error'] = api_lang("successful_waiting_for_audit");
            $root['status'] = 1;
        } else {
            $root['error'] = api_lang("operation_failed");
        }

        ajax_return($root);
    }

    //获取总钻石
    public function get_diamonds($user_id)
    {
        //获取邀请的总人数
        $sql = "select * from " . DB_PREFIX . "invite_rewards  where inviteid=" . $user_id;
        $invite_rewards = $GLOBALS['db']->getAll($sql);
        $diamonds = 0;
        foreach ($invite_rewards as $v) {
            $uid = $v['uid'];
            $sql = "select sum(diamonds) from " . DB_PREFIX . "payment_notice  where user_id=" . $uid . " and type=0 and is_paid=1";
            $payment_notice = $GLOBALS['db']->getOne($sql);
            $diamonds += $payment_notice ? $payment_notice : '0';
        }

        $m_config = load_auto_cache("m_config");
        $money = $diamonds * $m_config['invite_rewards_recharge'] / 100;


        //获取提现的钻石
        $sql = "select sum(diamonds) from " . DB_PREFIX . "invite_rewards_log  where uid=" . $user_id . " and status !=2";
        $invite_log = $GLOBALS['db']->getOne($sql);
        //获取注册获得的钻石,统计剩余的钻石
        $count_sum = count($invite_rewards);

        //获取用户充值的奖励钻石总数
        $sum_coin = round($money) + $count_sum * $m_config['invite_rewards'];

        $sum = $sum_coin - $invite_log;

        $article = $GLOBALS['db']->getRow("select a.* from " . DB_PREFIX . "article as a left join " . DB_PREFIX . "article_cate as v on v.id = a.cate_id  where a.is_effect = 1 and a.is_delete = 0 and v.title='" . api_lang("Invite_Awards") . "' order by a.sort desc", true, true);

        $root['diamonds'] = $sum_coin;
        $root['sum'] = round($sum) > 0 ? round($sum) : '0';
        $root['count_sum'] = $count_sum;
        $root['count_sum_diamonds'] = round($money);
        $root['m_config'] = $m_config;
        $root['list'] = $article;
        return $root;
    }


    //邀请下载页面
    public function download()
    {
        $file_contents = file_get_contents('http://pv.sohu.com/cityjson');
        $ip = explode('"', explode(':', $file_contents)[1])[1];
        $m_config = load_auto_cache("m_config");
        if (strpos($_SERVER['HTTP_USER_AGENT'], 'iPhone') || strpos($_SERVER['HTTP_USER_AGENT'], 'iPad')) {
            $root['filename'] = $m_config['ios_share_downloads'];
        } else if (strpos($_SERVER['HTTP_USER_AGENT'], 'Android')) {
            $root['filename'] = $m_config['android_share_downloads'];
        }

        $yqm = $_REQUEST['invite_code'];
        $sql = "select id from " . DB_PREFIX . "code_ip  where ip='$ip' and code='$yqm'";

        $codeid = $GLOBALS['db']->getOne($sql);
        if (!$codeid) {
            $sql = "INSERT INTO " . DB_PREFIX . "code_ip(ip,code,addtime) VALUES ('" . $ip . "', '" . $yqm . "','" . time() . "')";
            $GLOBALS['db']->query($sql);
        }
        //是否开启openinstall
        $root['openinstall'] = OPEN_OPENINSTALL == 1 ? $m_config['openinstall_val'] : 0;

        $root['yqm'] = $yqm ? $yqm : '';

        $root['app_logo'] = $m_config['app_logo'];

        $root['program_title'] = $m_config['program_title'];

        $root['qr_code'] = get_spec_image($m_config['download_qr_code']);

        api_ajax_return($root);
    }

    //绑定支付宝账户
    public function binding_alipay($user_id, $alipay_name, $alipay_account)
    {

        if ($alipay_name != '' && $alipay_account != '') {

            $sql = "select alipay_name,alipay_account from " . DB_PREFIX . "user  where id=" . $user_id;
            $user = $GLOBALS['db']->getRow($sql);

            if ($user['alipay_name'] == $alipay_name && $user['alipay_account'] == $alipay_account) {
                return 1;
            } else {
                $alipay = array();
                $alipay['alipay_name'] = strim($alipay_name);
                $alipay['alipay_account'] = strim($alipay_account);
                $alipay['binding_alipay'] = 1;
                $where = "id=" . $user_id;
                $result = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $alipay, "UPDATE", $where);

                if ($result) {
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    $user_ticket_info = $user_redis->update_db($user_id, $alipay);
                    return 1;
                }
            }
        }
        return 0;

    }

}