<?php
/**
 * 布谷科技商业系统
 * 多人直播房间
 * @author 山东布谷鸟网络科技有限公司
 * @create 2020-11-02 17:47
 */


class live_multi_roomModule extends baseModule
{

    /**
     * 用户-同意上麦&拒绝上麦
     * */
    public function api_request_host_agree()
    {
        $this->checkUserLogin();

        //上麦的位置
        $wheat_id = get_input('wheat_id', 'n');
        //直播ID
        $video_id = get_input('video_id', 'n');
        //直播ID
        $action = get_input('action', 'n');
        $to_user_id = get_input('to_user_id', 's');

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        //判断是不是当前用户的直播间
        $fields = array('user_id', 'vote_number', 'watch_number', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id');
        $video_info = $video_redis->getRow_db($video_id, $fields);

        if ($video_info['user_id'] != $this->loginUserId) {
            $return['error'] = api_lang("Insufficient_authority");
            $return['status'] = 0;
            ajax_return($return);
        }

        //查询是否已经在麦位
        $sql = "select status,user_id from " . DB_PREFIX . "video_multi_wheat_info where video_id=" . $video_id . ' and wheat_num=' . $wheat_id;
        $wheat_info_exits = $GLOBALS['db']->getRow($sql, true, true);

        if ($action == 1) {

            if ($wheat_info_exits && $wheat_info_exits['user_id'] != $to_user_id) {
                $return['error'] = api_lang("Other_users_have_applied_Macintosh");
                $return['status'] = 0;
                ajax_return($return);
            }

            //更新麦位状态
            $sql = "update " . DB_PREFIX . "video_multi_wheat_info set status = 1 where wheat_num = " . $wheat_id . " and video_id = " . $video_id;
            $GLOBALS['db']->query($sql);
        } else {
            //删除，拒绝上麦
            $sql = "DELETE FROM " . DB_PREFIX . "video_multi_wheat_info WHERE user_id=" . $to_user_id . " and wheat_num=" . $wheat_id;
            $GLOBALS['db']->query($sql);
        }

        $return['error'] = "";
        $return['status'] = 1;
        ajax_return($return);

    }


    /**
     * 对用户开麦闭麦操作
     * */
    public function api_action_mute_mike()
    {
        //上麦的位置
        $wheat_id = get_input('mic_num', 'n');
        //直播ID
        $video_id = get_input('video_id', 'n');
        //麦克风状态
        $mute_status = get_input('mute_status', 'n');

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        //判断是不是当前用户的直播间
        $fields = array('user_id', 'vote_number', 'watch_number', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id');
        $video_info = $video_redis->getRow_db($video_id, $fields);

        if ($video_info['user_id'] != $this->loginUserId) {
            $return['error'] = api_lang("Insufficient_authority");
            $return['status'] = 0;
            ajax_return($return);
        }

        //更新麦位状态
        $sql = "update " . DB_PREFIX . "video_multi_wheat_info set mute_status = {$mute_status} where wheat_num = " . $wheat_id . " and video_id = " . $video_id;
        $GLOBALS['db']->query($sql);

        $return['error'] = "";
        $return['status'] = 1;
        ajax_return($return);
    }

    /**
     * 获取房间在线用户列表
     * */
    public function api_get_room_user_list()
    {

        $video_id = get_input('video_id', 'n');
        $group_id = get_input('group_id', 's');

        $page = get_input('p', 'n');

        $root = load_auto_cache("video_viewer", array('group_id' => $group_id, 'video_id' => $video_id, 'page' => $page));

        //过滤user_id为0的机器人
        for ($i = count($root['list']) - 1; $i >= 0; $i--) {
            if ($root['list'][$i]['user_id'] == 0) {
                array_splice($root['list'], $i, 1);
                continue;
            }
        }

        ajax_return($root);
    }

    /**
     * 麦位列表-主播查看管理
     * */
    public function api_mic_list()
    {
        $this->checkUserLogin();

        //直播ID
        $video_id = get_input('video_id', 'n');

        //查询麦位列表
        $sql = "select v.*,u.nick_name,u.head_image from " . DB_PREFIX . "video_multi_wheat_info as v left join " . DB_PREFIX . "user as u on v.user_id=u.id where v.user_id!=" . $this->loginUserId . " and v.video_id=" . $video_id;
        $wheat_list = $GLOBALS['db']->getAll($sql, true, true);

        foreach ($wheat_list as &$v) {
            $v['head_image'] = get_spec_image($v['head_image']);
        }

        $return['list'] = $wheat_list;
        $return['error'] = "";
        $return['status'] = 1;

        ajax_return($return);
    }


    /**
     * host邀请用户上麦
     * */
    public function api_request_invite_up_mic()
    {
        $this->checkUserLogin();

        //上麦的位置
        $mic_num = get_input('mic_num', 'n');
        //直播ID
        $video_id = get_input('video_id', 'n');
        //邀请上麦的用户ID
        $invite_user_id = get_input('invite_user_id', 'n');

        //查询是否已经在麦位
        $sql = "select status,user_id,wheat_num from " . DB_PREFIX . "video_multi_wheat_info where user_id = " . $invite_user_id . " and video_id=" . $video_id . ' and wheat_num=' . $mic_num;
        $wheat_info_exits = $GLOBALS['db']->getRow($sql, true, true);

        //判断是否已经有人 $wheat_info_exits['user_id'] != $invite_user_id &&
        if ($wheat_info_exits && $wheat_info_exits['wheat_num'] == $mic_num && $wheat_info_exits['status'] == 0) {

            //这里要删除之前的邀请记录
            $sql = "DELETE FROM " . DB_PREFIX . "video_multi_wheat_info WHERE wheat_num={$mic_num} and video_id=" . $video_id;
            $GLOBALS['db']->query($sql);

        } else if ($wheat_info_exits && $wheat_info_exits['wheat_num'] == $mic_num && $wheat_info_exits['status'] == 1) {

            $return['error'] = api_lang("There_users_the_market");
            $return['status'] = 0;
            ajax_return($return);

        }

        //插入麦序位
        $wheat_info = ['user_id' => $invite_user_id, 'video_id' => $video_id, 'wheat_num' => $mic_num, 'create_time' => NOW_TIME];

        $GLOBALS['db']->autoExecute(DB_PREFIX . "video_multi_wheat_info", $wheat_info, 'INSERT');

        $return['error'] = "";
        $return['status'] = 1;
        ajax_return($return);
    }

    /**
     * 申请上麦
     * */
    public function api_request_up_mic()
    {
        $this->checkUserLogin();

        //上麦的位置
        $mic_num = get_input('mic_num', 'n');
        //直播ID
        $video_id = get_input('video_id', 'n');

        //查询是否已经在麦位
        $sql = "select status,user_id,wheat_num from " . DB_PREFIX . "video_multi_wheat_info where video_id=" . $video_id . ' and wheat_num=' . $mic_num;
        $wheat_info_exits = $GLOBALS['db']->getRow($sql, true, true);

        if ($wheat_info_exits && $wheat_info_exits['user_id'] == $this->loginUserId) {
            $return['error'] =  api_lang("have_applied_place");
            $return['status'] = 0;
            ajax_return($return);
        }


        //查询当前用户是否已经在麦位
        $sql = "select status,user_id,wheat_num from " . DB_PREFIX . "video_multi_wheat_info where video_id=" . $video_id . ' and user_id=' . $this->loginUserId . ' and status = 1';
        $user_wheat_info_exits = $GLOBALS['db']->getRow($sql, true, true);

        if ($user_wheat_info_exits) {
            $return['error'] = api_lang("Please_put_wheat_before_operation");
            $return['status'] = 0;
            ajax_return($return);
        }


        //判断是否已经有人
        if ($wheat_info_exits && $wheat_info_exits['user_id'] != $this->loginUserId && $wheat_info_exits['wheat_num'] == $mic_num) {
            $return['error'] = api_lang("Other_person_request_already_exists");
            $return['status'] = 0;
            ajax_return($return);
        }

        //插入麦序位
        $wheat_info = ['user_id' => $this->loginUserId, 'video_id' => $video_id, 'wheat_num' => $mic_num, 'create_time' => NOW_TIME];

        $GLOBALS['db']->autoExecute(DB_PREFIX . "video_multi_wheat_info", $wheat_info, 'INSERT');

        $return['error'] = "";
        $return['status'] = 1;
        ajax_return($return);
    }


    /**
     * 用户-同意上麦&拒绝上麦
     * */
    public function api_request_agree()
    {
        $this->checkUserLogin();

        //上麦的位置
        $wheat_id = get_input('wheat_id', 'n');
        //直播ID
        $video_id = get_input('video_id', 'n');
        //直播ID
        $action = get_input('action', 'n');

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        //判断是不是当前用户的直播间
//        $fields = array('user_id', 'vote_number', 'watch_number', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id');
//        $video_info = $video_redis->getRow_db($video_id, $fields);
//
//        if ($video_info['user_id'] != $this->loginUserId) {
//            $return['error'] = "权限不足！";
//            $return['status'] = 0;
//            ajax_return($return);
//        }

        //查询是否已经在麦位
        $sql = "select status,user_id from " . DB_PREFIX . "video_multi_wheat_info where video_id=" . $video_id . ' and wheat_num=' . $wheat_id;
        $wheat_info_exits = $GLOBALS['db']->getRow($sql, true, true);

        if ($action == 1) {

            if ($wheat_info_exits && $wheat_info_exits['user_id'] != $this->loginUserId) {
                $return['error'] = api_lang("Other_users_have_applied_Macintosh");
                $return['status'] = 0;
                ajax_return($return);
            }

            //更新麦位状态
            $sql = "update " . DB_PREFIX . "video_multi_wheat_info set status = 1 where wheat_num = " . $wheat_id . " and video_id = " . $video_id;
            $GLOBALS['db']->query($sql);
        } else {
            //删除，拒绝上麦
            $sql = "DELETE FROM " . DB_PREFIX . "video_multi_wheat_info WHERE user_id=" . $this->loginUserId . " and wheat_num=" . $wheat_id;
            $GLOBALS['db']->query($sql);
        }

        $return['error'] = "";
        $return['status'] = 1;
        ajax_return($return);

    }


    /**
     * host-把用户抱下麦
     * */
    public function api_request_do_down_up_mic_user()
    {
        $this->checkUserLogin();

        //上麦的位置
        $wheat_id = get_input('wheat_id', 'n');
        //直播ID
        $video_id = get_input('video_id', 'n');
        //麦位用户ID
        $user_id = get_input('user_id', 'n');

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        //删除，拒绝上麦
        $sql = "DELETE FROM " . DB_PREFIX . "video_multi_wheat_info WHERE user_id=" . $user_id . " and wheat_num=" . $wheat_id;
        $GLOBALS['db']->query($sql);

        $return['error'] = "";
        $return['status'] = 1;
        ajax_return($return);

    }
}