<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

use GuzzleHttp\Client;
use think\Db;

class loginModule extends baseModule
{

    /**
     * 【新】手机登录接口[验证码登录]
     */
    public function do_login_new()
    {

        $m_config = load_auto_cache("m_config"); //初始化手机端配置

        $root = array('status' => 0, 'error' => '', 'first_login' => 0);
        if (!$_REQUEST) {
            app_redirect(APP_ROOT . "/");
        }

        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        // 渠道号
        $channel = trim($_REQUEST['channel']);
        // 用户邀请码
        $invite_code = trim($_REQUEST['invite_code']);
        // 是否禁封
        disableSel($_REQUEST['mobile'], 5);

        if (!in_array($_REQUEST['tel_code'] . $_REQUEST['mobile'], $this->testMobile)) {
            // 如果不是测试账号，获取国家判断IP是否可用，禁止部分国家地区
            $this->checkCountryAreaAvailable();
        } else {
            // 是测试账号，但是需要禁止部分指定地区登录
            $this->checkBanAreaAvailable();
        }

        $result = do_login_user($_REQUEST['mobile'], $_REQUEST['verify_coder'], 0, $channel, $invite_code, '', 1, $_REQUEST['tel_code']);

        if ($result['status']) {
            $root['status'] = 1;
            $root['is_lack'] = $result['is_lack'];

            $root['is_agree'] = intval($result['user']['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
            $root['user_id'] = intval($result['user']['id']);
            $root['nick_name'] = $result['user']['nick_name'];
            $root['token'] = $result['user']['token'];
            if ($m_config['name_limit'] == 1) {
                //登录过滤铭感词汇
                $nick_name = $result['user']['nick_name'];
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                //判断用户名是否含有铭感词汇,如果包含,替换
                $nick_name1 = str_replace("'", "''", $nick_name);
                if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                    $root['nick_name'] = str_replace($limit_sql, '', $nick_name);
                }
                //判断用户名如果被过滤后为空,格式则变更为： 账号+ID
                if ($root['nick_name'] == '') {
                    $root['nick_name'] = ($m_config['default_nickname'] . $root['user_id']);
                }
                $result['user_info']['nick_name'] = $root['nick_name'];
                $name = $result['user_info']['nick_name'];
                $id = $result['user']['id'];
                //更新数据库
                $sql = "update " . DB_PREFIX . "user set nick_name = '$name' where id=" . $id;
                $GLOBALS['db']->query($sql);
                //更新redis
                user_deal_to_reids(array($id));
            }
            $is_effect = $GLOBALS['db']->getOne("select is_effect from " . DB_PREFIX . "user where id =" . $root['user_id']);
            if ($root['is_lack']) {
                $root['error'] = api_lang("Update_information");
            } elseif ($is_effect != 1) {
                ajax_return(array("status" => 0, "error" => api_lang("Account_disabled")));
            } elseif ($GLOBALS['db']->getOne("SELECT login_ip FROM " . DB_PREFIX . "user WHERE login_ip = '" . get_client_ip() . "' and is_effect !=1 and ban_type = 1")) {
                ajax_return(array("status" => 0, "error" => api_lang("IP_blocked")));
            } else {
                $root['error'] = api_lang("Login_successful");
            }
            $root['user_info'] = $result['user_info'];
            $root['is_tips'] = $result['is_tips']; //是否弹过弹窗

            $root['first_login'] = $result['first_login'];
            $root['new_level'] = $result['new_level'];
            $root['login_send_score'] = intval($m_config['login_send_score']);
            //登录日志
            $log_date = array();
            if (is_array($_REQUEST)) $log_date['request'] = json_encode($_REQUEST);
            $log_date['login_type'] = 2;
            $log_date['user_id'] = $root['user_id'];
            if (function_exists('log_login')) {
                log_login($log_date);
            }
        } else {
            $root['error'] = $result['info'];
        }
        ajax_return($root);
    }


    /**
     *   密码注册接口
     */
    public function password_registered()
    {
        $m_config = load_auto_cache("m_config"); //初始化手机端配置
        $root = array('status' => 0, 'error' => '', 'first_login' => 0);
        if (!$_REQUEST) {
            app_redirect(APP_ROOT . "/");
        }

        if (!isset($_REQUEST['mobile'])) {
            $root['error'] = api_lang("Input_mobile_phone_number");
            ajax_return($root);
        }

        if (!isset($_REQUEST['password'])) {
            $root['error'] = api_lang("Please_input_password");
            ajax_return($root);
        }

        if (!isset($_REQUEST['confirm_password'])) {
            $root['error'] = api_lang("Enter_the_confirmation_password");
            ajax_return($root);
        }
        if (strlen($_REQUEST['password']) < 6) {
            $root['error'] = api_lang("Enter_at_least_6_digits_of_password");
            ajax_return($root);
        }
        if ($_REQUEST['password'] != $_REQUEST['confirm_password']) {
            $root['error'] = api_lang("Password_inconsistency");
            ajax_return($root);
        }

        $is_user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where mobile = " . $_REQUEST['mobile']);

        if ($is_user) {
            $root['error'] = api_lang("Number_registered");
            ajax_return($root);
        }
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");

        //渠道号
        $channel = trim($_REQUEST['channel']);
        //用户邀请码
        $invite_code = trim($_REQUEST['invite_code']);


        $result = do_login_user($_REQUEST['mobile'], $_REQUEST['verify_coder'], 0, $channel, $invite_code, $_REQUEST['password'], 1, $_REQUEST['tel_code']);

        if ($result['status']) {
            $root['status'] = 1;
            $root['is_lack'] = $result['is_lack'];

            $root['is_agree'] = intval($result['user']['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
            $root['user_id'] = intval($result['user']['id']);
            $root['nick_name'] = $result['user']['nick_name'];

            if ($m_config['name_limit'] == 1) {
                //登录过滤铭感词汇
                $nick_name = $result['user']['nick_name'];
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                //判断用户名是否含有铭感词汇,如果包含,替换
                $nick_name1 = str_replace("'", "''", $nick_name);
                if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                    $root['nick_name'] = str_replace($limit_sql, '', $nick_name);
                }
                //判断用户名如果被过滤后为空,格式则变更为： 账号+ID
                if ($root['nick_name'] == '') {
                    $root['nick_name'] = ($m_config['default_nickname'] . $root['user_id']);
                }
                $result['user_info']['nick_name'] = $root['nick_name'];
                $name = $result['user_info']['nick_name'];
                $id = $result['user']['id'];
                //更新数据库
                $sql = "update " . DB_PREFIX . "user set nick_name = '$name' where id=" . $id;
                $GLOBALS['db']->query($sql);
                //更新redis
                user_deal_to_reids(array($id));
            }
            $is_effect = $GLOBALS['db']->getOne("select is_effect from " . DB_PREFIX . "user where id =" . $root['user_id']);
            if ($root['is_lack']) {
                $root['error'] = api_lang("Update_information");
            } elseif ($is_effect != 1) {
                ajax_return(array("status" => 0, "error" => api_lang("Account_disabled")));
            } elseif ($GLOBALS['db']->getOne("SELECT login_ip FROM " . DB_PREFIX . "user WHERE login_ip = '" . get_client_ip() . "' and is_effect !=1 and ban_type = 1")) {
                ajax_return(array("status" => 0, "error" => api_lang("IP_blocked")));
            } else {
                $root['error'] = api_lang("Login_successful");
            }
            $root['user_info'] = $result['user_info'];
            $root['is_tips'] = 0; //是否弹过弹窗
            $root['first_login'] = $result['first_login'];
            $root['new_level'] = $result['new_level'];
            $root['login_send_score'] = intval($m_config['login_send_score']);
            //登录日志
            $log_date = array();
            if (is_array($_REQUEST)) $log_date['request'] = json_encode($_REQUEST);
            $log_date['login_type'] = 1;
            $log_date['user_id'] = $root['user_id'];
            if (function_exists('log_login')) {
                log_login($log_date);
            }
        } else {
            $root['error'] = $result['info'];
        }
        ajax_return($root);
    }

    /**
     * 修改密码
     */
    public function update_password()
    {
        $root = array('status' => 0, 'error' => api_lang("Modification_failed"));
        if (!$_REQUEST) {
            app_redirect(APP_ROOT . "/");
        }

        if (!isset($_REQUEST['mobile'])) {
            $root['error'] = api_lang("Input_mobile_phone_number");
            ajax_return($root);
        }
        if (!isset($_REQUEST['verify_coder'])) {
            $root['error'] = api_lang("Please_enter_the_verification_code");
            ajax_return($root);
        }
        if (!isset($_REQUEST['password'])) {
            $root['error'] = api_lang("Please_input_password");
            ajax_return($root);
        }

        if (!isset($_REQUEST['confirm_password'])) {
            $root['error'] = api_lang("Enter_the_confirmation_password");
            ajax_return($root);
        }
        if (strlen($_REQUEST['password']) < 6) {
            $root['error'] = api_lang("Enter_at_least_6_digits_of_password");
            ajax_return($root);
        }
        if ($_REQUEST['password'] != $_REQUEST['confirm_password']) {
            $root['error'] = api_lang("Password_inconsistency");
            ajax_return($root);
        }
        if ($GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $_REQUEST['mobile'] . " AND verify_code='" . $_REQUEST['verify_coder'] . "'") == 0) {
            $root['error'] = api_lang("Verification_code_error");
            ajax_return($root);
        }

        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where mobile = '" . $_REQUEST['mobile'] . "'");

        if (!$user) {
            $root['error'] = api_lang("Account_does_not_exist");
            ajax_return($root);
        }
        if ($user['is_effect'] != 1) {
            $root['error'] = api_lang("account_has_been_disabled");
            ajax_return($root);
        }
        $password = md5($_REQUEST['password'] . "_EASE_COOKIE");
        if ($user['user_pwd'] == $password) {
            $root['status'] = 1;
            $root['error'] = api_lang("Modification_succeeded");
            ajax_return($root);
        }
        $sql = "update " . DB_PREFIX . "user set user_pwd = '$password' where id=" . $user['id'];
        $status = $GLOBALS['db']->query($sql);
        if ($status) {
            $root['status'] = 1;
            $root['error'] = api_lang("Modification_successful_please_login");
        }
        ajax_return($root);
    }

    /**
     *  【新】密码登录
     */
    public function password_login_new()
    {

        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $m_config = load_auto_cache("m_config"); //初始化手机端配置
        $root = array('status' => 0, 'error' => '', 'first_login' => 0);
        if (!$_REQUEST) {
            app_redirect(APP_ROOT . "/");
        }

        if (!isset($_REQUEST['mobile'])) {
            $root['error'] = api_lang("Input_mobile_phone_number");
            ajax_return($root);
        }
        if (!isset($_REQUEST['password'])) {
            $root['error'] = api_lang("Please_input_password");
            ajax_return($root);
        }

        if (!isset($_REQUEST['tel_code'])) {
            $root['error'] = 'The number location cannot be empty!';
            ajax_return($root);
        }

        // 获取国家判断IP是否可用
        if (!in_array($_REQUEST['tel_code'] . $_REQUEST['mobile'], $this->testMobile)) {
            // 获取国家判断IP是否可用
            $this->checkCountryAreaAvailable();
        }

        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where mobile = " . $_REQUEST['mobile'] . " and tel_code = " . $_REQUEST['tel_code']);

        if (!$user) {
            $root['error'] = api_lang("Account_does_not_exist");
            ajax_return($root);
        }
        if ($user['is_effect'] != 1) {
            $root['error'] = api_lang("account_has_been_disabled");
            ajax_return($root);
        }

        if ($user['user_pwd'] != md5($_REQUEST['password'] . "_EASE_COOKIE")) {
            $root['error'] = api_lang("Re_enter_the_password");
            ajax_return($root);
        }

        bogo_require(APP_ROOT_PATH . "system/libs/user.php");

        //渠道号
        $channel = trim($_REQUEST['channel']);
        //用户邀请码
        $invite_code = trim($_REQUEST['invite_code']);

        $result = do_login_user($_REQUEST['mobile'], $_REQUEST['verify_coder'], 0, $channel, $invite_code, $_REQUEST['password'], 1);

        if ($result['status']) {
            $root['status'] = 1;
            $root['is_lack'] = $result['is_lack'];

            $root['is_agree'] = intval($result['user']['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
            $root['user_id'] = intval($result['user']['id']);
            $root['nick_name'] = $result['user']['nick_name'];

            if ($m_config['name_limit'] == 1) {
                //登录过滤铭感词汇
                $nick_name = $result['user']['nick_name'];
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                //判断用户名是否含有铭感词汇,如果包含,替换
                $nick_name1 = str_replace("'", "''", $nick_name);
                if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                    $root['nick_name'] = str_replace($limit_sql, '', $nick_name);
                }
                //判断用户名如果被过滤后为空,格式则变更为： 账号+ID
                if ($root['nick_name'] == '') {
                    $root['nick_name'] = ($m_config['default_nickname'] . $root['user_id']);
                }
                $result['user_info']['nick_name'] = $root['nick_name'];
                $name = $result['user_info']['nick_name'];
                $id = $result['user']['id'];
                //更新数据库
                $sql = "update " . DB_PREFIX . "user set nick_name = '$name' where id=" . $id;
                $GLOBALS['db']->query($sql);
                //更新redis
                user_deal_to_reids(array($id));
            }

            $is_effect = $GLOBALS['db']->getOne("select is_effect from " . DB_PREFIX . "user where id =" . $root['user_id']);
            if ($root['is_lack']) {
                $root['error'] = api_lang("Update_information");
            } elseif ($is_effect != 1) {
                ajax_return(array("status" => 0, "error" => api_lang("Account_disabled")));
            } elseif ($GLOBALS['db']->getOne("SELECT login_ip FROM " . DB_PREFIX . "user WHERE login_ip = '" . get_client_ip() . "' and is_effect !=1 and ban_type = 1")) {
                ajax_return(array("status" => 0, "error" => api_lang("IP_blocked")));
            } else {
                $root['error'] = api_lang("Login_successful");
            }
            $root['user_info'] = $result['user_info'];
            $root['is_tips'] = $result['is_tips']; //是否弹过弹窗
            $root['first_login'] = $result['first_login'];
            $root['new_level'] = $result['new_level'];
            $root['login_send_score'] = intval($m_config['login_send_score']);
            //登录日志
            $log_date = array();
            if (is_array($_REQUEST)) $log_date['request'] = json_encode($_REQUEST);
            $log_date['login_type'] = 1;
            $log_date['user_id'] = $root['user_id'];
            if (function_exists('log_login')) {
                log_login($log_date);
            }
        } else {
            $root['error'] = $result['info'];
        }

        ajax_return($root);
    }

    /**注册提示弹窗**/
    public function is_tips()
    {
        $root = array('status' => 0, 'error' => '');
        $uid = intval($_REQUEST['uid']) ? intval($_REQUEST['uid']) : $GLOBALS['user_info']['id'];
        if (empty($uid)) {
            $root['error'] = "缺少必要参数";
            ajax_return($root);
        }

        $user = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where id = ' . $uid);
        if (empty($user)) {
            $root['error'] = api_lang('is_tips_error_1');
            ajax_return($root);
        }

        $up = $GLOBALS['db']->query("update " . DB_PREFIX . "user set is_tips = 1 where id =" . $uid);
        if ($up) {
            $root['status'] = 1;
        }
        ajax_return($root);
    }

    /**
     * 检验手机号
     *  用于忘记密码使用
     */
    public function check_mobile()
    {
        $mobile = strim($_REQUEST['mobile']);
        $tel_code = intval($_REQUEST['tel_code']);
        $lists = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where mobile = ' . $mobile . ' and tel_code =' . $tel_code);
        if ($lists) {
            $data['status'] = 1;
            $data['error'] = '';
            ajax_return($data);
        } else {
            $data['status'] = 0;
            $data['error'] = '账号未注册，请先去注册';
            ajax_return($data);
        }
    }

    /**
     * 修改密码
     */
    public function update_password_new()
    {

        $root = array('status' => 0, 'error' => api_lang("Modification_failed"));

        $tel_code = $_REQUEST['tel_code'];
        $code = $_REQUEST['verify_coder'];
        $mobile = $_REQUEST['mobile'];
        $otp_id = $_REQUEST['otp_message_id'];
        $password = $_REQUEST['password'];

        if (!isset($_REQUEST['mobile'])) {
            $root['error'] = api_lang("Input_mobile_phone_number");
            ajax_return($root);
        }
        if (!isset($_REQUEST['verify_coder'])) {
            $root['error'] = api_lang("Please_enter_the_verification_code");
            ajax_return($root);
        }
        if (!isset($_REQUEST['password'])) {
            $root['error'] = api_lang("Please_input_password");
            ajax_return($root);
        }

        if (!isset($_REQUEST['confirm_password'])) {
            $root['error'] = api_lang("Enter_the_confirmation_password");
            ajax_return($root);
        }
        if (strlen($_REQUEST['password']) < 6) {
            $root['error'] = api_lang("Enter_at_least_6_digits_of_password");
            ajax_return($root);
        }
        if ($_REQUEST['password'] != $_REQUEST['confirm_password']) {
            $root['error'] = api_lang("Password_inconsistency");
            ajax_return($root);
        }

        if (OPEN_OTP_SMS) {
            // 获取客户端传递的 otp_msg_id

            $verifyCodeRecord = dbGetRow(
                'mobile_verify_code',
                '',
                '',
                [],
                ['mobile' => $mobile, 'message_id' => $otp_id, 'area_code' => $tel_code]
            );

            if (!$verifyCodeRecord) {
                $result['info'] = api_lang("Verification_code_error");
                return $result;
            }

            // 判断如果有message_id就是otp验证码需要去验证
            if (!empty($verifyCodeRecord['message_id'])) {

                require_once APP_ROOT_PATH . "system/sms/ENGAGESOTP_sms.php";

                $sms = new ENGAGESOTP_sms();
                $verifyResult = $sms->verifySms($otp_id, $code);

                if ($verifyResult['code'] != 200 || !$verifyResult['verified']) {
                    $result['error'] = 'OTP:' . (empty($verifyResult['msg']) ? api_lang("Verification_code_error") : $verifyResult['msg']);
                    return $result;
                }
            } else {
                $result['error'] = api_lang("Verification_code_error") . ' code 3001';
                return $result;
            }
        } else {

            if ($GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND verify_code='" . $code . "'") == 0) {
                $root['error'] = api_lang("Verification_code_error");
                ajax_return($root);
            }
        }

        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where mobile = '" . $mobile . "' and tel_code = " . $tel_code);

        if (!$user) {
            $root['error'] = api_lang("Account_does_not_exist");
            ajax_return($root);
        }
        if ($user['is_effect'] != 1) {
            $root['error'] = api_lang("account_has_been_disabled");
            ajax_return($root);
        }
        $password = md5($_REQUEST['password'] . "_EASE_COOKIE");
        if ($user['user_pwd'] == $password) {
            $root['status'] = 1;
            $root['error'] = api_lang("Modification_succeeded");
            ajax_return($root);
        }
        $sql = "update " . DB_PREFIX . "user set user_pwd = '$password' where id=" . $user['id'];
        $status = $GLOBALS['db']->query($sql);
        if ($status) {
            $root['status'] = 1;
            $root['error'] = api_lang("Modification_successful_please_login");
        }

        ajax_return($root);
    }

    /**
     * 发送手机验证码[国际化验证码]
     */
    function send_mobile_verify_international()
    {
        $mobile = trim($_REQUEST['mobile']);
        $area_code = trim($_REQUEST['area_code']);
        $type = intval($_REQUEST['type']);

        if (app_conf("SMS_ON") == 0) {
            $root['status'] = 0;
            $root['error'] = api_lang("SMS_not_opened");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }
        if ($mobile == '') {
            $root['status'] = 0;
            $root['error'] = api_lang("Input_mobile_phone_number");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        if (!check_mobile($mobile)) {
            $root['status'] = 0;
            $root['error'] = api_lang("Fill_in_the_correct_number");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        //添加：手机发送 防护
        $root = check_sms_send($mobile);
        if ($root['status'] == 0) {
            $root['time'] = 0;
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        if ($GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where mobile = '" . $mobile . "' and is_effect =0")) {
            $root['status'] = 0;
            $root['error'] = api_lang("Account_disabled");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }

        //图片验证码
        if (app_conf("USER_VERIFY_STATUS") == 1 && !$GLOBALS['user_info']) {
            $image_code = strim($_REQUEST['image_code']);
            if ($image_code) {
                $sql = "select id from " . DB_PREFIX . "image_verify_code where verify_code = '" . md5($image_code) . "'";
                $verify_id = $GLOBALS['db']->getOne($sql);
                if (intval($verify_id) == 0) {
                    ajax_return(array("status" => 0, "error" => api_lang("Picture_captcha_error")));
                } else {
                    $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "image_verify_code WHERE verify_code = '" . md5($image_code) . "'");
                }
            } else {
                if ($type) {
                    api_ajax_return(array("status" => 0, "error" => api_lang("Image_verification_code_empty")));
                } else {
                    ajax_return(array("status" => 0, "error" => api_lang("Image_verification_code_empty")));
                }
            }
        }

        //发送时间
        if ($GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "mobile_verify_code where mobile = '" . $mobile . "' and client_ip='" . get_client_ip() . "' and create_time>=" . (get_gmtime() - 60) . " ORDER BY id DESC") > 0) {
            $root['status'] = 0;
            $root['error'] = api_lang("too_fast_to_send");
            if ($type) {
                api_ajax_return($root);
            } else {
                ajax_return($root);
            }
        }
        $n_time = get_gmtime() - 300;
        //删除超过5分钟的验证码
        $GLOBALS['db']->query("DELETE FROM " . DB_PREFIX . "mobile_verify_code WHERE create_time <=" . $n_time);
        //开始生成手机验证
        if ($mobile == '13888888888' || $mobile == '13999999999') {
            $root['status'] = 1;
            $root['time'] = 60;
            $root['error'] = api_lang("Sent_successfully");
        } else {
            $m_config = load_auto_cache("m_config"); //初始化手机端配置

            $code = '';
            if ($m_config['is_test_verification_code'] == 1) {
                $code = $m_config['test_verification_code'];
            }

            $code = $code ?: rand(1000, 9999);

            //$GLOBALS['db']->autoExecute(DB_PREFIX . "mobile_verify_code",array("verify_code" => $code, "mobile" => $mobile, "create_time" => get_gmtime(), "client_ip" => get_client_ip()) , "INSERT");
            $mvCodeId = DB::name('mobile_verify_code')->insertGetId(array("verify_code" => $code, "mobile" => $mobile, "area_code" => $area_code, "create_time" => get_gmtime(), "client_ip" => get_client_ip()));

            $_REQUEST['code'] = $code;

            $send_sms_data = send_verify_sms($area_code . $mobile, $code);

            $area_code_mobile = $area_code . $mobile;
            //$status = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "deal_msg_list where dest = '" . $area_code_mobile . "' and code='" . $code . "'");

            $root['otp_message_id'] = '';

            if ($send_sms_data['is_success']) {

                if (OPEN_OTP_SMS && !empty($send_sms_data['message_id'])) {
                    Db::name('mobile_verify_code')->where('id', '=', $mvCodeId)->update(['message_id' => $send_sms_data['message_id']]);
                    $root['otp_message_id'] = $send_sms_data['message_id'];
                }

                $root['status'] = 1;
                $root['time'] = 60;
                $root['error'] = $code == $m_config['test_verification_code'] ? "Your verification code is:" . $code : $send_sms_data['title'] . $send_sms_data['result'];
            } else {
                $root['status'] = 0;
                $root['time'] = 0;
                $root['error'] = $send_sms_data['result'] ?: api_lang("Verification_code_sending_failed");
            }
        }

        if ($type) {
            api_ajax_return($root);
        } else {
            ajax_return($root);
        }
    }


    /**
     * 检查手机验证码
     */
    public function check_verify_code()
    {
        $settings_mobile_code = strim($_REQUEST['code']);
        $mobile = strim($_REQUEST['mobile']);


        if ($GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND verify_code='" . $settings_mobile_code . "'") == 0) {
            $data['status'] = 0;
            $data['info'] = api_lang("Verification_code_error");
            ajax_return($data);
        } else {
            $data['status'] = 1;
            $data['info'] = api_lang("verification_code_is_correct");
            ajax_return($data);
        }
    }

    /*
     * 苹果登录
     */
    public function apple_login()
    {
        $root = array('status' => 0, 'error' => '');
        $clientUser = strim($_REQUEST['user_id']);
        $nickname = strim($_REQUEST['nickname']);
        $identityToken = strim($_REQUEST['verify_token']);

        bogo_require(APP_ROOT_PATH . "system/utils/vendor_interface_apple.php");
        $ASDecoder = new vendor_interface_apple();

        $verifyRes = $ASDecoder->apple_jwt_verify($identityToken);
        if (is_object($verifyRes)) {
            $verifyRes = (array)$verifyRes;
        }
        if (isset($verifyRes['jwtStatus']) && $verifyRes['jwtStatus'] == 'failed') {
            // 验证失败
            $root['error'] = $verifyRes['jwtMsg'];
            ajax_return($root);
        }
        if ($clientUser != $verifyRes['sub']) {
            $root['error'] = '参数错误';
            ajax_return($root);
        }
        // 是否禁封
        disableSel($clientUser, 7);
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        $root = appleLogin($clientUser, $nickname);
        ajax_return($root);
    }

    /*三方登录绑定手机号*/
    public function bound_mobile()
    {
        $root = array('status' => 0, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $mobile = $_REQUEST['mobile'];
        $tel_code = $_REQUEST['tel_code'];
        $verify_code = $_REQUEST['code'];

        if (empty($mobile)) {
            $root['error'] = "手机号不得为空";
            ajax_return($root);
        }

        $code = $GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND verify_code='" . $verify_code . "'");
        if ($code == 0) {
            $root['error'] = api_lang("Verification_code_error");
            ajax_return($root);
        }

        $user = $GLOBALS['db']->getOne('select count(*) from ' . DB_PREFIX . 'user where mobile = ' . $mobile . ' and tel_code = ' . $tel_code . '  and is_effect = 1');
        if ($user > 0) {
            $root['error'] = "此手机号已绑定，不可重复绑定";
            ajax_return($root);
        } else {
            $up = $GLOBALS['db']->query("update " . DB_PREFIX . "user set mobile = " . $mobile . " , tel_code = " . $tel_code . " where id = " . $user_id);
            if ($up) {
                $root['status'] = 1;
                $root['error'] = "操作成功";
            } else {
                $root['status'] = 0;
                $root['error'] = "操作失败";
            }
        }
        ajax_return($root);
    }

    /**
     * 国家电话地区表
     */
    public function mobile_code()
    {
        $keyword = $_REQUEST['keyword']; //搜索关键字
        $root = array();
        $param = array('keyword' => $keyword);
        $mobile_code = load_auto_cache("mobile_code", $param);
        $root['data'] = $mobile_code;
        $root['status'] = 1;
        $root['error'] = "";
        ajax_return($root);
    }

    /*账号与安全*/
    public function account_security()
    {
        $root = array('status' => 1, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        }
        $user_info = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where  id = ' . $user_id);
        $data = [
            'mobile'   => $user_info['mobile'],
            'tel_code' => $user_info['tel_code'],
            'QQ'       => $user_info['qq_nickname'],
            'wx'       => $user_info['user_name'],
            'is_young' => $user_info['is_open_young'],
        ];
        $root['data'] = $data;
        ajax_return($root);
    }

    //更换手机号 --- 验证之前手机号
    public function verification_mobile()
    {
        $root = array('status' => 0, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $mobile = $_REQUEST['mobile'];
        $verify_code = $_REQUEST['code'];
        $area_code = addslashes(htmlspecialchars(trim($_REQUEST['area_code'])));
        if ($area_code) {
            $sql = "SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND area_code='" . $area_code . "' AND verify_code='" . $verify_code . "'";
        } else {
            $sql = "SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND verify_code='" . $verify_code . "'";
        }
        $code = $GLOBALS['db']->getOne($sql);
        if ($code == 0) {
            $root['error'] = api_lang("Verification_code_error");
        } else {
            $root['status'] = 1;
            $root['error'] = '';
        }
        ajax_return($root);
    }

    //更换手机号
    public function exchange_mobile()
    {
        $root = array('status' => 0, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];

        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }

        $mobile = $_REQUEST['mobile'];
        $tel_code = $_REQUEST['tel_code'];
        $verify_code = $_REQUEST['code'];
        $otp_id = $_REQUEST['otp_message_id'];

        if ($GLOBALS['user_info']['mobile'] == $mobile) {
            $root['error'] = api_lang("新手机号不可与旧手机号一样");
            ajax_return($root);
        }

        if (OPEN_OTP_SMS) {
            // 获取客户端传递的 otp_msg_id

            $verifyCodeRecord = dbGetRow(
                'mobile_verify_code',
                '',
                '',
                [],
                ['mobile' => $mobile, 'message_id' => $otp_id, 'area_code' => $tel_code]
            );

            if (!$verifyCodeRecord) {
                $result['info'] = api_lang("Verification_code_error");
                return $result;
            }

            // 判断如果有message_id就是otp验证码需要去验证
            if (!empty($verifyCodeRecord['message_id'])) {

                require_once APP_ROOT_PATH . "system/sms/ENGAGESOTP_sms.php";

                $sms = new ENGAGESOTP_sms();
                $verifyResult = $sms->verifySms($otp_id, $verify_code);

                if ($verifyResult['code'] != 200 || !$verifyResult['verified']) {
                    $result['error'] = 'OTP:' . (empty($verifyResult['msg']) ? api_lang("Verification_code_error") : $verifyResult['msg']);
                    return $result;
                }
            } else {
                $result['error'] = api_lang("Verification_code_error") . ' code 3001';
                return $result;
            }
        } else {
            $code = $GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND area_code='" . $tel_code . "' AND verify_code='" . $verify_code . "'");
            if ($code == 0) {
                $root['error'] = api_lang("Verification_code_error");
                ajax_return($root);
            }
        }

        $user = $GLOBALS['db']->getOne('select count(*) from ' . DB_PREFIX . 'user where mobile = ' . $mobile . ' and is_effect = 1');
        if ($user > 0) {
            $root['error'] = api_lang("此手机号已绑定");
            ajax_return($root);
        } else {
            $up = $GLOBALS['db']->query("update " . DB_PREFIX . "user set mobile = " . $mobile . " , tel_code = " . $tel_code . " where id = " . $user_id);
            if ($up) {
                $root['status'] = 1;
                $root['error'] = api_lang("operation_was_successful");
            } else {
                $root['status'] = 0;
                $root['error'] = api_lang("operation_failed");
            }
        }

        ajax_return($root);
    }

    //注销账户
    public function cancellation()
    {
        $root = array('status' => 1, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $user_info = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where id = ' . $user_id);
        $data = [
            'diamonds' => $user_info['diamonds'],
            'ticket'   => round($user_info['ticket'] - $user_info['refund_ticket'], 2)
        ];
        $root['data'] = $data;
        ajax_return($root);
    }

    //确定注销
    public function unsubscribe()
    {
        $root = array('status' => 1, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        $mobile = $_REQUEST['mobile'];
        $verify_code = $_REQUEST['code'];
        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $user_info = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'user where id = ' . $user_id);
        if ($mobile != $user_info['mobile']) {
            $root['error'] = '此手机号未绑定该账户';
            $root['status'] = 0;
            ajax_return($root);
        }

        $code = $GLOBALS['db']->getOne("SELECT count(*) FROM " . DB_PREFIX . "mobile_verify_code WHERE mobile=" . $mobile . " AND verify_code='" . $verify_code . "'");
        if ($code == 0) {
            $root['status'] = 0;
            $root['error'] = api_lang("Verification_code_error");
            ajax_return($root);
        } else {
            //注销账户 : 清空钻石，印票，手机号，微信等信息
            $sql = "update " . DB_PREFIX . "user set mobile = '',tel_code = '',diamonds = 0,ticket = 0,wx_unionid = '',user_name = '',is_effect = 0,ban_type = 0,nick_name ='',user_pwd ='',authentication_name = '',identify_hold_image ='',qq_openid ='',qq_nickname = '',head_image = '',family_id = 0,token = '' where id = " . $user_id;

            $up = $GLOBALS['db']->query($sql);
            if ($up) {
                $reund = $GLOBALS['db']->query("delete from " . DB_PREFIX . "user_refund where user_id='" . $user_id . "' and ( is_pay = 0 or is_pay = 1) ");
                $root['error'] = "注销成功";
            } else {
                $root['status'] = 0;
                $root['error'] = '操作失败';
            }
            ajax_return($root);
        }
    }

    //第三方解绑
    public function unbound_account()
    {
        $root = array('status' => 0, 'error' => '',);
        $user_id = $GLOBALS['user_info']['id'] ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        $type = $_REQUEST['type']; //解绑的类型 1QQ， 2微信
        if (empty($user_id)) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }

        if (empty($type)) {
            $root['error'] = '请选择你要解绑的类型';
            $root['status'] = 0;
            ajax_return($root);
        }

        if ($type == 1) {
            $set = " qq_openid = '',qq_nickname = ''";
        } elseif ($type == 2) {
            $set = " wx_openid = '',wx_unionid = '',user_name=''";
        } else {
            $set = '';
        }

        $sql = "update " . DB_PREFIX . "user set " . $set . " where id = " . $user_id;
        $up = $GLOBALS['db']->query($sql);
        if ($up) {
            $root['error'] = '解绑成功';
            $root['status'] = 1;
        } else {
            $root['error'] = '解绑失败';
            $root['status'] = 0;
        }
        ajax_return($root);
    }

    /**
     * 手机登录更新（昵称、性别、头像）
     */
    public function do_update()
    {
        $root = array("status" => 0, "error" => '');
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        } else {

            $user_data = array();
            $user_req = $_REQUEST;
            foreach ($user_req as $k => $v) {
                $user_req[$k] = strim($v);
            }
            $user_id = $GLOBALS['user_info']['id'];
            $user_data['id'] = $user_id;
            $type = intval($user_req['type']); //开启oss 上传OSS图片链接
            $oss_path = $user_req['oss_path']; //开启oss 上传OSS图片链接
            $normal_head_path = $user_req['normal_head_path']; //修改头像上传的图片链接
            $nick_name = $user_req['nick_name'];
            $head_image = $user_req['head_image']; //注册时候上传的头像链接

            bogo_require(APP_ROOT_PATH . "system/libs/user.php");

            if ($GLOBALS['db']->getOne("SELECT login_ip FROM " . DB_PREFIX . "user WHERE login_ip = '" . get_client_ip() . "' and is_effect !=1 and ban_type = 1")) {
                ajax_return(array("status" => 0, "error" => api_lang("IP_blocked")));
            }
            $m_config = load_auto_cache("m_config"); //初始化手机端配置
            $open_sts = intval($m_config['open_sts']);
            $system_head_image = $m_config['default_avatar'];

            //oss //注册流程 (ios:$normal_head_path==''，android:intval($user_req['sex'])!=0)&&$type==0
            //2.2 版本以后优化此部分 去除 $normal_head_path 和 $user_req['sex']的判断，目前兼容旧版本暂时保留
            if ($normal_head_path == '' && $type == 0 && intval($user_req['sex']) != 0) {
                $GLOBALS['db']->query("set names 'utf8mb4'");
                $nick_name = emoji_encode($nick_name);
                if ($nick_name == '') {
                    ajax_return(array("status" => 0, "error" => api_lang("Please_enter_your_nickname")));
                } else {
                    $user_data['nick_name'] = $nick_name;
                }
                if ($GLOBALS['db']->getOne("SELECT nick_name FROM " . DB_PREFIX . "user WHERE nick_name<>" . $user_id . " and nick_name ='$nick_name'")) {
                    ajax_return(array("status" => 0, "error" => api_lang("Nickname_occupied")));
                }
                //过滤敏感词
                if ($m_config['name_limit'] == 1) {
                    $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                    //昵称如果等于铭感词,则提示,如果包含 则用*代替
                    $in = in_array($nick_name, $limit_sql);
                    $nick_name1 = str_replace("'", "''", $nick_name);
                    if ($in) {
                        ajax_return(array("status" => 0, "error" => api_lang("Nicknames_contain_sensitive_words")));
                    } elseif ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                        $user_data['nick_name'] = str_replace($limit_sql, '*', $nick_name);
                    }
                }
                $user_data['sex'] = $user_req['sex'] == 1 ? 1 : 2;
                //
                //判断头像 IOS 上传参数 $head_image；Android：$oss_path
                if ($head_image == '' && $oss_path == '') {
                    if ($system_head_image == '') {
                        $head_image = './public/attachment/test/noavatar_10.JPG';
                        syn_to_remote_image_server($head_image, false);
                    } else {
                        $head_image = $system_head_image;
                    }
                } else {
                    if ($oss_path != '') {
                        $head_image = $oss_path;
                    }
                }
            } else { //修改头像
                //兼容 IOS和Android 参数名称不同
                if ($normal_head_path == '') {
                    $head_image = $oss_path;
                } else if ($normal_head_path != '') {
                    $head_image = $normal_head_path;
                }
                $user_data['sex'] = $GLOBALS['user_info']['sex'];
            }
            $user_data['head_image'] = $head_image;

            $res = update_mobile_user($user_data, 'UPDATE');

            if ($res['status'] == 1) {
                //更新session
                $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
                es_session::set("user_info", $user_info);

                $user = array();
                $user['token'] = $user_info['token'];
                $user['user_id'] = $user_info['id'];
                $user['nick_name'] = $user_info['nick_name'];
                $user['mobile'] = $user_info['mobile'];
                $user['head_image'] = get_spec_image($user_info['head_image']);

                $root['error'] = api_lang("Modification_succeeded");
                $root['status'] = 1;
                $root['user_id'] = $res['data'];
                $root['user_info'] = $user;
                ajax_return($root);
            } else {
                $root['error'] = $res['error'];
                ajax_return($root);
            }
        }
    }


    /**
     * 退出功能
     */
    public function loginout()
    {
        $ajax = intval($_REQUEST['ajax']);
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        $result = loginout_user();

        es_session::delete("user_info");
        $root['status'] = 1;
        $root['error'] = api_lang("Exit_succeeded");

        ajax_return($root);
    }

    /**
     * 是否开启图片验证
     */
    function is_user_verify()
    {
        $root = array('status' => 0, 'error' => '', 'verify_url' => '');
        if (app_conf('USER_VERIFY_STATUS')) {
            $root['status'] = 1;
            $root['verify_url'] = get_domain() . APP_ROOT . '/verify.php?name=login_verify';
        }
        if (OPEN_YPSMS == 1) {
            $root['status'] = 1;
            $area = array();
            $area[] = array('id' => 1, 'name' => '中国大陆');
            /*$area[]=array('id'=>2,'name'=>'港澳台');
            $area[]=array('id'=>3,'name'=>'日本');
            $area[]=array('id'=>4,'name'=>'韩国');*/
            $area[] = array('id' => 5, 'name' => '其他国家(请在号码前加上区号)');
            $root['area'] = $area;
        } else {
            $root['area'] = array();
        }
        ajax_return($root);
    }

    /**
     * 游客登录
     */
    public function visitors_login()
    {
        $root = array('status' => 0, 'error' => '');
        $m_config = load_auto_cache("m_config"); //初始化手机端配置
        //登录限制（相同IP都限制）
        if ($GLOBALS['db']->getOne("SELECT login_ip FROM " . DB_PREFIX . "user WHERE login_ip = '" . get_client_ip() . "' and is_effect !=1 and ban_type = 1")) {
            ajax_return(array("status" => 0, "error" => api_lang("IP_blocked")));
        }

        if (intval(VISITORS) && intval($m_config['open_visitors_login'])) {
            $um_reg_id = strim($_REQUEST['um_reg_id']);
            //客服端手机类型dev_type=android;dev_type=ios
            $dev_type = strim($_REQUEST['sdk_type']);
            //验证um_reg_id
            $um_reg_id_info = $this->verify_um_reg_id($um_reg_id, $dev_type);
            $is_agree = 1; //ios 无法验证推送 暂时跳过验证
            if ($um_reg_id_info['status']) {
                $is_agree = 1;
            }

            if ($um_reg_id != '' && $is_agree) {
                $root = $this->login_viditors($um_reg_id);
            } else {
                $root['error'] = api_lang("Request_parameter_error") . $um_reg_id . "--" . $is_agree;
            }
        } else {
            $root['error'] = api_lang("Function_not_open");
        }
        ajax_return($root);
    }

    /**
     * firebase 验证码登录
     */
    public function firebase_login()
    {
        $fireBaseToken = trim($_REQUEST['firebase_token']);
        $loginType = $_REQUEST['login_type'];
        $phoneNumber = $_REQUEST['mobile'];
        $areaCode = $_REQUEST['tel_code'];

        if (!in_array($loginType, ['phone', 'google'])) {
            $return['status'] = 0;
            $return['error'] = "login_type error";
            ajax_return($return);
        }

        // 如果是手机号码登录，需要检查手机号码和区号参数
        if ($loginType == 'phone') {
            if (strlen($phoneNumber) <= 0) {
                $return['status'] = 0;
                $return['error'] = api_lang('firebase_code_login_error_1');
                ajax_return($return);
            }

            if (strlen($areaCode) <= 0) {
                $return['status'] = 0;
                $return['error'] = api_lang('firebase_code_login_error_2');
                ajax_return($return);
            }
        } else if ($loginType == 'google') {
        }

        if ($fireBaseToken == '') {
            $return['status'] = 0;
            $return['error'] = "token error";
            ajax_return($return);
        }

        if ($areaCode . $phoneNumber != '8613246579813') {
            // 请求接口验证IDToken
            $response = sms_Post(
                [
                    'id_token' => $fireBaseToken,
                ],
                'http://customer2-app-127-0-0-1.nip.io/mapi/user_app/getFireBaseUid'
            );

            if (is_null(json_decode($response))) {
                echo $response;
                exit;
            }

            $authResult = json_decode($response, true);

            if ($authResult['code'] != 1) {
                $return['status'] = $authResult['code'];
                $return['error'] = $authResult['msg'];
                ajax_return($return);
            }
        } else {
            // 测试账号
            $authResult['phone_number'] = ('+' . $areaCode . $phoneNumber);
            $authResult['uid'] = md5('testing' . $authResult['phone_number']);
        }

        $authResult = json_decode($response, true);

        if ($authResult['code'] == 0) {
            $return['status'] = 0;
            $return['error'] = $authResult['msg'];
            ajax_return($return);
        }

        // 用户的手机号码+区号拼接格式，例如：+86157xxxxxxxxx
        $userMobileAreaCodePhoneNumber = '';

        if ($loginType == 'phone') {
            // 验证用户输入的手机号码和firebase的手机号码是否一样
            if ($authResult['phone_number'] != ('+' . $areaCode . $phoneNumber)) {
                $return['status'] = 0;
                $return['error'] = api_lang('firebase_code_login_error_3');
                ajax_return($return);
            }

            $userMobileAreaCodePhoneNumber = $authResult['phone_number'];
        } else if ($loginType == 'google') {
            // 用户如果使用google登录获取之前是否使用过手机号码
            if (!empty($authResult['phone_number'])) {
                $userMobileAreaCodePhoneNumber = $authResult['phone_number'];
            }
        }

        $openid = $authResult['uid'];


        $user_name = trim($_REQUEST['user_name']);
        $user_icon = trim($_REQUEST['user_icon']);

        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();

        $user_info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user WHERE firebase_uid = '" . $openid . "'");

        //登录成功
        if (!$user_info) {
            // 注册
            // 需要通过接口的方式,获得一个新用户id
            $user_id = get_max_user_id(0);
            $data['id'] = $user_id;
            $data['token'] = encryptDecrypt('password', 'bogo|' . $data['id'] . '_' . time(), 0);
            $data['is_effect'] = 1;
            $data['create_time'] = NOW_TIME;
            $data['user_pwd'] = md5(rand(100000, 999999));
            $data['login_ip'] = CLIENT_IP;
            $data['user_level'] = 1;
            $data['login_type'] = 6;
            $data['is_remind'] = 1;
            $data['synchronize'] = 0;
            $data['firebase_uid'] = $openid;
            $data['nick_name'] = $user_name;
            $data['head_image'] = $user_icon;
            $data['is_tips'] = 1;
            $data['mobile'] = $userMobileAreaCodePhoneNumber;
            //$data['tel_code'] = $areaCode;
            $data['country_code'] = get_country_ipinfo();
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data);

            $ridis_data = $user_redis->reg_data($data);
            $user_info = $data;

            //redis注册赠送
            register_gift($ridis_data);
            $user_redis->insert_db($user_id, $ridis_data);

            if (intval($_REQUEST['invite_code']) > 0) {

                //获取邀请上2级的id
                $sj_copy_code = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $_REQUEST['invite_code']);
                $sjinviteid = $sj_copy_code ? $sj_copy_code['inviteid'] : 0;
                $sjsuperior = $sj_copy_code ? $sj_copy_code['superior'] : 0;
                $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards (uid,inviteid,superior,on_superior,addtime) VALUES ('" . $user_id . "', '" . $_REQUEST['invite_code'] . "', '" . $sjinviteid . "', '" . $sjsuperior . "','" . time() . "')";
                $GLOBALS['db']->query($sql);

                invite_rewards_earnings_log($user_id);
            } elseif (!empty($_REQUEST['channel'])) {

                $parent_user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "agent where channel ='" . $_REQUEST['channel'] . "' and type=3");
                if ($parent_user && $parent_user['status'] == 1) {
                    $agent['agent_id'] = $parent_user['id'];
                    $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $agent, "UPDATE", "id=" . $user_id);
                }
            }
        } else {
            if ($user_info['is_effect'] != 1) {
                $return['status'] = 0;
                $return['error'] = api_lang("account_has_been_disabled");
                ajax_return($return);
            }
            // 如果是已经注册过账号，检查是否有关联手机号码
            if (empty($user_info['mobile']) && !empty($userMobileAreaCodePhoneNumber)) {
                Db::name('user')->where('id', '=', $user_info['id'])->update(['mobile' => $userMobileAreaCodePhoneNumber]);
            }
        }

        es_session::set("user_info", $user_info);
        //设置session过期时间一个月
        es_session::setGcMaxLifetime('2592000');
        es_cookie::set("client_ip", CLIENT_IP, 3600 * 24 * 30);
        es_cookie::set("nick_name", $user_info['nick_name'], 3600 * 24 * 30);
        es_cookie::set("user_id", $user_info['id'], 3600 * 24 * 30);
        es_cookie::set("user_pwd", md5($user_info['user_pwd'] . "_EASE_COOKIE"), 3600 * 24 * 30);
        es_cookie::set("PHPSESSID2", es_session::id(), 3600 * 24 * 30);

        if ($user_info['id'] != '') {
            //登录成功 同步信息
            accountimport($user_info);
            //修改登录时间之前，获取上一次登录时间，每日首次登录赠送积分
            $login_root = login_prompt($user_info['id']);
            $return['first_login'] = $login_root['first_login'];
            $return['new_level'] = $login_root['new_level'];
            $now_time = NOW_TIME;
            //===========add  start ===========
            $data = array();
            $data['login_ip'] = CLIENT_IP;
            $data['login_time'] = to_date($now_time);
            $data['login_type'] = 6;
            $userToken = encryptDecrypt('password', 'bogo|' . $data['id'] . '_' . time(), 0);
            $data['token'] = $userToken;
            if (!isset($user_info['country_code']) || intval($user_info['country_code']) <= 0) {
                $data['country_code'] = get_country_ipinfo();
            }
            $GLOBALS['db']->autoExecute(DB_PREFIX . 'user', $data, 'UPDATE', 'id=' . $user_info['id']);
            $user_redis->update_db($user_info['id'], $data);

            $m_config = load_auto_cache("m_config"); //初始化手机端配置
            //判断昵称是否包含敏感词汇
            if ($m_config['name_limit'] == 1) {
                //登录过滤铭感词汇
                $nick_name = $user_info['nick_name'];
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                //判断用户名是否含有铭感词汇,如果包含,替换
                $nick_name1 = str_replace("'", "''", $nick_name);
                if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                    $user_info['nick_name'] = str_replace($limit_sql, '*', $nick_name);
                }
                $name = $user_info['nick_name'];
                $id = $user_info['id'];
                //更新数据库
                $sql = "update " . DB_PREFIX . "user set nick_name = '$name',sex={$data['sex']} where id=" . $id;
                $GLOBALS['db']->query($sql);
                //更新redis
                user_deal_to_reids(array($id));
            }
            $return['status'] = 1;
            $return['error'] = api_lang("Login_successful");
            $return['data'] = $user_info['id'];
            set_xy_point($user_info['id']);
            $return['user_id'] = $user_info['id'];
            $return['nick_name'] = $user_info['nick_name'];
            $return['token'] = $userToken;

            $return['is_agree'] = intval($user_info['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
            $return['is_tips'] = $user_info['is_tips']; //是否弹过弹窗
            $return['user_info']['user_id'] = $user_info['id'];
            $return['user_info']['token'] = $userToken;
            $return['user_info']['nick_name'] = $user_info['nick_name'];
            $return['user_info']['mobile'] = $user_info['mobile'];
            $return['user_info']['head_image'] = get_spec_image($user_info['head_image']);
        } else {
            $return['status'] = 0;
            $return['error'] = api_lang("Login_failed");
            $return['data'] = $user_info['id'];
        }
        ajax_return($return);
    }

    /**
     * facebook 登录
     */
    public function fb_login()
    {
        $openid = trim($_REQUEST['openid']);
        if ($openid == '') {
            $return['status'] = 0;
            $return['error'] = "openid不存在";
            ajax_return($return);
        }
        // 是否禁封
        disableSel($openid, 4);

        $user_name = trim($_REQUEST['user_name']);
        $user_icon = trim($_REQUEST['user_icon']);
        $user_info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user WHERE fb_openid = '" . $openid . "'");
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        //登录成功
        if (!$user_info) {
            // 注册
            //需要通过接口的方式,获得一个新用户id
            $user_id = get_max_user_id(0);
            $data['id'] = $user_id;
            $data['token'] = encryptDecrypt('password', 'bogo|' . $data['id'] . '_' . time(), 0);
            $data['is_effect'] = 1;
            $data['create_time'] = NOW_TIME;
            $data['user_pwd'] = md5(rand(100000, 999999));
            $data['login_ip'] = CLIENT_IP;
            $data['user_level'] = 1;
            $data['login_type'] = 7;
            $data['is_remind'] = 1;
            $data['synchronize'] = 0;
            $data['fb_openid'] = $openid;
            $data['nick_name'] = $user_name;
            $data['head_image'] = $user_icon;
            $data['is_tips'] = 1;
            $data['country_code'] = get_country_ipinfo();
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data);

            $ridis_data = $user_redis->reg_data($data);
            $user_info = $data;

            //redis注册赠送
            register_gift($ridis_data);
            $user_redis->insert_db($user_id, $ridis_data);
            if (intval($_REQUEST['invite_code']) > 0) {
                //获取邀请上2级的id
                $sj_copy_code = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $_REQUEST['invite_code']);
                $sjinviteid = $sj_copy_code ? $sj_copy_code['inviteid'] : 0;
                $sjsuperior = $sj_copy_code ? $sj_copy_code['superior'] : 0;
                $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards (uid,inviteid,superior,on_superior,addtime) VALUES ('" . $user_id . "', '" . $_REQUEST['invite_code'] . "', '" . $sjinviteid . "', '" . $sjsuperior . "','" . time() . "')";
                $GLOBALS['db']->query($sql);
                invite_rewards_earnings_log($user_id);
            } elseif (!empty($_REQUEST['channel'])) {
                $parent_user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "agent where channel ='" . $_REQUEST['channel'] . "' and type=3");
                if ($parent_user && $parent_user['status'] == 1) {
                    $agent['agent_id'] = $parent_user['id'];
                    $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $agent, "UPDATE", "id=" . $user_id);
                }
            }
        } else {
            if ($user_info['is_effect'] != 1) {
                $return['status'] = 0;
                $return['error'] = api_lang("account_has_been_disabled");
                ajax_return($return);
            }
        }
        es_session::set("user_info", $user_info);
        //设置session过期时间一个月
        es_session::setGcMaxLifetime('2592000');
        es_cookie::set("client_ip", CLIENT_IP, 3600 * 24 * 30);
        es_cookie::set("nick_name", $user_info['nick_name'], 3600 * 24 * 30);
        es_cookie::set("user_id", $user_info['id'], 3600 * 24 * 30);
        es_cookie::set("user_pwd", md5($user_info['user_pwd'] . "_EASE_COOKIE"), 3600 * 24 * 30);
        es_cookie::set("PHPSESSID2", es_session::id(), 3600 * 24 * 30);

        if ($user_info['id'] != '') {
            //登录成功 同步信息
            accountimport($user_info);
            //修改登录时间之前，获取上一次登录时间，每日首次登录赠送积分
            $login_root = login_prompt($user_info['id']);
            $return['first_login'] = $login_root['first_login'];
            $return['new_level'] = $login_root['new_level'];
            $now_time = NOW_TIME;
            //===========add  start ===========
            $data = array();
            $data['login_ip'] = CLIENT_IP;
            $data['login_time'] = to_date($now_time);
            $data['login_type'] = 7;
            $data['device_number'] = trim($_REQUEST['device_id']);
            if (!isset($user_info['country_code']) || intval($user_info['country_code']) <= 0) {
                $data['country_code'] = get_country_ipinfo();
            }
            $GLOBALS['db']->autoExecute(DB_PREFIX . 'user', $data, 'UPDATE', 'id=' . $user_info['id']);
            $user_redis->update_db($user_info['id'], $data);

            $m_config = load_auto_cache("m_config"); //初始化手机端配置
            //判断昵称是否包含敏感词汇
            if ($m_config['name_limit'] == 1) {
                //登录过滤铭感词汇
                $nick_name = $user_info['nick_name'];
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                //判断用户名是否含有铭感词汇,如果包含,替换
                $nick_name1 = str_replace("'", "''", $nick_name);
                if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                    $user_info['nick_name'] = str_replace($limit_sql, '*', $nick_name);
                }
                $name = $user_info['nick_name'];
                $id = $user_info['id'];
                //更新数据库
                $sql = "update " . DB_PREFIX . "user set nick_name = '$name',sex={$data['sex']} where id=" . $id;
                $GLOBALS['db']->query($sql);
                //更新redis
                user_deal_to_reids(array($id));
            }
            $return['status'] = 1;
            $return['error'] = api_lang("Login_successful");
            $return['data'] = $user_info['id'];
            set_xy_point($user_info['id']);
            $return['user_id'] = $user_info['id'];
            $return['nick_name'] = $user_info['nick_name'];
            $return['token'] = $user_info['token'];
            $return['is_agree'] = intval($user_info['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
            $return['is_tips'] = $user_info['is_tips']; //是否弹过弹窗
            $return['user_info']['user_id'] = $user_info['id'];
            $return['user_info']['token'] = $user_info['token'];
            $return['user_info']['nick_name'] = $user_info['nick_name'];
            $return['user_info']['mobile'] = $user_info['mobile'];
            $return['user_info']['head_image'] = get_spec_image($user_info['head_image']);
        } else {
            $return['status'] = 0;
            $return['error'] = api_lang("Login_failed");
            $return['data'] = $user_info['id'];
        }
        ajax_return($return);
    }

    /**
     *  facebook登录---验证
     * */
    public function facebook_login()
    {
        $return = array('status' => 0, 'error' => '', 'data' => array());
        $facebook_token = trim($_REQUEST['facebook_token']);

        // 新增：token 为空直接返回
        if (empty($facebook_token)) {
            $return['status'] = 0;
            $return['error'] = "Facebook access token not empty!";
            ajax_return($return);
        }

        $m_config = load_auto_cache("m_config"); //初始化手机端配置
        $app_id = $m_config['facebook_app_id'];
        $app_secret = $m_config['facebook_app_secret'];
        $fb = new \Facebook\Facebook([
            'app_id'                => $app_id,
            'app_secret'            => $app_secret,
            'default_graph_version' => 'v2.10',
            //'default_access_token' => '{access-token}', // optional
        ]);
        try {
            // Get the \Facebook\GraphNode\GraphUser object for the current user.
            // If you provided a 'default_access_token', the '{access-token}' is optional.
            $response = $fb->get('/me', $facebook_token);
            $me = $response->getGraphUser();
            $openid = $me['id'];
            $user_name = isset($me['name']) ? $me['name'] : '';
            $user_icon = isset($payload['picture']) ? $payload['picture'] : '';
            $email = isset($me['email']) ? $me['email'] : '';
            // 是否禁封
            $return_status = disableSel($openid, 4);
            if ($return_status) {
                $return = $return_status;
                ajax_return($return);
            }
            // 是否禁封
            if ($email) {
                $return_status = disableSel($email, 3);
                if ($return_status) {
                    $return = $return_status;
                    ajax_return($return);
                }
            }

            $user_info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user WHERE fb_openid = '" . $openid . "'");
            bogo_require(APP_ROOT_PATH . "system/libs/user.php");
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            //登录成功
            if (!$user_info) {
                // 注册
                //需要通过接口的方式,获得一个新用户id
                $user_id = get_max_user_id(0);
                $data['id'] = $user_id;
                $data['token'] = encryptDecrypt('password', 'bogo|' . $data['id'] . '_' . time(), 0);
                $data['is_effect'] = 1;
                $data['create_time'] = NOW_TIME;
                $data['user_pwd'] = md5(rand(100000, 999999));
                $data['login_ip'] = CLIENT_IP;
                $data['user_level'] = 1;
                $data['login_type'] = 7;
                $data['is_remind'] = 1;
                $data['synchronize'] = 0;
                $data['fb_openid'] = $openid;
                $data['nick_name'] = $user_name;
                $data['head_image'] = $user_icon;
                $data['email'] = $email;
                $data['is_tips'] = 1;
                $data['country_code'] = get_country_ipinfo();
                $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data);

                $ridis_data = $user_redis->reg_data($data);
                $user_info = $data;

                //redis注册赠送
                register_gift($ridis_data);
                $user_redis->insert_db($user_id, $ridis_data);
                if (intval($_REQUEST['invite_code']) > 0) {
                    //获取邀请上2级的id
                    $sj_copy_code = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $_REQUEST['invite_code']);
                    $sjinviteid = $sj_copy_code ? $sj_copy_code['inviteid'] : 0;
                    $sjsuperior = $sj_copy_code ? $sj_copy_code['superior'] : 0;
                    $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards (uid,inviteid,superior,on_superior,addtime) VALUES ('" . $user_id . "', '" . $_REQUEST['invite_code'] . "', '" . $sjinviteid . "', '" . $sjsuperior . "','" . time() . "')";
                    $GLOBALS['db']->query($sql);
                    invite_rewards_earnings_log($user_id);
                } elseif (!empty($_REQUEST['channel'])) {
                    $parent_user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "agent where channel ='" . $_REQUEST['channel'] . "' and type=3");
                    if ($parent_user && $parent_user['status'] == 1) {
                        $agent['agent_id'] = $parent_user['id'];
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $agent, "UPDATE", "id=" . $user_id);
                    }
                }
            } else {
                if ($user_info['is_effect'] != 1) {
                    $return['status'] = 0;
                    $return['error'] = api_lang("account_has_been_disabled");
                    ajax_return($return);
                }
            }
            es_session::set("user_info", $user_info);
            //设置session过期时间一个月
            es_session::setGcMaxLifetime('2592000');
            es_cookie::set("client_ip", CLIENT_IP, 3600 * 24 * 30);
            es_cookie::set("nick_name", $user_info['nick_name'], 3600 * 24 * 30);
            es_cookie::set("user_id", $user_info['id'], 3600 * 24 * 30);
            es_cookie::set("user_pwd", md5($user_info['user_pwd'] . "_EASE_COOKIE"), 3600 * 24 * 30);
            es_cookie::set("PHPSESSID2", es_session::id(), 3600 * 24 * 30);

            if ($user_info['id'] != '') {
                //登录成功 同步信息
                accountimport($user_info);
                //修改登录时间之前，获取上一次登录时间，每日首次登录赠送积分
                $login_root = login_prompt($user_info['id']);
                $return['first_login'] = $login_root['first_login'];
                $return['new_level'] = $login_root['new_level'];
                $now_time = NOW_TIME;
                //===========add  start ===========
                $data = array();
                $data['login_ip'] = CLIENT_IP;
                $data['login_time'] = to_date($now_time);
                $data['login_type'] = 7;
                $data['device_number'] = trim($_REQUEST['device_id']);
                $data['token'] = encryptDecrypt('password', 'bogo|' . $user_info['id'] . '_' . time(), 0);
                if (!isset($user_info['country_code']) || intval($user_info['country_code']) <= 0) {
                    $data['country_code'] = get_country_ipinfo();
                }
                $GLOBALS['db']->autoExecute(DB_PREFIX . 'user', $data, 'UPDATE', 'id=' . $user_info['id']);
                $user_redis->update_db($user_info['id'], $data);
                $user_info['token'] = $data['token'];
                //判断昵称是否包含敏感词汇
                if ($m_config['name_limit'] == 1) {
                    //登录过滤铭感词汇
                    $nick_name = $user_info['nick_name'];
                    $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                    //判断用户名是否含有铭感词汇,如果包含,替换
                    $nick_name1 = str_replace("'", "''", $nick_name);
                    if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                        $user_info['nick_name'] = str_replace($limit_sql, '*', $nick_name);
                    }
                    $name = $user_info['nick_name'];
                    $id = $user_info['id'];
                    //更新数据库
                    $sql = "update " . DB_PREFIX . "user set nick_name = '$name',sex={$data['sex']} where id=" . $id;
                    $GLOBALS['db']->query($sql);
                    //更新redis
                    user_deal_to_reids(array($id));
                }
                $return['status'] = 1;
                $return['error'] = api_lang("Login_successful");
                $return['data'] = $user_info['id'];
                set_xy_point($user_info['id']);
                $return['user_id'] = $user_info['id'];
                $return['nick_name'] = $user_info['nick_name'];
                $return['token'] = $user_info['token'];
                $return['is_agree'] = intval($user_info['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
                $return['is_tips'] = $user_info['is_tips']; //是否弹过弹窗
                $return['user_info']['user_id'] = $user_info['id'];
                $return['user_info']['token'] = $user_info['token'];
                $return['user_info']['nick_name'] = $user_info['nick_name'];
                $return['user_info']['mobile'] = $user_info['mobile'];
                $return['user_info']['head_image'] = get_spec_image($user_info['head_image']);
            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("Login_failed");
                $return['data'] = $user_info['id'];
            }
        } catch (\Facebook\Exception\FacebookResponseException $e) {
            // When Graph returns an error
            $return['error'] = $e->getMessage();
        } catch (\Facebook\Exception\FacebookSDKException $e) {
            // When validation fails or other local issues
            $return['error'] = $e->getMessage();
        }
        ajax_return($return);
    }

    /**
     * google 登录 ---验证
     * */
    public function google_verify_login()
    {
        $return = array('status' => 0, 'error' => '', 'data' => array());
        $google_token = trim($_REQUEST['google_token']);
        $m_config = load_auto_cache("m_config"); //初始化手机端配置

        // 获取国家判断IP是否可用
        $this->checkCountryAreaAvailable();

        $CLIENT_ID = '';
        if (isios()) {
            $CLIENT_ID = $m_config['google_ios_client_id'];
        } else {
            $CLIENT_ID = $m_config['google_client_id'];
        }

        add_file_log(date('Y-m-d H:i:s') . "\n ================google_token：" . $google_token . "================\n", "login");

        $client = new Google_Client(['client_id' => $CLIENT_ID]);  // Specify the CLIENT_ID of the app that accesses the backend

        $payload = $client->verifyIdToken($google_token);

        add_file_log($payload, "login");

        if ($payload) {

            $openid = $payload['sub'];
            // 是否禁封
            $return_status = disableSel($openid, 6);
            if ($return_status) {
                $return = $return_status;
                ajax_return($return);
            }

            // 是否禁封
            if (isset($payload['email'])) {
                $return_status = disableSel($payload['email'], 3);
                if ($return_status) {
                    $return = $return_status;
                    ajax_return($return);
                }
            }

            $user_info = $GLOBALS['db']->getRow("SELECT * FROM " . DB_PREFIX . "user WHERE google_openid = '" . $openid . "'");
            bogo_require(APP_ROOT_PATH . "system/libs/user.php");
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            //登录成功
            if (!$user_info) {
                // 注册
                //需要通过接口的方式,获得一个新用户id
                $user_id = get_max_user_id(0);
                $data['id'] = $user_id;
                $data['token'] = encryptDecrypt('password', 'bogo|' . $data['id'] . '_' . time(), 0);
                $data['is_effect'] = 1;
                $data['create_time'] = NOW_TIME;
                $data['user_pwd'] = md5(rand(100000, 999999));
                $data['login_ip'] = CLIENT_IP;
                $data['user_level'] = 1;
                $data['login_type'] = 8;
                $data['is_remind'] = 1;
                $data['synchronize'] = 0;
                $data['google_openid'] = $openid;
                $data['nick_name'] = isset($payload['name']) ? $payload['name'] : '';
                $data['head_image'] = isset($payload['picture']) ? $payload['picture'] : '';
                $data['email'] = isset($payload['email']) ? $payload['email'] : '';
                $data['country_code'] =  get_country_ipinfo();

                $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data);

                $ridis_data = $user_redis->reg_data($data);
                $user_info = $data;

                //redis注册赠送
                register_gift($ridis_data);
                $user_redis->insert_db($user_id, $ridis_data);
                if (intval($_REQUEST['invite_code']) > 0) {
                    //获取邀请上2级的id
                    $sj_copy_code = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $_REQUEST['invite_code']);
                    $sjinviteid = $sj_copy_code ? $sj_copy_code['inviteid'] : 0;
                    $sjsuperior = $sj_copy_code ? $sj_copy_code['superior'] : 0;
                    $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards (uid,inviteid,superior,on_superior,addtime) VALUES ('" . $user_id . "', '" . $_REQUEST['invite_code'] . "', '" . $sjinviteid . "', '" . $sjsuperior . "','" . time() . "')";
                    $GLOBALS['db']->query($sql);
                    invite_rewards_earnings_log($user_id);
                } elseif (!empty($_REQUEST['channel'])) {
                    $parent_user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "agent where channel ='" . $_REQUEST['channel'] . "' and type=3");
                    if ($parent_user && $parent_user['status'] == 1) {
                        $agent['agent_id'] = $parent_user['id'];
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $agent, "UPDATE", "id=" . $user_id);
                    }
                }
            } else {
                if ($user_info['is_effect'] != 1) {
                    $return['status'] = 0;
                    $return['error'] = api_lang("account_has_been_disabled");
                    ajax_return($return);
                }
            }
            es_session::set("user_info", $user_info);
            //设置session过期时间一个月
            es_session::setGcMaxLifetime('2592000');
            es_cookie::set("client_ip", CLIENT_IP, 3600 * 24 * 30);
            es_cookie::set("nick_name", $user_info['nick_name'], 3600 * 24 * 30);
            es_cookie::set("user_id", $user_info['id'], 3600 * 24 * 30);
            es_cookie::set("user_pwd", md5($user_info['user_pwd'] . "_EASE_COOKIE"), 3600 * 24 * 30);
            es_cookie::set("PHPSESSID2", es_session::id(), 3600 * 24 * 30);

            if ($user_info['id'] != '') {
                //登录成功 同步信息
                accountimport($user_info);
                //修改登录时间之前，获取上一次登录时间，每日首次登录赠送积分
                $login_root = login_prompt($user_info['id']);
                $return['first_login'] = $login_root['first_login'];
                $return['new_level'] = $login_root['new_level'];
                $now_time = NOW_TIME;
                //===========add  start ===========
                $data = array();
                $data['login_ip'] = CLIENT_IP;
                $data['login_time'] = to_date($now_time);
                $data['login_type'] = 8;
                $data['device_number'] = trim($_REQUEST['device_id']);
                $data['token'] = encryptDecrypt('password', 'bogo|' . $user_info['id'] . '_' . time(), 0);
                if (!isset($user_info['country_code']) || intval($user_info['country_code']) <= 0) {
                    $data['country_code'] = get_country_ipinfo();
                }

                $GLOBALS['db']->autoExecute(DB_PREFIX . 'user', $data, 'UPDATE', 'id=' . $user_info['id']);
                $user_redis->update_db($user_info['id'], $data);
                $user_info['token'] = $data['token'];
                $m_config = load_auto_cache("m_config"); //初始化手机端配置
                //判断昵称是否包含敏感词汇
                if ($m_config['name_limit'] == 1) {
                    //登录过滤铭感词汇
                    $nick_name = $user_info['nick_name'];
                    $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                    //判断用户名是否含有铭感词汇,如果包含,替换
                    $nick_name1 = str_replace("'", "''", $nick_name);
                    if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name1' like concat('%',name,'%')")) {
                        $user_info['nick_name'] = str_replace($limit_sql, '*', $nick_name);
                    }
                    $name = $user_info['nick_name'];
                    $id = $user_info['id'];
                    //更新数据库
                    $sql = "update " . DB_PREFIX . "user set nick_name = '$name',sex={$data['sex']} where id=" . $id;
                    $GLOBALS['db']->query($sql);
                    //更新redis
                    user_deal_to_reids(array($id));
                }
                $return['status'] = 1;
                $return['error'] = api_lang("Login_successful");
                $return['data'] = $user_info['id'];
                set_xy_point($user_info['id']);
                $return['user_id'] = $user_info['id'];
                $return['nick_name'] = $user_info['nick_name'];
                $return['token'] = $user_info['token'];
                $return['is_agree'] = intval($user_info['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
                $return['user_info']['user_id'] = $user_info['id'];
                $return['user_info']['token'] = $user_info['token'];
                $return['user_info']['nick_name'] = $user_info['nick_name'];
                $return['user_info']['mobile'] = $user_info['mobile'];
                $return['user_info']['head_image'] = get_spec_image($user_info['head_image']);
            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("Login_failed");
                $return['data'] = $user_info['id'];
            }
        } else {
            // Invalid ID token
            $return['status'] = 0;
            $return['error'] = api_lang("validation_error");
            $return['data'] = 0;
            ajax_return($return);
        }
        ajax_return($return);
    }

    /**
     * 游客登录-登录处理
     * @param $um_reg_id
     * @return array|mixed
     */
    private function login_viditors($um_reg_id)
    {
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        $result = array('status' => 0, 'info' => '', 'is_lack' => 0);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $sql = "select * from " . DB_PREFIX . "user where  apns_code = '" . $um_reg_id . "' and login_type = 4 order by id desc";
        $user = $GLOBALS['db']->getRow($sql);

        $user_id = intval($user['id']);
        //如果不存在，注册账号
        if (!$user) {
            $result = $this->reg_visitors($um_reg_id);
        } else {

            $result['user'] = $user;
            //判断账号有效
            if ($user['is_effect'] != 1) {
                $result['info'] = api_lang("account_has_been_disabled");
            } else {
                $result['status'] = 1;
                //更新等级
                user_leverl_syn($user);
                $login_time = get_gmtime();
                $user['login_time'] = $login_time;
                //设置cookie
                es_cookie::set("client_ip", CLIENT_IP, 3600 * 24 * 30);
                es_cookie::set("nick_name", $user['nick_name'], 3600 * 24 * 30);
                es_cookie::set("user_id", $user['id'], 3600 * 24 * 30);
                es_cookie::set("user_pwd", md5($user['user_pwd'] . "_EASE_COOKIE"), 3600 * 24 * 30);
                es_cookie::set("PHPSESSID2", es_session::id(), 3600 * 24 * 30);

                //设置session
                es_session::set("user_info", $user);
                $GLOBALS['user_info'] = $user;
                //修改登录时间之前，获取上一次登录时间，每日首次登录赠送积分
                $login_root = login_prompt($user['id']);
                $result['first_login'] = $login_root['first_login'];
                $result['new_level'] = $login_root['new_level'];

                $GLOBALS['db']->query("update " . DB_PREFIX . "user set login_ip = '" . get_client_ip() . "',login_time= '" . to_date($login_time) . "' where id =" . $user['id']);
                //更新redis
                $user_redis->update_db($user['id'], array("login_time" => to_date($login_time), "login_ip" => get_client_ip()));

                //登录成功 同步信息
                $user_im = array();
                $user_im['id'] = $user['id'];
                $user_im['nick_name'] = $user['nick_name'];
                $user_im['head_image'] = $user['head_image'];
                if ($user_im['nick_name'] == '') {
                    $user_im['nick_name'] = api_lang("tourist") . $user['id'];
                }
                if ($user_im['head_image'] == '') {
                    $m_config = load_auto_cache("m_config"); //初始化手机端配置
                    $system_head_image = $m_config['default_avatar'];
                    if ($system_head_image == '') {
                        $system_head_image = './public/attachment/test/noavatar_10.JPG';
                    }
                    $user_im['head_image'] = $system_head_image;
                }
                accountimport($user_im);
            }

            if ($user['nick_name'] == '' || $user['head_image'] == '') {
                $result['is_lack'] = 1;
            }
            set_xy_point($user['id']);
            $result['user_info']['user_id'] = $user['id'];
            $result['user_info']['token'] = $user['token'];
            $result['user_info']['nick_name'] = $user['nick_name'] ? $user['nick_name'] : '';
            $result['user_info']['mobile'] = $user['mobile'] ? $user['mobile'] : '';
            $result['user_info']['head_image'] = get_spec_image($user['head_image']);
        }

        return $result;
    }

    /**
     * 游客登录-注册处理
     * @param $um_reg_id
     * @return mixed
     */
    private function reg_visitors($um_reg_id)
    {
        $image = array(
            './public/attachment/test/noavatar_0.JPG',
            './public/attachment/test/noavatar_1.JPG',
            './public/attachment/test/noavatar_2.JPG',
            './public/attachment/test/noavatar_3.JPG',
            './public/attachment/test/noavatar_4.JPG',
            './public/attachment/test/noavatar_5.JPG',
            './public/attachment/test/noavatar_6.JPG',
            './public/attachment/test/noavatar_7.JPG',
            './public/attachment/test/noavatar_8.JPG',
        );

        $random = mt_rand(0, 8);
        $head_image = $image[$random];
        $nick_name = api_lang("tourist");

        $data = array(
            'head_image' => $head_image,
            'nick_name'  => $nick_name,
            'sex'        => 0,
            'apns_code'  => $um_reg_id,
            'login_type' => 4,
        );

        if ($GLOBALS['distribution_cfg']['OSS_TYPE'] && $GLOBALS['distribution_cfg']['OSS_TYPE'] != 'NONE') {
            syn_to_remote_image_server($data['head_image'], false);
        }
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");


        $return = save_user($data);
        $user_data = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $return['data']);

        if ($user_data['id'] != '') {
            //更新昵称
            $user_nick_name = $nick_name = $user_data['nick_name'] = $user_data['nick_name'] . ":" . $user_data['id'];
            $GLOBALS['db']->query("update " . DB_PREFIX . "user set login_ip = '" . get_client_ip() . "', nick_name = '" . $user_nick_name . "' where id =" . $user_data['id']);

            $root['status'] = 1;
            $root['error'] = $nick_name . api_lang("Login_successfully");
            $root['user'] = $user_data;
            es_session::set("user_info", $user_data);
            $GLOBALS['user_info'] = $user_data;
            es_cookie::set("client_ip", CLIENT_IP, 3600 * 24 * 30);
            es_cookie::set("nick_name", $user_data['nick_name'], 3600 * 24 * 30);
            es_cookie::set("user_id", $user_data['id'], 3600 * 24 * 30);
            es_cookie::set("user_pwd", md5($user_data['user_pwd'] . "_EASE_COOKIE"), 3600 * 24 * 30);
            es_cookie::set("is_agree", $user_data['is_agree'], 3600 * 24 * 30);
            es_cookie::set("PHPSESSID2", es_session::id(), 3600 * 24 * 30);

            $root['user_info']['user_id'] = $root['user_id'] = $user_data['id'];
            $root['user_info']['nick_name'] = $root['nick_name'] = $user_data['nick_name'];
            $root['user_info']['token'] = $root['token'] = $user_data['token'];
            $root['is_agree'] = intval($user_data['is_agree']); //是否同意直播协议 0 表示不同意 1表示同意
            $root['user_info']['head_image'] = $root['head_image'] = get_abs_img_root($user_data['head_image']); //是否同意直播协议 0 表示不同意 1表示同意

            if ($user_data['synchronize'] == 0) {
                //同步IM
                accountimport($user_data);
            }
        } else {
            $root['error'] = $nick_name . api_lang("Login_successfully");
        }
        return $root;
    }

    /**
     * 游客登录-推送友盟信息
     * @param $um_reg_id
     * @param $dev_type
     * @return array
     */
    private function verify_um_reg_id($um_reg_id, $dev_type)
    {
        $result = array('status' => 0, 'error' => '',);
        bogo_require(APP_ROOT_PATH . 'system/schedule/android_list_schedule.php');
        bogo_require(APP_ROOT_PATH . 'system/schedule/android_unicast_schedule.php');
        bogo_require(APP_ROOT_PATH . 'system/schedule/ios_list_schedule.php');
        bogo_require(APP_ROOT_PATH . 'system/schedule/ios_unicast_schedule.php');
        if (strtolower($dev_type) == 'ios') {
            $apns_ios_code_list[0] = $um_reg_id;
        } else {
            $apns_app_code_list[0] = $um_reg_id;
        }
        $content = api_lang("Tourist_account_registration");
        //安卓推送信息
        if (count($apns_app_code_list) > 0) {
            $AndroidList = new android_unicast_schedule();
            $android_dest = implode(",", $apns_app_code_list);
            $data = array(
                'dest'    => $android_dest,
                'content' => $content,
                'type'    => 0,
            );

            $return = $AndroidList->exec($data);
        }
        //ios 推送信息
        if (count($apns_ios_code_list) > 0) {
            $IosList = new ios_list_schedule();
            $ios_dest = implode(",", $apns_ios_code_list);
            $ios_data = array(
                'dest'    => $ios_dest,
                'content' => $content,
                'type'    => 0,
            );

            $return = $IosList->exec($ios_data);
        }
        if ($return['res']['ret'] == 'SUCCESS') {
            $result['status'] = 1;
        } else {
            log_err_file(array(__FILE__, __LINE__, __METHOD__, $return));
        }
        return $result;
    }

    //提交绑定经纪人用户
    public function invitation()
    {
        $root = array('status' => 0, 'error' => '');
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $user_id = intval($GLOBALS['user_info']['id']); //用户ID
        $parent_id = strtolower(trim($_REQUEST['invitation_id'])); // 邀请码
        if ($parent_id == $user_id) {
            $root['error'] = api_lang("You_cannot_set_yourself");
            ajax_return($root);
        }
        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id='" . $parent_id . "'");
        if (!$user) {
            $root['error'] = api_lang("Invitation_code_does_not_exist");
            ajax_return($root);
        }
        $sj_copy_code = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $user_id);

        if ($sj_copy_code) {
            $root['error'] = api_lang('Invitation_code_bound');
            ajax_return($root);
        }
        $invite_rewards = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $user['id']);
        $sjinviteid = $invite_rewards ? $invite_rewards['inviteid'] : '';
        $sjsuperior = $invite_rewards ? $invite_rewards['superior'] : '';
        $sql = "INSERT INTO " . DB_PREFIX . "invite_rewards (uid,inviteid,superior,on_superior,addtime) VALUES ('" . $user_id . "', '" . $user['id'] . "', '" . $sjinviteid . "', '" . $sjsuperior . "','" . time() . "')";
        $GLOBALS['db']->query($sql);
        bogo_require(APP_ROOT_PATH . "system/libs/user.php");
        invite_rewards_earnings_log($user_id);
        $root['status'] = 1;
        $root['error'] = api_lang('Binding_succeeded');
        ajax_return($root);
    }

    //查询用户是否有绑定过邀请码
    public function is_invitation()
    {
        $root = array('status' => 1, 'error' => '');
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0; //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']); //用户ID
            $sj_copy_code = $GLOBALS['db']->getRow("select inviteid,superior from " . DB_PREFIX . "invite_rewards where uid =" . $user_id);

            if ($sj_copy_code) {
                $root['state'] = 1;
            } else {
                $root['state'] = 0;
            }
        }

        ajax_return($root);
    }
}
