<?php

/**
 * 我的小店
 */
class myshopModule extends baseModule
{
    /**
     * 删除商品
     * */
    public function del_shop_product()
    {

        $root = array('status' => 1, 'error' => '');
        $user_info = get_user_token_info(strim($_REQUEST['token']));//用户ID

        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $id = $_REQUEST['id'];

        $sql = "delete from " . DB_PREFIX . "shop_product where id=" . $id . " and user_id = " . $user_info['id'];
        $GLOBALS['db']->query($sql);

        api_ajax_return($root);
    }

    /**
     * 获取商品列表
     * */
    public function get_shop_product_list()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $user_info = get_user_token_info(strim($_REQUEST['token']));

        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }

        //检查是否已经开通小店
        $sql = "select * from " . DB_PREFIX . "shop_product where user_id=" . $user_info['id'];
        $root['list'] = $GLOBALS['db']->getAll($sql);
        $list = $GLOBALS['db']->getAll($sql);
        if ($list) {
            $root['list'] = $list;
        }
        api_ajax_return($root);
    }


    /**
     * 获取商品列表
     * */
    public function get_other_shop_product_list()
    {

        $root = array('status' => 1, 'error' => '', 'list' => []);

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        } else {

            $toUserId = $_REQUEST['to_user_id'];
            //查询商品列表
            $sql = "select * from " . DB_PREFIX . "shop_product where user_id=" . $toUserId . " and status=1 order by create_time desc";
            $list = $GLOBALS['db']->getAll($sql);
            if ($list) {
                $root['list'] = $list;
            }
        }

        api_ajax_return($root);
    }


    /**
     * 添加商品
     * */
    public function add_shop_product()
    {
        //代表允许任何网址请求
        //header('Access-Control-Allow-Origin:*');
        //允许请求的类型
        //header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');

        $root = array('status' => 1, 'error' => '');
        $user_info = get_user_token_info(strim($_REQUEST['token']));//用户ID

        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }

        //检查是否已经开通小店
        $sql = "select * from " . DB_PREFIX . "shop where status = 1 and user_id=" . $user_info['id'];
        $shop_record = $GLOBALS['db']->getRow($sql);

        if (!$shop_record) {
            $root['error'] = api_lang("No_shop_opened");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $shop_name = $_REQUEST['shop_name'];

        if (empty($shop_name)) {
            $root['error'] = api_lang("Fill_in_commodity_name");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $shop_price = $_REQUEST['shop_price'];

        if (empty($shop_price)) {
            $root['error'] = api_lang("Fill_in_commodity_price");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $shop_url = $_REQUEST['shop_url'];

        if (empty($shop_url)) {
            $root['error'] = api_lang("Fill_commodity_chain_address");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $shop_logo_url = $_REQUEST['shop_logo_url'];

        if (empty($shop_logo_url)) {
            $root['error'] = api_lang("Upload_product_logo");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        //插入商品记录
        $log = [
            'user_id' => $user_info['id'],
            'shop_name' => $shop_name,
            'shop_price' => $shop_price,
            'shop_url' => base64_decode($shop_url),
            'shop_logo' => $shop_logo_url,
            'create_time' => NOW_TIME,
        ];
        //print_r($log);exit;
        $GLOBALS['db']->autoExecute(DB_PREFIX . "shop_product", $log, "INSERT");

        api_ajax_return($root);
    }


    /**
     * 获取创建页面的配置信息
     * */
    public function get_create_info()
    {
        $root = array('status' => 1, 'error' => '');
        $user_info = get_user_token_info(strim($_REQUEST['token']));//用户ID
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $m_config = load_auto_cache("m_config");

        $root['accessKeyId'] = $m_config['sts_access_key_id'];
        $root['accessKeySecret'] = $m_config['sts_access_key_secret'];
        $root['region'] = 'oss-cn-beijing';
        $root['bucket'] = $GLOBALS['distribution_cfg']['OSS_BUCKET_NAME'];
        $root['endpoint'] = $GLOBALS['distribution_cfg']['OSS_ENDPOINT'];


        api_ajax_return($root);
    }

    //我的小店
    public function my_shop_index()
    {
        $root = array('status' => 1, 'error' => '');
        //用户ID
        $user_info = get_user_token_info(strim($_REQUEST['token']));
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        }
        $m_config = load_auto_cache("m_config");

        $root['is_authentication'] = $user_info['is_authentication'];
        $root['open_my_shop_margin_num'] = $m_config['open_my_shop_margin_num'];
        $root['satisfy'] = 0;
        $root['margin_status'] = 0;

        //查询保证金记录
        $sql = "select * from " . DB_PREFIX . "shop_margin_log where user_id=" . $user_info['id'];
        $pay_record = $GLOBALS['db']->getRow($sql);

        if ($pay_record) {
            $root['margin_status'] = 1;
        }

        //是否认证&缴纳了保证金满足开通条件
        if ($pay_record && $user_info['is_authentication'] == 2) {
            $root['satisfy'] = 1;
        }
        $root['diamonds_name'] = $m_config['diamonds_name'];
        api_ajax_return($root);

    }


    /**
     * 缴纳保证金
     * @param token 用户的鉴权token
     * */
    public function pay_gold()
    {
        $root = array('status' => 1, 'error' => '');
        $user_id = get_user_token_id(strim($_REQUEST['token']));
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $config = load_auto_cache("m_config");

        //查询保证金记录
        $sql = "select * from " . DB_PREFIX . "shop_margin_log where user_id=" . $user_id;
        $pay_record = $GLOBALS['db']->getRow($sql);

        if ($pay_record) {
            $root['status'] = 0;
            $root['error'] = api_lang("I_have_paid_the_deposit");
            api_ajax_return($root);
        }

        //减少用户钻石
        $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $config['open_my_shop_margin_num'] . ", use_diamonds = use_diamonds + " . $config['open_my_shop_margin_num'] . ", score = score + " . $config['open_my_shop_margin_num'] . " where id = '" . $user_id . "' and diamonds >= " . $config['open_my_shop_margin_num'];

        $GLOBALS['db']->query($sql);

        if (!$GLOBALS['db']->affected_rows()) {
            $root['status'] = 0;
            $root['error'] = api_lang("Insufficient_amount_please_recharge");
        }
        //插入缴纳记录
        $log = [
            'user_id' => $user_id,
            'num' => $config['open_my_shop_margin_num'],
            'create_time' => NOW_TIME,
        ];

        $GLOBALS['db']->autoExecute(DB_PREFIX . "shop_margin_log", $log, "INSERT");

        api_ajax_return($root);

    }

    /**
     * 点击申请开通小店
     * @param token 用户的鉴权token
     * */
    public function request_open_shop()
    {
//        if (strtoupper($_SERVER['REQUEST_METHOD']) == 'OPTIONS') {
//            echo 'options请求，已忽略。';
//            exit;
//        }

        //代表允许任何网址请求
        //header('Access-Control-Allow-Origin:*');
        //允许请求的类型
        //header('Access-Control-Allow-Methods:POST,GET,OPTIONS,DELETE');

        $root = array('status' => 1, 'error' => '');
        $user_info = get_user_token_info(strim($_REQUEST['token']));//用户ID

        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        //print_r($_REQUEST);exit;
        //检查是否认证
        if ($user_info['is_authentication'] != 2) {
            $root['error'] = api_lang("Unable_to_open_small_shop");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }

        //检查是否缴纳保证金
        $sql = "select * from " . DB_PREFIX . "shop_margin_log where user_id=" . $user_info['id'];
        $pay_record = $GLOBALS['db']->getRow($sql);

        if (!$pay_record) {
            $root['error'] = api_lang("No_deposit_paid");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $shop_name = $_REQUEST['shop_name'];

        if (empty($shop_name)) {
            $root['error'] = api_lang("Fill_in_the_name_of_the_shop");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $shop_logo_url = $_REQUEST['shop_logo_url'];

        if (empty($shop_logo_url)) {
            $root['error'] = api_lang("upload_the_store_logo");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        //检查是否已经开通小店
        $sql = "select * from " . DB_PREFIX . "shop where user_id=" . $user_info['id'];
        $shop_record = $GLOBALS['db']->getRow($sql);

        if ($shop_record) {
            $root['error'] = api_lang("We_ve_opened_small_shop");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        //插入小店记录
        $log = [
            'user_id' => $user_info['id'],
            'shop_name' => $shop_name,
            'shop_logo_url' => $shop_logo_url,
            'create_time' => NOW_TIME,
        ];

        $GLOBALS['db']->autoExecute(DB_PREFIX . "shop", $log, "INSERT");

        api_ajax_return($root);
    }

}