<?php

/**
 * PayPalweb支付
 * */
class paypalwebModule extends baseModule
{

    /**
     * 展示支付页面
     */
    public function pay_index(){

        $root = array();
        $root['status'] = 1;
        //    $client_id = "AaqmBSXwKRGEDmJ0yIUnpPh216Zpafo1ZzTVWcYpVf63pM3vUTD1uApvolljiT4RRxhp8gmiVfm9SNLk";
        $order_id = intval($_REQUEST['notice_id']);//订单号id

        $user_id = intval($_REQUEST['user_id']);
        $token = trim($_REQUEST['token']);//支付id

        $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where token = '" . $token . "'");
        if(!$user_info){
            $root['status'] = 0;
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }

        $sql = "select id,name,class_name,logo,config from " . DB_PREFIX . "payment where class_name ='PayPalWeb'";
        $pay = $GLOBALS['db']->getRow($sql, true, true);

        $pay_config = unserialize($pay['config']);
        $client_id = $pay_config['publicKey'];

        // 获取订单价格
        $orders = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where id = '" . $order_id . "'");
        //     var_dump($orders);exit;
        $root['Loading_desperately'] = api_lang("Loading_desperately");
        $root['got_it'] = api_lang("got_it");
        $root['token'] = $token;
        $root['order'] = $orders;
        $root['client_id'] = $client_id;
        api_ajax_return($root);
    }
    /**
     * 支付成功第三方回调
     */
    public function Callback(){
        //    if(!$this->request->isPost()) die();
        $notify_str = '失败';
        //记录支付回调信息
        if(!empty($_POST)){
            $notify_str = "支付回调信息:\r\n";
            foreach ($_POST as $key => $value) {
                $notify_str.=$key."=".$value.";\r\n";
            }
        }
        // 记录日志
        $this->log_results($notify_str);


        //ipn验证
        $data = $_POST;
        $data['cmd'] = '_notify-validate';

        $url = IS_PAYPALWEB == 1 ?  "https://www.sandbox.paypal.com/cgi-bin/webscr" : "https://www.paypal.com/cgi-bin/webscr";  // 沙盒

        $res = $this->https_request($url,$data);
        //记录支付ipn验证回调信息
        $this->log_results($res);

        if (!empty($res)) {
            if (strcmp($res, "VERIFIED") == 0) {

                if ($_POST['payment_status'] == 'Completed' || $_POST['payment_status'] == 'Pending') {

                    $this->upd_status($_POST['txn_id']);
                    //付款完成，这里修改订单状态
                    return 'success';
                }
            } elseif (strcmp($res, "INVALID") == 0) {
                //未通过认证，有可能是编码错误或非法的 POST 信息
                return 'fail';
            }
        } else {
            //未通过认证，有可能是编码错误或非法的 POST 信息

            return 'fail';

        }
        return 'fail';
    }
    /**
     * 接口支付成功改变状态
     */
    public function payment_successful(){
        $order_id = $_REQUEST['orderid'];//支付id

        $token = $_REQUEST['token'];//支付id

        $this->log_results('===================');
        $this->log_results($order_id);
        $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where token = '" . $token . "'");

        if(!$user_info){
            $result['status'] = 0;
            $result['error'] = api_lang("user_not_logged_in");
            ajax_return($result);
        }

        // 查询订单信息
        $result = $this->upd_status($order_id);

        ajax_return($result);
    }
    /**
     * 支付成功改变状态
     * 第三方订单号 $outer_notice_sn
     */
    public function upd_status($outer_notice_sn){
        $result=array("error" => api_lang("Payment_failed_please_pay_again"), "status" => 0);
        $tokens = $this->access_token('');
        $token = $tokens['access_token'];
        //查询是否有订单
        $order = $this->get_curlOrder($outer_notice_sn, $token,'');
        // 记录日志
        $this->log_results(json_encode($order));
        if($order['status'] == 'COMPLETED'){
            // 服务器订单id
            $order_id = $order['purchase_units'][0]['reference_id'];
            if($order_id){
                // 支付成功改变状态
                $payment_notice = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where notice_sn = '" . $order_id . "'");
                if($payment_notice && $payment_notice['is_paid'] == 1){
                    return array("error" => api_lang("Payment_successful_APP_view"), "status" => 1);
                }else{
                    //付款完成，这里修改订单状态
                    require_once APP_ROOT_PATH . "system/libs/cart.php";
                    $order_res = payment_paid($order_id,$outer_notice_sn);
                    if($order_res && $order_res['status'] == 1){
                        $order_res['error'] =api_lang("Payment_successful_APP_view");
                    }
                    return $order_res;
                }
            }
        }

        return $result;
    }
    /**
     * 获取token
     */
    public function access_token($type = '') {

        $sql = "select id,name,class_name,logo,config from " . DB_PREFIX . "payment where class_name ='PayPalWeb'";
        $pay = $GLOBALS['db']->getRow($sql, true, true);

        $pay_config = unserialize($pay['config']);
        $clientId = $pay_config['publicKey'];
        $secret = $pay_config['privateKey'];

        // 1生产环境 2沙箱环境
        $url = IS_PAYPALWEB == 1 ? "https://api-m.sandbox.paypal.com/v1/oauth2/token/" :  "https://api-m.paypal.com/v1/oauth2/token/";

        $ch = curl_init ();
        curl_setopt ( $ch, CURLOPT_URL, $url );
        curl_setopt ( $ch, CURLOPT_HEADER, false );
        curl_setopt ( $ch, CURLOPT_SSL_VERIFYPEER, false );
        curl_setopt ( $ch, CURLOPT_POST, true );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt ( $ch, CURLOPT_USERPWD, $clientId . ":" . $secret );
        curl_setopt ( $ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials" );
        $result = curl_exec ( $ch );
        curl_close ( $ch );
        if (empty ( $result )) {
            return false;
        } else {
            return json_decode ( $result, true );
        }
    }
    // 获取curl订单信息 根据token查询订单方法
    public function get_curlOrder($orderid, $token, $type = '') {
        if (empty ( $orderid ) || empty ( $token )) {
            return false;
        }

        // 1生产环境 2沙箱环境
        $URL = IS_PAYPALWEB == 1 ?  "https://api-m.sandbox.paypal.com/v2/checkout/orders/" : "https://api-m.paypal.com/v2/checkout/orders/";
        $URL .=$orderid;

        $curl = curl_init ();
        curl_setopt ( $curl, CURLOPT_SSL_VERIFYHOST, '0' );
        curl_setopt ( $curl, CURLOPT_SSL_VERIFYPEER, '0' );
        curl_setopt_array ( $curl, array (
            CURLOPT_URL => $URL,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array (
                "Authorization: Bearer {$token}",
                "Content-Type:application/json"
            )
        ));

        $response = curl_exec ( $curl );
        curl_close ( $curl );
        return json_decode ( $response, true );
    }
    /**
     * 发送post请求
     * @author ganyuanjiang  <3164145970@qq.com>
     * @createtime 2017-07-26 14:06:04
     * @param string $url 请求地址
     * @param array $post_data post键值对数据
     * @return string
     */
    function https_request($url,$data=null){
        header("Content-type: text/html; charset=utf-8");
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; MSIE 5.01; Windows NT 5.0)');
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($ch, CURLOPT_AUTOREFERER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $tmpInfo = curl_exec($ch);
        if (curl_errno($ch)) {
            return curl_error($ch);
        }

        curl_close($ch);
        return $tmpInfo;

    }
    /**
     * 记录自定义日志
     * @author gyj  <375023402@qq.com>
     * @createtime 2018-08-24 14:12:01
     * @param $msg 错误信息
     * @param $type 写入类型 wechat aliyun
     * @return [type] [description]
     */
    function log_results($msg='',$type='paypalweb')
    {
        $dir = date('Ymd').".log";
        $file = APP_ROOT_PATH . "public/" . $type . "/".$dir;

        $fp = fopen($file, "a");
        flock($fp, LOCK_EX);
        fwrite($fp, "执行日期：" . strftime("%Y-%m-%d-%H：%M：%S", time()) . "\n" . $msg . "\n\n");
        flock($fp, LOCK_UN);
        fclose($fp);
    }


    /**
     *下订单
     * @param $user_id
     * @param $token
     * @param $rule  支付项目信息
     * @param $pay_id 支付id
     */
    public function pay($user_id,$rule,$pay_id){

        $money = $rule['money'];
        $diamonds = $rule['diamonds'];

        $payment_notice['create_time'] = NOW_TIME;
        $payment_notice['user_id'] = $user_id;
        $payment_notice['payment_id'] = $pay_id;
        $payment_notice['money'] = $money;
        $payment_notice['diamonds'] = $diamonds;//充值时,获得的钻石数量

        $payment_notice['recharge_id'] = $rule['id'];
        $payment_notice['recharge_name'] = $rule['name'];
        $payment_notice['product_id'] = $rule['product_id'];

        do {
            $payment_notice['notice_sn'] = to_date(NOW_TIME, "YmdHis") . rand(100, 999);
            $GLOBALS['db']->autoExecute(DB_PREFIX . "payment_notice", $payment_notice, "INSERT", "", "SILENT");
            $notice_id = $GLOBALS['db']->insert_id();
        } while ($notice_id == 0);
        $payment_notice['notice_id'] = $notice_id;
        return $payment_notice;
    }

}