<?php

class prop_mallModule extends baseModule
{

    /**
    * 获取道具商店推荐(支付最多的)
     * */
    public function index()
    {
        $root = ['status' => 1, 'error' => ''];
        $sql = "select n.id,n.title_img as img,n.img as svga,n.name,r.money as coin,r.day from " . DB_PREFIX . "noble n JOIN " . DB_PREFIX . "noble_recharge r on r.nobleid = n.id where n.status=1 and n.type=1 and r.status=1  order by n.quantity desc,n.sort asc,r.sort asc limit 0,9";
        $car = $GLOBALS['db']->getALL($sql);
        $sql = "select id,name,img,img as svga,coin,day from " . DB_PREFIX . "avatar_frame where status=1 order by quantity desc,sort asc limit 0,9";
        $avatar_frame = $GLOBALS['db']->getALL($sql);
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['data'] = array(
            'car' =>$car,
            'avatar_frame' =>$avatar_frame,
            'diamonds_name' =>$m_config['diamonds_name'],
            'head_image'=>$m_config['default_avatar'],
            'consumer_price_Icon'=> $m_config['consumer_price_Icon']
        );
        api_ajax_return($root);
    }
    /**
    * 查询是否续费还是购买
     * */
    public function select_coin()
    {
        $id = intval($_REQUEST['id']);
        $type = intval($_REQUEST['type']);
        $root['status'] = 1;
        $user_id = get_user_token_id(strim($_REQUEST['token']));//用户ID
        if (!$user_id) {
            $root['status'] = 0;
            $root['error'] = api_lang("please_log_in_again");
            ajax_return($root);
        }
        if (!$id) {
            $root['status'] = 0;
            $root['error'] = api_lang("please_log_in_again");
            ajax_return($root);
        }
        if ($type == 1) {
            // 查询座驾
            $sql = "select * from " . DB_PREFIX . "noble where status=1 and id=$id order by sort desc";
            $noble = $GLOBALS['db']->getRow($sql);
            if ($noble['type'] == 2) {    //守护座驾
                //获取是否是守护者
                $sql = "select * from " . DB_PREFIX . "guardian_user_old g  where status=1 and g.uid=" . $user_id . " and g.endtime >= " . time();
                $guardian_user = $GLOBALS['db']->getRow($sql);
                if (!$guardian_user) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("no_right_to_buy_guard_car");
                    ajax_return($root);
                }
            }
            $sql = "select id,nobleid from " . DB_PREFIX . "noble_recharge where status=1  and nobleid=" . $id . " order by sort asc";
            $noble_recharge = $GLOBALS['db']->getRow($sql);
            $sql = "select carid,endtime from " . DB_PREFIX . "noble_car where uid=$user_id and carid=$id and endtime > " . time();
            $car = $GLOBALS['db']->getRow($sql);
            if (!$noble_recharge) {
                $root['status'] = 0;
                $root['error'] = api_lang("no_data_available");
                ajax_return($root);
            }
            $time = '';
            $type = 0;
            if ($car) {
                $type = 1;
                $time = date("Y/m/d", $car['endtime']);
            }
            $noble_recharge['time'] = $time;
            $noble_recharge['is_renew'] = $type;
            $root['list'] = $noble_recharge;
        }else{
            // 查询头像框
            $sql = "select id,name,img,avatar_id,end_time from " . DB_PREFIX . "avatar_frame_log where status=1  and avatar_id=" . $id . " and uid=".$user_id." order by id desc";
            $avatar_frame_log = $GLOBALS['db']->getRow($sql);
            $time = '';
            $type = 0;
            if ($avatar_frame_log) {
                $type = 1;
                $time = date("Y/m/d", $avatar_frame_log['end_time']);
            }
            $avatar_frame_log['time'] = $time;
            $avatar_frame_log['is_renew'] = $type;
            $root['list'] = $avatar_frame_log;
        }
        ajax_return($root);
    }
    /**
    * 购买
     * */
    public function pay()
    {
        $root = ['status' => 1, 'error' => ''];
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,noble_car_id,diamonds from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $id = intval($_REQUEST['id']);
            $shop_id = intval($_REQUEST['shop_id']);
            $shop_type = intval($_REQUEST['shop_type']);
            if($shop_type == 1){
                // 购买座驾
                $root = $this->pay_car($id,$user_info,$shop_id);
            }else{
                // 购买头像框
                $root = $this->pay_avatar_frame($user_info,$shop_id);
            }
        }
        ajax_return($root);
    }

    /**
    * 购买头像框
     * */
    public function pay_avatar_frame($user_info,$id){
        $root = array('status'=>0,'error'=>'');

        $user_id = $user_info['id'];
        $avatar_frame = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "avatar_frame where  id=". $id." and status = 1");
        if (!$avatar_frame) {
            $root['error'] = api_lang("data_error");
            return $root;
        }
        if ($avatar_frame['coin'] > $user_info['diamonds']) {
            $root['error'] = api_lang('insufficient_balance');
            return $root;
        }
        $pInTrans = $GLOBALS['db']->StartTrans();
        try {
            $avatar_frame_log = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "avatar_frame_log where uid=". $user_id." and avatar_id=". $id." and status = 1");
            $time = NOW_TIME;
            $endtime = $time;
            if ($avatar_frame_log && $avatar_frame_log['end_time'] > $time) {
                // 说明有头像框
                $endtime = $avatar_frame_log['end_time'];
                //减少用户钻石
                $sql = "update " . DB_PREFIX . "avatar_frame_log set status = 2 where id = " . $avatar_frame_log['id'];
                $GLOBALS['db']->query($sql);
            }
            $endtime =  $endtime + 60 * 60 * 24 * $avatar_frame['day'];
            //减少用户钻石
            $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $avatar_frame['coin'] . ", use_diamonds = use_diamonds + " . $avatar_frame['coin'] . ", score = score + " . $avatar_frame['coin'] . " where id = '" . $user_id . "' and diamonds >= " . $avatar_frame['coin'];
            $GLOBALS['db']->query($sql);
            //支付数量+1
            $sql = "update " . DB_PREFIX . "avatar_frame set quantity = quantity + 1 where id = " . $id;
            $GLOBALS['db']->query($sql);

            // 添加购买记录
            $sql = "insert into " . DB_PREFIX . "avatar_frame_log(uid,avatar_id,name,img,coin,day,type,status,create_time,end_time) values(" . $user_id . "," . $id . ",'" . $avatar_frame['name'] . "','" .$avatar_frame['img']. "'," . $avatar_frame['coin'] . "," . $avatar_frame['day']. "," . 1 . "," . 1 . "," . $time . "," . $endtime . ")";
            $GLOBALS['db']->query($sql);
            // 获取插入的 ID
            $prop_id = $GLOBALS['db']->insert_id;
            $log_info= api_lang('Purchas_profile_picture_frame').$avatar_frame['coin']. api_lang('Diamonds');
            // 添加购买记录
            $sql = "insert into " . DB_PREFIX . "user_log(log_info,log_time,type,user_id,diamonds,prop_id) values('" . $log_info . "'," . $time . "," . 14 . "," .$user_id. "," . $avatar_frame['coin'] . "," . $prop_id. ")";
            $GLOBALS['db']->query($sql);

            $GLOBALS['db']->query("update " . DB_PREFIX . "user set avatar_frame_id = ".$id." where id = " . $user_id);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            // 消费和收益记录表
            add_user_consumption_log($user_id,0,$avatar_frame['coin'],api_lang('Purchas_profile_picture_frame')."：".$avatar_frame['name'],0,0,9);
            //更新session
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
            $user_redis->update_db($user_id, $user_info);
            es_session::set("user_info", $user_info);
            $root['status'] = 1;
            $root['error'] = api_lang("purchase_successful");
            $content = $avatar_frame['name']."(".$avatar_frame['id'].")";
            add_user_records( $user_id,0,$avatar_frame['coin'],0,$user_info['diamonds'],0,0,0,$content,7);
            //提交事务
            $GLOBALS['db']->Commit($pInTrans);
        } catch (Exception $e) {
            //异常回滚
            $root['error'] = $e->getMessage();
            $GLOBALS['db']->Rollback($pInTrans);
        }
       return $root;
    }
    /**
    * 购买座驾
     * */
    public function pay_car($id,$user_info,$carid){
        $root = ['status' => 0, 'error' => ''];
        $user_id = $user_info['id'];
        $recharge = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "noble_recharge where status=1  and   id=" . $id);
        if (!$recharge) {
            $root['error'] = api_lang("data_error");
            return $root;
        }
        $total_diamonds = $recharge['money'];
        $total_score = $recharge['integral'];
        if ($user_info['diamonds'] >= $recharge['money']) {
            $sql = "select id,carid,endtime from " . DB_PREFIX . "noble_car where uid=$user_id and carid=" . $carid;
            $car = $GLOBALS['db']->getRow($sql);
            $time = NOW_TIME + 60 * 60 * 24 * $recharge['day'];
            //减少用户钻石
            $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $total_diamonds . ", use_diamonds = use_diamonds + " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and diamonds >= " . $total_diamonds;
            $status = $GLOBALS['db']->query($sql);

            if ($status) {
                $sql = "insert into " . DB_PREFIX . "noble_car(uid,carid,recharge,addtime,endtime) values(" . $user_id . "," . $carid . "," . $id . "," . time() . "," . $time . ")";

                if ($car) {
                    if ($car['endtime'] > NOW_TIME) {
                        //续费
                        $time = $car['endtime'] + 60 * 60 * 24 * $recharge['day'];
                    }
                    $sql = "update " . DB_PREFIX . "noble_car set uid =" . $user_id . ", recharge =" . $id . ", endtime =" . $time . ", addtime = " . time() . " where id = " . $car['id'];
                }

                $GLOBALS['db']->query($sql);
                $noble = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "noble where id=" . $carid);
                //支付数量+1
                $sql = "update " . DB_PREFIX . "noble set quantity = quantity + 1 where id = " . $carid;
                $GLOBALS['db']->query($sql);
                // 更新座驾缓存
                $sql = "select * from " . DB_PREFIX . "noble_car where carid=" . $carid . " and endtime >=" . time() . " and uid=" . $user_id;
                $car = $GLOBALS['db']->getRow($sql, true, true);

                $value=array(
                    'uid'=>$user_id,
                    'carid' =>$carid,
                    'recharge' => $id,
                    'addtime' => NOW_TIME,
                    'endtime' => $time,
                );
                $expire = $time - NOW_TIME;
                // 把用户购买的座驾存入缓存使用 key = noble_car_座驾id_用户id   $expire =redis过期时间
                redis_set("noble_car_".$carid."_".$user_id,json_encode($value),$expire);
                $log_info = $noble['name']."(".$carid.") x ".$recharge['day']." ".api_lang('day');
                $sql = "insert into " . DB_PREFIX . "user_log(log_info,log_time,type,user_id,diamonds,prop_id,end_time) values('" . $log_info . "','" . time() . "','10','" . $user_id . "','" . $total_diamonds . "','" . $id . "','".$time."')";

                $GLOBALS['db']->query($sql);
                $root['noble_time'] = to_date($time, 'Y-m-d');

                $sql = "update " . DB_PREFIX . "user set noble_car_id =" . $car['carid'] . " where id =" . $user_id;
                $GLOBALS['db']->query($sql);


                // 消费和收益记录表
                add_user_consumption_log($user_id,0,$total_diamonds,api_lang('purchase').api_lang('Car')."：".$noble['name'],0,0,8);

                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();

                //更新session
                $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);

                $user_redis->update_db($user_id, $user_info);
                es_session::set("user_info", $user_info);
                $root['error'] = api_lang("purchase_successful");
                $root['status'] = 1;
                $content = $noble['name']."(".$carid.")";
                add_user_records( $user_id,0,$total_diamonds,0,$user_info['diamonds'],0,0,0,$content,2);

            } else {
                $root['status'] = 0;
                $root['error'] = api_lang("Insufficient_amount_please_recharge");
                ajax_return($root);
            }
        } else {
            $root['status'] = 0;
            $root['error'] = api_lang("Insufficient_amount_please_recharge");
        }
        return $root;
    }
    /**
    * 头像列表
     * */
    public function avatar_frame_list(){
        $root = ['status' => 1, 'error' => ''];
        $sql = "select id,name,img,img as svga,coin,day from " . DB_PREFIX . "avatar_frame where status=1 order by quantity desc,sort asc";
        $list = $GLOBALS['db']->getALL($sql);
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['data'] = array(
            'list' =>$list,
            'diamonds_name' =>$m_config['diamonds_name'],
            'head_image'=>$m_config['default_avatar'],
            'consumer_price_Icon'=> $m_config['consumer_price_Icon']
        );
        api_ajax_return($root);
    }
    /**
     * 座驾列表
     * */
    public function car_list(){
        $root = ['status' => 1, 'error' => ''];
        $sql = "select n.id,n.title_img as img,n.img as svga,n.name,r.money as coin,r.day from " . DB_PREFIX . "noble n JOIN " . DB_PREFIX . "noble_recharge r on r.nobleid = n.id where n.status=1 and n.type=1 and r.status=1  order by n.quantity desc,n.sort asc,r.sort asc";
        $list = $GLOBALS['db']->getALL($sql);
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['data'] = array(
            'list' =>$list,
            'diamonds_name' =>$m_config['diamonds_name'],
            'head_image'=>$m_config['default_avatar'],
            'consumer_price_Icon'=> $m_config['consumer_price_Icon']
        );
        api_ajax_return($root);
    }
    /**
     * 我的座驾
     * */
    public function my_car()
    {
        $root = ['status' => 1, 'error' => ''];
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,noble_car_id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //我的座驾
            $sql = "select id,carid as select_id,endtime from " . DB_PREFIX . "noble_car where uid=" . $user_info['id'] . "  and carid >0 and endtime > " . time();
            $car = $GLOBALS['db']->getALL($sql);
            foreach ($car as &$v) {
                $v['end_date'] = date("Y-m-d", $v['endtime']);
                $vid = $v['select_id'];
                $sql = "select * from " . DB_PREFIX . "noble where status=1 and id=" . $vid;
                $car_name = $GLOBALS['db']->getRow($sql);
                $v['name'] = $car_name['name'];
                $v['img'] = $car_name['img'];
                $v['title_img'] = $car_name['title_img'];
            }
            $root['user_info'] = $user_info;
            $root['data'] = array(
                'list' => $car,
                'head_image' => '',
                'select_id' => $user_info['noble_car_id']
            );
        }
        api_ajax_return($root);
    }
    // 我的头像框
    public function my_avatar_frame(){
        $root = array('status' => 1, 'error'=> '');
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select head_image,avatar_frame_id,id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['status'] = 0;
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $user_id=$user_info['id'];
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        $sql = "select id,name,img,avatar_id as select_id,end_time from " . DB_PREFIX . "avatar_frame_log where uid = ".$user_id." and status=1 and end_time >".time()." group by avatar_id order by create_time desc";
        $my_avatar = $GLOBALS['db']->getALL($sql);
        foreach ($my_avatar as &$v) {
            $v['end_date'] = date('Y-m-d',$v['end_time']);
            $v['title_img'] = $v['img'];
        }
        $root['data'] = array(
            'list' => $my_avatar,
            'head_image' => $m_config['default_avatar'],
            'select_id' => $user_info['avatar_frame_id']
        );
        api_ajax_return($root);
    }
    /**
    * 开启和关闭座驾
     * id 记录表id
     * */
    public function open_close_car()
    {
        $root = array('status' => 0, 'error' => api_lang("operation_was_successful"));
        $id = intval($_REQUEST['id']);
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,noble_car_id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$id) {
            $root['error'] = api_lang("parameter_error");
            api_ajax_return($root);
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];
        $sql = "select id,carid,endtime from " . DB_PREFIX . "noble_car where uid=$user_id  and id=$id and endtime > " . time();

        $car = $GLOBALS['db']->getRow($sql);

        $ucarid = $user_info['noble_car_id'];

        $type = $car['carid'] == $ucarid ? '0' : $car['carid'];

        $sql = "update " . DB_PREFIX . "user set noble_car_id =" . $type . " where id =" . $user_id;

        $status = $GLOBALS['db']->query($sql);

        if (!$status) {
            $root['error'] = api_lang("Start_failure");
        } else {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            //更新session
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
            // 把用户购买的座驾存入缓存使用 key = noble_car_座驾id_用户id   $expire =redis过期时间
            $expire = $car['endtime'] - NOW_TIME;
            if($expire > 0){
                redis_set("noble_car_".$type."_".$user_id,json_encode($car),$expire);
            }
            $root['status'] = 1;
            $user_redis->update_db($user_id, $user_info);
            es_session::set("user_info", $user_info);
        }
        ajax_return($root);
    }
    /**
     * 开启和关闭头像框
     *  id 记录表id
     * */
    public function open_close_avatar()
    {
        $root = array('status'=>0,'error'=>'');
        $id = intval($_REQUEST['id']);
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,avatar_frame_id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$id) {
            $root['error'] = api_lang("parameter_error");
            api_ajax_return($root);
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];
        $avatar_frame_log = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "avatar_frame_log where  uid = " . $user_id . " and status = 1 and id=".$id);
        if (!$avatar_frame_log) {
            $root['error'] = api_lang("data_error");
            api_ajax_return($root);
        }
        $avatar_frame_id = $avatar_frame_log['avatar_id'] == $user_info['avatar_frame_id'] ? 0 : $avatar_frame_log['avatar_id'];
        $sql = "update " . DB_PREFIX . "user set avatar_frame_id =" . $avatar_frame_id . " where id =" . $user_id;
        $status = $GLOBALS['db']->query($sql);
        if (!$status) {
            $root['error'] = api_lang("failed_to_open");
            api_ajax_return($root);
        }
        $root['status'] = 1;
        $root['error'] = api_lang("operation_was_successful");
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_redis->inc_field($user_id, 'avatar_frame_id', $avatar_frame_id);
        api_ajax_return($root);
    }

    /**
    * VIP列表
     * */
    public function vip_list()
    {
        $root = ['status' => 0, 'error' => ''];
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,vip_expire_time,head_image,nick_name from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            api_ajax_return($root);
        }
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $username = $user_info;
        if ($username['vip_expire_time'] > time()) {
            $username['vip_time'] = to_date($username['vip_expire_time'], 'Y/m/d');
        } else {
            $username['vip_time'] = "";
        }
        $username['head_image'] = get_spec_image($username['head_image']);
        $root['status'] = 1;
        $vip_rule = $GLOBALS['db']->getALL("select * from " . DB_PREFIX . "vip_rule where is_effect=1 order by sort desc");
        $root['data'] = array(
            'consumer_price_Icon' => $m_config['consumer_price_Icon'],
            'user' => $username,
            'vip_rule' => $vip_rule
        );
        api_ajax_return($root);

    }
    /**
    * 购买会员
     * */
    public function pay_vip()
    {
        $root = ['status' => 0, 'error' => ''];
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,diamonds,head_image,vip_expire_time from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            api_ajax_return($root);
        }
        $id = intval($_REQUEST['id']);
        $vip_rule = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "vip_rule where id=" . $id);
        if (!$vip_rule) {
            $root['error'] = api_lang("parameter_error");
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];
        $total_diamonds = $vip_rule['money'];
        $total_score = $vip_rule['money'];
        if ($user_info['diamonds'] < $total_diamonds) {
            $root['error'] = api_lang("insufficient_balance");
            api_ajax_return($root);
        }
        //减少用户钻石
        $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $total_diamonds . ", use_diamonds = use_diamonds + " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and diamonds >= " . $total_diamonds;
        $GLOBALS['db']->query($sql);
        if ($GLOBALS['db']->affected_rows()) {
            $vip_expire_time = $user_info['vip_expire_time'];
            if ($vip_expire_time > NOW_TIME) {
                $time = $vip_expire_time + 60 * 60 * 24 * $vip_rule['day_num'];
            } else {
                //购买
                $time = NOW_TIME + 60 * 60 * 24 * $vip_rule['day_num'];
            }
            $user_info['vip_expire_time'] = to_date($time, 'Y-m-d H:i');
            $user_info['is_vip'] = 1;
            bogo_require(APP_ROOT_PATH . "system/libs/user.php");
            //提交空字段不操作
            $status = save_user($user_info, 'UPDATE');
            if ($status) {
                $sql = "insert into " . DB_PREFIX . "user_log(log_info,log_time,type,user_id,diamonds,prop_id) values('".api_lang("Purchased_member_consumption") . $total_diamonds . api_lang("Diamonds")."','" . time() . "','9','" . $user_id . "','" . $total_diamonds . "','" . $id . "')";
                $GLOBALS['db']->query($sql);
                // 消费和收益记录表
                add_user_consumption_log($user_id,0,$total_diamonds,api_lang('purchase').api_lang('VIP_members'),0,0,7);
                $root['vip_expire_time'] = to_date($time, 'Y-m-d');
                //更新session
                $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $status['data']);
                es_session::set("user_info", $user_info);
                $content = $vip_rule['name']."(".$vip_rule['id'].")";
                add_user_records( $user_id,0,$total_diamonds,0,$user_info['diamonds'],0,0,0,$content,4);
            }
            $root['status'] = 1;
            $root['error'] = api_lang("purchase_successful");
        } else {
            $root['error'] = api_lang("insufficient_balance");
        }
        api_ajax_return($root);
    }
    /**
    * 靓号商城
     * */
    public function lucky_list()
    {
        $root = array('status' => 0, 'error' => '');
        $user_id = get_user_token_id(strim($_REQUEST['token']));//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $type = $GLOBALS['db']->getALL("select figure from " . DB_PREFIX . "luck_num where is_sale =0 and type=1 group by figure order by figure asc ");
        if ($type) {
            foreach ($type as &$v) {
                $figureid = $v['figure'];
                $sql = "select * from " . DB_PREFIX . "luck_num where is_sale =0 and type=1 and figure=" . $figureid;
                $v['list'] = $GLOBALS['db']->getALL($sql);
            }
        }
        $root['data'] = array(
            'consumer_price_Icon' => $m_config['consumer_price_Icon'],
            'type' => $type
        );
        $root['status'] = 1;
        api_ajax_return($root);
    }
    /**
    * 购买靓号
     **/
    public function pay_lucky()
    {
        $root = array('status' => 0, 'error' => api_lang("operation_failed"));
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,diamonds,head_image,vip_expire_time from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            api_ajax_return($root);
        }
        $id = intval($_REQUEST['id']);
        $user_id = intval($user_info['id']);
        $luck = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "luck_num where is_sale=0 and type=1 and id=" . $id);
        if (!$luck) {
            $root['error'] = api_lang("parameter_error");
            ajax_return($root);
        }
        if ($user_info['diamonds'] < $luck['price']) {
            $root['error'] = api_lang("insufficient_balance");
            api_ajax_return($root);
        }
        $luck_num = $GLOBALS['db']->getOne("select luck_num from " . DB_PREFIX . "user where id=" . $user_id);
        $pInTrans = $GLOBALS['db']->StartTrans();
        try {
            //减少用户钻石
            $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $luck['price'] . ", use_diamonds = use_diamonds + " . $luck['price'] . ", luck_num=" . $luck['luck_num'] . " where id = '" . $user_id . "' and diamonds >= " . $luck['price'];
            $GLOBALS['db']->query($sql);
            $GLOBALS['db']->query("update " . DB_PREFIX . "luck_num set is_sale=1 where id =" . $id);
            if ($luck_num != 0) {
                $GLOBALS['db']->query("update " . DB_PREFIX . "luck_num set is_sale=0 where luck_num =" . $luck_num);
            }
            $sql = "insert into " . DB_PREFIX . "user_log(log_info,log_time,type,user_id,diamonds,prop_id) values('购买靓号" . $luck['luck_num'] . api_lang('consumption') . $luck['price'] . "','" . time() . "','11','" . $user_id . "','" . $luck['price'] . "','" . $id . "')";
            $GLOBALS['db']->query($sql);
            // 消费和收益记录表
            add_user_consumption_log($user_id,0,$luck['price'],api_lang('Beautiful_name')."：".$luck['luck_num'],0,0,10);
            $root['status'] = 1;
            $root['error'] = api_lang("purchase_successful");
            $content = $luck['luck_num']."(".$luck['id'].")";
            add_user_records( $user_id,0,$luck['price'],0,$user_info['diamonds'],0,0,0,$content,5);
            //提交事务
            $GLOBALS['db']->Commit($pInTrans);
        } catch (Exception $e) {
            //异常回滚
            $root['error'] = $e->getMessage();
            $GLOBALS['db']->Rollback($pInTrans);
        }
        ajax_return($root);
    }
}