<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------
use think\Db;
class rankModule extends baseModule
{
    /**
     * 财富榜和魅力榜
     * **/
    public function charm_rich_rank(){
        $root = array('status' => 1, 'error' => '');
        $rank_type = strim($_REQUEST['rank_type']);// 财富榜和魅力榜
        $rank_name = strim($_REQUEST['rank_name']);//贡献榜 名称  日，月，总
        $rank_names = array('day', 'month', 'all');
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        // 判断传值是否正确
        if (in_array($rank_name, $rank_names)) {
            $list = $this->charm_rich_rank_redis($rank_type,$rank_name);
            require_once APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php';
            $user_redis = new UserRedisService();
            foreach ($list as $k => $v) {
                if ($v['noble_time'] > NOW_TIME) {
                    $jurisdiction = load_auto_cache("noble_id",['id'=>$v['nobleid']]);
                    // 是贵族
                    if($jurisdiction && $jurisdiction['is_list_invisible'] == 1 && $v['is_noble_ranking_stealth'] == 1){
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($v['user_id'], $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                        $list[$k]['user_id'] = 0;
                    }else if($v['is_noble_mysterious'] == 1) {
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($v['user_id'], $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                        $list[$k]['user_id'] = 0;
                    }
                    $list[$k]['is_noble_mysterious'] = $v['is_noble_mysterious'];
                    $list[$k]['is_noble_ranking_stealth'] = $v['is_noble_ranking_stealth'];
                }else{
                    $list[$k]['is_noble_mysterious'] = 0;
                    $list[$k]['is_noble_ranking_stealth'] = 0;
                }
                // 头像框
                $avatar_frame = $user_redis->getRow_db($v['user_id'], array('avatar_frame_id'));
                $list[$k]['avatar_frame_url'] = '';
                if ($avatar_frame && $avatar_frame['avatar_frame_id']) {
                    // 头像框
                    $list[$k]['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $avatar_frame['avatar_frame_id']);
                }
                $list[$k]['age'] = intval($v['birthday']) ? ceil((NOW_TIME - $v['birthday']) / 31536000) : 0;//年龄
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
                $list[$k]['nick_name'] = emoji_decode(htmlspecialchars_decode($v['nick_name']));
                $list[$k]['ticket'] = intval($v['ticket']);

                if ($list[$k]['ticket'] == 0) {
                    unset($list[$k]);
                }else{
                    // 转换单位
                    $list[$k]['ticket']=format_for_ten_thousand_k($list[$k]['ticket'],1,2);
                }
            }
            $root['data']['list'] = $list;
        } else {
            $root['status'] = 0;
            $root['error'] = api_lang("parameter_error");
        }
        $root['data']['unit'] = $rank_type== 'charm' ? $m_config['ticket_name'] :$m_config['diamonds_name'];

        ajax_return($root);
    }

    /**
    * 排行缓存
     * */
    public function charm_rich_rank_redis($rank_type,$rank_name){
        $page=1;
        $page_size = 30;//分页数量
        $table = createPropTable();
        $rank_names = array('day', 'month', 'all');
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $list = [];
        //贡献榜
        if (in_array($rank_name, $rank_names)) {
            $rank_cache_name = "rank_" . $rank_name;
            $rank_cache_time = $m_config[$rank_cache_name];
            $rank_cache_default = array("rank_day" => 1800, "rank_month" => 28800, "rank_all" => 86400);
            if ($rank_cache_time < $rank_cache_default[$rank_cache_name]) {
                $rank_cache_time = $rank_cache_default[$rank_cache_name];
            }
            $rank_cache_time = $rank_cache_time != '' ? $rank_cache_time : 86400;

            $param = array('rank_name' => $rank_name, 'table' => $table, 'page' => $page, 'page_size' => $page_size, 'cache_time' => $rank_cache_time);
            if($rank_type == 'charm'){
                $list = load_auto_cache("rank_consumption", $param);
            }else{
                $list = load_auto_cache("rank_contribution", $param);
            }
        }

//        $name_key =  $rank_type == 'charm' ? "rank_profit_h5_": "rank_consumption_h5_";
//        $rank_key = $name_key . $rank_name;
//        $table = createPropTable();
//        $list = redis_get($rank_key);
//        $list = false;
//        if (!$list) {
//            switch ($rank_name){
//                case 'day':
//                    // 当日
//                    $day_start_time = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
//                    $ticket = "v.total_diamonds";
//                    $left_join_id="v.from_user_id";
//                    if ($rank_type == 'charm'){
//                        $ticket = "v.total_ticket";
//                        $left_join_id="v.to_user_id";
//                    }
//                    $sql = "select u.id as user_id,u.birthday ,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(".$ticket.") as ticket ,u.is_authentication,u.sex,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
//												from " . $table . " as v LEFT JOIN  " . DB_PREFIX . "user as u on u.id = ".$left_join_id."
//												where u.is_effect=1 and v.create_time >=" . $day_start_time . " GROUP BY ".$left_join_id."
//												order BY ticket desc limit 0,100";
//                    $list = $GLOBALS['db']->getAll($sql, true, true);
//
//                    break;
//                case "month":
//                    // 本月
//                    $month_start_time = mktime(0, 0, 0, date('m'), 1, date('Y'));
//                    $ticket = "v.total_diamonds";
//                    $left_join_id="v.from_user_id";
//                    if ($rank_type == 'charm'){
//                        $ticket = "v.total_ticket";
//                        $left_join_id="v.to_user_id";
//                    }
//                    $sql = "select u.id as user_id,u.birthday ,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(".$ticket.") as ticket ,u.is_authentication,u.sex,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
//											from  " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = ".$left_join_id."
//											where u.is_effect=1 and v.create_time >=" . $month_start_time . " GROUP BY ".$left_join_id."
//											order BY ticket desc limit 0,100";
//                    $list = $GLOBALS['db']->getAll($sql, true, true);
//                    break;
//                default:
//                    $ticket = "u.use_diamonds";
//                    if ($rank_type == 'charm'){
//                        $ticket = "u.ticket";
//                    }
//                    $sql = "select u.id as user_id,u.birthday ,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,".$ticket." as ticket ,u.is_authentication,u.sex,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
//											from " . DB_PREFIX . "user as u where u.is_effect=1 and ".$ticket.">0
//											order BY ".$ticket." desc limit 0,100";
//                    $list = $GLOBALS['db']->getAll($sql, true, true);
//            }
//
//            redis_set($rank_key,json_encode($list),60);
//        } else{
//            $list = json_decode($list,true);
//        }
        return $list;
    }
    /**
     * 房间富豪榜  --- vue
     */
    public function video_ranking()
    {
        $root = array('status' => 1, 'error' => '');
        if (strim($_REQUEST['token'])) {
            $user_info = Db::name("user")->where("token='" . strim($_REQUEST['token']) . "'")->find();
        }
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];
        $user = [
            'id' => $user_id,
            'head_image' => get_spec_image($user_info['head_image']),
            'user_level' => $user_info['user_level'],
            'ticket' => 0,
            'order' => '0'
        ];
        $user_info['nick_name'] = htmlspecialchars_decode($user_info['nick_name']);
        $user['nick_name'] = emoji_decode($user_info['nick_name']);

        $to_user_id = intval($_REQUEST['to_uid']);
        $room_id = intval($_REQUEST['room_id']);//直播ID 也是room_id
        $type = intval($_REQUEST['type']); // 1今日排行 2昨日排行
        if ($type == 1) {
            // 获取房间富豪排行榜  -- 今日
            $start_time = strtotime(date('Y-m-d'));
            $endtime_time = $start_time + 24 * 60 * 60;
        } else {
            // 获取房间富豪排行榜  -- 昨日
            $start_time = strtotime(date('Y-m-d')) - 24 * 60 * 60;
            $endtime_time = $start_time + 24 * 60 * 60;
        }
        //获取数据表名
        $prev_m = date("Ym", $start_time);

        $table = 'video_prop_' . $prev_m;
        //今日贡献榜
        $field = "u.id as user_id ,u.nick_name,u.head_image,u.sex,u.user_level,sum(v.total_diamonds) as ticket";
        $where = "v.create_time >=" . $start_time . " and v.create_time <" . $endtime_time;
        if($room_id){
            $where .= " and v.video_id= " . $room_id;
        }else{
            $where .= " and v.to_user_id= " . $to_user_id;
        }

        $list = Db::name($table)->alias("v")
            ->join("user u", "u.id = v.from_user_id")
            ->field($field)
            ->where($where)
            ->group("v.from_user_id")
            ->order("ticket desc")
            ->limit(0, 100)
            ->select();
        foreach ($list as $k => $v) {
            $list[$k]['head_image'] = get_spec_image($v['head_image']);
            $v['nick_name'] = htmlspecialchars_decode($v['nick_name']);
            $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
            $list[$k]['sex'] = $v['sex'];
            $list[$k]['ticket'] = format_for_ten_thousand(intval($v['ticket']));
            if ($v['user_id'] == $user_id) {
                $user['order'] = $k + 1;
                $user['ticket'] = $v['ticket'];
            }
            if ($list[$k]['ticket'] == 0) {
                unset($list[$k]);
            }
        }
        $root['data'] = array(
            'list' => $list,
            'user' => $user
        );

        ajax_return($root);
    }
    /**
    * 贡献排行榜 2021-03-25
     * 去掉分页新增个人排名
     */
    public function contribution_ranking(){
        $root = array('status' => 1, 'error' => '');

        $rank_name = strim($_REQUEST['rank_name']);//贡献榜 名称  日，月，总
        $user_id = intval($GLOBALS['user_info']['id']);//登录用户id
        $rank_names = array('day', 'month', 'all');
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['my_ranking'] = 0;
        // 判断传值是否正确
        if (in_array($rank_name, $rank_names)) {
            $rank_key = "rank_consumption_" . $rank_name;
            $list = $GLOBALS['cache']->get($rank_key,true);

            $user_info = $GLOBALS['db']->getRow("select nick_name,head_image,user_level from " . DB_PREFIX . "user where id =" . $user_id);
            $user = [
                'avatar' => get_spec_image($user_info['head_image']),
                'nickname' => $user_info['nick_name'],
                'user_level' => $user_info['user_level'],
                'ticket' => 0,
                'order'  => api_lang('Not_on_list')
            ];


            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $keys = $user_redis->following();
            foreach ($list as $k => $v) {
                if ($v['noble_time'] > NOW_TIME) {
                    $jurisdiction = load_auto_cache("noble_id",['id'=>$v['nobleid']]);
                    // 是贵族
                    if($jurisdiction && $jurisdiction['is_list_invisible'] == 1 && $v['is_noble_ranking_stealth'] == 1){
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($v['user_id'], $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }else if($v['is_noble_mysterious'] == 1) {
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($v['user_id'], $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }
                    $list[$k]['is_noble_mysterious'] = $v['is_noble_mysterious'];
                    $list[$k]['is_noble_ranking_stealth'] = $v['is_noble_ranking_stealth'];
                }else{
                    $list[$k]['is_noble_mysterious'] = 0;
                    $list[$k]['is_noble_ranking_stealth'] = 0;
                }


                $list[$k]['head_image'] = get_spec_image($v['head_image']);
                $list[$k]['nick_name'] = htmlspecialchars_decode($v['nick_name']);
                $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
                $list[$k]['ticket'] = intval($v['ticket']);
                if ($user_id > 0) {
                    if($v['user_id'] == $user_id){
                        $root['my_ranking'] = $k + 1;
                        $user['order'] = $k + 1;
                        $user['ticket'] = $v['ticket'];
                    }
                    if (in_array($v['user_id'], $keys)) {
                        $list[$k]['is_focus'] = 1;
                    } else {
                        $list[$k]['is_focus'] = 0;
                    }
                } else {
                    $list[$k]['is_focus'] = 0;
                }
                if ($list[$k]['ticket'] == 0) {
                    unset($list[$k]);
                }
            }
            $root['list'] = $list;
            $root['user'] = $user;
        } else {
            $root['status'] = 0;
            $root['error'] = api_lang("parameter_error");
            ajax_return($root);
        }
        ajax_return($root);
    }
    /**
     * 收入排行榜 2021-03-25
     * 去掉分页新增个人排名
     */
    public function revenue_ranking()
    {
        $root = array('status' => 1, 'error' => '');

        $rank_name = strim($_REQUEST['rank_name']);//收入榜名称
        $user_id = intval($GLOBALS['user_info']['id']);//登录用户id

        $rank_names = array('day', 'month', 'all');
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['my_ranking'] = 0;
        //收入榜
        if (in_array($rank_name, $rank_names)) {
            $rank_key = "rank_profit_" . $rank_name;
            $list = $GLOBALS['cache']->get($rank_key,true);

            $user_info = $GLOBALS['db']->getRow("select nick_name,head_image,user_level from " . DB_PREFIX . "user where id =" . $user_id);
            $user = [
                'avatar' => get_spec_image($user_info['head_image']),
                'nickname' => $user_info['nick_name'],
                'user_level' => $user_info['user_level'],
                'ticket' => 0,
                'order'  => api_lang('Not_on_list')
            ];

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $keys = $user_redis->following();

            foreach ($list as $k => $v) {
                if ($v['noble_time'] > NOW_TIME) {
                    $jurisdiction = load_auto_cache("noble_id",['id'=>$v['nobleid']]);
                    // 是贵族
                    if($jurisdiction && $jurisdiction['is_list_invisible'] == 1 && $v['is_noble_ranking_stealth'] == 1){
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($v['user_id'], $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }else if($v['is_noble_mysterious'] == 1) {
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($v['user_id'], $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }
                }
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
                $list[$k]['nick_name'] = htmlspecialchars_decode($v['nick_name']);
                $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
                $list[$k]['ticket'] = intval($v['ticket']);

                if ($user_id > 0) {
                    if($v['user_id'] == $user_id){
                        $root['my_ranking'] = $k + 1;
                        $user['order'] = $k + 1;
                        $user['ticket'] = $v['ticket'];
                    }
                    if (in_array($v['user_id'], $keys)) {
                        $list[$k]['is_focus'] = 1;
                    } else {
                        $list[$k]['is_focus'] = 0;
                    }
                } else {
                    $list[$k]['is_focus'] = 0;
                }
                if ($list[$k]['ticket'] == 0) {
                    unset($list[$k]);
                }
            }
            $root['list'] = $list;
            $root['user'] = $user;
        } else {

            $root['status'] = 0;
            $root['error'] = api_lang("parameter_error");
            ajax_return($root);
        }
        ajax_return($root);
    }



    /**
     * 贡献排行榜 from_user_id 送   无关注  贡献（消费）榜是按：送出的钻石 排序  ===》total_diamonds
     * 分为 ： 日榜（缓存时间最低：1800s）、月榜（缓存时间最低：28800s）、总榜（缓存时间最低：86400s）
     * 缓存时间由后台设置，不得低于最低缓存时间
     */
    public function contribution()
    {
        $root = array('status' => 1, 'error' => '');
        //分页
        $page = intval($_REQUEST['p']);//当前页
        $page_size = 30;//分页数量
        if ($page == 0) {
            $page = 1;
        }

        $rank_name = strim($_REQUEST['rank_name']);//贡献榜 名称  日，月，总
        $user_id = intval($GLOBALS['user_info']['id']);//登录用户id
        $table = createPropTable();
        $rank_names = array('day', 'month', 'all');
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        //贡献榜
        if (in_array($rank_name, $rank_names)) {
            $rank_cache_name = "rank_" . $rank_name;
            $rank_cache_time = $m_config[$rank_cache_name];
            $rank_cache_default = array("rank_day" => 1800, "rank_month" => 28800, "rank_all" => 86400);
            if ($rank_cache_time < $rank_cache_default[$rank_cache_name]) {
                $rank_cache_time = $rank_cache_default[$rank_cache_name];
            }
            $rank_cache_time = $rank_cache_time != '' ? $rank_cache_time : 86400;

            $param = array('rank_name' => $rank_name, 'table' => $table, 'page' => $page, 'page_size' => $page_size, 'cache_time' => $rank_cache_time);
            $list = load_auto_cache("rank_contribution", $param);

            $user_info = $GLOBALS['db']->getRow("select nick_name,head_image,user_level,avatar_frame_id from " . DB_PREFIX . "user where id =" . $user_id);
            $user = [
                'avatar' => get_spec_image($user_info['head_image']),
                'nickname' => $user_info['nick_name'],
                'user_level' => $user_info['user_level'],
                'ticket' => 0,
                'avatar_frame_url' => get_avatar_frame_url($user_info['id'], $user_info['avatar_frame_id']),

                'order'  => api_lang('Not_on_list')
            ];

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $keys = $user_redis->following();

            foreach ($list as $k => $v) {
                if ($v['noble_time'] > NOW_TIME) {
                    $jurisdiction = load_auto_cache("noble_id",['id'=>$v['nobleid']]);
                    // 是贵族
                    if($jurisdiction && $jurisdiction['is_list_invisible'] == 1 && $v['is_noble_ranking_stealth'] == 1){
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($user_id, $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }else if($v['is_noble_mysterious'] == 1) {
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($user_id, $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }
                    $list[$k]['is_noble_mysterious'] = $v['is_noble_mysterious'];
                    $list[$k]['is_noble_ranking_stealth'] = $v['is_noble_ranking_stealth'];
                }else{
                    $list[$k]['is_noble_mysterious'] = 0;
                    $list[$k]['is_noble_ranking_stealth'] = 0;
                }
                $list[$k]['avatar_frame_url'] =get_avatar_frame_url($v['user_id'], $v['avatar_frame_id']);
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
                $list[$k]['nick_name'] = htmlspecialchars_decode($v['nick_name']);
                $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
                $list[$k]['ticket'] = intval($v['ticket']);
                if ($user_id > 0) {
                    if($v['user_id'] == $user_id){
                        $root['my_ranking'] = $k + 1;
                        $user['order'] = $k + 1;
                        $user['ticket'] = $v['ticket'];
                    }
                    if (in_array($v['user_id'], $keys)) {
                        $list[$k]['is_focus'] = 1;
                    } else {
                        $list[$k]['is_focus'] = 0;
                    }
                } else {
                    $list[$k]['is_focus'] = 0;
                }
                if ($list[$k]['ticket'] == 0) {
                    unset($list[$k]);
                }
            }

            $root['list'] = $list;
            $root['user'] = $user;
            $count = count($list);
        } else {
            $root['status'] = 0;
            $root['error'] = api_lang("parameter_error");
            ajax_return($root);
        }
        $root['page'] = $page;
        $has_next = ($count > $page * $page_size) ? 1 : 0;
        $root['has_next'] = $has_next;
        ajax_return($root);
    }

    /**
     * 收入排行榜 to_user_id 收  无关注  收入榜：按收到的印票 排序 ===> sum(total_ticket)   where is_red_envelope = 0
     * 分为 ： 日榜（缓存时间最低：1800s）、月榜（缓存时间最低：28800s）、总榜（缓存时间最低：86400s）
     * 缓存时间由后台设置，不得低于最低缓存时间
     */
    public function consumption()
    {
        $root = array('status' => 1, 'error' => '');
        //分页
        $page = intval($_REQUEST['p']);//当前页
        $page_size = 30;//分页数量
        if ($page == 0) {
            $page = 1;
        }
        $rank_name = strim($_REQUEST['rank_name']);//收入榜名称
        $user_id = intval($GLOBALS['user_info']['id']);//登录用户id

        //	$user_id = intval($_REQUEST['user_id']);

        $table = createPropTable();
        $rank_names = array('day', 'month', 'all');
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        //收入榜
        if (in_array($rank_name, $rank_names)) {
            $rank_cache_name = "rank_" . $rank_name;
            $rank_cache_time = $m_config[$rank_cache_name];
            $rank_cache_default = array("rank_day" => 1800, "rank_month" => 28800, "rank_all" => 86400);
            if ($rank_cache_time < $rank_cache_default[$rank_cache_name]) {
                $rank_cache_time = $rank_cache_default[$rank_cache_name];
            }
            $rank_cache_time = $rank_cache_time != '' ? $rank_cache_time : 86400;

            $param = array('rank_name' => $rank_name, 'table' => $table, 'page' => $page, 'page_size' => $page_size, 'cache_time' => $rank_cache_time);
            $list = load_auto_cache("rank_consumption", $param);

            $user_info = $GLOBALS['db']->getRow("select nick_name,head_image,user_level,avatar_frame_id from " . DB_PREFIX . "user where id =" . $user_id);
            $user = [
                'avatar' => get_spec_image($user_info['head_image']),
                'nickname' => $user_info['nick_name'],
                'user_level' => $user_info['user_level'],
                'ticket' => 0,
                'avatar_frame_url' => get_avatar_frame_url($user_info['id'], $user_info['avatar_frame_id']),
                'order'  =>api_lang('Not_on_list')
            ];


            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $keys = $user_redis->following();

            foreach ($list as $k => $v) {
                if ($v['noble_time'] > NOW_TIME) {

                    $jurisdiction = load_auto_cache("noble_id",['id'=>$v['nobleid']]);
                    // 是贵族
                    if($jurisdiction && $jurisdiction['is_list_invisible'] == 1 && $v['is_noble_ranking_stealth'] == 1){
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($user_id, $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }else if($v['is_noble_mysterious'] == 1) {
                        // 神秘人昵称
                        $v['nick_name'] = noble_mysterious_name($user_id, $v['create_time']);
                        // 神秘人头像
                        $v['head_image'] = $m_config['mysterious_picture'];
                    }

                }
                $list[$k]['avatar_frame_url'] =get_avatar_frame_url($v['user_id'], $v['avatar_frame_id']);

                $list[$k]['head_image'] = get_spec_image($v['head_image'], 150, 150);
                $list[$k]['nick_name'] = htmlspecialchars_decode($v['nick_name']);
                $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
                $list[$k]['ticket'] = intval($v['ticket']);


                if ($user_id > 0) {
                    if($v['user_id'] == $user_id){
                        $root['my_ranking'] = $k + 1;
                        $user['order'] = $k + 1;
                        $user['ticket'] = $v['ticket'];
                    }
                    if (in_array($v['user_id'], $keys)) {
                        $list[$k]['is_focus'] = 1;
                    } else {
                        $list[$k]['is_focus'] = 0;
                    }
                } else {
                    $list[$k]['is_focus'] = 0;
                }
                if ($list[$k]['ticket'] == 0) {
                    unset($list[$k]);
                }
            }

            $root['list'] = $list;
            $root['user'] = $user;
            $count = count($list);
        } else {

            $root['status'] = 0;
            $root['error'] = api_lang("parameter_error");
            ajax_return($root);
        }
        $root['page'] = $page;
        $has_next = ($count > $page * $page_size) ? 1 : 0;
        $root['has_next'] = $has_next;
        ajax_return($root);
    }

    /**
     * pk排行榜
     */
    public function rank_pk()
    {
        $root = array('status' => 1, 'error' => '');
        //分页
        $page = intval($_REQUEST['p']) == 0 ? 1 : intval($_REQUEST['p']);//当前页
        $page_size = 30;//分页数量
        $user_id = intval($GLOBALS['user_info']['id']);//登录用户id

        $param = array('page' => $page, 'page_size' => $page_size, 'cache_time' => 86400);

        $list = load_auto_cache("rank_pk", $param);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
        $user_redis = new UserFollwRedisService($user_id);
        $keys = $user_redis->following();

        foreach ($list as $k => $v) {
            $list[$k]['head_image'] = get_spec_image($v['head_image'], 150, 150);
            $list[$k]['nick_name'] = htmlspecialchars_decode($v['nick_name']);
            $list[$k]['nick_name'] = emoji_decode($v['nick_name']);
            if ($user_id > 0) {
                $list[$k]['is_focus'] = in_array($v['user_id'], $keys) ? 1 : 0;
            } else {
                $list[$k]['is_focus'] = 0;
            }
        }

        $root['list'] = $list;
        $count = count($list);
        $root['page'] = $page;
        $has_next = ($count > $page * $page_size) ? 1 : 0;
        $root['has_next'] = $has_next;
        ajax_return($root);
    }

}


?>