<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class RedisService extends BaseRedisService
{
    public function __construct()
    {
        parent::__construct();
    }
    public function set($key,$value,$time=0){
        $this->redis->set($this->prefix.$key, $value, $time);
    }
    public function get($key){
        return $this->redis->get($this->prefix.$key);
    }
    public function delete($key){
        $this->redis->delete($this->prefix.$key);
    }
    public function hSet($key,$name,$value){
        return $this->redis->hSet($this->prefix.$key, $name, $value);
    }
    public function hGet($key,$name){
        return $this->redis->hGet($this->prefix.$key, $name);
    }
    public function hDelOne($key,$name){
        return $this->redis->hDelOne($this->prefix.$key, $name);
    }
    public function zAdd($key,$score1,$name){
        return $this->redis->zAdd($this->prefix.$key,$score1, $name);
    }
    public function zRevRange($key, $start, $end, $withscores = null){
        return $this->redis->zRevRange($this->prefix.$key, $start, $end, $withscores);
    }
    public function zIncrBy($key,$member,$name){
        return $this->redis->zIncrBy($this->prefix.$key, $member, $name);
    }
    public function lPush($key,$value){
        return $this->redis->lPush($this->prefix.$key, $value);
    }
    public function lPop($key){
        return $this->redis->lPop($this->prefix.$key);
    }
    public function zRem($key, $name){
        return $this->redis->ZREM($this->prefix.$key, $name);
    }
}