<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class VideoContributionRedisService extends BaseRedisService
{

    var $user_contribution; //:podcast_id   zset 有序数据,user_id:贡献数
    var $video_contribution; //：video_id  zset 有序数据,user_id:贡献数
    var $video_vote_number_db; //   zset video_id:映票数(vote_number)
    var $user_day_contribution; // 用户日榜贡献 zset 有序数据

    public function __construct()
    {
        parent::__construct();
        $this->user_contribution = $this->prefix . 'user_contribution:';
        $this->video_contribution = $this->prefix . 'video_contribution:';
        $this->user_hash_db = $this->prefix . 'user_hash_db';
        $this->video_vote_number_db = $this->prefix . 'video_vote_number';
        $this->user_day_contribution = $this->prefix . 'user_day_contribution:' . date('Ymd') . ':';
    }

    /*
     * 添加
     * $video_id 为0时候，是直接发送礼物
     */
    public function insert_db($user_id, $podcast_id, $video_id = 0, $num)
    {
        $data = array();
        if ($video_id) {
            $data = $this->redis->hMGet($this->video_db . $video_id, array('province', 'sex', 'title', 'room_type', 'live_in'));
        }
        $pipe = $this->redis->multi();
        // 主播获取ticket，发送人 获取积分
        $pipe->zIncrBy($this->user_contribution . $podcast_id, $num, $user_id);

        // 更新用户日榜贡献数据
        $pipe->zIncrBy($this->user_day_contribution . $podcast_id, $num, $user_id);

        if ($video_id) {
            $pipe->zIncrBy($this->video_contribution . $video_id, $num, $user_id);
            $pipe->hIncrBy($this->video_db . $video_id, 'vote_number', $num);
            $pipe->zIncrBy($this->video_vote_number_db, $num, $video_id);
        }

        $replies = $pipe->exec();
        return $replies[0];
    }

    /*
     *  获取本主播当日最多贡献
     */
    public function get_video_contribute($user_id, $page, $page_size = 20, $is_only_list = false)
    {
        $root = array();
        if ($page == 0) {
            $page = 1;
        }
        $root['page'] = $page;
        // $page_size=20;
        $start = ($page - 1) * $page_size;
        $end = $page * $page_size - 1;
        bogo_require(APP_ROOT_PATH . "mapi/lib/core/common.php");
        //获取主播当日印票贡献排行
        $table = createPropTable();

        $m_config = load_auto_cache("m_config"); //初始化手机端配置
        //$rank_cache_time = intval($m_config['rank_day_user']) > 300 ? intval($m_config['rank_day_user']) : 300;
        $rank_cache_time = 10;
        $param = array('user_id' => $user_id, 'table' => $table, 'page' => $page, 'page_size' => $page_size, 'cache_time' => $rank_cache_time);
        $user_list = load_auto_cache("video_contribute", $param);

        $total_num = 0;
        foreach ($user_list as &$v) {
            $v['num'] = intval($v['num']);
            $total_num += $v['num'];
            if ($v['noble_time'] > NOW_TIME) {
                $jurisdiction = load_auto_cache("noble_id", ['id' => $v['nobleid']]);
                // 是贵族
                if ($jurisdiction && $v['is_noble_ranking_stealth'] == 1) {
                    // 神秘人昵称
                    $v['nick_name'] = noble_mysterious_name($user_id, $v['create_time']);
                    // 神秘人头像
                    $v['head_image'] = $m_config['mysterious_picture'];
                }
            }
            $v['head_image'] = get_spec_image($v['head_image']);
        }

        $root['list'] = $user_list;
        $root['total_ticket_num'] = $total_num;
        $root['user'] = $this->redis->hMGet($this->user_db . $user_id, array('nick_name', 'sex', 'head_image', 'ticket', 'user_level', 'v_type', 'v_icon'));
        $user = $root['user'];
        $root['user']['nick_name'] = $user['nick_name'] ? $user['nick_name'] : $user_id;
        $root['user']['sex'] = $user['sex'] ? $user['sex'] : 0;
        $root['user']['ticket'] = intval($user['ticket']) ? intval($user['ticket']) : '';
        $root['user']['user_level'] = $user['user_level'] ? $user['user_level'] : '1';
        $root['user']['v_type'] = $user['v_type'] ? $user['v_type'] : '';
        $root['user']['v_icon'] = $user['v_icon'] ? $user['v_icon'] : '';
        $root['user']['user_id'] = $user_id;
        $root['user']['head_image'] = get_spec_image($root['user']['head_image']);
        if ($page == 0) {
            $root['has_next'] = 0;
        } else {
            if ((count($user_list) == $page_size)) {
                $root['has_next'] = 1;
            } else {
                $root['has_next'] = 0;
            }
        }
        $root['status'] = 1;
        return $root;
    }

    /*
     * 获取当前主播 最多贡献
     *
     */
    /**
     * 处理用户基础信息
     */
    private function handleUserInfo($user, $user_id = '', $is_noble = false)
    {
        $m_config = load_auto_cache("m_config");

        if ($is_noble && $user['noble_time'] > NOW_TIME) {
            $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
            if ($jurisdiction && $user['is_noble_ranking_stealth'] == 1) {
                $user['nick_name'] = noble_mysterious_name($user_id, $user['create_time']);
                $user['head_image'] = $m_config['mysterious_picture'];
            }
        }

        $user['head_image'] = get_spec_image($user['head_image']);
        $user['nick_name'] = $user['nick_name'] ? $user['nick_name'] : $user_id;
        $user['sex'] = $user['sex'] ? $user['sex'] : '0';
        $user['user_level'] = $user['user_level'] ? $user['user_level'] : '1';
        $user['v_type'] = $user['v_type'] ? $user['v_type'] : '';
        $user['v_icon'] = $user['v_icon'] ? $user['v_icon'] : '';

        return $user;
    }

    /**
     * 获取主播贡献榜
     * @param string $type 榜单类型：total-总榜，day-日榜
     */
    public function get_podcast_contribute($podcast_id, $page = 1, $page_size = 20, $is_only_list = false, $type = 'total')
    {
        $root = ['status' => 1, 'page' => max(1, intval($page))];
        $start = ($root['page'] - 1) * $page_size;
        $end = $root['page'] * $page_size - 1;

        // 根据类型选择不同的贡献榜key
        $contribution_key = $type == 'day' ?
            $this->user_day_contribution . $podcast_id :
            $this->user_contribution . $podcast_id;

        // 获取排行数据
        $user_num_array = $this->redis->zRevRange($contribution_key, $start, $end, true);
        $user_keys = array_keys($user_num_array);
        $user_list_array = $this->redis->hMGet($this->user_hash_db, $user_keys);
        $user_list = array();

        $root['total_num'] = intval($this->redis->zCard($contribution_key));

        if (is_array($user_list_array)) {
            foreach ($user_list_array as $k => $v) {
                if ($v) {
                    $user = $this->redis->hMGet($this->user_db . $k, [
                        'id',
                        'nick_name',
                        'sex',
                        'head_image',
                        'ticket',
                        'no_ticket',
                        'user_level',
                        'v_type',
                        'v_icon',
                        'noble_time',
                        'nobleid',
                        'is_noble_ranking_stealth',
                        'is_noble_mysterious',
                        'create_time'
                    ]);

                    $user_con = $this->handleUserInfo($user, $k, true);
                    $user_con['user_id'] = $k;
                    $user_con['num'] = $user_num_array[$k];
                    $user_con['use_ticket'] = intval($user_num_array[$k]);

                    if ($user['noble_time'] > NOW_TIME) {
                        $user_con['is_noble_mysterious'] = $user['is_noble_mysterious'];
                        $user_con['is_noble_ranking_stealth'] = $user['is_noble_ranking_stealth'];
                    } else {
                        $user_con['is_noble_mysterious'] = 0;
                        $user_con['is_noble_ranking_stealth'] = 0;
                    }

                    $user_list[] = $user_con;
                }
            }
        }

        if ($is_only_list) {
            return $user_list;
        }

        $root['list'] = $user_list;

        // 获取主播信息
        $user = $this->redis->hMGet($this->user_db . $podcast_id, [
            'id',
            'nick_name',
            'sex',
            'head_image',
            'ticket',
            'no_ticket',
            'user_level',
            'v_type',
            'v_icon',
            'noble_time',
            'is_noble_ranking_stealth',
            'is_noble_mysterious',
            'create_time'
        ]);

        $root['user'] = $this->handleUserInfo($user, $podcast_id);
        $root['user']['user_id'] = $podcast_id;
        $root['user']['ticket'] = intval($user['ticket'] + $user['no_ticket']) ?: '';

        $root['has_next'] = count($user_list) == $page_size ? 1 : 0;
        $root['rs_count'] = count($user_num_array);

        return $root;
    }
}
