<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class VideoViewerRedisService extends BaseRedisService
{
    //var $video_viewer_level_db;//:video_id  zset 房间观众列表,user_id:会员级别

    /**
     *
     * +----------------------------------------------------------
     * 架构函数
     * +----------------------------------------------------------
     * @access public
     * +----------------------------------------------------------
     */
    public function __construct()
    {
        parent::__construct();

        //注：本redis只产生了一个：video_viewer_level_db 数据；观众列表
    }

    /*
     * 新会员进入
     */
    public function member_join($post)
    {
        $GroupId = $post['GroupId'];
        $video_id = $this->redis->hGet($this->video_group_db, $GroupId);
        if (!$video_id) {
            return false;
        }
        $video = $this->redis->hMGet($this->video_db . $video_id, array('room_type', 'virtual_number', 'robot_num', 'watch_number', 'user_id', 'id'));

        //前台展示的观众列表数量
        $now_num = $video['robot_num'] + $video['watch_number'];

        //新入群成员列表
        foreach ($post['NewMemberList'] as $k => $v) {
            $user_id = $v['Member_Account'];

            $user_db = $this->redis->hMGet($this->user_db . $user_id, array('user_level', 'is_robot', 'is_authentication', 'nobleid', 'noble_time', 'is_noble_stealth', 'is_noble_mysterious', 'id', 'head_image', 'thumb_head_image', 'nick_name'));

            $sort_num = $user_db['user_level'] * $this->gz_level_weight;
            if ($user_db['is_robot'] == 0) {
                $sort_num += $this->gz_real_weight;
            }
            if ($user_db['is_authentication'] == 2) {
                $sort_num += $this->gz_rz_weight;
            }

            if ($sort_num < 1) $sort_num = 1;

            //过滤重复加入的
            if ($this->redis->zAdd($this->video_viewer_level_db . $video_id, $sort_num, $user_id) > 0) {

                $now_num += 1;
                $virtual_number = 0;

                //非私密直播,1个真实用户进来,带一些机器人;且只有观众列表数大于6时，才加
                if ($video['room_type'] != 1 && $now_num >= 0 && intval($video['virtual_number']) > 0) {

                    $start_num = intval($video['virtual_number'] / 2) ? intval($video['virtual_number'] / 2) : 2;
                    $virtual_number = rand($start_num, $video['virtual_number']);

                    //添加虚拟人数
                    $this->redis->hIncrBy($this->video_db . $video_id, 'virtual_watch_number', $virtual_number);
                }

                //私密直播间主播进入不添加人数
                if ($video['room_type'] != 1 || ($video['room_type'] == 1 && $user_id != $video['user_id'])) {
                    //一个实际人数+虚拟人数
                    $virtual_number += 1;
                }
                $this->redis->hIncrBy($this->video_db . $video_id, 'max_watch_number', $virtual_number);

            }
            //hMGet
            //实际观众数统计：累计观众列表和; [score 为负数是：机器人; 正数是：真实观众]
            if ($video['room_type'] == 1 || $video['room_type'] == 3) {
                $watch_number = $this->redis->zCount($this->video_viewer_level_db . $video_id, '1', '+inf');
                $this->redis->hSet($this->video_db . $video_id, 'watch_number', $watch_number);
            }

            //添加用户是否是贵族缓存
            if ($user_db['noble_time'] > time() && $user_db['nobleid'] > 0) {
                $this->redis->hSet($this->video_db . "noble:" . $video_id, $user_id, json_encode($user_db));
            }
            $this->end_wheat_position($user_id, $video);// 下麦
        }

        $redis_key = "member_exit_list";
        redis_zrem($redis_key, $video_id);

        return true;
    }

    /*
     * 子房间观众加入
     */
    public function child_room_member_join($post, $video_id)
    {
        $video = $this->redis->hMGet($this->video_db . $video_id,
            array('room_type', 'virtual_number', 'robot_num', 'watch_number'));

        //前台展示的观众列表数量
        $now_num = $video['robot_num'] + $video['watch_number'];

        //新入群成员列表
        foreach ($post['NewMemberList'] as $k => $v) {
            $user_id = $v['Member_Account'];

            $user_db = $this->redis->hMGet($this->user_db . $user_id,
                array('user_level', 'is_robot', 'is_authentication'));

            $sort_num = $user_db['user_level'] * $this->gz_level_weight;
            if ($user_db['is_robot'] == 0) {
                $sort_num += $this->gz_real_weight;
            }
            if ($user_db['is_authentication'] == 2) {
                $sort_num += $this->gz_rz_weight;
            }

            if ($sort_num < 1) {
                $sort_num = 1;
            }

            //过滤重复加入的
            if ($this->redis->zAdd($this->video_viewer_level_db . $video_id, $sort_num, $user_id) > 0) {
                $now_num += 1;
                $virtual_number = 0;

                //非私密直播,1个真实用户进来,带一些机器人;且只有观众列表数大于6时，才加
                if ($video['room_type'] != 1 && $now_num > 6 && intval($video['virtual_number']) > 0) {

                    $start_num = intval($video['virtual_number'] / 2) ? intval($video['virtual_number'] / 2) : 2;

                    $virtual_number = rand($start_num, $video['virtual_number']);

                    //添加虚拟人数
                    $this->redis->hIncrBy($this->video_db . $video_id, 'virtual_watch_number', $virtual_number);
                }

                //一个实际人数+虚拟人数
                $virtual_number += 1;
                $this->redis->hIncrBy($this->video_db . $video_id, 'max_watch_number', $virtual_number);
            }

            //实际观众数统计：累计观众列表和; [score 为负数是：机器人; 正数是：真实观众]
            if ($video['room_type'] == 1 || $video['room_type'] == 3) {
                $watch_number = $this->redis->zCount($this->video_viewer_level_db . $video_id, '1', '+inf');
                $this->redis->hSet($this->video_db . $video_id, 'watch_number', $watch_number);
            }
        }
    }

    /*
     * 会员离开
     */
    public function member_exit($post, $type = 0)
    {

        $GroupId = $post['GroupId'];
        $video_id = $this->redis->hGet($this->video_group_db, $GroupId);
        if (!$video_id) {
            return false;
        }


        $video = $this->redis->hMGet($this->video_db . $video_id, array('room_type', 'virtual_number', 'virtual_watch_number', 'id'));
        if (intval($video['virtual_number']) > 0) {
            $number = intval($video['virtual_number'] / 2) ? intval($video['virtual_number'] / 2) : 2;
        } else {
            $number = 0;
        }


        $virtual_watch_number = intval($video['virtual_watch_number']);

        //退出群的成员列表
        foreach ($post['ExitMemberList'] as $k => $v) {
            $user_id = $v['Member_Account'];
            //用户移除成功
            if ($this->redis->zRem($this->video_viewer_level_db . $video_id, $user_id) > 0) {

                if ($video['room_type'] != 1 && $virtual_watch_number > 0) {
                    //随机减少一些虚拟人数
                    $virtual_number = rand(1, $number);
                    if ($virtual_number > $virtual_watch_number) {
                        $virtual_number = $virtual_watch_number;
                    }

                    $this->redis->hIncrBy($this->video_db . $video_id, 'virtual_watch_number', -$virtual_number);

                    $virtual_watch_number = intval($this->redis->hGet($this->video_db . $video_id, 'virtual_watch_number'));
                    if ($virtual_watch_number < 0) {
                        $virtual_watch_number = 0;
                        $this->redis->hSet($this->video_db . $video_id, 'virtual_watch_number', 0);
                    }
                }
            }

            //实际观众数统计：累计观众列表和; [score 为负数是：机器人; 正数是：真实观众]
            if ($video['room_type'] == 1 || $video['room_type'] == 3) {
                $watch_number = $this->redis->zCount($this->video_viewer_level_db . $video_id, '1', '+inf');
                $this->redis->hSet($this->video_db . $video_id, 'watch_number', $watch_number);
            }

            //删除用户是否是贵族缓存
            $this->del_user_noble($video_id, $user_id);

        }
        $watch_number = $this->redis->zCount($this->video_viewer_level_db . $video_id, '1', '+inf');

        if (isset($video['is_voice']) && $video['is_voice'] == 1 && $watch_number <= 0) {
            // 房间没有用户执行--定时器执行操作
            redis_zadd("member_exit_list", NOW_TIME, $video_id);
        }


        if (defined('CHILD_ROOM') && CHILD_ROOM == 1) {
            // 退出则所有房间退出
            $list = $this->redis->sMembers('video_child_room_' . $video_id);

            foreach ($list as $child_id) {
                $this->child_room_member_exit($post, $child_id);
            }
        }
        if ($type) {
            // 离开房间清楚用户在直播间缓存
            $this->redis->delete("room_user_status:" . $user_id);
            // 退出房间人数
            $this->end_wheat_position($user_id, $video);// 更新上下线
        }
    }

    /**
     * 删除个人缓存
     * */
    public function del_voice_one($video_id, $user_id)
    {
        return $this->redis->zRem($this->video_viewer_level_db . $video_id, $user_id);
    }

    /**
     * 获取数量
     * */
    public function get_voice_count($video_id)
    {
        return $this->redis->zCount($this->video_viewer_level_db . $video_id, '1', '+inf');
    }

    /**
     *  删除会员用户上线或掉线缓存
     * @param $user_id
     */
    public function del_user_online($user_id)
    {
        $this->redis->hDel($this->user_online, $user_id);
    }

    /**
     * 获取要修改的会员用户上线或掉线缓存
     */
    public function get_user_online()
    {
        return $this->redis->hGetAll($this->user_online);
    }

    /**
     * 更新上下线缓存
     * @param $user_id
     */
    public function end_wheat_position($user_id, $video)
    {
        $data = array(
            'uid'             => $user_id,
            'is_online'       => 1,
            'is_handle'       => 0, // 是否处理上下线状态1更新上下线 0否(这个地方需要处理麦位)
            'is_watch_number' => 1, // 是否更新观看人数
            'video_id'        => $video['id'],
            'login_time'      => NOW_TIME
        );
        // 存入缓存 -- 服务端定时器执行修改
        $this->redis->hSet($this->user_online, $user_id, json_encode($data));
    }

    /**
     * 会员上线或掉线缓存修改状态
     * @param $user_id
     * @param $action
     */
    public function add_user_online($user_id, $action)
    {
        $status = -1;// 在线状态
        require_once APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php';
        require_once APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php';
        $video_viewer = new VideoViewerRedisService();
        $videos = $video_viewer->redis->get("room_user_status:" . $user_id);
        if ($action == 'Login') {
            $status = 1;// 修改在线状态
        } elseif ($action == 'Logout' || $action == 'Disconnect' || $action == 'TimeOut') {
            // 掉线--离线 处理
            $status = 0;
            // 离开房间清楚用户在直播间缓存
            $video_viewer->redis->delete("room_user_status:" . $user_id);
        }
        if ($status >= 0) {
            $video_id = 0;
            if ($videos) {
                $videos = json_decode($videos, true);
                $video_id = $videos['id'];
            }
            $data = array(
                'uid'             => $user_id,
                'is_online'       => $status,
                'is_handle'       => 1, // 是否处理上下线状态1更新上下线 0否(这个地方需要处理麦位)
                'is_watch_number' => 1, // 是否更新观看人数
                'video_id'        => $video_id,
                'login_time'      => NOW_TIME
            );
            // 存入缓存 -- 服务端定时器执行修改
            $video_viewer->redis->hSet($this->user_online, $user_id, json_encode($data));
        }
    }

    /*
    * 子房间会员离开
    */
    public function child_room_member_exit($post, $video_id)
    {
        $video = $this->redis->hMGet($this->video_db . $video_id, array('room_type', 'virtual_number', 'virtual_watch_number',));
        if (intval($video['virtual_number']) > 0) {
            $number = intval($video['virtual_number'] / 2) ? intval($video['virtual_number'] / 2) : 2;
        } else {
            $number = 0;
        }

        $virtual_watch_number = intval($video['virtual_watch_number']);

        //退出群的成员列表
        foreach ($post['ExitMemberList'] as $k => $v) {
            $user_id = $v['Member_Account'];
            //用户移除成功
            if ($this->redis->zRem($this->video_viewer_level_db . $video_id, $user_id) > 0) {
                if ($video['room_type'] != 1 && $virtual_watch_number > 0) {
                    //随机减少一些虚拟人数
                    $virtual_number = rand(1, $number);
                    if ($virtual_number > $virtual_watch_number) {
                        $virtual_number = $virtual_watch_number;
                    }

                    $this->redis->hIncrBy($this->video_db . $video_id, 'virtual_watch_number', -$virtual_number);

                    $virtual_watch_number = intval($this->redis->hGet($this->video_db . $video_id,
                        'virtual_watch_number'));
                    if ($virtual_watch_number < 0) {
                        $virtual_watch_number = 0;
                        $this->redis->hSet($this->video_db . $video_id, 'virtual_watch_number', 0);
                    }
                }
            }
        }
    }

    /**
     *  获取直播间中的贵族列表
     */
    public function get_noble_list($video_id)
    {
        $video_id = $this->redis->hGetAll($this->video_db . "noble:" . $video_id);

        return $video_id;
    }

    /**
     *  获取存储缓存
     */
    public function set_redis_one($name, $val)
    {
        return $this->redis->set($name, $val);
    }

    /**
     *  获取存储缓存
     */
    public function get_redis_one($name)
    {
        return $this->redis->get($name);
    }

    /**
     *  删除直播间中的贵族用户
     */
    public function del_user_noble($video_id, $user_id)
    {
        $this->redis->hDel($this->video_db . "noble:" . $video_id, $user_id);
    }

    /**
     *  添加直播间中的贵族列表
     */
    public function get_noble_list_add($video_id, $user_id, $user_db)
    {


        $user_db['noble_maybe'] = 0;                    //贵族坐席

        $jurisdiction = load_auto_cache("noble_id", ['id' => $user_db['nobleid']]);
        if ($user_db['noble_time'] >= NOW_TIME) {
            $user_db['noble_name'] = $jurisdiction['name'];            //贵族名称
            $user_db['noble_icon'] = $jurisdiction['icon'];         //贵族图标
            $user_db['noble_avatar'] = $jurisdiction['avatar_img'];   //贵族头像图片
            $user_db['sort'] = $jurisdiction['sort'];   //排序

            // 是否有贵族坐席
            $user_db['noble_maybe'] = $jurisdiction['is_seats'];

            $video_id = $this->redis->hSet($this->video_db . "noble:" . $video_id, $user_id, json_encode($user_db));

            return $video_id;
        }
    }

    /**
     *  获取直播间中的贵族数量
     */
    public function get_noble_list_sum($video_id)
    {

        $video_ids = $this->redis->hLen($this->video_db . "noble:" . $video_id);

        return $video_ids;
    }

    /*
     * 获取热门视频
     */
    public function get_viewer_list($GroupId, $page = 0, $page_size = 200)
    {


        $video_id = $this->redis->hGet($this->video_group_db, $GroupId);
        if (!$video_id) {
            return array(
                'list'     => array(),
                'has_next' => 0,
                'page'     => 1,
                'status'   => 1
            );
        } else {
            return $this->get_viewer_list2($video_id, $page, $page_size);
        }
    }

    /*
     * 是否在当前房间用户列表 
     * 
     */
    public function existence_viewer_list($video_id, $user_id)
    {
        $root = array();
        $root['video_viewer_level_score'] = $this->redis->zScore($this->video_viewer_level_db . $video_id, $user_id);
        return $root;
    }

    /**
     * 获取热门视频
     */
    public function get_viewer_list2($video_id, $page = 0, $page_size = 200)
    {

        $root = array();
        if ($page == 0) {
            $page = 1;
        }
        $root['page'] = $page;
        $start = ($page - 1) * $page_size;
        $end = $page * $page_size - 1;

        $user_keys = $this->redis->zRevRange($this->video_viewer_level_db . $video_id, $start, $end, false);

        $user_list_array = $this->redis->hMGet($this->user_hash_db, $user_keys);

        $user_list = array();
        if (is_array($user_list_array)) {
            $m_config = load_auto_cache("m_config");
            // 用户信息
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            foreach ($user_list_array as $k => $v) {
                if ($v) {

                    $user = json_decode($v, true);
                    //移除异常数据
                    if (!$k) {
                        $this->redis->zRem($this->video_viewer_level_db . $video_id, $k);
                        continue;
                    }
                    $user_ids = $this->redis->hGet($this->video_db . "noble:" . $video_id, $k);

                    $user2 = array();
                    $user2['noble_avatar'] = '';
                    $user2['ranking_one'] = 0;
                    $user2['noble_id'] = 0;
                    //隐身
                    $is_noble_stealth = 0;
                    //贵宾座席
                    $noble_maybe = 0;
                    //是否开启了神秘人
                    $is_noble_mysterious = 0;
//                    $sql = "select * from " . DB_PREFIX . "user where id = " . $k;
//                    $user_one = $GLOBALS['db']->getRow($sql, true, true);

                    // 获取用户缓存中的信息
                    $user_one = $user_redis->getRow_db($k, ['avatar_frame_id', 'noble_time', 'nobleid', 'is_noble_stealth', 'is_noble_mysterious', 'avatar_frame_id']);


                    // 头像框
                    $user2['avatar_frame_url'] = get_avatar_frame_url($k, $user_one['avatar_frame_id']);

                    if ($user_ids) {
                        if ($user_one['noble_time'] >= NOW_TIME) {
                            $user2['noble_id'] = $user_one['nobleid'];
                            $jurisdiction = load_auto_cache("noble_id", ['id' => $user_one['nobleid']]);
                            // 贵族到期时间
                            if ($jurisdiction) {
                                //3头像框
                                if ($jurisdiction['is_hesder'] == 1) {
                                    //贵族头像图片
                                    $user2['noble_avatar'] = $jurisdiction['avatar_img'];
                                }
                                if ($jurisdiction['is_ranking'] == 1) {
                                    // 9排名靠前
                                    $user2['ranking_one'] = 1;
                                }
                                // 是否开启隐身
                                $is_noble_stealth = $jurisdiction['is_stealth_approach'] == 1 ? $user_one['is_noble_stealth'] : 0;
                            } else {
                                //获取贵族头像和名称  === 老版本
                                $sql = "select * from " . DB_PREFIX . "noble_classification where id = " . $user_one['nobleid'] . " and status=1";
                                $noble = $GLOBALS['db']->getRow($sql, true, true);
                                //贵族头像图片
                                $user2['noble_avatar'] = $noble['title_img'];

                                if ($noble['type']) {
                                    $sql = "select * from " . DB_PREFIX . "noble_type where status=1 and id in (" . $noble['type'] . ") order by sort asc";
                                    $noble_type = $GLOBALS['db']->getAll($sql, true, true);
                                    foreach ($noble_type as $v2) {
                                        if ($v2['type'] == 5) {
                                            $noble_maybe = 1;
                                        }
                                        if ($v2['type'] == 10) {
                                            $is_noble_stealth = $user_one['is_noble_stealth'];
                                        }
                                        if ($v2['type'] == 13) {
                                            $is_noble_mysterious = $user_one['is_noble_mysterious'];
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if ($is_noble_mysterious == 1 && $noble_maybe == 1) {
                        // 更换神秘人头像
                        $user['head_image'] = $m_config['mysterious_picture'];
                        $user['nick_name'] = noble_mysterious_name($v['id'], $user['create_time']);
                    }
                    //是否开启了神秘人
                    $user2['is_noble_mysterious'] = $is_noble_mysterious;
                    $user2['user_id'] = $k;
                    $user2['user_level'] = $user['user_level'];
                    $user2['is_robot'] = $user['is_robot'];
                    $user2['nick_name'] = $user['nick_name'] ? $user['nick_name'] : '';
                    $user2['nick_name'] = htmlspecialchars_decode($user2['nick_name']);
                    $user2['head_image'] = get_spec_image($user['head_image'], 150, 150);
                    $user2['v_icon'] = $user['v_icon'];
                    $user2['is_authentication'] = $user['is_authentication'];
                    $user2['sex'] = intval($user['sex']) == 2 ? 2 : 1;
                    if ($is_noble_stealth != 1) {
                        // 是否开启了隐藏
                        $user_list[] = $user2;
                    }
                }

            }
        }
        $distance = array();
        // 取得列的列表
        foreach ($user_list as $key => $row) {
            $distance[$key] = $row['ranking_one'];
        }
        if ($distance) {
            array_multisort($distance, SORT_DESC, $user_list);
        }

        $root['list'] = $user_list;

        if ($page == 0) {
            $root['has_next'] = 0;
        } else {
            if ((count($user_keys) == $page_size)) {
                $root['has_next'] = 1;
            } else {
                $root['has_next'] = 0;
            }
        }
        $root['status'] = 1;
        $root['list_number'] = $this->redis->zCard($this->video_viewer_level_db . $video_id);
        //$root['watch_number'] =  $this->redis->zScore($this->video_watch_sort,$video_id);
        $root['watch_number'] = $this->get_video_watch_num($video_id);
        if ($root['watch_number'] <= 0) {
            $root['watch_number'] = intval(count($root['list']));
        }
        return $root;
    }

    public function get_watch_number($video_id)
    {
        return $this->redis->zCard($this->video_viewer_level_db . $video_id);
    }

    public function get_video_watch_num($vedio_id)
    {
        $video_data = $this->redis->hMGet($this->video_db . $vedio_id, array('virtual_watch_number', 'robot_num', 'watch_number'));
        $virtual_watch_number = $video_data['virtual_watch_number'];
        $robot_num = $video_data['robot_num'];
        $watch_num = $video_data['watch_number'];
        $num = $virtual_watch_number + $watch_num + $robot_num;
        return $num;
    }

}//类定义结束

?>