<?php



//商城模块
class shopModule extends baseModule
{

    //商品分类
    public function class_list()
    {
        $root = array('status' => 1, 'error' => '');
        $lists = $GLOBALS['db'] -> getAll('select `id`,`name`,`img`,`level` from '.DB_PREFIX.'shop_class where status = 1 and level = 1 order by sort desc');//一级分类
        if(count($lists)>0){
            foreach($lists as &$v){
                $child = $GLOBALS['db'] -> getAll('select  `id`,`name`,`img`,`level` from '.DB_PREFIX.'shop_class where status = 1  and `level` = 2 and  parentId = '.$v['id'].' order by sort desc'); //所有的二级分类
                $v['child'] = $child;
            }
        }
        $root['data'] = $lists;
        ajax_return($root);
    }

    //商品首页
    public function index()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $user_info = strim($_REQUEST['token'])?get_user_token_info(strim($_REQUEST['token'])):$GLOBALS['user_info'];
        $page = $_REQUEST['page'];
        $cid = $_REQUEST['cate']?$_REQUEST['cate']:0;
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $title[] = ['id' =>0,'name' => '精选'];
        $cate = $GLOBALS['db'] -> getAll('select `id`,`name` from '.DB_PREFIX.'shop_class where status = 1 and `level` = 1 order by sort desc');
        $lists = array_merge($title,$cate); //标题

        $banner = $GLOBALS['db'] -> getAll('select `id`,`img`,`show_id`,`url`,`type` from '.DB_PREFIX.'shop_banner where status = 1 order by sort desc'); //banner 图

        $page = $page == 0 ? 1 : $page;

        $page_size = 50;

        $limit = (($page - 1) * $page_size) . "," . $page_size;

        if($cid>0){
            $class = $GLOBALS['db'] -> getAll('select `id`,`name` from '.DB_PREFIX.'shop_class where status = 1 and `parentId` = '.$cid.' order by sort desc ');
            $where = ' and cid in('.implode(',',array_column($class,'id')).')';
        }else{
            $where = ' and id>0';
        }

        $goods = $GLOBALS['db'] -> getAll('select `id`,`img`,`price`,`title`,`sale` from '.DB_PREFIX.'shop_goods where status = 1 '.$where.' order by sale desc  limit ' .$limit); //商品列表

        $data = [
            'title' => $lists,
            'banner' => $banner,
            'goods' => $goods,
        ];
        $root['list'] = $data;
        api_ajax_return($root);
    }

    //商品搜索记录
    public function search_index()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $user_info = strim($_REQUEST['token'])?get_user_token_info(strim($_REQUEST['token'])):$GLOBALS['user_info'];
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $lists = $GLOBALS['db'] -> getAll('select `title` from '.DB_PREFIX.'shop_search where uid = '.$user_info['id']);

        $root['list'] = $lists;
        api_ajax_return($root);
    }

    //商品搜索
    public function search()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $keyword = $_REQUEST['keyword'];
        $user_info = strim($_REQUEST['token'])?get_user_token_info(strim($_REQUEST['token'])):$GLOBALS['user_info'];
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        if(empty($keyword)){
            $root['error'] = "请输入搜索的关键字";
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $lists = $GLOBALS['db'] -> getAll('select `id`,`title`,`sale`,`img`,`is_self` from '.DB_PREFIX."shop_goods where title like '%".$keyword."%'");

        //有搜索记录不存
        $log = $GLOBALS['db'] -> getRow('select * from '.DB_PREFIX.'shop_search where uid = '.$user_info['id']." and title = '".$keyword."'");

        if(count($lists)>0 && empty($log)){
            $sql = "insert into ".DB_PREFIX."shop_search (uid,title,addtime) values (".$user_info['id']." ,'" .$keyword."' , " .time().")";
            $GLOBALS['db'] -> query($sql); //添加搜索记录
        }
        $root['list'] = $lists;
        api_ajax_return($root);
    }

    //删除搜索记录
    public function del_search()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $user_info = strim($_REQUEST['token'])?get_user_token_info(strim($_REQUEST['token'])):$GLOBALS['user_info'];
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $sql = "delete from ".DB_PREFIX.'shop_search where uid = '.$user_info['id'];
        $lists = $GLOBALS['db'] -> query($sql);
        if(!$lists){
            $root['error'] = "请刷新后再试";
            $root['status'] = 0;
        }
        api_ajax_return($root);
    }


    //商品分类列表
    public function cate_list()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $cid = $_REQUEST['cid']; //商品分类
        $type = intval($_REQUEST['type'])?intval($_REQUEST['type']):0;//0综合排序；1销量；2价格
        $o = intval($_REQUEST['o'])?intval($_REQUEST['o']):0; //1倒叙；0正序
        $page = intval($_REQUEST['page']); //分页
        $user_info = strim($_REQUEST['token'])?get_user_token_info(strim($_REQUEST['token'])):$GLOBALS['user_info'];
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $page = $page == 0 ? 1 : $page;
        $page_size = 50;
        $limit =  " limit ".(($page - 1) * $page_size) . "," . $page_size;

        if($type == 1){ //销量
            $c = $o==0?'asc':'desc';
            $order = " order by sale ".$c;
        }elseif ($type == 2){ //价格
            $a = $o==0?'asc':'desc';
            $order = " order by price ".$a;
        }else{
            $order = " order by id desc ";
        }


        $lists = $GLOBALS['db'] -> getAll('select `id`,`title`,`sale`,`img`,`is_self`,`price` from '.DB_PREFIX."shop_goods where cid = ".$cid .$order.$limit);

        $root['list'] = $lists;
        api_ajax_return($root);
    }

    //商品详情
    public function goods()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $user_info = strim($_REQUEST['token'])?get_user_token_info(strim($_REQUEST['token'])):$GLOBALS['user_info'];
        $id = intval($_REQUEST['id']); //商品id
        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
        }
        $list = $GLOBALS['db'] -> getRow('select * from '.DB_PREFIX.'shop_goods where id = '.$id);
        if($list['status'] != 1){
            $root['error'] = '此商品已下架';
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $attr = $GLOBALS['db'] -> getAll('select `id`,`name`,`original_price`,`price`,`stock`,`sales` from '.DB_PREFIX.'shop_attr where gid = '.$list['id'].' and status = 1 order by sa_order desc');
        $list['attr'] = $attr;
        $root['list'] = $list;
        api_ajax_return($root);
    }

}