<?php

/**
 * 红包
 * */
class surpriseModule extends baseModule
{
    private $dbNameLiveSurprise = 'live_surprise';
    private $dbNameLiveSurpriseLog = 'live_surprise_log';

    public function __construct()
    {
        parent::__construct();

        // 直播ID
        $video_id = get_input('video_id', 'n');

        // 有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        $this->checkUserLogin();

    }

    /**
     * 发红包
     *
     * */
    public function requestSendSurprise()
    {
        // 钻石数量
        $surpriseDiamonds = get_input('diamonds', 'n');
        // 份数
        $peopleQuantity = get_input('people_quantity', 'n');
        // 直播ID
        $video_id = get_input('video_id', 'n');
        // 内容
        $content = get_input('content');
        $m_config = load_auto_cache("m_config");
        if($m_config['red_envelope_switch'] == 0){
            $return['error'] = api_lang('feature_has_been_turned_off');
            $return['status'] = 0;
            ajax_return($return);
        }
        if ($peopleQuantity <= 0) {
            $return['error'] = api_lang('red_envelope_is_not_less_than_0');
            $return['status'] = 0;
            ajax_return($return);
        }
        if($m_config['red_min_number'] != 0 && $m_config['red_max_number'] !=0) {
            if($surpriseDiamonds < $m_config['red_min_number'] || $surpriseDiamonds > $m_config['red_max_number']){
                $str = api_lang("red_envelope_quantity_limit");
                $str = str_replace("{mincoin}", $m_config['red_min_number'], $str);
                $return['error'] = str_replace("{maxcoin}", $m_config['red_max_number'], $str);
                $return['status'] = 0;
                ajax_return($return);
            }
        }
        if($m_config['red_min_people'] !=0 && $m_config['red_max_people'] !=0) {
            if ($peopleQuantity < $m_config['red_min_people'] || $peopleQuantity > $m_config['red_max_people']) {
                $str = api_lang("red_envelope_people_limit");
                $str = str_replace("{mincoin}", $m_config['red_min_people'], $str);
                $return['error'] = str_replace("{maxcoin}", $m_config['red_max_people'], $str);
                $return['status'] = 0;
                ajax_return($return);
            }
        }
        // 判断是否足矣分成设置的份数
        if ($surpriseDiamonds < $peopleQuantity) {
            //$return['error'] = '钻石数量与份数不匹配！';
            $return['error'] = api_lang('quantity_not_match_number_copies');
            $return['status'] = 0;
            ajax_return($return);
        }


        // 判断余额是否足够
        // 获取当前余额
        $diamonds = dbGetOneFiled('user', 'diamonds', ['id' => $this->loginUserId]);
        if ($diamonds < $surpriseDiamonds) {
            //$return['error'] = '余额不足！';
            $return['error'] = api_lang('insufficient_balance');
            $return['status'] = 0;
            ajax_return($return);
        }

        $red_handling_fee = intval($m_config['red_handling_fee']) > 0 ? intval($m_config['red_handling_fee']) : 0;
        $platform_diamonds = 0;
        $surpriseDiamonds1 = $surpriseDiamonds;
        if($red_handling_fee){
            $red_handling_fee_val = $red_handling_fee / 100;
            $platform_diamonds = ceil($red_handling_fee_val * $surpriseDiamonds);
            $surpriseDiamonds1 = $surpriseDiamonds1 - $platform_diamonds;
        }
        if($surpriseDiamonds1 <= 0){
            $return['error'] = api_lang('扣除手续费后不足1个红包');
            $return['status'] = 0;
            ajax_return($return);
        }

        // 扣除余额
        $deductDiamonds = dbUpdate('user', ['id' => $this->loginUserId], "diamonds = diamonds - " . $surpriseDiamonds . ",use_diamonds = use_diamonds + " . $surpriseDiamonds);
        if (!$deductDiamonds) {
            $return['error'] = api_lang('insufficient_balance');
            $return['status'] = 0;
            ajax_return($return);
        }

        user_deal_to_reids(array($this->loginUserId));

        $return['balance_diamonds'] = ($diamonds - $surpriseDiamonds);
        $return['deduct_diamonds'] = $surpriseDiamonds;

        // 开始发红包
        $surpriseData = [
            'user_id' => $this->loginUserId,
            'video_id' => $video_id,
            'diamonds_quantity' => $surpriseDiamonds1,
            'people_quantity' => $peopleQuantity,
            'desc_content' => $content,
            'start_time' => NOW_TIME,
            'create_time' => NOW_TIME,
            'platform_diamonds' => $platform_diamonds,
            'platform_fee' => $red_handling_fee
        ];

        // 插入红包数据
        $addResult = dbInsert($this->dbNameLiveSurprise, $surpriseData, true);
        if ($addResult) {
            // 消费和收益记录表
            add_user_consumption_log($this->loginUserId, 0, $surpriseDiamonds, api_lang("发红包"), 0, 0, 22);
            // 实际可以分成的份数
            $surpriseList = $this->red_rand_list2($surpriseDiamonds1, $peopleQuantity);
            $money_list = [];
            foreach ($surpriseList as $v) {
                $item = ['surprise_id' => $addResult, 'video_id' => $video_id, 'diamonds_quantity' => $v, 'create_time' => NOW_TIME];
                $money_list[] = dbInsert($this->dbNameLiveSurpriseLog, $item,true);
            }
            // 红包存入缓存队列
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
            $videoRed_redis = new VideoRedRedisService();
            $videoRed_redis->push_red("surprise_".$addResult, $money_list);

            // 开始发送IM消息到客户端群组
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $group = $video_redis->getRow_db($video_id, array('group_id'));

            //查询直播记录
            $sql = "select id,user_id,group_id,prop_table,room_type from " . DB_PREFIX . "video where id = " . $video_id;
            $video = $GLOBALS['db']->getRow($sql);

            if ($group && $group['group_id']) {
                $group_id = strim($group['group_id']);//群组ID
            } else {
                $group_id = strim($video['group_id']);//群组ID
            }

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_info = $user_redis->getRow_db($this->loginUserId, array('nick_name', 'head_image', 'user_level', 'v_icon', 'is_gift_giving', 'nobleid', 'noble_time'));

            // 发送红包的IM消息
            $this->sendRedIMMsg($this->loginUserId, $group_id, $addResult, $user_info['nick_name'], $user_info['head_image']);

        }

        $return['error'] = '';
        $return['status'] = 1;
        ajax_return($return);
    }

    /**
     * 抢红包
     * */
    public function requestGetSurprise()
    {
        // 直播ID
        $video_id = get_input('video_id', 'n');
        // 红包ID
        $surpriseId = get_input('surprise_id', 'n');
        //查询直播记录
        $sql = "select id,user_id,group_id,prop_table,room_type,is_voice from " . DB_PREFIX . "video where id = " . $video_id;
        $video = $GLOBALS['db']->getRow($sql);
        // 检查红包是否存在
        $surpriseData = dbGetAll($this->dbNameLiveSurprise, '', [], true, [], ['id' => $surpriseId]);
        if (!$surpriseData) {
            //$return['error'] = '红包记录不存在';
            $return['error'] = api_lang('red_packet_record_not_exist');
            $return['status'] = 0;
            ajax_return($return);
        }
        // 判断是不是已经抢过了
        $isExitsGet = dbGetAll($this->dbNameLiveSurpriseLog, '', [], true, [], ['surprise_id' => $surpriseId, 'user_id' => $this->loginUserId]);
        if ($isExitsGet) {
            //$return['error'] = '已经领取过红包';
            $return['error'] = api_lang('Have_received_red_envelope');
            $return['status'] = 0;
            ajax_return($return);
        }

        // 红包缓存队列
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedRedisService.php');
        $videoRed_redis = new VideoRedRedisService();
        $user_prop_id = "surprise_".$surpriseId;
        //判断是否还有可以抢的红包
        if ($videoRed_redis->red_exists($user_prop_id)) {
            $redId = $videoRed_redis->pop_red($user_prop_id);
        }else{
            $return['error'] = api_lang('Slow_hand_was_robbed');
            $return['status'] = 0;
            ajax_return($return);
        }

        // 查询是否有没领取的红包
        $surpriseGet = dbGetAll($this->dbNameLiveSurpriseLog, '', [], true, [], ['surprise_id' => $surpriseId, 'id' => $redId], ['diamonds_quantity'], 'desc');

        if (!$surpriseGet) {
            //$return['error'] = '手慢了，已经被抢完了';
            $return['error'] = api_lang('Slow_hand_was_robbed');
            $return['status'] = 0;
            ajax_return($return);
        }

        // 更改红包领取状态
        $getSurpriseStatus = dbUpdate($this->dbNameLiveSurpriseLog, ['id' => $redId, 'get_time' => 0], ['get_time' => NOW_TIME, 'user_id' => $this->loginUserId]);

        $getResult = 0;

        if ($getSurpriseStatus) {
            $surplusCount = dbGetOneFiled($this->dbNameLiveSurpriseLog, 'count(*)', ['surprise_id' => $surpriseId, 'get_time' => 0]);

            if ($surplusCount == 0) {
                // 把红包记录状态改为已抢完
                dbUpdate($this->dbNameLiveSurprise, ['id' => $surpriseId], ['status' => 1]);
            }

            // 给用户加红包钻石
            $getResult = dbUpdate('user', ['id' => $this->loginUserId], "diamonds = diamonds + " . $surpriseGet['diamonds_quantity']);

            // 消费和收益记录表
            add_user_consumption_log(0, $this->loginUserId, 0, api_lang("抢红包"), 0, $surpriseGet['diamonds_quantity'], 22);

            user_deal_to_reids(array($this->loginUserId));
        }

        if ($getResult) {

            $return['content'] = $surpriseData['desc_content'];
            $return['diamonds'] = $surpriseGet['diamonds_quantity'];
            $return['error'] = '';
            $return['status'] = 1;
            if ($video && $surpriseGet['diamonds_quantity']) {
                $this->im_red_message($this->loginUserId, $surpriseGet['diamonds_quantity'], $video, $surpriseId);
            }
        } else {
            $return['error'] = api_lang('Slow_hand_was_robbed');
            //$return['error'] = '手慢了，已经被抢完了';
            $return['status'] = 0;
        }

        ajax_return($return);
    }

    // im
    public function im_red_message($user_id, $money, $video, $surpriseId)
    {
        $m_config = load_auto_cache("m_config");
        $system_user_id = $m_config['tim_identifier'];//系统消息
        $user = $GLOBALS['db']->getRow("SELECT id,nick_name FROM " . DB_PREFIX . "user WHERE id=" . $user_id,
            true, true);

        $ext = array();
        $ext['type'] = 301; // 抢红包发送im
        $ext['text'] = emoji_decode($user['nick_name']) . " " . api_lang("obtain") . " <span style='color:#e9b97b;'>" . $money . " " . $m_config['diamonds_name'] . "</span>";
        $ext['user_id'] = $user_id;
        $ext['surprise_id'] = $surpriseId;

        $msg_content = array();
        //创建array 所需元素
        $msg_content_elem = array(
            'MsgType' => 'TIMCustomElem',       //自定义类型
            'MsgContent' => array(
                'Data' => json_encode($ext),
                'Desc' => ''
            )
        );
        //将创建的元素$msg_content_elem, 加入array $msg_content
        array_push($msg_content, $msg_content_elem);
        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();
        $api->group_send_group_msg2($system_user_id, $video['group_id'], $msg_content);
    }


    /**
     * 获取房间的红包列表
     * */
    public function requestGetSurpriseList()
    {
        // 直播ID
        $video_id = get_input('video_id', 'n');
        $page = get_input('page', 'n');

        $page_size = 20;

        $p = $page == 1 ? 0 : $page_size * ($page - 1);

        $limit = $p . "," . $page_size;

        $join = [
            [
                'type' => 'left',
                'table_name' => 'user',
                'alias' => 'u',
                'on' => 'u.id=s.user_id'
            ]
        ];

        $field = ['s.*', 'u.head_image', 'u.nick_name'];

        // 获取红包列表，只获取未抢完的红包
        $surpriseDataList = dbGetAll($this->dbNameLiveSurprise, 's', $join, false, $field, ['video_id' => $video_id, 'status' => 0], [], '', '');

        foreach ($surpriseDataList as &$v) {
            $v['head_image'] = get_spec_image($v['head_image']);
            $v['nick_name'] = emoji_decode($v['nick_name']);
        }

        $return['list'] = $surpriseDataList;
        $return['error'] = '';
        $return['status'] = 1;

        ajax_return($return);
    }

    /**
     * 获取红包领取详情
     * */
    public function requestGetSurpriseGetDetailList()
    {
        $surprise_id = get_input('surprise_id', 'n');
        $page = get_input('page', 'n', 1);

        $page_size = 20;

        $p = $page == 1 ? 0 : $page_size * ($page - 1);

        //$limit = $p . "," . $page_size;
        $limit = '';

        // 检查红包是否存在
        $surpriseData = dbGetAll($this->dbNameLiveSurprise, '', [], true, [], ['id' => $surprise_id]);
        if (!$surpriseData) {
            //$return['error'] = '红包记录不存在';
            $return['error'] = api_lang('red_packet_record_not_exist');
            $return['status'] = 0;
            ajax_return($return);
        }

        //print_r($surpriseData);exit;
        $return['diamonds_quantity'] = $surpriseData['diamonds_quantity'];

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_info = $user_redis->getRow_db($surpriseData['user_id'], array('head_image'));
        $return['head_image'] = $user_info ? $user_info['head_image'] : '';

        // 获取红包所有奖品记录
        $surpriseDataList = dbGetAll($this->dbNameLiveSurpriseLog, 's',
            [
                [
                    'type' => 'left',
                    'table_name' => 'user',
                    'alias' => 'u',
                    'on' => 'u.id=s.user_id'
                ]
            ],
            false,
            ['s.*', 'u.head_image', 'u.nick_name'],
            [
                'surprise_id' => $surprise_id,
            ],
            ['get_time'], 'desc',
            $limit
        );

        $totalDiamonds = 0;
        $alertGetDiamonds = 0;

        // 已领取数量
        $alertGetNum = 0;

        foreach ($surpriseDataList as $k => &$v) {
            $v['head_image'] = get_spec_image($v['head_image']);
            $v['nick_name'] = emoji_decode($v['nick_name']);

            $totalDiamonds += $v['diamonds_quantity'];
            if ($v['get_time'] != 0) {
                $alertGetNum++;
                $alertGetDiamonds += $v['diamonds_quantity'];

                $v['get_time'] = date('Y-m-d H:i:s', $v['get_time']);
            } else {
                unset($surpriseDataList[$k]);
            }
        }

        // 2/10, нийт 29/100 алмаз цуглуулсан
        //$getInfoStr = '已领取' . $alertGetNum . '/' . count($surpriseDataList) . '个, ' . '共' . $alertGetDiamonds . '/' . $totalDiamonds;
        $getInfoStr = $alertGetNum . '/' . count($surpriseDataList) . ', ' . 'Total' . $alertGetDiamonds . '/' . $totalDiamonds;

        $return['get_info'] = $getInfoStr;

        $return['list'] = $surpriseDataList;
        $return['error'] = '';
        $return['status'] = 1;

        ajax_return($return);
    }

    /**
     * 发送红包IM消息
     * */
    private function sendRedIMMsg($userId, $groupId, $surpriseId, $nickname, $headImage)
    {
        $ext['type'] = 8;
        $ext['prop_id'] = 0; //礼物id
        $ext['icon'] = '';
        $ext['user_prop_id'] = 0;
        $ext['total_ticket'] = 0;//用户总的：印票数
        $ext['to_user_id'] = 0;//礼物接收人（主播）
        $ext['to_diamonds'] = 0;//礼物接收人（主播）,获得的：钻石 数量
        $ext['fonts_color'] = '';//字体颜色
        $ext['desc'] = '';//普通群员收到的提示内容;
        $ext['desc2'] = '';//礼物接收人（主播）收到的提示内容;

        $ext['surprise_id'] = $surpriseId;
        $ext['nick_name'] = emoji_decode($nickname);
        $ext['head_image'] = $headImage;

        #构造高级接口所需参数
        $msg_content = array();
        //创建array 所需元素
        $msg_content_elem = array(
            'MsgType' => 'TIMCustomElem',       //自定义类型
            'MsgContent' => array(
                'Data' => json_encode($ext),
                'Desc' => '',
            )
        );
        //将创建的元素$msg_content_elem, 加入array $msg_content
        array_push($msg_content, $msg_content_elem);


        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();
        $ret = $api->group_send_group_msg2($userId, $groupId, $msg_content);

        if ($ret['ActionStatus'] == 'FAIL' && $ret['ErrorCode'] == 10002) {
            //10002 系统错误，请再次尝试或联系技术客服。
            log_err_file(array(__FILE__, __LINE__, __METHOD__, $ret));
            $ret = $api->group_send_group_msg2($userId, $groupId, $msg_content);
        }

    }

    /**
     * 把$total_diamonds 生成指定数量$num的，随机列表数
     * @param $total_diamonds int 钻石数量
     * @param $num int 红包份数
     * @return array 份数
     */
    private function red_rand_list2($total_diamonds, $num)
    {
        $list = array();
        if ($num > $total_diamonds) {
            $num = $total_diamonds;
        }

        //先生成一批为：1 的
        for ($x = 0; $x < $num; $x++) {
            $list[] = 1;
            $total_diamonds = $total_diamonds - 1;
        }

        while ($total_diamonds > 0) {
            foreach ($list as $k => $v) {
                $diamonds = mt_rand(1, 19);//随机取：1至20中的一个数字

                if ($total_diamonds >= $diamonds) {
                    $total_diamonds = $total_diamonds - $diamonds;
                } else {
                    if ($total_diamonds >= 1) {
                        $diamonds = 1;
                        $total_diamonds = $total_diamonds - $diamonds;
                    }
                }

                $list[$k] = $v + $diamonds;

                if ($total_diamonds == 0) {
                    break;
                }
            }
        };

        return $list;
    }

}