<?php

use TencentCloud\Common\Credential;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Vod\V20180717\VodClient;
use TencentCloud\Vod\V20180717\Models\ProcessMediaByUrlRequest;

/**
 * 短视频
 * */
class svideoModule extends baseModule
{
    //热门
    public function index()
    {
        if (!$GLOBALS['user_info']) {
            $user_id = 0;
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
        }
        $cate = intval($_REQUEST['cate']);  // 默认0为全部
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        $order = intval($_REQUEST['order']) ? intval($_REQUEST['order']) : 1;   // 1热门 2最新 3附近
        $Lat = $_REQUEST['lat'] ? $_REQUEST['lat'] : '';//用户纬度
        $Lng = $_REQUEST['lng'] ? $_REQUEST['lng'] : '';//用户经度
        $root = array(
            'has_next' => 1,
            'page'     => $page,
            'status'   => 1,
            'error'    => ''
        );
        $page_size = 20;
        $list = load_auto_cache("svideo_select_weibo_recommend",
            array('page' => $page, 'page_size' => $page_size, 'user_id' => $user_id, 'type' => 'video', 'order' => $order, 'lat' => $Lat, 'lng' => $Lng, 'cate' => $cate));

        for ($i = 0; $i < count($list); $i++) {
            $list[$i]['nick_name'] = emoji_decode($list[$i]['nick_name']);
            $list[$i]['content'] = emoji_decode($list[$i]['content']);
        }


        if (count($list) > 0) {
            foreach ($list as &$v) {
                if ($v['shop_id'] > 0) {
                    $goods = $GLOBALS['db']->getRow('select * from ' . DB_PREFIX . 'shop_goods where gid = ' . $v['shop_id']);
                    if ($goods) {
                        $v['model_id'] = $goods['model_id'];
                        $v['link_url'] = $goods['link_url'];
                        $v['status'] = $goods['status'];
                    }
                }
            }
        }

        $root['data'] = $list;
        if (count($list) == $page_size) {
            $root['has_next'] = 1;
        } else {
            $root['has_next'] = 0;
        }
        api_ajax_return($root);
    }

    //是否关注用户
    public function is_follwing_userid()
    {
        $root = array('status' => 1, 'error' => '');
        $user_id = intval($_REQUEST['user_id']) ? intval($_REQUEST['user_id']) : intval($GLOBALS['user_info']['id']);

        if (!$user_id) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            return api_ajax_return(array(
                'error'             => api_lang("user_not_logged_in"),
                'status'            => 0,
                'user_login_status' => 0,
            ));
        }

        $to_user_id = intval($_REQUEST['to_user_id']);//被查看的用户ID
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');

        $userfollw_redis = new UserFollwRedisService($user_id);

        if ($userfollw_redis->is_following($to_user_id)) {
            $root['is_focus'] = 1;//0:未关注;1:已关注
        } else {
            $root['is_focus'] = 0;//0:未关注;1:已关注
        }

        api_ajax_return($root);

    }

    public function video()
    {
        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            return api_ajax_return(array(
                'error'             => api_lang("user_not_logged_in"),
                'status'            => 0,
                'user_login_status' => 0,
            ));
        }

        $user_id = intval($GLOBALS['user_info']['id']);
        //被查看的用户ID
        $to_user_id = intval($_REQUEST['to_user_id']);
        if (!$to_user_id) {
            $to_user_id = $user_id;
        }

        $page = intval($_REQUEST['page']); //取第几页数据
        $page = $page >= 1 ? $page : 1;
        $page_size = 10;

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
        $is_focus = 0;
        if ($user_id == $to_user_id) {
            $list = load_auto_cache("edu_select_weibo_list",
                array('page' => $page, 'page_size' => $page_size, 'user_id' => $user_id, 'type' => 'video'));
            foreach ($list as $k => $v) {
                $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
                $list[$k]['content'] = emoji_decode($list[$k]['content']);
                //第三方商品的链接
                if ($v['shop_id'] > 0) {
                    $sql = "select g.*  from " . DB_PREFIX . "shop_goods as g join " . DB_PREFIX . "shop_attr as a on a.gid = g.gid where g.status =11 and a.status = 1 and a.stock>0 and g.gid=" . $v['shop_id'];
                    $goods = $GLOBALS['db']->getRow($sql);
                    if ($goods) {
                        $list[$k]['model_id'] = $goods['model_id'];
                        $list[$k]['link_url'] = $goods['link_url'];
                        $list[$k]['status'] = $goods['status'];
                    } else {
                        // 删除视频商品
                        $GLOBALS['db']->query("update " . DB_PREFIX . "weibo set shop_id=0,shop_title='' where id = " . $v['weibo_id']);
                        $list[$k]['shop_id'] = 0;
                        $list[$k]['shop_title'] = '';
                    }
                }
            }
        } else {
            $list = load_auto_cache("select_weibo_other_list",
                array('page' => $page, 'page_size' => $page_size, 'to_user_id' => $to_user_id, 'type' => 'video'));
            if ($user_id > 0) {
                $pay_digg_list = load_auto_cache("select_user_pay_list",
                    array('page' => $page, 'page_size' => $page_size, 'user_id' => $user_id));
                $diggs_array = $pay_digg_list['digg'];

                $user_redis = new UserFollwRedisService($user_id);
                $is_focus = intval($user_redis->is_following($to_user_id));
            } else {
                $diggs_array = array();
            }

            foreach ($list as $k => $v) {
                if (in_array($v['weibo_id'], $diggs_array)) {
                    $list[$k]['has_digg'] = 1;
                }
                //第三方商品的链接
                if ($v['shop_id'] > 0) {
                    $sql = "select g.*  from " . DB_PREFIX . "shop_goods as g join " . DB_PREFIX . "shop_attr as a on a.gid = g.gid where g.status =11 and a.status = 1 and a.stock>0 and g.gid=" . $v['shop_id'];
                    $goods = $GLOBALS['db']->getRow($sql);
                    if ($goods) {
                        $list[$k]['model_id'] = $goods['model_id'];
                        $list[$k]['link_url'] = $goods['link_url'];
                        $list[$k]['status'] = $goods['status'];
                    } else {
                        // 删除视频商品
                        $GLOBALS['db']->query("update " . DB_PREFIX . "weibo set shop_id=0,shop_title='' where id = " . $v['weibo_id']);
                        $list[$k]['shop_id'] = 0;
                        $list[$k]['shop_title'] = '';
                    }
                }

                if ($user_id != $v['user_id']) {
                    $list[$k]['is_top'] = 0;
                }
                $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
                $list[$k]['content'] = emoji_decode($list[$k]['content']);
            }
        }

        return api_ajax_return(array(
            'status'   => 1,
            'data'     => $list,
            'has_next' => count($list) == $page_size ? 1 : 0,
            'page'     => $page,
            'is_focus' => $is_focus
        ));
    }


    /**
     * 视频点赞
     * */
    public function add_favor()
    {
        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            return api_ajax_return(array(
                'error'             => api_lang("user_not_logged_in"),
                'status'            => 0,
                'user_login_status' => 0,
            ));
        }
        $user_id = $GLOBALS['user_info']['id'];
        $weibo_id = intval($_REQUEST['weibo_id']);

        if ($weibo_id > 0) {
            $weibo_exists = $GLOBALS['db']->getOne("select count(*) from bogo_weibo where id = " . $weibo_id);
            if (!$weibo_exists) {
                return api_ajax_return(array('status' => 0, 'error' => api_lang("Small_video_does_not_exist")));
            }

            $exists = $GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "qk_svideo_favor f where user_id = {$user_id} and weibo_id = {$weibo_id}");
            if (!$exists) {
                $GLOBALS['db']->autoExecute(DB_PREFIX . "qk_svideo_favor",
                    array('user_id' => $user_id, 'weibo_id' => $weibo_id, 'create_time' => NOW_TIME), 'INSERT');
            } else {
                $this->del_favor();
            }
        }

        return api_ajax_return(array('status' => 1, 'has_favor' => 1));
    }

    public function del_favor()
    {
        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            return api_ajax_return(array(
                'error'             => api_lang("user_not_logged_in"),
                'status'            => 0,
                'user_login_status' => 0,
            ));
        }
        $user_id = $GLOBALS['user_info']['id'];
        $weibo_id = intval($_REQUEST['weibo_id']);

        $GLOBALS['db']->query("delete from " . DB_PREFIX . "qk_svideo_favor where user_id = {$user_id} and weibo_id = {$weibo_id}");

        return api_ajax_return(array('status' => 1, 'has_favor' => 0));
    }


    //我的收藏
    public function favor()
    {
        if (!$GLOBALS['user_info']['id']) {
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            return api_ajax_return(array(
                'error'             => api_lang("user_not_logged_in"),
                'status'            => 0,
                'user_login_status' => 0,
            ));
        }
        $user_id = $GLOBALS['user_info']['id'];
        $page_size = 20;

        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        $limit = (($page - 1) * $page_size) . "," . $page_size;
        $sql = "SELECT w.user_id,w.id as weibo_id,u.head_image,u.is_authentication,w.content,w.red_count,w.digg_count,w.comment_count,w.video_count,w.data,u.nick_name,w.sort_num,w.photo_image,w.is_top ,u.city,w.price,w.type,w.create_time,w.city,w.province,w.address
FROM
    " . DB_PREFIX . "qk_svideo_favor as f join " . DB_PREFIX . "weibo as w on f.weibo_id = w.id
    left join " . DB_PREFIX . "user as u on w.user_id = u.id 
WHERE f.user_id = {$user_id} order by f.id desc limit {$limit}";

        bogo_require(APP_ROOT_PATH . 'mapi/xr/core/common.php');
        $items = $GLOBALS['db']->getAll($sql);
        foreach ($items as &$item) {
            $item['head_image'] = deal_weio_image($item['head_image'], 'head_image');
            $item['photo_image'] = deal_weio_image($item['photo_image'], $item['type']);
        }
        unset($item);

        api_ajax_return(array(
            'items'    => $items,
            'has_next' => count($items) == $page_size ? 1 : 0,
            'page'     => $page,
            'status'   => 1,
            'error'    => ''
        ));
    }

    /**
     * 短视频送礼
     */
    public function send_gift()
    {
        //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        if (!$GLOBALS['user_info']['id']) return api_ajax_return(['error' => api_lang("user_not_logged_in"), 'status' => 0, 'user_login_status' => 0]);
        $time = time();
        $g_id = get_input('g_id', 'n', 0, 'intval,abs');
        $uid = $GLOBALS['user_info']['id'];                              // 赠送用户id
        $to_uid = get_input('to_uid', 'n', 0, 'intval,abs');             // 接收用户id
        $w_id = get_input('w_id', 'n', 0, 'intval,abs');                  // 短视频id
        $num = get_input('num', 'n', 0, 'intval,abs');                   // 礼物数量
        $money_type = get_input('price_type', 'n', 0, 'intval,abs');     // 金额类型(1钻石2金币)

        if ($num == 0) api_ajax_return(array('status' => 0, 'error' => api_lang("Choose_the_number_of_gifts")));
        else if ($to_uid == 0 || $w_id == 0) api_ajax_return(array('status' => 0, 'error' => api_lang("Select_the_object_to_send")));
        else if ($g_id == 0) api_ajax_return(array('status' => 0, 'error' => api_lang("Choose_a_gift_to_give")));
        else if ($uid == $to_uid) api_ajax_return(array('status' => 0, 'error' => api_lang("Don_give_yourself_gifts")));

        $sql = "select * from " . DB_PREFIX . "user where id = '{$uid}'";
        $user = $GLOBALS['db']->getRow($sql);

        $g_sql = "select * from " . DB_PREFIX . "prop where id={$g_id}";
        $gift = $GLOBALS['db']->getRow($g_sql);
        if (empty($gift)) api_ajax_return(array('status' => 0, 'error' => api_lang("gift_does_not_exist")));
        else if ($gift['type'] == 3 && $user['is_vip'] != 1) api_ajax_return(['status' => 0, 'error' => api_lang("This_gift_is_exclusive_to_VIP")]);
        //守护礼物
        if ($gift['type'] == 2) {
            //获取是否是守护者
            $guardian_user = redis_get("guardian_host_".$to_uid."_user_".$uid);
            if (!$guardian_user) {
                api_ajax_return(['status' => 0, 'error' => api_lang("Guard_not_opened")]);
            }
        }

        $prop = load_auto_cache("prop_id", array('id' => $g_id));

        //贵族礼物
        if ($prop['type'] == 4) {
            //获取贵族头像和名称
            if ($user['nobleid'] < 0 || $user['noble_time'] < NOW_TIME) {
                $root['status'] = 0;
                $root['error'] = api_lang("No_noble_gifts_sent");
                ajax_return($root);
            } else {
                //【新贵族权限】
                $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
                if ($jurisdiction && $jurisdiction['is_gift'] != 1) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("noble_Insufficient_authority");
                    ajax_return($root);
                }
            }
        }


        // 短视频验证
        $sql = "select id, user_id from " . DB_PREFIX . "weibo where id ='{$w_id}'";
        $weibo = $GLOBALS['db']->getRow($sql);
        if (empty($weibo)) api_ajax_return(array('status' => 0, 'error' => api_lang("Short_video_does_not_exist")));
        elseif ($weibo['user_id'] != $to_uid) api_ajax_return(array('status' => 0, 'error' => api_lang("Video_publisher_error")));

        // 总价, 以及用户需要扣除的金额类型
        $gift_price = $gift['diamonds'];         // 礼物单价
        $score = $gift['type'] == 3 ? $gift['score'] + $gift['vip_score'] : $gift['score'];
        // 用户金额验证
        $gift_count_price = bcmul($gift_price, $num, 2);                  // 礼物总价
        if ($user['diamonds'] < $gift_count_price) api_ajax_return(array('status' => 0, 'error' => api_lang("insufficient_balance")));

        $ins_sql = "insert into " . DB_PREFIX . "weibo_gift";
        $ins_arr = [
            'weibo'       => $w_id,
            'gift'        => $g_id,
            'gift_num'    => $num,
            'count_price' => $gift_count_price,
            'uid'         => $uid,
            'to_uid'      => $to_uid,
            'addtime'     => NOW_TIME,
        ];
        $ins_sql .= insertStr($ins_arr);
        $bool = $GLOBALS['db']->query($ins_sql);
        if (!$bool) api_ajax_return(array('status' => 0, 'error' => api_lang("Gift_giving_failure")));

        // 用户钻石减少, 经验增加
        $sql = "update " . DB_PREFIX . "user set diamonds=`diamonds`-'{$gift_count_price}', use_diamonds = `use_diamonds`+'{$gift_count_price}', score = `score`+'{$score}' where id = '{$uid}'";
        $bool = $GLOBALS['db']->query($sql);

        //增加：用户印票
        if ($to_uid) {
            $total_ticket = intval($num * $gift['ticket']);
            $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . $total_ticket . " where id = " . $to_uid;
            $GLOBALS['db']->query($sql);
        }

        // 日志记录
        $sql = "insert into " . DB_PREFIX . "user_log";
        $ins_arr = [
            'log_info'     => api_lang("Short_video") . "({$weibo['id']})" . api_lang("present_as_a_gift") . "{$num}" . api_lang("individual") . "{$gift['name']}," . api_lang("consume") . "{$gift_count_price}" . api_lang("Diamonds"),
            'log_time'     => $time,
            'log_admin_id' => 0,
            'money'        => 0,
            'user_id'      => $uid,
            'type'         => 21,
            'diamonds'     => $gift_count_price
        ];
        $sql .= insertstr($ins_arr);
        $bool = $GLOBALS['db']->query($sql);
        $root = array(
            'status' => 0,
            'error'  => api_lang("operation_failed")
        );
        if ($bool) {
            // 更新余额
            $root = array(
                'status'   => 1,
                'error'    => api_lang("Sent_successfully"),
                'data'     => $prop,
                'anim_cfg' => $prop ? $prop['anim_cfg'] : array()
            );

            $user_info = $GLOBALS['db']->getRow("select diamonds from " . DB_PREFIX . "user  where id=" . $uid);
            $root['user_diamonds'] = $user_info['diamonds'];

            api_ajax_return($root);
        }
        api_ajax_return($root);
        //    return $bool ? api_ajax_return(array('status' => 1, 'error' => api_lang("Sent_successfully"))) : api_ajax_return(array('status' => 0, 'error' => api_lang("operation_failed")));
    }

    /**
     * 发起视频的审核任务
     * */
    public function request_video_audit()
    {
        //视频ID
        $video_id = get_input('video_id', 0);

        $this->checkUserLogin();

        $config = load_auto_cache('m_config');

        //查询视频
        try {

            $cred = new Credential($config['qcloud_secret_id'], $config['qcloud_secret_key']);
            $httpProfile = new HttpProfile();
            $httpProfile->setEndpoint("vod.tencentcloudapi.com");

            $clientProfile = new ClientProfile();
            $clientProfile->setHttpProfile($httpProfile);
            $client = new VodClient($cred, "", $clientProfile);

            $req = new ProcessMediaByUrlRequest();

            $params = array(
                "InputInfo" => array(
                    "Url" => 'http://1251470018.vod2.myqcloud.com/9445e43cvodgzp1251470018/55d8d96b5285890807027251890/2NsO2bxMu4wA.mp4'
                )
            );
            $req->fromJsonString(json_encode($params));


            $resp = $client->ProcessMediaByUrl($req);

            print_r($resp->toJsonString());
        } catch (TencentCloudSDKException $e) {
            echo $e;
        }
    }
}
