<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class upload_fileModule extends baseModule
{

    public function upload_video_file()
    {
        //创建temp临时目录
        $save_rec_temp = "/public/attachment/temp/";
        $savePath_temp = APP_ROOT_PATH . "public/attachment/temp/";

        if (!is_dir(APP_ROOT_PATH . "public/attachment/temp/")) {
            @mkdir(APP_ROOT_PATH . "public/attachment/temp/");
            @chmod(APP_ROOT_PATH . "public/attachment/temp/", 0777);
        }

        //开始移动图片到相应位置
        $dir_name = to_date(get_gmtime(), "Ym");
        if (!is_dir(APP_ROOT_PATH . "public/attachment/" . $dir_name)) {
            @mkdir(APP_ROOT_PATH . "public/attachment/" . $dir_name);
            @chmod(APP_ROOT_PATH . "public/attachment/" . $dir_name, 0777);
        }

        $dir_name = $dir_name . "/" . to_date(get_gmtime(), "d");
        if (!is_dir(APP_ROOT_PATH . "public/attachment/" . $dir_name)) {
            @mkdir(APP_ROOT_PATH . "public/attachment/" . $dir_name);
            @chmod(APP_ROOT_PATH . "public/attachment/" . $dir_name, 0777);
        }

        $dir_name = $dir_name . "/" . to_date(get_gmtime(), "H");
        if (!is_dir(APP_ROOT_PATH . "public/attachment/" . $dir_name)) {
            @mkdir(APP_ROOT_PATH . "public/attachment/" . $dir_name);
            @chmod(APP_ROOT_PATH . "public/attachment/" . $dir_name, 0777);
        }

        //上传时先存放原图
        $save_rec_Path = "/public/attachment/" . $dir_name . "/origin/";
        //绝对路径
        $savePath = APP_ROOT_PATH . "public/attachment/" . $dir_name . "/origin/";
        if (!is_dir(APP_ROOT_PATH . "public/attachment/" . $dir_name . "/origin/")) {
            @mkdir(APP_ROOT_PATH . "public/attachment/" . $dir_name . "/origin/");
            @chmod(APP_ROOT_PATH . "public/attachment/" . $dir_name . "/origin/", 0777);
        }

        $id = rand(1000, 9999);

        //判断文件类型
        $ext = strtolower(pathinfo(@$_FILES['file']['name'], PATHINFO_EXTENSION));
        $save_name = get_gmtime() . $id . '.' . $ext;

        $image_file_domain = "." . $save_rec_Path . $save_name;
        $image_file = $savePath;

        //开始上传
        $video_result = $this->upload_file($_FILES['file'], $image_file, $save_name);

        if (file_exists($video_result)) {

            if ($GLOBALS['distribution_cfg']['OSS_TYPE'] && $GLOBALS['distribution_cfg']['OSS_TYPE'] != 'NONE') {
                syn_to_remote_image_server($image_file_domain, false);
            }

            $root['status'] = 1;
            $root['error'] = api_lang("Upload_successful");
            $root['path'] = $image_file_domain;
            $root['server_full_path'] = get_spec_image($image_file_domain);
        } else {
            $root['status'] = 0;
            $root['error'] = api_lang("Upload_failed");
            $root['path'] = '';
        }
        ajax_return($root);
    }


    function upload_file($files, $path, $file_name, $imagesExt = ['jpg', 'png', 'jpeg', 'gif', 'mp4', 'mov'])
    {

        // 判断错误号
        if (@$files['error'] == 00) {

            // 判断文件类型
            $ext = strtolower(pathinfo(@$files['name'], PATHINFO_EXTENSION));

            if (!in_array($ext, $imagesExt)) {
                return api_lang("Illegal_file_type");
            }

            // 判断是否存在上传到的目录
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }

            // 生成唯一的文件名
            //$fileName = md5(uniqid(microtime(true), true)) . '.' . $ext;

            // 将文件名拼接到指定的目录下
            $destName = $path . "/" . $file_name;

            // 进行文件移动
            if (!move_uploaded_file($files['tmp_name'], $destName)) {
                return $path;
            }

            return $path;

        } else {
            // 根据错误号返回提示信息
            switch (@$files['error']) {
                case 1:
                    echo api_lang("uploaded_file_exceeds_option_limit");
                    break;
                case 2:
                    echo api_lang("upload_size_exceeds_specified_value");
                    break;
                case 3:
                    echo api_lang("Only_part_file_was_uploaded");
                    break;
                case 4:
                    echo api_lang("No_files_were_uploaded");
                    break;
                case 6:
                case 7:
                    echo api_lang("System_error");
                    break;

            }
            exit;
        }

    }
}