<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------
use think\Db;
class userModule extends baseModule
{
    /**
     * 获取当月收益
     */
    public function month_statistics(){
        $root = array('status'=> 1,'error'=>'');
        $token = strim($_REQUEST['token']);
        if (!empty($token)) {
            //根据加密的token获取id pc使用
            $user = $GLOBALS['db'] -> getRow('select * from '.DB_PREFIX."user where token = '".$token."'");
            $user_id = $user && $user['id'] ? $user['id'] : '';
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
        }

        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            // 获取时间 数组格式
            $date = get_date_time(NOW_TIME);
            $date_y = $date['date_y'];
            $date_m = $date['date_m'];
            $date_d = $date['date_d'];
            // 查询当月数据
            $where="uid=" . $user_id." and date_y='".$date_y."' and date_m='".$date_m."'";
            $m_config = load_auto_cache("m_config");//初始化手机端配置

            if($m_config['effective_duration_voice_computing'] == 1){
                // 语音房间 + 直播房间时长
                $field1 = "sum(earnings) as earnings,sum(voice_duration + live_duration) as duration,sum(day_effective) as day_effective";
                $field2 ="sum(earnings) as earnings,sum(voice_duration + live_duration) as duration";
            }else {
                // 直播房间时长
                $field1 = "sum(earnings) as earnings,sum(live_duration) as duration,sum(day_effective) as day_effective";
                $field2 ="sum(earnings) as earnings,sum(live_duration) as duration";
            }

            $month = Db::name("user_duration")->field($field1)->where($where)->find();
            // 查询今日数据
            $where.="  and date_d='".$date_d."'";
            $today = Db::name("user_duration")->field($field2)->where($where)->find();

            // 主播每日任务时长奖励
            $host_mission_list = host_mission_list(); // 任务列表
            $date =date('Y-m-d');
            // 是否领取了奖励

            $reward_record_key="mission_reward_record_".$date."_".$user_id."_";


            $task_duration_list = [];
            foreach ($host_mission_list as $v){
                $is_reward_list =json_decode(redis_get($reward_record_key.$v['id']),true);
                $reward_text = '';
                if ($is_reward_list) {
                    if ($is_reward_list['status'] == 1) {
                        // 已奖励
                        $reward_text = api_lang('Received_already');
                    } else {
                        // 未领取
                        $reward_text = api_lang('Unclaimed');
                    }
                }
                $task_duration_list[] = array(
                    'id' =>$v['id'],
                    'name' =>time_duration($v['duration'] * 60),
                    'money' => money_k($v['money']),
                    'duration' => $v['duration'],
                    'reward_text' =>$reward_text
                );
            }

            $root['data'] = array(
                'month' => array(
                    'earnings' =>  $month && $month['earnings'] ? $month['earnings'].' '.$m_config['ticket_name'] : 0,
                    'duration' =>  $month && $month['duration'] ? get_live_time_lenght($month['duration']) : 0,
                    'day_effective' =>  $month && $month['day_effective'] ? $month['day_effective'] : 0,
                ),
                'today' =>array(
                    'earnings' =>  $today && $today['earnings'] ? $today['earnings'].' '.$m_config['ticket_name'] : 0,
                    'duration' =>  $today && $today['duration'] ? get_live_time_lenght($today['duration']) : 0
                ),
                'ticket_name' => $m_config['ticket_name'],
                'is_task' => count($task_duration_list) <= 0 ? 0 : 1,
                'task' =>array(
                    'list' => $task_duration_list
                ),
            );
        }
        ajax_return($root);
    }
    /**
     * 获取收益记录-月统计
     */
    public function get_day_earnings(){
        $root = array('status'=> 1,'error'=>'');
        $token = strim($_REQUEST['token']);
        if (!empty($token)) {
            //根据加密的token获取id pc使用
            $user = $GLOBALS['db'] -> getRow('select * from '.DB_PREFIX."user where token = '".$token."'");
            $user_id = $user && $user['id'] ? $user['id'] : '';
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
        }

        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
            $starttime = strim($_REQUEST['starttime']);
            $endtime = strim($_REQUEST['endtime']);
            $time_type = intval($_REQUEST['time_type']); // 1 天 2 月
            $p = ($page - 1) * 20;
            $where="uid=".$user_id;
            $date_y = date('Y', strtotime($starttime));
            $date_m = date('m', strtotime($starttime));
            $date_d = date('d', strtotime($starttime));
            $date_e_y = date('Y', strtotime($endtime));
            $date_e_m = date('m', strtotime($endtime));
            $date_e_d = date('d', strtotime($endtime));

            $where .= $date_y == $date_e_y ? " and date_y =".$date_y : " and date_y >='".$date_y."' and date_y <=".$date_e_y;
            $where .= $date_m == $date_e_m ? " and date_m =".$date_m : " and date_m >='".$date_m."' and date_m <=".$date_e_m;
            if ($time_type == 1) {
                $where .= $date_d == $date_e_d ? " and date_d =" . $date_d : " and date_d >='" . $date_d . "' and date_d <=" . $date_e_d;
            }
//            if ($time_type == 1) {
//                $where .= $starttime ? " and create_time >=". strtotime($starttime) : "";
//                $where .= $endtime ? " and create_time <=". strtotime($endtime) : "";
//            } else {
//                $where .= $starttime ? " and create_time >=". strtotime($starttime."-01") : "";
//                if ($endtime) {
//                    // 月第一天
//                    $first = date('Y-m-01 0:0:0', strtotime($endtime."-01"));
//                    // 月最后一天
//                    $last = date('Y-m-d 23:59:59', strtotime("$first +1 month -1 day"));
//                    $where .= $last ? " and create_time <=". strtotime($last) : "";
//                }
//            }

            $m_config = load_auto_cache("m_config");//初始化手机端配置
            //查询本用户的所有记录
            $record_list = Db::name("user_duration")->where($where)
                ->field("id,earnings,voice_duration,live_duration,day_effective,date_y,date_m,date_d,date_type")
                ->order("create_time desc")
                ->limit($p, 20)
                ->select();
            $visit_list = [];
            foreach ($record_list as $v) {
                $v['duration'] = intval($v['voice_duration']) + intval($v['live_duration']);
                $date = $v['date_y']."-".$v['date_m'];
                $v['create_time'] =$v['date_y']."-".$v['date_m']."-".$v['date_d'];
                $v['earnings']= api_lang('earnings_title').":  ".$v['earnings']." ". $m_config['ticket_name'];
                $v['duration'] = $v['duration'] > 0 ? get_live_time_lenght($v['duration']) : '0:00:00';
                $v['voice_duration'] = $v['voice_duration'] > 0 ? get_live_time_lenght($v['voice_duration']) : '0:00:00';
                $v['live_duration'] = $v['live_duration'] > 0 ? get_live_time_lenght($v['live_duration']) : '0:00:00';
                $v['day_effective'] = $v['day_effective'] == 1 ?  api_lang('yes') : api_lang('no');
                $visit_list[$date][] = $v;
            }

            $list_array = [];
            foreach ($visit_list as $k => $val) {
                $array = [];
                $array['time'] = $k;

                $array['list'] = $val;

                $list_array[] = $array;
            }
            $userinfo = Db::name("user_duration")->field("sum(earnings) as earnings,sum(voice_duration) as voice_duration,sum(live_duration) as live_duration,sum(day_effective) as day_effective")->where($where)->find();
            $earnings = $userinfo && $userinfo['earnings'] ? $userinfo['earnings'] : 0;
            $duration = 0;
            if ($userinfo) {
                $duration = intval($userinfo['voice_duration']) + intval($userinfo['live_duration']);
            }
            $root['data'] = array(
                'earnings' => $earnings." ".$m_config['ticket_name'] ,
                'voice_duration' => $userinfo && $userinfo['voice_duration'] > 0 ? get_live_time_lenght($userinfo['voice_duration']) : '0:00:00',
                'live_duration' => $userinfo && $userinfo['live_duration'] > 0 ? get_live_time_lenght($userinfo['live_duration']) : '0:00:00',
                'duration' => $userinfo && $duration > 0 ? get_live_time_lenght($duration) : '0:00:00',
                'day_effective' => $userinfo && $userinfo['day_effective'] ? $userinfo['day_effective'] : 0,
                'month_list' => $list_array
            );
        }
        ajax_return($root);
    }
    /**
    * 获取用户余额
     */
    public function get_diamonds(){
        $root = array();
        $user_id = intval($GLOBALS['user_info']['id']);
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $userinfo = $GLOBALS['db']->getRow('select diamonds from ' . DB_PREFIX . 'user where id =' . $user_id);
            $root['status'] = 1;
            $root['error'] = '';
            $root['data'] = array(
                'diamonds' => $userinfo['diamonds']
            );
        }
        ajax_return($root);
    }
    /**
     * 获取用户签名
     */
    public function usersig()
    {
        $root = array();

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");// es_session::id();
            //$root['es_session'] = es_session::id();
            //$root['user_info'] = json_encode(es_session::get("user_info"));
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $identifier = $GLOBALS['user_info']['id'];// $_REQUEST['identifier'];

            $root = load_auto_cache("usersig", array("id" => $identifier));
        }
        if (intval($_REQUEST['ajax_type']) && intval(IS_DEBUG)) {
            print_r($root);
            echo "<hr/>";
        }
        ajax_return($root);
    }

    /**
     * 获得用户公开信息;不传identifier时,则获得当前登陆用户的信息
     */
    public function userinfo()
    {
        $root = array();

        //$GLOBALS['user_info']['id'] = 292;
        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : $_REQUEST['uid'];
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $podcast_id = intval($_REQUEST['podcast_id']);//主播id，bogo_user.id
            $to_user_id = intval($_REQUEST['to_user_id']);//需要查看的用户id
            if ($to_user_id == 0) {
                $to_user_id = $user_id;
            }

            $root = getuserinfo($user_id, $podcast_id, $to_user_id, $_REQUEST);
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $root['init_version'] = intval($m_config['init_version']);//手机端配置版本号

            //公会ljz
            if ($root['user']['society_id'] > 0) {
                $root['user']['society_name'] = $GLOBALS['db']->getOne("select name from " . DB_PREFIX . "society where id=" . $root['user']['society_id']);
            } else {
                $root['user']['society_name'] = '';
            }

            if ($m_config['name_limit'] == 1) {
                $user = $GLOBALS['db']->getRow("select nick_name from " . DB_PREFIX . "user where id = " . $user_id);
                $nick_name = addslashes($user['nick_name']);

                //进入个人中心过滤铭感词汇
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                if ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '$nick_name' like concat('%',name,'%')")) {
                    $nick_name = str_replace($limit_sql, '*', $nick_name);
                }

                //判断用户名如果被过滤后为空,格式则变更为： 账号+ID
                if ($nick_name == '') {
                    $nick_name = ($m_config['default_nickname'] . $user_id);
                }

                //更新数据库
                $sql = "update " . DB_PREFIX . "user set nick_name = '$nick_name' where id=" . $user_id;
                $GLOBALS['db']->query($sql);
                //更新redis
                user_deal_to_reids(array($user_id));

            }

            $sdk_version_name = strim($_REQUEST['sdk_version_name']);
            $root['show_red'] = $m_config['ios_check_version'] && $m_config['ios_check_version'] == $sdk_version_name ? 0 : 1;

            $root['status'] = 1;

            //格式化数据(大于10000保留两位小数，否则不变)
            //bogo_require(APP_ROOT_PATH . 'mapi/lib/core/num_format.php');
            $root['user']['n_fans_count'] = format_for_ten_thousand($root['user']['fans_count']);
            $root['user']['n_focus_count'] = format_for_ten_thousand($root['user']['focus_count']);
            $root['user']['n_use_diamonds'] = format_for_ten_thousand_new($root['user']['use_diamonds']);
            $root['user']['n_ticket'] = format_for_ten_thousand_new($root['user']['ticket']);
            $root['user']['n_video_count'] = format_for_ten_thousand($root['user']['video_count']);
            $root['user']['n_useable_ticket'] = format_for_ten_thousand($root['user']['useable_ticket']);
            $root['user']['n_diamonds'] = format_for_ten_thousand($root['user']['diamonds']);
            $root['user']['n_show_user_order'] = format_for_ten_thousand($root['user']['show_user_order']);
            $root['user']['n_user_order'] = format_for_ten_thousand($root['user']['user_order']);
            $root['user']['n_show_user_pai'] = format_for_ten_thousand($root['user']['show_user_pai']);
            $root['user']['n_user_pai'] = format_for_ten_thousand($root['user']['user_pai']);
            $root['user']['n_show_podcast_order'] = format_for_ten_thousand($root['user']['show_podcast_order']);
            $root['user']['n_podcast_order'] = format_for_ten_thousand($root['user']['podcast_order']);
            $root['user']['n_show_shopping_cart'] = format_for_ten_thousand($root['user']['show_shopping_cart']);
            $root['user']['n_shopping_cart'] = format_for_ten_thousand($root['user']['shopping_cart']);
            $root['user']['n_podcast_goods'] = format_for_ten_thousand($root['user']['podcast_goods']);
            $root['user']['n_coin'] = format_for_ten_thousand($root['user']['coin']);
            $root['user']['n_podcast_pai'] = format_for_ten_thousand($root['user']['podcast_pai']);
            $root['user']['n_shop_goods'] = format_for_ten_thousand($root['user']['shop_goods']);
            $root['user']['n_svideo_count'] = format_for_ten_thousand($root['user']['svideo_count']);

            //购买靓号
            $root['user']['luck_num_url'] = SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=luck&act=index";
            //购买座驾
            $root['user']['pay_car'] = SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=car&act=index";
            //购买会员
            $root['user']['members_url'] = SITE_DOMAIN . APP_ROOT . "/wap/index.php?ctl=vip_pay&act=purchase";

            $root['user']['is_shop'] = 0;

        }

        ajax_return($root);
    }

    /**
     * 关注某个用户
     */
    public function follow()
    {
        $root = array('status' => 1, 'error' => '');

        //$GLOBALS['user_info']['id'] = 269;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //
            $user_level = $GLOBALS['db']->getOne("select user_level from " . DB_PREFIX . "user where id = " . $GLOBALS['user_info']['id'], true, true);
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $show_follow_msg = intval($m_config['show_follow_msg']);//是否现发送关注提示信息 0:不显示; 1:显示
            $show_follow_msg_lv = intval($m_config['show_follow_msg_lv']);//关注提示显示的等级

            $user_id = intval($GLOBALS['user_info']['id']);//当前用户;
            $room_id = intval($_REQUEST['room_id']);//room_id 当前直播房间号，用来：计算权重的;

            $to_user_id = intval($_REQUEST['to_user_id']);//被关注或取消关注的用户

            $to_user_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id = " . $to_user_id, true, true);
            if (!intval($to_user_id)) {
                $root['error'] = api_lang("following_user_does_not_exist");
                $root['status'] = 0;
            } else if ($user_id != $to_user_id) {
                // 查看用户是否被拉黑
                $black = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "black where black_user_id = " . $to_user_id . " and user_id = " . $user_id);
                if($black){
                    $root['status'] = 0;
                    $root['error'] = api_lang("Black_relations_with_the_other_side");
                    ajax_return($root);
                }

                $root = redis_set_follow($user_id, $to_user_id, false, $room_id);
                clear_auto_cache("playback_list", array("user_id" => $user_id));


                if ($show_follow_msg && ($user_level >= $show_follow_msg_lv)) {
                    $root['follow_msg'] = emoji_decode($GLOBALS['user_info']['nick_name']) .' '. api_lang("Follow_the_anchor");
                } else {
                    $root['follow_msg'] = '';
                }

                /*
                bogo_require(APP_ROOT_PATH.'mapi/lib/redis/UserFollwRedisService.php');
                $user_redis = new UserFollwRedisService($user_id);
                //查看关注人数
                $follow_count = $user_redis->follow_count();
                //粉丝人数
                $follow_by_count = $user_redis->follower_count();
                //update_follow($user_id,$follow_count,$follow_by_count);

                //$root = set_follow($user_id,$to_user_id);
                //$root = redis_set_follow($user_id,$to_user_id);
                 */
                if (defined('OPEN_MISSION') && OPEN_MISSION && $root['has_focus']) {
                    require_once APP_ROOT_PATH . 'mapi/lib/core/Model.class.php';
                    Model::$lib = dirname(__FILE__);
                    Model::build('mission')->incProgress($user_id, 4);
                }
            } else {
                $root['error'] = api_lang("Don_care_about_yourself");
                $root['status'] = 0;
            }


        }
        ajax_return($root);
    }

    /**
     * 关注多个用户
     */
    public function follow_all()
    {
        $root = array('status' => 1, 'error' => '');

        //$GLOBALS['user_info']['id'] = 269;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //
            $user_level = $GLOBALS['db']->getOne("select user_level from " . DB_PREFIX . "user where id = " . $GLOBALS['user_info']['id'], true, true);
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $show_follow_msg = intval($m_config['show_follow_msg']);//是否现发送关注提示信息 0:不显示; 1:显示
            $show_follow_msg_lv = intval($m_config['show_follow_msg_lv']);//关注提示显示的等级

            $user_id = intval($GLOBALS['user_info']['id']);//当前用户;
            $room_id = 0;//room_id 当前直播房间号，用来：计算权重的;

            $to_user_id_str = get_input('to_user_id', 's', '', 'trim');//被关注或取消关注的用户
            $to_user_id_all = array_filter(explode(',', $to_user_id_str));
//            pp($to_user_id_all);
//            die;
            // 关注多个主播
            if (in_array($user_id, $to_user_id_all)) {
                $root['error'] = api_lang("Don_care_about_yourself");
                $root['status'] = 0;
            } else {
                foreach ($to_user_id_all as $to_user_id) {
                    $to_user_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id = '{$to_user_id}'", true, true);
                    if (!intval($to_user_id)) {
                        $root['error'] = api_lang("following_user_does_not_exist");
                        $root['status'] = 0;
                        break;
                    } else if ($user_id != $to_user_id) {
                        $root = redis_set_follow($user_id, $to_user_id, false, $room_id);
                        clear_auto_cache("playback_list", array("user_id" => $user_id));
//                    if ($show_follow_msg && ($user_level >= $show_follow_msg_lv)) {
//                        $root['follow_msg'] = emoji_decode($GLOBALS['user_info']['nick_name']) . "关注了主播";
//                    } else {
//                        $root['follow_msg'] = '';
//                    }
                        if (defined('OPEN_MISSION') && OPEN_MISSION && $root['has_focus']) {
                            require_once APP_ROOT_PATH . 'mapi/lib/core/Model.class.php';
                            Model::$lib = dirname(__FILE__);
                            Model::build('mission')->incProgress($user_id, 4);
                        }
                    }
                }
            }
        }
        ajax_return($root);
    }

    /**
     * 禁言,只有：主群或群管理员才能设置
     */
    public function forbid_send_msg()
    {

        $root = array();
        $root['status'] = 0;
        $root['is_forbid'] = 0;
        //$GLOBALS['user_info']['id'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']);//
            $to_user_id = strim($_REQUEST['to_user_id']);//被禁言的用户id
            $group_id = strim($_REQUEST['group_id']);//群组ID
            $second = intval($_REQUEST['second']);//禁言时间，单位为秒; 为0时表示取消禁言

            $is_nospeaking = $GLOBALS['db']->getOne("select is_nospeaking from " . DB_PREFIX . "user where id = " . $to_user_id, true, true);
            if (intval($is_nospeaking) == 1) {
                $root['error'] = api_lang("Be_forbidden_to_send_message");
                ajax_return($root);
            }

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $video = $video_redis->getRow_db_ByGroupId($group_id, array('id', 'user_id'));
//			//优化
//			$forbid_info = $video_redis->has_forbid_msg($group_id,$to_user_id);//判断某个用户是否被禁言(被禁言返回：true; 未被禁言返回：false)
//			if($forbid_info && intval($forbid_info)>NOW_TIME){
//				$second = 0;
//			}else{
//				$second = 10000;
//                $video_redis->unset_forbid_msg($group_id,$to_user_id);
//			}

            //$sql = "select id,user_id,group_id from ".DB_PREFIX."video where group_id = '".$group_id."'";
            //$video = $GLOBALS['db']->getRow($sql,true,true);
            $podcast_id = intval($video['user_id']);
            $room_id = intval($video['id']);


            //查看自己
            if ($to_user_id == $user_id) {
                $root['error'] = api_lang("You_can_forbid_yourself");
            } else {
                $allow = false;
                //主播查看
                if ($podcast_id == $user_id) {
                    $allow = true;//主播 有权限禁言
                } else {
                    $sql = "select count(id) as num from " . DB_PREFIX . "user_admin where podcast_id = " . $podcast_id . " and user_id = " . $user_id;
                    if ($GLOBALS['db']->getOne($sql, true, true) > 0) {
                        $allow = true;//管理员 有权限禁言按钮
                    }
                }

            }
            //获取是否是守护者
            $guardian_user = redis_get("guardian_host_".$user_id."_user_".$to_user_id);
            if($guardian_user){
                $guardian_user = json_decode($guardian_user,true);
            }
            if ($guardian_user && $guardian_user['classification_id'] == 3) { //至尊守护不可禁言
                $root['status'] = 0;
                $root['error'] = api_lang("Guard_has_no_right_to_speak");
                ajax_return($root);
            }

            //贵族用户不能禁言
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            $fields = array('id', 'noble_time', 'nobleid');
            $userinfo = $user_redis->getRow_db($to_user_id, $fields);

            if ($userinfo['noble_time'] >= NOW_TIME) {
                // 贵族20210429版
                $jurisdiction = load_auto_cache("noble_id", ['id' => $userinfo['nobleid']]);
                if ($jurisdiction) {
                    if ($jurisdiction['is_kickproof'] == 1) {
                        // 防踢防禁言
                        $root['error'] = api_lang("nobles_have_no_power_to_forbid");
                        ajax_return($root);
                    }
                } else {
                    $sql = "select * from " . DB_PREFIX . "noble_classification where id = " . $userinfo['nobleid'] . " and status=1";
                    $noble = $GLOBALS['db']->getROW($sql, true, true);
                    //获取贵族的特权 type=11防禁言
                    $sql = "select * from " . DB_PREFIX . "noble_type where id in (" . $noble['type'] . ") and status=1 and type=11";

                    $noble_type = $GLOBALS['db']->getROW($sql, true, true);

                    if ($noble_type) {
                        $root['error'] = api_lang("nobles_have_no_power_to_forbid");
                        ajax_return($root);
                    }
                }
            }
            if ($allow) {
                $sql = "select is_robot,nick_name from " . DB_PREFIX . "user where id = '" . $to_user_id . "'";
                $user = $GLOBALS['db']->getRow($sql, true, true);
                $nick_name = $user['nick_name'];

                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();
                //设置：禁言(second>0)，取消禁言(second = 0)
                if ($user['is_robot'] != 1) {
                    $ret = $api->group_forbid_send_msg($group_id, (string)$to_user_id, $second);
                }
                if ($ret['ActionStatus'] == 'OK' || $user['is_robot'] == 1) {

                    if ($second > 0) {
                        //禁言到期时间
                        if ($second > 86400) {
                            //大于一天则永禁言
                            $msg = emoji_decode($nick_name) . api_lang("Be_permanently_forbidden");//.print_r($ret,1).';user_id:'.$user_id.";second:".$second.";group_id:".$group_id;
                            $second = 99999999;
                        } else {
                            $msg = emoji_decode($nick_name) . api_lang("Be_forbidden") . get_live_time_len2($second);
                        }
                        $root['is_forbid'] = 1;

                        $shutup_time = NOW_TIME + $second;
                        $video_redis->set_forbid_msg($group_id, $to_user_id, $shutup_time);

                    } else {
                        $msg = emoji_decode($nick_name) . api_lang("Lift_the_ban");
                        $video_redis->unset_forbid_msg($group_id, $to_user_id);
                        $root['is_forbid'] = 0;
                        //$sql = "delete from ".DB_PREFIX."video_forbid_send_msg where group_id='".$group_id."' and user_id = '".$to_user_id."'";
                        //$GLOBALS['db']->query($sql);
                    }


                    $root['status'] = 1;
                } else {
                    $root['status'] = 0;
                    $root['error'] = $ret['ErrorInfo'] . ":" . $ret['ErrorCode'];
                }

                if ($root['status'] == 1) {
                    if (!$api) {
                        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                        $api = createTimAPI();
                    }

                    //群播一个：禁言通知
                    $ext = array();
                    $ext['type'] = 4; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束
                    $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                    $ext['fonts_color'] = '';//字体颜色
                    $ext['desc'] = $msg;//禁言通知消息;
                    $ext['desc2'] = $msg;//禁言通知消息;

                    //消息发送者
                    $sender = array();
                    $sender['user_id'] = $GLOBALS['user_info']['id'];//发送人昵称
                    $sender['nick_name'] = emoji_decode($GLOBALS['user_info']['nick_name']);//发送人昵称
                    $sender['head_image'] = $GLOBALS['user_info']['head_image'];//发送人头像
                    $sender['user_level'] = $GLOBALS['user_info']['user_level'];//用户等级

                    $ext['sender'] = $sender;


                    #构造高级接口所需参数
                    $msg_content = array();
                    //创建array 所需元素
                    $msg_content_elem = array(
                        'MsgType' => 'TIMCustomElem',       //自定义类型
                        'MsgContent' => array(
                            'Data' => json_encode($ext),
                            'Desc' => '',
                            //	'Ext' => $ext,
                            //	'Sound' => '',
                        )
                    );
                    //将创建的元素$msg_content_elem, 加入array $msg_content
                    array_push($msg_content, $msg_content_elem);

                    $ret = $api->group_send_group_msg2($GLOBALS['user_info']['id'], $group_id, $msg_content);
                }


            } else {
                $root['error'] = api_lang("No_power_of_Estoppel");
            }
        }
        ajax_return($root);


    }


    /**
     * 设置/取消 管理员
     */
    public function set_admin()
    {

        $root = array();
        $root['status'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //
            $user_id = intval($GLOBALS['user_info']['id']);
            $to_user_id = intval($_REQUEST['to_user_id']);//被关注或取消 管理员用户
            $status = intval($_REQUEST['status']);// 1加入管理员2删除管理员
            $room_id = strim($_REQUEST['room_id']);
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $video_one = Db::name("video")->where("user_id=" . $user_id . " and is_voice=1 and live_in=1")->find();

            $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = '" . $user_id . "' and user_id = " . $to_user_id;
            $user_admin_id = $GLOBALS['db']->getOne($sql);
            if ($user_admin_id > 0) {
                if ($status == 1) {
                    // 已是管理员,不能重复加入
                    $root['error'] = api_lang("Already_an_administrator");
                    $root['status'] = 0;
                    ajax_return($root);
                }else{
                    //取消管理员操作;
                    $sql = "delete from " . DB_PREFIX . "user_admin where id = " . $user_admin_id;
                    $GLOBALS['db']->query($sql);
                    if($video_one){
                        // 删除房间管理员缓存
                        $video_redis->unset_room_administrator($video_one['id'],$to_user_id);
                    }
                }
            } else {
                $sql = "select count(id) as num from " . DB_PREFIX . "user_admin where podcast_id = " . $GLOBALS['user_info']['id'];
                if ($GLOBALS['db']->getOne($sql) < 5) {
                    //设置管理员操作;
                    $user_admin = array();
                    $user_admin['podcast_id'] = $GLOBALS['user_info']['id'];
                    $user_admin['user_id'] = $to_user_id;
                    $user_admin['create_time'] = NOW_TIME;
                    $GLOBALS['db']->autoExecute(DB_PREFIX . "user_admin", $user_admin, "INSERT");
                    if($video_one){
                        // 增加房间管理员缓存
                        $video_redis->set_room_administrator($video_one['id'],$to_user_id,1);
                    }
                } else {
                    $root['error'] = api_lang("There_are_more_than_5_administrators");
                    $root['status'] = 0;
                }
            }

            $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = '" . $user_id . "' and user_id = " . $to_user_id;
            if ($GLOBALS['db']->getOne($sql) > 0) {
                $root['has_admin'] = 1;//0:非管理员;1:是管理员
            } else {
                $root['has_admin'] = 0;
            }


            if ($root['status'] == 1 && $room_id != '') {

                $sql = "select nick_name from " . DB_PREFIX . "user where id = '" . $to_user_id . "'";
                if ($root['has_admin'] == 1) {
                    $msg = emoji_decode($GLOBALS['db']->getOne($sql)) . api_lang("Set_as_Administrator");
                } else {
                    $msg = emoji_decode($GLOBALS['db']->getOne($sql)) . api_lang("Administrator_cancelled");
                }


                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();

                //群播一个：直播消息
                $ext = array();
                $ext['type'] = 9; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束
                $ext['room_id'] = $room_id;//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
                $ext['fonts_color'] = '';//字体颜色
                $ext['desc'] = $msg;//禁言通知消息;
                $ext['desc2'] = $msg;//禁言通知消息;

                //消息发送者
                $sender = array();
                $sender['user_id'] = $GLOBALS['user_info']['id'];//发送人昵称
                $sender['nick_name'] = emoji_decode($GLOBALS['user_info']['nick_name']);//发送人昵称
                $sender['head_image'] = $GLOBALS['user_info']['head_image'];//发送人头像
                $sender['user_level'] = $GLOBALS['user_info']['user_level'];//用户等级

                $ext['sender'] = $sender;


                #构造高级接口所需参数
                $msg_content = array();
                //创建array 所需元素
                $msg_content_elem = array(
                    'MsgType' => 'TIMCustomElem',       //自定义类型
                    'MsgContent' => array(
                        'Data' => json_encode($ext),
                        'Desc' => '',
                        //	'Ext' => $ext,
                        //	'Sound' => '',
                    )
                );
                //将创建的元素$msg_content_elem, 加入array $msg_content
                array_push($msg_content, $msg_content_elem);


                $sql = "select group_id from " . DB_PREFIX . "video where id = '" . $room_id . "'";
                $group_id = $GLOBALS['db']->getOne($sql);

                $ret = $api->group_send_group_msg2($GLOBALS['user_info']['id'], $group_id, $msg_content);
                if ($ret['ActionStatus'] == 'FAIL' && $ret['ErrorCode'] == 10002) {
                    //10002 系统错误，请再次尝试或联系技术客服。
                    $ret = $api->group_send_group_msg2($GLOBALS['user_info']['id'], $group_id, $msg_content);
                }

            }

        }

        ajax_return($root);
    }

    /**
     * 举报用户
     */
    public function tipoff()
    {

        $root = array();
        $root['status'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {


            $to_user_id = intval($_REQUEST['to_user_id']);//被关注的举报用户ID
            $type = intval($_REQUEST['type']);
            $room_id = intval($_REQUEST['room_id']); //被举报的房间id

            $tipoff = array();
            $tipoff['from_user_id'] = $GLOBALS['user_info']['id'];
            $tipoff['to_user_id'] = $to_user_id;
            $tipoff['create_time'] = NOW_TIME;
            $tipoff['tipoff_type_id'] = $type;
            $tipoff['video_id'] = $room_id;
            $GLOBALS['db']->autoExecute(DB_PREFIX . "tipoff", $tipoff, "INSERT");

            if ($room_id > 0) {
                //累加举报次数
                $sql = "update " . DB_PREFIX . "video set tipoff_count = tipoff_count + 1 where id =" . $room_id;
                $GLOBALS['db']->query($sql);
            }
        }

        ajax_return($root);
    }

    /**
     * 主播管理员列表
     */
    public function user_admin()
    {

        $root = array();
        $root['status'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']);//用户ID


            $sql = "select ua.id, ua.user_id, u.nick_name,u.head_image,u.sex,u.user_level  from " . DB_PREFIX . "user_admin ua left join " . DB_PREFIX . "user u on u.id = ua.user_id where ua.podcast_id = " . $user_id;
            $list = $GLOBALS['db']->getAll($sql);
            foreach ($list as $k => $v) {
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
                $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
            }
            $root['list'] = $list;

            $root['max_num'] = 5;
            $root['cur_num'] = count($list);

            $root['status'] = 1;
        }

        ajax_return($root);
    }

    /**
     * 关注的用户，最多不超过100个
     */
    public function user_follow()
    {

        $root = array();
        $root['status'] = 1;
        //$GLOBALS['user_info']['id'] = 278;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']);//id
            $page = intval($_REQUEST['p']);//取第几页数据

            if ($page == 0) {
                $page = 1;
            }
            if (isset($_REQUEST['to_user_id'])) {
                $to_user_id = strim($_REQUEST['to_user_id']);//被查看的用户id
            } else {
                $to_user_id = $user_id;//id
            }

            $page_size = 20;
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $list = $user_redis->get_follonging_user($to_user_id, $page, $page_size);
            foreach ($list as $k => $v) {
                $list[$k]['signature'] = htmlspecialchars_decode($list[$k]['signature']);
                $list[$k]['nick_name'] = htmlspecialchars_decode($list[$k]['nick_name']);
                $list[$k]['signature'] = emoji_decode($list[$k]['signature']);
                $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
            }
            $root['list'] = $list;
            $rs_count = $user_redis->following();
            if ($page == 0) {
                $root['has_next'] = 0;
            } else {
                if (count($rs_count) >= $page_size)
                    $root['has_next'] = 1;
                else
                    $root['has_next'] = 0;
            }

            $root['page'] = $page;//

        }
        ajax_return($root);
    }

    /**
     * 粉丝列表，最多不超过100个
     */
    public function user_focus()
    {

        $root = array();
        $root['status'] = 1;
        //$GLOBALS['user_info']['id'] = 278;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//id
            if (isset($_REQUEST['to_user_id'])) {
                $to_user_id = strim($_REQUEST['to_user_id']);//被查看的用户id
            } else {
                $to_user_id = $user_id;
            }

            $page = intval($_REQUEST['p']);//取第几页数据
            if ($page == 0) {
                $page = 1;
            }
            $page_size = 20;
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $list = $user_redis->get_follonging_by_user($to_user_id, $page);
            $keys = $user_redis->following();
            foreach ($list as $k => $v) {
                if ($user_id > 0) {
                    if (in_array($v['user_id'], $keys)) {
                        $list[$k]['follow_id'] = 1;
                    } else {
                        $list[$k]['follow_id'] = 0;
                    }
                } else {
                    $list[$k]['follow_id'] = 0;
                }
                $list[$k]['head_image'] = get_spec_image($v['head_image']);
                $list[$k]['nick_name'] = htmlspecialchars_decode($list[$k]['nick_name']);
                $list[$k]['signature'] = htmlspecialchars_decode($list[$k]['signature']);
                $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
                $list[$k]['signature'] = emoji_decode($list[$k]['signature']);
            }
            $root['list'] = $list;


            if ($page == 0) {
                $root['has_next'] = 0;
            } else {
                if (count($list) >= $page_size)
                    $root['has_next'] = 1;
                else
                    $root['has_next'] = 0;
            }

            $root['page'] = $page;//

        }
        ajax_return($root);
    }

    /**
     * 分享成功回调
     * type: 分享类型（WEIXIN,WEIXIN_CIRCLE,QQ,QZONE,EMAIL,SMS,SINA 微信，微信朋友圈，qq，QQ空间，email，短信，新浪微博）
     */
    public function share()
    {

        $root = array();
        $root['status'] = 1;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $type = strtolower(strim($_REQUEST['type']));//WEIXIN,WEIXIN_CIRCLE,QQ,QZONE,EMAIL,SMS,SINA

            $room_id = intval($_REQUEST['room_id']);//直播ID 也是room_id

            //分享加印票功能
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            //每个房间每个类型可以分享一次，主播分享自己房间不获得
            if (defined('OPEN_SHARE_EXPERIENCE') && OPEN_SHARE_EXPERIENCE == 1 && intval($m_config['open_share_ticket'])) {

                $sql = "select max(id) from " . DB_PREFIX . "video_share  where video_id = " . $room_id . " and user_id =" . $user_id . " and type = '" . $type . "'";
                $exist_share_id = $GLOBALS['db']->getOne($sql);

                //获取主播ID
                $sql = "select user_id as from_user_id from " . DB_PREFIX . "video where id =" . $room_id;
                $video_user_info = $GLOBALS['db']->getRow($sql);

                $share_id = intval($exist_share_id);
                if ($share_id == 0) {
                    //分享表中无记录，查分享历史表
                    $sql = "select id  from " . DB_PREFIX . "video_share_history  where video_id = " . $room_id . " and user_id =" . $user_id . " and type = '" . $type . "'";
                    $share_id = intval($GLOBALS['db']->getOne($sql));
                }
                $now_time = NOW_TIME;
                $s_now_time = to_timespan(to_date($now_time, "Y-m-d 00:00:00"));
                $e_now_time = to_timespan(to_date($now_time, "Y-m-d 23:59:59"));

                if ($share_id == 0) {
                    $sql = "select max(id) from " . DB_PREFIX . "video_share  where  user_id =" . $user_id . " and type = '" . $type . "' and create_time>" . $s_now_time . " and create_time<" . $e_now_time;
                    $video_t_share_id = $GLOBALS['db']->getOne($sql);

                    $share_id = intval($video_t_share_id);
                    if ($share_id == 0) {
                        //分享表中无记录，查分享历史表
                        $sql = "select id  from " . DB_PREFIX . "video_share_history  where user_id =" . $user_id . " and type = '" . $type . "' and create_time>" . $s_now_time . " and create_time<" . $e_now_time;
                        $share_id = intval($GLOBALS['db']->getOne($sql));
                    }
                }
            }


            //每个用户每个房间可以分享一次，增加分享次数

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            //$video_redis->incry($this->video_db.$room_id, 'share_count', 1);
            $video_redis->redis->hIncrBy($video_redis->video_db . $room_id, 'share_count', 1);
            $data = array();
            //写入分享表
            $video_monitor = array();
            $video_monitor['user_id'] = $user_id;
            $video_monitor['video_id'] = $room_id;
            $video_monitor['type'] = $type;
            $video_monitor['create_time'] = NOW_TIME;
            $GLOBALS['db']->autoExecute(DB_PREFIX . "video_share", $video_monitor, "INSERT");

            $video_share_id = $GLOBALS['db']->insert_id();
            if (defined('OPEN_MISSION') && OPEN_MISSION) {
                require_once APP_ROOT_PATH . 'mapi/lib/core/Model.class.php';
                Model::$lib = dirname(__FILE__);
                Model::build('mission')->incProgress($user_id, 3);
            }
            if (defined('OPEN_SHARE_EXPERIENCE') && OPEN_SHARE_EXPERIENCE == 1 && intval($m_config['open_share_ticket'])) {
                //历史记录中也没有，可以增加
                if ($share_id == 0 && intval($m_config['share_ticket']) > 0 && intval($video_user_info['from_user_id']) != $user_id && intval($video_share_id) > 0) {
                    //根据open_share_ticket决定获得印票或钻石 1印票 2钻石
                    $ticket_name = $m_config['ticket_name'];
                    if (intval($m_config['open_share_ticket']) == 1) {
                        $sql = "update " . DB_PREFIX . "user set ticket = ticket + " . intval($m_config['share_ticket']) . " where id =" . $user_id;
                        $data['ticket'] = intval($m_config['share_ticket']);
                        if ($ticket_name == '') {
                            $ticket_name = api_lang("Printing_tickets");
                        }
                    } else {
                        $sql = "update " . DB_PREFIX . "user set diamonds = diamonds + " . intval($m_config['share_ticket']) . " where id =" . $user_id;
                        $data['diamonds'] = intval($m_config['share_ticket']);
                        $ticket_name = api_lang("Diamonds");
                    }
                    $GLOBALS['db']->query($sql);//增加用户印票或钻石
                    user_deal_to_reids(array($user_id));//同步用户redis

                    //请求返回信息
                    $root['share_award'] = intval($m_config['share_ticket']);
                    $root['share_award_type'] = $ticket_name;
                    $root['share_award_info'] = api_lang("Share_live") . $ticket_name . intval($m_config['share_ticket']);

                    //写入用户日志
                    $data['log_admin_id'] = 0;
                    $data['video_id'] = $room_id;
                    $param['type'] = 4;//类型 0表示充值 1表示提现 2赠送道具 3 兑换印票 4 分享获得印票
                    $log_msg = api_lang("adopt") . $type . api_lang("Sharing_studio") . $room_id . '，' . api_lang("obtain") . intval($m_config['share_ticket']) . $ticket_name;
                    account_log_com($data, $user_id, $log_msg, $param);
                }
            }
        }

        ajax_return($root);
    }

    /**
     * 更新设备号
     */
    public function apns()
    {
        $root = array();
        $root['status'] = 1;
        //$GLOBALS['user_info']['id'] = 1;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $apns_code = addslashes($_REQUEST['apns_code']);

            if (!$apns_code) {
                $root['error'] = api_lang("Equipment_number_is_empty");
                $root['status'] = 0;
                ajax_return($root);
            }

            //apns_code 友盟消息推送服务对设备的唯一标识。Android的device_token是44位字符串, iOS的device-token是64位
            //device_type 1:android; 2:ios
            if (strlen($apns_code) == 44) {
                $device_type = 1;
            } else if (strlen($apns_code) == 64) {
                $device_type = 2;
            } else {
                $device_type = 0;
            }

            $sql = 'update ' . DB_PREFIX . "user set apns_code ='" . $apns_code . "',device_type='" . $device_type . "' where id =" . $user_id;
            $GLOBALS['db']->query($sql);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $data['apns_code'] = $apns_code;
            $data['device_type'] = $device_type;
            $user_redis->update_db($user_id, $data);

        }

        ajax_return($root);
    }

    /**
     * 查看个人主页
     */
    public function user_home()
    {

        $root = array();

        $user_id= $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : 168279;
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
         //   $user_id = intval($GLOBALS['user_info']['id']);//用户ID

            $to_user_id = intval($_REQUEST['to_user_id']);//被查看的用户id
            if ($to_user_id == 0) {
                $to_user_id = $user_id;
            }

            $root = getuserinfo($user_id, 0, $to_user_id);
            $root['status'] = 1;

            //格式化基本资料
            $item[] = $root['user']['item'];
            $new = [];
            if (count($item) > 0) {
                foreach ($item as $v) {
                    foreach ($v as $k => $s) {
                        $new[][$k] = $s;
                    }
                }
            }

            $root['user']['new_item'] = array_values($new);


            //格式化数据(大于10000保留两位小数，否则不变)
            //bogo_require(APP_ROOT_PATH . 'mapi/lib/core/num_format.php');
            $root['user']['n_fans_count'] = format_for_ten_thousand($root['user']['fans_count']);
            $root['user']['n_focus_count'] = format_for_ten_thousand($root['user']['focus_count']);
            $root['user']['n_use_diamonds'] = format_for_ten_thousand($root['user']['use_diamonds']);
            $root['user']['n_ticket'] = format_for_ten_thousand($root['user']['ticket']);
            $root['user']['n_video_count'] = format_for_ten_thousand($root['user']['video_count']);
            $root['user']['n_useable_ticket'] = format_for_ten_thousand($root['user']['useable_ticket']);
            $root['user']['n_diamonds'] = format_for_ten_thousand($root['user']['diamonds']);
            $root['user']['n_use_diamonds'] = format_for_ten_thousand($root['user']['use_diamonds']);
            $root['user']['n_show_user_order'] = format_for_ten_thousand($root['user']['show_user_order']);
            $root['user']['n_user_order'] = format_for_ten_thousand($root['user']['user_order']);
            $root['user']['n_show_user_pai'] = format_for_ten_thousand($root['user']['show_user_pai']);
            $root['user']['n_user_pai'] = format_for_ten_thousand($root['user']['user_pai']);
            $root['user']['n_show_podcast_order'] = format_for_ten_thousand($root['user']['show_podcast_order']);
            $root['user']['n_podcast_order'] = format_for_ten_thousand($root['user']['podcast_order']);
            $root['user']['n_show_shopping_cart'] = format_for_ten_thousand($root['user']['show_shopping_cart']);
            $root['user']['n_shopping_cart'] = format_for_ten_thousand($root['user']['shopping_cart']);
            $root['user']['n_podcast_goods'] = format_for_ten_thousand($root['user']['podcast_goods']);
            $root['user']['n_coin'] = format_for_ten_thousand($root['user']['coin']);
            $root['user']['n_podcast_pai'] = format_for_ten_thousand($root['user']['podcast_pai']);
            $root['user']['n_shop_goods'] = format_for_ten_thousand($root['user']['shop_goods']);
            $root['user']['n_svideo_count'] = format_for_ten_thousand($root['user']['svideo_count']);

            if (!$root['user']['luck_num']) {
                $root['user']['luck_num'] = '';
            }


            $root['user']['is_shop'] = 0; //小店
            //小店
            if (defined('OPEN_MY_SHOP') && OPEN_MY_SHOP == 1) {
                //检查是否已经开通小店
                $sql = "select * from " . DB_PREFIX . "shop where status = 1 and user_id=" . $to_user_id;
                $shop_record = $GLOBALS['db']->getRow($sql);
                if ($shop_record) {
                    $root['user']['is_shop'] = 1;
                }
            }
            //检查是否已经开通商城店铺
            $sql = "select * from " . DB_PREFIX . "shop_store where  uid=" . $to_user_id;
            $shop_store = $GLOBALS['db']->getRow($sql);
            $root['user']['is_open_shop'] = 0;//商城店铺
            if ($shop_store['status'] == 1) {
                $root['user']['is_open_shop'] = 1;
            }
            //商城店铺审核状态
            $root['user']['shop_status'] = empty($shop_store) ? -1 : $shop_store['status'];//0 审核中 1通过 2失败 -1未提交


        }

        ajax_return($root);

    }

    /**
     * 直播回看
     */
    public function user_review()
    {
        $root = array();

        //$GLOBALS['user_info']['id'] = 1;


        $to_user_id = intval($_REQUEST['to_user_id']);//被查看的用户id
        if ($to_user_id == 0) {
            $to_user_id = intval($GLOBALS['user_info']['id']);
        }

        $sort = intval($_REQUEST['sort']);//排序类型; 0:最新;1:最热


        $page = intval($_REQUEST['p']);//取第几页数据
        if ($page == 0) $page = 1;
        $page_size = 10;

        $limit = (($page - 1) * $page_size) . "," . $page_size;

        $sort_field = "vh.begin_time desc";
        if ($sort == 1) {
            $sort_field = "vh.max_watch_number desc";
        }

        //video_count
        if ($to_user_id == intval($GLOBALS['user_info']['id'])) {
            $sql = "select vh.id,vh.id as room_id,vh.group_id,vh.live_image,vh.live_in,vh.title,vh.begin_time,vh.max_watch_number,vh.video_vid,vh.video_type,vh.channelid,vh.create_time,u.id as user_id,u.head_image,u.nick_name from " . DB_PREFIX . "video_history as vh left join " . DB_PREFIX . "user as u on u.id= vh.user_id  where vh.group_id!='' and  vh.is_delete = 0 and vh.is_del_vod = 0 and vh.user_id = '" . $to_user_id . "' order by " . $sort_field . " limit " . $limit;
        } else {
            $sql = "select vh.id,vh.id as room_id,vh.group_id,vh.live_image,vh.live_in,vh.title,vh.begin_time,vh.max_watch_number,vh.video_vid,vh.video_type,vh.channelid,vh.create_time,u.id as user_id,u.head_image,u.nick_name from " . DB_PREFIX . "video_history as vh left join " . DB_PREFIX . "user as u on u.id= vh.user_id  where vh.group_id!='' and  vh.is_delete = 0 and vh.is_del_vod = 0 and vh.is_live_pay = 0 and user_id = '" . $to_user_id . "' order by " . $sort_field . " limit " . $limit;
        }

        $list = array();
        $list_arr = array();
        $list_info = $GLOBALS['db']->getAll($sql);
        foreach ($list_info as $k => $v) {

            /*//判断视频存在
            bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
            $video_factory = new VideoFactory();

            if($v['video_type'] == 1 && $v['channelid'])
            {
                if(strlen($v['channelid'])>20){
                    $fileName = $v['channelid'];
                       $ret = $video_factory->DescribeVodPlayInfo($fileName);
                }else{
                    $ret = $video_factory->GetVodRecordFiles($v['channelid'], $v['create_time']);
                }
            }else{
                $fileName = $v['id'] . '_' . to_date($v['begin_time'],'Y-m-d-H');
                $ret = $video_factory->DescribeVodPlayInfo($fileName);
            }

            if($ret['codeDesc'] == 'Success'){
                $list_arr = $v;
                $list_arr['head_image'] =  get_spec_image($v['head_image'],150,150);
                $list_arr['begin_time_format'] = format_show_date($v['begin_time']);
                if ($v['max_watch_number'] > 10000){
                    $list_arr['watch_number_format'] = round($v['max_watch_number']/10000,2)."万";
                }else{
                    $list_arr['watch_number_format'] = $v['max_watch_number'];
                }

                $list_arr['max_watch_number'] = $v['max_watch_number'];

                if($v['title'] == '')
                    $list_arr['title'] = "....";

                $list[] = $list_arr;
            }else{
                //会误删
                $sql = "update ".DB_PREFIX."video_history set is_del_vod = 1 where id =".$v['id'];
                //$GLOBALS['db']->query($sql);
            }*/
            $list_arr = $v;
            $list_arr['live_image'] = get_spec_image($v['live_image']);
            $list_arr['head_image'] = get_spec_image($v['head_image'], 150, 150);
            $list_arr['begin_time_format'] = format_show_date($v['begin_time']);
            if ($v['max_watch_number'] > 10000) {
                $list_arr['watch_number_format'] = round($v['max_watch_number'] / 10000, 2) . api_lang("ten_thousand");
            } else {
                $list_arr['watch_number_format'] = $v['max_watch_number'];
            }

            $list_arr['max_watch_number'] = $v['max_watch_number'];
            //20170930 Ios端逻辑处理添加 @slf
            $list_arr['live_in'] = 3;

            if ($v['title'] == '')
                $list_arr['title'] = "....";

            $list[] = $list_arr;

        }
        $root['list'] = $list;

        if ($to_user_id == intval($GLOBALS['user_info']['id'])) {
            $sql = "select count(*)  from " . DB_PREFIX . "video_history as vh left join " . DB_PREFIX . "user as u on u.id= vh.user_id  where vh.group_id!='' and  vh.is_delete = 0 and vh.is_del_vod = 0 and vh.user_id = '" . $to_user_id . "' order by " . $sort_field;
        } else {
            $sql = "select count(*)  from " . DB_PREFIX . "video_history as vh left join " . DB_PREFIX . "user as u on u.id= vh.user_id  where vh.group_id!='' and  vh.is_delete = 0 and vh.is_del_vod = 0 and vh.is_live_pay = 0 and user_id = '" . $to_user_id . "' order by " . $sort_field;
        }

        $count = $GLOBALS['db']->getOne($sql);
        //$count = count($list);
        if ($count >= $page_size)
            $root['has_next'] = 1;
        else
            $root['has_next'] = 0;

        $root['count'] = $count;
        if ($to_user_id == intval($GLOBALS['user_info']['id']) && $page == 1) {

            $sql = "update " . DB_PREFIX . "user set video_count = " . $root['count'] . " where id = " . intval($GLOBALS['user_info']['id']) . " and video_count!=" . $root['count'];
            $GLOBALS['db']->query($sql);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_data = array();
            $user_data['video_count'] = $root['count'];
            $user_redis->update_db(intval($GLOBALS['user_info']['id']), $user_data);
        }

        $root['page'] = $page;
        $root['status'] = 1;

        ajax_return($root);
    }

    /**
     * 设置黑名单
     */
    public function set_black()
    {
        $root = array();

        //$GLOBALS['user_info']['id'] = 269;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //
            $user_id = intval($GLOBALS['user_info']['id']);//当前用户;

            $to_user_id = intval($_REQUEST['to_user_id']);//被关注或取消关注的用户
            if ($user_id != $to_user_id) {
                $root = set_black($user_id, $to_user_id);
            } else {
                $root['error'] = api_lang("You_cannot_set_yourself");
                $root['status'] = 0;
            }
        }
        ajax_return($root);
    }

    /**
     * 搜索用户列表
     */
    public function search()
    {

        $user_id = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : intval($_REQUEST['uid']);//id
        $root = array();
        $root['status'] = 1;
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $keyword = strim($_REQUEST['keyword']);//搜索关键字
            if ($keyword != "") {
                $page = intval($_REQUEST['p']);//取第几页数据

                if ($page == 0) $page = 1;
                $page_size = 20;
                $limit = (($page - 1) * $page_size) . "," . $page_size;

                $m_config = load_auto_cache("m_config");//初始化手机端配置
                $limit = $page == 1 ? "20" : $limit;

                if ($m_config['search_change'] == 0) {    //精准搜索 //如果搜索关键字为数字//搜索ID，昵称,靓号，不为机器人。
                    $where = "(u.id = '" . $keyword . "' or u.luck_num = '" . $keyword . "' or u.nick_name = '" . $keyword . "')  and u.is_robot = 0 limit " . $limit;
                } else {//模糊搜索
                    $where = "(u.id like '%" . $keyword . "%' or u.luck_num like '%" . $keyword . "%' or u.nick_name like '%" . $keyword . "%')  and u.is_robot = 0  limit " . $limit;
                }
                $sql = "select u.id as user_id,u.nick_name,u.signature,u.sex,u.head_image,u.user_level,u.v_icon from " . DB_PREFIX . "user u where " . $where;

                //查询用户列表,修改成 从只读数据库中取,但不是高效做法;主并发时,可以加入阿里云的搜索服务
                //https://www.aliyun.com/product/opensearch?spm=5176.8142029.388261.62.tgDxhe
                $list = $GLOBALS['db']->getAll($sql, true, true);
                $keys = array();

                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
                $user_redis = new UserFollwRedisService($user_id);
                $keys = $user_redis->following();
                foreach ($list as $k => $v) {
                    if (in_array($v['user_id'], $keys)) {
                        $list[$k]['follow_id'] = $v['user_id'];
                    } else {
                        $list[$k]['follow_id'] = 0;
                    }
                    $list[$k]['head_image'] = get_spec_image($v['head_image']);
                    $list[$k]['signature'] = htmlspecialchars_decode($list[$k]['signature']);
                    $list[$k]['nick_name'] = htmlspecialchars_decode($list[$k]['nick_name']);
                    $list[$k]['signature'] = emoji_decode($list[$k]['signature']);
                    $list[$k]['nick_name'] = emoji_decode($list[$k]['nick_name']);
                }

                if (count($list) > 0) {
                    $root['list'] = $list;
                }
                if (count($list) == $page_size) {
                    $root['has_next'] = 1;
                } else {
                    $root['has_next'] = 0;
                }
                $root['page'] = $page;
            } else {
                $root['has_next'] = 0;
                //$root['list'] = array();
                $root['page'] = 0;
            }
        }
        ajax_return($root);
    }

    /**
     * 批量导入未同步的用户到im
     */
    public function account_import()
    {
        $root = array();
        $root['status'] = 1;

        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();

        $sql = "select id,nick_name,head_image from " . DB_PREFIX . "user where synchronize = 0 limit 10";

        $list = $GLOBALS['db']->getAll($sql);

        foreach ($list as $k => $v) {
            $face_url = get_spec_image($v['head_image']);
            $ret = $api->account_import((string)$v['id'], $v['nick_name'], $face_url);
            if ($ret['ActionStatus'] == 'OK') {
                $sql = 'update ' . DB_PREFIX . "user set synchronize =1 where id =" . $v['id'];
                $GLOBALS['db']->query($sql);
            } else {
                $root['ret'][$v['id']] = $ret;
            }
            //print_r($ret);
        }
        ajax_return($root);
    }

    /**
     * 允许直播的话，未同意状态改为同意
     */
    public function agree()
    {
        $user_id = intval($GLOBALS['user_info']['id']);
        if ($user_id) {
            $GLOBALS['db']->query("update " . DB_PREFIX . "user set is_agree =1 where   id=" . $user_id . "  and is_agree = 0  ");

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $data['is_agree'] = 1;
            $user_redis->update_db($user_id, $data);
        }

        $root['status'] = 1;
        $root['error'] = '';

        ajax_return($root);
    }

    /**
     * 一次性取出,我关注的用户列表
     */
    public function my_follow()
    {

        $root = array();
        $root['status'] = 1;
//		$GLOBALS['user_info']['id'] = 290;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']);//id

//			$sql = "select f.podcast_id as user_id from ".DB_PREFIX."focus f where f.user_id = ".$user_id;
//
//			//$root['sql'] = $sql;
//
//			$list = $GLOBALS['db']->getAll($sql);
//			$root['list'] = $list;

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $root['list'] = $user_redis->get_follonging_user($user_id, 1, 1000);

            if (!empty($root['list'])) {
                for ($i = 0; $i < count($root['list']); $i++) {
                    $root['list'][$i]['nick_name'] = emoji_decode($root['list'][$i]['nick_name']);
                    $root['list'][$i]['signature'] = emoji_decode($root['list'][$i]['signature']);
                }
            }

        }
        ajax_return($root);
    }

    /**
     * 好友，相互关注的用户;用于私密直播时，添加的用户列表
     */
    public function friends()
    {

        $root = array();
        $root['status'] = 1;
        //$GLOBALS['user_info']['id'] = 278;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            $user_id = intval($GLOBALS['user_info']['id']);//id
            $video_id = intval($_REQUEST['room_id']);

            $page = intval($_REQUEST['p']);//取第几页数据

            if ($page == 0) {
                $page = 1;
            }

            $page_size = 20;

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserFollwRedisService.php');
            $user_redis = new UserFollwRedisService($user_id);
            $root = $user_redis->get_private_user($page, $page_size);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $video_data = $video_redis->getRow_db($video_id, array('group_id', 'user_id'));

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
            $video_viewer_redis = new VideoViewerRedisService();
            $group_id = $video_data['group_id'];//聊天群id

            if ($group_id) {
                $users = $video_viewer_redis->get_viewer_list($group_id, $page);
                if ($users['list']) {
                    $user_ids = array_column($users['list'], 'user_id');
                    $friends = $root['list'];
                    foreach ($friends as $k => $v) {
                        if (in_array($v['user_id'], $user_ids) || $v['user_id'] == $video_data['user_id']) {
                            unset($friends[$k]);
                        }
                    }
                    $root['list'] = array_values($friends);
                }
            }

        }

        if (!empty($root['list'])) {
            for ($i = 0; $i < count($root['list']); $i++) {
                $root['list'][$i]['nick_name'] = emoji_decode($root['list'][$i]['nick_name']);
                $root['list'][$i]['signature'] = emoji_decode($root['list'][$i]['signature']);
            }
        }

        ajax_return($root);
    }

    /**
     * 获得用户基本信息(比如：固化的信息比如：头像，性别，昵称，等级，签名等）
     */
    public function baseinfo()
    {
        $root = array();

        //$GLOBALS['user_info']['id'] = 292;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);

            $user_ids = strim($_REQUEST['user_ids']);//字符串类型的用户id 23,123,3455 以英文逗号分割的字符串 ,一次不能大于100个用户


            if ($user_ids == '') {
                $user_ids = $user_id;
            }

            //将选中的：私聊 数据添加到数据库中
            $user_list = explode(',', $user_ids);

            if (count($user_list) > 100) {
                $root['status'] = 0;
                $root['error'] = api_lang("No_more_than_100_users_time");

            } else {

                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();

                $list = $user_redis->get_m_user($user_list);
                /*

                $fields = array('id','is_agree','video_count','is_authentication','nick_name','signature','sex','province','city','head_image','ticket','use_diamonds','user_level','v_type','v_explain','v_icon','is_remind');



                foreach ( $user_list as $k => $v )
                {
                    $userinfo = $user_redis->getRow_db($v,$fields);
                    $userinfo['user_id'] = $v;
                    $list[] = $userinfo;
                }



                $sql = "select id as user_id,is_agree,is_authentication,nick_name,signature,sex,province,city,head_image,user_level,v_type,v_explain,v_icon from ".DB_PREFIX."user where id in (".$user_ids.")";

                $list = $GLOBALS['db']->getAll($sql);
                foreach ( $list as $k => $v )
                {
                    $list[$k]['head_image'] = get_abs_img_root($v['head_image']);
                }
                */

                $root['list'] = $list;

                if (!empty($root['list'])) {
                    for ($i = 0; $i < count($root['list']); $i++) {
                        $root['list'][$i]['nick_name'] = emoji_decode($root['list'][$i]['nick_name']);
                    }
                }

                $root['status'] = 1;
            }
        }
        ajax_return($root);
    }

    /**
     * app呼醒跟进入后台时调用【用来统计用户在线时长】
     */
    function state_change()
    {
        $root = array();
        $root['status'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
            $action = strim($_REQUEST['action']);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            if (strtolower($action) == 'login') {
                $data = array('is_online' => 1, 'login_time' => to_date(NOW_TIME));
                $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, "UPDATE", 'id=' . $user_id);
                $user_redis->update_db($user_id, $data);
            } else {
                $data = array('is_online' => 0, 'login_time' => to_date(NOW_TIME), 'logout_time' => to_date(NOW_TIME));

                $user = $user_redis->getRow_db($user_id, array('login_time', 'logout_time', 'online_time'));
                $user['online_time']= $user['online_time'] > 0 ? $user['online_time'] : 0;
                $user['login_time']= $user['login_time'] > 0 ? $user['login_time'] : 0;
                $login_time = to_timespan($user['login_time']);
                if ($login_time == 0) {
                    $data['login_time'] = to_date(NOW_TIME);
                }

                //计算在线时长
                $online = NOW_TIME - $login_time > 0 ? NOW_TIME - $login_time : 0;

                if ($online > 7200) {
                    //异常数据,一次不可能超过8小时
                    $online = 0;
                }

                $data['online_time'] = $user['online_time'] + $online;

                $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, "UPDATE", 'id=' . $user_id);
                if ($GLOBALS['db']->affected_rows()) {
                    $user_redis->update_db($user_id, $data);

                    //更新用户等级
                    $user_info = $user_redis->getRow_db($user_id, array('id', 'score', 'online_time', 'user_level'));
                    user_leverl_syn($user_info);
                }
            }

        }
        ajax_return($root);

    }

    /**
     * 用户是否 开启关闭隐身功能 【废】
     */
    public function is_noble_stealth()
    {

        $user_id = intval($GLOBALS['user_info']['id']);//用户id

        $type = $_REQUEST['type'] == '1' ? $_REQUEST['type'] : '0';//类型

        $data = array('status' => 1, 'error' => '');

        if (!$user_id) {
            $data['error'] = api_lang("user_not_logged_in");
            $data['status'] = 0;
            $data['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($data);
            exit;
        }
        $user = $GLOBALS['db']->getRow("select nobleid,noble_time from " . DB_PREFIX . "user where id=" . $user_id . " and noble_time >=" . time());
        $nobleid = $user && $user['nobleid'] ? $user['nobleid'] : 0;
        $is_noble_stealth = 0;
        //获取贵族权限
        if ($user['nobleid'] > 0 && $user['noble_time'] > NOW_TIME) {
            $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
            if ($jurisdiction && $jurisdiction['is_stealth_approach'] == 1) {
                $is_noble_stealth = 1;
            } else {
                $types = $GLOBALS['db']->getRow("select type,name from " . DB_PREFIX . "noble_classification where status=1 and  id=" . $nobleid);
                if ($types) {
                    $sql = "select * from " . DB_PREFIX . "noble_type where status=1 and id in (" . $types['type'] . ") order by sort asc";
                    $noble_type = $GLOBALS['db']->getAll($sql, true, true);
                    foreach ($noble_type as $v) {
                        switch ($v['type']) {
                            case '12':
                                $is_noble_stealth = 1;
                                break;
                            default:
                                break;
                        }
                    }
                }
            }
        }

        if ($is_noble_stealth == 0) {
            $data['status'] = 0;
            $data['error'] = api_lang("Please_buy_more_noble");
            ajax_return($data);
            exit;
        }

        $sql = "update " . DB_PREFIX . "user set is_noble_stealth = " . $type . " where id=" . $user_id;
        $name = $GLOBALS['db']->query($sql);

        if ($name) {
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
            es_session::set("user_info", $user_info);
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_redis->update_db($user_id, $user_info);

            $data['status'] = 1;
            $data['type'] = $type;
            $data['error'] = api_lang("operation_was_successful");
        } else {
            $data['error'] = api_lang("operation_failed");
        }
        ajax_return($data);
        exit;
    }

    /**
     * 是否开启榜单隐身功能0否1是
     */
    public function is_noble_ranking_stealth()
    {

        $user_id = intval($GLOBALS['user_info']['id']);//用户id

        $type = $_REQUEST['type'] == '1' ? $_REQUEST['type'] : '0';//类型

        $data = array('status' => 1, 'error' => '');

        if (!$user_id) {
            $data['error'] = api_lang("user_not_logged_in");
            $data['status'] = 0;
            $data['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($data);
            exit;
        }

        $user = $GLOBALS['db']->getRow("select nobleid,noble_time from " . DB_PREFIX . "user where id=" . $user_id . " and noble_time >=" . time());
        $nobleid = $user && $user['nobleid'] ? $user['nobleid'] : 0;
        $is_noble_ranking_stealth = 0;
        //获取贵族权限
        $stealth_name='';

        $types = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "aristocratic_classification where status=1 and  type=14");
        if ($user['nobleid'] > 0 && $user['noble_time'] > NOW_TIME) {
            $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
            if ($jurisdiction && $jurisdiction['is_list_invisible'] == 1) {
                $is_noble_ranking_stealth = 1;
            } else {
                if ($types) {
                    if ($types['aristocratic_id']){
                        if (strpos($types['aristocratic_id'], ",".$nobleid.",") !== false) {
                            $is_noble_ranking_stealth = 1;
                        }

                    }
                }
            }
        }

        if ($is_noble_ranking_stealth == 0) {
            if($types){
                $aristocratic_in = trim($types['aristocratic_id'], ',');
                $sql = "select * from " . DB_PREFIX . "aristocratic where status=1 and id in (" . $aristocratic_in . ") order by sort asc";
                $noble_type = $GLOBALS['db']->getRow($sql, true, true);
                if($noble_type){
                    $stealth_name= $noble_type['name'];
                }
            }


            $data['status'] = 0;
            $data['error'] = api_lang("Please_buy_more_noble")."(".$stealth_name.")";
            ajax_return($data);
            exit;
        }

        $sql = "update " . DB_PREFIX . "user set is_noble_ranking_stealth = " . $type . " where id=" . $user_id;
        $name = $GLOBALS['db']->query($sql);

        if ($name) {
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
            es_session::set("user_info", $user_info);
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_redis->update_db($user_id, $user_info);

            $data['status'] = 1;
            $data['type'] = $type;
            $data['error'] = api_lang("operation_was_successful");
        } else {
            $data['error'] = api_lang("operation_failed");
        }
        ajax_return($data);
        exit;
    }

    /**
     * 是否开启隐身进场
     *  【现用着的接口】
     *  隐身后导致在线人数和观众列表展示不一致
     */
    public function is_noble_mysterious()
    {

        $data = array('status' => 0, 'error' => api_lang("parameter_error"));

        //用户id
        $user_id = intval($GLOBALS['user_info']['id']);

        $type = intval($_REQUEST['type']) == 1 ? 1 : 0;//类型

        if (!$user_id) {
            ajax_return($data);
            exit;
        }

        $user = $GLOBALS['db']->getRow("select nobleid,noble_time from " . DB_PREFIX . "user where id=" . $user_id . " and noble_time >=" . NOW_TIME);
        $nobleId = $user && $user['nobleid'] ? $user['nobleid'] : 0;
        $is_noble_mysterious = 0;
        //获取贵族权限
        $stealth_name='';
        $types = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "aristocratic_classification where status=1 and  type=12");
        if ($user['nobleid'] > 0 && $user['noble_time'] > NOW_TIME) {
            $jurisdiction = load_auto_cache("noble_id", ['id' => $user['nobleid']]);
            if ($jurisdiction && $jurisdiction['is_list_invisible'] == 1) {
                $is_noble_mysterious = 1;
            } else {
                if ($types) {
                    if ($types['aristocratic_id']){
                        if (strpos($types['aristocratic_id'], ",".$nobleId.",") !== false) {
                            $is_noble_mysterious = 1;
                        }
                    }
                }
            }
        }
        if ($is_noble_mysterious == 0) {
            if ($types) {
                $aristocratic_in = trim($types['aristocratic_id'], ',');
                $sql = "select * from " . DB_PREFIX . "aristocratic where status=1 and id in (" . $aristocratic_in . ") order by sort asc";
                $noble_type = $GLOBALS['db']->getRow($sql, true, true);
                if($noble_type){
                    $stealth_name= $noble_type['name'];
                }
            }
            $data['error'] = api_lang("Please_buy_more_noble")."(".$stealth_name.")";
            ajax_return($data);
            exit;
        }
        $sql = "update " . DB_PREFIX . "user set is_noble_mysterious = " . $type . ",is_noble_stealth=" . $type . " where id=" . $user_id;
        $res = $GLOBALS['db']->query($sql);

        if ($res) {
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
            es_session::set("user_info", $user_info);
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_redis->update_db($user_id, $user_info);

            $data['status'] = 1;
            $data['type'] = $type;
            $data['error'] = api_lang("operation_was_successful");
        } else {
            $data['error'] = api_lang("operation_failed");
        }
        ajax_return($data);
        exit;
    }

    /*用户浏览记录*/
    public function user_record()
    {
        $root = array('status' => 1, 'data' => []);

        $user_id = $GLOBALS['user_info']['id'] ? $GLOBALS['user_info']['id'] : $_REQUEST['uid'];//用户id
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 0;//分页
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $sql = "select u.id,u.nick_name,u.head_image from " . DB_PREFIX . 'user_record a left join ' . DB_PREFIX . 'user u on a.to_user_id = u.id where a.uid = ' . $user_id . ' order by a.addtime desc limit ' . $page . ",20";
            $list = $GLOBALS['db']->getAll($sql);

            if (count($list) > 0) {
                foreach ($list as &$v) {
                    $v['head_image'] = get_abs_img_root($v['head_image']);
                }
            }

            $root['data'] = $list;

        }
        ajax_return($root);
    }
}