<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------
use think\Db;

class user_centerModule extends baseModule
{


    //收支记录【新】
    public function coin_recode()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $user_id = intval($_REQUEST['uid']) ? intval($_REQUEST['uid']) : intval($GLOBALS['user_info']['id']);
        $time = $_REQUEST['time'] ? $_REQUEST['time'] : date('Y-m'); //输入要查询的时间【格式：2021-04】
        $type = intval($_REQUEST['type']) ? intval($_REQUEST['type']) : 1; //账单类型【1充值明细；2消费明细】
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1; //分页

        if (!$user_id) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            api_ajax_return($root);
        }
        $m_config = load_auto_cache("m_config");
        $startime = strtotime($time); //查询的开始时间
        $endtime = strtotime("$time +1 month"); //查询结束时间
        $page_size = 20;
        $p = $page_size * ($page - 1);
        $limit = $p . "," . $page_size;

        if ($type == 2) { //2消费明细

            $sql = "select u.nick_name,v.consumption as `diamonds`,v.content,v.create_time,v.type from " . DB_PREFIX . "user_consumption_log as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = v.received_uid where v.from_uid=" . $user_id . " and v.consumption > 0 and v.type != 18 and v.create_time between " . $startime . " and " . $endtime . " order BY v.create_time desc limit " . $limit;
            $list = $GLOBALS['db']->getAll($sql, true, true); //消费记录
            if (count($list) > 0) {
                // 1礼物 2守护 3 任务 4 付费房间 5私信6弹幕7vip8座驾9头像框10靓号11充值金币12兑换13签到14修改昵称消费15注册赠送16幸运礼物中奖17购买贵族18三方游戏19家族20平台操作21提现22红包
                foreach ($list as &$l) {
                    switch ($l['type']){
                        case 1:
                            $l['content'] = api_lang('Give_gifts_to') . '--' . emoji_decode($l['nick_name']);
                            break;
                        case 2:
                            $l['content'] = $l['content'] . '--' . emoji_decode($l['nick_name']);
                            break;
                        case 4:
                            $l['content'] = api_lang('付费房间') . '--' . emoji_decode($l['nick_name']);
                            break;
                        case 5:
                            $l['content'] = api_lang('私信') . '--' . emoji_decode($l['nick_name']);
                            break;
                        case 6:
                            $l['content'] = api_lang('弹幕') . '--' . emoji_decode($l['nick_name']);
                            break;
                        case 7:
                            $l['content'] = 'Buy VIP';
                            break;
                        default:
                    }
                    $l['create_time'] = date('Y-m-d H:i:s', $l['create_time']);
                }
            }

//            $start_time = str_replace('-', '', $time);
//
//            $table = DB_PREFIX . "video_prop_" . $start_time;
//            $result = $GLOBALS['db']->getRow("SHOW TABLES LIKE '" . $table . "'");
//
//            if (!empty($result)) {
//                $sql = "select u.nick_name,v.total_diamonds as `diamonds`,v.prop_name,v.create_time from " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = v.to_user_id where v.from_user_id=" . $user_id . " and v.total_ticket > 0 and v.create_time between " . $startime . " and " . $endtime . " order BY v.create_time desc limit " . $limit;
//                $gift = $GLOBALS['db']->getAll($sql, true, true); //送礼物记录
//            } else {
//                $gift = [];
//            }
//            if (count($gift) > 0) {
//                foreach ($gift as &$l) {
//                    $l['content'] = api_lang('Give_gifts_to') . '--' . emoji_decode($l['nick_name']);
//                    $l['create_time'] = date('Y-m-d H:i:s', $l['create_time']);
//                }
//            }
//
//
//            //购买贵族 守护 靓号 座驾 送礼物 消费记录
//            $log = $GLOBALS['db']->getAll('select log_info as `content` ,diamonds,log_time as `create_time` from ' . DB_PREFIX . 'user_log where user_id = ' . $user_id . ' and log_time between ' . $startime . ' and ' . $endtime . ' and ( type = 9  or type = 10 or type = 11 or type = 6 or type = 21 or type = 12 ) order by log_time desc');
//            if (count($log) > 0) {
//                foreach ($log as &$g) {
//                    $g['create_time'] = date('Y-m-d H:i:s', $g['create_time']);
//                }
//            }
//            if (count($gift) > 0 && count($log) > 0) {
//                $list = array_merge($gift, $log);
//            } elseif (count($gift) > 0 && count($log) < 1) {
//                $list = $gift;
//            } elseif (count($gift) < 1 && count($log) > 0) {
//                $list = $log;
//            } else {
//                $list = [];
//            }

        } else { //1充值明细
            $sql = "select money,recharge_name,diamonds,type,create_time,is_paid from " . DB_PREFIX . "payment_notice where user_id=" . $user_id . " and create_time between " . $startime . ' and ' . $endtime . "  and type = 0 order BY create_time desc limit " . $limit;
            $record = $GLOBALS['db']->getAll($sql, true, true); //充值记录

            $sql = "select ticket,diamonds,create_time,is_success from " . DB_PREFIX . "exchange_log where user_id=" . $user_id . " and create_time between " . $startime . " and " . $endtime . " order BY create_time desc limit " . $limit;
            $exchange = $GLOBALS['db']->getAll($sql, true, true); //兑换明细

            //签到获取钻石
            $log = $GLOBALS['db']->getAll('select log_info as `content` ,diamonds,log_time as `create_time` from ' . DB_PREFIX . 'user_log where user_id = ' . $user_id . ' and log_time between ' . $startime . ' and ' . $endtime . ' and type = 20 order by log_time desc');
            if (count($log) > 0) {
                foreach ($log as &$g) {
                    $g['create_time'] = date('Y-m-d H:i:s', $g['create_time']);
                }
            }

            if (count($record) > 0) {
                foreach ($record as &$r) {
                    //  $r['content'] = $r['recharge_name'];
                    $r['content'] = $m_config['diamonds_name'];
                    $r['create_time'] = date('Y-m-d H:i:s', $r['create_time']);
                    $r['is_paid_status'] = $r['is_paid'] == 1 ? api_lang("Successful_trade") : api_lang("The_deal_failed");
                }
            }
            if (count($exchange) > 0) {
                foreach ($exchange as &$e) {
                    $e['content'] = api_lang('Income_conversion') . $m_config['diamonds_name'];
                    $e['create_time'] = date('Y-m-d H:i:s', $e['create_time']);
                    $e['is_success_status'] = $e['is_success'] == 1 ? api_lang("Successful_trade") : api_lang("The_deal_failed");
                }
            }
            if (count($record) > 0 && count($exchange) > 0) {
                $lists = array_merge($record, $exchange);
            } elseif (count($record) > 0 && count($exchange) < 1) {
                $lists = $record;
            } elseif (count($record) < 1 && count($exchange) > 0) {
                $lists = $exchange;
            } else {
                $lists = [];
            }

            if (count($log) > 0) {
                $list = array_merge($lists, $log);
            } else {
                $list = $lists;
            }

        }

        if (count($list) > 0) {

            //二维数组排序
            $sort = array(
                'direction' => 'SORT_DESC', //排序顺序标志 SORT_DESC 降序；SORT_ASC 升序
                'field'     => 'create_time',       //排序字段
            );
            $arrSort = array();
            foreach ($list as $uniqid => $row) {
                foreach ($row as $key => $value) {
                    $arrSort[$key][$uniqid] = $value;
                }
            }
            array_multisort($arrSort[$sort['field']], constant($sort['direction']), $list);
            $lists = $this->array_page($list, $page, 20); //分页
        } else {
            $lists = [];
        }
        $root['list'] = $lists;
        ajax_return($root);
    }

    /*
     * 二维数组分页
     * $arr 要分页的二维数组
     * $p 页数
     * $count 每页显示几个
    */
    function array_page($arr, $p, $count)
    {
        $start = ($p - 1) * $count;
        $new_arr = [];
        for ($i = $start; $i < $start + $count; $i++) {
            if (!empty($arr[$i])) {
                $new_arr[$i] = $arr[$i];
            }
        }
        return $new_arr;
    }


    //账户提现接口20200717
    public function submit_refund_bank_new()
    {
        $root = array('status' => 1, 'error' => api_lang("success"));
        //$user_id = !$GLOBALS['user_info'] ? '100394' : $GLOBALS['user_info']['id'];//会员ID
        $user_id = $GLOBALS['user_info']['id'] ? $GLOBALS['user_info']['id'] : $_REQUEST['uid'];//会员ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $m_config = load_auto_cache("m_config");//初始化手机端配置

        //判断是否在直播中，如是则不让进入提现界面
        $is_live = $GLOBALS['db']->getRow("select user_id,live_in from " . DB_PREFIX . "video where  user_id=" . $user_id . " order by id desc");
        //异常退出后，等待公会长抽成完成后才能提现ljz
        if (!empty($is_live) && $is_live['live_in'] == 1) {
            $root['status'] = 0;
            $root['error'] = api_lang("Unable_to_withdraw_cash_temporarily");
            ajax_return($root);
        }
        $sql = "select * from " . DB_PREFIX . "user_cash_account where choose=1 and uid=" . $user_id;

        $user_cash_account = $GLOBALS['db']->getRow($sql);
        if (!$user_cash_account) {
            $root['status'] = 0;
            $root['error'] = api_lang("bind_account_to_withdraw_cash");
            ajax_return($root);
        }
        $rate = $GLOBALS['db']->getOne("select alone_ticket_ratio from " . DB_PREFIX . "user where id=" . intval($user_id));
        if ($rate == '') {
            $rate = $m_config['ticket_catty_ratio'];
        }
        $ticket = intval($_REQUEST['ticket']);//提现印票
        $memo = $user_cash_account['account'];
        $money = floatval($ticket * $rate);
        //未处理提现
        $ready_refund_id = intval($GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_refund where user_id = " . intval($user_id) . " and (is_pay =0 or is_pay=1)"));
        if ($ready_refund_id) {
            $root['error'] = api_lang("There_are_outstanding_withdrawals");
            $root['status'] = 0;
            ajax_return($root);
        }
        //会员当前印票
        $user_ticket_info = $GLOBALS['db']->getRow("select ticket,refund_ticket from " . DB_PREFIX . "user where id = '" . intval($user_id) . "'");
        $user_ticket = $user_ticket_info['ticket'] - $user_ticket_info['refund_ticket'];//可使用的印票
        //超额判断
        if ($ticket > $user_ticket) {
            $root['error'] = api_lang("No_more_than_available_withdrawal");
            $root['status'] = 0;
            ajax_return($root);
        }
        // 进入每月提现一次流程
        $month_carry_one = intval($m_config['month_carry_one']) ? 1 : 0;//提现配置，1：每月提现1次，0：无限制
        if ($month_carry_one) {
            $ready_refund_info = $GLOBALS['db']->getRow("select pay_time from " . DB_PREFIX . "user_refund where user_id = " . intval($user_id) . " and is_pay = 3");
            $pay_time = $ready_refund_info['pay_time'];
            //本月是否有提现
            if ($pay_time != '' && (to_date($pay_time, "Ym") == to_date(get_gmtime(), 'Ym'))) {
                $root['error'] = api_lang("Cash_has_been_withdrawn_this_month");
                $root['status'] = 0;
                ajax_return($root);
            } else {
                //查看本月允许提现时间，精确计算到天
                if ((to_date(get_gmtime(), 'd') > intval($m_config['month_carry_max']) || to_date(get_gmtime(), 'd') < intval($m_config['month_carry_min'])) && intval($m_config['month_carry_max']) != 0 && intval($m_config['month_carry_min']) != 0) {
                    $root['error'] = api_lang("monthly") . intval($m_config['month_carry_min']) . api_lang("day") . api_lang("reach") . intval($m_config['month_carry_max']) . api_lang("day") . api_lang("To_withdraw_cash");
                    $root['status'] = 0;
                    ajax_return($root);
                }
            }
        }
        //百媚模式下代理会员提现
        if (defined('OPEN_BM') && OPEN_BM) {
            $bm_config = load_auto_cache("bm_config");
            $bm_pid = intval($bm_config['bm_pid']);
            $bm_user = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id=" . intval($user_id) . " and( bm_pid=" . $bm_pid . " or bm_pid=0)");
            $bm_promoter = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "bm_promoter where user_id=" . intval($user_id));
            if ($bm_user == '' || $bm_promoter) {
                $root['error'] = $m_config['bm_point'];
                $root['status'] = 0;
                ajax_return($root);
            }

        }

        //如果开启公会并且开启无抽成模式，支付宝 将无法提现ljz
        if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE == 1 && $m_config['society_pattern'] == 2) {
            $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_id);
            if (intval($society_info['society_chieftain']) == 1) {
                $root['error'] = api_lang("Withdrawal_by_Chairman");
                $root['status'] = 0;
                ajax_return($root);
            } elseif (intval($society_info['society_id'])) {
                $root['error'] = api_lang("association_does_not_withdraw_cash");
                $root['status'] = 0;
                ajax_return($root);
            }
        }

        //提现最小值
        $ticket_catty_min = $m_config['ticket_catty_min'] > 1 ? $m_config['ticket_catty_min'] : 1;
        //最小判断
        if ($money < $ticket_catty_min) {
            $root['error'] = api_lang("Withdrawal_cannot_be_less_than") . $ticket_catty_min . api_lang("Yuan");
            $root['status'] = 0;
            ajax_return($root);
        }

        //取用户当日提现金额之和
        //create_time储存的是格林威治时间。使用时需转换为北京时间
        $refunded_money_sql = "select sum(money) from " . DB_PREFIX . "user_refund where user_id=" . $user_id . " and (is_pay=0 or is_pay=1 or is_pay=3) 
                                and DATE_FORMAT(FROM_UNIXTIME(create_time+28800),'%Y-%m-%d')=DATE_FORMAT(NOW(),'%Y-%m-%d')";
        $refunded_money = $GLOBALS['db']->getOne($refunded_money_sql);
        $total_money = floatval($refunded_money) + $money;
        //提现最大值
        $day_cash_max = intval($m_config['day_cash_max']);
        //总和判断
        if ($total_money > $day_cash_max) {
            $root['error'] = api_lang("No_more_than_daily_withdrawal") . $day_cash_max . api_lang("Yuan");
            $root['status'] = 0;
            ajax_return($root);
        }

        $refund_data['money'] = $money;
        $refund_data['user_bank_id'] = 0;
        $refund_data['ticket'] = $ticket;
        $refund_data['user_id'] = $user_id;
        $refund_data['create_time'] = NOW_TIME;
        $refund_data['memo'] = $memo;
        $refund_data['withdrawals_type'] = 3;
        $refund_data['account_name'] = $user_cash_account['name'];
        $refund_data['account_number'] = $user_cash_account['account_number'];
        $GLOBALS['db']->autoExecute(DB_PREFIX . "user_refund", $refund_data);

        ajax_return($root);
    }

    /**
     *我的等级更新最新版本2019/05/28
     */
    public function level()
    {

        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        if ($user_id == 0) {
            $user_id = $GLOBALS['user_info']['id'];
        }
        if ($user_id == 0) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            //$user_data = $user_redis->getRow_db($user_id, array('id', 'score', 'online_time', 'user_level'));
            $user_data = $GLOBALS['db']->getRow('select id, score, online_time, user_level from ' . DB_PREFIX . 'user where id = ' . $user_id);

            user_leverl_syn($user_data);
            $level = $GLOBALS['db']->getRow("select ul.name as leve_name,ul.score as l_score from " . DB_PREFIX . "user_level as ul  where ul.level=" . intval($user_data['user_level']));
            $m_config = load_auto_cache("m_config");
            $level['u_score'] = $user_data['score'] + floor($user_data['online_time'] * floatval($m_config['onlinetime_to_experience']));
            $level['up_score'] = intval($GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level=" . intval($user_data['user_level'] + 1)));

            if (intval($level['up_score']) <= 0) {
                $l_up_score = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level>" . intval($user_data['user_level'] + 1));

                if ($l_up_score > 0) {
                    $level['up_score'] = intval($l_up_score);
                } else {
                    $level['up_score'] = intval($level['u_score']);
                }

            }

            $level['percentage'] = intval($level['u_score']) / intval($level['up_score']) * 100;
            $user_data['user_level'] = $level['leve_name'];
            $root = $level;
            $root['status'] = 1;
            $root['error'] = '';
        }
        $root['page_title'] = api_lang("Grade");
        api_ajax_return($root);
    }
    //

    /**
     * 我的等级 （H5 页面接口）
     */
    public function grade()
    {
        $root = array();
        $user_id = intval($_REQUEST['user_id']);
        if ($user_id == 0) {
            $user_id = $GLOBALS['user_info']['id'];
        }
        if ($user_id == 0) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_data = $user_redis->getRow_db($user_id, array('id', 'score', 'online_time', 'user_level'));
            user_leverl_syn($user_data);
            $level = $GLOBALS['db']->getRow("select ul.name as leve_name,ul.score as l_score from " . DB_PREFIX . "user_level as ul  where ul.level=" . intval($user_data['user_level']));
            $m_config = load_auto_cache("m_config");
            $level['u_score'] = $user_data['score'] + floor($user_data['online_time'] * floatval($m_config['onlinetime_to_experience']));
            $level['up_score'] = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level=" . intval($user_data['user_level'] + 1));
            if (intval($level['up_score']) <= 0) {
                $l_up_score = $GLOBALS['db']->getOne("select score from " . DB_PREFIX . "user_level  where level>" . intval($user_data['user_level'] + 1));
                if ($l_up_score > 0) {
                    $level['up_score'] = $l_up_score;
                } else {
                    $level['up_score'] = api_lang("Full_class");
                }
            }
            $user_data['user_level'] = $level['name'];
            $root = $level;
            $root['status'] = 1;
            $root['error'] = '';
        }
        $root['page_title'] = api_lang("Grade");
        api_ajax_return($root);
    }

    /**
     * 我的收益-主页面
     */
    public function profit()
    {
        $root = array();
        $user_id = $GLOBALS['user_info'] ? intval($GLOBALS['user_info']['id']) : 168279;
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {

            //$profit= $GLOBALS['db']->getRow("select ticket,money,subscribe,wx_openid,mobile from ".DB_PREFIX."user where id=".$user_id);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $profit = $user_redis->getRow_db($user_id, array('ticket', 'money', 'subscribe', 'wx_openid', 'mobile', 'refund_ticket', 'binding_alipay','country_code','family_id'));

            //$root = $profit;
            $root['status'] = 1;
            $root['error'] = '';
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            //提现比例 如果主播提现比例为空，则使用后台通用比例
            $root['ticket_catty_ratio'] = $GLOBALS['db']->getOne("select alone_ticket_ratio from " . DB_PREFIX . "user where id=" . $user_id);
            if ($root['ticket_catty_ratio'] == '') {
                // 先处理国家是否有提现比例
                $country_ratio =get_country_config(2,$profit['country_code']);

                $root['ticket_catty_ratio'] = $country_ratio > 0 ? floatval($country_ratio) : floatval($m_config['ticket_catty_ratio']);
            }

            //公会长提现比例特殊ljz
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE == 1 && $m_config['society_pattern'] == 2) {
                $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_id);
                if (intval($society_info['society_chieftain']) == 1) {
                    $refund_rate = $GLOBALS['db']->getOne("select refund_rate from " . DB_PREFIX . "society where id=" . $society_info['society_id']);
                    $root['ticket_catty_ratio'] = floatval($refund_rate);
                    if ($root['ticket_catty_ratio'] > 1 || $root['ticket_catty_ratio'] <= 0) {
                        $root['ticket_catty_ratio'] = $m_config['society_public_rate'];
                    }
                } elseif ($society_info['society_id']) {
                    $root['ticket_catty_ratio'] = $m_config['society_user_rate'];
                }
            }

            $root['ticket'] = intval($profit['ticket']);
            $root['money'] = number_format(intval($profit['ticket'] - $profit['refund_ticket']) * floatval($root['ticket_catty_ratio']), 2);
            $root['useable_ticket'] = intval($profit['ticket'] - $profit['refund_ticket']);
            $root['subscribe'] = intval($profit['subscribe']);

            //最小提现印票
            $root['ticket_catty_min'] = intval(intval($m_config['ticket_catty_min']) / floatval($root['ticket_catty_ratio']));
            //添加微信公众号名称
            $root['subscription'] = mb_strlen($m_config['subscription']) ? $m_config['subscription'] : '';

            //每日可提现印票
            if (floatval($root['ticket_catty_ratio']) > 0) {
                $root['day_ticket_max'] = intval(intval($m_config['day_cash_max']) / floatval($root['ticket_catty_ratio']));
            }

            //是否有未处理的提现
            if ($GLOBALS['db']->getOne("select count(*) FROM " . DB_PREFIX . "user_refund WHERE user_id = " . $user_id . " and (is_pay =0 or is_pay=1)") > 0) {
                $root['refund_exist'] = 1;
            } else {
                $root['refund_exist'] = 0;
            }

            if ($profit['wx_openid'] != '')
                $root['binding_wx'] = 1;
            else
                $root['binding_wx'] = 0;

            if ($profit['mobile'] != '')
                $root['mobile_exist'] = 1;
            else
                $root['mobile_exist'] = 0;

            if (OPEN_PAI_MODULE == 1) {
                $rs = BogoServiceCall("user_center", "profit", array("user_id" => $user_id));
            }
            //$rs = BogoServiceCall("user_center","profit",array("user_id"=>$user_id));
            //$rs['pai_income_done'] = 0;
            //$rs['pai_income_undone'] = 0;
            $root['show_pai_ticket'] = 0;
            $root['pai_ticket'] = intval($rs['pai_income_done']);
            $root['pai_wait_ticket'] = intval($rs['pai_income_undone']);

            $root['show_goods_ticket'] = 0;
            $root['goods_ticket'] = intval($rs['goods_income_done']);
            $root['goods_wait_ticket'] = intval($rs['goods_income_undone']);

            //是否绑定支付宝 0指未绑定， 1指已绑定
            $result_one = db::name('user_cash_account')->where("uid=" . $user_id . " and choose=1")->find();

            //提现开启或关闭 1：开启 0：关闭
            $root['is_refund'] = $m_config['is_refund'];

            $root['withdrawals_name'] = $result_one ? $result_one['account'] : '';
            $root['is_binding'] = $result_one && !empty($result_one['name']) ? 1 : 0;
            // 是否显示兑换按钮 0关闭1开启
            $root['show_exchange'] = 1;
            if($profit['family_id']){
                // 是否显示兑换按钮 2关闭1开启
                $family_status = $GLOBALS['db']->getOne("SELECT is_exchange FROM " . DB_PREFIX . "family WHERE id =" . intval($profit['family_id']) . " and status=1");
                $root['show_exchange'] = intval($family_status) == 2 ? 0 : 1;
            }


            //提现说明
            $root['refund_explain'] = array();
            $refund_arr = explode("<br />", nl2br($m_config['refund_explain']));
            foreach ($refund_arr as $k => $v) {
                $v = ltrim(rtrim(trim($v)));
                if ($v != '') {
                    $root['refund_explain'][] = $v;
                }
            }
        }

        ajax_return($root);
    }

    /**
     * 我的收益-兑换规则列表
     */
    public function exchange()
    {
        $root = array('status' => 1, 'error' => '');
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $exchange_rules = $video_new = $GLOBALS['db']->getAll("select er.id,er.diamonds,er.ticket from " . DB_PREFIX . "exchange_rule as er where is_effect=1 and is_delete=0 order by er.diamonds");
            $root['exchange_rules'] = $exchange_rules;

            //$user =  $GLOBALS['db']->getRow("select ticket,diamonds from ".DB_PREFIX."user where id=".$GLOBALS['user_info']['id'],true,true);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user = $user_redis->getRow_db($GLOBALS['user_info']['id'], array('ticket', 'diamonds', 'refund_ticket'));

            $GLOBALS['user_info']['ticket'] = intval($user['ticket']);
            $root['ticket'] = intval($user['ticket']);

            $GLOBALS['user_info']['refund_ticket'] = intval($user['refund_ticket']);
            $root['refund_ticket'] = intval($user['refund_ticket']);//已使用的印票

            $GLOBALS['user_info']['diamonds'] = intval($user['diamonds']);
            $root['diamonds'] = intval($user['diamonds']);
            $root['useable_ticket'] = intval($user['ticket'] - $user['refund_ticket']);
            //兑换规则
            //$ratio = floatval(app_conf('TICKET_CATTY_RATIO'));
            $ratio = floatval(1 / $m_config['exchange_rate']);
            $root['ratio'] = $ratio;

            $m_config = load_auto_cache("m_config");
            //兑换最低票数
            $root['min_ticket'] = floatval($m_config['exchange_rate']);

        }
        ajax_return($root);
    }

    /**
     * 我的收益-兑换功能
     */
    public function do_exchange()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//登录用户
            $to_uid = intval($_REQUEST['to_uid']) ? intval($_REQUEST['to_uid']) : $user_id;// 给对方兑换
            $is_live = $GLOBALS['db']->getRow("select user_id,live_in from " . DB_PREFIX . "video where  user_id=" . $user_id . " order by id desc");
            $before_user_diamonds = intval($GLOBALS['db']->getOne("select diamonds from " . DB_PREFIX . "user where id=" . $to_uid));
            $user = $GLOBALS['db']->getRow("select ticket,family_id,society_id from " . DB_PREFIX . "user where id=" . $user_id);

            $before_to_ticket = intval($user['ticket']);
            if($user['family_id']){
                // 是否显示兑换按钮 2关闭1开启
                $family_status = $GLOBALS['db']->getOne("SELECT is_exchange FROM " . DB_PREFIX . "family WHERE id =" . intval($user['family_id']) . " and status=1");
                if (intval($family_status) == 2){
                    // 暂无权限兑换
                    $root['status'] = 0;
                    $root['error'] = api_lang("No_permission");
                    ajax_return($root);
                }
            }

            //异常退出后，等待家族长抽成完成后才能提现ljz
            if (!empty($is_live) && $is_live['live_in'] == 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("Temporarily_unable_to_exchange");
            } else {
                $m_config = load_auto_cache("m_config");//初始化手机端配置
                //无抽成模式下会长会员都不可以兑换钻石ljz
                $society_id = intval($user['society_id']);
                if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE && $m_config['society_pattern'] == 2 && $society_id) {
                    $root['status'] = 0;
                    $root['error'] = api_lang("No_stamp_ticket_for_diamond");
                    ajax_return($root);
                }
                $rule_id = intval($_REQUEST['rule_id']);//100
                $ticket = intval($_REQUEST['ticket']);//250000

                //$user =  $GLOBALS['db']->getRow("select ticket,diamonds from ".DB_PREFIX."user where id=".$user_id);

                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();
                $user = $user_redis->getRow_db($user_id, array('ticket', 'diamonds', 'refund_ticket'));

                $diamonds = 0;
                if ($user['ticket'] - $user['refund_ticket'] < $ticket) {
                    $root['status'] = 0;
                    $root['error'] = $m_config['ticket_name'] . ' ' . api_lang("Insufficient");
                    $root['ticket'] = $user['ticket'];
                    $root['refund_ticket'] = $user['refund_ticket'];
                    $root['diamonds'] = $user['diamonds'];
                    ajax_return($root);
                }
                if ($rule_id > 0) {
                    //兑换规则
                    $exchange_rule = $video_new = $GLOBALS['db']->getRow("select er.* from " . DB_PREFIX . "exchange_rule as er where is_effect=1 and is_delete=0 and id = " . $rule_id . " and ticket=" . $ticket);
                    if ($exchange_rule) {
                        $diamonds = intval($exchange_rule['diamonds']);

                        $ticket = intval($exchange_rule['ticket']);
                    } else {
                        $root['status'] = 0;
                        $root['error'] = api_lang("Exchange_error");
                        $root['ticket'] = $user['ticket'];
                        $root['refund_ticket'] = $user['refund_ticket'];
                        $root['diamonds'] = $user['diamonds'];
                        ajax_return($root);
                    }
                } else {
                    //自定义兑换
                    //$ratio = app_conf('TICKET_CATTY_RATIO');
                    $ratio = $m_config['exchange_rate'];
                    if ($ratio) {
                        if ($ticket % $ratio != 0) {
                            $root['status'] = 0;
                            $str = api_lang("必须是整倍数兑换");
                            $newStr = str_replace("{name}", $ratio, $str);
                            $root['error'] = $newStr;
                            ajax_return($root);
                        }
                        $diamonds = intval($ticket / $ratio);
                    }

                }

                if ($diamonds > 0) {
                    //使用兑换列表的值
                    $sql = "update " . DB_PREFIX . "user set refund_ticket=refund_ticket+" . $ticket . ",diamonds=diamonds+" . $diamonds . " where ticket >= refund_ticket + " . $ticket . " and id=" . $user_id;
                    $GLOBALS['db']->query($sql);
                    if ($GLOBALS['db']->affected_rows()) {
                        //redis 更新信息
                        user_deal_to_reids(array($user_id));
                        if ($user_id != $to_uid) {
                            user_deal_to_reids(array($to_uid));
                        }
                        // 消费和收益记录表
                        add_user_consumption_log($user_id, $to_uid, 0, api_lang('Income_conversion'), '-' . $ticket, $diamonds, 12);
                        $exchange_log = array();
                        $exchange_log['user_id'] = $user_id;
                        $exchange_log['rule_id'] = $rule_id;
                        $exchange_log['diamonds'] = $diamonds;
                        $exchange_log['ticket'] = $ticket;
                        $exchange_log['create_time'] = get_gmtime();
                        $exchange_log['is_success'] = 1;
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "exchange_log", $exchange_log, "INSERT", "", "SILENT");
                        //写入用户日志
                        $data = array();
                        $data['diamonds'] = intval($diamonds);
                        $data['ticket'] = intval($ticket);
                        $param['type'] = 3;//类型 0表示充值 1表示提现 2赠送道具 3 兑换印票
                        $ticket_name = $m_config['ticket_name'] != '' ? $m_config['ticket_name'] : api_lang("Printing_tickets");
                        $log_msg = $ticket . $ticket_name . '兑换成' . $diamonds . api_lang("Diamonds");
                        account_log_com($data, $user_id, $log_msg, $param);
                        $root['error'] = api_lang("Successful_exchange");
                        $root['status'] = 1;
                        $content = api_lang('Income_conversion') . ":" . api_lang('Deduction_account_income') . "(" . $ticket . ");" . api_lang('Add_diamonds') . "(" . $diamonds . ")";
                        add_user_records($user_id, $to_uid, $diamonds, $ticket, $before_user_diamonds, $before_to_ticket, 0, 0, $content, 10);

                    } else {
                        $exchange_log['is_success'] = 0;
                        $GLOBALS['db']->autoExecute(DB_PREFIX . "exchange_log", $exchange_log, "INSERT", "", "SILENT");
                        $root['status'] = 0;
                        $root['error'] = api_lang("Exchange_failure");
                    }
                }
            }
        }
        //获取新的印票
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_new_info = $user_redis->getRow_db($user_id, array('ticket', 'diamonds', 'refund_ticket'));

        $GLOBALS['user_info']['ticket'] = $user_new_info['ticket'];
        $GLOBALS['user_info']['refund_ticket'] = $user_new_info['refund_ticket'];
        $GLOBALS['user_info']['diamonds'] = $user_new_info['diamonds'];

        $root['ticket'] = $user_new_info['ticket'];
        $root['refund_ticket'] = $user_new_info['refund_ticket'];
        $root['diamonds'] = $user_new_info['diamonds'];
        $root['useable_ticket'] = intval($user_new_info['ticket'] - $user_new_info['refund_ticket']);
        ajax_return($root);
    }

    /**
     * 微信提现页面
     */
    public function money_carry_wx()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            if (intval($m_config['is_refund']) != 1 || intval($m_config['withdrawals_type']) != 0) {
                $root['status'] = 0;
                $root['error'] = api_lang("Wechat_cash_withdrawal_closed");
                ajax_return($root);
            }
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $ticket_info = $user_redis->getRow_db($GLOBALS['user_info']['id'], array('ticket', 'refund_ticket'));

            $ready_refund_ticket = floatval($GLOBALS['db']->getOne("select sum(ticket) from " . DB_PREFIX . "user_refund where user_id = " . intval($GLOBALS['user_info']['id']) . " and is_pay in (0,1,3)"));

            $bank_info['ratio'] = floatval($m_config['ticket_catty_ratio']);
            $bank_info['can_use_ticket'] = $ticket_info['ticket'] - $ticket_info['refund_ticket'] - $ready_refund_ticket;
            $bank_info['ready_refund_ticket'] = $ready_refund_ticket;

            $root = $bank_info;
            $root['status'] = 1;
            $root['error'] = '';
        }
        ajax_return($root);
    }

    /**
     * 微信提现处理
     */
    public function submitrefundwx()
    {
        $root = array();
        $id = intval($_REQUEST['id']);
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $user_info_wx = es_session::get("user_info_wx");
        $user_info = $user_info_wx[$id];
        $refresh = SITE_DOMAIN . '/mapi/index.php?ctl=wx_bind';
        //$user_info = $GLOBALS['db']->getRow("select * from ".DB_PREFIX."user where id = ".intval($id));

        $tips = '<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>微信提现</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=2.0, user-scalable=0,minimum-scale=0.5">
    <meta http-equiv="refresh" content="1; url=' . $refresh . '"><link rel="shortcut icon" href="/favicon.ico">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
</head>
<body style="background:#f0f7f6;">
xxxx
</body>
</html>';
        if (!$user_info) {
            $error = api_lang("user_not_logged_in");
            echo str_replace('xxxx', $error, $tips);
            return;
        } else {

            // 进入每月提现一次流程
            $month_carry_one = intval($m_config['month_carry_one']) ? 1 : 0;

            if ($month_carry_one) {
                $ready_refund_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user_refund where user_id = " . intval($user_info['id']) . " and is_pay = 3");
                $pay_time = $ready_refund_info['pay_time'];
                //本月是否有提现
                if ($pay_time != '' && (to_date($pay_time, "Ym") == to_date(get_gmtime(), 'Ym'))) {
                    $error = api_lang("Cash_has_been_withdrawn_this_month");
                    echo str_replace('xxxx', $error, $tips);
                    return;
                } else {
                    //查看本月允许提现时间
                    if (to_date(get_gmtime(), 'd') < intval($m_config['month_carry_min']) || to_date(get_gmtime(), 'd') > intval($m_config['month_carry_max'])) {
                        $error = api_lang("monthly") . intval($m_config['month_carry_min']) . api_lang("day") . api_lang("reach") . intval($m_config['month_carry_max']) . api_lang("day") . api_lang("To_withdraw_cash");
                        echo str_replace('xxxx', $error, $tips);
                        return;
                    }
                }

            }

            $ready_refund_id = intval($GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_refund where user_id = " . intval($user_info['id']) . " and (is_pay =0 or is_pay=1)"));

            if ($ready_refund_id) {
                $error = api_lang("There_are_outstanding_withdrawals");
                echo str_replace('xxxx', $error, $tips);
                return;
            }

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_ticket_info = $user_redis->getRow_db($user_info['id'], array('ticket', 'refund_ticket'));
            $memo = api_lang("Withdrawal_by_wechat");
            //可用印票
            $use_ticket = $user_ticket_info['ticket'] - $user_ticket_info['refund_ticket'];
            //今日可提现金额
            $s_now_time = to_timespan(to_date(NOW_TIME, "Y-m-d 00:00:00"));
            $e_now_time = to_timespan(to_date(NOW_TIME, "Y-m-d 23:59:59"));
            $ready_refund_info = $GLOBALS['db']->getOne("select sum(money) from " . DB_PREFIX . "user_refund where user_id = " . intval($user_info['id']) . " and is_pay = 3 and pay_time>=" . $s_now_time . " and pay_time<=" . $e_now_time);
            $use_cash_money = floatval(floatval($m_config['day_cash_max']) - $ready_refund_info);
            //提现比例 如果主播提现比例为空，则使用后台通用比例
            $rate = $GLOBALS['db']->getOne("select alone_ticket_ratio from " . DB_PREFIX . "user where id=" . intval($user_info['id']));
            if ($rate == '') {
                $rate = $m_config['ticket_catty_ratio'];
            }
            if (defined('OPEN_BM') && OPEN_BM) {
                $bm_config = load_auto_cache("bm_config");
                $bm_pid = intval($bm_config['bm_pid']);
                $bm_user = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id=" . intval($user_info['id']) . " and( bm_pid=" . $bm_pid . " or bm_pid=0)");
                $bm_promoter = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "bm_promoter where user_id=" . intval($user_info['id']));
                if ($bm_user == '' || $bm_promoter) {
                    $error = $m_config['bm_point'];
                    echo str_replace('xxxx', $error, $tips);
                    return;
                }
            }

            //如果开启公会并且开启无抽成模式，微信 将无法提现ljz
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE == 1 && $m_config['society_pattern'] == 2) {
                $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_info['id']);
                if (intval($society_info['society_chieftain']) == 1) {
                    $error = api_lang("Withdrawal_by_Chairman");
                    echo str_replace('xxxx', $error, $tips);
                    return;
                    $refund_rate = $GLOBALS['db']->getOne("select refund_rate from " . DB_PREFIX . "society where id=" . $society_info['society_id']);
                    $rate = floatval($refund_rate);
                } elseif (intval($society_info['society_id'])) {
                    $error = api_lang("association_does_not_withdraw_cash");
                    echo str_replace('xxxx', $error, $tips);
                    return;
                    $refund_rate = $GLOBALS['db']->getOne("select refund_rate from " . DB_PREFIX . "society where id=" . $society_info['society_id']);
                    $rate = floatval($refund_rate);
                }
            }

            //总金额
            $use_money = floatval($use_ticket * $rate);

            $ticket_catty_min = $m_config['ticket_catty_min'] ? $m_config['ticket_catty_min'] : 1;
            if ($use_money < $ticket_catty_min) {
                $error = api_lang("minimum_amount_of_withdrawal") . $ticket_catty_min . api_lang("Yuan");
                echo str_replace('xxxx', $error, $tips);
                return;
            }

            $cash_money = strim($_REQUEST['cash_money']);
            $num_cash_money = floatval($cash_money);
            if (!isset($_REQUEST['cash_money'])) {
                $error_tip = "";
                $cash_money = '';
            } elseif ($cash_money == '') {
                $error_tip = api_lang("enter_the_claim_amount");
                $cash_money = '';
            } elseif (!preg_match('/^[0-9]+(.[0-9]{0,2})?$/', $cash_money)) {
                $error_tip = api_lang("Get_up_to_two_decimal_places");
            } elseif ($num_cash_money < $ticket_catty_min) {
                $error_tip = api_lang("minimum_amount_of_payment_is") . $ticket_catty_min . api_lang("Yuan");
            } elseif ($num_cash_money > $use_money) {
                $error_tip = api_lang("Claim_more_than_total_amount");
            } elseif ($num_cash_money > $use_cash_money) {
                $error_tip = api_lang("Exceeding_the_recoverable_amount");
            } else {
                $ticket = $num_cash_money / $rate;
                if ($ticket > 0 && $num_cash_money > 0) {
                    $refund_data['money'] = $num_cash_money;
                    $refund_data['user_bank_id'] = -1;
                    $refund_data['ticket'] = $ticket;
                    $refund_data['user_id'] = $user_info['id'];
                    $refund_data['create_time'] = NOW_TIME;
                    $refund_data['memo'] = $memo;
                    $refund_data['withdrawals_type'] = 0;
                    $GLOBALS['db']->autoExecute(DB_PREFIX . "user_refund", $refund_data);
                    $error = api_lang("Successful_withdrawal_application");
                    echo str_replace('xxxx', $error, $tips);
                    return;
                } else {
                    $error = api_lang("Withdrawal_application_failed");
                    echo str_replace('xxxx', $error, $tips);
                    return;
                }

            }


            $action = SITE_DOMAIN . '/mapi/index.php?ctl=user_center&act=submitrefundwx&id=' . $id;
            $html = '<div class="content">
			    <div class="m-top">
				<div class="m-user">
					<div class="user-img">
						<img src="' . $user_info['head_image'] . '"/>
					</div>
					<div class="user-name">
						<p class="name">' . $user_info['nick_name'] . '</p>
						<p class="id">' . $user_info['id'] . '</p>
					</div>
					<div class="clear"></div>
				</div>
				<div class="m-money">
					<div class="money-all">
						<p class="money">' . number_format($use_money, 2) . '</p><p class="title">总金额（元）</p>
					</div>
					<div class="money-today">
						<p class="money">' . number_format($use_cash_money, 2) . '</p><p class="title">今日可领取金额（元）</p>
					</div>
					<div class="clear"></div>
				</div>
				<div class="clear"></div>
			</div>
			<form method="post" action="' . $action . '">
			<div class="m-input">
				<span>领取金额</span>
				<div class="input-content">
					<input type="text" name="cash_money" value="' . $cash_money . '" placeholder="请输入要领取的金额" />
					<span>(元)</span>
				</div>
			</div>';
            if ($error_tip) {
                $html .= '<div class="m-input">
				<span style="padding-left:60px;text-align:right;">&nbsp;</span>
				<div class="input-content">
					<span style="color:red">' . $error_tip . '</span>
				</div>
			</div>';
            }
            $html .= '<div class="button">
				<input type="submit" value="确定" style="-webkit-appearance: none;background:#FF0000;color:#fff;height:36px;line-height:36px;padding:0 15px;font-size:14px;border:0;" />
			</div></form>
		</div>';
            echo '<!DOCTYPE html><html><head>
		<meta charset="UTF-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>微信提现</title>
		<meta name="viewport" content="initial-scale=1, maximum-scale=1">
		<meta name="apple-mobile-web-app-capable" content="yes">
		<meta name="apple-mobile-web-app-status-bar-style" content="black">
		<style type="text/css">
			*{margin: 0;padding: 0;}
			body{background: #eef7f4;font-size: 16px;}
			.clear {clear: both;visibility: hidden;font-size: 0;height: 0;line-height: 0;}
			.content{padding: 20px;background: #fff;}
			.m-user{display: -webkit-flex;display: flex;-webkit-align-items: center;align-items: center;margin-bottom: 15px;}
			.user-img{width: 40px;height: 40px;overflow: hidden;border-radius: 50%;float: left;margin-right: 5px;}
			.user-img img{width: 100%;}
			.user-name{float: left;}
			.user-name .name{font-size: 18px;line-height: 18px;margin-bottom: 5px;}
			.m-money{text-align: center;display: -webkit-flex;display: flex;-webkit-justify-content: center;justify-content: center;}
			.money-all{width: 50%;padding-right: 10px;box-sizing: border-box;text-align: left;}
			.money{font-size: 24px;color: #FF0000;font-family: arial;}
			.money-today{width: 50%;padding-left: 10px;box-sizing: border-box;text-align: left;}
			.title{color: #666;line-height: 20px;font-size: 14px;}
			.button{text-align: center;display: -webkit-flex;display: flex;margin: 0 px;}
			.button input{border:none;text-align: center;background: #ff5500;height: 40px;line-height: 40px;color: #fff;padding: 0 30px;display: block;text-decoration: none;border-radius: 3px;}
			.m-input{display: -webkit-flex;display: flex;-webkit-align-items: center;align-items: center;margin-top: 15px;display:-webkit-box;-webkit-box-orient:horizontal;}
			.m-input .input-content{display:flex;-webkit-box-flex:1;-moz-box-flex:1;-webkit-box-align:center;}
			.m-input input{height: 36px;line-height: 36px;border: 1px solid #dedede;padding: 0 10px;margin: 0 10px;display: flex;font-size:14px;}
			.m-input span{font-size: 14px;line-height: 30px;color: #666;}
		</style></head><body>
                        ' . $html . '
            </body></html>';
        }
    }

    /**
     * 修改账户信息-主页
     */
    public function user_edit()
    {
        $root = array();
        $root['nick_info'] = '';
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $root['status'] = 1;
            $root['error'] = "";
            $user_id = intval($GLOBALS['user_info']['id']);
            $sql = "select id as user_id,head_image,nick_name,sex,signature,is_authentication,birthday,emotional_state,province,city,job,is_edit_sex,luck_num,user_lang from " . DB_PREFIX . "user where id=" . $user_id;
            $user = $GLOBALS['db']->getRow($sql, true, true);
            foreach ($user as $k => $v) {
                $user[$k] = htmlspecialchars_decode($v);
            }
            $user['head_image'] = get_spec_image($user['head_image']);
            $user['birthday'] = date('Y-m-d', $user['birthday']);
            $user['signature'] = emoji_decode($user['signature']);
            $user['nick_name'] = emoji_decode($user['nick_name']);
            $user['user_lang'] = strim($user['user_lang']);
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            if ($m_config['is_change_name'] == 1) {
                $root['nick_info'] = api_lang("One_free_change_of_nickname") . $m_config['change_name'] . api_lang("Diamonds");
            }

            $root['user'] = $user;
        }
        ajax_return($root);
    }

    /**
     * 保存账户信息
     */
    public function user_save()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
            $user_info_req = $_REQUEST;
            foreach ($user_info_req as $k => $v) {
                if ($v != 'user_center' || $v != 'user_save') {
                    $user_info[$k] = trim($v);
                }
            }
            //判断性别是否可修改
            if (isset($user_info['sex'])) {
                $user_info['is_edit_sex'] = 0;
            }
            //判断性别是否可修改
            if (isset($user_info['user_lang'])) {
                $user_info['user_lang'] = strim($user_info['user_lang']);
            }

            $user_info['id'] = $user_id;
            $user_info['birthday'] = strtotime($user_info['birthday']);

            $GLOBALS['db']->query("set names 'utf8mb4'");
            $user_info['signature'] = emoji_encode($user_info['signature']);
            $user_info['nick_name'] = emoji_encode($user_info['nick_name']);


            if ($user_info['birthday'] == '') unset($user_info['birthday']);
            if ($user_info['signature'] == '') unset($user_info['signature']);
            if ($user_info['nick_name'] == '') unset($user_info['nick_name']);
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            //昵称如果等于铭感词,则提示,如果包含 则用*代替
            $nick_name = addslashes($user_info['nick_name']);
            if ($m_config['name_limit'] == 1) {
                $limit_sql = $GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name");
                $in = in_array($nick_name, $limit_sql);
                if ($in) {
                    ajax_return(array("status" => 0, "error" => api_lang("Nicknames_contain_sensitive_words")));
                } elseif ($GLOBALS['db']->getCol("SELECT name FROM " . DB_PREFIX . "limit_name WHERE '" . $nick_name . "' like concat('%',name,'%')")) {
                    $user_info['nick_name'] = str_replace($limit_sql, '*', $nick_name);
                }
            }
            if ($GLOBALS['db']->getOne("SELECT nick_name FROM " . DB_PREFIX . "user WHERE id<>" . $user_id . " and  nick_name ='$nick_name'")) {
                ajax_return(array("status" => 0, "error" => api_lang("Nickname_occupied")));
            }

            //修改昵称付费
            if ($m_config['is_change_name'] == 1 && $nick_name != '') {
                $change_name_info = $GLOBALS['db']->getRow("SELECT is_change_name,diamonds,nick_name FROM " . DB_PREFIX . "user WHERE id=" . $user_id);
                if ($change_name_info['nick_name'] != $user_info['nick_name']) {
                    if ($change_name_info['is_change_name'] == 1) {
                        if ($change_name_info['diamonds'] >= intval($m_config['change_name'])) {
                            $sql = "update " . DB_PREFIX . "user set diamonds=diamonds-" . intval($m_config['change_name']) . " where id=" . $user_id;
                            $GLOBALS['db']->query($sql);
                            // 消费和收益记录表
                            add_user_consumption_log($user_id, 0, intval($m_config['change_name']), api_lang('Nickname') . api_lang('CHANGE') . "：" . $user_info['nick_name'], 0, 0, 14);

                        } else {
                            ajax_return(array("status" => 0, "error" => api_lang('Nickname_modification_failed_recharge_diamonds')));
                        }
                    }
                }
            }

            bogo_require(APP_ROOT_PATH . "system/libs/user.php");
            //提交空字段不操作
            if ($user_info) {
                $root = save_user($user_info, 'UPDATE');
            } else {
                $root['status'] = 1;
                $root['error'] = '';
                ajax_return($root);
            }
            if ($root['status']) {
                //更新session
                $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $root['data']);
                es_session::set("user_info", $user_info);

                $user_id = $root['data'];
                if ($m_config['is_change_name'] == 1) {
                    $sql = "select id as user_id,head_image,nick_name,sex,signature,is_authentication,birthday,emotional_state,province,city,job,is_edit_sex,diamonds,is_change_name from " . DB_PREFIX . "user where id=" . $user_id;
                } else {
                    $sql = "select id as user_id,head_image,nick_name,sex,signature,is_authentication,birthday,emotional_state,province,city,job,is_edit_sex,diamonds from " . DB_PREFIX . "user where id=" . $user_id;
                }

                $user = $GLOBALS['db']->getRow($sql);

                if ($m_config['is_change_name'] == 1 && $nick_name != '') {
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    if ($change_name_info['nick_name'] != $user['nick_name']) {
                        if ($user['is_change_name'] == 0) {
                            $sql = "update " . DB_PREFIX . "user set is_change_name=1 where id=" . $user_id;
                            $GLOBALS['db']->query($sql);
                            $user_redis->update_db($user_id, array('is_change_name' => 1));
                        }
                        $user_redis->update_db($user_id, array('diamonds' => $user['diamonds']));
                    }
                }

                $user['head_image'] = get_spec_image($user['head_image']);

                $user['birthday'] = date('Y-m-d', $user['birthday']);
                $root['status'] = 1;
                $root['error'] = api_lang("Edit_succeeded");
                $root['user'] = $user;
            } else {
                $root['status'] = 0;
                if ($root['error'] == '') {
                    $root['error'] = api_lang("Edit_failed");
                }
            }
        }
        ajax_return($root);//返回信息缺少认证信息
    }

    /**
     * 地区接口
     */
    public function region_list()
    {
        $root = array();
        $root['status'] = 1;
        $root['error'] = '';
        $region_list = load_auto_cache("region_list");
        $root['region_list'] = $region_list;
        $m_config = load_auto_cache("m_config");
        $root['region_versions'] = $m_config['region_versions'];
        ajax_return($root);
    }

    /**
     * 认证初始化
     */
    public function authent()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $m_config = load_auto_cache("m_config");
            $root['status'] = 1;
            $root['error'] = "";
            $root['title'] = $m_config['short_name'] . ' ' . api_lang('CERTIFICATION');
            $user_id = intval($GLOBALS['user_info']['id']);

            $root['is_show_identify_number'] = intval($m_config['is_show_identify_number']);//0:不需要验证身份证号码 1:需要验证身份证号码
            $root['identify_hold_example'] = $m_config['identify_hold_example'];//手持身份证示例图片

            //判断是否开启公会邀请码功能ljz
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE && $m_config['society_pattern'] != 0 && $m_config['open_society_code'] == 1) {
                $root['open_society_code'] = 1;
            } else {
                $root['open_society_code'] = 0;
            }

            if ($root['open_society_code'] == 1 && defined('GAME_DISTRIBUTION') && GAME_DISTRIBUTION) {
                $user_sql = "select id,id as user_id,investor_send_info,authentication_type,authentication_name,identify_number, contact,from_platform,wiki,identify_positive_image,identify_nagative_image,identify_hold_image,is_authentication,game_distribution_id,society_code from " . DB_PREFIX . "user where is_effect =1 and id=" . $user_id;
            } elseif ($root['open_society_code'] == 1) {
                $user_sql = "select id,id as user_id,investor_send_info,authentication_type,authentication_name,identify_number, contact,from_platform,wiki,identify_positive_image,identify_nagative_image,identify_hold_image,is_authentication,society_code from " . DB_PREFIX . "user where is_effect =1 and id=" . $user_id;
            } elseif (defined('GAME_DISTRIBUTION') && GAME_DISTRIBUTION) {
                $user_sql = "select id,id as user_id,investor_send_info,authentication_type,authentication_name,identify_number, contact,from_platform,wiki,identify_positive_image,identify_nagative_image,identify_hold_image,is_authentication,game_distribution_id from " . DB_PREFIX . "user where is_effect =1 and id=" . $user_id;
            } else {
                $user_sql = "select id,id as user_id,investor_send_info,authentication_type,authentication_name,identify_number, contact,from_platform,wiki,identify_positive_image,identify_nagative_image,identify_hold_image,is_authentication from " . DB_PREFIX . "user where is_effect =1 and id=" . $user_id;
            }

            $user = $GLOBALS['db']->getRow($user_sql, true, true);
            foreach ($user as $k => $v) {
                $user[$k] = htmlspecialchars_decode($v);
            }
            //①用户认证状态为非默认状态(未认证) AND 身份证号码为空, 则不显示身份证号码
            if (intval($user['is_authentication']) != 0 && trim($user['identify_number']) == '') {
                $root['is_show_identify_number'] = 0;
            }
//            //②用户认证状态为未通过(3)状态 AND 需要身份验证, 则显示身份验证
//            if(intval($user['is_authentication'])==3 && intval($m_config['is_show_identify_number'])==1){
//                $root['is_show_identify_number'] = 1;
//            }

            $user['identify_number'] = !empty($user['identify_number']) ? $user['identify_number'] : '';

            $authent_list_sql = "select id,`name` from " . DB_PREFIX . "authent_list order by sort desc";
            $authent_list = $GLOBALS['db']->getAll($authent_list_sql, true, true);

            $root['authent_list'] = $authent_list;
            $root['invite_id'] = intval($user['game_distribution_id']);
            unset($user['game_distribution_id']);
            $root['user'] = $user;
            $root['invite_type_list'] = [];
            if (defined('GAME_DISTRIBUTION') && GAME_DISTRIBUTION) {
                $root['invite_id'] = intval($user['game_distribution_id']);
                unset($user['game_distribution_id']);
                $root['invite_type_list'] = [
                    [
                        'id'   => 1,
                        'name' => api_lang("nothing")
                    ],
                    [
                        'id'   => 2,
                        'name' => api_lang("Recommender_ID")
                    ],
                    [
                        'id'   => 3,
                        'name' => api_lang("Recommender_mobile_phone")
                    ],
                ];
            }

            //认证状态提示消息
            if (trim($user['investor_send_info']) && $user['is_authentication'] != 2) {
                $root['investor_send_info'] = $user['investor_send_info'];
            } else {
                $root['investor_send_info'] = $this->get_investor_info($user['is_authentication']);
            }
        }
        ajax_return($root);
    }

    /**
     * 提交保存认证信息
     */
    public function attestation()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $root['status'] = 1;
            $root['error'] = "";
            bogo_require(APP_ROOT_PATH . 'system/libs/user.php');
            $authent_list_id = intval($_REQUEST['authentication_id']);//认证类型id
            $authentication_type = strim($_REQUEST['authentication_type']);//认证类型
            $authentication_name = trim($_REQUEST['authentication_name']);//真实姓名

            $m_config = load_auto_cache("m_config");
            $is_check_id_num = intval($m_config['is_show_identify_number']);//0:不需要验证身份证号码 1:需要验证身份证号码
            $authent_info = $GLOBALS['db']->getRow("select is_authentication,identify_number from  " . DB_PREFIX . "user where id=" . $GLOBALS['user_info']['id']);
            if (intval($authent_info['is_authentication']) != 0 && trim($authent_info['identify_number']) == '') {
                $is_check_id_num = 0;
            }
            $identify_number = strim($_REQUEST['identify_number']);//身份证号码

            $identify_hold_image = strim($_REQUEST['identify_hold_image']);//手持身份证正面
            $identify_positive_image = strim($_REQUEST['identify_positive_image']);//身份证正面
            $identify_nagative_image = strim($_REQUEST['identify_nagative_image']);//身份证反面

            $contact = trim($_REQUEST['contact']);//联系方式
            //$from_platform = '';//来自平台
            $wiki = trim($_REQUEST['wiki']); //百度百科


            //=============================
            if ($authentication_type == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Select_authentication_type");
                ajax_return($root);
            }
            if ($authentication_name == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Fill_in_your_real_name");
                ajax_return($root);
            }
            //是否需要验证身份证号码 $is_check_id_num: 1需要验证; 0跳过验证
            if ($identify_number == '' && $is_check_id_num == 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("Enter_ID_number");
                ajax_return($root);
            }
            if ($identify_positive_image == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Upload_ID_card_photo");
                ajax_return($root);
            }
            if ($identify_nagative_image == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Upload_ID_back_photo");
                ajax_return($root);
            }
            if ($identify_hold_image == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Upload_handheld_ID_front");
                ajax_return($root);
            }
            if ($contact == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Fill_in_the_contact_information");
                ajax_return($root);
            }
            /*if($from_platform==''){
                $root['status'] = 0;
                $root['error'] = '请填写来自平台！';
                 ajax_return($root);
            }*/

            // 匹配中文
//            if (!preg_match('/^([\xe4-\xe9][\x80-\xbf]{2}){2,4}$/', $authentication_name)) {
//                $root['status'] = 0;
//                $root['error'] = api_lang("fill_in_your_Chinese_name");
//                ajax_return($root);
//            }

            if (strlen($contact) == 0) {
                $root['status'] = 0;
                $root['error'] = api_lang("Fill_in_the_mobile_number");
                ajax_return($root);
            }

//            if (!check_mobile($contact)) {
//                $root['status'] = 0;
//                $root['error'] = api_lang("Fill_in_the_mobile_number");
//                ajax_return($root);
//            }


            if (defined('EXAMINE_TIME') && EXAMINE_TIME) {
                $user_investor_time = $GLOBALS['db']->getRow("select investor_time from  " . DB_PREFIX . "user where id=" . $GLOBALS['user_info']['id']);
                $m_config = load_auto_cache("m_config");
                if ($m_config['attestation_time'] !== '') {
                    if (get_gmtime() < $user_investor_time['investor_time']) {
                        $investor_time = to_date($user_investor_time['investor_time'], "Y-m-d:H:i:s");
                        $root['status'] = 0;
                        $root['error'] = api_lang("Your_next_audit_time_is") . $investor_time;
                        ajax_return($root);
                    }
                }
            }

            //判断该实名是否存在
            $user_info = $GLOBALS['db']->getRow("select id  from  " . DB_PREFIX . "user where id=" . $GLOBALS['user_info']['id']);
            if ($user_info) {
                $user_info['is_authentication'] = 1;//认证状态 0指未认证  1指待审核 2指认证 3指审核不通过
                $user_info['user_type'] = 0;//用户类型
                $user_info['authent_list_id'] = $authent_list_id;//认证类型id
                $user_info['authentication_type'] = $authentication_type;//认证类型
                $user_info['authentication_name'] = $authentication_name;//真实姓名
                $user_info['identify_number'] = $identify_number;//身份证号码
                $user_info['contact'] = $contact;//联系方式
                //$user_info['from_platform'] = $from_platform;//来自平台
                $user_info['wiki'] = $wiki; //百度百科
                $user_info['identify_hold_image'] = get_spec_image($identify_hold_image);//手持身份证正面
                $user_info['identify_positive_image'] = get_spec_image($identify_positive_image);//身份证正面
                $user_info['identify_nagative_image'] = get_spec_image($identify_nagative_image);//身份证反面

                if (defined('GAME_DISTRIBUTION') && GAME_DISTRIBUTION) {
                    $game_distribution_id = 0;
                    $game_distribution_type = intval($_REQUEST['invite_type']);
                    switch ($game_distribution_type) {
                        case 2:
                            $game_distribution_id = intval($_REQUEST['invite_input']);
                            if (!$game_distribution_id) {
                                ajax_return(['status' => 0, 'error' => api_lang("recommender_ID_does_not_exist")]);
                            }
                            $game_distribution_id = $GLOBALS['db']->getOne("select id from  " . DB_PREFIX . "user where id={$game_distribution_id} or luck_num = {$game_distribution_id}");
                            if (!$game_distribution_id) {
                                ajax_return(['status' => 0, 'error' => api_lang("recommender_ID_does_not_exist")]);
                            }
                            break;
                        case 3:
                            $game_distribution_moblie = trim($_REQUEST['invite_input']);
                            if (!$game_distribution_moblie) {
                                ajax_return(['status' => 0, 'error' => api_lang("Fill_mobile_phone_of_the_recommender")]);
                            }
                            $game_distribution_id = $GLOBALS['db']->getOne("select id from  " . DB_PREFIX . "user where mobile={$game_distribution_moblie}");
                            if (!$game_distribution_id) {
                                ajax_return(['status' => 0, 'error' => api_lang("Recommended_mobile_phone_does_not_exist")]);
                            }
                            break;
                        default:
                            break;
                    }
                    if ($GLOBALS['user_info']['id'] == $game_distribution_id) {
                        ajax_return(['status' => 0, 'error' => api_lang("You_can_recommend_yourself")]);
                    } else {
                        $set = "`game_distribution_id` = $game_distribution_id";
                        if (defined('GAME_DISTRIBUTION_TOP') && GAME_DISTRIBUTION_TOP && $game_distribution_type != 1) {
                            $top = $GLOBALS['db']->getOne("SELECT game_distribution_top_id FROM `" . DB_PREFIX . "user` WHERE `id` = " . $game_distribution_id);
                            if (!$top) {
                                ajax_return(['status' => 0, 'error' => api_lang("recommender_is_invalid")]);
                            }
                            $set .= ',`game_distribution_top_id` = ' . $top;
                        }
                        $GLOBALS['db']->query("UPDATE `" . DB_PREFIX . "user` SET $set WHERE `id` = " . intval($GLOBALS['user_info']['id']));
                    }
                }

                //公会邀请码ljz
                $user_info['society_code'] = strim($_REQUEST['society_code']);
                if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE) {//服务端开始公会
                    $m_config = load_auto_cache("m_config");
                    if ($m_config['society_pattern'] != 0 && $m_config['open_society_code'] == 1 && strlen($user_info['society_code']) != 0) {//后台开启公会，开启公会邀请码，邀请码有值
                        $society_id = $GLOBALS['db']->getOne("select society_id from " . DB_PREFIX . "user where id=" . $GLOBALS['user_info']['id']);
                        if ($society_id) {//判断是否有公会
                            ajax_return(['status' => 0, 'error' => api_lang("You_already_have_a_guild")]);
                        } else {
                            $res = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "society where status=1 and society_code='" . $user_info['society_code'] . "'");
                            if (empty($res)) {//邀请码是否存在
                                ajax_return(['status' => 0, 'error' => api_lang("Guild_invitation_code_does_not_exist")]);
                            }
                        }
                    }
                }

                $res = save_user($user_info, "UPDATE");

                if ($res['status'] == 1) {
                    //更新session
                    $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $res['data']);
                    es_session::set("user_info", $user_info);

                    $root['status'] = 1;
                    $root['error'] = api_lang("Submitted_for_review");
                } else {
                    $root['status'] = 0;
                    $root['error'] = $res['error'];
                }
            } else {
                $root['status'] = 0;
                $root['error'] = api_lang("Member_information_does_not_exist");
            }
        }
        ajax_return($root);
    }

    //提现领取记录
    public function extract_record()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = $GLOBALS['user_info']['id'];
            $sql = "select money,pay_time,create_time,is_pay from " . DB_PREFIX . "user_refund  where is_pay in (1,3) and user_id =" . $user_id . ' order by pay_time desc';
            $list = $GLOBALS['db']->getAll($sql, true, true);
            if ($list) {
                $totle_money = 0;
                foreach ($list as $k => $v) {
                    if ($v['is_pay'] == 3) {
                        $totle_money += $v['money'] * 100;
                    }
                    $record[$k]['money'] = number_format($v['money'], 2);
                    if ($v['pay_time'] != 0) {
                        $record[$k]['pay_time'] = date("Y-m-d", $v['pay_time']);
                    }
                    $record[$k]['is_pay'] = intval($v['is_pay']);
                    $record[$k]['create_time'] = date("Y-m-d", $v['create_time']);
                }
            } else {
                $record = array();
            }

            $root['total_money'] = number_format(intval($totle_money) / 100, 2);
            $root['status'] = 1;
            $root['error'] = '';//提现记录
            $root['list'] = $record;
        }

        ajax_return($root);
    }

    //更新微信openid
    public function update_wxopenid()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
            bogo_require(APP_ROOT_PATH . "system/utils/weixin.php");
            $m_config = load_auto_cache("m_config");//初始化手机端配置

            //获取微信配置信息
            if ($m_config['wx_appid'] == '' || $m_config['wx_secrit'] == '') {
                $root['status'] = 0;
                $root['error'] = api_lang("Wechat_withdrawal_parameters_not_configured");
                ajax_return($root);
            } else {
                $wx_appid = strim($m_config['wx_appid']);
                $wx_secrit = strim($m_config['wx_secrit']);
            }

            $jump_url = SITE_DOMAIN . url_wap("user_center#update_wxopenid");

            $weixin = new weixin($wx_appid, $wx_secrit, $jump_url);

            if (($_REQUEST['openid'] != "" && $_REQUEST['access_token'] != "") || $_REQUEST['code'] != "") {
                if ($_REQUEST['openid'] != "" && $_REQUEST['access_token'] != "") {
                    $wx_info = $weixin->sns_get_userinfo($_REQUEST['openid'], $_REQUEST['access_token']);
                } else if ($_REQUEST['code'] != "") {
                    $wx_info = $weixin->scope_get_userinfo($_REQUEST['code']);
                } else {
                    $root['status'] = 0;
                    $root['error'] = api_lang("Failed_to_obtain_wechat_parameters") . "(openid or code).";
                }
                bogo_require(APP_ROOT_PATH . "system/libs/user.php");
                $root = wxUser_update($wx_info, $user_id);
            } else {
                $root['status'] = 0;
                $root['error'] = api_lang("Unable_to_get_app_wechat_parameters") . "(openid or code)!";
            }
        }
        ajax_return($root);
    }

    //支付宝提现绑定接口
    public function binding_alipay()
    {
        $root = array();
        $user_id = $GLOBALS['user_info']['id'] ? $GLOBALS['user_info']['id'] : $_REQUEST['uid'];//会员ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //$user_id = $GLOBALS['user_info']['id'];
            $alipay_name = trim($_REQUEST['alipay_name']);
            $alipay_account = trim($_REQUEST['alipay_account']);

            if ($alipay_name != '' && $alipay_account != '') {
                $alipay = array();
                $alipay['alipay_name'] = strim($alipay_name);
                $alipay['alipay_account'] = strim($alipay_account);
                $alipay['binding_alipay'] = 1;
                $where = "id=" . $user_id;
                $result = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $alipay, "UPDATE", $where);

                if (!$result) {
                    $root['error'] = api_lang("Binding_failed");
                    $root['status'] = 0;
                } else {
                    bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                    $user_redis = new UserRedisService();
                    $user_ticket_info = $user_redis->update_db($user_id, $alipay);

                    $root['error'] = api_lang("Binding_succeeded");
                    $root['status'] = 1;
                }
            } else {
                $root['error'] = api_lang("Alipay_account_can_not_be_empty");
                $root['status'] = 0;
            }
        }
        ajax_return($root);
    }

    //支付宝提现界面初始化接口
    public function money_carry_alipay()
    {
        $root = array('status' => 1, 'error' => api_lang("Initialization_successful"));
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $user_id = intval($GLOBALS['user_info']['id']);
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $ticket = $user_redis->getRow_db($user_id, array('ticket', 'refund_ticket'));
            //提现比例 如果主播提现比例为空，则使用后台通用比例
            $root['ratio'] = $GLOBALS['db']->getOne("select alone_ticket_ratio from " . DB_PREFIX . "user where id=" . $user_id);
            if ($root['ratio'] == '') {
                $root['ratio'] = $m_config['ticket_catty_ratio'];
            }
            //公会长提现比例特殊
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE && $m_config['society_pattern'] == 2) {
                $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_id);
                if (intval($society_info['society_chieftain'])) {
                    $refund_rate = $GLOBALS['db']->getOne("select refund_rate from " . DB_PREFIX . "society where id=" . $society_info['society_id']);
                    $root['ratio'] = floatval($refund_rate);
                    if ($root['ratio'] > 1 || $root['ratio'] <= 0) {
                        $root['ratio'] = $m_config['society_public_rate'];
                    }
                }
            }
            $root['can_use_ticket'] = intval($ticket['ticket'] - $ticket['refund_ticket']);//可提现印票

            if (floatval($m_config['ticket_catty_ratio']) > 0) {
                //每日可提现印票
                $root['day_ticket_max'] = intval(intval($m_config['day_cash_max']) / floatval($root['ratio']));
                //最小提现印票
                $root['ticket_catty_min'] = intval(intval($m_config['ticket_catty_min']) / floatval($root['ratio']));
            }

            //计算已提现印票
            $user_refund = $GLOBALS['db']->getRow("SELECT SUM(ticket) AS refund_sum FROM " . DB_PREFIX .
                "user_refund WHERE user_id=" . $user_id . " AND is_pay=3");
            $root['ready_refund_ticket'] = intval($user_refund['refund_sum']);
        }
        ajax_return($root);
    }

    //支付宝提现接口---使用中
    public function submit_refund_alipay()
    {
        $root = array('status' => 1, 'error' => api_lang("success"));
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $user_id = $GLOBALS['user_info']['id'];//会员ID
            if (intval($m_config['is_refund']) != 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("withdrawal_now_closed");
                ajax_return($root);
            }
            //判断是否在直播中，如是则不让进入提现界面
            $is_live = $GLOBALS['db']->getRow("select user_id,live_in from " . DB_PREFIX . "video where  user_id=" . $user_id . " order by id desc");
            //异常退出后，等待公会长抽成完成后才能提现ljz
            if (!empty($is_live) && $is_live['live_in'] == 1) {
                $root['status'] = 0;
                $root['error'] = api_lang("Unable_to_withdraw_cash_temporarily");
                ajax_return($root);
            }

            $user = $GLOBALS['db']->getRow("select alone_ticket_ratio,country_code from " . DB_PREFIX . "user where id=" . intval($user_id));
            $rate = $user['alone_ticket_ratio'];
            if ($rate == '') {
                $country_ratio =get_country_config(2,$user['country_code']);
                $rate = $country_ratio > 0 ? floatval($country_ratio) : floatval($m_config['ticket_catty_ratio']);
            }
            $result_one = Db::name("user_cash_account")->where("uid=" . $user_id . " and choose=1")->find();
            if (!$result_one) {
                $root['error'] = api_lang("Please_bind_Alipay");
                $root['status'] = 0;
                api_ajax_return($root);
            }
            $ticket = intval($_REQUEST['ticket']);//提现印票
            $memo = $result_one['account'];
            $money = floatval($ticket * $rate);
            //未处理提现
            $ready_refund_id = intval($GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user_refund where user_id = " . intval($user_id) . " and (is_pay =0 or is_pay=1)"));
            if ($ready_refund_id) {
                $root['error'] = api_lang("There_are_outstanding_withdrawals");
                $root['status'] = 0;
                ajax_return($root);
            }
            $keys="submit_refund_alipay_".$user_id;
            $is_lock = intval(redis_get($keys));
            if($is_lock > 0){
                $root['status'] = 0;
                $root['error'] = api_lang("in_process");
                ajax_return($root);
            }
            redis_set($keys,1,5);
            //会员当前印票
            $user_ticket_info = $GLOBALS['db']->getRow("select ticket,refund_ticket from " . DB_PREFIX . "user where id = '" . intval($user_id) . "'");
            $user_ticket = $user_ticket_info['ticket'] - $user_ticket_info['refund_ticket'];//可使用的印票
            $before_to_ticket = $user_ticket_info['ticket'];
            //超额判断
            if ($ticket > $user_ticket) {
                $root['error'] = api_lang("No_more_than_available_withdrawal");
                $root['status'] = 0;
                redis_rm($keys);
                ajax_return($root);
            }
            // 进入每月提现一次流程
            $month_carry_one = intval($m_config['month_carry_one']) ? 1 : 0;//提现配置，1：每月提现1次，0：无限制
            if ($month_carry_one) {
                $ready_refund_info = $GLOBALS['db']->getRow("select pay_time from " . DB_PREFIX . "user_refund where user_id = " . intval($user_id) . " and is_pay = 3");
                $pay_time = $ready_refund_info['pay_time'];
                //本月是否有提现
                if ($pay_time != '' && (to_date($pay_time, "Ym") == to_date(get_gmtime(), 'Ym'))) {
                    $root['error'] = api_lang("Cash_has_been_withdrawn_this_month");
                    $root['status'] = 0;
                    redis_rm($keys);
                    ajax_return($root);
                } else {
                    //查看本月允许提现时间，精确计算到天
                    if ((to_date(get_gmtime(), 'd') > intval($m_config['month_carry_max']) || to_date(get_gmtime(), 'd') < intval($m_config['month_carry_min'])) && intval($m_config['month_carry_max']) != 0 && intval($m_config['month_carry_min']) != 0) {
                        $root['error'] = api_lang("monthly") . intval($m_config['month_carry_min']) . api_lang("day") . api_lang("reach") . intval($m_config['month_carry_max']) . api_lang("day") . api_lang("To_withdraw_cash");
                        $root['status'] = 0;
                        redis_rm($keys);
                        ajax_return($root);
                    }
                }
            }
            //百媚模式下代理会员提现
            if (defined('OPEN_BM') && OPEN_BM) {
                $bm_config = load_auto_cache("bm_config");
                $bm_pid = intval($bm_config['bm_pid']);
                $bm_user = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id=" . intval($user_id) . " and( bm_pid=" . $bm_pid . " or bm_pid=0)");
                $bm_promoter = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "bm_promoter where user_id=" . intval($user_id));
                if ($bm_user == '' || $bm_promoter) {
                    $root['error'] = $m_config['bm_point'];
                    $root['status'] = 0;
                    redis_rm($keys);
                    ajax_return($root);
                }

            }


            //如果开启公会并且开启无抽成模式，支付宝 将无法提现ljz
            if (defined('OPEN_SOCIETY_MODULE') && OPEN_SOCIETY_MODULE == 1 && $m_config['society_pattern'] == 2) {
                $society_info = $GLOBALS['db']->getRow("select society_id,society_chieftain from " . DB_PREFIX . "user where id=" . $user_id);
                if (intval($society_info['society_chieftain']) == 1) {
                    $root['error'] = api_lang("Withdrawal_by_Chairman");
                    $root['status'] = 0;
                    redis_rm($keys);
                    ajax_return($root);
                } elseif (intval($society_info['society_id'])) {
                    $root['error'] = api_lang("association_does_not_withdraw_cash");
                    $root['status'] = 0;
                    redis_rm($keys);
                    ajax_return($root);
                }
            }

            //提现最小值
            $ticket_catty_min = $m_config['ticket_catty_min'] > 1 ? $m_config['ticket_catty_min'] : 1;
            //最小判断
            if ($money < $ticket_catty_min) {
                $root['error'] = api_lang("Withdrawal_cannot_be_less_than") . $ticket_catty_min . api_lang("Yuan");
                $root['status'] = 0;
                redis_rm($keys);
                ajax_return($root);
            }

            //取用户当日提现金额之和
            //create_time储存的是格林威治时间。使用时需转换为北京时间
            $refunded_money_sql = "select sum(money) from " . DB_PREFIX . "user_refund where user_id=$user_id and (is_pay=0 or is_pay=1 or is_pay=3) 
			                        and DATE_FORMAT(FROM_UNIXTIME(create_time+28800),'%Y-%m-%d')=DATE_FORMAT(NOW(),'%Y-%m-%d')";
            $refunded_money = $GLOBALS['db']->getOne($refunded_money_sql);
            $total_money = floatval($refunded_money) + $money;
            //提现最大值
            $day_cash_max = intval($m_config['day_cash_max']);
            //总和判断
            if ($total_money > $day_cash_max) {
                $root['error'] = api_lang("No_more_than_daily_withdrawal") . $day_cash_max . api_lang("Yuan");
                $root['status'] = 0;
                redis_rm($keys);
                ajax_return($root);
            }
            $pay = $GLOBALS['db']->getRow("select id,config,logo,class_name from " . DB_PREFIX . "payment where is_effect= 1 and is_modern_payment=1");
            if($result_one['bank_code'] && $pay){
                $refund_data['payment_id'] = $pay['id'];
            }
            $refund_data['money'] = $money;
            $refund_data['user_bank_id'] = -1;
            $refund_data['ticket'] = $ticket;
            $refund_data['user_id'] = $user_id;
            $refund_data['create_time'] = NOW_TIME;
            $refund_data['memo'] = $memo;
            $refund_data['account_number'] = $result_one['account_number'];
            $refund_data['account_name'] = $result_one['name'];
            $refund_data['bank_name'] = $result_one['account'];
            $refund_data['bank_code'] = $result_one['bank_code'];
            $refund_data['partner_trade_no'] = to_date(NOW_TIME, "Ymdhi") . rand(10000, 99999);
            $refund_data['withdrawals_type'] = 1;
            $refund_data['withdrawal_ratio'] = $rate;
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user_refund", $refund_data);


            //冻结用户提现印票
            $sql = "update " . DB_PREFIX . "user set refund_ticket=refund_ticket +" . $refund_data['ticket'] . " where ticket >= refund_ticket + " . $refund_data['ticket'] . " and id=" . $refund_data['user_id'];
            $GLOBALS['db']->query($sql);
            // 加入扣费记录

            $content = api_lang('label.application_for_withdrawal') . ":" . api_lang('Net_income') . "=" . $refund_data['ticket'] . "; " . api_lang('Withdrawal') . " = " . $refund_data['money'];
            add_user_records($user_id, 0, 0, $refund_data['ticket'], 0, $before_to_ticket, 0, 0, $content, 9);

            // 消费和收益记录表
            add_user_consumption_log($user_id, $user_id, 0, api_lang('提现'), '-' . $ticket, 0, 21);
            redis_rm($keys);
        }
        ajax_return($root);
    }

    //竞拍收入明细
    //$type  0 --已结算
    //$type  1 --待结算
    public function income()
    {

//		if (intval($_REQUEST['details'])==1) {
//			$this->goods_income_details();
//		}
        $root = array();
        $user_id = intval($GLOBALS['user_info']['id']);
        if ($user_id == 0) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            api_ajax_return($root);
        }

        $year = intval($_REQUEST['year']);
        $month = intval($_REQUEST['month']);
        $type = intval($_REQUEST['type']);
        $is_pai = intval($_REQUEST['is_pai']);

        $time = NOW_TIME;
        $end_year = to_date($time, 'Y');
        $end_month = to_date($time, 'm');

        if ($year == 0) {
            $year = $end_year;
            $month = $end_month;
        }

        $rs = BogoServiceCall("user_center", "pai_income_details", array("user_id" => $user_id, "year" => $year, "month" => $month, "type" => $type, "is_pai" => $is_pai));

        if ($rs['status'] == 1) {

            $root['type'] = $type;
            $root['status'] = $rs['status'];
            $root['ticket'] = $rs['cumulative'];
            $root['pending'] = $rs['settlement'];
            $root['now_year'] = $year;
            $root['now_month'] = $month;
            $root['end_year'] = intval($end_year);
            $root['end_month'] = intval($end_month);
            $root['list'] = $rs['details'];
            $root['page'] = array('page' => 1, 'has_next' => 0);
        }

        api_ajax_return($root);
    }

    //商品收入明细
    //$type  1 --已结算
    //$type  2 --待结算
    //$tupe  3 --无效
    public function goods_income_details()
    {
        $root = array();
        $user_id = intval($GLOBALS['user_info']['id']);
        if ($user_id == 0) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            api_ajax_return($root);
        }

        $page = intval($_REQUEST['page']);
        $page_size = 20;
        $time = NOW_TIME;
        $year = intval($_REQUEST['year']);
        $month = intval($_REQUEST['month']);
        $type = intval($_REQUEST['type']);

        $end_year = to_date($time, 'Y');
        $end_month = to_date($time, 'm');

        if ($year == 0) {
            $year = $end_year;
            $month = $end_month;
        }

        bogo_require(APP_ROOT_PATH . 'mapi/shop/pai_podcast.action.php');
        $pai_podcast = new pai_podcastCModule();
        $rs = $pai_podcast->commodity_profitlist($page, $page_size, $time, $year, $month, $type);

        if ($rs['status'] == 1) {
            if ($rs['OrderIncome']['totalAccount'] == '') {
                $rs['OrderIncome']['totalAccount'] = 0;
            }
            if ($rs['OrderIncome']['waitAccount'] == '') {
                $rs['OrderIncome']['waitAccount'] = 0;
            }
            if ($rs['ProfitOrder'] == '') {
                $rs['ProfitOrder'] = array();
            }

            $root['type'] = $type;
            $root['status'] = $rs['status'];
            $root['ticket'] = $rs['OrderIncome']['totalAccount'];
            $root['pending'] = $rs['OrderIncome']['waitAccount'];
            $root['now_year'] = $year;
            $root['now_month'] = $month;
            $root['end_year'] = intval($end_year);
            $root['end_month'] = intval($end_month);
            $root['list'] = $rs['ProfitOrder'];
            $root['page'] = array('page' => 1, 'has_next' => 0);
        }

        api_ajax_return($root);
    }

    /*
     * 支付宝认证
     */
    public function authent_alipay()
    {
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $user_id = intval($GLOBALS['user_info']['id']);
        $request = $_REQUEST;
        if ($user_id == 0) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            ajax_return($root);
        } else {
            $m_config = load_auto_cache("m_config");//初始化手机端配置
            $aliConnect = new aliConnectAPI($m_config['alipay_partner'], $m_config['alipay_key']);
            if (intval($GLOBALS['db']->getOne("select id from bogo_user where v_type=3 and id=" . $user_id . " and alipay_authent_token <>''"))) {
                $root['status'] = 0;
                $root['error'] = api_lang("User_Alipay_has_been_certified");
                echo $aliConnect->build_html($root['error']);
                die;
            }

            if (strim($request['is_success']) == 'T') {
                //支付宝用户号
                $alipay_user_id = intval($request['user_id']);
                //授权令牌
                $token = strim($request['token']);
                //真实姓名
                $real_name = strim($_REQUEST['real_name']);
                require_once(APP_ROOT_PATH . "system/libs/user.php");
                $user_data = array();
                $user_data['id'] = $user_id;
                $user_data['alipay_user_id'] = $alipay_user_id;
                $user_data['alipay_name'] = $real_name;
                $user_data['alipay_authent_token'] = $token;
                $user_data['v_type'] = 3;
                $root = AuthentAlipayUser($user_data);
                echo $aliConnect->buildRequestForm($root['error']);
                die;
            }

            if ((!defined('OPEN_AUTHENT_ALIPAY') || OPEN_AUTHENT_ALIPAY == 0) && intval($m_config['authent_alipay']) == 0) {
                $root['status'] = 0;
                $root['error'] = api_lang("Alipay_key_authentication_not_open");
                ajax_return($root);
            } else {
                $aliConnect->get_display_code();
            }
        }

    }

    /*
     * 更新推荐人字段
    */
    public function update_p_user_id()
    {

        $root = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);
        $request = $_REQUEST;
        if ($user_id == 0) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            ajax_return($root);
        }

        if (intval($GLOBALS['user_info']['p_user_id']) > 0) {
            $root['error'] = api_lang("Recommender_already_exists");
            $root['status'] = 0;
            ajax_return($root);
        }

        $p_user_id = intval($_REQUEST['p_user_id']);
        $p_user_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id =" . $p_user_id);

        if (intval($p_user_id) == 0) {
            $root['error'] = api_lang("recommender_does_not_exist");
            $root['status'] = 0;
            ajax_return($root);
        }

        $data = array(
            'p_user_id' => $p_user_id,
        );

        $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, "UPDATE", "id=" . $user_id);

        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        $user_redis->update_db($user_id, $data);

        //更新session
        $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
        es_session::set("user_info", $user_info);


        api_ajax_return($root);

    }

    /*
     * 获取推荐人字段
    */
    public function get_p_user_id()
    {
        $root = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);
        $request = $_REQUEST;
        if ($user_id == 0) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            ajax_return($root);
        }

        $root['p_user_id'] = intval($GLOBALS['user_info']['p_user_id']);

        api_ajax_return($root);

    }

    //认证状态提示消息
    public function get_investor_info($authent_type)
    {
        $type = intval($authent_type);
        $info = '';
        if ($type == 0) {
            $info = api_lang("Items_with_asterisk_are_required");
        } elseif ($type == 1) {
            $info = api_lang("Certification_under_review");
        } elseif ($type == 2) {
            $info = api_lang("Congratulations_on_the_successful_certification");
        } elseif ($type == 3) {
            $info = api_lang("Certification_failed");
        }
        return $info;
    }

    // 账户记录
    public function user_log()
    {
        $root = array('status' => 1, 'error' => '');
        $root['token'] = strim($_REQUEST['token']);

        api_ajax_return($root);
    }

    // 直播记录
    public function live_log()
    {
        $root = array('status' => 1, 'error' => '');
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $user_id = $user_info ? $user_info['id'] : intval($GLOBALS['user_info']['id']);

        $m_config = load_auto_cache("m_config");

        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;

        $page_size = 10;
        $p = $page == 1 ? 0 : $page_size * ($page - 1);
        $limit = $p . "," . $page_size;
        // 获取时间查询
        $sql = "select len_time,title,begin_time from " . DB_PREFIX . "video_history where user_id=" . $user_id . " and len_time>0 order BY begin_time desc limit " . $limit;

        $list = $GLOBALS['db']->getAll($sql, true, true);
        // 当日直播时长
        $begin_time = strtotime(date('Y-m-d'));
        $sql = "select sum(len_time) from " . DB_PREFIX . "video_history where user_id=" . $user_id . " and len_time>0 and begin_time >=" . $begin_time . " order BY begin_time desc limit " . $limit;
        $day_len = $GLOBALS['db']->getOne($sql, true, true);
        // 本月直播时长
        $start_time = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $end_time = mktime(23, 59, 59, date('m'), date('t'), date('Y'));
        $sql = "select sum(len_time)  from " . DB_PREFIX . "video_history where user_id=" . $user_id . " and len_time>0 and begin_time >=" . $start_time . " and begin_time<= " . $end_time . " order BY begin_time desc limit " . $limit;
        $month_len = $GLOBALS['db']->getOne($sql, true, true);

        foreach ($list as &$v) {
            $v['begin_time'] = date('Y-m-d H:i:s', $v['begin_time']);
            $v['len_time'] = get_live_time_lenght($v['len_time']);
            $v['title'] = $v['title'] ? $v['title'] : api_lang("No_theme");
        }
        $root['has_next'] = count($list) <= 0 ? 0 : 1;
        $root['list'] = $list;
        $root['day_len'] = $day_len ? get_live_time_lenght(intval($day_len)) : '00:00:00';
        $root['month_len'] = $month_len ? get_live_time_lenght(intval($month_len)) : '00:00:00';
        $root['token'] = strim($_REQUEST['token']);
        $root['diamonds_name'] = $m_config['diamonds_name'];
        if ($page > 1) {
            ajax_return($root);
        } else {
            api_ajax_return($root);
        }
    }

    // 兑换记录
    public function exchange_log()
    {
        $root = array('status' => 1, 'error' => '');
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $user_id = $user_info ? $user_info['id'] : intval($GLOBALS['user_info']['id']);

        $m_config = load_auto_cache("m_config");

        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;

        $page_size = 10;
        $p = $page == 1 ? 0 : $page_size * ($page - 1);
        $limit = $p . "," . $page_size;
        // 获取时间查询
        $sql = "select ticket,diamonds,create_time,is_success from " . DB_PREFIX . "exchange_log where user_id=" . $user_id . " order BY create_time desc limit " . $limit;

        $list = $GLOBALS['db']->getAll($sql, true, true);
        foreach ($list as &$v) {
            $v['create_time'] = date('Y-m-d H:i', $v['create_time']);
            $v['is_success_status'] = $v['is_success'] == 1 ? api_lang("Successful_trade") : api_lang("The_deal_failed");
        }
        $root['has_next'] = count($list) <= 0 ? 0 : 1;
        $root['list'] = $list;
        $root['token'] = strim($_REQUEST['token']);
        $root['diamonds_name'] = $m_config['diamonds_name'];
        if ($page > 1) {
            ajax_return($root);
        } else {
            api_ajax_return($root);
        }
    }

    // 充值记录
    public function recharge_log()
    {
        $root = array('status' => 1, 'error' => '');
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $user_id = $user_info ? $user_info['id'] : intval($GLOBALS['user_info']['id']);

        $m_config = load_auto_cache("m_config");

        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;

        $page_size = 10;
        $p = $page == 1 ? 0 : $page_size * ($page - 1);
        $limit = $p . "," . $page_size;
        // 获取时间查询
        $sql = "select money,recharge_name,diamonds,type,create_time,is_paid from " . DB_PREFIX . "payment_notice where user_id=" . $user_id . " and type = 0 order BY create_time desc limit " . $limit;

        $list = $GLOBALS['db']->getAll($sql, true, true);
        foreach ($list as &$v) {
            $v['create_time'] = date('Y-m-d H:i', $v['create_time']);
            $v['is_paid_status'] = $v['is_paid'] == 1 ? api_lang("Successful_trade") : api_lang("The_deal_failed");
        }
        $root['has_next'] = count($list) <= 0 ? 0 : 1;
        $root['list'] = $list;
        $root['token'] = strim($_REQUEST['token']);
        $root['diamonds_name'] = $m_config['diamonds_name'];
        if ($page > 1) {
            ajax_return($root);
        } else {
            api_ajax_return($root);
        }
    }

    // 收益记录
    public function earnings_log()
    {
        $root = array('status' => 1, 'error' => '', 'list' => []);
        $year = strim($_REQUEST['year']) ? $_REQUEST['year'] : date("Y", NOW_TIME);
        $month = strim($_REQUEST['month']) ? $_REQUEST['month'] : date("m", NOW_TIME);
        $time_show = $year . '-' . $month;
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        if (!$user_info) {
            $root['status'] = 10007;
            $root['error'] = api_lang("Please_log_in_first");
            api_ajax_return($root);
        }
        $user_id = $user_info['id'];

        createPropTable();

        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;

        $page_size = 20;
        $p = $page == 1 ? 0 : $page_size * ($page - 1);
        $limit = $p . "," . $page_size;
        // 获取时间查询

        $start_time = date('Ym', strtotime(strim($time_show)));
        $table = DB_PREFIX . "video_prop_" . $start_time;
        $result = $GLOBALS['db']->getRow("SHOW TABLES LIKE '" . $table . "'");
        $count = 0;
        $list = [];

        if (!empty($result)) {
            $sql = "select u.nick_name,v.total_ticket,v.prop_name,FROM_UNIXTIME(v.create_time,'%y-%m-%d %H:%i') as time
                from " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = v.from_user_id
                where v.to_user_id=" . $user_id . " and v.total_ticket > 0 order BY v.create_time desc limit " . $limit;

            $list = $GLOBALS['db']->getAll($sql, true, true);

            $sql = "select sum(v.total_ticket) as total_ticket
                    from " . $table . " as v LEFT JOIN " . DB_PREFIX . "user as u on u.id = v.from_user_id
                    where v.to_user_id=" . $user_id . " and v.total_ticket > 0";

            $count = $GLOBALS['db']->getOne($sql, true, true);
        }

        $root['has_next'] = count($list) <= 0 ? 0 : 1;

        $root['count'] = intval($count);
        $root['list'] = $list;
        $root['start_time'] = $time_show;
        $root['user_id'] = $user_id;

        ajax_return($root);
    }

    // 短视频收礼记录
    public function video_log()
    {
        $root = array('status' => 1, 'error' => '');
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }
        $user_id = $user_info ? $user_info['id'] : intval($GLOBALS['user_info']['id']);

        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;

        $page_size = 10;
        $p = $page == 1 ? 0 : $page_size * ($page - 1);
        $limit = $p . "," . $page_size;
        // 获取查询
        $sql = "select u.nick_name,v.content,p.name,w.gift_num,w.count_price,w.addtime
                from " . DB_PREFIX . "weibo_gift as w INNER JOIN " . DB_PREFIX . "user as u on u.id = w.uid INNER JOIN " . DB_PREFIX . "weibo as v on v.id = w.weibo 
                INNER JOIN " . DB_PREFIX . "prop as p on p.id = w.gift
                where w.to_uid=" . $user_id . " order BY w.addtime desc limit " . $limit;

        $list = $GLOBALS['db']->getAll($sql, true, true);

        foreach ($list as &$v) {
            $v['addtime'] = date('Y-m-d H:i', $v['addtime']);
        }
        $root['has_next'] = count($list) <= 0 ? 0 : 1;
        $root['list'] = $list;
        $root['token'] = strim($_REQUEST['token']);
        if ($page > 1) {
            ajax_return($root);
        } else {
            api_ajax_return($root);
        }
    }
}


?>