<?php

/**
 * 心愿单控制器
 * Class user_wishModule
 */
class user_wishModule extends baseModule
{

    public $time;
    public $uid;
    public $day;

    public function __construct()
    {
        if (!$GLOBALS['user_info']) {
            $res['error'] = api_lang("user_not_logged_in");
            $res['status'] = 0;
            $res['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($res);
        }
        $this->time = NOW_TIME;
        $this->day = strtotime(date('Y-m-d', $this->time));
        //$this->uid = 164743;
        $this->uid = $GLOBALS['user_info']['id'];
    }

    /**
     * 礼物列表接口
     */
    public function gift_list()
    {
        $root = array();
        $root['status'] = 1;
        $sql = "select * from " . DB_PREFIX . "prop where is_effect = 1";
        $gift = $GLOBALS['db']->getAll($sql);

        foreach ($gift as $k => &$v) {
            $v['ticket'] = intval($v['ticket']);
           // $v['icon'] = get_spec_image($v['icon'], 24, 25);
        }
        $root['list'] = $gift;

        ajax_return($root);
    }


    /**
     * 主播发布心愿
     */
    public function pub_wish()
    {

        $res['status'] = 0;
        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id ='{$GLOBALS['user_info']['id']}'");

        $g_id = get_input('g_id', 'n', 0, 'intval');        // 礼物
        $g_num = get_input('g_num', 'n', 0, 'intval');      // 礼物数量
        $txt = get_input('txt', 's', '', 'trim');           // 回报方式

        $sql = "select * from " . DB_PREFIX . "prop where id={$g_id}";
        $gift = $GLOBALS['db']->getRow($sql);
        if (empty($gift)) {
            $res['error'] = api_lang("gift_does_not_exist");
            ajax_return($res);
        }

        $wish_count = count($this->get_today_wish());
        if ($wish_count >= 3) {
            $res['error'] = api_lang("Three_wishes_day_at_most");
            ajax_return($res);
        }

        //心愿单数量限制 
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $wish_limit = intval($m_config['wish_limit']);

        if ($g_num > $wish_limit) {
            $res['error'] = api_lang("Add_quantity_cannot_exceed") . $wish_limit . api_lang("individual");
            ajax_return($res);
        }
        $sql = "insert into " . DB_PREFIX . "user_wish";
        $ins_arr = [
            'uid' => $this->uid,
            'g_id' => $g_id,
            'g_name' => $gift['name'],
            'g_icon' => $gift['icon'],
            'g_num' => $g_num,
            'txt' => $txt,
            'add_day' => $this->day,
            'add_time' => $this->time,
        ];
        $sql .= insertstr($ins_arr);
        $bool = $GLOBALS['db']->query($sql);
        if (!$bool) {
            $res['error'] = api_lang("Failure_to_make_a_wish");
            ajax_return($res);
        }
        $res['status'] = 1;
        $res['error'] = '';
        $this->pub_wish_message($user, $ins_arr);
        ajax_return($res);
    }

    /**
     * 发消息
     */
    public function pub_wish_message($user_info, $ins_arr)
    {
        // 发送心愿单消息
        $video = $GLOBALS['db']->getRow("SELECT id,group_id,prop_table,room_type FROM " . DB_PREFIX . "video where live_in=1 and user_id=" . $user_info['id']);

        $ext = array();
        $ext['type'] = 71; //0:普通消息;1:礼物;2:弹幕消息;3:主播退出;4:禁言;5:观众进入房间；6：观众退出房间；7:直播结束83中奖通知
        //消息发送者
        $sender = array();
        $sender['user_id'] = $user_info['id'];//发送人昵称
        $sender['nick_name'] = emoji_decode($user_info['nick_name']);//发送人昵称
        $sender['head_image'] = get_spec_image($user_info['head_image']);//发送人头像
        $sender['user_level'] = $user_info['user_level'];//用户等级

        $gift['name'] = $ins_arr['name'];
        $gift['icon'] = $ins_arr['icon'];
        $gift['num'] = $ins_arr['num'];
        $gift['txt'] = $ins_arr['txt'];
        $ext['room_id'] = $video['id'];//直播ID 也是room_id;只有与当前房间相同时，收到消息才响应
        $ext['sender'] = $sender;
        $ext['gift'] = $gift;

        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();


        #构造高级接口所需参数
        $msg_content = array();
        //创建array 所需元素
        $msg_content_elem = array(
            'MsgType' => 'TIMCustomElem',       //自定义类型
            'MsgContent' => array(
                'Data' => json_encode($ext),
                'Desc' => '',
            )
        );
        //将创建的元素$msg_content_elem, 加入array $msg_content
        array_push($msg_content, $msg_content_elem);
        $res = [
            'ret' => $api->group_send_group_msg2($user_info['id'], $video['group_id'], $msg_content),
            'ext' => $ext,
            'user_id' => $user_info['id'],
            'group_id' => $video['group_id'],
        ];
        return $res;
    }

    /**
     * 心愿单
     */
    public function wish_list()
    {
        if (!$GLOBALS['user_info']) {
            $res['error'] = api_lang("user_not_logged_in");
            $res['status'] = 0;
            $res['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($res);
        } else {
            $date = to_date(NOW_TIME, 'Y-m-d');
            $c_date = date('Y-m-d', NOW_TIME);
            $m = date('m', $this->time);
            $d = date('d', $this->time);

            $room_id = get_input('room_id', 'n', 0, 'intval');//直播ID
            if ($room_id) {
                $video = $GLOBALS['db']->getRow("SELECT id,user_id,group_id,prop_table,room_type FROM " . DB_PREFIX . "video where live_in=1 and id=" . $room_id);
                $uid = '';
                if ($video) {
                    $uid = $video['user_id'];
                }
            } else {
                $uid = $this->uid;
            }

            $list = $this->get_today_wish($uid);
            /*foreach ($list as &$v) {
                $v['g_now_num'] = 0;
                $sql = "select from_user_id, SUM(num) as nums from " . createPropTable() . " where prop_id='{$v['g_id']}' and to_user_id='{$uid}' and create_date = '{$c_date}' and create_time >=".$v['add_time']." group by from_user_id order by nums DESC limit 3";

                $v['top_user'] = [];
                $v['g_icon'] = get_spec_image($v['g_icon']);

                $top = $GLOBALS['db']->getAll($sql);
                if (!empty($top)) {
                    foreach ($top as $vs) {
                        $v['g_now_num'] += $vs['nums'];
                        $sql = "select nick_name, head_image from " . DB_PREFIX . "user where id ='{$vs['from_user_id']}'";
                        $u = $GLOBALS['db']->getRow($sql);
                        array_push($v['top_user'], [
                            'head_image' => get_spec_image($u['head_image']),
                            'nick_name' => $u['nick_name'],
                            'gift_num' => $vs['nums']
                        ]);
                    }
                }
                if($v['g_now_num'] > $v['g_num']){
                    $v['g_now_num'] = $v['g_num'];
                }
            }*/
            foreach ($list as &$v) {
                $v['g_now_num'] = 0;
                $sql = "select t.from_user_id,sum(t.num) as nums from  (select * from " . createPropTable() . " where  prop_id='{$v['g_id']}' and to_user_id='{$uid}' and
create_date = '{$c_date}' and create_time >= ".$v['add_time']." order by create_time asc limit ".$v['g_num']. ") as t GROUP BY from_user_id order by nums desc ";
                $v['top_user'] = [];
                $v['g_icon'] = get_spec_image($v['g_icon']);

                $top = $GLOBALS['db']->getAll($sql);

                if (count($top)>0) {
                    foreach ($top as $vs) {
                        if($v['g_now_num']<$v['g_num']){ //小于心愿单数量
                            $n = $vs['nums']>$v['g_num']?$v['g_num']:$vs['nums']; //单个人的礼物数量大于需求的数量 就显示需求的数量
                            $num = $v['g_num']-$v['g_now_num']>$n?$n:$v['g_num']-$v['g_now_num']; //需求-已送的> 用户送的，那就等用户送的数量，否则就是
                            $v['g_now_num'] += $num;
                            $u = $GLOBALS['db'] -> getRow('select nick_name, head_image from '.DB_PREFIX.'user where id = '.$vs['from_user_id']);
                            array_push($v['top_user'], [
                                'head_image' => get_spec_image($u['head_image']),
                                'nick_name' => $u['nick_name'],
                                'gift_num' => $num
                            ]);
                        }
                    }
                }

                if(count($v['top_user'])>0){
                    //二维数组排序
                    $sort = array(
                        'direction' => 'SORT_DESC', //排序顺序标志 SORT_DESC 降序；SORT_ASC 升序
                        'field'     => 'gift_num',       //排序字段
                    );
                    $arrSort = array();
                    foreach($v['top_user'] AS $uniqid => $row){
                        foreach($row AS $key=>$value){
                            $arrSort[$key][$uniqid] = $value;
                        }
                    }
                    array_multisort($arrSort[$sort['field']], constant($sort['direction']), $v['top_user']);
                }

                if(empty($v['txt'])){
                    $v['txt'] = "";
                }

            }
            $res['status'] = 1;
            $res['error'] = '';
            $res['list'] = $list;
            ajax_return($res);
        }

    }


    /**
     * 得到今日心愿单
     * @return mixed
     */
    public function get_today_wish($uid)
    {
        $sql = "select * from " . DB_PREFIX . "user_wish where uid = '{$uid}' and add_day='{$this->day}'";
        $list = $GLOBALS['db']->getAll($sql);
        return $list;
    }

    /**
     * 删除心愿单
     */
    public function del_wish()
    {
        $id = get_input('id', 'n', 0, 'intval,abs');
        $uid = $GLOBALS['user_info']['id']?$GLOBALS['user_info']['id']:$_REQUEST['uid'];

        $user = $GLOBALS['db']->getRow(' select * from '.DB_PREFIX.'user where id ='.$uid);
        $ins_arr = [];

        $ret = $this -> pub_wish_message($user, $ins_arr); //发消息

        if($ret){
            $sql = "delete from " . DB_PREFIX . "user_wish where id = '{$id}'"; //删除心愿
            $bool = $GLOBALS['db']->query($sql);
        }else{
            $bool = false;
        }

        return $bool ? y_ajax('') : n_ajax(api_lang("operation_failed"));
    }

}
