<?php

class vehicleModule extends baseModule
{

    //购买座驾
    public function index()
    {
        $root = array();
        $root['status'] = 1;

        $sql = "select n.*,r.money as coin,r.day from " . DB_PREFIX . "noble n JOIN " . DB_PREFIX . "noble_recharge r on r.nobleid = n.id where n.status=1 and n.type=1 and r.status=1  order by n.sort asc,r.sort asc";
        $noble = $GLOBALS['db']->getALL($sql);

        $root['list'] = $noble;
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['diamonds_name'] = $m_config['diamonds_name'];
        $root['consumer_price_Icon'] = $m_config['consumer_price_Icon'];
        
        api_ajax_return($root);
    }

    /**
     * 我的座驾
     * */
    public function my_car()
    {
        $root = array();
        $root['status'] = 1;
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,noble_car_id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }

        if (!$user_info) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //我的座驾
            $sql = "select id,carid,endtime from " . DB_PREFIX . "noble_car where uid=" . $user_info['id'] . "  and carid >0 and endtime > " . time();

            $car = $GLOBALS['db']->getALL($sql);

            foreach ($car as &$v) {
                $v['endtime'] = date("Y/m/d", $v['endtime']);
                $vid = $v['carid'];
                $sql = "select * from " . DB_PREFIX . "noble where status=1 and id=" . $vid;
                $car_name = $GLOBALS['db']->getRow($sql);
                $v['name'] = $car_name['name'];

                $v['img'] = $car_name['img'];
                $v['title_img'] = $car_name['title_img'];
            }
            $root['car'] = $car;
            $root['user_info'] = $user_info;
        }
        api_ajax_return($root);
    }

    /*开启和关闭座驾*/
    public function car_open_close()
    {
        $root = array('status' => 1, 'error' => api_lang("operation_was_successful"));
        $id = intval($_REQUEST['id']);

        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,noble_car_id from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }

        if (!$id) {
            $root['status'] = 0;
            $root['error'] = api_lang("parameter_error");
            ajax_return($root);
        }
        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        $user_id = $user_info['id'];
        $sql = "select id,carid,endtime from " . DB_PREFIX . "noble_car where uid=$user_id  and id=$id and endtime > " . time();

        $car = $GLOBALS['db']->getRow($sql);

        $ucarid = $user_info['noble_car_id'];

        $type = $car['carid'] == $ucarid ? '0' : $car['carid'];

        $sql = "update " . DB_PREFIX . "user set noble_car_id =" . $type . " where id =" . $user_id;

        $status = $GLOBALS['db']->query($sql);

        if (!$status) {
            $root['error'] = api_lang("Start_failure");
            $root['status'] = 0;
        } else {

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();

            //更新session
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);
            // 把用户购买的座驾存入缓存使用 key = noble_car_座驾id_用户id   $expire =redis过期时间
            $expire = $car['endtime'] - NOW_TIME;
            if($expire > 0){
                redis_set("noble_car_".$type."_".$user_id,json_encode($car),$expire);
            }

            $user_redis->update_db($user_id, $user_info);
            es_session::set("user_info", $user_info);
        }
        ajax_return($root);

    }

    public function select_coin()
    {
        $id = $_REQUEST['id'];
        $root['status'] = 1;
        $user_id = get_user_token_id(strim($_REQUEST['token']));//用户ID

        if (!$id) {
            $root['status'] = 0;
            $root['error'] = api_lang("please_log_in_again");
            ajax_return($root);
        }
        if (!$user_id) {
            $root['status'] = 0;
            $root['error'] = api_lang("please_log_in_again");
            ajax_return($root);
        }
        $sql = "select * from " . DB_PREFIX . "noble where status=1 and id=$id order by sort desc";

        $noble = $GLOBALS['db']->getRow($sql);
        if ($noble['type'] == 2) {    //守护座驾
            //获取是否是守护者
            $sql = "select * from " . DB_PREFIX . "guardian_user_old g  where status=1 and g.uid=" . $user_id . " and g.endtime >= " . time();
            $guardian_user = $GLOBALS['db']->getRow($sql);
            if (!$guardian_user) {
                $root['status'] = 0;
                $root['error'] = api_lang("no_right_to_buy_guard_car");
                ajax_return($root);
            }
        }


        $sql = "select id,nobleid from " . DB_PREFIX . "noble_recharge where status=1  and nobleid=" . $id . " order by sort asc";
        $noble_recharge = $GLOBALS['db']->getRow($sql);

        $sql = "select carid,endtime from " . DB_PREFIX . "noble_car where uid=$user_id and carid=$id and endtime > " . time();
        $car = $GLOBALS['db']->getRow($sql);

        if (!$noble_recharge) {
            $root['status'] = 0;
            $root['error'] = api_lang("no_data_available");
            ajax_return($root);
        }
        $time = '';
        $type = 0;
        if ($car) {
            $type = 1;
            $time = date("Y/m/d", $car['endtime']);
        }
        $noble_recharge['time'] = $time;
        $noble_recharge['car_type'] = $type;

        $root['list'] = $noble_recharge;

        ajax_return($root);
    }

    //购买座驾
    public function pay()
    {

        $root = array();
        $root['status'] = 1;
        $user_info = array();
        if (strim($_REQUEST['token'])) {
            $user_info = $GLOBALS['db']->getRow("select id,noble_car_id,diamonds from " . DB_PREFIX . "user where  token = '" . strim($_REQUEST['token']) . "'");
        }

        if (!$user_info) {
            $root['error'] = api_lang("please_log_in_again");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $id = intval($_REQUEST['id']);
            $user_id = $user_info['id'];

            $recharge = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "noble_recharge where status=1  and   id=" . $id);

            if (!$recharge) {
                $root['error'] = api_lang("data_error");
            } else {

                $total_diamonds = $recharge['money'];
                $total_score = $recharge['integral'];
                $carid = intval($_REQUEST['car_id']);
                $before_user_diamonds = $user_info['diamonds'];
                if ($user_info['diamonds'] >= $recharge['money']) {

                    $sql = "select id,carid,endtime from " . DB_PREFIX . "noble_car where uid=$user_id and carid=" . $carid;
                    $car = $GLOBALS['db']->getRow($sql);

                    $time = NOW_TIME + 60 * 60 * 24 * $recharge['day'];
                    //减少用户钻石
                    $sql = "update " . DB_PREFIX . "user set diamonds = diamonds - " . $total_diamonds . ", use_diamonds = use_diamonds + " . $total_diamonds . ", score = score + " . $total_score . " where id = '" . $user_id . "' and diamonds >= " . $total_diamonds;

                    $status = $GLOBALS['db']->query($sql);

                    if ($status) {
                        $sql = "insert into " . DB_PREFIX . "noble_car(uid,carid,recharge,addtime,endtime) values(" . $user_id . "," . $carid . "," . $id . "," . time() . "," . $time . ")";

                        if ($car) {
                            if ($car['endtime'] > NOW_TIME) {
                                //续费
                                $time = $car['endtime'] + 60 * 60 * 24 * $recharge['day'];
                            }
                            $sql = "update " . DB_PREFIX . "noble_car set uid =" . $user_id . ", recharge =" . $id . ", endtime =" . $time . ", addtime = " . time() . " where id = " . $car['id'];
                        }

                        $GLOBALS['db']->query($sql);
                        $noble = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "noble where id=" . $carid);
                        // 更新座驾缓存

                        $sql = "select * from " . DB_PREFIX . "noble_car where carid=" . $carid . " and endtime >=" . time() . " and uid=" . $user_id;
                        $car = $GLOBALS['db']->getRow($sql, true, true);

                        $value=array(
                            'uid'=>$user_id,
                            'carid' =>$carid,
                            'recharge' => $id,
                            'addtime' => NOW_TIME,
                            'endtime' => $time,
                        );
                        $expire = $time - NOW_TIME;
                        // 把用户购买的座驾存入缓存使用 key = noble_car_座驾id_用户id   $expire =redis过期时间
                        redis_set("noble_car_".$carid."_".$user_id,json_encode($value),$expire);
                        $log_info = $noble['name']."(".$carid.") x ".$recharge['day']." ".api_lang('day');
                        $sql = "insert into " . DB_PREFIX . "user_log(log_info,log_time,type,user_id,diamonds,prop_id,end_time) values('" . $log_info . "','" . time() . "','10','" . $user_id . "','" . $total_diamonds . "','" . $id . "','".$time."')";

                        $GLOBALS['db']->query($sql);
                        $root['noble_time'] = to_date($time, 'Y-m-d');

                        $sql = "update " . DB_PREFIX . "user set noble_car_id =" . $car['carid'] . " where id =" . $user_id;
                        $GLOBALS['db']->query($sql);


                        // 消费和收益记录表
                        add_user_consumption_log($user_id,0,$total_diamonds,api_lang('purchase').api_lang('Car')."：".$noble['name'],0,0,8);

                        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                        $user_redis = new UserRedisService();

                        //更新session
                        $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $user_id);

                        $user_redis->update_db($user_id, $user_info);
                        es_session::set("user_info", $user_info);
                        $root['error'] = api_lang("purchase_successful");

                        $content = $noble['name']."(".$carid.")";
                        add_user_records( $user_id,0,$total_diamonds,0,$before_user_diamonds,0,0,0,$content,2);

                    } else {
                        $root['status'] = 0;
                        $root['error'] = api_lang("Insufficient_amount_please_recharge");
                        ajax_return($root);
                    }

                } else {

                    $root['status'] = 0;
                    $root['error'] = api_lang("Insufficient_amount_please_recharge");
                }
            }
        }

        ajax_return($root);
    }

}