<?php

use think\Db;

class voiceModule extends baseModule
{
    /**
     * 获取管理房间信息
     * */
    public function get_manage_voice()
    {
        $root = array('status' => 0, 'error' => '', 'data' => '');
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $uid = intval($GLOBALS['user_info']['id']);//用户ID
            $room_id = intval($_REQUEST['room_id']);//房间id
            $video = Db::name("video")->where("live_in=1 and is_voice=1 and id=" . $room_id)->find();
            if (!$video) {
                $root['error'] = api_lang("Invalid_live_broadcasting_room");
                ajax_return($root);
            }
            $is_administrators = 2;
            if ($video['user_id'] != $uid) {
                // 不是房主
                // 判断当前用户是否是房主或管理员
                $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = '" . $video['user_id'] . "' and user_id = " . $uid;
                if ($GLOBALS['db']->getOne($sql) <= 0) {
                    // 也不是管理员
                    $root['error'] = api_lang("No_permission");
                    ajax_return($root);
                }
                $is_administrators = 1;
            }
            $root['status'] = 1;
            //先取出之前的麦位列表看下人数是否需要切换
            $mic_list = json_decode($video['wheat_type']);
            $data = array(
                'id'                    => $video['id'],
                'title'                 => $video['title'],
                'live_image'            => get_spec_image($video['live_image']),
                'classified_id'         => $video['classified_id'],
                'announcement'          => $video['announcement'],
                'people_count'          => count($mic_list),
                'password'              => '',
                'voice_bg'              => $video['voice_bg'],
                'is_voice'              => $video['is_voice'],
                'is_room_administrator' => $is_administrators,
            );
            $root['data'] = $data;
        }
        ajax_return($root);
    }

    /**
     * 保存房间信息
     * */
    public function save_voice()
    {
        $root = array('status' => 0, 'error' => '', 'data' => '');
        //  $GLOBALS['user_info']['id'] = 167440;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $uid = intval($GLOBALS['user_info']['id']);//用户ID
            $room_id = intval($_REQUEST['room_id']);//房间id
            $people_count = intval($_REQUEST['people_count']);//麦位人数
            $title = strim($_REQUEST['title']);// 房间标题
            $live_image = strim($_REQUEST['live_image']);// 房间封面图
            $announcement = strim($_REQUEST['announcement']);// 房间公告
            $password = strim($_REQUEST['password']);// 房间密码
            $video_classified = intval($_REQUEST['classified_id']); // 分类id

            // 此处需要处理麦位正确性
            $voice_wheat = Db::name('voice_wheat')->where("status=1 and wheat=" . $people_count)->find();
            if (!$voice_wheat) {
                $re = array("error" => api_lang("microphone_position_error"), "status" => 0);
                ajax_return($re);
            }
            $video = Db::name("video")->where("live_in=1 and is_voice=1 and id=" . $room_id)->find();
            if (!$video) {
                $root['error'] = api_lang("Invalid_live_broadcasting_room");
                ajax_return($root);
            }
            if ($video['user_id'] != $uid) {
                // 不是房主
                // 判断当前用户是否是房主或管理员
                $user_admin = Db::name("user_admin")->where(" podcast_id = " . $video['user_id'] . " and user_id =" . $uid)->find();
                if (!$user_admin) {
                    // 也不是管理员
                    $root['error'] = api_lang("No_permission");
                    ajax_return($root);
                }
            }
            $save = [];
            if (!empty($password)) {
                $save['password'] = strtoupper(md5($password));
                $save['password_text'] = $password;
            }
            if (!empty($title)) {
                $save['title'] = $title;
            }
            if ($video_classified) {
                $save['classified_id'] = $video_classified;
            }

            if (!empty($live_image)) {
                $save['live_image'] = $live_image;
            }
            if (!empty($announcement)) {
                $save['announcement'] = $announcement;
            }
            if ($people_count) {
                $voice_wheat = db::name("voice_wheat")->where("status", 1)->where("wheat", $people_count)->find();
                if (!$voice_wheat) {
                    $root['error'] = api_lang('Parameter_error');
                    ajax_return($root);
                }
            }

            //先取出之前的麦位列表看下人数是否需要切换
            $mic_list = json_decode($video['wheat_type']);
            $mic_list_count = count($mic_list); // 获取变更之前麦位数量
            if ($people_count && $people_count != $mic_list_count) {
                if ($mic_list_count > $people_count) {
                    // 减少多余的麦位
                    //如果是从多切换到少，要判断麦位是否有人，如果有人则不能切换
                    $even_wheat = get_voice_even_wheat_log_list($room_id, 1);
                    foreach ($even_wheat as $value) {
                        //判断数组even_wheat中的location有12到20的话，不能切换
                        if ($value['location'] > $people_count) {
                            $root['status'] = 0;
                            //提示几麦位有人，无法切换
                            $root['error'] = 'There are users in the ' . $value['location'] . ' location, unable to switch';
                            ajax_return($root);
                        }
                    }
                    //保留麦位，其余的麦位删除
                    $mic_list = array_slice($mic_list, 0, $people_count);
                } else {
                    // 增加麦位 更新到video表中 获取需要增加多少麦位数量
                    $people_count_add = $people_count - $mic_list_count;
                    for ($i = 1; $i <= $people_count_add; $i++) {
                        $mic_list[] = array(
                            'wheat_id'   => $i + $mic_list_count,
                            'wheat_name' => $i + $mic_list_count,
                            'type'       => 0,
                        );
                    }
                }
                $mic_list = json_encode($mic_list);
                $save['wheat_type'] = $mic_list;
            }
            $update = false;
            if (count($save)) {
                $update = Db::name('video')->where('id', $room_id)->update($save);
            }
            if (!$update) {
                $root['error'] = api_lang('Operation_failed');
                ajax_return($root);
            }
            //更新redis
            sync_video_to_redis($room_id, '*', false);

            $broadMsg['type'] = 303;
            $broadMsg['data'] = json_decode($mic_list);
            #构造rest API请求包
            $msg_content = array();
            //创建$msg_content 所需元素
            $msg_content_elem = array(
                'MsgType'    => 'TIMCustomElem',       //定义类型为普通文本型
                'MsgContent' => array(
                    'Data' => json_encode($broadMsg)    //转为JSON字符串
                )
            );

            //将创建的元素$msg_content_elem, 加入array $msg_content
            array_push($msg_content, $msg_content_elem);
            bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
            $api = createTimAPI();
            $m_config = load_auto_cache("m_config");
            $ret = $api->group_send_group_msg2($m_config['tim_identifier'], $video['group_id'], $msg_content);
            // 更新麦位上用户信息
            im_wheat_position_upd($video['id']);
            $root['status'] = 1;
            $root['error'] = api_lang('Saved_successfully');
        }
        ajax_return($root);
    }

    /**
     * 房间流水
     * */
    public function get_room_flow()
    {
        $root = array('status' => 0, 'error' => '', 'data' => '');

        $room_id = intval($_REQUEST['room_id']);//房间id
        $token = strim($_REQUEST['token']);// token
        $user_info = Db::name('user')->where("token='" . $token . "'")->find();
        if (!$user_info) {
            $root['status'] = 0;
            $root['error'] = api_lang("user_not_logged_in");
            api_ajax_return($root);
        }
        $uid = $user_info['id'];
        $video = Db::name("video")->where("live_in=1 and is_voice=1 and id=" . $room_id)->find();
        if (!$video) {
            $root['error'] = api_lang("Invalid_live_broadcasting_room");
            ajax_return($root);
        }
        if ($video['user_id'] != $uid) {
            // 不是房主
            // 判断当前用户是否是房主或管理员
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $video['user_id'] . " and user_id =" . $uid)->find();
            if (!$user_admin) {
                // 也不是管理员
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
        }
        $month = 0;
        $last_month = 0;
        $yesterday = 0;
        $today = 0;
        $time = NOW_TIME;
        // 昨日日期
        $yesDate = strtotime('-1 day');
        // 当前月
        $outside = 'video_prop_' . to_date($time, 'Ym');
        $table = DB_PREFIX . $outside;
        $res = $GLOBALS['db']->getRow("SHOW TABLES LIKE'$table'");
        if ($res) {
            $month = Db::name($outside)->where("create_ym", to_date($time, 'Ym'))->where("video_id", $room_id)->sum("total_diamonds");
            $today = Db::name($outside)->where("create_ym", to_date($time, 'Ym'))->where("create_d", to_date($time, 'd'))->where("video_id", $room_id)->sum("total_diamonds");
            if (to_date($time, 'Ym') == to_date($yesDate, 'Ym')) {
                // 昨日
                $yesterday = Db::name($outside)->where("create_ym", to_date($time, 'Ym'))->where("create_d", to_date($yesDate, 'd'))->where("video_id", $room_id)->sum("total_diamonds");
            }
        }
        // 上月
        $lastMonth = strtotime("-1 month");
        $last_outside = 'video_prop_' . to_date($lastMonth, 'Ym');
        $last_table = DB_PREFIX . $last_outside;
        $last_res = $GLOBALS['db']->getRow("SHOW TABLES LIKE'$last_table'");
        if ($last_res) {
            $month = Db::name($last_outside)->where("create_ym", to_date($lastMonth, 'Ym'))->where("video_id", $room_id)->sum("total_diamonds");
            if (to_date($lastMonth, 'Ym') == to_date($yesDate, 'Ym')) {
                // 昨日
                $yesterday = Db::name($last_outside)->where("create_ym", to_date($lastMonth, 'Ym'))->where("create_d", to_date($yesDate, 'd'))->where("video_id", $room_id)->sum("total_diamonds");
            }
        }
        $root['data'] = array(
            'room_img'   => $video['live_image'],
            'room_title' => $video['title'],
            'room_id'    => $video['id'],
            'month'      => $month,
            'last_month' => $last_month,
            'yesterday'  => $yesterday,
            'today'      => $today,
        );
        $root['status'] = 1;
        $root['error'] = api_lang('Saved_successfully');
        ajax_return($root);
    }

    /**
     * 语音直播时长 当他上麦并开始说话，会记录他的语音直播时长
     * 前端的三方回调后请求--1分钟请求一次
     */
    public function voice_duration()
    {
        $root = array('status' => 1, 'error' => '', 'data' => '');
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $uid = intval($GLOBALS['user_info']['id']);//用户ID--房主id
            $room_id = intval($_REQUEST['room_id']);//房间号id
            $sum = intval($_REQUEST['voice_duration']); // 语音时长秒
            $video = Db::name("video")->where("user_id=" . $uid . " and live_in=1 and is_voice=1 and id=" . $room_id)->find();
            if ($video) {
                // 获取时间 数组格式
                $date = get_date_time(NOW_TIME);
                // 是房主本人，增加时长
                insert_duration($date, $uid, 2, $sum);
            } else {
                //   $root['error']= api_lang('Not_owner_himself');
            }
        }
        ajax_return($root);
    }

    /**
     * 检查有没有创建房间，如果有的话返回进入房间的那些信息
     */
    public function check_has_voice_room()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $where = "user_id=" . $user_id . " and live_in=1";
            $sql = "select * from " . DB_PREFIX . "video where " . $where;
            $video = $GLOBALS['db']->getRow($sql);
            $root['status'] = 1;
            $data = array(
                'status' => 0,
            );
            $data['room_info'] = '';
            if ($video) {
                $data['status'] = 1;
                //房间号id; 如果有的话，则返回当前房间信息;
                //$root = get_voice_info($video['id'], $user_id);
//                if ($root['status'] == 1) {
//                    $data['room_info'] = $root;
//                }
                $video['room_id'] = $video['id'];
                $data['room_info'] = $video;
            }
            $root['data'] = $data;
        }
        ajax_return($root);
    }

    /* 获取房间背景图片 */
    public function get_voice_bg_list()
    {
        $root = array('status' => 1, 'error' => '', 'data' => array());
        $voice_bg = Db::name('voice_bg')->where("status=1")->order("sort DESC")->select();
        $root['data'] = $voice_bg;

        ajax_return($root);
    }

    //修改房间麦位人数
    public function change_room_mic_people()
    {
        $root = array('status' => 0, 'error' => '', 'data' => '');

        $room_id = intval($_REQUEST['room_id']);//房间号id
        $people_count = intval($_REQUEST['people_count']);//麦位人数
        $user_id = $GLOBALS['user_info']['id'];//用户ID

        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }

        // 此处需要处理麦位正确性
        $voice_wheat = Db::name('voice_wheat')->where("status=1 and wheat=" . $people_count)->find();
        if (!$voice_wheat) {
            $re = array("error" => api_lang("microphone_position_error"), "status" => 0);
            ajax_return($re);
        }

        // 获取房间信息
        $video = Db::name("video")->where("id=" . $room_id)->find();

        if (!$video || $video['live_in'] != 1) {
            $root['error'] = api_lang('Room_closed');
            ajax_return($root);
        }

        if ($user_id != $video['user_id']) {
            //是否有管理员权限
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $video['user_id'] . " and user_id =" . $user_id)->find();
            if (!$user_admin) {
                //没有有管理员权限
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
        }
        //先取出之前的麦位列表看下人数是否需要切换
        $mic_list = json_decode($video['wheat_type']);
        $mic_list_count = count($mic_list); // 获取变更之前麦位数量
        if ($mic_list_count == $people_count) {
            $root['status'] = 1;
            ajax_return($root);
        }
        if ($mic_list_count > $people_count) {
            // 减少多余的麦位
            //如果是从多切换到少，要判断麦位是否有人，如果有人则不能切换
            $even_wheat = get_voice_even_wheat_log_list($room_id, 1);
            foreach ($even_wheat as $value) {
                //判断数组even_wheat中的location有12到20的话，不能切换
                if ($value['location'] > $people_count) {
                    $root['status'] = 0;
                    //提示几麦位有人，无法切换
                    $root['error'] = 'There are users in the ' . $value['location'] . ' location, unable to switch';
                    ajax_return($root);
                }
            }
            //保留麦位，其余的麦位删除
            $mic_list = array_slice($mic_list, 0, $people_count);
        } else {
            // 增加麦位 更新到video表中 获取需要增加多少麦位数量
            $people_count_add = $people_count - $mic_list_count;
            for ($i = 1; $i <= $people_count_add; $i++) {
                $mic_list[] = array(
                    'wheat_id'   => $i + $mic_list_count,
                    'wheat_name' => $i + $mic_list_count,
                    'type'       => 0,
                );
            }
        }
        $mic_list = json_encode($mic_list);
        $update = Db::name('video')->where('id', $room_id)->update(['wheat_type' => $mic_list]);
        if (!$update) {
            $root['error'] = api_lang('Operation_failed');
            ajax_return($root);
        }
        //更新redis
        sync_video_to_redis($room_id, '*', false);

        $broadMsg['type'] = 303;
        $broadMsg['data'] = json_decode($mic_list);
        #构造rest API请求包
        $msg_content = array();
        //创建$msg_content 所需元素
        $msg_content_elem = array(
            'MsgType'    => 'TIMCustomElem',       //定义类型为普通文本型
            'MsgContent' => array(
                'Data' => json_encode($broadMsg)    //转为JSON字符串
            )
        );

        //将创建的元素$msg_content_elem, 加入array $msg_content
        array_push($msg_content, $msg_content_elem);
        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();
        $m_config = load_auto_cache("m_config");
        $ret = $api->group_send_group_msg2($m_config['tim_identifier'], $video['group_id'], $msg_content);
        // 更新麦位上用户信息
        im_wheat_position_upd($video['id']);

        $root['status'] = 1;
        ajax_return($root);
    }


    // 选中房间背景图片
    public function selected_voice_bg()
    {
        $root = array('status' => 0, 'error' => '', 'data' => '');

        $room_id = intval($_REQUEST['room_id']);//房间号id
        $voice_bg = intval($_REQUEST['voice_bg']); // 背景图id

        $user_id = $GLOBALS['user_info']['id'];//用户ID

        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }

        // 查看是否有背景图id
        $voice_type_id = Db::name('voice_bg')->where("status=1 and id=" . $voice_bg)->find();
        if (!$voice_type_id) {
            $root['error'] = api_lang('Please_select_room_background');
            ajax_return($root);
        }

        // 获取房间信息
        $video = Db::name("video")->where("id=" . $room_id)->find();

        if (!$video || $video['live_in'] != 1) {
            $root['error'] = api_lang('Room_closed');
            ajax_return($root);
        }

        if ($user_id != $video['user_id']) {
            //是否有管理员权限
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $video['user_id'] . " and user_id =" . $user_id)->find();
            if (!$user_admin) {
                //没有有管理员权限
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
        }

        //修改 房间类型
        if ($video['voice_bg'] != $voice_bg) {
            $roomInfo = array('voice_bg' => $voice_bg);
            $voice_status = Db::name("video")->where("id=" . $room_id)->update($roomInfo);
            if (!$voice_status) {
                $root['msg'] = api_lang('Modification_failed');
                ajax_return($root);
            }
            sync_video_to_redis($room_id, '*', false);
            //发送im
            $this->send_im_voice(['voice_bg_image' => $voice_type_id['image'], 'group_id' => $video['group_id']]);
        }

        $root['status'] = 1;
        ajax_return($root);
    }

    /**
     * 修改房内信息发送im消息
     * @param $voice
     */
    public function send_im_voice($voice)
    {
        $broadMsg['type'] = 302;
        $broadMsg['voice'] = array(
            'voice_bg_image' => $voice['voice_bg_image'] // 房间背景图片
        );
        #构造rest API请求包
        $msg_content = array();
        //创建$msg_content 所需元素
        $msg_content_elem = array(
            'MsgType'    => 'TIMCustomElem',       //定义类型为普通文本型
            'MsgContent' => array(
                'Data' => json_encode($broadMsg)    //转为JSON字符串
            )
        );

        //将创建的元素$msg_content_elem, 加入array $msg_content
        array_push($msg_content, $msg_content_elem);
        bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
        $api = createTimAPI();
        $m_config = load_auto_cache("m_config");
        $ret = $api->group_send_group_msg2($m_config['tim_identifier'], $voice['group_id'], $msg_content);
    }

    /**
     * 获取开房间时--上次开房间的房间封面图
     */
    public function get_video_cover_image()
    {
        $root = array('status' => 1, 'error' => '', 'data' => array());
        $uid = intval($GLOBALS['user_info']['id']) ? intval($GLOBALS['user_info']['id']) : '';
        if (!$uid) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;
            ajax_return($root);
        }
        $is_voice = intval($_REQUEST['is_voice']); // 0直播间 1语音房间
        // 获取上次开直播时的直播封面图
        $video = Db::name("video")->where("user_id=" . $uid . " and is_voice=" . $is_voice)->order("end_time desc")->find();
        if ($video) {
            $data['live_image'] = get_spec_image($video['live_image']);
        } else {
            $video_history = Db::name("video_history")->where("user_id=" . $uid . " and is_voice=" . $is_voice . " and live_image !=''")->order("end_time desc")->find();
            $data['live_image'] = $video_history ? get_spec_image($video_history['live_image']) : '';
        }

        $root['data'] = $data;
        ajax_return($root);
    }

    /**
     * 获取语音房间状态
     */
    public function voice_status()
    {
        $root = array();
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $room_id = intval($_REQUEST['room_id']);//房间号id
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $where = "id=" . $room_id . " and live_in=1 and is_voice=1";
            $video = Db::name("video")->where($where)->find();
            $root['status'] = 1;
            $data = array(
                'status' => 0,
            );
            if ($video) {
                $data['status'] = 1;
                //房间号id; 如果有的话，则返回当前房间信息;
                $room_id = intval($_REQUEST['room_id']);
                //初始化手机端配置
                $m_config = load_auto_cache("m_config");
                //是否被踢出房间
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
                $video_private_redis = new VideoPrivateRedisService();
                $times = $video_private_redis->check_ordinary_user_drop($room_id, $user_id);
                if ($times) {
                    $times = intval($times) + $m_config['kicking_time'];
                    if ($times > NOW_TIME) {
                        $root['error'] = api_lang("You_have_been_kicked_out");
                        $root['status'] = 0;
                        ajax_return($root);
                    }
                }

                $root = get_voice_info($room_id, $user_id);
                if ($root['status'] != 1) {
                    ajax_return($root);
                }
                $data['room_info'] = $root;
            }
            $root['data'] = $data;
        }
        ajax_return($root);
    }

    /**
     * 获取房间公告
     */
    public function get_notice()
    {
        $root = array('status' => 1, 'error' => '', 'data' => array());
        $this->checkUserLogin();
        $room_id = intval($_REQUEST['room_id']);//房间号id
        $where = "id=" . $room_id;
        $video = Db::name("video")->field("announcement")->where($where)->find();
        $root['data'] = array(
            'announcement' => $video ? $video['announcement'] : ''
        );
        ajax_return($root);
    }

    /**
     * 修改房间公告
     */
    public function save_notice()
    {
        $root = array('status' => 0, 'error' => api_lang("Modification_failed"), 'data' => array());
        $this->checkUserLogin();
        $user_id = intval($GLOBALS['user_info']['id']);
        $room_id = intval($_REQUEST['room_id']);//房间号id
        $announcement = strim($_REQUEST['announcement']);
        $where = "id=" . $room_id . " and user_id=" . $user_id;
        $status = Db::name("video")->where($where)->update(['announcement' => $announcement]);
        if ($status) {
            $root['status'] = 1;
            $root['error'] = api_lang("Modification_succeeded");
        }
        ajax_return($root);
    }

    /**
     * 开启语音房间
     */
    public function add_voice()
    {
        $this->checkUserLogin();
        //用户是否禁播，$is_ban=1 永久禁播；$is_ban=0非永久禁播，$ban_time禁播结束时间
        $user_id = intval($GLOBALS['user_info']['id']);
        $user = Db::name("user")->field("is_authentication,is_ban,ban_time,mobile,login_ip,ban_type,apns_code,sex,ticket,refund_ticket,user_level,fans_count,head_image,thumb_head_image,family_id")->where("id=" . $user_id)->find();

        $video_classified = intval($_REQUEST['video_classified']); // 分类id
        $is_authentication = intval($user['is_authentication']); // 是否认证
        $announcement = strim($_REQUEST['announcement']);
        $voice_bg = intval($_REQUEST['voice_bg']); // 房间背景id
        $people_count = intval($_REQUEST['people_count']); // 房间人数:现可选值11(所谓10人位其实是11人),20
        $m_config = load_auto_cache("m_config");
        $is_limitation= false;
        $error='';
        switch ($m_config['voice_streaming_activation_conditions']){
            case 1:
                if (intval($m_config['voice_level_lv']) > intval($user['user_level'])) {
                    // 开直播必须等级达到后才能直播
                    $str = api_lang("voice_streaming_reaching_level");
                    $str = str_replace("{level}", $m_config['voice_level_lv'], $str);
                    $is_limitation= true;
                    $error = $str;
                }
                break;
            case 2:
                if(!$user['family_id']){
                    $str = api_lang("join_family_start_voice_stream");
                    $is_limitation= true;
                    $error = $str;
                }
                break;
            case 3:
                if (intval($m_config['voice_level_lv']) > intval($user['user_level']) && !$user['family_id']) {
                    // 开直播必须等级达到后才能直播
                    $str = api_lang("reaching_level_or_joining_family_voice");
                    $str = str_replace("{level}", $m_config['voice_level_lv'], $str);
                    $is_limitation= true;
                    $error = $str;
                }
                break;
            default:
        }
        if($is_limitation){
            $re = array("error" => $error, "status" => 0);
            ajax_return($re);
        }
        // 此处需要处理麦位正确性
        $voice_wheat = Db::name('voice_wheat')->where("status=1 and wheat=" . $people_count)->find();
        if (!$voice_wheat) {
            $re = array("error" => api_lang("microphone_position_error"), "status" => 0);
            ajax_return($re);
        }

        if ($user['sex'] != 2 && $user['user_level'] < $m_config['Male_live_rating']) {
            // 男性用户限制等级
            $re = array("error" => api_lang("voice_room_must_reach_level") . $m_config['Male_live_rating'], "status" => 0);
            ajax_return($re);
        }
        if ($m_config['must_authentication'] == 1 && $is_authentication != 2) {
            $re = array("error" => api_lang("Live_broadcast_after_certification"), "status" => 0);
            ajax_return($re);
        }
        if ($voice_bg) {
            $voice_bg_info = Db::name('voice_bg')->where("status=1 and id=" . $voice_bg)->find();;
            if (!$voice_bg || !$voice_bg_info) {
                $result['status'] = 0;
                $result['error'] = api_lang('Please_select_room_background');
                ajax_return($result);
            }
        }
        if (Db::name("ban_list")->field("ban_ip")->where("ban_type=1 and ban_ip='" . $user['login_ip'] . "'")->find()) {
            $re = array("error" => api_lang("Failed_to_request_room_ID"), "status" => 0);
            ajax_return($re);
        }
        $video_insert = Db::name("video")->where("user_id=" . $user_id . " and is_voice=1 and live_in=1")->find();
        if ($video_insert) {
            $re = array("error" => api_lang("Voice_room_already_exists_cannot_create"), "status" => 0);
            ajax_return($re);
        }
        $video_insert_one = Db::name("video")->where("user_id=" . $user_id . " and is_voice=0 and live_in=1")->find();
        if ($video_insert_one) {
            $re = array("error" => api_lang("Turn_off_room_and_turn_on_voice"), "status" => 0);
            ajax_return($re);
        }

        if (Db::name("ban_list")->field("apns_code")->where("ban_type=2 and apns_code='" . $user['apns_code'] . "'")->find()) {
            $re = array("error" => api_lang("current_device_is_disabled"), "status" => 0);
            ajax_return($re);
        }

        if (intval($user['is_ban']) == 0 && intval($user['ban_time']) < get_gmtime()) {
            $title = strim(str_replace('#', '', $_REQUEST['title']));
            //是否是密码房间 密码
            $password = strim($_REQUEST['password']);
            $video_id = get_max_room_id(0);
            $data = array();
            if (!empty($password)) {
                $data['password'] = strtoupper(md5($password));
                $data['password_text'] = $password;
            }
            $data['id'] = $video_id;
            $data['room_type'] = 3; //room_type 房间类型 : 1私有群（Private）,0公开群（Public）,2聊天室（ChatRoom）,3互动直播聊天室（AVChatRoom）
            $data['voice_bg'] = $voice_bg; // 背景图片id
            // 获取上次开直播时的直播封面图
            $video_history = Db::name("video_history")->where("user_id=" . $user_id . " and is_voice=1 and live_image !=''")->order("end_time desc")->find();
            $data['live_image'] = $video_history ? $video_history['live_image'] : $user['head_image'];
            //图片,应该从客户端上传过来,如果没上传图片再用会员头像 -- 图片地址,手机端图片先上传到oss，然后获得图片地址,再跟其它资料一起提交到服务器
            $live_image = strim($_REQUEST['live_image']);
            if ($live_image != '' && $live_image != './(null)') {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/core/transport.php');
                $trans = new transport();
                $req = $trans->request(get_spec_image($live_image), '', 'GET');
                if (strlen($req['body']) > 1000) {
                    $data['live_image'] = $live_image;
                }
            }

            $data['head_image'] = $user['head_image'];
            $data['thumb_head_image'] = $user['thumb_head_image'];

            //性别 0:未知, 1-男，2-女
            $data['sex'] = intval($user['sex']);

            //0:腾讯云互动直播;1:腾讯云直播
            $data['video_type'] = intval($m_config['video_type']);

            if ($data['video_type'] > 0) {
                require_once(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();
                $ret = $api->group_create_group('AVChatRoom', (string)$user_id, (string)$user_id, (string)$video_id);
                if ($ret['ActionStatus'] != 'OK') {
                    ajax_return(array(
                        'status' => 0,
                        'error'  => $ret['ErrorCode'] . $ret['ErrorInfo']
                    ));
                }
                $data['group_id'] = $ret['GroupId'];
                bogo_require(APP_ROOT_PATH . 'mapi/lib/core/video_factory.php');
                $video_factory = new VideoFactory();
                $channel_info = $video_factory->Create($video_id, 'mp4', $user_id);
                if (!empty($channel_info['video_type'])) {
                    $data['video_type'] = $channel_info['video_type'];
                }
                $data['channelid'] = $channel_info['channel_id'];
                $data['push_rtmp'] = $channel_info['upstream_address'];
                $data['play_flv'] = $channel_info['downstream_address']['flv'];
                $data['play_rtmp'] = $channel_info['downstream_address']['rtmp'];
                $data['play_hls'] = $channel_info['downstream_address']['hls'];
                $return['push_rtmp'] = $channel_info['upstream_address'];
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
                $video_redis = new VideoRedisService();
                $video_redis->video_online($video_id, $data['group_id']);
            }
            //video_type=1;1:腾讯云直播播放地址(rmtp,flv)
            $data['play_url'] = '';
            $data['title'] = $title;
            $data['user_id'] = $user_id;
            //live_in:是否直播中 1-直播中 0-已停止;2:正在创建直播;
            $data['live_in'] = 1;
            $data['watch_number'] = '';//'当前观看人数';
            $data['vote_number'] = '';//'获得票数';
            $data['announcement'] = $announcement;//语音房间公告;

            $data['create_time'] = NOW_TIME;//'创建时间';
            $data['begin_time'] = NOW_TIME;//'开始时间';
            $data['end_time'] = '';//'结束时间';
            $data['online_status'] = 1;//主播在线状态;1:在线(默认); 0:离开
            //sort_init(初始排序权重) = (用户可提现印票：bogo_user.ticket - bogo_user.refund_ticket) * 保留印票权重+ 直播/回看[回看是：0; 直播：9000000000 直播,需要排在最上面 ]+ bogo_user.user_level * 等级权重+ bogo_user.fans_count * 当前有的关注数权重
            $sort_init = (intval($user['ticket']) - intval($user['refund_ticket'])) * floatval($m_config['ticke_weight']);
            $sort_init += intval($user['user_level']) * floatval($m_config['level_weight']);
            $sort_init += intval($user['fans_count']) * floatval($m_config['focus_weight']);

            $data['sort_init'] = 200000000 + $sort_init;
            $data['sort_num'] = $data['sort_init'];

            // 1、创建视频时检查表是否存在，如不存在创建礼物表，表命名格式 bogo_ video_ prop_201611、格式同bogo_ video_ prop相同
            // 2、将礼物表名称写入bogo_video 中，需新建字段
            // 3、记录礼物发送时候读取bogo_video 的礼物表名，写入对应的礼物表
            // 4、修改所有读取礼物表的地方，匹配数据
            $data['prop_table'] = createPropTable();
            //直播分类
            $data['classified_id'] = $video_classified;

            $data['push_type'] = 1; //1手机摄像头(视频)直播 2外设直播
            $data['is_voice'] = 1; // 语音房间

            $wheat_type = array();
            for ($i = 1; $i <= $people_count; $i++) {
                $wheat_type[] = array(
                    'wheat_id'   => $i,
                    'wheat_name' => $i,
                    'type'       => 0,
                );
            }
            $data['wheat_type'] = json_encode($wheat_type);

            $video_insert = Db::name("video")->insert($data);
            if ($video_insert) {
                $return['status'] = 1;
                $return['error'] = '';
                $return['room_id'] = $video_id;
                $return['video_type'] = intval($data['video_type']);

                sync_video_to_redis($video_id, '*', false);
            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("Failed_to_create_room");
            }
        } else {
            if (intval($user['is_ban'] && intval($user['ban_type'] == 0))) {
                $return['status'] = 0;
                $return['error'] = api_lang("You_are_banned");
            } elseif (intval($user['is_ban'] && intval($user['ban_type'] == 1))) {
                $return['status'] = 0;
                $return['error'] = api_lang("Failed_to_request_room_ID");
            } elseif (intval($user['is_ban'] && intval($user['ban_type'] == 2))) {
                $return['status'] = 0;
                $return['error'] = api_lang("current_device_is_disabled");
            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("title_can_be_broadcast_for_time_being") . '：' . to_date(intval($user['ban_time']), 'Y-m-d H:i:s') . '。';
            }

        }

        if ($m_config['must_authentication'] == 1) {
            if ($is_authentication != 2) {
                $return['room_id'] = 0;
            }
        }
        //-------------------------------------
        //sdk_type 0:使用腾讯SDK、1：使用金山SDK
        //映射关系类型  腾讯云直播, 金山云，星域，  云 ，阿里云cont
        //video_type     1  		2		 3		4		5
        //sdk_type       0			1		 -		-		-
        $return['sdk_type'] = get_sdk_info($m_config['video_type']);

        ajax_return($return);
    }

    /**
     * 退出语音房间
     */
    public function end_voice()
    {
        $root = array('status' => 0, 'error' => '');
        $this->checkUserLogin();
        $user_id = intval($GLOBALS['user_info']['id']);
        $room_id = intval($_REQUEST['room_id']);//房间号id

        $video = Db::name("video")->where("id=" . $room_id)->find();
        if ($video) {
            do_end_voice($video, $user_id);
        }
        rm_auto_cache("select_video");
        $root['status'] = 1;
        $root['error'] = api_lang("Exit_succeeded_1");
        ajax_return($root);
    }

    /**
     * 获取结束信息
     */
    public function voice_end_message()
    {
        $root = array('status' => 0, 'error' => api_lang("No_permission"), 'data' => '');
        $this->checkUserLogin();
        $user_id = intval($GLOBALS['user_info']['id']);
        $room_id = intval($_REQUEST['room_id']);//房间号id
        $video = Db::name("video")->where("id=" . $room_id)->find();
        $root['data'] = '';
        if ($video) {
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/BaseRedisService.php');
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            // 用户信息
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
            $user_redis = new UserRedisService();
            $user_info = $user_redis->getRow_db($user_id, ['nick_name', 'head_image']);//用户信息

            $vote_number = intval($video['vote_number']) + intval($video_redis->getOne_db($video['id'], 'game_vote_number'));//获得印票
            $time_len = NOW_TIME - $video['begin_time'];//私有聊天或小于5分钟的视频，不保存

            $time = $time_len > 0 ? gmdate('H:i:s', $time_len) : '00:00:00';

            $root['data'] = array(
                'vote_number' => $vote_number,
                'time_len'    => $time,
                'nick_name'   => emoji_decode($user_info['nick_name']),
                'head_image'  => get_spec_image($user_info['head_image'])
            );
        } else {
            ajax_return($root);
        }

        $root['status'] = 1;
        $root['error'] = '';
        ajax_return($root);
    }

    /**
     * 关闭语音房间 --- 删除房间
     */
    public function close_voice()
    {
        $root = array('status' => 0, 'error' => api_lang("No_permission"));
        $this->checkUserLogin();
        $user_id = intval($GLOBALS['user_info']['id']);
        $room_id = strim($_REQUEST['room_id']);//房间号id

        $video = Db::name("video")->where("id=" . $room_id)->find();
        do_close_voice($video, $user_id);
        rm_auto_cache("select_video");
        $root['status'] = 1;
        $root['error'] = api_lang("Exit_succeeded_1");
        ajax_return($root);
    }

    /**
     * 获取语音房间信息
     */
    public function get_voice()
    {
        $root = array();

        $is_refresh = get_input('is_refresh', 'n', 0, 'intval,abs');

        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            //房间号id; 如果有的话，则返回当前房间信息;
            $room_id = intval($_REQUEST['room_id']);

            //初始化手机端配置
            $m_config = load_auto_cache("m_config");
            //是否被踢出房间
            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
            $video_private_redis = new VideoPrivateRedisService();
            $times = $video_private_redis->check_ordinary_user_drop($room_id, $user_id);
            if ($times) {
                $times = intval($times) + $m_config['kicking_time'];
                if ($times > NOW_TIME) {
                    $root['error'] = api_lang("You_have_been_kicked_out");
                    $root['status'] = 0;
                    ajax_return($root);
                }
            }

            //强制升级不升级无法查看直播
            $forced_upgrade = 1;
            if (intval($m_config['forced_upgrade'])) {
                $root = $this->compel_upgrade($m_config);
                $forced_upgrade = $root['status'];
            }

            if ($forced_upgrade == 1) {
                $root = get_voice_info($room_id, $user_id, $is_refresh);
            }
            if ($root['status'] != 1) {
                ajax_return($root);
            }

            $root['is_refresh'] = $is_refresh;
        }

        ajax_return($root);
    }

    /**
     * 强制升级不升级无法查看直播
     * @param $m_config
     * @return array
     */
    public function compel_upgrade($m_config)
    {
        $root = array('status' => 1, 'error' => '');
        $dev_type = strim($_REQUEST['sdk_type']);
        $version = strim($_REQUEST['sdk_version']);//升级版本号yyyymmddnn： 2017031502
        if ($dev_type == 'android') {
            //  $root['serverVersion'] = $m_config['android_version'];//android版本号
            $sql = "select * from " . DB_PREFIX . "version_log where type =2  and is_release=1 and is_update=1 order by version_number desc";
            $version_log = $GLOBALS['db']->getROW($sql, true, true);

            $root['serverVersion'] = $version_log ? $version_log['version_number'] : '';//android版本号
            //print_r($m_config);
            if ($root['serverVersion'] != '' && $version < $root['serverVersion']) {
                $root['status'] = 0;
                $root['filename'] = $version_log['url'];//android下载包名
                $root['android_upgrade'] = $version_log['content'];//android版本升级内容

                $root['forced_upgrade'] = 1;//强制升级
                $root['hasfile'] = 1;
                $root['has_upgrade'] = 1;//1:可升级;0:不可升级
                $root['error'] = $m_config['forced_upgrade_tips'];//强制升级提醒
            } else {
                $root['hasfile'] = 0;
                $root['has_upgrade'] = 0;//1:可升级;0:不可升级
            }
        } else if ($dev_type == 'ios') {
            //  $root['serverVersion'] = $m_config['ios_version'];//IOS版本号
            $sql = "select * from " . DB_PREFIX . "version_log where type =1  and is_release=1 and is_update=1 order by version_number desc";
            $version_log = $GLOBALS['db']->getROW($sql, true, true);
            $root['serverVersion'] = $version_log ? $version_log['version_number'] : '';
            if ($root['serverVersion'] != '' && $version < $root['serverVersion']) {
                $root['status'] = 0;
                $root['ios_down_url'] = $version_log['url'];//ios下载地址
                $root['ios_upgrade'] = $version_log['content'];//ios版本升级内容
                $root['has_upgrade'] = 1;//1:可升级;0:不可升级
                $root['forced_upgrade'] = 1;//0:非强制升级;1:强制升级
                $root['error'] = $m_config['forced_upgrade_tips'];//强制升级提醒
            } else {
                $root['has_upgrade'] = 0;//1:可升级;0:不可升级
            }
        } else {
            $root['hasfile'] = 0;
            $root['has_upgrade'] = 0;//1:可升级;0:不可升级
        }
        return $root;
    }

    /**
     * 管理员获取麦位列表
     */
    public function get_wheat_list()
    {
        $root = array('status' => 0, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        // 房间id
        $video_id = intval($_REQUEST['room_id']);
        $type = intval($_REQUEST['type']); // 0申请 1 上麦的
        // 查询语音房间
        $voice = Db::name("video")->where("id=" . $video_id . " and is_voice=1")->find();
        if ($voice['user_id'] != $user_id) {
            //判断是否管理员
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $voice['user_id'] . " and user_id =" . $user_id)->find();
            if (!$user_admin) {
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
        }
        //获取上麦人列表
        $even_wheat = get_voice_even_wheat_log_list($video_id, $type);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        // 处理麦位上信息

        foreach ($even_wheat as &$v) {
            // 查询用户已禁言
            $kick_out = $video_redis->has_forbid_msg($voice['group_id'], $v['user_id']);
            // 是否禁言1禁言0否
            $v['is_kick_out'] = $kick_out ? 1 : 0;
            // 是否是管理员
            $v['is_admin'] = 0;
            if ($voice['user_id'] != $v['user_id']) {
                //判断是否管理员
                $user_admin = Db::name("user_admin")->where(" podcast_id = " . $voice['user_id'] . " and user_id =" . $v['user_id'])->find();
                $v['is_admin'] = $user_admin ? 1 : 0;
            }

            // 查询用户是否禁止发音
            $ban_voice = $video_redis->has_forbid_speak($voice['group_id'], $v['user_id']);
            // 是否禁止发音 1禁0否
            $v['is_ban_voice'] = $ban_voice ? 1 : 0;
            $v['nick_name'] = emoji_decode($v['nick_name']);
            // 头像框
            //    $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $v['avatar_frame_id']);
        }
        $root['status'] = 1;
        $root['data'] = $even_wheat;
        ajax_return($root);
    }

    /**
     * 获取要收礼物的用户列表
     */
    public function get_wheat_user()
    {
        $root = array('status' => 0, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        // 房间id
        $video_id = intval($_REQUEST['room_id']);
        //获取上麦人列表
        $even_wheat = get_voice_even_wheat_log_list($video_id, 1, "user_id,nick_name,head_image");
        $root['status'] = 1;
        $root['data'] = $even_wheat;
        ajax_return($root);
    }

    /**
     * 用户申请上麦
     */
    public function apply_wheat()
    {
        $root = array('status' => 0, 'error' => '');

        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        // 房间id
        $video_id = intval($_REQUEST['room_id']);
        // 上麦位置id
        $wheat_id = intval($_REQUEST['wheat_id']);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        // 用户信息
        $user_info = $user_redis->getRow_db($user_id, ['nick_name', 'head_image']);//用户信息

        // 查询语音房间
        $voice = Db::name("video")->where("id=" . $video_id . " and is_voice=1")->find();
        if (!$voice || $voice['live_in'] != 1) {
            $root['error'] = api_lang("Room_closed");
            ajax_return($root);
        }

        //获取其他房间用户是否在麦位上-- 下麦处理
        $where = "video_id !=" . $video_id . " and user_id=" . $user_id . " and (status=1 or status =0)";
        $wheat_logs_type = Db::name('voice_even_wheat_log')->where($where)->find();
        if ($wheat_logs_type) {
            // 用户下麦
            $name = array('status' => 3, 'endtime' => NOW_TIME);
            // 操作修改
            Db::name('voice_even_wheat_log')->where("id=" . $wheat_logs_type['id'])->update($name);
            im_wheat_position_upd($wheat_logs_type['video_id']);
        }
        // 获取麦上位置是否存在用户
        $where = "video_id=" . $video_id . " and location=" . $wheat_id . " and status=1";
        $wheat_logs_type = Db::name('voice_even_wheat_log')->where($where)->find();
        if ($wheat_logs_type) {
            $root['error'] = api_lang("User_already_exists_on_wheat_position");
            ajax_return($root);
        }
        //判断是否管理员
        $user_admin = Db::name("user_admin")->where(" podcast_id = " . $voice['user_id'] . " and user_id =" . $user_id)->find();
        //上麦位状态 0申请 1直接上麦 3下麦
        $status = $user_admin || $voice['user_id'] == $user_id ? 1 : 0;

        //主持麦判断
        if ($wheat_id == 1) {
            if ($status != 1) {
                $root['error'] = api_lang("No_wheat_cant_be_served_temporarily");
                ajax_return($root);
            }
        } else {
            $wheat_type = json_decode($voice['wheat_type'], true);
            $type = 1;
            // 是否有上麦申请权限
            foreach ($wheat_type as $v) {
                if ($v['wheat_id'] == $wheat_id) {
                    $type = $v['type'];
                }
            }
            //直接上麦
            if ($type == 0) {
                $status = 1;
                $root['error'] = api_lang("Succeed_in_wheat");
            }
        }

        //是否在该麦位上
        $where = "video_id=" . $video_id . " and user_id=" . $user_id . " and location=" . $wheat_id . " and (status=1 or status =0)";
        $wheat_logs_type = Db::name('voice_even_wheat_log')->where($where)->find();
        if ($wheat_logs_type) {
            if ($status) {
                // 如果房主把麦位设置成直接上麦的话，用户点击后清除之前申请的麦位，直接上麦
                $name = array('status' => 3, 'endtime' => NOW_TIME);
                Db::name('voice_even_wheat_log')->where('id = ' . $wheat_logs_type['id'])->update($name);
            } else {
                $root['error'] = $wheat_logs_type['status'] == 1 ? api_lang("Already_on_wheat_positionw") : api_lang("Applied_for_wheat_feeding");
                ajax_return($root);
            }
        }

        //用户是否在其他麦位
        $where = "video_id=" . $video_id . " and user_id=" . $user_id . " and (status=1 or status=0)";
        $user_wheat = Db::name('voice_even_wheat_log')->where($where)->find();
        if ($user_wheat) {
            //原麦位下麦
            $name = array('status' => 3, 'endtime' => NOW_TIME);
            Db::name('voice_even_wheat_log')->where('id = ' . $user_wheat['id'])->update($name);
        }
        // 上麦人收益  $user['head_image'] =
        $gift_earnings = 0;
        $data_log = array(
            'video_id'      => $video_id,
            'user_id'       => $user_id,
            'status'        => $status,
            'nick_name'     => $user_info['nick_name'],
            'head_image'    => get_spec_image($user_info['head_image']),
            'location'      => $wheat_id,
            'gift_earnings' => $gift_earnings,
            'addtime'       => NOW_TIME,
        );
        // 加入连麦记录
        Db::name('voice_even_wheat_log')->insert($data_log);
        // 发送im消息
        im_wheat_position_upd($video_id);

        $root['status'] = 1;
        $root['data'] = array(
            'application_status' => $status //上麦位状态 0申请 1直接上麦
        );
        ajax_return($root);
    }

    /**
     * 用户上下麦 同意上麦
     */
    public function upd_wheat_user()
    {
        $root = array('status' => 0, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        // 房间id
        $video_id = intval($_REQUEST['room_id']);
        // 上下麦位置id
        //    $wheat_id = intval($_REQUEST['wheat_id']);
        // 上下麦人id
        $to_user_id = intval($_REQUEST['to_user_id']);
        // 连麦类型 1上麦成功 2拒绝上麦 3结束上麦(下麦)
        $status = intval($_REQUEST['status']) ? intval($_REQUEST['status']) : 3;
        // 查询语音房间
        $voice = Db::name("video")->where("id=" . $video_id . " and is_voice=1")->find();

        // 获取用户是否在麦上
        $where = "video_id=" . $video_id . " and user_id=" . $to_user_id . " and (status=1 or status=0)";
        $wheat_logs = Db::name('voice_even_wheat_log')->where($where)->find();
        if (!$wheat_logs) {
            $root['error'] = api_lang("User_has_left_room");
            ajax_return($root);
        }
        $wheat_id = $wheat_logs['location'];
        if ($user_id == $to_user_id) {
            // 用户自己是否下麦 -- 用户操作自己的上麦状态
            if ($status != 3) {
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
            // 用户下麦
            $name = array('status' => 3, 'endtime' => NOW_TIME);
        } else {
            if ($user_id != $voice['user_id']) {
                //是否有管理员权限
                $user_admin = Db::name("user_admin")->where(" podcast_id = " . $voice['user_id'] . " and user_id =" . $user_id)->find();
                if (!$user_admin) {
                    //没有有管理员权限
                    $root['error'] = api_lang("No_permission");
                    ajax_return($root);
                }
            }

            if ($status == 1) {
                // 获取麦上位置是否存在用户
                $where = "video_id=" . $video_id . " and location=" . $wheat_id . " and status=1";
                $wheat_logs_type = Db::name('voice_even_wheat_log')->where($where)->find();
                if ($wheat_logs_type) {
                    $root['error'] = api_lang("User_already_exists_on_wheat_position");
                    ajax_return($root);
                }
            }
            // 要修改麦位上的字段
            $name = $status == 1 ? array('status' => $status, 'addtime' => NOW_TIME, 'location' => $wheat_id) : array('status' => $status, 'endtime' => NOW_TIME);
        }
        // 操作修改
        $upd_voice = Db::name('voice_even_wheat_log')->where("id=" . $wheat_logs['id'])->update($name);
        if (!$upd_voice) {
            $root['error'] = api_lang("operation_failed");
            ajax_return($root);
        }
        im_wheat_position_upd($video_id);

        $root['status'] = 1;
        $root['error'] = $name['status'] == 1 ? api_lang("Succeed_in_wheat") : $name['status'] == 3 ? api_lang("Succeed_in_feeding_wheat") : api_lang("Succeeded_in_refusing_to_serve_wheat");

        ajax_return($root);
    }

    /**
     * 设置上麦权限
     */
    public function wheat_apply()
    {
        $root = array('status' => 0, 'error' => api_lang("Failed_to_set_microphone_type_voice_room"));
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        // 房间id
        $video_id = intval($_REQUEST['room_id']);
        // 上麦的位置id
        $wheat_id = intval($_REQUEST['wheat_id']);
        // 上麦权限 0直接上麦 1申请上麦 2锁定上麦
        $type = intval($_REQUEST['type']) ? intval($_REQUEST['type']) : 0;
        // 查询语音房间
        $voice = Db::name("video")->where("id=" . $video_id . " and is_voice=1")->find();
        if (!$voice || $voice['live_in'] != 1) {
            $root['error'] = api_lang("Room_closed");
            ajax_return($root);
        }
        if ($user_id != $voice['user_id']) {
            //是否有管理员权限
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $voice['user_id'] . " and user_id =" . $user_id)->find();
            if (!$user_admin) {
                //没有有管理员权限
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
        }
        // 上麦转换

        $wheat_type = json_decode($voice['wheat_type'], true);
        foreach ($wheat_type as &$v) {
            if ($v['wheat_id'] == $wheat_id) {
                $v['type'] = $type;
            }
        }
        $name = array('wheat_type' => json_encode($wheat_type));
        // 修改上麦
        $upd_voice = Db::name('video')->where("id=" . $voice['id'])->update($name);
        if ($upd_voice) {
            sync_video_to_redis($video_id, '*', false);
            // 发送im消息
            im_wheat_position_upd($video_id);
            $root['status'] = 1;
            $root['error'] = api_lang("Succeeded_in_setting_wheat_feeding_type");
        }
        ajax_return($root);
    }

    /**
     * 禁止用户语音  禁止发音
     */
    public function user_ban_voice()
    {
        $root = array('status' => 0, 'error' => api_lang("operation_failed"));
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($root);
        }
        // 房间id
        $video_id = intval($_REQUEST['room_id']);
        // 要禁止语音的用户id
        $to_user_id = intval($_REQUEST['to_user_id']);
        $second = intval($_REQUEST['second']) == 1 ? 60 * 60 * 24 : 0;//禁言时间，单位为秒; 为0时表示取消发音 1禁止发音
        // 查询语音房间
        $voice = Db::name("video")->where("id=" . $video_id . " and is_voice=1")->find();
        if ($user_id != $voice['user_id'] && $user_id != $to_user_id) {
            //是否有管理员权限
            $user_admin = Db::name("user_admin")->where(" podcast_id = " . $voice['user_id'] . " and user_id =" . $user_id)->find();
            if (!$user_admin) {
                //没有有管理员权限
                $root['error'] = api_lang("No_permission");
                ajax_return($root);
            }
        }
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();

        if ($second > 0) {
            //查询用户是否禁止发音
            $shutup_time = NOW_TIME + $second;
            $video_redis->set_forbid_speak($voice['group_id'], $to_user_id, $shutup_time);
            $error = api_lang("Successfully_closed_wheat");
        } else {
            // 解除禁止发音
            $error = api_lang("Succeed_in_opening_wheat");
            $video_redis->unset_forbid_speak($voice['group_id'], $to_user_id);
        }

        $root['status'] = 1;
        $root['error'] = $error;
        // 发送im消息
        im_wheat_position_upd($video_id);
        ajax_return($root);
    }

    /**
     * 踢人普通用户
     */
    public function kicking()
    {
        $return['status'] = 1;
        $return['error'] = api_lang("Operation_completed");
        if (!$GLOBALS['user_info']) {
            $return['error'] = api_lang("user_not_logged_in");
            $return['status'] = 0;
            $return['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);
            $video_id = intval($_REQUEST['room_id']);

            $by_kicking = strim($_REQUEST['user_id']);//被踢用户ID

            $sql = "select id,user_id from " . DB_PREFIX . "video where room_type = 3 and live_in = 1 and id =" . $video_id;
            $video = $GLOBALS['db']->getRow($sql);

            //主播自己或管理员，可以：踢人
            if ($video && $video['user_id'] != $user_id) {
                //判断是否管理员
                $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = " . $video['user_id'] . " and user_id =" . $user_id;
                if (intval($GLOBALS['db']->getRow($sql)) == 0) {
                    //非管理员
                    unset($video);
                }
            }

            //是否是至尊守护
            $guardian_user = redis_get("guardian_host_" . $user_id . "_user_" . $by_kicking);
            if ($guardian_user) {
                $guardian_user = json_decode($guardian_user, true);
            }
            if ($guardian_user && $guardian_user['classification_id'] == 3) { //至尊守护不可禁言
                $root['status'] = 0;
                $root['error'] = api_lang("user_supreme_guardian_no_kick_people");
                ajax_return($root);
            }
            // 是否是贵族==判断贵族有防踢权限 Kicking_failed
            $sql = "select id,nobleid,noble_time from " . DB_PREFIX . "user where id =" . $by_kicking;
            $user_info = $GLOBALS['db']->getRow($sql);
            if ($user_info['nobleid'] > 0 && $user_info['noble_time'] > NOW_TIME) {
                $jurisdiction = load_auto_cache("noble_id", ['id' => $user_info['nobleid']]);
                if ($jurisdiction && $jurisdiction['is_kickproof'] == 1) {
                    // 防踢防禁言
                    $root['status'] = 0;
                    $root['error'] = api_lang("nobility_has_no_authority_kick_people");
                    ajax_return($root);
                }
            }
            if ($video) {
                $sql = "select id from " . DB_PREFIX . "user_admin where podcast_id = " . $video['user_id'] . " and user_id =" . $by_kicking;
                if (intval($GLOBALS['db']->getRow($sql))) {
                    //对方是管理员不能操作
                    $return['status'] = 0;
                    $return['error'] = api_lang("other_party_is_administrator");
                    ajax_return($return);
                }
                //发送踢人消息
                $ext = array();
                $ext['type'] = 17;
                $ext['room_id'] = $video_id;
                $ext['kick_uid'] = $by_kicking;
                $ext['desc'] = api_lang("You_were_kicked_out_of_room");
                #构造高级接口所需参数
                $msg_content = array();
                //创建array 所需元素
                $msg_content_elem = array(
                    'MsgType'    => 'TIMCustomElem',       //自定义类型
                    'MsgContent' => array(
                        'Data' => json_encode($ext),
                        'Desc' => '',
                        //	'Ext' => $ext,
                        //	'Sound' => '',
                    )
                );
                //将创建的元素$msg_content_elem, 加入array $msg_content
                array_push($msg_content, $msg_content_elem);
                bogo_require(APP_ROOT_PATH . 'system/tim/TimApi.php');
                $api = createTimAPI();

                $ret = $api->openim_send_msg2('', $by_kicking, $msg_content);
                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoPrivateRedisService.php');
                $video_private_redis = new VideoPrivateRedisService();
                $video_private_redis->drop_ordinary_user($video_id, $by_kicking, NOW_TIME);
                if ($ret['ActionStatus'] != 'OK') {
                    $return['status'] = 0;
                    $return['error'] = api_lang("Kicking_failed") . ',' . $ret['ErrorInfo'] . ";" . $ret['ErrorCode'];
                }
            } else {
                $return['status'] = 0;
                $return['error'] = api_lang("Kicking_failed");
            }
        }
        ajax_return($return);
    }

    /**
     * 语音房间观众列表
     */
    public function audience_list()
    {
        $return = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        if (!$user_id) {
            $return['error'] = api_lang("user_not_logged_in");
            $return['status'] = 0;
            $return['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($return);
        }
        $room_id = intval($_REQUEST['room_id']);
        //观众列表
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        $video_viewer_redis = new VideoViewerRedisService();
        $viewer = $video_viewer_redis->get_viewer_list2($room_id, $page, 20);
        $list = $viewer['list'];
        // 用户信息
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
        $user_redis = new UserRedisService();
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        if (count($list) > 0) {
            foreach ($list as &$v) {
                $v['nick_name'] = emoji_decode($v['nick_name']);
                // 获取用户缓存中的信息
                $noble = $user_redis->getRow_db($v['user_id'], ['nobleid', 'noble_time', 'is_noble_ranking_stealth', 'is_noble_mysterious', 'avatar_frame_id']);

                if ($noble['noble_time'] > NOW_TIME) {
                    $v['nobleid'] = $noble['nobleid'];
                    $v['is_noble_ranking_stealth'] = $noble['is_noble_ranking_stealth'];
                    $v['is_noble_mysterious'] = $noble['is_noble_mysterious'];
                } else {
                    $v['nobleid'] = '';
                    $v['is_noble_ranking_stealth'] = 0;
                    $v['is_noble_mysterious'] = 0;
                }
                // 头像框
                $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $noble['avatar_frame_id']);
                // 获取是否是管理员
                $v['is_room_administrator'] = intval($video_redis->has_room_administrator($room_id, $v['user_id']));
            }
            //二维数组排序
            $sort = array(
                'direction' => 'SORT_DESC', //排序顺序标志 SORT_DESC 降序；SORT_ASC 升序
                'field'     => 'total_num',       //排序字段
                'field2'    => 'nobleid',       //排序字段
            );
            $arrSort = array();
            foreach ($list as $uniqid => $row) {
                foreach ($row as $key => $value) {
                    $arrSort[$key][$uniqid] = $value;
                }
            }
            array_multisort($arrSort[$sort['field']], SORT_DESC, $arrSort[$sort['field2']], SORT_DESC, $list);
        } else {
            $list = [];
        }
        $return['data'] = $list;


        ajax_return($return);
    }

    /**
     * 语音房间观众列表 ==返回值增加了观众总数
     */
    public function audience_list_2405()
    {
        $return = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        if (!$user_id) {
            $return['error'] = api_lang("user_not_logged_in");
            $return['status'] = 0;
            $return['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($return);
        }
        $room_id = intval($_REQUEST['room_id']);
        //观众列表
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        $video_viewer_redis = new VideoViewerRedisService();
        $viewer = $video_viewer_redis->get_viewer_list2($room_id, $page, 20);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        $list = $viewer['list'];
        $list_number = $viewer['list_number'];
        if (count($list) > 0) {
            foreach ($list as &$v) {
                $v['nick_name'] = emoji_decode($v['nick_name']);
                $noble = $GLOBALS['db']->getRow('select  nobleid,noble_time,is_noble_ranking_stealth,is_noble_mysterious,avatar_frame_id   from ' . DB_PREFIX . 'user where id = ' . $v['user_id']);
                if ($noble['noble_time'] > NOW_TIME) {
                    $v['nobleid'] = $noble['nobleid'];
                    $v['is_noble_ranking_stealth'] = $noble['is_noble_ranking_stealth'];
                    $v['is_noble_mysterious'] = $noble['is_noble_mysterious'];
                } else {
                    $v['nobleid'] = '';
                    $v['is_noble_ranking_stealth'] = 0;
                    $v['is_noble_mysterious'] = 0;
                }
                // 头像框
                $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $noble['avatar_frame_id']);
                // 获取是否是管理员
                $v['is_room_administrator'] = intval($video_redis->has_room_administrator($room_id, $v['user_id']));
            }
            //二维数组排序
            $sort = array(
                'direction' => 'SORT_DESC', //排序顺序标志 SORT_DESC 降序；SORT_ASC 升序
                'field'     => 'total_num',       //排序字段
                'field2'    => 'nobleid',       //排序字段
            );
            $arrSort = array();
            foreach ($list as $uniqid => $row) {
                foreach ($row as $key => $value) {
                    $arrSort[$key][$uniqid] = $value;
                }
            }
            array_multisort($arrSort[$sort['field']], SORT_DESC, $arrSort[$sort['field2']], SORT_DESC, $list);
        } else {
            $list = [];
        }

        $return['data'] = array(
            'list'         => $list,
            'watch_number' => $list_number
        );

        ajax_return($return);
    }

    /**
     * 语音房间观众列表 ==返回值增加了观众总数
     */
    public function search_audience_list_2405()
    {
        $return = array('status' => 1, 'error' => '');
        $user_id = intval($GLOBALS['user_info']['id']);
        $page = intval($_REQUEST['page']) ? intval($_REQUEST['page']) : 1;
        if (!$user_id) {
            $return['error'] = api_lang("user_not_logged_in");
            $return['status'] = 0;
            $return['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            ajax_return($return);
        }
        $room_id = intval($_REQUEST['room_id']);
        $search_keys = strim($_REQUEST['search_keys']);
        //观众列表
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoViewerRedisService.php');
        $video_viewer_redis = new VideoViewerRedisService();
        $viewer = $video_viewer_redis->get_search_viewer_list2($room_id, $page, 20, $search_keys);
        bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
        $video_redis = new VideoRedisService();
        $list = $viewer['list'];
        $list_number = $viewer['list_number'];
        if (count($list) > 0) {
            foreach ($list as &$v) {
                $v['nick_name'] = emoji_decode($v['nick_name']);
                $noble = $GLOBALS['db']->getRow('select  nobleid,noble_time,is_noble_ranking_stealth,is_noble_mysterious,avatar_frame_id   from ' . DB_PREFIX . 'user where id = ' . $v['user_id']);
                if ($noble['noble_time'] > NOW_TIME) {
                    $v['nobleid'] = $noble['nobleid'];
                    $v['is_noble_ranking_stealth'] = $noble['is_noble_ranking_stealth'];
                    $v['is_noble_mysterious'] = $noble['is_noble_mysterious'];
                } else {
                    $v['nobleid'] = '';
                    $v['is_noble_ranking_stealth'] = 0;
                    $v['is_noble_mysterious'] = 0;
                }
                // 头像框
                $v['avatar_frame_url'] = get_avatar_frame_url($v['user_id'], $noble['avatar_frame_id']);
                // 获取是否是管理员
                $v['is_room_administrator'] = intval($video_redis->has_room_administrator($room_id, $v['user_id']));
            }
            //二维数组排序
            $sort = array(
                'direction' => 'SORT_DESC', //排序顺序标志 SORT_DESC 降序；SORT_ASC 升序
                'field'     => 'total_num',       //排序字段
                'field2'    => 'nobleid',       //排序字段
            );
            $arrSort = array();
            foreach ($list as $uniqid => $row) {
                foreach ($row as $key => $value) {
                    $arrSort[$key][$uniqid] = $value;
                }
            }
            array_multisort($arrSort[$sort['field']], SORT_DESC, $arrSort[$sort['field2']], SORT_DESC, $list);
        } else {
            $list = [];
        }

        $return['data'] = array(
            'list'         => $list,
            'watch_number' => $list_number
        );

        ajax_return($return);
    }

    /**
     * 语音房间观众心跳监听，每30秒监听一次;监听数据：时间点，印票数，房间人数
     */
    public function viewer_monitor()
    {
        $root = array();
        $root['status'] = 1;

        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            //有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
            $root['user_login_status'] = 0;
        } else {
            //用户ID
            $user_id = intval($GLOBALS['user_info']['id']);
            //直播ID 也是room_id
            $room_id = intval($_REQUEST['room_id']);

            bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/VideoRedisService.php');
            $video_redis = new VideoRedisService();
            $fields = array('id', 'vote_number', 'is_voice', 'watch_number', 'begin_time', 'is_live_pay', 'live_pay_time', 'live_pay_type', 'live_fee', 'live_is_mention', 'robot_num', 'virtual_watch_number', 'group_id', 'user_id');
            $video_number = $video_redis->getRow_db($room_id, $fields);

            //获得印票数
            $vote_number = intval($video_number['vote_number']);
            //当前观看人数
            $watch_number = intval($video_number['watch_number']);
            //聊天组ID
            $group_id = strim($video_number['group_id']);

            if (intval($_REQUEST['watch_number']) > 0) {
                //客户端有返回：当前观看人数 则取客户端返回的
                //当前观看人数
                $watch_number = intval($_REQUEST['watch_number']);
            }

            //当前连麦数量
            $lianmai_num = intval($_REQUEST['lianmai_num']);

            $live_quality = json_decode($_REQUEST['live_quality'], true);
            //appcpu占用率
            $appCPURate = intval($live_quality['appCPURate']);
            //系统cpu占用率
            $sysCPURate = intval($live_quality['sysCPURate']);
            //上行速率
            $sendKBps = intval($live_quality['sendKBps']);
            //下行速率
            $recvKBps = intval($live_quality['recvKBps']);
            //上行丢包率
            $sendLossRate = intval($live_quality['sendLossRate']);
            //视频帧率fps
            $fps = intval($live_quality['fps']);
            //设备系统
            $device = strim($live_quality['device']);

            $monitor_time = to_date(NOW_TIME, 'Y-m-d H:i:s');

            //00:00; 05:00; 10:00; 15:00; ....; 55:00;
            $i_time = to_date(NOW_TIME, 'i');
            $s_time = to_date(NOW_TIME, 's');

            if ($i_time >= 55 && $s_time > 0) {
                //放在下一小时的：00:00 时段
                $statistic_time = to_date(NOW_TIME + 330, 'Y-m-d H:00:00');
            } else {

                if ($i_time >= 50) {
                    $i_time2 = '55';
                } else if ($i_time >= 45) {
                    $i_time2 = '50';
                } else if ($i_time >= 40) {
                    $i_time2 = '45';
                } else if ($i_time >= 35) {
                    $i_time2 = '40';
                } else if ($i_time >= 30) {
                    $i_time2 = '35';
                } else if ($i_time >= 25) {
                    $i_time2 = '30';
                } else if ($i_time >= 20) {
                    $i_time2 = '25';
                } else if ($i_time >= 15) {
                    $i_time2 = '20';
                } else if ($i_time >= 10) {
                    $i_time2 = '15';
                } else if ($i_time >= 5) {
                    $i_time2 = '10';
                } else {
                    $i_time2 = '05';
                }

                $statistic_time = to_date(NOW_TIME, 'Y-m-d H:') . $i_time2 . ':00';
            }

            //更新最后心跳时间点
            $sql = "update " . DB_PREFIX . "voice_even_wheat_log set monitor_time = '" . $monitor_time . "' where video_id = " . $room_id . " and user_id = " . $user_id;
            $GLOBALS['db']->query($sql);
            if ($GLOBALS['db']->affected_rows()) {

                $video_monitor = array();
                $video_monitor['user_id'] = $user_id;
                $video_monitor['video_id'] = $room_id;
                $video_monitor['vote_number'] = $vote_number;
                $video_monitor['watch_number'] = $watch_number;
                $video_monitor['monitor_time'] = $monitor_time;
                $video_monitor['statistic_time'] = $statistic_time;
                $video_monitor['appCPURate'] = $appCPURate;
                $video_monitor['sysCPURate'] = $sysCPURate;
                $video_monitor['sendKBps'] = $sendKBps;
                $video_monitor['recvKBps'] = $recvKBps;
                $video_monitor['sendLossRate'] = $sendLossRate;
                $video_monitor['fps'] = $fps;
                $video_monitor['device'] = $device;
                $GLOBALS['db']->autoExecute(DB_PREFIX . "voice_monitor", $video_monitor, "INSERT");
            }
        }

        //初始化手机端配置
        $m_config = load_auto_cache("m_config");

        ajax_return($root);
    }
}