<?php

class distributionCModule extends baseCModule
{
    public function index()
    {
        $root = array('status' => 1, 'error' => '');
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in") . print_r($_COOKIE, 1);
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $page = intval($_REQUEST['p']);//取第几页数据

            if ($page == 0) {
                $page = 1;
            }

            $page_size = 30;
            $limit = (($page - 1) * $page_size) . "," . $page_size;

            $sql = "select dl.id,dl.memo,dl.weibo_money,dl.create_time,dl.from_user_id as user_id,u.head_image,u.nick_name as user_name,u.nick_name from " . DB_PREFIX . "weibo_distribution_log dl left join " . DB_PREFIX . "user as u on u.id = dl.from_user_id where dl.to_user_id = " . $user_id . "  group by dl.from_user_id order by dl.id desc limit " . $limit;
            $list = $GLOBALS['db']->getAll($sql, true, true);
            $total_weibo_money = 0;
            foreach ($list as $k => $v) {
                $m_config = load_auto_cache("m_config");//初始化手机端配置
                if ($v['head_image'] == '') $v['head_image'] = $m_config['app_logo'];
                $list[$k]['head_image'] = deal_weio_image($v['head_image'], 'head_image');
                $list[$k]['create_time'] = to_date($v['create_time']);
                if ($v['weibo_money']) {
                    $total_weibo_money += $v['weibo_money'];
                }
            }

            $rs_count = count($list);

            if ($page == 1) {
                $root['page'] = array('page' => $page, 'has_next' => 0);
            } else {
                $has_next = ($rs_count > $page * $page_size) ? '1' : '0';
                $root['page'] = array('page' => $page, 'has_next' => $has_next);
            }

            $root['data'] = $list;
            $root['total_weibo_money'] = $total_weibo_money;
        }
        api_ajax_return($root);
    }

    public function init_register()
    {
        $root = array('status' => 0, 'error' => '');
        $share_id = intval($_REQUEST['user_id']);
        if (!$share_id) {
            $root['error'] = api_lang("Sharing_ID_error");
            api_ajax_return($root);
        }
        $from_user = $GLOBALS['db']->getRow("select id,nick_name,head_image from " . DB_PREFIX . "user  where id = " . $share_id);
        if (!$from_user) {
            $root['error'] = api_lang("member_does_not_exist");
            api_ajax_return($root);
        }
        $root['from_nick_name'] = $from_user['nick_name'];
        $root['from_head_image'] = deal_weio_image($from_user['head_image'], 'head_image');
        $root['url'] = SITE_DOMAIN . '/mapi/index.php?ctl=distribution&act=register&itype=xr&user_id=' . $share_id;
        $root['page_title'] = api_lang("Mobile_phone_registration");
        $root['app_down_url'] = SITE_DOMAIN_DOWNLOAD . "/appdown.php";
        $root['is_login_user'] = 0;
        $root['nick_name'] = '';
        $root['head_image'] = '';
        $root['status'] = 1;
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $root['app_name'] = $m_config['app_name'];
        if ($GLOBALS['user_info']) {
            $root['is_login_user'] = $GLOBALS['user_info']['id'];
            $row = $GLOBALS['db']->getRow("select nick_name,head_image from " . DB_PREFIX . "user  where id = " . $GLOBALS['user_info']['id']);
            $root['nick_name'] = $row['nick_name'];
            $root['head_image'] = deal_weio_image($row['head_image'], 'head_image');
        }
        if (OPEN_YPSMS == 1) {
            $root['status'] = 1;
            $area = array();
            $area[] = array('id' => 1, 'name' => '中国大陆');
            /*$area[]=array('id'=>2,'name'=>'港澳台');
             $area[]=array('id'=>3,'name'=>'日本');
            $area[]=array('id'=>4,'name'=>'韩国');*/
            $area[] = array('id' => 5, 'name' => '其他国家(请在号码前加上区号)');
            $root['area'] = $area;
        }
        api_ajax_return($root);
    }

    public function register()
    {
        $root = array('status' => 1, 'error' => '');
        $root['url'] = SITE_DOMAIN_DOWNLOAD . "/appdown.php";
        if (!$_REQUEST) {
            app_redirect(get_domain() . "/");
        }
        foreach ($_REQUEST as $k => $v) {
            $_REQUEST[$k] = strim($v);
        }
        $p_user_id = intval($_REQUEST['user_id']);
        $mobile = $_REQUEST['mobile'];
        if (!$mobile) {
            $root['error'] = api_lang("phone_number_not_uploaded");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $p_user_id = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where id =" . $p_user_id);
        $mobile = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "user where mobile =" . $mobile);

        if (intval($p_user_id) == 0) {
            $root['error'] = api_lang("Superior_does_not_exist");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        if ($mobile != '') {
            $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $mobile);
            es_session::set("user_info", $user_info);
            $root['is_url'] = 1;
            $root['is_lack'] = $user_info['is_lack'];//是否缺少用户信息
            $root['is_agree'] = intval($user_info['is_agree']);//是否同意直播协议 0 表示不同意 1表示同意
            $root['user_id'] = intval($user_info['user']['id']);
            $root['nick_name'] = $user_info['nick_name'];
            $root['family_id'] = intval($user_info['family_id']);
            $root['family_chieftain'] = intval($user_info['family_chieftain']);
            $root['error'] = api_lang("Login_successful");
            $root['user_info'] = $user_info;
            $root['status'] = 1;
            api_ajax_return($root);

        }
        if ($root['status'] != 0) {
            bogo_require(APP_ROOT_PATH . "system/libs/user.php");
            $result = do_login_user($_REQUEST['mobile'], $_REQUEST['verify_coder'], $p_user_id);
        }
        if ($result['status']) {
            $root['user_id'] = $result['user']['id'];
            $root['status'] = 1;
            if ($result['user']['head_image'] == '' || $result['user_info']['head_image'] == '') {
                //头像
                $m_config = load_auto_cache("m_config");//初始化手机端配置
                $system_head_image = $m_config['app_logo'];

                if ($system_head_image == '') {
                    $system_head_image = './public/attachment/test/noavatar_11.JPG';
                    syn_to_remote_image_server($system_head_image);
                }

                $data = array(
                    'head_image' => $system_head_image,
                    'thumb_head_image' => get_spec_image($system_head_image, 40, 40),
                    'p_user_id' => $result['p_user_id'],
                );

                $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, "UPDATE", "id=" . $result['user']['id']);

                bogo_require(APP_ROOT_PATH . 'mapi/lib/redis/UserRedisService.php');
                $user_redis = new UserRedisService();
                $user_redis->update_db($result['user']['id'], $data);

                //更新session
                $user_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id =" . $result['user']['id']);
                es_session::set("user_info", $user_info);
            }
            $root['is_url'] = 1;
            $root['is_lack'] = $result['is_lack'];//是否缺少用户信息
            $root['is_agree'] = intval($result['user']['is_agree']);//是否同意直播协议 0 表示不同意 1表示同意
            $root['user_id'] = intval($result['user']['id']);
            $root['nick_name'] = $result['user']['nick_name'];
            $root['family_id'] = intval($result['user']['family_id']);
            $root['family_chieftain'] = intval($result['user']['family_chieftain']);
            $root['error'] = api_lang("login_was_successful");
            $root['user_info'] = $result['user_info'];

        } else {
            $root['status'] = 0;
            if ($root['error'] == '')
                $root['error'] = $result['info'];
        }
        api_ajax_return($root);
    }
}

?>
