<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------
use TencentCloud\Common\Credential;
use TencentCloud\Common\Exception\TencentCloudSDKException;
use TencentCloud\Common\Profile\ClientProfile;
use TencentCloud\Common\Profile\HttpProfile;
use TencentCloud\Vod\V20180717\Models\ProcessMediaByUrlRequest;
use TencentCloud\Vod\V20180717\Models\ProcessMediaRequest;
use TencentCloud\Vod\V20180717\VodClient;

class publishCModule extends baseCModule
{
    //发布信息
    public function do_publish()
    {
        $time = NOW_TIME;
        $root = array();
        $data = array();
        $cate = empty($_REQUEST['cate']) ? 0 : $_REQUEST['cate'];
        //初始化手机端配置
        $m_config = load_auto_cache("m_config");
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID

        if ($m_config['svideo_must_authentication']) {
            $sql = "select is_authentication from " . DB_PREFIX . "user where id = " . $user_id;
            $is_authentication = $GLOBALS['db']->getOne($sql);
            if ($is_authentication != 2) {
                api_ajax_return(array("error" => api_lang("Release_video_after_authentication"), "status" => 0));
            }
        }

        $type_array = array(
            'imagetext', 'video', 'weixin', 'goods', 'red_photo', 'photo',
        );
        $type = strim($_REQUEST['publish_type']);
        if (!in_array($type, $type_array)) {
            $root = array(
                'status' => 0,
                'error' => $type . api_lang("Upload_type_error")
            );
            api_ajax_return($root);
        }
        if ($type == 'photo' || $type == 'goods' || $type == 'weixin') {
            if (floatval($_REQUEST['price']) <= 0) {
                $root = array(
                    'status' => 0,
                    'error' => api_lang("Price_cannot_be_empty")
                );
                api_ajax_return($root);
            }
        }

        if ($type == 'weixin') {
            // 微信类型
            $data['weixin_account'] = $_REQUEST['data'];
            $data['weixin_price'] = floatval($_REQUEST['price']);
            $data['weixin_account_time'] = to_date(get_gmtime());
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, 'UPDATE', 'id = ' . $user_id);
        } else {
            // 其它
            $data['content'] = strim($_REQUEST['content']);
            if (empty($data['content'])) {
                $root = array(
                    'status' => 0,
                    'error' => api_lang("Content_cannot_be_empty")
                );
                api_ajax_return($root);
            }

            if ($type == 'photo' || $type == 'video') { // 图片或视频
                if (empty($_REQUEST['photo_image'])) {
                    $root = array(
                        'status' => 0,
                        'error' => api_lang("Cover_cannot_be_empty")
                    );
                    api_ajax_return($root);
                } else {
                    $data['photo_image'] = strim($_REQUEST['photo_image']);
                }
            }

            if ($type == 'video') {
                // $data['photo_image'] = strim($_REQUEST['image_url']);
                $video_url = strim($_REQUEST['video_url']);
                $video_direction = strim($_REQUEST['video_direction']); //视频方向0 默认竖屏 1横屏
                $width = strim($_REQUEST['width']);//视频宽度
                $height = strim($_REQUEST['height']);//视频高度
                if (!$video_url) {
                    $root = array(
                        'status' => 0,
                        'error' => api_lang("Video_cannot_be_empty")
                    );
                    api_ajax_return($root);
                }
                $data['data'] = $video_url;
                $data['video_direction'] = $video_direction;
                $data['width'] = $width;
                $data['height'] = $height;

            } else {

                $_REQUEST['data'] = json_decode($_REQUEST['data'], TRUE);

                if (is_array($_REQUEST['data'])) {
                    $image_array = $_REQUEST['data'];
                    if ($type == 'goods' && $image_array[0]['url']) {
                        $data['photo_image'] = $image_array[0]['url'];
                    }
                    if ($type == 'red_photo') {

                        $_REQUEST['price'] = floatval(count($image_array)) * floatval($m_config['weibo_red_price']);

                        if (floatval($_REQUEST['price']) <= 0) {
                            $root = array(
                                'status' => 0,
                                'error' => api_lang("red_envelope_is_not_less_than_0")
                            );
                            api_ajax_return($root);
                        }
                    }
                    $data['data'] = serialize($image_array);


                } else {
                    $root = array(
                        'status' => 0,
                        'error' => api_lang("Picture_structure_error")
                    );
                    api_ajax_return($root);
                }
            }
            $data['type'] = strim($type);
            $data['status'] = 1;
            $data['price'] = floatval($_REQUEST['price']);

            $data['xpoint'] = strim($_REQUEST['xpoint']);
            $data['ypoint'] = strim($_REQUEST['ypoint']);
            $data['create_time'] = to_date($time);
            $data['user_id'] = $user_id;
            $data['is_audit'] = 0;          // 默认未审核过

            $data['province'] = strim($_REQUEST['province']);
            $data['city'] = strim($_REQUEST['city']);
            $data['address'] = strim($_REQUEST['address']);
            if ($data['city'] == '不显示' || $data['address'] == '不显示') {
                $data['city'] = '';
                $data['address'] = '';
                $data['province'] = '';
            }

            //不需要审核默认通过审核
            if ($m_config['short_video_is_need_audit'] == 0) {
                $data['is_audit'] = 1;
            }

            //是否开启腾讯云存储
            if ($m_config['short_video_store'] == 1) {
                $data['tencent_video_id'] = get_input('tencent_video_id', 's');
            }

            $data['cate'] = $cate;

            $video_id = $GLOBALS['db']->autoExecute(DB_PREFIX . "weibo", $data, 'INSERT');

        }
        if ($GLOBALS['db']->affected_rows()) {
            $root = array(
                'status' => 1,
                'error' => api_lang("Publish_successfully")
            );
            $weibo_count = $GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "weibo where user_id = " . $user_id);
            $GLOBALS['db']->query("update " . DB_PREFIX . "user set weibo_count = " . intval($weibo_count) . " where id = " . $user_id);

            //腾讯云存储的支持只能审核鉴黄
            if ($m_config['short_video_store'] == 1 && $m_config['short_video_ai_audit'] == 1) {

                //提交审批审核任务
                bogo_require(APP_ROOT_PATH . 'vendor/autoload.php');
                //查询视频
                try {
                    $config = load_auto_cache('m_config');

                    $cred = new Credential($config['qcloud_secret_id'], $config['qcloud_secret_key']);
                    $httpProfile = new HttpProfile();
                    $httpProfile->setEndpoint("vod.tencentcloudapi.com");

                    $clientProfile = new ClientProfile();
                    $clientProfile->setHttpProfile($httpProfile);
                    $client = new VodClient($cred, "", $clientProfile);

                    $req = new ProcessMediaRequest();

                    $params = array(
                        "FileId" => $data['tencent_video_id'],
                        "AiContentReviewTask" => array(
                            "Definition" => 10
                        )
                    );
                    $req->fromJsonString(json_encode($params));


                    $resp = $client->ProcessMedia($req);

                    $root['TaskInfo'] = $resp->toJsonString();
                    //print_r($resp->toJsonString());

                } catch (TencentCloudSDKException $e) {
                    echo $e;
                }
            }

        } else {
            $root = array(
                'status' => 0,
                'error' => api_lang("Upload_failed")
            );
        }
        api_ajax_return($root);
    }

    public function do_video_publish()
    {
        $root = array();
        $data = array();
        $m_config = load_auto_cache("m_config");//初始化手机端配置
        $user_id = intval($_REQUEST['user_id']) ? intval($_REQUEST['user_id']) : intval($GLOBALS['user_info']['id']);//用户ID
        if (!$user_id) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }

        $sql = "select is_authentication,nick_name,head_image from " . DB_PREFIX . "user where id = " . $user_id;
        $user = $GLOBALS['db']->getRow($sql);
        //$user_id = 3;
        if ($m_config['svideo_must_authentication']) {

            if ($user['is_authentication'] != 2) {
                api_ajax_return(array("error" => api_lang("Release_video_after_authentication"), "status" => 0));
            }
        }


        $data['type'] = 'video';//类型 视频
        $data['content'] = strim($_REQUEST['content']);//内容
        $data['photo_image'] = strim($_REQUEST['photo_image']);//封面
        $data['data'] = strim($_REQUEST['video_url']);//视频地址

        $data['xpoint'] = strim($_REQUEST['xpoint']);//经度
        $data['ypoint'] = strim($_REQUEST['ypoint']);//纬度
        $data['province'] = strim($_REQUEST['province']);//省份
        $data['city'] = strim($_REQUEST['city']);//城市
        $data['address'] = strim($_REQUEST['address']);//发布地址
        $data['video_type'] = strim($_REQUEST['video_type']);//发布地址
        $mid = $_REQUEST['mid'];//音乐ID

        $music_url = $_REQUEST['music_url'];//音乐地址
        $music_time = $_REQUEST['music_time'];//音乐时长

        if (empty($data['data'])) {
            $root = array(
                'status' => 0,
                'error' => api_lang("Video_cannot_be_empty")
            );
            api_ajax_return($root);
        }

        if (empty($data['photo_image'])) {
            $root = array(
                'status' => 0,
                'error' => api_lang("Cover_cannot_be_empty")
            );
            api_ajax_return($root);
        }

        if (empty($mid)) {
            if (empty($music_url)) {
                $root = array(
                    'status' => 0,
                    'error' => api_lang("Please_upload_music")
                );
                api_ajax_return($root);
            }

            $music = array(
                'uid' => $user_id,
                'music_name' => $user['nick_name'] . api_lang("Original_music"),
                'music_url' => deal_weio_image($music_url, 'music'),
                'cover' => deal_weio_image($user['head_image']),
                't_id' => 0,
                'music_time' => $this->conversion_time($music_time),
                'music_author' => $user['nick_name'],
                'orderno' => 0,
                't_status' => 1,
                'status' => '1',
                'addtime' => time(),
                'type' => 1,
                'recommend' => 0,
            );

            $GLOBALS['db']->autoExecute(DB_PREFIX . "music", $music, 'INSERT');
            $mid = $GLOBALS['db']->insert_id();
            if (!$mid) {
                $root = array(
                    'status' => 0,
                    'error' => api_lang("Music_upload_failed")
                );
                api_ajax_return($root);
            }
        }
        $data['mid'] = $mid;
        $data['create_time'] = date('Y-m-d H:i:s', time());//创建时间
        $data['status'] = 1;//状态1上线
        $data['is_audit'] = 1;//审核1上线
        $data['is_audit'] = 1;//审核1上线
        $data['user_id'] = $user_id;//审核1上线


        if ($data['city'] == '不显示' || $data['address'] == '不显示') {
            $data['city'] = '';
            $data['address'] = '';
            $data['province'] = '';
        }

        $GLOBALS['db']->autoExecute(DB_PREFIX . "weibo", $data, 'INSERT');

        if ($GLOBALS['db']->affected_rows()) {
            $root = array(
                'status' => 1,
                'error' => api_lang("Publish_successfully")
            );
            $weibo_count = $GLOBALS['db']->getOne("select count(*) from " . DB_PREFIX . "weibo where user_id = " . $user_id);
            $re = $GLOBALS['db']->query("update " . DB_PREFIX . "user set weibo_count = " . intval($weibo_count) . " where id = " . $user_id);
            //增加音乐使用次数
            if (!empty($mid)) {

                $GLOBALS['db']->query("update " . DB_PREFIX . "music set user_rate = user_rate + 1 where id = " . $mid);
            }
        } else {
            $root = array(
                'status' => 0,
                'error' => api_lang("Upload_failed")
            );
        }
        api_ajax_return($root);
    }

    public function conversion_time($seconds)
    {
        $seconds = $seconds / 1000;//前端传值是毫秒
        if ($seconds > 3600) {
            $hours = intval($seconds / 3600);
            $minutes = $seconds % 3600;
            $time = $hours . ":" . gmstrftime('%M:%S', $minutes);
        } else {
            $time = gmstrftime('%H:%M:%S', $seconds);
        }
        return $time;
    }

    //微信下架
    public function off_weixin()
    {
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 2;
            api_ajax_return($root);
        }
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID
        $data = array('weixin_account' => '', 'weixin_price' => 0);
        $where = 'id = ' . $user_id;
        $res = $GLOBALS['db']->autoExecute(DB_PREFIX . "user", $data, 'UPDATE', $where);
        if ($res) {
            $root = array(
                'status' => 1,
                'error' => api_lang("Wechat_offline_successfully")
            );
        } else {
            $root = array(
                'status' => 0,
                'error' => api_lang("Wechat_offline_failed")
            );
        }
        api_ajax_return($root);
    }

    //获取会员权限
    public function check_type()
    {
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $user_info = $GLOBALS['db']->getRow("select is_authentication,weibo_count from " . DB_PREFIX . "user where id = " . $GLOBALS['user_info']['id']);
        $root = array(
            'status' => 1,
            'error' => '',
            'info' => $user_info
        );
        api_ajax_return($root);
    }

    // 获取视频类型
    public function get_video_type()
    {
        //$GLOBALS['user_info']['id'] = 3;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $video_type_list = $GLOBALS['db']->getAll("select id,title from " . DB_PREFIX . "video_type where is_effect = 1 order by sort asc");
        $root = array(
            'status' => 1,
            'error' => '',
            'info' => $video_type_list
        );
        api_ajax_return($root);
    }

    //添加喜欢的视频
    public function add_like_video_type()
    {
        //$GLOBALS['user_info']['id'] = 3;
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            api_ajax_return($root);
        }
        $user_id = intval($GLOBALS['user_info']['id']);//用户ID

        $video_type = $_REQUEST['video_type'];//音乐ID
        $video = explode(',', $video_type);
        foreach ($video as $val) {
            $data['v_type'] = $val;
            $data['uid'] = $user_id;
            $GLOBALS['db']->autoExecute(DB_PREFIX . "user_video_type", $data, 'INSERT');
        }

        $root = array(
            'status' => 1,
            'error' => '',
        );
        api_ajax_return($root);
    }

    //删除小视频
    public function del_weibo()
    {
        $root['status'] = 0;
        $root['error'] = api_lang("Deletion_failed");
        if (!$GLOBALS['user_info']) {
            $root['error'] = api_lang("user_not_logged_in");
            $root['status'] = 0;
            $root['user_login_status'] = 0;//有这个参数： user_login_status = 0 时，表示服务端未登陆、要求登陆，操作
        } else {
            $user_id = intval($GLOBALS['user_info']['id']);//用户ID
            $weibo_id = $_REQUEST['weibo_id'];     //视频ID

            $weibo_uid = $GLOBALS['db']->getOne("select id from " . DB_PREFIX . "weibo where id =" . $weibo_id);
            if (empty($weibo_uid)) {
                $root['error'] = api_lang("Short_video_does_not_exist");
                api_ajax_return($root);
            }
            //删除
            $sql = "delete from " . DB_PREFIX . "weibo where id=" . $weibo_uid . " and user_id=" . $user_id;
            $result = $GLOBALS['db']->query($sql);
            if ($result) {
                //$sql="update ".DB_PREFIX."user_dynamic set comments = comments - 1 where id =". $dynamic_id;
                //$GLOBALS['db']->query($sql);

                $root['status'] = 1;
                $root['error'] = api_lang("Deletion_succeeded");
            }
        }
        api_ajax_return($root);
    }


}

?>
