/**
 * zjh
 */

const baseUrl = location.origin + '/index.php?';                                // 域名
const loginUrl = baseUrl + 'm=Mobile&c=public&a=login';                         // 登录
const loginOutUrl = baseUrl + 'm=Mobile&c=user&a=loginOut';                     // 注销
// const userInfoUrl = baseUrl + 'm=Jason&c=user&a=userinfo';                      // 得到用户信息
const defaultAvatar = '/template/default/statics/images/avatar_member@2x.png';  // 默认头像


/**
 * 简化数组循环
 * @param {*} arr 
 * @param {*} def 
 */
// function Each(arr = [], def, newArr = []) {
//     for (let i in arr) newArr.array_push(def(i, arr[i]));
//     return newArr;
// }

/**
 * 合并多个对象
 * @param {*} arr  多个对象
 * @param {*} newObj 
 */
function fuse(arr, newObj = {}) {
    arr.forEach( it => newObj = {...it, ...newObj} )
    return newObj;
}

/**
 * 获得url query参数
 */
function getUrlQuery(query = {}) {
    location.search.replace(/([^?&=]+)=([^&]+)/g, (_, k, v) => query[k] = v);
    return query;
}

/**
 * 判断是否在微信浏览器内
 */
function isWeiXin() {
    var ua = window.navigator.userAgent.toLowerCase();
    if (ua.match(/MicroMessenger/i) == "micromessenger") {
        return true;
    } else {
        return false;
    }
}

/**
 * 下载图片
 * @param {*} Url 
 */
function saveAs(Url) {
    var blob = new Blob([''], {
        type: 'application/octet-stream'
    });
    var url = URL.createObjectURL(blob);
    var a = document.createElement('a');
    a.href = Url;
    a.download = Url.replace(/(.*\/)*([^.]+.*)/ig, "$2").split("?")[0];
    var e = document.createEvent('MouseEvents');
    e.initMouseEvent('click', true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);
    a.dispatchEvent(e);
    URL.revokeObjectURL(url);
}

/**
 * 得到指定天数后的日期
 * @param {*} days 
 */
Date.prototype.getAfterDay = function (days) {
  const nDate = new Date();
  const millSeconds = Math.abs(nDate) + days * 24 * 60 * 60 * 1000;
  const rDate = new Date(millSeconds);
  const year = rDate.getFullYear();
  let month = rDate.getMonth() + 1;
  if (month < 10) month = "0" + month;
  let date = rDate.getDate();
  if (date < 10) date = "0" + date;
  return year + "-" + month + "-" + date;
}

/**
 * 自定义layer msg
 * 手机端
 * success 成功调起的回调
 * end     消息结束的回调
 * @param {*} content 
 * @param {*} time 
 */
function m_msg(content, obj = {}, time = 3, ) {
    const layer_inx = layer.open({
        content,
        skin: 'msg',
        time,
        ...obj
    });
    return layer_inx;
}


/**
 * 展示load状态
 * 手机端
 * @param {*} content 
 */
function m_load(content = '', obj = {}) {
    return layer.open({
        type:2,
        content,
        time: 10000,
        shadeClose: false,  // 点击不关闭遮罩层,
        shade: [0.1, '#333'], //0.1透明度的白色背景
        ...obj
    });
}


/**
 * 自定义layer msg
 * success 成功调起的回调
 * end     消息结束的回调
 * @param {*} content 
 * @param {*} time 
 */
function showMsg(content, obj = {}, time = 5000, ) {
    const layer_inx =  layer.open({
        content,
        time,
        ...obj
    });
    return layer_inx;
}

/**
 * layer 自定义提示
 * @param {*} text 
 */
function divMsg(content = '',
    yes = (layer_inx) => {
        console.log('yes', layer_inx);
        layer.close(layer_inx);
    },
    no = (params) => {
        console.log('no', params);
    },
    text = '提示', obj={}) {
    const layer_inx = layer.open({
        title: [text, 'background-color: #2581FF; color:#fff;height:50px;line-height:50px;'],
        content,
        btn: ['确认', '取消'],
        yes,
        no,
        ...obj
    });
}

/**
 * 展示load状态
 * @param {*} content 
 */
function showLoad(content = '', obj = {}) {
    return layer.load(1, {
        content,
        time: 10000,
        shadeClose: false,  // 点击不关闭遮罩层,
        shade: [0.1, '#333'], //0.1透明度的白色背景
        ...obj
    });
}

/**
 * 跳转页面
 * @param {*} url 
 */
function goTo(url = '/', data = {}, query = '') {
    for(let i in data) query += `&${i}=${data[i]}`
    location.href = url+query;
}

/**
 * ajaxGet请求
 * @param {*} url 
 * @param {*} data 
 * @param {*} success 
 * @param {*} obj 
 */
const reqGet = (url, data = {}, success, obj = {}) => {
    // let query = '';
    // for( let i in data ) query += `&${i}=${data[i]}`
    // url += query
    reqLog(url, data);
    $.ajax({
        type: 'GET', dataType: 'JSON',
        contentType: 'application/x-www-form-urlencoded;charset=utf-8',
        url, data,  success,
        ...obj
    });
}

/**
 * ajaxPost请求
 * @param {*} url 
 * @param {*} data 
 * @param {*} success 
 * @param {*} obj
 */
const reqPost = (url, data, success, obj = {}) => {
    // data = {...data, token: getUrlQuery('token')};
    reqLog(url, data);
    $.ajax({
        url, data, success,
        type: 'POST', dataType: 'JSON',
        contentType: 'application/x-www-form-urlencoded;charset=utf-8',
        ...obj
    });
}

/**
 * 打印请求数据
 */
const reqLog = (url, data) => {
    console.log(
        '%c┍------------------------------------------------------------------┑',
        `color:blue;`
    )
    console.log('| 请求地址：', url)
    console.log('| 请求参数：', data)
    // console.log('| 返回数据：', response.data)
    console.log(
        '%c┕------------------------------------------------------------------┙',
        `color:blue;`
    )
}

/**
 * 根据返回msg字段判断错误
 * @param {*} msg 
 */
function handleExcept(resp) {
    if ( resp.code == 0 ) {
    } else if (resp.code == 2) {
    } else {
    }
}

/**
 * 处理http200异常返回
 * @param {*} msg 
 */
function handleElse(resp) {
    showMsg(resp.msg, {
        end: function () {
            handleExcept(resp);
        }
    });
}

/**
 * 产生dom
 * @param {*} domName 
 */
function proDom(domName) {
    return document.createElement(domName);
}

/**
 * 跳转登录
 */
function isLogin() {
    const token = getCookie('token');
    console.log('%c用户token  ' + token, 'color: #f00')
    if ( token ) return true;
    showMsg('您还未登录或者登录超时,即将跳转登录', {
        end: function () {
            location.href = loginUrl;
        }
    });
    return false;
}

/**
 * 退出登录
 */
function loginOut() {
    if (isLogin()) {
        reqPost(loginOutUrl, {}, function (resp) {
            if (resp.status == 'y') {
                showMsg('成功退出', {
                    end: function (params) {
                        location.href = loginUrl
                    }
                });
            } else {
                const msg = resp.status
                showMsg(msg);
            }
        });
    }
}


/**
 * 手机号转化 ...
 * @param {*} tel 
 */
function encryMobile(tel = '***********') {
    if (tel) tel = tel.substr(0, 3) + "****" + tel.substr(7);
    return tel;
}

/**
 * 银行卡号转化
 * @param {*} card 
 * @param {*} arr 
 */
function encryCard( card = '****************', arr = [] ) {
    arr = [
        card.substr(0, 4),
        '****',
        '****',
        card.substr(-4)
    ]
    return arr;
}

String.prototype.encryCard = function(card = '****************', arr = []) {
    arr = [
        card.substr(0, 4),
        '****',
        '****',
        card.substr(-4)
    ]
    return arr;
}


/************************************************     设置存储cookie, localstorage    ********************************************************** */

/**
 * 设置storage
 * @param {*} name 
 * @param {*} value 
 */
function setStorage(name, value) {
    localStorage.setItem(name, value);
}

/**
 * 读取storage
 * @param {*} name 
 */
function getStorage(name) {
    const val = localStorage.getItem(name);
    return val ? val : false;
}

/**
 * 设置cookie
 * @param {*} c_name 
 * @param {*} value 
 * @param {*} expiredays 
 */
function setCookie(c_name, value, expiredays) {
    var exdate = new Date()
    exdate.setDate(exdate.getDate() + expiredays)
    document.cookie = c_name + "=" + escape(value) +
        ((expiredays == null) ? "" : ";expires=" + exdate.toGMTString()) + ";path=/";

}
/**
 * 读取cookie
 * @param {*} c_name 
 */
function getCookie(c_name) {
    if (document.cookie.length > 0) {
        var c_start = document.cookie.indexOf(c_name + "=")
        if (c_start != -1) {
            c_start = c_start + c_name.length + 1
            var c_end = document.cookie.indexOf(";", c_start)
            if (c_end == -1) c_end = document.cookie.length
            return unescape(document.cookie.substring(c_start, c_end))
        }
    }
    return ""
}


/**************************************************  dom设置, 读取值(text, value)  *********************************************************** */

/**
 * 根据id名对多个dom绑定值
 * const bind = new Bind({
 *  id1: val1,
 *  id2: val2,
 *  ...
 * })
 * 读取指定属性值
 * const bind = new Bind([id1, id2, ...])
 */
class Bind {
    // dom = {};           // dom列表
    // v = {};             // 获取的dom指定属性值
    constructor(data) {
        this.dom = {};
        if (data instanceof Array) {    // 读取dom指定
            data.forEach( it => {
                this.type = type;                
                this.dom[it] = document.getElementById(it);
                this.getContent(it, this.dom[it])
            } )
        } else {                        // 设置dom值
            for (let i in data) {
                this.dom[i] = document.getElementById(i);             
                // type == 'value' ? this.sv(this.dom[i], data[i]) : this.st(this.dom[i], data[i]);
                this.setAttr(this.dom[i], data[i])
            }
        }
    }

    st(dom, text) {
        dom.innerText = text+'';
    }

    sv(dom, val) {
        dom.value = val+'';
    }

    setAttr(dom, val) {
        switch (val.type) {
            case 'text':
                dom.innerText = val.val + '';
            break;
            case 'value':
                dom.value = val.val + '';
            break;
            case 'class':
                dom.className = val.val + '';
            case 'image':
                dom.src = val.val + '';
            default:
                dom[this.type] = val.val +'';
            break;
        }
           
    }

    getText(name) {
        return this.dom[name].innerText;
    }

    getVal(name) {
        return this.dom[name].value;
    }

    /**
     * 读取dom指定属性
     * @param {*} name 
     * @param {*} dom 
     */
    getContent(name, type) {
        return  this.dom[name][type]
    }

    getAll(attr = '', data = {}) {
        for (let i in this.dom) data[i] = this.dom[i][attr]
        return data;
    }
}


/**
 * 获取浏览器, 版本信息
 */
function getBrowserInfo() {
    var agent = navigator.userAgent.toLowerCase();
    var regStr_ie = /msie [\d.]+;/gi;
    var regStr_ff = /firefox\/[\d.]+/gi
    var regStr_chrome = /chrome\/[\d.]+/gi;
    var regStr_saf = /safari\/[\d.]+/gi;
    var isIE = agent.indexOf("compatible") > -1 && agent.indexOf("msie" > -1); //判断是否IE<11浏览器 var
    var isEdge = agent.indexOf("edge") > -1 && !isIE; //判断是否IE的Edge浏览器
    var isIE11 = agent.indexOf('trident') > -1 && agent.indexOf("rv:11.0") > -1;
    if (isIE) {
        var reIE = new RegExp("msie (\\d+\\.\\d+);");
        reIE.test(agent);
        var fIEVersion = parseFloat(RegExp["$1"]);
        if (fIEVersion == 7) {
            return "IE/7";
        } else if (fIEVersion == 8) {
            return "IE/8";
        } else if (fIEVersion == 9) {
            return "IE/9";
        } else if (fIEVersion == 10) {
            return "IE/10";
        }
    } //isIE end
    if (isIE11) {
        return "IE/11";
    }
    //firefox
    if (agent.indexOf("firefox") > 0) {
        return agent.match(regStr_ff);
    }
    //Safari
    if (agent.indexOf("safari") > 0 && agent.indexOf("chrome") < 0) {
        return agent.match(regStr_saf);
    } //Chrome if
    if (agent.indexOf("chrome") > 0) {
        return agent.match(regStr_chrome);
    }
}

/**
 * 函数防抖
 * 调用时, 保证this指向dom
 * 原理: 对处理函数进行延时操作, 在指定的延时内调用函数, 先删除上一次的调用, 重新定时执行.
 * @param {*} fn      函数
 * @param {*} delay   指定的延时时间
 */
function debounce(fn, delay) {
    // 维护一个 timer
    let timer = null;
    return function () { // 通过 ‘this’ 和 ‘arguments’ 获取函数的作用域和变量
        let context = this || window;
        let args = arguments;

        if (timer) clearTimeout(timer);
        timer = setTimeout(function () {
            fn.apply(context, args);
        }, delay);
    }
}