<?php

class rank_consumption_auto_cache extends auto_cache{
	private $key = "rank:consumption:";
	public function load($param)
	{
		$rank_name = strim($param['rank_name']);
		$table = strim($param['table']);
		$page = intval($param['page']);
		$page_size = intval($param['page_size']);
		$cache_time = strim($param['cache_time']);
		$limit = (($page - 1) * $page_size) . "," . $page_size;

		$this->key .= $rank_name . '_' . $page;

		$key_bf = $this->key.'_bf';

		$list = $GLOBALS['cache']->get($this->key,true);
        $list = false;
		if ($list == false) {
			$is_ok =  $GLOBALS['cache']->set_lock($this->key);
            $is_ok = 1;
			if(!$is_ok){
				$list = $GLOBALS['cache']->get($key_bf,true);
			}else{
                $m_config =  load_auto_cache("m_config");//参数
				if($rank_name=='day'){//day
                    $day_start_time = strtotime(to_date(NOW_TIME,'Y-m-d'));

					$sql ="select u.id as user_id,u.birthday,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_ticket) as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from  ".$table." as v LEFT JOIN ".DB_PREFIX."user as u  on u.id = v.to_user_id
											where u.is_effect=1 and v.create_time>=".$day_start_time." and v.is_red_envelope = 0 GROUP BY v.to_user_id
											order BY sum(v.total_ticket) desc limit ".$limit;
				}elseif($rank_name=='week'){//week

                    //获取开始时间
                    $weeks = get_weeks_array();
                    $week = date('W');
                    $start_month = $weeks['start_month'];
                    $end_month = $weeks['end_month'];

                    if($start_month == $end_month) {
                        // 不跨表查询
                        $table = DB_PREFIX . 'video_prop_' . $end_month;
                        $sql ="select u.id as user_id,u.birthday,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_ticket) as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from  ".$table." as v LEFT JOIN ".DB_PREFIX."user as u  on u.id = v.to_user_id
											where u.is_effect=1 and v.create_w=".$week." and v.is_red_envelope = 0 GROUP BY u.id
											order BY sum(v.total_ticket) desc limit ".$limit;
                    }else{
                        // 跨表查询
                        $table = DB_PREFIX . 'video_prop_' . $start_month;
                        $table1 = DB_PREFIX . 'video_prop_' . $end_month;

                        $field="u.id as user_id,u.birthday,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(coalesce(v.total_ticket,0) + coalesce(v1.total_ticket,0)) as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth";

                        $sql = "select ".$field." from ".DB_PREFIX."user  as u  left JOIN ".$table." as v on u.id = v.to_user_id  left JOIN ".$table1." as v1 on u.id = v1.to_user_id
											where u.is_effect=1 and ((v.create_w =".$week." and v.is_red_envelope = 0) or (v1.create_w =".$week." and v1.is_red_envelope = 0)) GROUP BY u.id
											order BY ticket desc limit ".$limit;
                    }
                }elseif($rank_name=='month'){//month

                    $month_start_time = mktime(0, 0, 0, date('m'), 1, date('Y'));

                    $sql = "select u.id as user_id,u.birthday,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,sum(v.total_ticket) as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from ".$table." as v LEFT JOIN ".DB_PREFIX."user as u on u.id = v.to_user_id
											where u.is_effect=1 and v.create_time>=".$month_start_time." and v.is_red_envelope = 0 GROUP BY v.to_user_id
											order BY sum(v.total_ticket) desc limit ".$limit;
				}else{//all
					$sql = "select u.id as user_id,u.birthday,u.nick_name,u.v_type,u.v_icon,u.head_image,u.sex,u.user_level,u.ticket as ticket,u.is_authentication,u.create_time,u.nobleid,u.noble_time,u.is_noble_mysterious,u.is_noble_ranking_stealth
											from ".DB_PREFIX."user as u
											where u.is_effect=1 and u.ticket>0
											order BY u.ticket desc limit ".$limit;
				}

				$list=$GLOBALS['db']->getAll($sql,true,true);

				if($rank_name=='day'){
					$GLOBALS['cache']->set($this->key, $list, $cache_time, true);//缓存时间 1800秒
					$GLOBALS['cache']->set($key_bf, $list, $m_config['rank_day'], true);//备份
                }elseif($rank_name=='week'){
                    $GLOBALS['cache']->set($this->key, $list, $cache_time, true);//缓存时间 28800秒 8h
                    $GLOBALS['cache']->set($key_bf, $list, $m_config['rank_day'], true);//备份
				}elseif($rank_name=='month'){
					$GLOBALS['cache']->set($this->key, $list, $cache_time, true);//缓存时间 28800秒 8h
					$GLOBALS['cache']->set($key_bf, $list, $m_config['rank_month'], true);//备份
				}else{
					$GLOBALS['cache']->set($this->key, $list, $cache_time, true);//缓存时间 86400秒 24h
					$GLOBALS['cache']->set($key_bf, $list, $m_config['rank_all'], true);//备份
				}
			}
 		}

 		if ($list == false) $list = array();

		return $list;
	}

	public function rm()
	{

		$GLOBALS['cache']->clear_by_name($this->key);
	}

	public function clear_all()
	{

		$GLOBALS['cache']->clear_by_name($this->key);
	}
}
?>