<?php

$payment_lang = array(
    'name' => 'PayPalWeb',
    'merchantId' => 'merchantId',
    'publicKey' => 'publicKey',
    'privateKey' => 'privateKey',
);

$config = array(
    'merchantId' => array(
        'INPUT_TYPE' => '0',
    ),
    'publicKey' => array(
        'INPUT_TYPE' => '0',
    ),
    'privateKey' => array(
        'INPUT_TYPE' => '0',
    ),
);

/* 模块的基本信息 */
if (isset($read_modules) && $read_modules == true) {
    $module['class_name'] = 'PayPalWeb';
    /* 名称 */
    $module['name'] = $payment_lang['name'];

    /* 支付方式：1：在线支付；0：线下支付  2:仅wap支付 3:仅app支付 4:兼容wap和app*/
    $module['online_pay'] = '4';

    /* 配送 */
    $module['config'] = $config;

    $module['lang'] = $payment_lang;

    $module['reg_url'] = '';

    return $module;
}

// 支付模型
require_once(APP_ROOT_PATH . 'system/libs/payment.php');

class PayPalWeb_payment implements payment
{

    public function get_payment_code($payment_notice_id)
    {

        $pay = array();
        $pay['is_wap'] = 1;
        $pay['class_name'] = "PayPalWeb";
        $pay['is_without'] = 0;
        $pay['url'] = SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=paypalweb&act=pay_index&pay_code=PayPalWeb&notice_id=' . $payment_notice_id;
        $pay['sdk_code'] = array("pay_sdk_type" => "PayPal", "config" =>
            array(
                "url" => SITE_DOMAIN . APP_ROOT . '/wap/index.php?ctl=paypalweb&act=pay_index&pay_code=PayPalWeb&notice_id=' . $payment_notice_id,
                "is_wap" => 1,
            )
        );
        $pay['notice_id'] = $payment_notice_id;
        return $pay;

    }

    public function response($request)
    {

    }

    public function notify($request)
    {

    }

    function get_display_code()
    {

    }

    public function display_code($payment_notice_id)
    {

    }
}
