<?php


$payment_lang = array(
    'name' => 'Razorpay',
    'key_id' => 'Razorpay key_id',
    'secret' => 'Razorpay secret',
);

$config = array(
    'appkey' => array(
        'INPUT_TYPE' => '0',
    ),
    'appsecret' => array(
        'INPUT_TYPE' => '0',
    ),
);

/* 模块的基本信息 */
if (isset($read_modules) && $read_modules == true) {
    $module['class_name'] = 'Razorpay';

    /* 名称 */
    $module['name'] = $payment_lang['name'];

    /* 支付方式：1：在线支付；0：线下支付  2:仅wap支付 3:仅app支付 4:兼容wap和app*/
    $module['online_pay'] = '4';

    /* 配送 */
    $module['config'] = $config;

    $module['lang'] = $payment_lang;

    $module['reg_url'] = 'https://razorpay.com/';

    return $module;
}

// 支付模型
require_once(APP_ROOT_PATH . 'system/libs/payment.php');

class Razorpay_payment implements payment
{

    public function get_payment_code($payment_notice_id)
    {

        $payment_notice = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where id = " . $payment_notice_id);

        $payment = $GLOBALS['db']->getRow("select id,config,logo from " . DB_PREFIX . "payment where id=" . intval($payment_notice['payment_id']));
        $payment['config'] = unserialize($payment['config']);

        $pay = array();

        // 请求接口验证IDToken
        $response = sms_Post([
            'order_id' => $payment_notice['notice_sn'],
            'money' => $payment_notice['money'],
            'key_id' => $payment['config']['key_id'],
            'secret' => $payment['config']['secret'],
        ],
            'http://customer2-app-127-0-0-1.nip.io/mapi/pay_app/serviceApiRazorpayCreateOrder');

        if (is_null(json_decode($response))) {
            echo $response;
            exit;
        }

        $orderResult = json_decode($response, true);

        $orderResult['key_id'] = $payment['config']['key_id'];
        $orderResult['money_name'] = $payment_notice['name'];
        $orderResult['order_id'] = $orderResult['id'];

        // 更新第三方订单号码
        $sql = "update " . DB_PREFIX . "payment_notice set outer_notice_sn='{$orderResult['order_id']}' where id=" . $payment_notice_id;
        $result = $GLOBALS['db']->query($sql);

        $pay['sdk_code'] = array("pay_sdk_type" => "razorpay", "config" =>
            array(
                $orderResult
            )
        );

        return $pay;

    }

    public function response($request)
    {

    }

    public function notify($request)
    {

    }

    function get_display_code()
    {

    }

    public function display_code($payment_notice_id)
    {

    }

    public function checkOrder($razorpay_payment_id, $razorpay_order_id, $razorpay_signature)
    {
        // 请求接口验证IDToken
//        $response = sms_Post([
//            'razorpay_signature' => $razorpay_signature,
//            'razorpay_payment_id' => $razorpay_payment_id,
//            'razorpay_order_id' => $razorpay_order_id
//        ],
//            'http://customer2-app-127-0-0-1.nip.io/mapi/pay_app/serviceApiRazorpayCheck');
//
//        if (is_null(json_decode($response))) {
//            echo $response;
//            exit;
//        }

        $result = [];

        $payment_notice = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where outer_notice_sn = '{$razorpay_order_id}'");

        if (!$payment_notice) {
            $result['check_result'] = 'Fail 1001';
            return $result;
        }

        $payment = $GLOBALS['db']->getRow("select id,config,logo from " . DB_PREFIX . "payment where id=" . intval($payment_notice['payment_id']));
        $payment['config'] = unserialize($payment['config']);

        $secret = $payment['config']['secret'];

        $generated_signature = hash_hmac('sha256', $payment_notice['outer_notice_sn'] . "|" . $razorpay_payment_id, $secret);

        if ($generated_signature == $razorpay_signature) {

            require_once APP_ROOT_PATH . "system/libs/cart.php";
            $rs = payment_paid($payment_notice['notice_sn'], $payment_notice['outer_notice_sn']);
            if ($rs) {
                $result['check_result'] = 'Success';
            } else {
                $result['check_result'] = 'Fail 1002';
            }
        } else {
            $result['check_result'] = 'Fail 1003';
        }

        return $result;

    }
}