<?php

require_once(APP_ROOT_PATH . 'system/libs/payment.php');
bogo_require(APP_ROOT_PATH . "system/libs/auto_cache.php");

class TopPay_payment extends auto_cache
{
    // 支付
    public function get_payment_code($payment_notice_id)
    {
        $payment_notice = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where id = " . $payment_notice_id);
        $pay = $GLOBALS['db']->getRow("select id,config,logo,class_name from " . DB_PREFIX . "payment where id=" . intval($payment_notice['payment_id']));
        $user = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "user where id=" . intval($payment_notice['user_id']));
        $pay['config'] = unserialize($pay['config']);
        $merchantCode = $pay['config']['merchant_code']; // 商户 ID merchant_code 来自idntask、用户信息的merchent ID
        $mchPrivateKey = $pay['config']['private_key']; // mchchant私钥
        //  $public_key = $pay['config']['public_key']; // 平台公钥，来自密钥配置
        $money = round($payment_notice['money'], 2);
        $payMoney = intval($money);
        $orderType = '0'; // 付款方式
        $orderNum = $payment_notice['notice_sn']; // 商户系统唯一订单号
        $productDetail = $payment_notice['recharge_name']; // 虚拟帐户描述
        $dateTime = date("YmdHis", time());
        $email = $user['email'] ?: "11@qq.com"; // 客户的电子邮件地址
        $phone = $user['mobile'] ?: "1111"; // 客户手机号码
        $name = $user['nick_name']; // 在银行确认显示上显示姓名
        $notifyUrl = SITE_DOMAIN . '/callback/payment/top_notify.php'; // 用于回调的url
        $expiryPeriod = '1440';
        $redirectUrl = SITE_DOMAIN . '/pay_return.html';
        $params = array(
            'merchantCode'  => $merchantCode . '',
            'orderType'     => $orderType,
            'orderNum'      => $orderNum . '',
            'payMoney'      => $payMoney . '',
            'name'          => $name,
            'email'         => $email,
            'phone'         => $phone,
            'notifyUrl'     => $notifyUrl,
            'dateTime'      => $dateTime,
            'expiryPeriod'  => $expiryPeriod,
            'productDetail' => $productDetail,
            'redirectUrl'   => $redirectUrl,
        );

        ksort($params);
        $params_str = '';
        foreach ($params as $val) {
            $params_str = $params_str . $val;
        }
        $sign = $this->pivate_key_encrypt($params_str, $mchPrivateKey);
        $params['sign'] = $sign;
        $params_string = json_encode($params);
        $url = 'https://id-openapi.toppay.asia/gateway/prepaidOrder';
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($params_string))
        );
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        $request = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        add_file_log("返回的request1:" . $request . ";httpCode=" . $httpCode, 'TopPay', 'pay');

        if ($httpCode == 200) {
            $result = json_decode($request, true);
            $pay_info['url'] = $result['url'];       //生成指定网址: 如果你使用模式1，获取url参数，收银机链接 /如果使用模式2，则获取payData参数、付款信息
            if (isset($result['platRespCode']) && $result['platRespCode'] == 'FAIL') {
                $pay_info['msg'] = $result['platRespMessage'];
                $pay_info['url'] = '';
            }
        } else {
            $result = json_decode($request, true);
            add_file_log("返回的request:" . $request, 'TopPay', 'pay');
            $pay_info['msg'] = $result['platRespMessage'];
            $pay_info['url'] = "";
        }
        $pay_info['is_wap'] = 1;
        $pay_info['is_without'] = 1;
        return $pay_info;
    }

    // 支付成功异步回调
    public function notify()
    {
        require_once APP_ROOT_PATH . 'system/common.php';
        $res = json_decode(file_get_contents('php://input'), true);
        add_file_log("支付异步回调：" . json_encode($res), 'TopPay_notify', 'pay');
        $platSign = $res['platSign'];
        unset($res['platSign']);
        $order_id = $res['orderNum'];
        $order_info = false;
        if ($order_id) {
            //查询订单
            $order_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where notice_sn = '" . $order_id . "'");
        }
        if (!$order_info) {
            add_file_log("==== 订单不存在 ===", 'TopPay_notify', 'pay');
            echo 'fail';
            exit;
        }
        $pay = $GLOBALS['db']->getRow("select id,config,logo from " . DB_PREFIX . "payment where id=" . intval($order_info['payment_id']));
        if (!$pay) {
            add_file_log("==== 支付方式不存在 ====", 'TopPay_notify', 'pay');
            echo 'fail';
            exit;
        }
        $pay['config'] = unserialize($pay['config']);
        $public_key = $pay['config']['public_key']; // 平台公钥，来自密钥配置
        $decryptSign = $this->public_key_decrypt($platSign, $public_key);
        $params = $res;
        ksort($params);
        $params_str = '';
        foreach ($params as $key => $val) {
            $params_str = $params_str . $val;
        }
        if ($params_str == $decryptSign) {
            if ($res['code'] == '00') {
                $payment_intent = $res['platOrderNum'];
                //可在此处增加操作数据库语句，实现自动下发，也可在其他文件导入该php，写入数据库
                require_once APP_ROOT_PATH . "system/libs/cart.php";
                payment_paid($order_id, $payment_intent);
                echo 'SUCCESS';
            } else {
                add_file_log("==== 支付失败 ====", 'TopPay_notify', 'pay');
                echo 'fail';
            }
        } else {
            add_file_log("==== Sign错误 ====" . $decryptSign, 'TopPay_notify', 'pay');
            echo 'fail';
        }
    }

    private function pivate_key_encrypt($data, $pivate_key)
    {
        $pivate_key = '-----BEGIN PRIVATE KEY-----' . "\n" . $pivate_key . "\n" . '-----END PRIVATE KEY-----';
        $pi_key = openssl_pkey_get_private($pivate_key);
        $crypto = '';
        foreach (str_split($data, 117) as $chunk) {
            openssl_private_encrypt($chunk, $encryptData, $pi_key);
            $crypto .= $encryptData;
        }
        return base64_encode($crypto);
    }

    private function public_key_decrypt($data, $public_key)
    {
        $public_key = '-----BEGIN PUBLIC KEY-----' . "\n" . $public_key . "\n" . '-----END PUBLIC KEY-----';
        $data = base64_decode($data);
        $pu_key = openssl_pkey_get_public($public_key);
        $crypto = '';
        foreach (str_split($data, 128) as $chunk) {
            openssl_public_decrypt($chunk, $decryptData, $pu_key);
            $crypto .= $decryptData;
        }
        return $crypto;
    }
}