<?php

require_once(APP_ROOT_PATH . 'system/libs/payment.php');
bogo_require(APP_ROOT_PATH . "system/libs/auto_cache.php");
use Stripe\Checkout\Session;
use Stripe\Event;
use Stripe\Stripe;

class stripe_h5_payment extends auto_cache
{
    // 支付
    public function get_payment_code($payment_notice_id)
    {
        $payment_notice = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where id = " . $payment_notice_id);
        $money = round($payment_notice['money'], 2);

        $pay = $GLOBALS['db']->getRow("select id,config,logo,class_name from " . DB_PREFIX . "payment where id=" . intval($payment_notice['payment_id']));
        $pay['config'] = unserialize($pay['config']);
        $private_key = $pay['config']['private_key'];
        $merchant_id = $pay['config']['merchant_id'];
        $app_id = $pay['config']['app_id'];

        Stripe::setApiKey($private_key);
        $money = intval($money) * 100;

        $m_config = load_auto_cache("m_config");
        $name = $m_config['diamonds_name'];
        if ($name == ''){
            $name = 'coin';
        }

        $name .= $name.': ' . $payment_notice['diamonds'];
        // card,Stripe
        $payment_type = explode(',', $merchant_id);

        $session = Session::create(
            [
                'line_items' => [[
                    'price_data' => [
                        'currency' => $app_id,
                        'product_data' => [
                            'name' => $name,
                        ],
                        'unit_amount' => $money,
                    ],
                    'quantity' => 1,
                ]],
                // 'customer' => $order_id,
                'mode' => 'payment',
                'payment_method_types' => $payment_type,
                'success_url' => SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=pay&act=pay_success_display_html&order_id=' . $payment_notice['notice_sn'] . '&class_name=' . $pay['class_name'],
                'cancel_url' =>  SITE_DOMAIN . APP_ROOT . '/mapi/index.php?ctl=pay&act=pay_success_display_html&order_id=' . $payment_notice['notice_sn'] . '&class_name=' . $pay['class_name'],
       //         'client_reference_id'=> $payment_notice['notice_sn'],
                'payment_intent_data' => [//这个参数里的内容可以自定义
                    'metadata' => ['order_sn'=>$payment_notice['notice_sn']],

                ]
            ]
        );

//          $payment_intent = $session->payment_intent;
//  add_file_log("stripe== 支付cache ==> payment_intent：".$payment_intent,'stripe_h5');
// add_file_log("stripe== 支付开始：".json_encode($session),'stripe_h5');
//         $GLOBALS['cache']->set($payment_intent,$payment_notice['notice_sn'], 60 * 60 * 24);

        $pay_info['url'] = $session->url;       //生成指定网址
        $pay_info['is_wap'] = 1;
        $pay_info['is_without'] = 1;
        return $pay_info;
    }

    // 支付成功异步回调
    public function notify($request)
    {
        $re = json_decode($request, true);

        add_file_log("stripe== 支付异步回调：".$request,'stripe_h5');
        $order_id = $re["data"]['object']['metadata']['order_sn'];
    //    add_file_log("stripe支付异步回调== order_id = ".$order_id,'stripe_h5');
        if ($order_id) {
            //查询订单
            $order_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "payment_notice where notice_sn = '" .$order_id."'");
    //        add_file_log("查询订单：".json_encode($order_info),'stripe_h5');
            $pay_info = $GLOBALS['db']->getRow("select id,config,logo from " . DB_PREFIX . "payment where id=" . intval($order_info['payment_id']));
    //        add_file_log("查询pay_info：".json_encode($pay_info),'stripe_h5');
            if (!$pay_info) {
                bogo_require(APP_ROOT_PATH . 'mapi/lib/tools/PushLog.class.php');
                PushLog::log($re);
                http_response_code(400); exit;
            }

            $pay_info['config'] = unserialize($pay_info['config']);
            $private_key = $pay_info['config']['private_key'];

            Stripe::setApiKey($private_key);

            $event = null;
            try {
                $event = Event::constructFrom($re);
                add_file_log("查询event：".json_encode($event),'stripe_h5');
            } catch(\UnexpectedValueException $e) {
                // Invalid payload
                add_file_log("查询错误：".$e,'stripe_h5');
                http_response_code(400);
                exit();
            }
        //    add_file_log("stripe== event->type ：".$event->type,'stripe_h5');
            switch ($event->type) {
                case 'charge.succeeded':
                    $succeeded = $event->data->object;
       //             add_file_log("stripe== succeeded ：".json_encode($succeeded),'stripe_h5');
                    if ($succeeded->status == 'succeeded'){
                        $order_num = $succeeded->metadata->order_sn;
       //                 add_file_log("stripe== order_num ：".$order_num." ======payment_intent:". $succeeded->id,'stripe_h5');
                        $payment_intent = $succeeded->id;
                        //可在此处增加操作数据库语句，实现自动下发，也可在其他文件导入该php，写入数据库
                        require_once APP_ROOT_PATH . "system/libs/cart.php";
                        add_file_log("stripe== 支付成功：".json_encode($succeeded),'stripe_h5');
                        payment_paid($order_num, $payment_intent);

                        http_response_code(200);
                    }
                    break;
                default:
                    echo 'Received unknown event type ' . $event->type;
                    break;
            }
        }else{
            add_file_log("order不存在：",'stripe_h5');
            http_response_code(400);
            exit();
        }

        /*$endpoint_secret = $pay_info['public_key'];
        $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
        try {
            $event = Webhook::constructEvent(
                $request, $sig_header, $endpoint_secret
            );
        } catch(\UnexpectedValueException $e) {
            // Invalid payload
            http_response_code(400);
            exit();
        } catch(\Stripe\Exception\SignatureVerificationException $e) {
            // Invalid signature
            http_response_code(400);
            exit();
        }*/

        // Handle the event

        //   switch ($event->type) {
        //     case 'payment_intent.succeeded':
        //         $object = $event->data->object;
        //         if ($object->status == 'succeeded'){//支付成功
        //
        //         }
        //         break;
        // }



        return true;
    }

    // 支付成功同步跳转
    public function success_html($order_id)
    {
        $html = '<html>
            <head><title>Thanks for your order!</title></head>
            <body>
                <h1>Thanks for your order!</h1>
                <p>
                We appreciate your business!
                If you have any questions, please open application.
            </body>
        </html>';
        echo $html;
        exit;
    }

    // 支付取消同步跳转
    public function cancel_html($order_id)
    {
        $html = '<html>
            <head><title>Thanks for your order!</title></head>
            <body>
                <h1>Thanks for your order!</h1>
                <p>
                We appreciate your business!
                If you have any questions, please open application.
            </body>
        </html>';
        echo $html;
        exit;
    }
}