<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
use AlibabaCloud\Client\AlibabaCloud;
use AlibabaCloud\Client\Exception\ClientException;
use AlibabaCloud\Client\Exception\ServerException;

/* 模块的基本信息 */
if (isset($read_modules) && $read_modules == true) {
    $module['server_url'] = 'https://aliyun.com';

    $module['class_name'] = 'ALI';
    /* 名称 */
    $module['name'] = "阿里云短信平台";

    if (ACTION_NAME == "install" || ACTION_NAME == "edit") {

        $install_info = [
            'lang' => ['模板ID', '签名'],
            'config' => [['INPUT_TYPE' => 0], ['INPUT_TYPE' => 0]]
        ];
        $module['lang'] = $install_info['lang'];
        $module['config'] = $install_info['config'];
    }
    return $module;
}


// 企信通短信平台
require_once APP_ROOT_PATH . "system/libs/sms.php";  //引入接口
require_once APP_ROOT_PATH . "system/sms/BOGO/transport.php";

class ALI_sms implements sms
{
    public $sms;
    public $message = "";

    public function __construct($smsInfo = '')
    {
        if (!empty($smsInfo)) {
            $this->sms = $smsInfo;
        }
    }

    public function sendSMS($mobile_number, $content, $sendTime = '', $is_adv = 0, $code = 0)
    {
        require_once APP_ROOT_PATH . "system/sms/aliopenapi-sdk/vendor/autoload.php";
        $sms = new transport_sms();
        if (is_array($mobile_number)) {
            $mobile_number = implode(",", $mobile_number);
        }

        $this->sms['mobile'] = $mobile_number;
        $this->sms['content'] = urlencode($content);

        if ($is_adv == 1) {
            $this->sms['is_adv'] = 1;
        } else {
            $this->sms['is_adv'] = 0;
        }

        $params = json_encode($this->sms);

        $accessKeyId = $this->sms['user_name'];
        $accessSecret = $this->sms['password'];

        if (strpos($mobile_number, '+86') !== false) {
            //国内短信
            $mobile_number = substr($mobile_number, 3);
        }

        //阿里云短信发送
        try {
            AlibabaCloud::accessKeyClient($accessKeyId, $accessSecret)
                ->regionId('cn-hangzhou')
                ->asGlobalClient();
            $result = AlibabaCloud::rpcRequest()
                ->product('Dysmsapi')
                // ->scheme('https') // https | http
                ->version('2017-05-25')
                ->action('SendSms')
                ->method('POST')
                ->options([
                    'query' => [
                        'RegionId' => 'cn-hangzhou',
                        'SignName' => "{$this->sms['config'][1]}",
                        'PhoneNumbers' => $mobile_number,
                        'TemplateCode' => $this->sms['config'][0],
                        'TemplateParam' => '{"code":"' . $code . '"}',
                    ],
                ])
                ->request();
        } catch (ClientException $e) {
            echo $e->getErrorMessage() . PHP_EOL;
        } catch (ServerException $e) {
            echo $e->getErrorMessage() . PHP_EOL;
        }
        $return_data = $result->toArray();
        $result['status'] = 0;
        if ($return_data['Code'] == 'OK') {
            $result['status'] = 1;
        }
        $result['msg'] = $return_data['Message'];
        return $result;
    }

    public function getSmsInfo()
    {

        return "阿里云短信平台";

    }

    public function check_fee()
    {
//        $sms = new transport_sms();
//
//        //$url = $this->sms['server_url'] . "get";
//        $params = json_encode($this->sms);
//
//        $url = 'http://106.ihuyi.com/webservice/sms.php?method=GetNum&account=' . $this->sms['user_name'] . '&password=' . trim($this->sms['password']) . '&format=json&time=' . time();
//
//        $result = file_get_contents($url);
//        $result = json_decode($result, 1);
//        $str = '剩余：' . $result['num'] . '条';
        $str = '暂无接口！';
        return $str;

    }
}

?>