<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------

/* 模块的基本信息 */
if (isset($read_modules) && $read_modules == true) {
    $module['server_url'] = 'http://www.bogokj.com/';

    $module['class_name'] = 'BOGO';
    /* 名称 */
    $module['name'] = "互亿无线平台";

    if (ACTION_NAME == "install" || ACTION_NAME == "edit") {
        require_once APP_ROOT_PATH . "system/sms/BOGO/transport.php";
        $tran = new transport_sms();
        $install_info = $tran->request($module['server_url'] . "data/install.php");
        $install_info = json_decode($install_info['body'], 1);

        $module['lang'] = $install_info['lang'];
        $module['config'] = $install_info['config'];
    }
    return $module;
}

// 企信通短信平台
require_once APP_ROOT_PATH . "system/libs/sms.php";  //引入接口
require_once APP_ROOT_PATH . "system/sms/BOGO/transport.php";

class BOGO_sms implements sms
{
    public $sms;
    public $message = "";

    public function __construct($smsInfo = '')
    {
        if (!empty($smsInfo)) {
            $this->sms = $smsInfo;
        }
    }

    public function sendSMS($mobile_number, $content, $sendTime = '', $is_adv = 0, $code = 0)
    {
        $sms = new transport_sms();
        if (is_array($mobile_number)) {
            $mobile_number = implode(",", $mobile_number);
        }

        $this->sms['mobile'] = $mobile_number;
        $this->sms['content'] = urlencode($content);

        if ($is_adv == 1) {
            $this->sms['is_adv'] = 1;
        } else {
            $this->sms['is_adv'] = 0;
        }

        $params = json_encode($this->sms);

        //互亿无线
        $target = "http://106.ihuyi.cn/webservice/sms.php?method=Submit";

        $post_data = "account=" . $this->sms['user_name'] . "&password=" . trim($this->sms['password']) . "&mobile=" . $mobile_number . "&content=" . rawurlencode($content);
        //密码可以使用明文密码或使用32位MD5加密
        $gets = sms_xml_to_array(sms_Post($post_data, $target));

        if ($gets['SubmitResult']['code'] == 2) {
            $result['status'] = 1;
            $result['msg'] = $gets['SubmitResult']['msg'];
        } else {
            $result['status'] = 0;
            $result['msg'] = $gets['SubmitResult']['msg'];
        }
        return $result;
    }

    public function getSmsInfo()
    {

        return "布谷短信平台";

    }

    public function check_fee()
    {
        $sms = new transport_sms();

        //$url = $this->sms['server_url'] . "get";
        $params = json_encode($this->sms);

        $url = 'http://106.ihuyi.com/webservice/sms.php?method=GetNum&account=' . $this->sms['user_name'] . '&password=' . trim($this->sms['password']) . '&format=json&time=' . time();

        $result = file_get_contents($url);
        $result = json_decode($result, 1);
        $str = '剩余：' . $result['num'] . '条';

        return $str;

    }
}

?>