<?php
// +----------------------------------------------------------------------
// | Bogo 直播系统
// +----------------------------------------------------------------------
// | Copyright (c) 2011 http://www.bogokj.com All rights reserved.
// +----------------------------------------------------------------------
// | Author: 布谷科技
// +----------------------------------------------------------------------

class ENGAGESOTP_sms
{
    var $sms;
    var $url;
    var $api_key;
    var $api_secret;
    var $template_id;

    public function __construct()
    {
        $this->url = 'https://otp.api.engagelab.cc/v1/messages';

        $sms_info = $GLOBALS['db']->getRow("select * from " . DB_PREFIX . "sms where is_effect = 1");

        if ($sms_info) {
            $sms_info['config'] = unserialize($sms_info['config']);

            $this->api_key = $sms_info['user_name'];
            $this->api_secret = $sms_info['password'];
            $this->template_id = $sms_info['config'][0];
        }
    }


    public function sendSms($mobiles, $content, $sendTime = '', $is_adv = 0, $code)
    {
        if (app_conf("SMS_ON") == 0) {
            return array(
                "status" => 0,
                "msg"    => 'The website does not turn on the SMS function.',
            );
        }

        if (!is_array($mobiles)) {
            $phone_number = preg_split("/[ ,]/i", $mobiles);
        } else {
            $phone_number = $mobiles[0];
        }

        if (substr($mobiles, 0, 1) !== '+') {
            $phone_number = '+' . $phone_number;
        }

        if (count($mobiles) > 0) {
            $url = $this->url;
            $para = array(
                'to'         => $phone_number,
                'api_key'    => $this->api_key,
                'api_secret' => $this->api_secret,
                'code'       => $code,
            );

            $result = $this->https_request($url, $para);

        } else {
            $result['status'] = 0;
            $result['msg'] = "No mobile phone number sent.";
        }

        add_file_log($result, 'engages_api', 'OTP');

        return $result;
    }

    public function https_request($url, $para)
    {

        $devKey = $para['api_key']; // 替换为您的 Dev Key
        $devSecret = $para['api_secret']; // 替换为您的 Dev Secret
        $authString = base64_encode($devKey . ':' . $devSecret);

        $data = [
            "to"       => $para['to'],
            "template" => [
                "id"       => $this->template_id,
                "language" => "en"
            ],
        ];

        $data_string = json_encode($data);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                "Authorization: Basic " . $authString,
                "Content-Type: application/json",
                "Content-Length: " . strlen($data_string))
        );

        $response = curl_exec($ch);
        curl_close($ch);

        $data_val = json_decode($response, true);

        add_file_log(['request_data' => $data, 'response_data' => $data_val], 'engages_api', 'OTP');

        $data = array();

        if (isset($data_val['code'])) {
            $data['status'] = 0;
            $data['msg'] = $data_val['message'];
            $data['message_id'] = '';
        } else {
            $data['message_id'] = $data_val['message_id'];
            $data['status'] = 1;
            $data['msg'] = 'OK';
        }

        return $data;
    }


    public function verifySms($messageId, $code)
    {
        $url = 'https://otp.api.engagelab.cc/v1/verifications';

        $devKey = $this->api_key; // 替换为您的 Dev Key
        $devSecret = $this->api_secret; // 替换为您的 Dev Secret
        $authString = base64_encode($devKey . ':' . $devSecret);

        $data = [
            "message_id"  => $messageId,
            "verify_code" => $code,
        ];

        $data_string = json_encode($data);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                "Authorization: Basic " . $authString,
                "Content-Type: application/json",
                "Content-Length: " . strlen($data_string))
        );

        $response = curl_exec($ch);
        curl_close($ch);

        $data_val = json_decode($response, true);

        //  . '-----' . json_encode($para)
        add_file_log($response, 'engages_verifications_api', 'otp');

        if (isset($data_val['code'])) {
            return ['code' => $data_val['code'], 'msg' => $data_val['message'], 'verified' => $data_val['verified']];
        } else {
            return ['code' => 200, 'msg' => '', 'verified' => $data_val['verified']];
        }
    }
}